/*
   winiodef.h

   Base definitions

   Copyright (C) 1996 Free Software Foundation, Inc.

   This file is part of the Windows32 API Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   If you are interested in a warranty or support for this source code,
   contact Scott Christley <scottc@net-community.com> for more information.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   -----------
   DAL 2003 - this file modified extensively for my compiler.  New
   definitionswnwn added as well.
*/
#define ASSERT_ALTERNATE (9)
#define ASSERT_PRIMARY (8)

#define ATAPI_ID_CMD (161)

#define CAP_ATAPI_ID_CMD (2)
#define CAP_ATA_ID_CMD (1)
#define CAP_SMART_CMD (4)

#define CHANGER_BAR_CODE_SCANNER_INSTALLED (1)
#define CHANGER_CARTRIDGE_MAGAZINE (256)
#define CHANGER_CLEANER_ACCESS_NOT_VALID (262144)
#define CHANGER_CLEANER_AUTODISMOUNT (2147483647)
#define CHANGER_CLEANER_OPS_NOT_SUPPORTED (2147483647)
#define CHANGER_CLEANER_SLOT (64)
#define CHANGER_CLOSE_IEPORT (4)
#define CHANGER_DEVICE_REINITIALIZE_CAPABLE (134217728)
#define CHANGER_DRIVE_CLEANING_REQUIRED (65536)
#define CHANGER_DRIVE_EMPTY_ON_DOOR_ACCESS (536870912)
#define CHANGER_EXCHANGE_MEDIA (32)
#define CHANGER_IEPORT_USER_CONTROL_CLOSE (2147483647)
#define CHANGER_IEPORT_USER_CONTROL_OPEN (2147483647)
#define CHANGER_INIT_ELEM_STAT_WITH_RANGE (2)
#define CHANGER_KEYPAD_ENABLE_DISABLE (268435456)
#define CHANGER_LOCK_UNLOCK (128)
#define CHANGER_MEDIUM_FLIP (512)
#define CHANGER_MOVE_EXTENDS_IEPORT (2147483647)
#define CHANGER_MOVE_RETRACTS_IEPORT (2147483647)
#define CHANGER_OPEN_IEPORT (8)
#define CHANGER_POSITION_TO_ELEMENT (1024)
#define CHANGER_PREDISMOUNT_ALIGN_TO_DRIVE (2147483647)
#define CHANGER_PREDISMOUNT_ALIGN_TO_SLOT (2147483647)
#define CHANGER_PREDISMOUNT_EJECT_REQUIRED (131072)
#define CHANGER_PREMOUNT_EJECT_REQUIRED (524288)
#define CHANGER_REPORT_IEPORT_STATE (2048)
#define CHANGER_RESERVED_BIT (2147483647)
#define CHANGER_RTN_MEDIA_TO_ORIGINAL_ADDR (2147483647)
#define CHANGER_SERIAL_NUMBER_VALID (67108864)
#define CHANGER_SLOTS_USE_TRAYS (2147483647)
#define CHANGER_STATUS_NON_VOLATILE (16)
#define CHANGER_STORAGE_DRIVE (4096)
#define CHANGER_STORAGE_IEPORT (8192)
#define CHANGER_STORAGE_SLOT (16384)
#define CHANGER_STORAGE_TRANSPORT (32768)
#define CHANGER_TO_DRIVE (8)
#define CHANGER_TO_IEPORT (4)
#define CHANGER_TO_SLOT (2)
#define CHANGER_TO_TRANSPORT (1)
#define CHANGER_TRUE_EXCHANGE_CAPABLE (2147483647)
#define CHANGER_VOLUME_ASSERT (4194304)
#define CHANGER_VOLUME_IDENTIFICATION (1048576)
#define CHANGER_VOLUME_REPLACE (8388608)
#define CHANGER_VOLUME_SEARCH (2097152)
#define CHANGER_VOLUME_UNDEFINE (16777216)

#define COMPRESSION_FORMAT_SPARSE (16384)

#define COPYFILE_SIS_FLAGS (3)
#define COPYFILE_SIS_LINK (1)
#define COPYFILE_SIS_REPLACE (2)

#define DEVICE_TYPE DWORD

#define DISABLE_SMART (217)

#define DISK_BINNING (3)
#define DISK_HISTOGRAM_SIZE sizeof(DISK_HISTOGRAM)
#define DISK_LOGGING_DUMP (2)
#define DISK_LOGGING_START (0)
#define DISK_LOGGING_STOP (1)

#define ELEMENT_STATUS_ACCESS (8)
#define ELEMENT_STATUS_AVOLTAG (536870912)
#define ELEMENT_STATUS_EXCEPT (4)
#define ELEMENT_STATUS_EXENAB (16)
#define ELEMENT_STATUS_FULL (1)
#define ELEMENT_STATUS_ID_VALID (8192)
#define ELEMENT_STATUS_IMPEXP (2)
#define ELEMENT_STATUS_INENAB (32)
#define ELEMENT_STATUS_INVERT (4194304)
#define ELEMENT_STATUS_LUN_VALID (4096)
#define ELEMENT_STATUS_NOT_BUS (32768)
#define ELEMENT_STATUS_PVOLTAG (268435456)
#define ELEMENT_STATUS_SVALID (8388608)

#define ENABLE_DISABLE_AUTOSAVE (210)
#define ENABLE_DISABLE_AUTO_OFFLINE (219)
#define ENABLE_SMART (216)

#define ENCRYPTION_FORMAT_DEFAULT (1)

#define ERROR_DRIVE_NOT_INSTALLED (8)
#define ERROR_INIT_STATUS_NEEDED (17)
#define ERROR_LABEL_QUESTIONABLE (2)
#define ERROR_LABEL_UNREADABLE (1)
#define ERROR_SLOT_NOT_PRESENT (4)
#define ERROR_TRAY_MALFUNCTION (16)
#define ERROR_UNHANDLED_ERROR (2147483647)

#define EXECUTE_OFFLINE_DIAGS (212)

#define EXTEND_IEPORT (2)

#define FILESYSTEM_STATISTICS_TYPE_FAT (2)
#define FILESYSTEM_STATISTICS_TYPE_NTFS (1)

#define FILE_ANY_ACCESS (0)
#define FILE_CLEAR_ENCRYPTION (2)
#define FILE_DEVICE_8042_PORT (39)
#define FILE_DEVICE_ACPI (50)
#define FILE_DEVICE_BATTERY (41)
#define FILE_DEVICE_BEEP (1)
#define FILE_DEVICE_BUS_EXTENDER (42)
#define FILE_DEVICE_CD_ROM (2)
#define FILE_DEVICE_CD_ROM_FILE_SYSTEM (3)
#define FILE_DEVICE_CHANGER (48)
#define FILE_DEVICE_CONTROLLER (4)
#define FILE_DEVICE_DATALINK (5)
#define FILE_DEVICE_DFS (6)
#define FILE_DEVICE_DFS_FILE_SYSTEM (53)
#define FILE_DEVICE_DFS_VOLUME (54)
#define FILE_DEVICE_DISK (7)
#define FILE_DEVICE_DISK_FILE_SYSTEM (8)
#define FILE_DEVICE_DVD (51)
#define FILE_DEVICE_FILE_SYSTEM (9)
#define FILE_DEVICE_FULLSCREEN_VIDEO (52)
#define FILE_DEVICE_INPORT_PORT (10)
#define FILE_DEVICE_KEYBOARD (11)
#define FILE_DEVICE_KS (47)
#define FILE_DEVICE_KSEC (57)
#define FILE_DEVICE_MAILSLOT (12)
#define FILE_DEVICE_MASS_STORAGE (45)
#define FILE_DEVICE_MIDI_IN (13)
#define FILE_DEVICE_MIDI_OUT (14)
#define FILE_DEVICE_MODEM (43)
#define FILE_DEVICE_MOUSE (15)
#define FILE_DEVICE_MULTI_UNC_PROVIDER (16)
#define FILE_DEVICE_NAMED_PIPE (17)
#define FILE_DEVICE_NETWORK (18)
#define FILE_DEVICE_NETWORK_BROWSER (19)
#define FILE_DEVICE_NETWORK_FILE_SYSTEM (20)
#define FILE_DEVICE_NETWORK_REDIRECTOR (40)
#define FILE_DEVICE_NULL (21)
#define FILE_DEVICE_PARALLEL_PORT (22)
#define FILE_DEVICE_PHYSICAL_NETCARD (23)
#define FILE_DEVICE_PRINTER (24)
#define FILE_DEVICE_SCANNER (25)
#define FILE_DEVICE_SCREEN (28)
#define FILE_DEVICE_SERENUM (55)
#define FILE_DEVICE_SERIAL_MOUSE_PORT (26)
#define FILE_DEVICE_SERIAL_PORT (27)
#define FILE_DEVICE_SMARTCARD (49)
#define FILE_DEVICE_SMB (46)
#define FILE_DEVICE_SOUND (29)
#define FILE_DEVICE_STREAMS (30)
#define FILE_DEVICE_TAPE (31)
#define FILE_DEVICE_TAPE_FILE_SYSTEM (32)
#define FILE_DEVICE_TERMSRV (56)
#define FILE_DEVICE_TRANSPORT (33)
#define FILE_DEVICE_UNKNOWN (34)
#define FILE_DEVICE_VDM (44)
#define FILE_DEVICE_VIDEO (35)
#define FILE_DEVICE_VIRTUAL_DISK (36)
#define FILE_DEVICE_WAVE_IN (37)
#define FILE_DEVICE_WAVE_OUT (38)
#define FILE_READ_ACCESS (1)
#define FILE_SET_ENCRYPTION (1)
#define FILE_SPECIAL_ACCESS (FILE_ANY_ACCESS)
#define FILE_WRITE_ACCESS (2)

#define FSCTL_ALLOW_EXTENDED_DASD_IO CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 32, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_CREATE_OR_GET_OBJECT_ID CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 48, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_CREATE_USN_JOURNAL CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 57, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_DELETE_OBJECT_ID CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 40, METHOD_BUFFERED, FILE_SPECIAL_ACCESS)
#define FSCTL_DELETE_REPARSE_POINT CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 43, METHOD_BUFFERED, FILE_SPECIAL_ACCESS)
#define FSCTL_DELETE_USN_JOURNAL CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 62, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_DISMOUNT_VOLUME CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 8, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_DUMP_PROPERTY_DATA CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 37, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_ENABLE_UPGRADE CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 52, METHOD_BUFFERED, FILE_WRITE_DATA)
#define FSCTL_ENCRYPTION_FSCTL_IO CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 54, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_ENUM_USN_DATA CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 44, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_EXTEND_VOLUME CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 60, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_FILESYSTEM_GET_STATISTICS CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 24, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_FIND_FILES_BY_SID CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 35, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_GET_COMPRESSION CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 15, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_GET_HFS_INFORMATION CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 31, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_GET_NTFS_FILE_RECORD CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 26, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_GET_NTFS_VOLUME_DATA CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 25, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_GET_OBJECT_ID CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 39, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_GET_REPARSE_POINT CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 42, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_GET_RETRIEVAL_POINTERS CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 28, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_GET_VOLUME_BITMAP CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 27, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_HSM_DATA (CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 68, METHOD_NEITHER, FILE_READ_DATA | FILE_WRITE_DATA))
#define FSCTL_HSM_MSG (CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 66, METHOD_BUFFERED, FILE_READ_DATA | FILE_WRITE_DATA))
#define FSCTL_INVALIDATE_VOLUMES CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 21, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_IS_PATHNAME_VALID CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 11, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_IS_VOLUME_DIRTY CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 30, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_IS_VOLUME_MOUNTED CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 10, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_LOCK_VOLUME CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 6, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_MARK_AS_SYSTEM_HIVE CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 19, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_MARK_HANDLE CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 63, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_MARK_VOLUME_DIRTY CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 12, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_MOVE_FILE CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 29, METHOD_BUFFERED, FILE_SPECIAL_ACCESS)
#define FSCTL_NSS_CONTROL CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 67, METHOD_BUFFERED, FILE_WRITE_DATA)
#define FSCTL_NSS_RCONTROL CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 70, METHOD_BUFFERED, FILE_READ_DATA)
#define FSCTL_OPBATCH_ACK_CLOSE_PENDING CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 4, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_OPLOCK_BREAK_ACKNOWLEDGE CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 3, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_OPLOCK_BREAK_ACK_NO_2 CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 20, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_OPLOCK_BREAK_NOTIFY CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 5, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_QUERY_ALLOCATED_RANGES CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 51, METHOD_NEITHER, FILE_READ_DATA)
#define FSCTL_QUERY_FAT_BPB CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 22, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_QUERY_RETRIEVAL_POINTERS CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 14, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_QUERY_USN_JOURNAL CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 61, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_READ_FILE_USN_DATA CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 58, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_READ_PROPERTY_DATA CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 33, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_READ_RAW_ENCRYPTED CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 56, METHOD_NEITHER, FILE_SPECIAL_ACCESS)
#define FSCTL_READ_USN_JOURNAL CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 46, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_RECALL_FILE CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 69, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_REQUEST_BATCH_OPLOCK CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 2, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_REQUEST_FILTER_OPLOCK CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 23, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_REQUEST_OPLOCK_LEVEL_1 CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 0, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_REQUEST_OPLOCK_LEVEL_2 CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 1, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_SECURITY_ID_CHECK CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 45, METHOD_NEITHER, FILE_READ_DATA)
#define FSCTL_SET_COMPRESSION (CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 16, METHOD_BUFFERED, FILE_READ_DATA | FILE_WRITE_DATA))
#define FSCTL_SET_ENCRYPTION CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 53, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_SET_OBJECT_ID CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 38, METHOD_BUFFERED, FILE_SPECIAL_ACCESS)
#define FSCTL_SET_OBJECT_ID_EXTENDED CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 47, METHOD_BUFFERED, FILE_SPECIAL_ACCESS)
#define FSCTL_SET_REPARSE_POINT CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 41, METHOD_BUFFERED, FILE_SPECIAL_ACCESS)
#define FSCTL_SET_SPARSE CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 49, METHOD_BUFFERED, FILE_SPECIAL_ACCESS)
#define FSCTL_SET_ZERO_DATA CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 50, METHOD_BUFFERED, FILE_WRITE_DATA)
#define FSCTL_SIS_COPYFILE CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 64, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_SIS_LINK_FILES (CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 65, METHOD_BUFFERED, FILE_READ_DATA | FILE_WRITE_DATA))
#define FSCTL_UNLOCK_VOLUME CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 7, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_WRITE_PROPERTY_DATA CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 34, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_WRITE_RAW_ENCRYPTED CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 55, METHOD_NEITHER, FILE_SPECIAL_ACCESS)
#define FSCTL_WRITE_USN_CLOSE_RECORD CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 59, METHOD_NEITHER, FILE_ANY_ACCESS)

#define HISTOGRAM_BUCKET_SIZE sizeof(HISTOGRAM_BUCKET)

#define HIST_NO_OF_BUCKETS (24)

#define IDENTIFY_BUFFER_SIZE (512)

#define ID_CMD (236)

#define IOCTL_CHANGER_BASE FILE_DEVICE_CHANGER
#define IOCTL_CHANGER_EXCHANGE_MEDIUM CTL_CODE(IOCTL_CHANGER_BASE, 8, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_CHANGER_GET_ELEMENT_STATUS (CTL_CODE(IOCTL_CHANGER_BASE, 5, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS))
#define IOCTL_CHANGER_GET_PARAMETERS CTL_CODE(IOCTL_CHANGER_BASE, 0, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_CHANGER_GET_PRODUCT_DATA CTL_CODE(IOCTL_CHANGER_BASE, 2, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_CHANGER_GET_STATUS CTL_CODE(IOCTL_CHANGER_BASE, 1, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_CHANGER_INITIALIZE_ELEMENT_STATUS CTL_CODE(IOCTL_CHANGER_BASE, 6, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_CHANGER_MOVE_MEDIUM CTL_CODE(IOCTL_CHANGER_BASE, 9, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_CHANGER_QUERY_VOLUME_TAGS (CTL_CODE(IOCTL_CHANGER_BASE, 11, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS))
#define IOCTL_CHANGER_REINITIALIZE_TRANSPORT CTL_CODE(IOCTL_CHANGER_BASE, 10, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_CHANGER_SET_ACCESS (CTL_CODE(IOCTL_CHANGER_BASE, 4, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS))
#define IOCTL_CHANGER_SET_POSITION CTL_CODE(IOCTL_CHANGER_BASE, 7, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_DISK_BASE FILE_DEVICE_DISK
#define IOCTL_DISK_CHECK_VERIFY CTL_CODE(IOCTL_DISK_BASE, 512, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_DISK_CONTROLLER_NUMBER CTL_CODE(IOCTL_DISK_BASE, 17, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_DELETE_DRIVE_LAYOUT (CTL_CODE(IOCTL_DISK_BASE, 64, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS))
#define IOCTL_DISK_EJECT_MEDIA CTL_CODE(IOCTL_DISK_BASE, 514, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_DISK_FIND_NEW_DEVICES CTL_CODE(IOCTL_DISK_BASE, 518, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_DISK_FORMAT_DRIVE (CTL_CODE(IOCTL_DISK_BASE, 243, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS))
#define IOCTL_DISK_FORMAT_TRACKS (CTL_CODE(IOCTL_DISK_BASE, 6, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS))
#define IOCTL_DISK_FORMAT_TRACKS_EX (CTL_CODE(IOCTL_DISK_BASE, 11, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS))
#define IOCTL_DISK_GET_CACHE_INFORMATION CTL_CODE(IOCTL_DISK_BASE, 53, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_DISK_GET_DRIVE_GEOMETRY CTL_CODE(IOCTL_DISK_BASE, 0, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_GET_DRIVE_LAYOUT CTL_CODE(IOCTL_DISK_BASE, 3, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_DISK_GET_MEDIA_TYPES CTL_CODE(IOCTL_DISK_BASE, 768, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_GET_PARTITION_INFO CTL_CODE(IOCTL_DISK_BASE, 1, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_DISK_GROW_PARTITION (CTL_CODE(IOCTL_DISK_BASE, 52, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS))
#define IOCTL_DISK_HISTOGRAM_DATA CTL_CODE(IOCTL_DISK_BASE, 13, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_HISTOGRAM_RESET CTL_CODE(IOCTL_DISK_BASE, 14, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_HISTOGRAM_STRUCTURE CTL_CODE(IOCTL_DISK_BASE, 12, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_IS_WRITABLE CTL_CODE(IOCTL_DISK_BASE, 9, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_LOAD_MEDIA CTL_CODE(IOCTL_DISK_BASE, 515, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_DISK_LOGGING CTL_CODE(IOCTL_DISK_BASE, 10, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_MEDIA_REMOVAL CTL_CODE(IOCTL_DISK_BASE, 513, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_DISK_PERFORMANCE CTL_CODE(IOCTL_DISK_BASE, 8, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_REASSIGN_BLOCKS (CTL_CODE(IOCTL_DISK_BASE, 7, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS))
#define IOCTL_DISK_RELEASE CTL_CODE(IOCTL_DISK_BASE, 517, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_DISK_REQUEST_DATA CTL_CODE(IOCTL_DISK_BASE, 16, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_REQUEST_STRUCTURE CTL_CODE(IOCTL_DISK_BASE, 15, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_RESERVE CTL_CODE(IOCTL_DISK_BASE, 516, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_DISK_SENSE_DEVICE CTL_CODE(IOCTL_DISK_BASE, 248, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_SET_CACHE_INFORMATION (CTL_CODE(IOCTL_DISK_BASE, 54, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS))
#define IOCTL_DISK_SET_DRIVE_LAYOUT (CTL_CODE(IOCTL_DISK_BASE, 4, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS))
#define IOCTL_DISK_SET_PARTITION_INFO (CTL_CODE(IOCTL_DISK_BASE, 2, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS))
#define IOCTL_DISK_UPDATE_DRIVE_SIZE (CTL_CODE(IOCTL_DISK_BASE, 50, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS))
#define IOCTL_DISK_VERIFY CTL_CODE(IOCTL_DISK_BASE, 5, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_SERENUM_EXPOSE_HARDWARE CTL_CODE(FILE_DEVICE_SERENUM, 128, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_SERENUM_GET_PORT_NAME CTL_CODE(FILE_DEVICE_SERENUM, 131, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_SERENUM_PORT_DESC CTL_CODE(FILE_DEVICE_SERENUM, 130, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_SERENUM_REMOVE_HARDWARE CTL_CODE(FILE_DEVICE_SERENUM, 129, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_SERIAL_LSRMST_INSERT CTL_CODE(FILE_DEVICE_SERIAL_PORT, 31, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_BASE FILE_DEVICE_MASS_STORAGE
#define IOCTL_STORAGE_CHECK_VERIFY CTL_CODE(IOCTL_STORAGE_BASE, 512, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_STORAGE_CHECK_VERIFY2 CTL_CODE(IOCTL_STORAGE_BASE, 512, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_EJECTION_CONTROL CTL_CODE(IOCTL_STORAGE_BASE, 592, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_EJECT_MEDIA CTL_CODE(IOCTL_STORAGE_BASE, 514, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_STORAGE_FIND_NEW_DEVICES CTL_CODE(IOCTL_STORAGE_BASE, 518, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_STORAGE_GET_DEVICE_NUMBER CTL_CODE(IOCTL_STORAGE_BASE, 1056, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_GET_MEDIA_TYPES CTL_CODE(IOCTL_STORAGE_BASE, 768, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_GET_MEDIA_TYPES_EX CTL_CODE(IOCTL_STORAGE_BASE, 769, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_LOAD_MEDIA CTL_CODE(IOCTL_STORAGE_BASE, 515, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_STORAGE_LOAD_MEDIA2 CTL_CODE(IOCTL_STORAGE_BASE, 515, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_MCN_CONTROL CTL_CODE(IOCTL_STORAGE_BASE, 593, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_MEDIA_REMOVAL CTL_CODE(IOCTL_STORAGE_BASE, 513, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_STORAGE_PREDICT_FAILURE CTL_CODE(IOCTL_STORAGE_BASE, 1088, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_RELEASE CTL_CODE(IOCTL_STORAGE_BASE, 517, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_STORAGE_RESERVE CTL_CODE(IOCTL_STORAGE_BASE, 516, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_STORAGE_RESET_BUS CTL_CODE(IOCTL_STORAGE_BASE, 1024, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_STORAGE_RESET_DEVICE CTL_CODE(IOCTL_STORAGE_BASE, 1025, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_VOLUME_BASE ((DWORD)'V')
#define IOCTL_VOLUME_GET_VOLUME_DISK_EXTENTS CTL_CODE(IOCTL_VOLUME_BASE, 0, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define LOCK_ELEMENT (0)
#define LOCK_UNLOCK_DOOR (2)
#define LOCK_UNLOCK_IEPORT (1)
#define LOCK_UNLOCK_KEYPAD (4)

#define MAXIMUM_ENCRYPTION_VALUE (4)

#define MAX_VOLUME_ID_SIZE (36)
#define MAX_VOLUME_TEMPLATE_SIZE (40)

#define MEDIA_CURRENTLY_MOUNTED (2147483647)
#define MEDIA_ERASEABLE (1)
#define MEDIA_READ_ONLY (4)
#define MEDIA_READ_WRITE (8)
#define MEDIA_WRITE_ONCE (2)
#define MEDIA_WRITE_PROTECTED (256)

#define METHOD_BUFFERED (0)
#define METHOD_IN_DIRECT (1)
#define METHOD_NEITHER (3)
#define METHOD_OUT_DIRECT (2)

#define NSS_CONTROL_ISNSSFILE (4)
#define NSS_CONTROL_MARK (1)
#define NSS_CONTROL_UNMARK (2)

#define OBSOLETE_IOCTL_STORAGE_RESET_BUS (CTL_CODE(IOCTL_STORAGE_BASE, 1024, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS))
#define OBSOLETE_IOCTL_STORAGE_RESET_DEVICE \
    (CTL_CODE(IOCTL_STORAGE_BASE, 1025, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS))

#define PARTITION_ENTRY_UNUSED (0)
#define PARTITION_EXTENDED (5)
#define PARTITION_FAT32 (11)
#define PARTITION_FAT32_XINT13 (12)
#define PARTITION_FAT_12 (1)
#define PARTITION_FAT_16 (4)
#define PARTITION_HUGE (6)
#define PARTITION_IFS (7)
#define PARTITION_LDM (66)
#define PARTITION_NTFT (128)
#define PARTITION_PREP (65)
#define PARTITION_UNIX (99)
#define PARTITION_XENIX_1 (2)
#define PARTITION_XENIX_2 (3)
#define PARTITION_XINT13 (14)
#define PARTITION_XINT13_EXTENDED (15)

#define PRODUCT_ID_LENGTH (16)

#define READ_ATTRIBUTES (208)
#define READ_ATTRIBUTE_BUFFER_SIZE (512)
#define READ_COMPRESSION_INFO_VALID (32)
#define READ_THRESHOLDS (209)
#define READ_THRESHOLD_BUFFER_SIZE (512)

#define RECOVERED_READS_VALID (4)
#define RECOVERED_WRITES_VALID (1)

#define REPLACE_ALTERNATE (11)
#define REPLACE_PRIMARY (10)

#define RETRACT_IEPORT (3)

#define RETURN_SMART_STATUS (218)

#define REVISION_LENGTH (4)

#define SAVE_ATTRIBUTE_VALUES (211)

#define SEARCH_ALL (0)
#define SEARCH_ALL_NO_SEQ (4)
#define SEARCH_ALTERNATE (2)
#define SEARCH_ALT_NO_SEQ (6)
#define SEARCH_PRIMARY (1)
#define SEARCH_PRI_NO_SEQ (5)

#define SERIAL_IOC_FCR_DMA_MODE ((DWORD)8)
#define SERIAL_IOC_FCR_FIFO_ENABLE ((DWORD)1)
#define SERIAL_IOC_FCR_RCVR_RESET ((DWORD)2)
#define SERIAL_IOC_FCR_RCVR_TRIGGER_LSB ((DWORD)64)
#define SERIAL_IOC_FCR_RCVR_TRIGGER_MSB ((DWORD)128)
#define SERIAL_IOC_FCR_RES1 ((DWORD)16)
#define SERIAL_IOC_FCR_RES2 ((DWORD)32)
#define SERIAL_IOC_FCR_XMIT_RESET ((DWORD)4)
#define SERIAL_IOC_MCR_DTR ((DWORD)1)
#define SERIAL_IOC_MCR_LOOP ((DWORD)16)
#define SERIAL_IOC_MCR_OUT1 ((DWORD)4)
#define SERIAL_IOC_MCR_OUT2 ((DWORD)8)
#define SERIAL_IOC_MCR_RTS ((DWORD)2)
#define SERIAL_LSRMST_ESCAPE ((BYTE)0)
#define SERIAL_LSRMST_LSR_DATA ((BYTE)1)
#define SERIAL_LSRMST_LSR_NODATA ((BYTE)2)
#define SERIAL_LSRMST_MST ((BYTE)3)
#define SERIAL_NUMBER_LENGTH (32)

#define SMART_CMD (176)
#define SMART_CYL_HI (194)
#define SMART_CYL_LOW (79)
#define SMART_ERROR_NO_MEM (7)
#define SMART_GET_VERSION CTL_CODE(IOCTL_DISK_BASE, 32, METHOD_BUFFERED, FILE_READ_ACCESS)
#define SMART_IDE_ERROR (1)
#define SMART_INVALID_BUFFER (4)
#define SMART_INVALID_COMMAND (3)
#define SMART_INVALID_DRIVE (5)
#define SMART_INVALID_FLAG (2)
#define SMART_INVALID_IOCTL (6)
#define SMART_INVALID_REGISTER (8)
#define SMART_NOT_SUPPORTED (9)
#define SMART_NO_ERROR (0)
#define SMART_NO_IDE_DEVICE (10)
#define SMART_RCV_DRIVE_DATA (CTL_CODE(IOCTL_DISK_BASE, 34, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS))
#define SMART_SEND_DRIVE_COMMAND (CTL_CODE(IOCTL_DISK_BASE, 33, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS))

#define STREAM_CLEAR_ENCRYPTION (4)
#define STREAM_SET_ENCRYPTION (3)

#define TAPE_RESET_STATISTICS (2)
#define TAPE_RETURN_ENV_INFO (1)
#define TAPE_RETURN_STATISTICS (0)

#define UNDEFINE_ALTERNATE (13)
#define UNDEFINE_PRIMARY (12)

#define UNLOCK_ELEMENT (1)

#define UNRECOVERED_READS_VALID (8)
#define UNRECOVERED_WRITES_VALID (2)

#define USN_DELETE_FLAG_DELETE (1)
#define USN_DELETE_FLAG_NOTIFY (2)
#define USN_DELETE_VALID_FLAGS (3)
#define USN_PAGE_SIZE (4096)
#define USN_REASON_BASIC_INFO_CHANGE (32768)
#define USN_REASON_CLOSE (2147483647)
#define USN_REASON_COMPRESSION_CHANGE (131072)
#define USN_REASON_DATA_EXTEND (2)
#define USN_REASON_DATA_OVERWRITE (1)
#define USN_REASON_DATA_TRUNCATION (4)
#define USN_REASON_EA_CHANGE (1024)
#define USN_REASON_ENCRYPTION_CHANGE (262144)
#define USN_REASON_FILE_CREATE (256)
#define USN_REASON_FILE_DELETE (512)
#define USN_REASON_HARD_LINK_CHANGE (65536)
#define USN_REASON_INDEXABLE_CHANGE (16384)
#define USN_REASON_NAMED_DATA_EXTEND (32)
#define USN_REASON_NAMED_DATA_OVERWRITE (16)
#define USN_REASON_NAMED_DATA_TRUNCATION (64)
#define USN_REASON_OBJECT_ID_CHANGE (524288)
#define USN_REASON_RENAME_NEW_NAME (8192)
#define USN_REASON_RENAME_OLD_NAME (4096)
#define USN_REASON_REPARSE_POINT_CHANGE (1048576)
#define USN_REASON_SECURITY_CHANGE (2048)
#define USN_REASON_STREAM_CHANGE (2097152)
#define USN_SOURCE_AUXILIARY_DATA (2)
#define USN_SOURCE_DATA_MANAGEMENT (1)
#define USN_SOURCE_REPLICATION_MANAGEMENT (4)

#define VALID_NTFT (192)

#define VENDOR_ID_LENGTH (8)

#define VOLUME_IS_DIRTY (1)
#define VOLUME_UPGRADE_SCHEDULED (2)

#define WMI_DISK_GEOMETRY_GUID                                      \
    {                                                               \
        620789585, 22466, 4561, { 165, 40, 0, 160, 201, 6, 41, 16 } \
    }

#define WRITE_COMPRESSION_INFO_VALID (16)
