/*
  RUNTIME - A program that sets a timer, then runs another program, and then
  prints the run time of that program.  It's very short.  :)

  Copyright (C) 2000,2002 Jim Hall <jhall@freedos.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>

#include <dos.h>			/* clock() */
#include <time.h>			/* clock() */
#include <process.h>			/* exec() */

#include <locale.h>			/* setlocale() */
#include "catgets.h"			/* catopen/catgets */

/* Functions */

void help (nl_catd cat);

/* Program starts here */

int
main (int argc, char **argv)
{
  char *fmt;
  int i;
  nl_catd cat;
  clock_t begin, end;

  /* Open the message catalog */

  cat = catopen ("runtime", 0);

  /* Note that Borland setlocale() only supports the C locale, so this
     doesn't really do anything.  Otherwise, "" means use LANG env var */

  setlocale (LC_NUMERIC, "");

  /* Check command line */

  if (argc == 1)
    {
      help(cat);
      catclose (cat);
      exit (1);
    }

  if (argv[1][0] == '/')
    {
      help(cat);
      catclose (cat);
      exit (1);
    }

  /* Shift argv, and terminate with NULL */

  for (i = 1; i < argc;  i++)
    {
      argv[i-1] = argv[i];
    }

  argc--;
  argv[argc] = NULL;

  /* Start the timer, run it, then stop the timer */

  begin = clock();
  spawnvp (P_WAIT, argv[0], argv);
  end = clock();

  /* Print results and quit */

  fmt = catgets (cat, 1, 0, "Run time was %f seconds");
  printf (fmt, (end - begin) / CLK_TCK);
  printf ("\n");

  /* Done */

  catclose (cat);
  exit (0);
}

void
help (nl_catd cat)
{
  char *s;

  /* print the help message, and return */

  /* we don't print the copyright information in another language
     because of a legal requirement - or so I infer from the GNU GPL */

  fprintf (stderr, "RUNTIME 2.1 (GNU GPL - see the file COPYING)\n");
  fprintf (stderr, "Copyright (C) 2000,2002 Jim Hall <jhall@freedos.org>\n\n");

  s = catgets (cat, 0, 0, "Determine the run time for a program");
  fprintf (stderr, "RUNTIME - %s\n", s);

  s = catgets (cat, 0, 1, "Usage");
  fprintf (stderr, "%s:\n", s);

  s = catgets (cat, 2, 0, "program");
  fprintf (stderr, "  RUNTIME { %s } [ ... ]\n", s);
}
