/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGIOES.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgOpenEnumSection(const Cfg_secEnumData * const keyinfo)

	Open a section, previously enumerated by cfgEnumSections().

	If the Enum() function searched in one INI file only, the opened
	section will only access this file.

	Return: cfg error code

ob(ject): cfgOpenEnumSection
su(bsystem): inifile/3
sh(ort description): Open a section enumerated by cfgEnumSections()
lo(ng description): Open a section that has been enumerated by cfgEnumSections().
	If the cfgEnumSections() function searched in one file only, the opened
	section will include only the part within that one file.
re(lated to): 
fi(le): cfgioes.c
in(itialized by): cfgInitINI cfgEnumSections

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"
#include "supplio.h"
#include "dynstr.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGIOES.C 1.5 2001/02/27 01:27:45 ska Exp ska $";
#endif

int cfgOpenEnumSection(const Cfg_secEnumData * const keyinfo)
{	inifstru *f, *o;
	char *secnam;

	DBG_ENTER("cfgOpenEnumSection", Suppl_inifile3)

	assert(keyinfo);

	chkHeap
	if(keyinfo->cfgi___mods != I(modifications))
		DBG_RETURN_I( CFG_ERR_INICHG)

	if(keyinfo->cfgi_keyname) {
		if(!StrCpy(I(key), keyinfo->cfgi_keyname))
			DBG_RETURN_I( CFG_ERR_MEM)
	} else
		StrFree(I(key));
	chkHeap

	if(keyinfo->cfgi_location) {
		f = aS(usrini);
		o = aS(sysini);
	} else {
		f = aS(sysini);
		o = aS(usrini);
	}

	assert(f->cfgi_fp);

	f->cfgi_avail = 1;
	o->cfgi_avail = 0;
	chkHeap

	Fposcpy(aS(f->cfgi_keypos), aS(keyinfo->cfgi___kpos));
	Fposcpy(aS(f->cfgi_pos), aS(keyinfo->cfgi___vpos));
	if(FFsetpos(f->cfgi_fp, f->cfgi_pos))	/* seek to first value */
		DBG_RETURN_I( CFG_ERR_ACC)
	chkHeap

	if(keyinfo->cfgi___mode == CFG_FSTD) {	/* update the other INI file */
		secnam = I(key);
		I(key) = 0;
		cfgi_opSec(secnam, 0);
	}
	chkHeap

	DBG_RETURN_I( CFG_ERR_NONE)
}
