/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: FSTPCPY.C $
   $Locker: ska $	$Name:  $	$State: Exp $

ob(ject): _fstpcpy
su(bsystem): farmem
ty(pe): 
sy(nopsis): 
sh(ort description): Copies a string
lo: Copy the source string onto the destination memory area
	and returns the address of the end of the string.
he(ader files): 
pr(erequistes): pointers must not be equal to \tok{NULL}
va(lue): pointer to end of string
re(lated to): stpcpy _fstrcpy
se(condary subsystems): portable
xr(ef): 
im(port): 
fi(le): 
in(itialized by): 
wa(rning): 
bu(gs): 
co(mpilers):

*/

#include "initsupl.loc"

#ifdef _MICROC_
#include <portable.h>

unsigned _fstpcpy(unsigned const dseg, unsigned dofs
 , unsigned const sseg, unsigned sofs)
{
	while((peekb(dseg, dofs++) = peekb(sseg, sofs++)) != 0);

	return dofs - 1;
}

#else

#include <portable.h>
#include "fmemory.h"

char far *_fstpcpy(char far * const dst, const char far * const src)
{	char far *p;
	const char far *q;

	p = dst - 1;
	q = src - 1;
	while((*++p = *++q) != 0);
	return p;
}
#endif
