/* amd64-darwin.macho-entry.h
   created from amd64-darwin.macho-entry.bin, 9467 (0x24fb) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2017 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2017 Laszlo Molnar
   Copyright (C) 2000-2017 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_AMD64_DARWIN_MACHO_ENTRY_SIZE    9467
#define STUB_AMD64_DARWIN_MACHO_ENTRY_ADLER32 0x77b69279
#define STUB_AMD64_DARWIN_MACHO_ENTRY_CRC32   0x1e1a6ac8

unsigned char stub_amd64_darwin_macho_entry[9467] = {
/* 0x0000 */ 127, 69, 76, 70,  2,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 62,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0, 88, 24,  0,  0,  0,  0,  0,  0,
/* 0x0030 */   0,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0, 23,  0, 20,  0,
/* 0x0040 */  82,  0,131,249, 73,117, 74, 72,137,241, 72,137,254,235, 44,138,
/* 0x0050 */   7, 72,131,199,  1, 60,128,114, 10, 60,143,119,  6,128,127,254,
/* 0x0060 */  15,116,  6, 44,232, 60,  1,119, 35, 56, 23,117, 31,139,  7, 37,
/* 0x0070 */   0,255,255,255, 15,200, 41,248,  1,240,171, 72,131,233,  4,138,
/* 0x0080 */   7, 72,131,199,  1, 72,255,201,117,217,235,  5, 72,255,201,117,
/* 0x0090 */ 190,195,232,  0,  0,  0,  0, 85, 83, 81, 82, 72,  1,254, 86, 72,
/* 0x00a0 */ 137,254, 72,137,215, 49,219, 49,201, 72,131,205,255,232, 81,  0,
/* 0x00b0 */   0,  0,  1,219,116,  2,243,195,139, 30, 72,131,238,252, 17,219,
/* 0x00c0 */ 138, 22,243,195, 72,141,  4, 47,131,249,  5,138, 16,118, 33, 72,
/* 0x00d0 */ 131,253,252,119, 27,131,233,  4,139, 16, 72,131,192,  4,131,233,
/* 0x00e0 */   4,137, 23, 72,141,127,  4,115,239,131,193,  4,138, 16,116, 17,
/* 0x00f0 */  72,131,192,  1,136, 23,131,233,  1,138, 16, 72,141,127,  1,117,
/* 0x0100 */ 239,243,195,252, 65, 91, 65,128,248,  8,116, 13,233,172,  0,  0,
/* 0x0110 */   0, 72,255,198,136, 23, 72,255,199,138, 22,  1,219,117, 10,139,
/* 0x0120 */  30, 72,131,238,252, 17,219,138, 22,114,230,141, 65,  1,235,  7,
/* 0x0130 */ 255,200, 65,255,211, 17,192, 65,255,211, 17,192,  1,219,117, 10,
/* 0x0140 */ 139, 30, 72,131,238,252, 17,219,138, 22,115,228,131,232,  3,114,
/* 0x0150 */  29,193,224,  8, 15,182,210,  9,208, 72,255,198,131,240,255, 15,
/* 0x0160 */ 132,  0,  0,  0,  0,209,248, 72, 99,232,114, 56,235, 14,  1,219,
/* 0x0170 */ 117,  8,139, 30, 72,131,238,252, 17,219,114, 40,255,193,  1,219,
/* 0x0180 */ 117,  8,139, 30, 72,131,238,252, 17,219,114, 24, 65,255,211, 17,
/* 0x0190 */ 201,  1,219,117,  8,139, 30, 72,131,238,252, 17,219,115,237,131,
/* 0x01a0 */ 193,  2,235,  5, 65,255,211, 17,201, 72,129,253,  0,251,255,255,
/* 0x01b0 */ 131,209,  2,232,  0,  0,  0,  0,233, 92,255,255,255, 65,128,248,
/* 0x01c0 */   5,116, 13,233,147,  0,  0,  0, 72,255,198,136, 23, 72,255,199,
/* 0x01d0 */ 138, 22,  1,219,117, 10,139, 30, 72,131,238,252, 17,219,138, 22,
/* 0x01e0 */ 114,230,141, 65,  1,235,  7,255,200, 65,255,211, 17,192, 65,255,
/* 0x01f0 */ 211, 17,192,  1,219,117, 10,139, 30, 72,131,238,252, 17,219,138,
/* 0x0200 */  22,115,228,131,232,  3,114, 27,193,224,  8, 15,182,210,  9,208,
/* 0x0210 */  72,255,198,131,240,255, 15,132,  0,  0,  0,  0,209,248, 72, 99,
/* 0x0220 */ 232,235,  3, 65,255,211, 17,201, 65,255,211, 17,201,117, 24,255,
/* 0x0230 */ 193, 65,255,211, 17,201,  1,219,117,  8,139, 30, 72,131,238,252,
/* 0x0240 */  17,219,115,237,131,193,  2, 72,129,253,  0,251,255,255,131,209,
/* 0x0250 */   1,232,  0,  0,  0,  0,233,117,255,255,255, 65,128,248,  2,116,
/* 0x0260 */  13,233,133,  0,  0,  0, 72,255,198,136, 23, 72,255,199,138, 22,
/* 0x0270 */   1,219,117, 10,139, 30, 72,131,238,252, 17,219,138, 22,114,230,
/* 0x0280 */ 141, 65,  1, 65,255,211, 17,192,  1,219,117, 10,139, 30, 72,131,
/* 0x0290 */ 238,252, 17,219,138, 22,115,235,131,232,  3,114, 23,193,224,  8,
/* 0x02a0 */  15,182,210,  9,208, 72,255,198,131,240,255, 15,132,  0,  0,  0,
/* 0x02b0 */   0, 72, 99,232,141, 65,  1, 65,255,211, 17,201, 65,255,211, 17,
/* 0x02c0 */ 201,117, 24,137,193,131,192,  2, 65,255,211, 17,201,  1,219,117,
/* 0x02d0 */   8,139, 30, 72,131,238,252, 17,219,115,237, 72,129,253,  0,243,
/* 0x02e0 */ 255,255, 17,193,232,  0,  0,  0,  0,235,131, 65,128,248, 14, 15,
/* 0x02f0 */ 133,  0,  0,  0,  0, 85, 72,137,229, 68,139,  9, 73,137,208, 72,
/* 0x0300 */ 137,242, 72,141,119,  2, 86,138,  7,255,202,136,193, 36,  7,192,
/* 0x0310 */ 233,  3, 72,199,195,  0,253,255,255, 72,211,227,136,193, 72,141,
/* 0x0320 */ 156, 92,136,241,255,255, 72,131,227,192,106,  0, 72, 57,220,117,
/* 0x0330 */ 249, 83, 72,141,123,  8,138, 78,255,255,202,136, 71,  2,136,200,
/* 0x0340 */ 192,233,  4,136, 79,  1, 36, 15,136,  7, 72,141, 79,252, 80, 65,
/* 0x0350 */  87, 72,141, 71,  4, 69, 49,255, 65, 86, 65,190,  1,  0,  0,  0,
/* 0x0360 */  65, 85, 69, 49,237, 65, 84, 85, 83, 72,137, 76, 36,240, 72,137,
/* 0x0370 */  68, 36,216,184,  1,  0,  0,  0, 72,137,116, 36,248, 76,137, 68,
/* 0x0380 */  36,232,137,195, 68,137, 76, 36,228, 15,182, 79,  2,211,227,137,
/* 0x0390 */ 217, 72,139, 92, 36, 56,255,201,137, 76, 36,212, 15,182, 79,  1,
/* 0x03a0 */ 211,224, 72,139, 76, 36,240,255,200,137, 68, 36,208, 15,182,  7,
/* 0x03b0 */ 199,  1,  0,  0,  0,  0,199, 68, 36,200,  0,  0,  0,  0,199, 68,
/* 0x03c0 */  36,196,  1,  0,  0,  0,199, 68, 36,192,  1,  0,  0,  0,199, 68,
/* 0x03d0 */  36,188,  1,  0,  0,  0,199,  3,  0,  0,  0,  0,137, 68, 36,204,
/* 0x03e0 */  15,182, 79,  1,  1,193,184,  0,  3,  0,  0,211,224, 49,201,141,
/* 0x03f0 */ 184, 54,  7,  0,  0, 65, 57,255,115, 19, 72,139, 92, 36,216,137,
/* 0x0400 */ 200,255,193, 57,249,102,199,  4, 67,  0,  4,235,235, 72,139,124,
/* 0x0410 */  36,248,137,208, 69, 49,210, 65,131,203,255, 49,210, 73,137,252,
/* 0x0420 */  73,  1,196, 76, 57,231, 15,132,239,  8,  0,  0, 15,182,  7, 65,
/* 0x0430 */ 193,226,  8,255,194, 72,255,199, 65,  9,194,131,250,  4,126,227,
/* 0x0440 */  68, 59,124, 36,228, 15,131,218,  8,  0,  0,139, 68, 36,212, 72,
/* 0x0450 */  99, 92, 36,200, 72,139, 84, 36,216, 68, 33,248,137, 68, 36,184,
/* 0x0460 */  72, 99,108, 36,184, 72,137,216, 72,193,224,  4, 72,  1,232, 65,
/* 0x0470 */ 129,251,255,255,255,  0, 76,141, 12, 66,119, 26, 76, 57,231, 15,
/* 0x0480 */ 132,150,  8,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8,
/* 0x0490 */  72,255,199, 65,  9,194, 65, 15,183, 17, 68,137,216,193,232, 11,
/* 0x04a0 */  15,183,202, 15,175,193, 65, 57,194, 15,131,197,  1,  0,  0, 65,
/* 0x04b0 */ 137,195,184,  0,  8,  0,  0, 72,139, 92, 36,216, 41,200, 15,182,
/* 0x04c0 */  76, 36,204,190,  1,  0,  0,  0,193,248,  5,141,  4,  2, 65, 15,
/* 0x04d0 */ 182,213,102, 65,137,  1,139, 68, 36,208, 68, 33,248,211,224,185,
/* 0x04e0 */   8,  0,  0,  0, 43, 76, 36,204,211,250,  1,208,105,192,  0,  3,
/* 0x04f0 */   0,  0,131,124, 36,200,  6,137,192, 76,141,140, 67,108, 14,  0,
/* 0x0500 */   0, 15,142,184,  0,  0,  0, 72,139, 84, 36,232, 68,137,248, 68,
/* 0x0510 */  41,240, 15,182, 44,  2,  1,237, 72, 99,214,137,235,129,227,  0,
/* 0x0520 */   1,  0,  0, 65,129,251,255,255,255,  0, 72, 99,195, 73,141,  4,
/* 0x0530 */  65, 76,141,  4, 80,119, 26, 76, 57,231, 15,132,219,  7,  0,  0,
/* 0x0540 */  15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,
/* 0x0550 */ 194, 65, 15,183,144,  0,  2,  0,  0, 68,137,216,193,232, 11, 15,
/* 0x0560 */ 183,202, 15,175,193, 65, 57,194,115, 32, 65,137,195,184,  0,  8,
/* 0x0570 */   0,  0,  1,246, 41,200,193,248,  5,133,219,141,  4,  2,102, 65,
/* 0x0580 */ 137,128,  0,  2,  0,  0,116, 33,235, 45, 65, 41,195, 65, 41,194,
/* 0x0590 */ 137,208,102,193,232,  5,141,116, 54,  1,102, 41,194,133,219,102,
/* 0x05a0 */  65,137,144,  0,  2,  0,  0,116, 14,129,254,255,  0,  0,  0, 15,
/* 0x05b0 */ 142, 97,255,255,255,235,120,129,254,255,  0,  0,  0,127,112, 72,
/* 0x05c0 */  99,198, 65,129,251,255,255,255,  0, 77,141,  4, 65,119, 26, 76,
/* 0x05d0 */  57,231, 15,132, 67,  7,  0,  0, 15,182,  7, 65,193,226,  8, 65,
/* 0x05e0 */ 193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 16, 68,137,216,
/* 0x05f0 */ 193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 24, 65,137,
/* 0x0600 */ 195,184,  0,  8,  0,  0,  1,246, 41,200,193,248,  5,141,  4,  2,
/* 0x0610 */ 102, 65,137,  0,235,161, 65, 41,195, 65, 41,194,137,208,102,193,
/* 0x0620 */ 232,  5,141,116, 54,  1,102, 41,194,102, 65,137, 16,235,136, 72,
/* 0x0630 */ 139, 76, 36,232, 68,137,248, 65,255,199, 65,137,245, 64,136, 52,
/* 0x0640 */   1,131,124, 36,200,  3,127, 13,199, 68, 36,200,  0,  0,  0,  0,
/* 0x0650 */ 233,166,  6,  0,  0,139, 84, 36,200,139, 68, 36,200,131,234,  3,
/* 0x0660 */ 131,232,  6,131,124, 36,200,  9, 15, 79,208,137, 84, 36,200,233,
/* 0x0670 */ 135,  6,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,
/* 0x0680 */ 102, 41,194, 72,139, 68, 36,216, 65,129,251,255,255,255,  0,102,
/* 0x0690 */  65,137, 17, 72,141, 52, 88,119, 26, 76, 57,231, 15,132,121,  6,
/* 0x06a0 */   0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199,
/* 0x06b0 */  65,  9,194, 15,183,150,128,  1,  0,  0, 68,137,216,193,232, 11,
/* 0x06c0 */  15,183,202, 15,175,193, 65, 57,194,115, 78, 65,137,195,184,  0,
/* 0x06d0 */   8,  0,  0, 76,139, 76, 36,216, 41,200,139, 76, 36,196, 68,137,
/* 0x06e0 */ 116, 36,196,193,248,  5,141,  4,  2,139, 84, 36,192,137, 76, 36,
/* 0x06f0 */ 192,102,137,134,128,  1,  0,  0, 49,192,131,124, 36,200,  6,137,
/* 0x0700 */  84, 36,188, 15,159,192, 73,129,193,100,  6,  0,  0,141,  4, 64,
/* 0x0710 */ 137, 68, 36,200,233, 84,  2,  0,  0, 65, 41,195, 65, 41,194,137,
/* 0x0720 */ 208,102,193,232,  5,102, 41,194, 65,129,251,255,255,255,  0,102,
/* 0x0730 */ 137,150,128,  1,  0,  0,119, 26, 76, 57,231, 15,132,218,  5,  0,
/* 0x0740 */   0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,
/* 0x0750 */   9,194, 15,183,150,152,  1,  0,  0, 68,137,216,193,232, 11, 15,
/* 0x0760 */ 183,202, 15,175,193, 65, 57,194, 15,131,208,  0,  0,  0, 65,184,
/* 0x0770 */   0,  8,  0,  0, 65,137,195, 72,193,227,  5, 68,137,192, 41,200,
/* 0x0780 */ 193,248,  5,141,  4,  2,102,137,134,152,  1,  0,  0, 72,139, 68,
/* 0x0790 */  36,216, 72,  1,216, 65,129,251,255,255,255,  0, 72,141, 52,104,
/* 0x07a0 */ 119, 26, 76, 57,231, 15,132,112,  5,  0,  0, 15,182,  7, 65,193,
/* 0x07b0 */ 226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,224,
/* 0x07c0 */   1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65,
/* 0x07d0 */  57,194,115, 79, 65, 41,200, 65,137,195, 65,193,248,  5, 69,133,
/* 0x07e0 */ 255, 66,141,  4,  2,102,137,134,224,  1,  0,  0, 15,132, 41,  5,
/* 0x07f0 */   0,  0, 49,192,131,124, 36,200,  6, 72,139, 92, 36,232, 15,159,
/* 0x0800 */ 192,141, 68,  0,  9,137, 68, 36,200, 68,137,248, 68, 41,240, 68,
/* 0x0810 */  15,182, 44,  3, 68,137,248, 65,255,199, 68,136, 44,  3,233,216,
/* 0x0820 */   4,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102,
/* 0x0830 */  41,194,102,137,150,224,  1,  0,  0,233, 17,  1,  0,  0, 65, 41,
/* 0x0840 */ 195, 65, 41,194,137,208,102,193,232,  5,102, 41,194, 65,129,251,
/* 0x0850 */ 255,255,255,  0,102,137,150,152,  1,  0,  0,119, 26, 76, 57,231,
/* 0x0860 */  15,132,181,  4,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,
/* 0x0870 */   8, 72,255,199, 65,  9,194, 15,183,150,176,  1,  0,  0, 68,137,
/* 0x0880 */ 216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 32, 65,
/* 0x0890 */ 137,195,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,
/* 0x08a0 */ 137,134,176,  1,  0,  0,139, 68, 36,196,233,152,  0,  0,  0, 65,
/* 0x08b0 */  41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194, 65,129,
/* 0x08c0 */ 251,255,255,255,  0,102,137,150,176,  1,  0,  0,119, 26, 76, 57,
/* 0x08d0 */ 231, 15,132, 68,  4,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,
/* 0x08e0 */ 227,  8, 72,255,199, 65,  9,194, 15,183,150,200,  1,  0,  0, 68,
/* 0x08f0 */ 137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 29,
/* 0x0900 */  65,137,195,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,
/* 0x0910 */ 102,137,134,200,  1,  0,  0,139, 68, 36,192,235, 34, 65, 41,195,
/* 0x0920 */  65, 41,194,137,208,102,193,232,  5,102, 41,194,139, 68, 36,188,
/* 0x0930 */ 102,137,150,200,  1,  0,  0,139, 84, 36,192,137, 84, 36,188,139,
/* 0x0940 */  76, 36,196,137, 76, 36,192, 68,137,116, 36,196, 65,137,198, 49,
/* 0x0950 */ 192,131,124, 36,200,  6, 76,139, 76, 36,216, 15,159,192, 73,129,
/* 0x0960 */ 193,104, 10,  0,  0,141, 68, 64,  8,137, 68, 36,200, 65,129,251,
/* 0x0970 */ 255,255,255,  0,119, 26, 76, 57,231, 15,132,156,  3,  0,  0, 15,
/* 0x0980 */ 182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,
/* 0x0990 */  65, 15,183, 17, 68,137,216,193,232, 11, 15,183,202, 15,175,193,
/* 0x09a0 */  65, 57,194,115, 39, 65,137,195,184,  0,  8,  0,  0, 69, 49,237,
/* 0x09b0 */  41,200,193,248,  5,141,  4,  2,102, 65,137,  1, 72, 99, 68, 36,
/* 0x09c0 */ 184, 72,193,224,  4, 77,141, 68,  1,  4,235,120, 65, 41,195, 65,
/* 0x09d0 */  41,194,137,208,102,193,232,  5,102, 41,194, 65,129,251,255,255,
/* 0x09e0 */ 255,  0,102, 65,137, 17,119, 26, 76, 57,231, 15,132, 42,  3,  0,
/* 0x09f0 */   0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,
/* 0x0a00 */   9,194, 65, 15,183, 81,  2, 68,137,216,193,232, 11, 15,183,202,
/* 0x0a10 */  15,175,193, 65, 57,194,115, 52, 65,137,195,184,  0,  8,  0,  0,
/* 0x0a20 */  65,189,  8,  0,  0,  0, 41,200,193,248,  5,141,  4,  2,102, 65,
/* 0x0a30 */ 137, 65,  2, 72, 99, 68, 36,184, 72,193,224,  4, 77,141,132,  1,
/* 0x0a40 */   4,  1,  0,  0, 65,185,  3,  0,  0,  0,235, 39, 65, 41,195, 65,
/* 0x0a50 */  41,194,137,208,102,193,232,  5, 77,141,129,  4,  2,  0,  0, 65,
/* 0x0a60 */ 189, 16,  0,  0,  0,102, 41,194,102, 65,137, 81,  2, 65,185,  8,
/* 0x0a70 */   0,  0,  0, 68,137,203,189,  1,  0,  0,  0, 72, 99,197, 65,129,
/* 0x0a80 */ 251,255,255,255,  0, 73,141, 52, 64,119, 26, 76, 57,231, 15,132,
/* 0x0a90 */ 135,  2,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,
/* 0x0aa0 */ 255,199, 65,  9,194, 15,183, 14, 68,137,216,193,232, 11, 15,183,
/* 0x0ab0 */ 209, 15,175,194, 65, 57,194,115, 23, 65,137,195,184,  0,  8,  0,
/* 0x0ac0 */   0,  1,237, 41,208,193,248,  5,141,  4,  1,102,137,  6,235, 22,
/* 0x0ad0 */  65, 41,195, 65, 41,194,137,200,102,193,232,  5,141,108, 45,  1,
/* 0x0ae0 */ 102, 41,193,102,137, 14,255,203,117,145,184,  1,  0,  0,  0, 68,
/* 0x0af0 */ 137,201,211,224, 41,197, 68,  1,237,131,124, 36,200,  3, 15,143,
/* 0x0b00 */ 194,  1,  0,  0,131, 68, 36,200,  7,184,  3,  0,  0,  0,131,253,
/* 0x0b10 */   4, 15, 76,197, 72,139, 92, 36,216, 65,184,  1,  0,  0,  0, 72,
/* 0x0b20 */ 152, 72,193,224,  7, 76,141,140,  3, 96,  3,  0,  0,187,  6,  0,
/* 0x0b30 */   0,  0, 73, 99,192, 65,129,251,255,255,255,  0, 73,141, 52, 65,
/* 0x0b40 */ 119, 26, 76, 57,231, 15,132,208,  1,  0,  0, 15,182,  7, 65,193,
/* 0x0b50 */ 226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183, 22, 68,
/* 0x0b60 */ 137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 24,
/* 0x0b70 */  65,137,195,184,  0,  8,  0,  0, 69,  1,192, 41,200,193,248,  5,
/* 0x0b80 */ 141,  4,  2,102,137,  6,235, 23, 65, 41,195, 65, 41,194,137,208,
/* 0x0b90 */ 102,193,232,  5, 71,141, 68,  0,  1,102, 41,194,102,137, 22,255,
/* 0x0ba0 */ 203,117,143, 65,131,232, 64, 65,131,248,  3, 69,137,198, 15,142,
/* 0x0bb0 */  13,  1,  0,  0, 65,131,230,  1, 68,137,192,209,248, 65,131,206,
/* 0x0bc0 */   2, 65,131,248, 13,141,112,255,127, 35,137,241, 72,139, 92, 36,
/* 0x0bd0 */ 216, 73, 99,192, 65,211,230, 72,  1,192, 68,137,242, 72,141, 20,
/* 0x0be0 */  83, 72, 41,194, 76,141,138, 94,  5,  0,  0,235, 81,141,112,251,
/* 0x0bf0 */  65,129,251,255,255,255,  0,119, 26, 76, 57,231, 15,132, 25,  1,
/* 0x0c00 */   0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199,
/* 0x0c10 */  65,  9,194, 65,209,235, 69,  1,246, 69, 57,218,114,  7, 69, 41,
/* 0x0c20 */ 218, 65,131,206,  1,255,206,117,199, 76,139, 76, 36,216, 65,193,
/* 0x0c30 */ 230,  4,190,  4,  0,  0,  0, 73,129,193, 68,  6,  0,  0, 65,189,
/* 0x0c40 */   1,  0,  0,  0,187,  1,  0,  0,  0, 72, 99,195, 65,129,251,255,
/* 0x0c50 */ 255,255,  0, 77,141,  4, 65,119, 26, 76, 57,231, 15,132,185,  0,
/* 0x0c60 */   0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199,
/* 0x0c70 */  65,  9,194, 65, 15,183, 16, 68,137,216,193,232, 11, 15,183,202,
/* 0x0c80 */  15,175,193, 65, 57,194,115, 24, 65,137,195,184,  0,  8,  0,  0,
/* 0x0c90 */   1,219, 41,200,193,248,  5,141,  4,  2,102, 65,137,  0,235, 26,
/* 0x0ca0 */  65, 41,195, 65, 41,194,137,208,102,193,232,  5,141, 92, 27,  1,
/* 0x0cb0 */  69,  9,238,102, 41,194,102, 65,137, 16, 69,  1,237,255,206,117,
/* 0x0cc0 */ 136, 65,255,198,116, 64,131,197,  2, 69, 57,254,119, 77, 72,139,
/* 0x0cd0 */  84, 36,232, 68,137,248, 68, 41,240, 68, 15,182, 44,  2, 68,137,
/* 0x0ce0 */ 248, 65,255,199,255,205, 68,136, 44,  2, 15,149,194, 49,192, 68,
/* 0x0cf0 */  59,124, 36,228, 15,146,192,133,194,117,211, 68, 59,124, 36,228,
/* 0x0d00 */  15,130, 69,247,255,255, 65,129,251,255,255,255,  0,119, 22, 76,
/* 0x0d10 */  57,231,184,  1,  0,  0,  0,116, 35,235,  7,184,  1,  0,  0,  0,
/* 0x0d20 */ 235, 26, 72,255,199,137,248, 43, 68, 36,248, 72,139, 76, 36,240,
/* 0x0d30 */  72,139, 92, 36, 56,137,  1, 68,137, 59, 49,192, 91, 93, 65, 92,
/* 0x0d40 */  65, 93, 65, 94, 65, 95, 65, 87, 72,141, 71,  4, 69, 49,255, 65,
/* 0x0d50 */  86, 65,190,  1,  0,  0,  0, 65, 85, 69, 49,237, 65, 84, 85, 83,
/* 0x0d60 */  72,137, 76, 36,240, 72,137, 68, 36,216,184,  1,  0,  0,  0, 72,
/* 0x0d70 */ 137,116, 36,248, 76,137, 68, 36,232,137,195, 68,137, 76, 36,228,
/* 0x0d80 */  15,182, 79,  2,211,227,137,217, 72,139, 92, 36, 56,255,201,137,
/* 0x0d90 */  76, 36,212, 15,182, 79,  1,211,224, 72,139, 76, 36,240,255,200,
/* 0x0da0 */ 137, 68, 36,208, 15,182,  7,199,  1,  0,  0,  0,  0,199, 68, 36,
/* 0x0db0 */ 200,  0,  0,  0,  0,199, 68, 36,196,  1,  0,  0,  0,199, 68, 36,
/* 0x0dc0 */ 192,  1,  0,  0,  0,199, 68, 36,188,  1,  0,  0,  0,199,  3,  0,
/* 0x0dd0 */   0,  0,  0,137, 68, 36,204, 15,182, 79,  1,  1,193,184,  0,  3,
/* 0x0de0 */   0,  0,211,224, 49,201,141,184, 54,  7,  0,  0, 65, 57,255,115,
/* 0x0df0 */  19, 72,139, 92, 36,216,137,200,255,193, 57,249,102,199,  4, 67,
/* 0x0e00 */   0,  4,235,235, 72,139,124, 36,248,137,208, 69, 49,210, 65,131,
/* 0x0e10 */ 203,255, 49,210, 73,137,252, 73,  1,196, 76, 57,231, 15,132,239,
/* 0x0e20 */   8,  0,  0, 15,182,  7, 65,193,226,  8,255,194, 72,255,199, 65,
/* 0x0e30 */   9,194,131,250,  4,126,227, 68, 59,124, 36,228, 15,131,218,  8,
/* 0x0e40 */   0,  0,139, 68, 36,212, 72, 99, 92, 36,200, 72,139, 84, 36,216,
/* 0x0e50 */  68, 33,248,137, 68, 36,184, 72, 99,108, 36,184, 72,137,216, 72,
/* 0x0e60 */ 193,224,  4, 72,  1,232, 65,129,251,255,255,255,  0, 76,141, 12,
/* 0x0e70 */  66,119, 26, 76, 57,231, 15,132,150,  8,  0,  0, 15,182,  7, 65,
/* 0x0e80 */ 193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183,
/* 0x0e90 */  17, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,
/* 0x0ea0 */  15,131,197,  1,  0,  0, 65,137,195,184,  0,  8,  0,  0, 72,139,
/* 0x0eb0 */  92, 36,216, 41,200, 15,182, 76, 36,204,190,  1,  0,  0,  0,193,
/* 0x0ec0 */ 248,  5,141,  4,  2, 65, 15,182,213,102, 65,137,  1,139, 68, 36,
/* 0x0ed0 */ 208, 68, 33,248,211,224,185,  8,  0,  0,  0, 43, 76, 36,204,211,
/* 0x0ee0 */ 250,  1,208,105,192,  0,  3,  0,  0,131,124, 36,200,  6,137,192,
/* 0x0ef0 */  76,141,140, 67,108, 14,  0,  0, 15,142,184,  0,  0,  0, 72,139,
/* 0x0f00 */  84, 36,232, 68,137,248, 68, 41,240, 15,182, 44,  2,  1,237, 72,
/* 0x0f10 */  99,214,137,235,129,227,  0,  1,  0,  0, 65,129,251,255,255,255,
/* 0x0f20 */   0, 72, 99,195, 73,141,  4, 65, 76,141,  4, 80,119, 26, 76, 57,
/* 0x0f30 */ 231, 15,132,219,  7,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,
/* 0x0f40 */ 227,  8, 72,255,199, 65,  9,194, 65, 15,183,144,  0,  2,  0,  0,
/* 0x0f50 */  68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115,
/* 0x0f60 */  32, 65,137,195,184,  0,  8,  0,  0,  1,246, 41,200,193,248,  5,
/* 0x0f70 */ 133,219,141,  4,  2,102, 65,137,128,  0,  2,  0,  0,116, 33,235,
/* 0x0f80 */  45, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,141,116, 54,
/* 0x0f90 */   1,102, 41,194,133,219,102, 65,137,144,  0,  2,  0,  0,116, 14,
/* 0x0fa0 */ 129,254,255,  0,  0,  0, 15,142, 97,255,255,255,235,120,129,254,
/* 0x0fb0 */ 255,  0,  0,  0,127,112, 72, 99,198, 65,129,251,255,255,255,  0,
/* 0x0fc0 */  77,141,  4, 65,119, 26, 76, 57,231, 15,132, 67,  7,  0,  0, 15,
/* 0x0fd0 */ 182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,
/* 0x0fe0 */  65, 15,183, 16, 68,137,216,193,232, 11, 15,183,202, 15,175,193,
/* 0x0ff0 */  65, 57,194,115, 24, 65,137,195,184,  0,  8,  0,  0,  1,246, 41,
/* 0x1000 */ 200,193,248,  5,141,  4,  2,102, 65,137,  0,235,161, 65, 41,195,
/* 0x1010 */  65, 41,194,137,208,102,193,232,  5,141,116, 54,  1,102, 41,194,
/* 0x1020 */ 102, 65,137, 16,235,136, 72,139, 76, 36,232, 68,137,248, 65,255,
/* 0x1030 */ 199, 65,137,245, 64,136, 52,  1,131,124, 36,200,  3,127, 13,199,
/* 0x1040 */  68, 36,200,  0,  0,  0,  0,233,166,  6,  0,  0,139, 84, 36,200,
/* 0x1050 */ 139, 68, 36,200,131,234,  3,131,232,  6,131,124, 36,200,  9, 15,
/* 0x1060 */  79,208,137, 84, 36,200,233,135,  6,  0,  0, 65, 41,195, 65, 41,
/* 0x1070 */ 194,137,208,102,193,232,  5,102, 41,194, 72,139, 68, 36,216, 65,
/* 0x1080 */ 129,251,255,255,255,  0,102, 65,137, 17, 72,141, 52, 88,119, 26,
/* 0x1090 */  76, 57,231, 15,132,121,  6,  0,  0, 15,182,  7, 65,193,226,  8,
/* 0x10a0 */  65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,128,  1,  0,
/* 0x10b0 */   0, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,
/* 0x10c0 */ 115, 78, 65,137,195,184,  0,  8,  0,  0, 76,139, 76, 36,216, 41,
/* 0x10d0 */ 200,139, 76, 36,196, 68,137,116, 36,196,193,248,  5,141,  4,  2,
/* 0x10e0 */ 139, 84, 36,192,137, 76, 36,192,102,137,134,128,  1,  0,  0, 49,
/* 0x10f0 */ 192,131,124, 36,200,  6,137, 84, 36,188, 15,159,192, 73,129,193,
/* 0x1100 */ 100,  6,  0,  0,141,  4, 64,137, 68, 36,200,233, 84,  2,  0,  0,
/* 0x1110 */  65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194, 65,
/* 0x1120 */ 129,251,255,255,255,  0,102,137,150,128,  1,  0,  0,119, 26, 76,
/* 0x1130 */  57,231, 15,132,218,  5,  0,  0, 15,182,  7, 65,193,226,  8, 65,
/* 0x1140 */ 193,227,  8, 72,255,199, 65,  9,194, 15,183,150,152,  1,  0,  0,
/* 0x1150 */  68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194, 15,
/* 0x1160 */ 131,208,  0,  0,  0, 65,184,  0,  8,  0,  0, 65,137,195, 72,193,
/* 0x1170 */ 227,  5, 68,137,192, 41,200,193,248,  5,141,  4,  2,102,137,134,
/* 0x1180 */ 152,  1,  0,  0, 72,139, 68, 36,216, 72,  1,216, 65,129,251,255,
/* 0x1190 */ 255,255,  0, 72,141, 52,104,119, 26, 76, 57,231, 15,132,112,  5,
/* 0x11a0 */   0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199,
/* 0x11b0 */  65,  9,194, 15,183,150,224,  1,  0,  0, 68,137,216,193,232, 11,
/* 0x11c0 */  15,183,202, 15,175,193, 65, 57,194,115, 79, 65, 41,200, 65,137,
/* 0x11d0 */ 195, 65,193,248,  5, 69,133,255, 66,141,  4,  2,102,137,134,224,
/* 0x11e0 */   1,  0,  0, 15,132, 41,  5,  0,  0, 49,192,131,124, 36,200,  6,
/* 0x11f0 */  72,139, 92, 36,232, 15,159,192,141, 68,  0,  9,137, 68, 36,200,
/* 0x1200 */  68,137,248, 68, 41,240, 68, 15,182, 44,  3, 68,137,248, 65,255,
/* 0x1210 */ 199, 68,136, 44,  3,233,216,  4,  0,  0, 65, 41,195, 65, 41,194,
/* 0x1220 */ 137,208,102,193,232,  5,102, 41,194,102,137,150,224,  1,  0,  0,
/* 0x1230 */ 233, 17,  1,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,
/* 0x1240 */   5,102, 41,194, 65,129,251,255,255,255,  0,102,137,150,152,  1,
/* 0x1250 */   0,  0,119, 26, 76, 57,231, 15,132,181,  4,  0,  0, 15,182,  7,
/* 0x1260 */  65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,
/* 0x1270 */ 150,176,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,
/* 0x1280 */ 193, 65, 57,194,115, 32, 65,137,195,184,  0,  8,  0,  0, 41,200,
/* 0x1290 */ 193,248,  5,141,  4,  2,102,137,134,176,  1,  0,  0,139, 68, 36,
/* 0x12a0 */ 196,233,152,  0,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,
/* 0x12b0 */ 232,  5,102, 41,194, 65,129,251,255,255,255,  0,102,137,150,176,
/* 0x12c0 */   1,  0,  0,119, 26, 76, 57,231, 15,132, 68,  4,  0,  0, 15,182,
/* 0x12d0 */   7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,
/* 0x12e0 */ 183,150,200,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,
/* 0x12f0 */ 175,193, 65, 57,194,115, 29, 65,137,195,184,  0,  8,  0,  0, 41,
/* 0x1300 */ 200,193,248,  5,141,  4,  2,102,137,134,200,  1,  0,  0,139, 68,
/* 0x1310 */  36,192,235, 34, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,
/* 0x1320 */ 102, 41,194,139, 68, 36,188,102,137,150,200,  1,  0,  0,139, 84,
/* 0x1330 */  36,192,137, 84, 36,188,139, 76, 36,196,137, 76, 36,192, 68,137,
/* 0x1340 */ 116, 36,196, 65,137,198, 49,192,131,124, 36,200,  6, 76,139, 76,
/* 0x1350 */  36,216, 15,159,192, 73,129,193,104, 10,  0,  0,141, 68, 64,  8,
/* 0x1360 */ 137, 68, 36,200, 65,129,251,255,255,255,  0,119, 26, 76, 57,231,
/* 0x1370 */  15,132,156,  3,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,
/* 0x1380 */   8, 72,255,199, 65,  9,194, 65, 15,183, 17, 68,137,216,193,232,
/* 0x1390 */  11, 15,183,202, 15,175,193, 65, 57,194,115, 39, 65,137,195,184,
/* 0x13a0 */   0,  8,  0,  0, 69, 49,237, 41,200,193,248,  5,141,  4,  2,102,
/* 0x13b0 */  65,137,  1, 72, 99, 68, 36,184, 72,193,224,  4, 77,141, 68,  1,
/* 0x13c0 */   4,235,120, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102,
/* 0x13d0 */  41,194, 65,129,251,255,255,255,  0,102, 65,137, 17,119, 26, 76,
/* 0x13e0 */  57,231, 15,132, 42,  3,  0,  0, 15,182,  7, 65,193,226,  8, 65,
/* 0x13f0 */ 193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 81,  2, 68,137,
/* 0x1400 */ 216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 52, 65,
/* 0x1410 */ 137,195,184,  0,  8,  0,  0, 65,189,  8,  0,  0,  0, 41,200,193,
/* 0x1420 */ 248,  5,141,  4,  2,102, 65,137, 65,  2, 72, 99, 68, 36,184, 72,
/* 0x1430 */ 193,224,  4, 77,141,132,  1,  4,  1,  0,  0, 65,185,  3,  0,  0,
/* 0x1440 */   0,235, 39, 65, 41,195, 65, 41,194,137,208,102,193,232,  5, 77,
/* 0x1450 */ 141,129,  4,  2,  0,  0, 65,189, 16,  0,  0,  0,102, 41,194,102,
/* 0x1460 */  65,137, 81,  2, 65,185,  8,  0,  0,  0, 68,137,203,189,  1,  0,
/* 0x1470 */   0,  0, 72, 99,197, 65,129,251,255,255,255,  0, 73,141, 52, 64,
/* 0x1480 */ 119, 26, 76, 57,231, 15,132,135,  2,  0,  0, 15,182,  7, 65,193,
/* 0x1490 */ 226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183, 14, 68,
/* 0x14a0 */ 137,216,193,232, 11, 15,183,209, 15,175,194, 65, 57,194,115, 23,
/* 0x14b0 */  65,137,195,184,  0,  8,  0,  0,  1,237, 41,208,193,248,  5,141,
/* 0x14c0 */   4,  1,102,137,  6,235, 22, 65, 41,195, 65, 41,194,137,200,102,
/* 0x14d0 */ 193,232,  5,141,108, 45,  1,102, 41,193,102,137, 14,255,203,117,
/* 0x14e0 */ 145,184,  1,  0,  0,  0, 68,137,201,211,224, 41,197, 68,  1,237,
/* 0x14f0 */ 131,124, 36,200,  3, 15,143,194,  1,  0,  0,131, 68, 36,200,  7,
/* 0x1500 */ 184,  3,  0,  0,  0,131,253,  4, 15, 76,197, 72,139, 92, 36,216,
/* 0x1510 */  65,184,  1,  0,  0,  0, 72,152, 72,193,224,  7, 76,141,140,  3,
/* 0x1520 */  96,  3,  0,  0,187,  6,  0,  0,  0, 73, 99,192, 65,129,251,255,
/* 0x1530 */ 255,255,  0, 73,141, 52, 65,119, 26, 76, 57,231, 15,132,208,  1,
/* 0x1540 */   0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199,
/* 0x1550 */  65,  9,194, 15,183, 22, 68,137,216,193,232, 11, 15,183,202, 15,
/* 0x1560 */ 175,193, 65, 57,194,115, 24, 65,137,195,184,  0,  8,  0,  0, 69,
/* 0x1570 */   1,192, 41,200,193,248,  5,141,  4,  2,102,137,  6,235, 23, 65,
/* 0x1580 */  41,195, 65, 41,194,137,208,102,193,232,  5, 71,141, 68,  0,  1,
/* 0x1590 */ 102, 41,194,102,137, 22,255,203,117,143, 65,131,232, 64, 65,131,
/* 0x15a0 */ 248,  3, 69,137,198, 15,142, 13,  1,  0,  0, 65,131,230,  1, 68,
/* 0x15b0 */ 137,192,209,248, 65,131,206,  2, 65,131,248, 13,141,112,255,127,
/* 0x15c0 */  35,137,241, 72,139, 92, 36,216, 73, 99,192, 65,211,230, 72,  1,
/* 0x15d0 */ 192, 68,137,242, 72,141, 20, 83, 72, 41,194, 76,141,138, 94,  5,
/* 0x15e0 */   0,  0,235, 81,141,112,251, 65,129,251,255,255,255,  0,119, 26,
/* 0x15f0 */  76, 57,231, 15,132, 25,  1,  0,  0, 15,182,  7, 65,193,226,  8,
/* 0x1600 */  65,193,227,  8, 72,255,199, 65,  9,194, 65,209,235, 69,  1,246,
/* 0x1610 */  69, 57,218,114,  7, 69, 41,218, 65,131,206,  1,255,206,117,199,
/* 0x1620 */  76,139, 76, 36,216, 65,193,230,  4,190,  4,  0,  0,  0, 73,129,
/* 0x1630 */ 193, 68,  6,  0,  0, 65,189,  1,  0,  0,  0,187,  1,  0,  0,  0,
/* 0x1640 */  72, 99,195, 65,129,251,255,255,255,  0, 77,141,  4, 65,119, 26,
/* 0x1650 */  76, 57,231, 15,132,185,  0,  0,  0, 15,182,  7, 65,193,226,  8,
/* 0x1660 */  65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 16, 68,137,
/* 0x1670 */ 216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 24, 65,
/* 0x1680 */ 137,195,184,  0,  8,  0,  0,  1,219, 41,200,193,248,  5,141,  4,
/* 0x1690 */   2,102, 65,137,  0,235, 26, 65, 41,195, 65, 41,194,137,208,102,
/* 0x16a0 */ 193,232,  5,141, 92, 27,  1, 69,  9,238,102, 41,194,102, 65,137,
/* 0x16b0 */  16, 69,  1,237,255,206,117,136, 65,255,198,116, 64,131,197,  2,
/* 0x16c0 */  69, 57,254,119, 77, 72,139, 84, 36,232, 68,137,248, 68, 41,240,
/* 0x16d0 */  68, 15,182, 44,  2, 68,137,248, 65,255,199,255,205, 68,136, 44,
/* 0x16e0 */   2, 15,149,194, 49,192, 68, 59,124, 36,228, 15,146,192,133,194,
/* 0x16f0 */ 117,211, 68, 59,124, 36,228, 15,130, 69,247,255,255, 65,129,251,
/* 0x1700 */ 255,255,255,  0,119, 22, 76, 57,231,184,  1,  0,  0,  0,116, 35,
/* 0x1710 */ 235,  7,184,  1,  0,  0,  0,235, 26, 72,255,199,137,248, 43, 68,
/* 0x1720 */  36,248, 72,139, 76, 36,240, 72,139, 92, 36, 56,137,  1, 68,137,
/* 0x1730 */  59, 49,192, 91, 93, 65, 92, 65, 93, 65, 94, 65, 95, 72,139,117,
/* 0x1740 */ 248, 72,139,125, 16,139, 75,  4, 72,  1,206,139, 19, 72,  1,215,
/* 0x1750 */ 201, 89, 72,137,240, 72, 41,200, 90, 72, 41,215, 89,137, 57, 91,
/* 0x1760 */  93,195, 91,139, 75,  4, 72,141,116, 25, 11,139, 59, 72,141,188,
/* 0x1770 */  31,203,  0,  0,  0,253,243,164, 72,141,147,128,  0,  0,  0, 72,
/* 0x1780 */ 137,222, 72,141,127,  1, 82,252,173, 80, 72,137,225,173, 80,173,
/* 0x1790 */  68, 15,182,192, 94,255,213, 89, 72,141, 93,247,195, 93,232,191,
/* 0x17a0 */ 255,255,255,102,105,108,101, 32,102,111,114,109, 97,116, 32,101,
/* 0x17b0 */ 108,102, 54, 52, 45,120, 56, 54, 45, 54, 52, 10, 10, 83,101, 99,
/* 0x17c0 */ 116,105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32,
/* 0x17d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32,
/* 0x17e0 */  32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x17f0 */  32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1800 */  32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32,
/* 0x1810 */  32, 65,108,103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48,
/* 0x1820 */  32, 65, 77, 68, 54, 52, 66, 88, 88, 32, 32, 32, 32, 32, 32, 48,
/* 0x1830 */  48, 48, 48, 48, 48, 53, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1840 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1850 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1860 */  48, 48, 48, 52, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1870 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x1880 */  32, 32, 49, 32, 77, 65, 67, 72, 77, 65, 73, 78, 88, 32, 32, 32,
/* 0x1890 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48,
/* 0x18a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x18b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x18c0 */  48, 48, 48, 48, 48, 48, 57, 50, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x18d0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x18e0 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 50, 32, 77, 65,
/* 0x18f0 */  67, 72, 95, 85, 78, 67, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x1900 */  48, 48, 48, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1910 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1920 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1930 */  57, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1940 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 51,
/* 0x1950 */  32, 78, 82, 86, 95, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48,
/* 0x1960 */  48, 48, 48, 48, 48, 54, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1970 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1980 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1990 */  48, 48, 48, 57,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x19a0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x19b0 */  32, 32, 52, 32, 78, 82, 86, 50, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x19c0 */  32, 32, 48, 48, 48, 48, 48, 48, 98, 55, 32, 32, 48, 48, 48, 48,
/* 0x19d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x19e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x19f0 */  48, 48, 48, 48, 48, 49, 48, 54, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1a00 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x1a10 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 53, 32, 78, 82,
/* 0x1a20 */  86, 50, 68, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x1a30 */  48, 48, 57,101, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1a40 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1a50 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,
/* 0x1a60 */  98,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1a70 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x1a80 */  78, 76, 89, 10, 32, 32, 54, 32, 78, 82, 86, 50, 66, 32, 32, 32,
/* 0x1a90 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 57, 48, 32, 32,
/* 0x1aa0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ab0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ac0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 53, 98, 32, 32, 50, 42,
/* 0x1ad0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x1ae0 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32,
/* 0x1af0 */  55, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32,
/* 0x1b00 */  48, 48, 48, 48, 48, 48, 54, 52, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1b10 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1b20 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1b30 */  48, 48, 48, 50,101, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1b40 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x1b50 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 56, 32, 76, 90, 77, 65,
/* 0x1b60 */  95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 57,
/* 0x1b70 */ 102, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1b80 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1b90 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 52,102,
/* 0x1ba0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x1bb0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 57, 32, 76,
/* 0x1bc0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32, 32, 48, 48, 48,
/* 0x1bd0 */  48, 48, 57,102, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1be0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1bf0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1c00 */ 100, 52, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1c10 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49,
/* 0x1c20 */  48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32,
/* 0x1c30 */  48, 48, 48, 48, 48, 48, 49, 52, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1c40 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1c50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1c60 */  48, 48, 49, 55, 51,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1c70 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x1c80 */  10, 32, 49, 49, 32, 78, 82, 86, 95, 84, 65, 73, 76, 32, 32, 32,
/* 0x1c90 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1ca0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1cb0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1cc0 */  32, 48, 48, 48, 48, 49, 55, 53, 49, 32, 32, 50, 42, 42, 48, 32,
/* 0x1cd0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x1ce0 */  78, 76, 89, 10, 32, 49, 50, 32, 77, 65, 67, 72, 77, 65, 73, 78,
/* 0x1cf0 */  89, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 49, 32, 32,
/* 0x1d00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d10 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d20 */  48, 48, 32, 32, 48, 48, 48, 48, 49, 55, 53, 49, 32, 32, 50, 42,
/* 0x1d30 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x1d40 */  65, 68, 79, 78, 76, 89, 10, 32, 49, 51, 32, 77, 65, 67, 72, 77,
/* 0x1d50 */  65, 73, 78, 90, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 52,
/* 0x1d60 */  49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d70 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d80 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 55, 54, 50, 32,
/* 0x1d90 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x1da0 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 83, 89, 77, 66, 79, 76,
/* 0x1db0 */  32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1dc0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x1dd0 */  32, 78, 82, 86, 95, 72, 69, 65, 68,  9, 48, 48, 48, 48, 48, 48,
/* 0x1de0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 95, 72,
/* 0x1df0 */  69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e00 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77,
/* 0x1e10 */  65, 95, 68, 69, 67, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e20 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x1e30 */  67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e40 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 65, 67,
/* 0x1e50 */  72, 77, 65, 73, 78, 89,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e60 */  48, 48, 48, 48, 48, 48, 48, 32, 77, 65, 67, 72, 77, 65, 73, 78,
/* 0x1e70 */  89, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e80 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 65, 67, 72, 77,
/* 0x1e90 */  65, 73, 78, 90,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ea0 */  48, 48, 48, 48, 48, 32, 77, 65, 67, 72, 77, 65, 73, 78, 90, 10,
/* 0x1eb0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ec0 */  32,108, 32, 32, 32, 32,100, 32, 32, 65, 77, 68, 54, 52, 66, 88,
/* 0x1ed0 */  88,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ee0 */  48, 48, 32, 65, 77, 68, 54, 52, 66, 88, 88, 10, 48, 48, 48, 48,
/* 0x1ef0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x1f00 */  32, 32,100, 32, 32, 77, 65, 67, 72, 77, 65, 73, 78, 88,  9, 48,
/* 0x1f10 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1f20 */  77, 65, 67, 72, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 48,
/* 0x1f30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x1f40 */ 100, 32, 32, 77, 65, 67, 72, 95, 85, 78, 67,  9, 48, 48, 48, 48,
/* 0x1f50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 65, 67,
/* 0x1f60 */  72, 95, 85, 78, 67, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1f70 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x1f80 */  82, 86, 50, 69,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1f90 */  48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48,
/* 0x1fa0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x1fb0 */  32, 32,100, 32, 32, 78, 82, 86, 50, 68,  9, 48, 48, 48, 48, 48,
/* 0x1fc0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50,
/* 0x1fd0 */  68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1fe0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66,
/* 0x1ff0 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2000 */  48, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2010 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x2020 */  32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,  9, 48, 48, 48, 48,
/* 0x2030 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77,
/* 0x2040 */  65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2050 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x2060 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48,
/* 0x2070 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77,
/* 0x2080 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2090 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x20a0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,  9, 48, 48, 48, 48,
/* 0x20b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77,
/* 0x20c0 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x20d0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x20e0 */  32, 78, 82, 86, 95, 84, 65, 73, 76,  9, 48, 48, 48, 48, 48, 48,
/* 0x20f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 95, 84,
/* 0x2100 */  65, 73, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2110 */  48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 77, 65, 67,
/* 0x2120 */  72, 77, 65, 73, 78, 88,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2130 */  48, 48, 48, 48, 48, 48, 48, 32, 95,115,116, 97,114,116, 10, 48,
/* 0x2140 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 32,
/* 0x2150 */ 103, 32, 32, 32, 32, 32, 32, 32, 77, 65, 67, 72, 77, 65, 73, 78,
/* 0x2160 */  89,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2170 */  48, 48, 32,101,110,100, 95,100,101, 99,111,109,112,114,101,115,
/* 0x2180 */ 115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x2190 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 77, 65, 67, 72, 77,
/* 0x21a0 */  65, 73, 78, 88, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x21b0 */  32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x21c0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x21d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x21e0 */  32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32,
/* 0x21f0 */  32, 32, 32, 77, 65, 67, 72, 77, 65, 73, 78, 90, 43, 48,120, 48,
/* 0x2200 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51, 55, 10,
/* 0x2210 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x2220 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 69, 93, 58,
/* 0x2230 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2240 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2250 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x2260 */  48, 48, 48, 48, 48, 48, 48, 48, 97,101, 32, 82, 95, 88, 56, 54,
/* 0x2270 */  95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x2280 */  95, 72, 69, 65, 68, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2290 */  48, 48, 48, 48, 48, 48, 50, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x22a0 */  48, 48, 48, 48, 48, 48, 48, 53, 98, 32, 82, 95, 88, 56, 54, 95,
/* 0x22b0 */  54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 77, 65, 67, 72,
/* 0x22c0 */  77, 65, 73, 78, 89, 43, 48,120,102,102,102,102,102,102,102,102,
/* 0x22d0 */ 102,102,102,102,102,102,102, 99, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x22e0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x22f0 */  32, 91, 78, 82, 86, 50, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x2300 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x2310 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x2320 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2330 */  48, 57, 53, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51,
/* 0x2340 */  50, 32, 32, 32, 32, 32, 78, 82, 86, 95, 72, 69, 65, 68, 43, 48,
/* 0x2350 */ 120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x2360 */  49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2370 */  53, 98, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50,
/* 0x2380 */  32, 32, 32, 32, 32, 77, 65, 67, 72, 77, 65, 73, 78, 89, 43, 48,
/* 0x2390 */ 120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x23a0 */  99, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x23b0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 66,
/* 0x23c0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32,
/* 0x23d0 */  32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x23e0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x23f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 56, 97, 32, 82, 95, 88,
/* 0x2400 */  56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 78,
/* 0x2410 */  82, 86, 95, 72, 69, 65, 68, 43, 48,120, 48, 48, 48, 48, 48, 48,
/* 0x2420 */  48, 48, 48, 48, 48, 48, 48, 48, 50, 49, 10, 48, 48, 48, 48, 48,
/* 0x2430 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 53, 50, 32, 82, 95, 88, 56,
/* 0x2440 */  54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 77, 65,
/* 0x2450 */  67, 72, 77, 65, 73, 78, 89, 43, 48,120,102,102,102,102,102,102,
/* 0x2460 */ 102,102,102,102,102,102,102,102,102, 99, 10, 10, 82, 69, 76, 79,
/* 0x2470 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x2480 */  79, 82, 32, 91, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 93, 58,
/* 0x2490 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x24a0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x24b0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x24c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 54, 32, 82, 95, 88, 56, 54,
/* 0x24d0 */  95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x24e0 */  65, 95, 68, 69, 67, 51, 48, 43, 48,120, 48, 48, 48, 48, 48, 48,
/* 0x24f0 */  48, 48, 48, 48, 48, 48, 48, 48, 49, 48, 10
};
