/* armeb.v4a-linux.elf-entry.h
   created from armeb.v4a-linux.elf-entry.bin, 14936 (0x3a58) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2017 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2017 Laszlo Molnar
   Copyright (C) 2000-2017 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_ARMEB_V4A_LINUX_ELF_ENTRY_SIZE    14936
#define STUB_ARMEB_V4A_LINUX_ELF_ENTRY_ADLER32 0x155120f3
#define STUB_ARMEB_V4A_LINUX_ELF_ENTRY_CRC32   0x9e120aec

unsigned char stub_armeb_v4a_linux_elf_entry[14936] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  2,  1, 97,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   0,  1,  0, 40,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0, 19,120,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,
/* 0x0030 */   0, 27,  0, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0040 */   0,  0,  0,  0,226, 79,192, 28,232,156, 76,  6,224,139,176, 12,
/* 0x0050 */ 224,138,160, 12,229,155, 48,  0,224, 76,144,  1,224,129, 16,  3,
/* 0x0060 */ 225,160,  0,  2,226,129, 26,  1,227,160, 48,  0,227,160, 58,  1,
/* 0x0070 */ 233, 45, 64, 15,227,160, 32,  7,229,156, 48, 16,227,160, 80,  0,
/* 0x0080 */ 227,224, 64,  0,227,131, 48, 16,239,144,  0,192,227,112, 10,  1,
/* 0x0090 */  42,255,255,254,232,185,  1,254,225, 89,  0, 10,232,160,  1,254,
/* 0x00a0 */  58,  0,  0,  7,224, 64, 64,  9,229,157, 16, 16,226,143, 80, 84,
/* 0x00b0 */ 228,128, 16,  4,225,160,224,  0,224,133, 80,  4,225,160,  0,  5,
/* 0x00c0 */ 224,137, 16,  4,227,160, 32,  0,239,159,  0,  2,229,156,144,  0,
/* 0x00d0 */ 226, 73,144,140,224, 76,160,  9,224,138,160,  4,229,155,  0,  8,
/* 0x00e0 */ 233, 45, 64,  1,229,155, 48,  0,226,139,  0, 12,229,155, 16,  4,
/* 0x00f0 */ 225,160, 32, 14,229,141, 48, 16,226,141, 48, 16,225,160,224, 15,
/* 0x0100 */ 225,160,240,  5,232,189,128,  2,233, 45, 64,252,224,129,112,  0,
/* 0x0110 */ 227,224, 80,  0,227,160, 65,  2,234,  0,  0, 20,232,189,  0, 24,
/* 0x0120 */ 224, 64,  0,  7,224, 66, 32,  3,229,132, 32,  0,225,160, 64,  0,
/* 0x0130 */ 225,160,  0,  3,224,131, 16,  2,227,160, 32,  0,239,159,  0,  2,
/* 0x0140 */ 225,160,  0,  4,232,189,128,240,228,208, 64,  1,224,164, 64,  4,
/* 0x0150 */ 225,176, 76,  4,225,160,240, 14,228,208, 48,  1,228,194, 48,  1,
/* 0x0160 */ 224,148, 64,  4, 11,  0,  0, 14, 42,  0,  0, 18,227,160, 16,  1,
/* 0x0170 */ 234,  0,  0, 29,226, 65, 16,  1,224,148, 64,  4, 11,  0,  0, 14,
/* 0x0180 */ 224,161, 16,  1,224,148, 64,  4, 11,  0,  0, 14,224,161, 16,  1,
/* 0x0190 */ 224,148, 64,  4, 11,  0,  0, 14, 58,  0,  0, 25,226, 81, 48,  3,
/* 0x01a0 */ 227,160, 16,  0, 58,  0,  0, 45,228,208, 80,  1,225,133, 84,  3,
/* 0x01b0 */ 225,240, 80,  5, 10,  0,  0,  3,225,176, 80,197, 42,  0,  0, 60,
/* 0x01c0 */ 234,  0,  0, 48,224,148, 64,  4, 11,  0,  0, 14, 42,  0,  0, 60,
/* 0x01d0 */ 227,160, 16,  1,224,148, 64,  4, 11,  0,  0, 14, 42,  0,  0, 60,
/* 0x01e0 */ 224,148, 64,  4, 11,  0,  0, 14,224,161, 16,  1,224,148, 64,  4,
/* 0x01f0 */  11,  0,  0, 14, 58,  0,  0, 52,226,129, 16,  4,234,  0,  0, 64,
/* 0x0200 */ 224,148, 64,  4, 11,  0,  0, 14,224,161, 16,  1,226,129, 16,  2,
/* 0x0210 */ 227,117, 12,  5, 50,129, 16,  1,224,130, 48,  1,229, 83, 48,  1,
/* 0x0220 */ 231,210, 48,  5,228,194, 48,  1,226, 81, 16,  1, 26,  0,  0, 68,
/* 0x0230 */ 234,  0,  0, 20,233, 45, 64,252,224,129,112,  0,227,224, 80,  0,
/* 0x0240 */ 227,160, 65,  2,234,  0,  0, 20,232,189,  0, 24,224, 64,  0,  7,
/* 0x0250 */ 224, 66, 32,  3,229,132, 32,  0,225,160, 64,  0,225,160,  0,  3,
/* 0x0260 */ 224,131, 16,  2,227,160, 32,  0,239,159,  0,  2,225,160,  0,  4,
/* 0x0270 */ 232,189,128,240,228,208, 64,  1,224,164, 64,  4,225,176, 76,  4,
/* 0x0280 */ 225,160,240, 14,228,208, 48,  1,228,194, 48,  1,224,148, 64,  4,
/* 0x0290 */  11,  0,  0, 14, 42,  0,  0, 18,227,160, 16,  1,234,  0,  0, 29,
/* 0x02a0 */ 226, 65, 16,  1,224,148, 64,  4, 11,  0,  0, 14,224,177, 16,  1,
/* 0x02b0 */ 224,148, 64,  4, 11,  0,  0, 14,224,177, 16,  1,224,148, 64,  4,
/* 0x02c0 */  11,  0,  0, 14, 58,  0,  0, 25,226, 81, 48,  3,227,160, 16,  0,
/* 0x02d0 */  58,  0,  0, 44,228,208, 80,  1,225,133, 84,  3,225,240, 80,  5,
/* 0x02e0 */  10,  0,  0,  3,225,176, 80,197,234,  0,  0, 46,224,148, 64,  4,
/* 0x02f0 */  11,  0,  0, 14,224,177, 16,  1,224,148, 64,  4, 11,  0,  0, 14,
/* 0x0300 */ 224,177, 16,  1, 26,  0,  0, 59,227,160, 16,  1,224,148, 64,  4,
/* 0x0310 */  11,  0,  0, 14,224,177, 16,  1,224,148, 64,  4, 11,  0,  0, 14,
/* 0x0320 */  58,  0,  0, 52,226,129, 16,  2,226,129, 16,  1,227,117, 12,  5,
/* 0x0330 */  50,129, 16,  1,229,210, 48,  0,231,210, 48,  5,228,194, 48,  1,
/* 0x0340 */ 226, 81, 16,  1, 26,  0,  0, 63,234,  0,  0, 20,224,129, 16,  0,
/* 0x0350 */ 233, 45, 64, 62,227,224, 80,  0,227,160, 65,  2,234,  0,  0, 29,
/* 0x0360 */ 232,189,  0, 26,224, 64,  0,  1,224, 66, 32,  3,229,132, 32,  0,
/* 0x0370 */ 225,160, 64,  0,225,160,  0,  3,224,131, 16,  2,227,160, 32,  0,
/* 0x0380 */ 239,159,  0,  2,225,160,  0,  4,232,189,128, 48,224,148, 64,  4,
/* 0x0390 */  17,160,240, 14,228,208, 64,  1,224,164, 64,  4,225,176, 76,  4,
/* 0x03a0 */ 225,160,240, 14,227,160, 16,  1,225,160,192, 14,235,  0,  0, 14,
/* 0x03b0 */ 224,177, 16,  1,235,  0,  0, 14, 58,  0,  0, 22,225,160,240, 12,
/* 0x03c0 */ 228,208, 48,  1,228,194, 48,  1,235,  0,  0, 14, 42,  0,  0, 27,
/* 0x03d0 */ 235,  0,  0, 20,226, 81, 48,  3,227,160, 16,  0, 58,  0,  0, 39,
/* 0x03e0 */ 228,208, 80,  1,225,133, 84,  3,225,240, 80,  5, 10,  0,  0,  3,
/* 0x03f0 */ 235,  0,  0, 14,224,177, 16,  1,235,  0,  0, 14,224,177, 16,  1,
/* 0x0400 */  26,  0,  0, 46,235,  0,  0, 20,226,129, 16,  2,227,117, 12, 13,
/* 0x0410 */  50,129, 16,  1,231,210, 48,  5,226, 81, 16,  1,228,194, 48,  1,
/* 0x0420 */  42,  0,  0, 48,234,  0,  0, 29,229,221,192,  0,227, 92,  0, 14,
/* 0x0430 */  26,255,255,254,233, 45, 72, 12,229,208,176,  0,227,160,204,  6,
/* 0x0440 */ 225,160,177,171,225,160,203, 28,225,160,176, 13,226,140,205, 58,
/* 0x0450 */ 224, 77,208, 12,229,147,192,  0,229,141, 48,  8,229,141,192,  4,
/* 0x0460 */ 229,141, 32,  0,226,141, 48, 12,227,160,192,  0,228,131,192,  4,
/* 0x0470 */ 225, 83,  0, 11, 26,  0,  0, 15,226,141, 48, 12,226, 65, 32,  2,
/* 0x0480 */ 225,160, 16,  0,228,209,192,  1,226, 12,192,  7,229,205,192, 18,
/* 0x0490 */ 228,209,192,  1,225,160,  2, 44,229,205,  0, 17,226, 12,192, 15,
/* 0x04a0 */ 229,205,192, 16,226,141,  0, 16,235,  0,  0, 40,225,160,208, 11,
/* 0x04b0 */ 225,160, 48,  0,232,189,  0,  3,229,145, 16,  0,224,129, 16,  0,
/* 0x04c0 */ 227,160, 32,  0,239,159,  0,  2,225,160,  0,  3,232,189,136,  0,
/* 0x04d0 */ 233, 45, 79,240,226, 77,208, 48,229,141, 48,  0,229,208, 48,  0,
/* 0x04e0 */ 229,208, 80,  2,229,208,224,  1,229,157,192,  0,229,141, 48, 20,
/* 0x04f0 */ 229,157, 48, 92,227,160, 64,  0,229,140, 64,  0,229,131, 64,  0,
/* 0x0500 */ 229,157,192, 20,229,208, 48,  1,224,140, 48,  3,227,160,204,  3,
/* 0x0510 */ 225,160,195, 28,227,160, 48,  1,225,160,238, 19,225,160, 53, 19,
/* 0x0520 */ 226,140,206,115,226, 67, 48,  1,226, 78,224,  1,226,128,  0,  4,
/* 0x0530 */ 226,140,192,  6,229,141, 16,  4,229,141, 48, 12,229,141,224, 16,
/* 0x0540 */ 229,141,  0,  8,234,  0,  0, 31,229,157,  0,  8,227,160, 27,  1,
/* 0x0550 */ 225,131, 16,176,225, 84,  0, 12,225,160, 48,132,226,132, 64,  1,
/* 0x0560 */  26,  0,  0, 28,229,157, 48,  4,227,160, 96,  0,224,131,144,  2,
/* 0x0570 */ 225,160,224,  3,225,160, 32,  6,229,157, 80,  4,224,101, 48,  9,
/* 0x0580 */ 225, 82,  0,  3,226,142,224,  1, 10,  0,  2, 73,231,210, 48,  5,
/* 0x0590 */ 226,130, 32,  1,227, 82,  0,  5,225,131,100,  6, 26,  0,  0, 40,
/* 0x05a0 */ 227,160,176,  0,227,160,192,  1,225,160,112, 11,227,224,  0,  0,
/* 0x05b0 */ 229,141,192, 44,229,141,176, 24,229,141,192, 28,229,141,192, 32,
/* 0x05c0 */ 229,141,192, 36,234,  0,  2, 57,227,224,132,255,225, 80,  0,  8,
/* 0x05d0 */ 138,  0,  0, 68,225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,
/* 0x05e0 */ 225,160,  4,  0,225,131,100,  6,229,157, 16, 12,229,157, 32, 24,
/* 0x05f0 */ 224, 11,160,  1,225,160, 18,  2,224,138, 48,  1,225,160, 80,131,
/* 0x0600 */ 229,157, 48,  8,225,147,192,181,225,160, 53,160,224,  4,  3,156,
/* 0x0610 */ 225, 86,  0,  4, 42,  0,  0,185,229,157,  0, 20,226, 96, 48,  8,
/* 0x0620 */ 225,160, 51, 87,229,157, 16, 16,224, 11, 32,  1,224,131, 48, 18,
/* 0x0630 */ 229,157,  0,  8,227,160, 44,  6,224, 34,  2,147,229,157, 16, 24,
/* 0x0640 */ 226,108, 59,  2,227, 81,  0,  6,224,140, 50,195,226,130,142,230,
/* 0x0650 */ 225,128, 48,181,226,136,128, 12,209,160,  0,  4,211,160, 16,  1,
/* 0x0660 */ 218,  0,  0,164,229,157, 32, 44,229,157, 80, 84,224, 98, 48, 11,
/* 0x0670 */ 231,213,112,  3,225,160,  0,  4,227,160, 16,  1,225,160,112,135,
/* 0x0680 */ 226,  7, 92,  1,225,160,160,129,224,136, 48,133,224,131, 48, 10,
/* 0x0690 */ 227, 80,  4,  1,226,131, 76,  2,226,129,192,  1, 42,  0,  0,119,
/* 0x06a0 */ 225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,
/* 0x06b0 */ 225,131,100,  6,225,212, 48,176,225,160, 37,160,224,129, 16, 12,
/* 0x06c0 */ 224, 12,  2,147,226, 99, 43,  2,225, 86,  0, 12,224,131, 34,194,
/* 0x06d0 */ 224, 67, 50,163, 42,  0,  0,135,227, 85,  0,  0,225,160,  0, 12,
/* 0x06e0 */ 225,196, 32,176,225,160, 16, 10, 10,  0,  0,140,225,160,  0, 12,
/* 0x06f0 */ 234,  0,  0,164,227, 85,  0,  0,225,196, 48,176,224,108, 96,  6,
/* 0x0700 */ 224,108,  0,  0, 10,  0,  0,164,227, 81,  0,255,202,  0,  0,168,
/* 0x0710 */ 234,  0,  0,105,227, 80,  4,  1,224,129, 16,  3, 42,  0,  0,151,
/* 0x0720 */ 225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,
/* 0x0730 */ 225,131,100,  6,225,152, 48,180,225,160, 37,160,224, 12,  2,147,
/* 0x0740 */ 226, 99, 43,  2,225, 86,  0, 12,224, 67, 82,163,224,131, 50,194,
/* 0x0750 */  49,136, 48,180, 33,136, 80,180,224,108,  0,  0, 49,160, 16,  4,
/* 0x0760 */  49,160,  0, 12, 32,108, 96,  6,227, 81,  0,255,225,160, 64,129,
/* 0x0770 */ 226,129, 48,  1,218,  0,  0,143,229,157,192, 24,226,  1,112,255,
/* 0x0780 */ 227, 92,  0,  3,229,157, 16, 84,211,160, 32,  0,231,193,112, 11,
/* 0x0790 */ 226,139,176,  1,213,141, 32, 24,218,  0,  2, 57,229,157, 48, 24,
/* 0x07a0 */ 227, 83,  0,  9,197,157, 80, 24,210, 67, 48,  3,194, 69, 80,  6,
/* 0x07b0 */ 213,141, 48, 24,197,141, 80, 24,234,  0,  2, 57,224, 76, 50,172,
/* 0x07c0 */ 224,100, 32,  0,229,157,192,  8,225, 82,  0,  8,225,140, 48,181,
/* 0x07d0 */ 224,100, 96,  6,138,  0,  0,197,225, 94,  0,  9, 10,  0,  2, 73,
/* 0x07e0 */ 228,222, 48,  1,225,160, 36,  2,225,131,100,  6,229,157,  0,  8,
/* 0x07f0 */ 229,157, 48, 24,224,128,112,131,226,135, 13,  6,225,208,192,176,
/* 0x0800 */ 225,160, 53,162,224,  4,  3,156,225, 86,  0,  4, 42,  0,  0,225,
/* 0x0810 */ 229,157, 32, 24,229,157, 80,  8,227, 82,  0,  6,226,108, 59,  2,
/* 0x0820 */ 226,133, 30,102,195,160, 32,  3,229,157, 80, 32,211,160, 32,  0,
/* 0x0830 */ 224,140, 50,195,229,141, 32, 24,229,157,192, 28,229,157, 32, 44,
/* 0x0840 */ 229,141, 80, 36,226,129, 16,  4,225,160, 80,  4,229,141,192, 32,
/* 0x0850 */ 229,141, 32, 28,225,192, 48,176,234,  0,  1, 98,224,100, 32,  2,
/* 0x0860 */ 224, 76, 50,172,225, 82,  0,  8,225,192, 48,176,224,100, 96,  6,
/* 0x0870 */ 138,  0,  0,236,225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,
/* 0x0880 */ 225,160, 36,  2,225,131,100,  6,226,135, 95,102,225,213,192,176,
/* 0x0890 */ 225,160, 53,162,224,  4,  3,156,225, 86,  0,  4, 42,  0,  1, 26,
/* 0x08a0 */ 226,108, 59,  2,224,140, 50,195,225, 84,  0,  8,225,197, 48,176,
/* 0x08b0 */ 138,  0,  0,252,225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,
/* 0x08c0 */ 225,160, 68,  4,225,131,100,  6,229,157, 80,  8,224,133, 48,129,
/* 0x08d0 */ 224,131, 48,138,226,131, 30, 30,225,209,192,176,225,160, 53,164,
/* 0x08e0 */ 224,  2,  3,156,225, 86,  0,  2, 32, 98, 96,  6, 32, 76, 50,172,
/* 0x08f0 */  32, 98, 80,  4, 42,  0,  1, 50,226,108, 59,  2,224,140, 50,195,
/* 0x0900 */ 227, 91,  0,  0,225,193, 48,176, 10,  0,  2, 73,229,157,192, 44,
/* 0x0910 */ 229,157, 16, 24,229,157,  0, 84,224,108, 48, 11,231,208,112,  3,
/* 0x0920 */ 227, 81,  0,  6,195,160, 16, 11,211,160, 16,  9,229,141, 16, 24,
/* 0x0930 */ 231,192,112, 11,225,160,  0,  2,226,139,176,  1,234,  0,  2, 57,
/* 0x0940 */ 224,100, 32,  2,224, 76, 50,172,225, 82,  0,  8,225,197, 48,176,
/* 0x0950 */ 224,100, 96,  6,138,  0,  1, 37,225, 94,  0,  9, 10,  0,  2, 73,
/* 0x0960 */ 228,222, 48,  1,225,160, 36,  2,225,131,100,  6,226,135, 30, 27,
/* 0x0970 */ 225,209,192,176,225,160, 53,162,224,  4,  3,156,225, 86,  0,  4,
/* 0x0980 */  42,  0,  1, 52,229,157, 80, 44,226,108, 59,  2,229,157, 32, 28,
/* 0x0990 */ 224,140, 50,195,229,141, 80, 28,225,160, 80,  4,229,141, 32, 44,
/* 0x09a0 */ 225,193, 48,176,234,  0,  1, 90,224,100, 32,  2,224, 76, 50,172,
/* 0x09b0 */ 225, 82,  0,  8,225,193, 48,176,224,100, 96,  6,138,  0,  1, 63,
/* 0x09c0 */ 225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,225,160, 36,  2,
/* 0x09d0 */ 225,131,100,  6,226,135, 31,114,225,209,192,176,225,160, 53,162,
/* 0x09e0 */ 224,  4,  3,156,225, 86,  0,  4, 42,  0,  1, 78,226,108, 59,  2,
/* 0x09f0 */ 229,157, 32, 32,224,140, 50,195,229,157,  0, 44,229,157,192, 28,
/* 0x0a00 */ 225,160, 80,  4,229,141,192, 32,229,141,  0, 28,234,  0,  1, 49,
/* 0x0a10 */ 224, 76, 50,172,225,193, 48,176,229,157,192, 44,226,141, 16, 32,
/* 0x0a20 */ 232,145,  0, 10,224,100, 80,  2,229,157, 32, 28,229,141, 16, 36,
/* 0x0a30 */ 229,141, 32, 32,229,141,192, 28,229,141, 48, 44,224,100, 96,  6,
/* 0x0a40 */ 229,157, 32, 24,229,157,  0,  8,227, 82,  0,  6,195,160, 32, 11,
/* 0x0a50 */ 211,160, 32,  8,226,128, 30,166,229,141, 32, 24,226,129, 16,  8,
/* 0x0a60 */ 227,224,116,255,225, 85,  0,  7,138,  0,  1,106,225, 94,  0,  9,
/* 0x0a70 */  10,  0,  2, 73,228,222, 48,  1,225,160, 84,  5,225,131,100,  6,
/* 0x0a80 */ 225,209,192,176,225,160, 53,165,224,  4,  3,156,225, 86,  0,  4,
/* 0x0a90 */  42,  0,  1,120,224,129, 34, 10,226,108, 59,  2,224,140, 50,195,
/* 0x0aa0 */ 226,130, 80,  4,225,160,  0,  4,227,160,160,  3,227,160,128,  0,
/* 0x0ab0 */ 225,193, 48,176,234,  0,  1,152,224,100, 32,  5,224, 76, 50,172,
/* 0x0ac0 */ 225, 82,  0,  7,224,100, 96,  6,225,193, 48,176,138,  0,  1,131,
/* 0x0ad0 */ 225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,225,160, 36,  2,
/* 0x0ae0 */ 225,131,100,  6,225,209,192,178,225,160, 53,162,224,  4,  3,156,
/* 0x0af0 */ 225, 86,  0,  4, 42,  0,  1,145,224,129, 34, 10,226,108, 59,  2,
/* 0x0b00 */ 224,140, 50,195,226,130, 95, 65,225,160,  0,  4,227,160,160,  3,
/* 0x0b10 */ 227,160,128,  8,225,193, 48,178,234,  0,  1,152,224, 76, 50,172,
/* 0x0b20 */ 225,193, 48,178,224,100, 96,  6,224,100,  0,  2,226,129, 95,129,
/* 0x0b30 */ 227,160,160,  8,227,160,128, 16,225,160,112, 10,227,160, 16,  1,
/* 0x0b40 */ 226,129, 48,  1,227, 80,  4,  1,225,160, 64,129,224,129, 16,  3,
/* 0x0b50 */  42,  0,  1,164,225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,
/* 0x0b60 */ 228,222, 48,  1,225,131,100,  6,225,149, 48,180,225,160, 37,160,
/* 0x0b70 */ 224, 12,  2,147,226, 99, 43,  2,225, 86,  0, 12,224,131, 34,194,
/* 0x0b80 */ 224, 67, 50,163,224,108,  0,  0, 49,160, 16,  4, 49,160,  0, 12,
/* 0x0b90 */  49,133, 32,180, 32,108, 96,  6, 33,133, 48,180,226, 87,112,  1,
/* 0x0ba0 */  26,  0,  1,154,227,160, 32,  1,224, 65, 58, 18,229,157, 80, 24,
/* 0x0bb0 */ 224,131, 48,  8,227, 85,  0,  3,229,141, 48, 40,202,  0,  2, 36,
/* 0x0bc0 */ 229,157,192,  8,227, 83,  0,  3,163,160, 48,  3,224,140, 51,131,
/* 0x0bd0 */ 226,131, 94, 54,225,160,112,  2,227,160,128,  6,226,135, 48,  1,
/* 0x0be0 */ 227, 80,  4,  1,225,160, 64,135,224,135,112,  3, 42,  0,  1,203,
/* 0x0bf0 */ 225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,
/* 0x0c00 */ 225,131,100,  6,225,149, 48,180,225,160, 37,160,224, 12,  2,147,
/* 0x0c10 */ 226, 99, 43,  2,225, 86,  0, 12,224,131, 34,194,224, 67, 50,163,
/* 0x0c20 */ 224,108,  0,  0, 49,160,112,  4, 49,160,  0, 12, 49,133, 32,180,
/* 0x0c30 */  32,108, 96,  6, 33,133, 48,180,226, 88,128,  1, 26,  0,  1,193,
/* 0x0c40 */ 226, 71, 32, 64,227, 82,  0,  3,209,160, 80,  2,218,  0,  2, 30,
/* 0x0c50 */ 225,160, 64,194,227, 82,  0, 13,226,  2, 48,  1,226, 68,112,  1,
/* 0x0c60 */ 227,131,192,  2,194, 68, 64,  5,193,160, 32,  8,202,  0,  1,237,
/* 0x0c70 */ 225,160, 87, 28,229,157, 16,  8,224,129, 48,133,224, 67, 48,130,
/* 0x0c80 */ 226,131, 78, 85,226,132, 64, 14,234,  0,  2,  1,227, 80,  4,  1,
/* 0x0c90 */ 226,130, 32,  1, 42,  0,  1,245,225, 94,  0,  9,225,160,  4,  0,
/* 0x0ca0 */  10,  0,  2, 73,228,222, 48,  1,225,131,100,  6,225,160,  0,160,
/* 0x0cb0 */ 225, 86,  0,  0,225,160,192,140, 32, 96, 96,  6, 35,140,192,  1,
/* 0x0cc0 */ 225, 82,  0,  4, 26,  0,  1,237,229,157, 32,  8,226,130, 77, 25,
/* 0x0cd0 */ 226,132, 64,  4,225,160, 82, 12,227,160,112,  4,227,160,160,  1,
/* 0x0ce0 */ 225,160,128, 10,227, 80,  4,  1,225,160, 16,136,226,136,192,  1,
/* 0x0cf0 */  42,  0,  2, 12,225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,
/* 0x0d00 */ 228,222, 48,  1,225,131,100,  6,225,148, 48,177,225,160, 37,160,
/* 0x0d10 */ 224,136,128, 12,224, 12,  2,147,226, 99, 43,  2,225, 86,  0, 12,
/* 0x0d20 */ 224,131, 34,194,224, 67, 50,163, 33,133, 80, 10, 49,160,128,  1,
/* 0x0d30 */  49,160,  0, 12, 49,132, 32,177, 33,132, 48,177, 32,108, 96,  6,
/* 0x0d40 */  32,108,  0,  0,226, 87,112,  1,225,160,160,138, 26,  0,  2,  3,
/* 0x0d50 */ 226,149, 80,  1,229,141, 80, 44, 10,  0,  2, 60,229,157, 48, 24,
/* 0x0d60 */ 226,131, 48,  7,229,141, 48, 24,229,157, 80, 44,225, 85,  0, 11,
/* 0x0d70 */ 138,  0,  2, 73,229,157,192, 40,229,157, 16, 84,224,101, 48, 11,
/* 0x0d80 */ 226,140, 32,  2,224,129, 64,  3,224,129,192, 11,226, 82, 32,  1,
/* 0x0d90 */ 229,157, 80, 88,  3,160, 48,  0, 19,160, 48,  1,226,139,176,  1,
/* 0x0da0 */ 225, 91,  0,  5, 35,160, 48,  0, 50,  3, 48,  1,228,212,112,  1,
/* 0x0db0 */ 227, 83,  0,  0,228,204,112,  1, 26,  0,  2, 45,229,157,192, 88,
/* 0x0dc0 */ 225, 91,  0, 12, 58,  0,  0, 60,227, 80,  4,  1, 42,  0,  2, 65,
/* 0x0dd0 */ 225, 94,  0,  9, 10,  0,  2, 73,226,142,224,  1,229,157,  0,  4,
/* 0x0de0 */ 229,157, 16,  0,229,157, 32, 92,224, 96, 48, 14,227,160,  0,  0,
/* 0x0df0 */ 229,129, 48,  0,229,130,176,  0,234,  0,  2, 74,227,160,  0,  1,
/* 0x0e00 */ 226,141,208, 48,232,189,143,240,233, 45, 79,248,224,130,192,  1,
/* 0x0e10 */ 229,157,144, 40,229,157,112, 44,225,160,128,  1,224,135,160,  9,
/* 0x0e20 */ 226,128,176,  4,229,208, 96,  0,229,208, 80,  1,229,208, 64,  2,
/* 0x0e30 */ 224,133,224,  6,227,224,112,  0,225,224, 85, 23,225,224, 68, 23,
/* 0x0e40 */ 227,160, 48,  1,227,160, 32,  1,227,160, 16,  1,227,160,  0,  1,
/* 0x0e50 */ 233, 45, 95,255,227,160, 96,  0,229,141, 96, 28,227,160, 44,  3,
/* 0x0e60 */ 225,160, 46, 18,226,130, 32, 54,226,130, 44,  7,225,160, 16, 11,
/* 0x0e70 */ 227,160, 11,  1,227,128,  3,  1,228,129,  0,  4,226, 82, 32,  2,
/* 0x0e80 */ 202,  0,  0, 26,226,136,  0,  5,235,  0,  1,  5,225, 80,  0,  8,
/* 0x0e90 */  26,  0,  0, 30,229,157, 48, 36,229,157, 32, 16,224, 73, 64,  3,
/* 0x0ea0 */ 224,  4,  0,  2,229,141,  0, 44,224,128,  2,  6,226,139, 16,  0,
/* 0x0eb0 */ 235,  0,  1,  9, 26,  0,  0, 80,229,157, 48, 20,229,157, 32, 24,
/* 0x0ec0 */ 224,  3, 48,  4,229,221,  0, 28,225,160, 50, 19,226, 98, 32,  8,
/* 0x0ed0 */ 224,131, 50, 48,226,139,160,108,224,131, 48,131,226,138,172, 14,
/* 0x0ee0 */ 227,160,  0,  1,224,138,164,131,227, 86,  0,  7, 58,  0,  0, 69,
/* 0x0ef0 */ 229,157, 16,  0,231, 89, 80,  1,225,160, 80,133,226,138, 28,  2,
/* 0x0f00 */ 226,  5, 76,  1,224,129, 16,132,235,  0,  1, 11,226,  0, 48,  1,
/* 0x0f10 */ 225, 83,  4, 36, 26,  0,  0, 71,227, 80, 12,  1, 58,  0,  0, 58,
/* 0x0f20 */ 234,  0,  0, 73,225,160, 16, 10,235,  0,  1, 11,227, 80, 12,  1,
/* 0x0f30 */  58,  0,  0, 69,227,160, 48,  6,227, 86,  0, 10, 51,160, 48,  3,
/* 0x0f40 */ 227, 86,  0,  4, 49,160, 48,  6,224, 70, 96,  3,234,  0,  0,112,
/* 0x0f50 */ 226,139, 29,  6,235,  0,  1,  8, 26,  0,  0, 95,229,157, 48,  8,
/* 0x0f60 */ 229,157, 32,  4,229,157, 16,  0,229,141, 48, 12,229,141, 32,  8,
/* 0x0f70 */ 229,141, 16,  4,227, 86,  0,  7,227,160, 96,  3, 51,160, 96,  0,
/* 0x0f80 */ 226,139,160,100,226,138,172,  6,234,  0,  0,135,226,139, 31,102,
/* 0x0f90 */ 235,  0,  1,  8, 26,  0,  0,114,229,157, 48, 44,226,139, 30, 30,
/* 0x0fa0 */ 224,131,  2,  6,235,  0,  1,  9, 26,  0,  0,130,227, 86,  0,  7,
/* 0x0fb0 */ 227,160, 96, 11, 51,160, 96,  9,229,157, 48, 36,229,157, 16,  0,
/* 0x0fc0 */ 224, 73, 64,  3,225, 84,  0,  1, 58,  0,  0,253,231, 89,  0,  1,
/* 0x0fd0 */ 228,201,  0,  1,234,  0,  0,237,226,139, 30, 27,235,  0,  1,  8,
/* 0x0fe0 */ 229,157, 64,  4, 10,  0,  0,127,226,139, 31,114,235,  0,  1,  8,
/* 0x0ff0 */ 229,157, 64,  8, 10,  0,  0,125,229,157, 48,  8,229,157, 64, 12,
/* 0x1000 */ 229,141, 48, 12,229,157, 48,  4,229,141, 48,  8,229,157, 16,  0,
/* 0x1010 */ 229,141, 64,  0,229,141, 16,  4,227, 86,  0,  7,227,160, 96, 11,
/* 0x1020 */  51,160, 96,  8,226,139,160,104,226,138,172, 10,226,138, 16,  0,
/* 0x1030 */ 235,  0,  1, 10, 26,  0,  0,144,229,157, 48, 44,226,138, 80,  4,
/* 0x1040 */ 227,160, 32,  0,224,133, 82,  3,227,160, 64,  8,234,  0,  0,156,
/* 0x1050 */ 226,138, 16,  2,235,  0,  1, 10, 26,  0,  0,153,229,157, 48, 44,
/* 0x1060 */ 226,138, 95, 65,227,160, 32,  8,224,133, 82,  3,227,160, 64,  8,
/* 0x1070 */ 234,  0,  0,156,226,138, 95,129,227,160, 32, 16,227,160, 76,  1,
/* 0x1080 */ 229,141, 32, 52,227,160,  0,  1,225,160, 16,  5,235,  0,  1, 11,
/* 0x1090 */ 224, 80, 48,  4, 58,  0,  0,158,229,157, 80, 52,224,133, 80,  3,
/* 0x10a0 */ 229,141, 80, 52,229,157, 16,  0,227, 86,  0,  4, 42,  0,  0,225,
/* 0x10b0 */ 226,134, 96,  7,227, 85,  0,  4, 35,160, 80,  3,224,139, 83,133,
/* 0x10c0 */ 226,133, 94, 54,227,160,  0,  1,227,160, 64, 64,225,160, 16,  5,
/* 0x10d0 */ 235,  0,  1, 11,224, 80, 48,  4, 58,  0,  0,175,229,141, 48, 44,
/* 0x10e0 */ 227, 83,  0,  4, 58,  0,  0,221,225,160, 64,163,226, 68, 64,  1,
/* 0x10f0 */ 226,  3, 16,  1,227,129, 16,  2,227, 83,  0, 14, 42,  0,  0,194,
/* 0x1100 */ 225,160, 20, 17,226,139,160, 94,224, 65, 48,  3,226,138,172,  5,
/* 0x1110 */ 224,138,160,131,234,  0,  0,206,226, 68, 64,  4,235,  0,  0,255,
/* 0x1120 */ 225,160,112,167,225, 92,  0,  7, 32, 76,192,  7,224,161, 16,  1,
/* 0x1130 */ 226, 84, 64,  1, 26,  0,  0,195,226,139,160, 68,226,138,172,  6,
/* 0x1140 */ 225,160, 18,  1,227,160, 64,  4,229,141, 16,  0,227,160, 80,  1,
/* 0x1150 */ 227,160,  0,  1,225,160, 16, 10,235,  0,  1, 11,227, 16,  0,  1,
/* 0x1160 */  10,  0,  0,216,229,157, 16,  0,225,129, 16,  5,229,141, 16,  0,
/* 0x1170 */ 225,160, 80,133,226, 84, 64,  1, 26,  0,  0,209,229,157, 16,  0,
/* 0x1180 */ 234,  0,  0,222,229,157, 16, 44,226,145, 16,  1,229,141, 16,  0,
/* 0x1190 */ 229,157, 80, 52,229,157, 48, 36,226,133, 80,  2,224, 73, 48,  3,
/* 0x11a0 */ 225, 81,  0,  3,138,  0,  0,253,229,157, 32, 40,231, 89,  0,  1,
/* 0x11b0 */ 228,201,  0,  1,225, 89,  0,  2, 42,  0,  0,241,226, 85, 80,  1,
/* 0x11c0 */  26,  0,  0,231,229,205,  0, 28,229,157, 32, 40,225, 89,  0,  2,
/* 0x11d0 */  58,  0,  0, 33,235,  0,  0,255,227,160,  0,  0,229,157, 32, 32,
/* 0x11e0 */ 224, 72, 48,  2,229,157, 32, 56,229,130, 48,  0,229,157, 32, 36,
/* 0x11f0 */ 224, 73, 48,  2,229,157, 32,104,229,130, 48,  0,226,141,208, 60,
/* 0x1200 */ 232,189,143,240,227,160,  0,  1,234,  0,  0,243,227, 87,  4,  1,
/* 0x1210 */  33,160,240, 14,229,157, 48, 48,225,160,116,  7,225, 83,  0,  8,
/* 0x1220 */  10,  0,  0,253,228,216, 48,  1,225,131,196, 12,225,160,240, 14,
/* 0x1230 */ 225,160,  0,  6,224,129, 16,128,227,160,  0,  0,224,129, 16,128,
/* 0x1240 */ 227, 87,  4,  1,225,160, 32, 14, 59,  0,  1,  1,225,209, 48,176,
/* 0x1250 */ 225,160,229,167,224, 14, 14,147,225, 92,  0, 14, 49,160,112, 14,
/* 0x1260 */  32, 71,112, 14, 50, 99,235,  2, 32, 76,192, 14, 48,131, 50,174,
/* 0x1270 */  32, 67, 50,163,224,176,  0,  0,225,193, 48,176,225,160,240,  2,
/* 0x1280 */ 227,160, 32, 30,226,143, 16, 12,227,160,  0,  2,239,144,  0,  4,
/* 0x1290 */ 227,160,  0,127,239,144,  0,  1, 80, 82, 79, 84, 95, 69, 88, 69,
/* 0x12a0 */  67,124, 80, 82, 79, 84, 95, 87, 82, 73, 84, 69, 32,102, 97,105,
/* 0x12b0 */ 108,101,100, 46, 10,  0,102,105,108,101, 32,102,111,114,109, 97,
/* 0x12c0 */ 116, 32,101,108,102, 51, 50, 45, 98,105,103, 97,114,109, 10, 10,
/* 0x12d0 */  83,101, 99,116,105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,
/* 0x12e0 */ 109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101,
/* 0x12f0 */  32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32,
/* 0x1300 */  76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,
/* 0x1310 */ 102,102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,103,115, 10,
/* 0x1320 */  32, 32, 48, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 32, 32, 32,
/* 0x1330 */  32, 32, 48, 48, 48, 48, 48, 48, 51, 52, 32, 32, 48, 48, 48, 48,
/* 0x1340 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1350 */  48, 48, 48, 48, 48, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1360 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x1370 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 49, 32, 76, 85,
/* 0x1380 */  78, 77, 80, 48, 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x1390 */  48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x13a0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x13b0 */  54, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x13c0 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 50,
/* 0x13d0 */  32, 76, 85, 78, 77, 80, 48, 48, 49, 32, 32, 32, 32, 32, 32, 48,
/* 0x13e0 */  48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x13f0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1400 */  48, 48, 48, 54, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1410 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x1420 */  32, 32, 51, 32, 69, 76, 70, 77, 65, 73, 78, 88,117, 32, 32, 32,
/* 0x1430 */  32, 32, 48, 48, 48, 48, 48, 48, 57, 56, 32, 32, 48, 48, 48, 48,
/* 0x1440 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1450 */  48, 48, 48, 48, 48, 48, 55, 48, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1460 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x1470 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 52, 32, 78, 82,
/* 0x1480 */  86, 95, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x1490 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x14a0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,
/* 0x14b0 */  48, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x14c0 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 53,
/* 0x14d0 */  32, 78, 82, 86, 95, 84, 65, 73, 76, 32, 32, 32, 32, 32, 32, 48,
/* 0x14e0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x14f0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1500 */  48, 48, 49, 48, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1510 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x1520 */  32, 32, 54, 32, 78, 82, 86, 50, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x1530 */  32, 32, 48, 48, 48, 48, 48, 49, 50, 99, 32, 32, 48, 48, 48, 48,
/* 0x1540 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1550 */  48, 48, 48, 48, 48, 49, 48, 56, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1560 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x1570 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 55, 32, 78, 82,
/* 0x1580 */  86, 50, 68, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x1590 */  48, 49, 49, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x15a0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50,
/* 0x15b0 */  51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x15c0 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x15d0 */  78, 76, 89, 10, 32, 32, 56, 32, 78, 82, 86, 50, 66, 32, 32, 32,
/* 0x15e0 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,100, 99, 32, 32,
/* 0x15f0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1600 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 52, 99, 32, 32, 50, 42,
/* 0x1610 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x1620 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32,
/* 0x1630 */  57, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32,
/* 0x1640 */  48, 48, 48, 48, 48, 48, 97, 56, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1650 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1660 */  48, 48, 48, 52, 50, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1670 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x1680 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 48, 32, 76, 90, 77, 65,
/* 0x1690 */  95, 68, 69, 67, 50, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 57,
/* 0x16a0 */  51, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x16b0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52,100, 48,
/* 0x16c0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x16d0 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x16e0 */  89, 10, 32, 49, 49, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x16f0 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 52, 55, 56, 32, 32, 48, 48,
/* 0x1700 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1710 */  32, 32, 48, 48, 48, 48, 48,101, 48, 56, 32, 32, 50, 42, 42, 48,
/* 0x1720 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x1730 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 50, 32,
/* 0x1740 */  76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 48,
/* 0x1750 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1760 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1770 */  49, 50, 56, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1780 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x1790 */  49, 51, 32, 69, 76, 70, 77, 65, 73, 78, 89, 32, 32, 32, 32, 32,
/* 0x17a0 */  32, 48, 48, 48, 48, 48, 48, 51, 54, 32, 32, 48, 48, 48, 48, 48,
/* 0x17b0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x17c0 */  48, 48, 48, 49, 50, 56, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x17d0 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x17e0 */  89, 10, 32, 49, 52, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 32,
/* 0x17f0 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1800 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1810 */  32, 32, 48, 48, 48, 48, 49, 50, 98, 54, 32, 32, 50, 42, 42, 48,
/* 0x1820 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x1830 */  79, 78, 76, 89, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76,
/* 0x1840 */  69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x1850 */  32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,117,  9, 48, 48,
/* 0x1860 */  48, 48, 48, 48, 48, 48, 32, 69, 76, 70, 77, 65, 73, 78, 88,117,
/* 0x1870 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x1880 */  32, 32, 78, 82, 86, 50, 69,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1890 */  32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x18a0 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 68,  9, 48, 48,
/* 0x18b0 */  48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48,
/* 0x18c0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82,
/* 0x18d0 */  86, 50, 66,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86,
/* 0x18e0 */  50, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x18f0 */  32,100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,  9, 48,
/* 0x1900 */  48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70,
/* 0x1910 */  48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x1920 */  32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,  9, 48,
/* 0x1930 */  48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x1940 */  50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x1950 */  32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  9, 48,
/* 0x1960 */  48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x1970 */  49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x1980 */  32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,  9, 48,
/* 0x1990 */  48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x19a0 */  51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x19b0 */  32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 89,  9, 48, 48, 48,
/* 0x19c0 */  48, 48, 48, 48, 48, 32, 69, 76, 70, 77, 65, 73, 78, 89, 10, 48,
/* 0x19d0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x19e0 */  69, 76, 70, 77, 65, 73, 78, 88,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x19f0 */  48, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48,
/* 0x1a00 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 85, 78, 77,
/* 0x1a10 */  80, 48, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 85,
/* 0x1a20 */  78, 77, 80, 48, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1a30 */ 108, 32, 32, 32, 32,100, 32, 32, 76, 85, 78, 77, 80, 48, 48, 49,
/* 0x1a40 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 85, 78, 77, 80, 48,
/* 0x1a50 */  48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x1a60 */  32,100, 32, 32, 78, 82, 86, 95, 72, 69, 65, 68,  9, 48, 48, 48,
/* 0x1a70 */  48, 48, 48, 48, 48, 32, 78, 82, 86, 95, 72, 69, 65, 68, 10, 48,
/* 0x1a80 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x1a90 */  78, 82, 86, 95, 84, 65, 73, 76,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x1aa0 */  48, 32, 78, 82, 86, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48,
/* 0x1ab0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77,
/* 0x1ac0 */  65, 73, 78, 90,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 76,
/* 0x1ad0 */  70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1ae0 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48,
/* 0x1af0 */  48, 48, 48, 48, 48, 48, 32, 65, 68, 82, 77, 10, 48, 48, 48, 48,
/* 0x1b00 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x1b10 */  68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 69, 78, 70,
/* 0x1b20 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,
/* 0x1b30 */  32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1b40 */  32, 67, 80, 82, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1b50 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48,
/* 0x1b60 */  48, 48, 48, 48, 48, 32, 77, 70, 76, 71, 10, 48, 48, 48, 48, 48,
/* 0x1b70 */  48, 49, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x1b80 */  65, 73, 78, 88,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 95,115,
/* 0x1b90 */ 116, 97,114,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32,
/* 0x1ba0 */  32, 32, 32, 32, 70, 32, 78, 82, 86, 50, 69,  9, 48, 48, 48, 48,
/* 0x1bb0 */  48, 49, 50, 99, 32,117, 99,108, 95,110,114,118, 50,101, 95,100,
/* 0x1bc0 */ 101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48,
/* 0x1bd0 */  48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 78, 82, 86,
/* 0x1be0 */  50, 68,  9, 48, 48, 48, 48, 48, 49, 49, 56, 32,117, 99,108, 95,
/* 0x1bf0 */ 110,114,118, 50,100, 95,100,101, 99,111,109,112,114,101,115,115,
/* 0x1c00 */  95, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32,
/* 0x1c10 */  32, 32, 70, 32, 78, 82, 86, 50, 66,  9, 48, 48, 48, 48, 48, 48,
/* 0x1c20 */ 100, 99, 32,117, 99,108, 95,110,114,118, 50, 98, 95,100,101, 99,
/* 0x1c30 */ 111,109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48,
/* 0x1c40 */  48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x1c50 */  68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x1c60 */ 122,109, 97, 68,101, 99,111,100,101, 10, 48, 48, 48, 48, 48, 48,
/* 0x1c70 */  48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x1c80 */  73, 78, 89,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,101,110,100,
/* 0x1c90 */  95,100,101, 99,111,109,112,114,101,115,115, 10, 48, 48, 48, 48,
/* 0x1ca0 */  48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x1cb0 */  77, 65, 73, 78, 90,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,
/* 0x1cc0 */ 112,114, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x1cd0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 76, 70,
/* 0x1ce0 */  77, 65, 73, 78, 88, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x1cf0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1d00 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d10 */  48, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32, 32,
/* 0x1d20 */  32, 32, 32, 32, 65, 68, 82, 77, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d30 */  52, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32, 32,
/* 0x1d40 */  32, 32, 32, 32, 76, 69, 78, 70, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d50 */  56, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32, 32,
/* 0x1d60 */  32, 32, 32, 32, 67, 80, 82, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d70 */  99, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32, 32,
/* 0x1d80 */  32, 32, 32, 32, 77, 70, 76, 71, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x1d90 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x1da0 */  32, 91, 69, 76, 70, 77, 65, 73, 78, 88,117, 93, 58, 10, 79, 70,
/* 0x1db0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x1dc0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x1dd0 */  48, 48, 48, 48, 48, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x1de0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x1df0 */  78, 89, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32, 82, 95, 65, 82,
/* 0x1e00 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x1e10 */  70, 77, 65, 73, 78, 88,117, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x1e20 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x1e30 */  91, 78, 82, 86, 50, 69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x1e40 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1e50 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x1e60 */  49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x1e70 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48,
/* 0x1e80 */  48, 53, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x1e90 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48,
/* 0x1ea0 */  48, 48, 54, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x1eb0 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48,
/* 0x1ec0 */  48, 48, 48, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x1ed0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48,
/* 0x1ee0 */  48, 48, 48, 48, 55, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x1ef0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48,
/* 0x1f00 */  48, 48, 48, 48, 48, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x1f10 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10,
/* 0x1f20 */  48, 48, 48, 48, 48, 48, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x1f30 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69,
/* 0x1f40 */  10, 48, 48, 48, 48, 48, 48, 57, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x1f50 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x1f60 */  69, 10, 48, 48, 48, 48, 48, 48, 57, 99, 32, 82, 95, 65, 82, 77,
/* 0x1f70 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x1f80 */  50, 69, 10, 48, 48, 48, 48, 48, 48, 97, 99, 32, 82, 95, 65, 82,
/* 0x1f90 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x1fa0 */  86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 98, 52, 32, 82, 95, 65,
/* 0x1fb0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x1fc0 */  82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 98, 56, 32, 82, 95,
/* 0x1fd0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1fe0 */  78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 99, 48, 32, 82,
/* 0x1ff0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2000 */  32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 99, 52, 32,
/* 0x2010 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2020 */  32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,100, 48,
/* 0x2030 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2040 */  32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,100,
/* 0x2050 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2060 */  32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x2070 */ 100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2080 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48,
/* 0x2090 */  48,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x20a0 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48,
/* 0x20b0 */  48, 48,101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x20c0 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48,
/* 0x20d0 */  48, 48, 48,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x20e0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48,
/* 0x20f0 */  48, 48, 48, 48,102, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2100 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48,
/* 0x2110 */  48, 48, 48, 48, 49, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2120 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10,
/* 0x2130 */  48, 48, 48, 48, 48, 49, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2140 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69,
/* 0x2150 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x2160 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 68, 93,
/* 0x2170 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x2180 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x2190 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 65, 82,
/* 0x21a0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x21b0 */  86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 53, 99, 32, 82, 95, 65,
/* 0x21c0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x21d0 */  82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 54, 48, 32, 82, 95,
/* 0x21e0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x21f0 */  78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 54, 56, 32, 82,
/* 0x2200 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2210 */  32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 55, 52, 32,
/* 0x2220 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2230 */  32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 56, 48,
/* 0x2240 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2250 */  32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 56,
/* 0x2260 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2270 */  32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x2280 */  57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2290 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48,
/* 0x22a0 */  48, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x22b0 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48,
/* 0x22c0 */  48, 48, 97, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x22d0 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48,
/* 0x22e0 */  48, 48, 48, 98, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x22f0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48,
/* 0x2300 */  48, 48, 48, 48, 98, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2310 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48,
/* 0x2320 */  48, 48, 48, 48, 48, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2330 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10,
/* 0x2340 */  48, 48, 48, 48, 48, 48,100, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2350 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68,
/* 0x2360 */  10, 48, 48, 48, 48, 48, 48,100, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x2370 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x2380 */  68, 10, 48, 48, 48, 48, 48, 48,101, 56, 32, 82, 95, 65, 82, 77,
/* 0x2390 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x23a0 */  50, 68, 10, 48, 48, 48, 48, 48, 48,101, 99, 32, 82, 95, 65, 82,
/* 0x23b0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x23c0 */  86, 50, 68, 10, 48, 48, 48, 48, 48, 49, 49, 48, 32, 82, 95, 65,
/* 0x23d0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x23e0 */  82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 49, 49, 52, 32, 82, 95,
/* 0x23f0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2400 */  78, 82, 86, 50, 68, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x2410 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x2420 */  82, 86, 50, 66, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x2430 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2440 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 48,
/* 0x2450 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2460 */  32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 54,
/* 0x2470 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2480 */  32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48,
/* 0x2490 */  54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x24a0 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48,
/* 0x24b0 */  48, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x24c0 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48,
/* 0x24d0 */  48, 48, 55, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x24e0 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48,
/* 0x24f0 */  48, 48, 48, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2500 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48,
/* 0x2510 */  48, 48, 48, 48, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2520 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48,
/* 0x2530 */  48, 48, 48, 48, 48, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2540 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10,
/* 0x2550 */  48, 48, 48, 48, 48, 48, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2560 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66,
/* 0x2570 */  10, 48, 48, 48, 48, 48, 48, 97, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x2580 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x2590 */  66, 10, 48, 48, 48, 48, 48, 48, 97, 99, 32, 82, 95, 65, 82, 77,
/* 0x25a0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x25b0 */  50, 66, 10, 48, 48, 48, 48, 48, 48, 98, 52, 32, 82, 95, 65, 82,
/* 0x25c0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x25d0 */  86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 98, 56, 32, 82, 95, 65,
/* 0x25e0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x25f0 */  82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48,100, 52, 32, 82, 95,
/* 0x2600 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2610 */  78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48,100, 56, 32, 82,
/* 0x2620 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2630 */  32, 78, 82, 86, 50, 66, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x2640 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x2650 */  76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 93, 58, 10, 79, 70, 70,
/* 0x2660 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x2670 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x2680 */  48, 48, 48, 48, 48, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2690 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x26a0 */  67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 52, 99, 32, 82, 95, 65,
/* 0x26b0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x26c0 */  90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x26d0 */  56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x26e0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10,
/* 0x26f0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x2700 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69,
/* 0x2710 */  67, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x2720 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2730 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 55, 52, 32,
/* 0x2740 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2750 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x2760 */  48, 48, 48, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2770 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2780 */  50, 48, 10, 48, 48, 48, 48, 48, 48, 98, 56, 32, 82, 95, 65, 82,
/* 0x2790 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x27a0 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 99,
/* 0x27b0 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x27c0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x27d0 */  48, 48, 48, 48, 48,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x27e0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x27f0 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49, 48, 48, 32, 82, 95,
/* 0x2800 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2810 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x2820 */  49, 48, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2830 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x2840 */  10, 48, 48, 48, 48, 48, 49, 52, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x2850 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2860 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49, 57, 48, 32,
/* 0x2870 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2880 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x2890 */  48, 48, 49, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x28a0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x28b0 */  50, 48, 10, 48, 48, 48, 48, 48, 49,100, 56, 32, 82, 95, 65, 82,
/* 0x28c0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x28d0 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 48,
/* 0x28e0 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x28f0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x2900 */  48, 48, 48, 48, 50, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2910 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x2920 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 50, 48, 32, 82, 95,
/* 0x2930 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2940 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x2950 */  50, 51, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2960 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x2970 */  10, 48, 48, 48, 48, 48, 50, 51, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x2980 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2990 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 52, 48, 32,
/* 0x29a0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x29b0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x29c0 */  48, 48, 50, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x29d0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x29e0 */  50, 48, 10, 48, 48, 48, 48, 48, 50, 53, 56, 32, 82, 95, 65, 82,
/* 0x29f0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x2a00 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 97,
/* 0x2a10 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2a20 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x2a30 */  48, 48, 48, 48, 50, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2a40 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x2a50 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50,101, 56, 32, 82, 95,
/* 0x2a60 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2a70 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x2a80 */  51, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2a90 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x2aa0 */  10, 48, 48, 48, 48, 48, 51, 48, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x2ab0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2ac0 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 51, 99, 32,
/* 0x2ad0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2ae0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x2af0 */  48, 48, 51, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2b00 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2b10 */  50, 48, 10, 48, 48, 48, 48, 48, 51, 97, 48, 32, 82, 95, 65, 82,
/* 0x2b20 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x2b30 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 97,
/* 0x2b40 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2b50 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x2b60 */  48, 48, 48, 48, 51, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2b70 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x2b80 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51,101, 48, 32, 82, 95,
/* 0x2b90 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2ba0 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x2bb0 */  51,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2bc0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x2bd0 */  10, 48, 48, 48, 48, 48, 52, 50, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x2be0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2bf0 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 51, 56, 32,
/* 0x2c00 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2c10 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x2c20 */  48, 48, 52, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2c30 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2c40 */  50, 48, 10, 48, 48, 48, 48, 48, 52, 56, 52, 32, 82, 95, 65, 82,
/* 0x2c50 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x2c60 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 56,
/* 0x2c70 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2c80 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x2c90 */  48, 48, 48, 48, 52, 98, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2ca0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x2cb0 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52,100, 52, 32, 82, 95,
/* 0x2cc0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2cd0 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x2ce0 */  52,101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2cf0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x2d00 */  10, 48, 48, 48, 48, 48, 52,102, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x2d10 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2d20 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 49, 56, 32,
/* 0x2d30 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2d40 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x2d50 */  48, 48, 53, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2d60 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2d70 */  50, 48, 10, 48, 48, 48, 48, 48, 53, 57, 56, 32, 82, 95, 65, 82,
/* 0x2d80 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x2d90 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 97,
/* 0x2da0 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2db0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x2dc0 */  48, 48, 48, 48, 53, 99, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2dd0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x2de0 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53,101, 52, 32, 82, 95,
/* 0x2df0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2e00 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x2e10 */  53,102, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2e20 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x2e30 */  10, 48, 48, 48, 48, 48, 54, 48, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x2e40 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2e50 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54, 50, 52, 32,
/* 0x2e60 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2e70 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x2e80 */  48, 48, 54, 52, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2e90 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2ea0 */  50, 48, 10, 48, 48, 48, 48, 48, 54, 56, 48, 32, 82, 95, 65, 82,
/* 0x2eb0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x2ec0 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54, 56,
/* 0x2ed0 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2ee0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x2ef0 */  48, 48, 48, 48, 54,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2f00 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x2f10 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54,101, 99, 32, 82, 95,
/* 0x2f20 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2f30 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x2f40 */  55, 49, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2f50 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x2f60 */  10, 48, 48, 48, 48, 48, 55, 50, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x2f70 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2f80 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 54, 99, 32,
/* 0x2f90 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2fa0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x2fb0 */  48, 48, 55, 55, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2fc0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2fd0 */  50, 48, 10, 48, 48, 48, 48, 48, 55, 57, 99, 32, 82, 95, 65, 82,
/* 0x2fe0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x2ff0 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 98,
/* 0x3000 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3010 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x3020 */  48, 48, 48, 48, 55, 99, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3030 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3040 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55,100, 48, 32, 82, 95,
/* 0x3050 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3060 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x3070 */  55,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3080 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x3090 */  10, 48, 48, 48, 48, 48, 56, 50, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x30a0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x30b0 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56, 50, 99, 32,
/* 0x30c0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x30d0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x30e0 */  48, 48, 56, 55, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x30f0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3100 */  50, 48, 10, 48, 48, 48, 48, 48, 56, 56, 56, 32, 82, 95, 65, 82,
/* 0x3110 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x3120 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56, 97,
/* 0x3130 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3140 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x3150 */  48, 48, 48, 48, 56,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3160 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3170 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56,102, 52, 32, 82, 95,
/* 0x3180 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3190 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x31a0 */  56,102, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x31b0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x31c0 */  10, 48, 48, 48, 48, 48, 57, 48, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x31d0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x31e0 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 57, 50, 56, 32,
/* 0x31f0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3200 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 10, 82, 69,
/* 0x3210 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x3220 */  32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x3230 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x3240 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x3250 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65,
/* 0x3260 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x3270 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3280 */  56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3290 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x32a0 */  48, 48, 48, 48, 48, 48, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x32b0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x32c0 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 97, 56, 32, 82,
/* 0x32d0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x32e0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x32f0 */  48, 48, 97, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3300 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x3310 */  48, 10, 48, 48, 48, 48, 48, 48,101, 52, 32, 82, 95, 65, 82, 77,
/* 0x3320 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x3330 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 48, 48,
/* 0x3340 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3350 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x3360 */  48, 48, 48, 49, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3370 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3380 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 49, 52, 32, 82, 95, 65,
/* 0x3390 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x33a0 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49,
/* 0x33b0 */  49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x33c0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x33d0 */  48, 48, 48, 48, 48, 49, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x33e0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x33f0 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 50, 56, 32, 82,
/* 0x3400 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3410 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x3420 */  48, 49, 52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3430 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x3440 */  48, 10, 48, 48, 48, 48, 48, 49, 52, 99, 32, 82, 95, 65, 82, 77,
/* 0x3450 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x3460 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 53, 48,
/* 0x3470 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3480 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x3490 */  48, 48, 48, 49, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x34a0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x34b0 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 56, 56, 32, 82, 95, 65,
/* 0x34c0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x34d0 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49,
/* 0x34e0 */  56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x34f0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x3500 */  48, 48, 48, 48, 48, 49, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3510 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x3520 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 97, 48, 32, 82,
/* 0x3530 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3540 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x3550 */  48, 49, 99, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3560 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x3570 */  48, 10, 48, 48, 48, 48, 48, 49, 99, 99, 32, 82, 95, 65, 82, 77,
/* 0x3580 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x3590 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49,100, 52,
/* 0x35a0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x35b0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x35c0 */  48, 48, 48, 49,100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x35d0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x35e0 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 49,101, 52, 32, 82, 95, 65,
/* 0x35f0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x3600 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49,
/* 0x3610 */ 101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3620 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x3630 */  48, 48, 48, 48, 48, 50, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3640 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x3650 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 50, 99, 32, 82,
/* 0x3660 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3670 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x3680 */  48, 50, 52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3690 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x36a0 */  48, 10, 48, 48, 48, 48, 48, 50, 52, 99, 32, 82, 95, 65, 82, 77,
/* 0x36b0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x36c0 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 53, 48,
/* 0x36d0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x36e0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x36f0 */  48, 48, 48, 50, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3700 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3710 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 56, 52, 32, 82, 95, 65,
/* 0x3720 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x3730 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50,
/* 0x3740 */  56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3750 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x3760 */  48, 48, 48, 48, 48, 50, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3770 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x3780 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 99, 56, 32, 82,
/* 0x3790 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x37a0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x37b0 */  48, 50,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x37c0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x37d0 */  48, 10, 48, 48, 48, 48, 48, 50,100, 99, 32, 82, 95, 65, 82, 77,
/* 0x37e0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x37f0 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50,102, 52,
/* 0x3800 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3810 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x3820 */  48, 48, 48, 51, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3830 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3840 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 49, 52, 32, 82, 95, 65,
/* 0x3850 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x3860 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51,
/* 0x3870 */  50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3880 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x3890 */  48, 48, 48, 48, 48, 51, 53, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x38a0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x38b0 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 53, 56, 32, 82,
/* 0x38c0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x38d0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x38e0 */  48, 51, 55, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x38f0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x3900 */  48, 10, 48, 48, 48, 48, 48, 51, 55, 56, 32, 82, 95, 65, 82, 77,
/* 0x3910 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x3920 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 57, 99,
/* 0x3930 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3940 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x3950 */  48, 48, 48, 51, 98, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3960 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3970 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 98, 56, 32, 82, 95, 65,
/* 0x3980 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x3990 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51,
/* 0x39a0 */  99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x39b0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x39c0 */  48, 48, 48, 48, 48, 51, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x39d0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x39e0 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52, 48, 48, 32, 82,
/* 0x39f0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3a00 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x3a10 */  48, 52, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3a20 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x3a30 */  48, 10, 48, 48, 48, 48, 48, 52, 52, 48, 32, 82, 95, 65, 82, 77,
/* 0x3a40 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x3a50 */  65, 95, 68, 69, 67, 49, 48, 10
};
