/* armeb.v4a-linux.elf-entry.h
   created from armeb.v4a-linux.elf-entry.bin, 13848 (0x3618) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2023 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2023 Laszlo Molnar
   Copyright (C) 2000-2023 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_ARMEB_V4A_LINUX_ELF_ENTRY_SIZE    13848
#define STUB_ARMEB_V4A_LINUX_ELF_ENTRY_ADLER32 0xbee041d2
#define STUB_ARMEB_V4A_LINUX_ELF_ENTRY_CRC32   0x6fdb8360

unsigned char stub_armeb_v4a_linux_elf_entry[13848] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  2,  1, 97,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   0,  1,  0, 40,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0, 19, 84,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,
/* 0x0030 */   0,  0,  0,  0,  0,  0,  0,  0,226, 77,208, 24,235,  0,  0, 43,
/* 0x0040 */ 233, 45, 64,252,224,129,112,  0,227,224, 80,  0,227,160, 65,  2,
/* 0x0050 */ 234,  0,  0, 20,232,189,  0, 24,224, 64,  0,  7,224, 66, 32,  3,
/* 0x0060 */ 229,132, 32,  0,225,160, 64,  0,225,160,  0,  3,224,131, 16,  2,
/* 0x0070 */ 227,160, 32,  0,239,159,  0,  2,225,160,  0,  4,232,189,128,240,
/* 0x0080 */ 228,208, 64,  1,224,164, 64,  4,225,176, 76,  4,225,160,240, 14,
/* 0x0090 */ 228,208, 48,  1,228,194, 48,  1,224,148, 64,  4, 11,  0,  0, 14,
/* 0x00a0 */  42,  0,  0, 18,227,160, 16,  1,234,  0,  0, 29,226, 65, 16,  1,
/* 0x00b0 */ 224,148, 64,  4, 11,  0,  0, 14,224,161, 16,  1,224,148, 64,  4,
/* 0x00c0 */  11,  0,  0, 14,224,161, 16,  1,224,148, 64,  4, 11,  0,  0, 14,
/* 0x00d0 */  58,  0,  0, 25,226, 81, 48,  3,227,160, 16,  0, 58,  0,  0, 45,
/* 0x00e0 */ 228,208, 80,  1,225,133, 84,  3,225,240, 80,  5, 10,  0,  0,  3,
/* 0x00f0 */ 225,176, 80,197, 42,  0,  0, 60,234,  0,  0, 48,224,148, 64,  4,
/* 0x0100 */  11,  0,  0, 14, 42,  0,  0, 60,227,160, 16,  1,224,148, 64,  4,
/* 0x0110 */  11,  0,  0, 14, 42,  0,  0, 60,224,148, 64,  4, 11,  0,  0, 14,
/* 0x0120 */ 224,161, 16,  1,224,148, 64,  4, 11,  0,  0, 14, 58,  0,  0, 52,
/* 0x0130 */ 226,129, 16,  4,234,  0,  0, 64,224,148, 64,  4, 11,  0,  0, 14,
/* 0x0140 */ 224,161, 16,  1,226,129, 16,  2,227,117, 12,  5, 50,129, 16,  1,
/* 0x0150 */ 224,130, 48,  1,229, 83, 48,  1,231,210, 48,  5,228,194, 48,  1,
/* 0x0160 */ 226, 81, 16,  1, 26,  0,  0, 68,234,  0,  0, 20,233, 45, 64,252,
/* 0x0170 */ 224,129,112,  0,227,224, 80,  0,227,160, 65,  2,234,  0,  0, 20,
/* 0x0180 */ 232,189,  0, 24,224, 64,  0,  7,224, 66, 32,  3,229,132, 32,  0,
/* 0x0190 */ 225,160, 64,  0,225,160,  0,  3,224,131, 16,  2,227,160, 32,  0,
/* 0x01a0 */ 239,159,  0,  2,225,160,  0,  4,232,189,128,240,228,208, 64,  1,
/* 0x01b0 */ 224,164, 64,  4,225,176, 76,  4,225,160,240, 14,228,208, 48,  1,
/* 0x01c0 */ 228,194, 48,  1,224,148, 64,  4, 11,  0,  0, 14, 42,  0,  0, 18,
/* 0x01d0 */ 227,160, 16,  1,234,  0,  0, 29,226, 65, 16,  1,224,148, 64,  4,
/* 0x01e0 */  11,  0,  0, 14,224,177, 16,  1,224,148, 64,  4, 11,  0,  0, 14,
/* 0x01f0 */ 224,177, 16,  1,224,148, 64,  4, 11,  0,  0, 14, 58,  0,  0, 25,
/* 0x0200 */ 226, 81, 48,  3,227,160, 16,  0, 58,  0,  0, 44,228,208, 80,  1,
/* 0x0210 */ 225,133, 84,  3,225,240, 80,  5, 10,  0,  0,  3,225,176, 80,197,
/* 0x0220 */ 234,  0,  0, 46,224,148, 64,  4, 11,  0,  0, 14,224,177, 16,  1,
/* 0x0230 */ 224,148, 64,  4, 11,  0,  0, 14,224,177, 16,  1, 26,  0,  0, 59,
/* 0x0240 */ 227,160, 16,  1,224,148, 64,  4, 11,  0,  0, 14,224,177, 16,  1,
/* 0x0250 */ 224,148, 64,  4, 11,  0,  0, 14, 58,  0,  0, 52,226,129, 16,  2,
/* 0x0260 */ 226,129, 16,  1,227,117, 12,  5, 50,129, 16,  1,229,210, 48,  0,
/* 0x0270 */ 231,210, 48,  5,228,194, 48,  1,226, 81, 16,  1, 26,  0,  0, 63,
/* 0x0280 */ 234,  0,  0, 20,224,129, 16,  0,233, 45, 64, 62,227,224, 80,  0,
/* 0x0290 */ 227,160, 65,  2,234,  0,  0, 29,232,189,  0, 26,224, 64,  0,  1,
/* 0x02a0 */ 224, 66, 32,  3,229,132, 32,  0,225,160, 64,  0,225,160,  0,  3,
/* 0x02b0 */ 224,131, 16,  2,227,160, 32,  0,239,159,  0,  2,225,160,  0,  4,
/* 0x02c0 */ 232,189,128, 48,224,148, 64,  4, 17,160,240, 14,228,208, 64,  1,
/* 0x02d0 */ 224,164, 64,  4,225,176, 76,  4,225,160,240, 14,227,160, 16,  1,
/* 0x02e0 */ 225,160,192, 14,235,  0,  0, 14,224,177, 16,  1,235,  0,  0, 14,
/* 0x02f0 */  58,  0,  0, 22,225,160,240, 12,228,208, 48,  1,228,194, 48,  1,
/* 0x0300 */ 235,  0,  0, 14, 42,  0,  0, 27,235,  0,  0, 20,226, 81, 48,  3,
/* 0x0310 */ 227,160, 16,  0, 58,  0,  0, 39,228,208, 80,  1,225,133, 84,  3,
/* 0x0320 */ 225,240, 80,  5, 10,  0,  0,  3,235,  0,  0, 14,224,177, 16,  1,
/* 0x0330 */ 235,  0,  0, 14,224,177, 16,  1, 26,  0,  0, 46,235,  0,  0, 20,
/* 0x0340 */ 226,129, 16,  2,227,117, 12, 13, 50,129, 16,  1,231,210, 48,  5,
/* 0x0350 */ 226, 81, 16,  1,228,194, 48,  1, 42,  0,  0, 48,234,  0,  0, 29,
/* 0x0360 */ 229,157,192,  0,227, 92,  0, 14, 26,  0,  0, 40,233, 45, 72, 12,
/* 0x0370 */ 229,208,176,  0,227,160,204,  6,225,160,177,171,225,160,203, 28,
/* 0x0380 */ 225,160,176, 13,226,140,205, 58,224, 77,208, 12,229,147,192,  0,
/* 0x0390 */ 229,141, 48,  8,229,141,192,  4,229,141, 32,  0,226,141, 48, 12,
/* 0x03a0 */ 227,160,192,  0,228,131,192,  4,225, 83,  0, 11, 26,  0,  0, 15,
/* 0x03b0 */ 226,141, 48, 12,226, 65, 32,  2,225,160, 16,  0,228,209,192,  1,
/* 0x03c0 */ 226, 12,192,  7,229,205,192, 18,228,209,192,  1,225,160,  2, 44,
/* 0x03d0 */ 229,205,  0, 17,226, 12,192, 15,229,205,192, 16,226,141,  0, 16,
/* 0x03e0 */ 235,  0,  0, 41,225,160,208, 11,225,160, 48,  0,232,189,  0,  3,
/* 0x03f0 */ 229,145, 16,  0,224,129, 16,  0,227,160, 32,  0,239,159,  0,  2,
/* 0x0400 */ 225,160,  0,  3,232,189,136,  0,231,240,  1,240,233, 45, 79,240,
/* 0x0410 */ 226, 77,208, 48,229,141, 48,  0,229,208, 48,  0,229,208, 80,  2,
/* 0x0420 */ 229,208,224,  1,229,157,192,  0,229,141, 48, 20,229,157, 48, 92,
/* 0x0430 */ 227,160, 64,  0,229,140, 64,  0,229,131, 64,  0,229,157,192, 20,
/* 0x0440 */ 229,208, 48,  1,224,140, 48,  3,227,160,204,  3,225,160,195, 28,
/* 0x0450 */ 227,160, 48,  1,225,160,238, 19,225,160, 53, 19,226,140,206,115,
/* 0x0460 */ 226, 67, 48,  1,226, 78,224,  1,226,128,  0,  4,226,140,192,  6,
/* 0x0470 */ 229,141, 16,  4,229,141, 48, 12,229,141,224, 16,229,141,  0,  8,
/* 0x0480 */ 234,  0,  0, 31,229,157,  0,  8,227,160, 27,  1,225,131, 16,176,
/* 0x0490 */ 225, 84,  0, 12,225,160, 48,132,226,132, 64,  1, 26,  0,  0, 28,
/* 0x04a0 */ 229,157, 48,  4,227,160, 96,  0,224,131,144,  2,225,160,224,  3,
/* 0x04b0 */ 225,160, 32,  6,229,157, 80,  4,224,101, 48,  9,225, 82,  0,  3,
/* 0x04c0 */ 226,142,224,  1, 10,  0,  2, 73,231,210, 48,  5,226,130, 32,  1,
/* 0x04d0 */ 227, 82,  0,  5,225,131,100,  6, 26,  0,  0, 40,227,160,176,  0,
/* 0x04e0 */ 227,160,192,  1,225,160,112, 11,227,224,  0,  0,229,141,192, 44,
/* 0x04f0 */ 229,141,176, 24,229,141,192, 28,229,141,192, 32,229,141,192, 36,
/* 0x0500 */ 234,  0,  2, 57,227,224,132,255,225, 80,  0,  8,138,  0,  0, 68,
/* 0x0510 */ 225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,225,160,  4,  0,
/* 0x0520 */ 225,131,100,  6,229,157, 16, 12,229,157, 32, 24,224, 11,160,  1,
/* 0x0530 */ 225,160, 18,  2,224,138, 48,  1,225,160, 80,131,229,157, 48,  8,
/* 0x0540 */ 225,147,192,181,225,160, 53,160,224,  4,  3,156,225, 86,  0,  4,
/* 0x0550 */  42,  0,  0,185,229,157,  0, 20,226, 96, 48,  8,225,160, 51, 87,
/* 0x0560 */ 229,157, 16, 16,224, 11, 32,  1,224,131, 48, 18,229,157,  0,  8,
/* 0x0570 */ 227,160, 44,  6,224, 34,  2,147,229,157, 16, 24,226,108, 59,  2,
/* 0x0580 */ 227, 81,  0,  6,224,140, 50,195,226,130,142,230,225,128, 48,181,
/* 0x0590 */ 226,136,128, 12,209,160,  0,  4,211,160, 16,  1,218,  0,  0,164,
/* 0x05a0 */ 229,157, 32, 44,229,157, 80, 84,224, 98, 48, 11,231,213,112,  3,
/* 0x05b0 */ 225,160,  0,  4,227,160, 16,  1,225,160,112,135,226,  7, 92,  1,
/* 0x05c0 */ 225,160,160,129,224,136, 48,133,224,131, 48, 10,227, 80,  4,  1,
/* 0x05d0 */ 226,131, 76,  2,226,129,192,  1, 42,  0,  0,119,225, 94,  0,  9,
/* 0x05e0 */ 225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,225,131,100,  6,
/* 0x05f0 */ 225,212, 48,176,225,160, 37,160,224,129, 16, 12,224, 12,  2,147,
/* 0x0600 */ 226, 99, 43,  2,225, 86,  0, 12,224,131, 34,194,224, 67, 50,163,
/* 0x0610 */  42,  0,  0,135,227, 85,  0,  0,225,160,  0, 12,225,196, 32,176,
/* 0x0620 */ 225,160, 16, 10, 10,  0,  0,140,225,160,  0, 12,234,  0,  0,164,
/* 0x0630 */ 227, 85,  0,  0,225,196, 48,176,224,108, 96,  6,224,108,  0,  0,
/* 0x0640 */  10,  0,  0,164,227, 81,  0,255,202,  0,  0,168,234,  0,  0,105,
/* 0x0650 */ 227, 80,  4,  1,224,129, 16,  3, 42,  0,  0,151,225, 94,  0,  9,
/* 0x0660 */ 225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,225,131,100,  6,
/* 0x0670 */ 225,152, 48,180,225,160, 37,160,224, 12,  2,147,226, 99, 43,  2,
/* 0x0680 */ 225, 86,  0, 12,224, 67, 82,163,224,131, 50,194, 49,136, 48,180,
/* 0x0690 */  33,136, 80,180,224,108,  0,  0, 49,160, 16,  4, 49,160,  0, 12,
/* 0x06a0 */  32,108, 96,  6,227, 81,  0,255,225,160, 64,129,226,129, 48,  1,
/* 0x06b0 */ 218,  0,  0,143,229,157,192, 24,226,  1,112,255,227, 92,  0,  3,
/* 0x06c0 */ 229,157, 16, 84,211,160, 32,  0,231,193,112, 11,226,139,176,  1,
/* 0x06d0 */ 213,141, 32, 24,218,  0,  2, 57,229,157, 48, 24,227, 83,  0,  9,
/* 0x06e0 */ 197,157, 80, 24,210, 67, 48,  3,194, 69, 80,  6,213,141, 48, 24,
/* 0x06f0 */ 197,141, 80, 24,234,  0,  2, 57,224, 76, 50,172,224,100, 32,  0,
/* 0x0700 */ 229,157,192,  8,225, 82,  0,  8,225,140, 48,181,224,100, 96,  6,
/* 0x0710 */ 138,  0,  0,197,225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,
/* 0x0720 */ 225,160, 36,  2,225,131,100,  6,229,157,  0,  8,229,157, 48, 24,
/* 0x0730 */ 224,128,112,131,226,135, 13,  6,225,208,192,176,225,160, 53,162,
/* 0x0740 */ 224,  4,  3,156,225, 86,  0,  4, 42,  0,  0,225,229,157, 32, 24,
/* 0x0750 */ 229,157, 80,  8,227, 82,  0,  6,226,108, 59,  2,226,133, 30,102,
/* 0x0760 */ 195,160, 32,  3,229,157, 80, 32,211,160, 32,  0,224,140, 50,195,
/* 0x0770 */ 229,141, 32, 24,229,157,192, 28,229,157, 32, 44,229,141, 80, 36,
/* 0x0780 */ 226,129, 16,  4,225,160, 80,  4,229,141,192, 32,229,141, 32, 28,
/* 0x0790 */ 225,192, 48,176,234,  0,  1, 98,224,100, 32,  2,224, 76, 50,172,
/* 0x07a0 */ 225, 82,  0,  8,225,192, 48,176,224,100, 96,  6,138,  0,  0,236,
/* 0x07b0 */ 225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,225,160, 36,  2,
/* 0x07c0 */ 225,131,100,  6,226,135, 95,102,225,213,192,176,225,160, 53,162,
/* 0x07d0 */ 224,  4,  3,156,225, 86,  0,  4, 42,  0,  1, 26,226,108, 59,  2,
/* 0x07e0 */ 224,140, 50,195,225, 84,  0,  8,225,197, 48,176,138,  0,  0,252,
/* 0x07f0 */ 225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,225,160, 68,  4,
/* 0x0800 */ 225,131,100,  6,229,157, 80,  8,224,133, 48,129,224,131, 48,138,
/* 0x0810 */ 226,131, 30, 30,225,209,192,176,225,160, 53,164,224,  2,  3,156,
/* 0x0820 */ 225, 86,  0,  2, 32, 98, 96,  6, 32, 76, 50,172, 32, 98, 80,  4,
/* 0x0830 */  42,  0,  1, 50,226,108, 59,  2,224,140, 50,195,227, 91,  0,  0,
/* 0x0840 */ 225,193, 48,176, 10,  0,  2, 73,229,157,192, 44,229,157, 16, 24,
/* 0x0850 */ 229,157,  0, 84,224,108, 48, 11,231,208,112,  3,227, 81,  0,  6,
/* 0x0860 */ 195,160, 16, 11,211,160, 16,  9,229,141, 16, 24,231,192,112, 11,
/* 0x0870 */ 225,160,  0,  2,226,139,176,  1,234,  0,  2, 57,224,100, 32,  2,
/* 0x0880 */ 224, 76, 50,172,225, 82,  0,  8,225,197, 48,176,224,100, 96,  6,
/* 0x0890 */ 138,  0,  1, 37,225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,
/* 0x08a0 */ 225,160, 36,  2,225,131,100,  6,226,135, 30, 27,225,209,192,176,
/* 0x08b0 */ 225,160, 53,162,224,  4,  3,156,225, 86,  0,  4, 42,  0,  1, 52,
/* 0x08c0 */ 229,157, 80, 44,226,108, 59,  2,229,157, 32, 28,224,140, 50,195,
/* 0x08d0 */ 229,141, 80, 28,225,160, 80,  4,229,141, 32, 44,225,193, 48,176,
/* 0x08e0 */ 234,  0,  1, 90,224,100, 32,  2,224, 76, 50,172,225, 82,  0,  8,
/* 0x08f0 */ 225,193, 48,176,224,100, 96,  6,138,  0,  1, 63,225, 94,  0,  9,
/* 0x0900 */  10,  0,  2, 73,228,222, 48,  1,225,160, 36,  2,225,131,100,  6,
/* 0x0910 */ 226,135, 31,114,225,209,192,176,225,160, 53,162,224,  4,  3,156,
/* 0x0920 */ 225, 86,  0,  4, 42,  0,  1, 78,226,108, 59,  2,229,157, 32, 32,
/* 0x0930 */ 224,140, 50,195,229,157,  0, 44,229,157,192, 28,225,160, 80,  4,
/* 0x0940 */ 229,141,192, 32,229,141,  0, 28,234,  0,  1, 49,224, 76, 50,172,
/* 0x0950 */ 225,193, 48,176,229,157,192, 44,226,141, 16, 32,232,145,  0, 10,
/* 0x0960 */ 224,100, 80,  2,229,157, 32, 28,229,141, 16, 36,229,141, 32, 32,
/* 0x0970 */ 229,141,192, 28,229,141, 48, 44,224,100, 96,  6,229,157, 32, 24,
/* 0x0980 */ 229,157,  0,  8,227, 82,  0,  6,195,160, 32, 11,211,160, 32,  8,
/* 0x0990 */ 226,128, 30,166,229,141, 32, 24,226,129, 16,  8,227,224,116,255,
/* 0x09a0 */ 225, 85,  0,  7,138,  0,  1,106,225, 94,  0,  9, 10,  0,  2, 73,
/* 0x09b0 */ 228,222, 48,  1,225,160, 84,  5,225,131,100,  6,225,209,192,176,
/* 0x09c0 */ 225,160, 53,165,224,  4,  3,156,225, 86,  0,  4, 42,  0,  1,120,
/* 0x09d0 */ 224,129, 34, 10,226,108, 59,  2,224,140, 50,195,226,130, 80,  4,
/* 0x09e0 */ 225,160,  0,  4,227,160,160,  3,227,160,128,  0,225,193, 48,176,
/* 0x09f0 */ 234,  0,  1,152,224,100, 32,  5,224, 76, 50,172,225, 82,  0,  7,
/* 0x0a00 */ 224,100, 96,  6,225,193, 48,176,138,  0,  1,131,225, 94,  0,  9,
/* 0x0a10 */  10,  0,  2, 73,228,222, 48,  1,225,160, 36,  2,225,131,100,  6,
/* 0x0a20 */ 225,209,192,178,225,160, 53,162,224,  4,  3,156,225, 86,  0,  4,
/* 0x0a30 */  42,  0,  1,145,224,129, 34, 10,226,108, 59,  2,224,140, 50,195,
/* 0x0a40 */ 226,130, 95, 65,225,160,  0,  4,227,160,160,  3,227,160,128,  8,
/* 0x0a50 */ 225,193, 48,178,234,  0,  1,152,224, 76, 50,172,225,193, 48,178,
/* 0x0a60 */ 224,100, 96,  6,224,100,  0,  2,226,129, 95,129,227,160,160,  8,
/* 0x0a70 */ 227,160,128, 16,225,160,112, 10,227,160, 16,  1,226,129, 48,  1,
/* 0x0a80 */ 227, 80,  4,  1,225,160, 64,129,224,129, 16,  3, 42,  0,  1,164,
/* 0x0a90 */ 225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,
/* 0x0aa0 */ 225,131,100,  6,225,149, 48,180,225,160, 37,160,224, 12,  2,147,
/* 0x0ab0 */ 226, 99, 43,  2,225, 86,  0, 12,224,131, 34,194,224, 67, 50,163,
/* 0x0ac0 */ 224,108,  0,  0, 49,160, 16,  4, 49,160,  0, 12, 49,133, 32,180,
/* 0x0ad0 */  32,108, 96,  6, 33,133, 48,180,226, 87,112,  1, 26,  0,  1,154,
/* 0x0ae0 */ 227,160, 32,  1,224, 65, 58, 18,229,157, 80, 24,224,131, 48,  8,
/* 0x0af0 */ 227, 85,  0,  3,229,141, 48, 40,202,  0,  2, 36,229,157,192,  8,
/* 0x0b00 */ 227, 83,  0,  3,163,160, 48,  3,224,140, 51,131,226,131, 94, 54,
/* 0x0b10 */ 225,160,112,  2,227,160,128,  6,226,135, 48,  1,227, 80,  4,  1,
/* 0x0b20 */ 225,160, 64,135,224,135,112,  3, 42,  0,  1,203,225, 94,  0,  9,
/* 0x0b30 */ 225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,225,131,100,  6,
/* 0x0b40 */ 225,149, 48,180,225,160, 37,160,224, 12,  2,147,226, 99, 43,  2,
/* 0x0b50 */ 225, 86,  0, 12,224,131, 34,194,224, 67, 50,163,224,108,  0,  0,
/* 0x0b60 */  49,160,112,  4, 49,160,  0, 12, 49,133, 32,180, 32,108, 96,  6,
/* 0x0b70 */  33,133, 48,180,226, 88,128,  1, 26,  0,  1,193,226, 71, 32, 64,
/* 0x0b80 */ 227, 82,  0,  3,209,160, 80,  2,218,  0,  2, 30,225,160, 64,194,
/* 0x0b90 */ 227, 82,  0, 13,226,  2, 48,  1,226, 68,112,  1,227,131,192,  2,
/* 0x0ba0 */ 194, 68, 64,  5,193,160, 32,  8,202,  0,  1,237,225,160, 87, 28,
/* 0x0bb0 */ 229,157, 16,  8,224,129, 48,133,224, 67, 48,130,226,131, 78, 85,
/* 0x0bc0 */ 226,132, 64, 14,234,  0,  2,  1,227, 80,  4,  1,226,130, 32,  1,
/* 0x0bd0 */  42,  0,  1,245,225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,
/* 0x0be0 */ 228,222, 48,  1,225,131,100,  6,225,160,  0,160,225, 86,  0,  0,
/* 0x0bf0 */ 225,160,192,140, 32, 96, 96,  6, 35,140,192,  1,225, 82,  0,  4,
/* 0x0c00 */  26,  0,  1,237,229,157, 32,  8,226,130, 77, 25,226,132, 64,  4,
/* 0x0c10 */ 225,160, 82, 12,227,160,112,  4,227,160,160,  1,225,160,128, 10,
/* 0x0c20 */ 227, 80,  4,  1,225,160, 16,136,226,136,192,  1, 42,  0,  2, 12,
/* 0x0c30 */ 225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,
/* 0x0c40 */ 225,131,100,  6,225,148, 48,177,225,160, 37,160,224,136,128, 12,
/* 0x0c50 */ 224, 12,  2,147,226, 99, 43,  2,225, 86,  0, 12,224,131, 34,194,
/* 0x0c60 */ 224, 67, 50,163, 33,133, 80, 10, 49,160,128,  1, 49,160,  0, 12,
/* 0x0c70 */  49,132, 32,177, 33,132, 48,177, 32,108, 96,  6, 32,108,  0,  0,
/* 0x0c80 */ 226, 87,112,  1,225,160,160,138, 26,  0,  2,  3,226,149, 80,  1,
/* 0x0c90 */ 229,141, 80, 44, 10,  0,  2, 60,229,157, 48, 24,226,131, 48,  7,
/* 0x0ca0 */ 229,141, 48, 24,229,157, 80, 44,225, 85,  0, 11,138,  0,  2, 73,
/* 0x0cb0 */ 229,157,192, 40,229,157, 16, 84,224,101, 48, 11,226,140, 32,  2,
/* 0x0cc0 */ 224,129, 64,  3,224,129,192, 11,226, 82, 32,  1,229,157, 80, 88,
/* 0x0cd0 */   3,160, 48,  0, 19,160, 48,  1,226,139,176,  1,225, 91,  0,  5,
/* 0x0ce0 */  35,160, 48,  0, 50,  3, 48,  1,228,212,112,  1,227, 83,  0,  0,
/* 0x0cf0 */ 228,204,112,  1, 26,  0,  2, 45,229,157,192, 88,225, 91,  0, 12,
/* 0x0d00 */  58,  0,  0, 60,227, 80,  4,  1, 42,  0,  2, 65,225, 94,  0,  9,
/* 0x0d10 */  10,  0,  2, 73,226,142,224,  1,229,157,  0,  4,229,157, 16,  0,
/* 0x0d20 */ 229,157, 32, 92,224, 96, 48, 14,227,160,  0,  0,229,129, 48,  0,
/* 0x0d30 */ 229,130,176,  0,234,  0,  2, 74,227,160,  0,  1,226,141,208, 48,
/* 0x0d40 */ 232,189,143,240,233, 45, 79,248,224,130,192,  1,229,157,144, 40,
/* 0x0d50 */ 229,157,112, 44,225,160,128,  1,224,135,160,  9,226,128,176,  4,
/* 0x0d60 */ 229,208, 96,  0,229,208, 80,  1,229,208, 64,  2,224,133,224,  6,
/* 0x0d70 */ 227,224,112,  0,225,224, 85, 23,225,224, 68, 23,227,160, 48,  1,
/* 0x0d80 */ 227,160, 32,  1,227,160, 16,  1,227,160,  0,  1,233, 45, 95,255,
/* 0x0d90 */ 227,160, 96,  0,229,141, 96, 28,227,160, 44,  3,225,160, 46, 18,
/* 0x0da0 */ 226,130, 32, 54,226,130, 44,  7,225,160, 16, 11,227,160, 11,  1,
/* 0x0db0 */ 227,128,  3,  1,228,129,  0,  4,226, 82, 32,  2,202,  0,  0, 26,
/* 0x0dc0 */ 226,136,  0,  5,235,  0,  1,  5,225, 80,  0,  8, 26,  0,  0, 30,
/* 0x0dd0 */ 229,157, 48, 36,229,157, 32, 16,224, 73, 64,  3,224,  4,  0,  2,
/* 0x0de0 */ 229,141,  0, 44,224,128,  2,  6,226,139, 16,  0,235,  0,  1,  9,
/* 0x0df0 */  26,  0,  0, 80,229,157, 48, 20,229,157, 32, 24,224,  3, 48,  4,
/* 0x0e00 */ 229,221,  0, 28,225,160, 50, 19,226, 98, 32,  8,224,131, 50, 48,
/* 0x0e10 */ 226,139,160,108,224,131, 48,131,226,138,172, 14,227,160,  0,  1,
/* 0x0e20 */ 224,138,164,131,227, 86,  0,  7, 58,  0,  0, 69,229,157, 16,  0,
/* 0x0e30 */ 231, 89, 80,  1,225,160, 80,133,226,138, 28,  2,226,  5, 76,  1,
/* 0x0e40 */ 224,129, 16,132,235,  0,  1, 11,226,  0, 48,  1,225, 83,  4, 36,
/* 0x0e50 */  26,  0,  0, 71,227, 80, 12,  1, 58,  0,  0, 58,234,  0,  0, 73,
/* 0x0e60 */ 225,160, 16, 10,235,  0,  1, 11,227, 80, 12,  1, 58,  0,  0, 69,
/* 0x0e70 */ 227,160, 48,  6,227, 86,  0, 10, 51,160, 48,  3,227, 86,  0,  4,
/* 0x0e80 */  49,160, 48,  6,224, 70, 96,  3,234,  0,  0,112,226,139, 29,  6,
/* 0x0e90 */ 235,  0,  1,  8, 26,  0,  0, 95,229,157, 48,  8,229,157, 32,  4,
/* 0x0ea0 */ 229,157, 16,  0,229,141, 48, 12,229,141, 32,  8,229,141, 16,  4,
/* 0x0eb0 */ 227, 86,  0,  7,227,160, 96,  3, 51,160, 96,  0,226,139,160,100,
/* 0x0ec0 */ 226,138,172,  6,234,  0,  0,135,226,139, 31,102,235,  0,  1,  8,
/* 0x0ed0 */  26,  0,  0,114,229,157, 48, 44,226,139, 30, 30,224,131,  2,  6,
/* 0x0ee0 */ 235,  0,  1,  9, 26,  0,  0,130,227, 86,  0,  7,227,160, 96, 11,
/* 0x0ef0 */  51,160, 96,  9,229,157, 48, 36,229,157, 16,  0,224, 73, 64,  3,
/* 0x0f00 */ 225, 84,  0,  1, 58,  0,  0,253,231, 89,  0,  1,228,201,  0,  1,
/* 0x0f10 */ 234,  0,  0,237,226,139, 30, 27,235,  0,  1,  8,229,157, 64,  4,
/* 0x0f20 */  10,  0,  0,127,226,139, 31,114,235,  0,  1,  8,229,157, 64,  8,
/* 0x0f30 */  10,  0,  0,125,229,157, 48,  8,229,157, 64, 12,229,141, 48, 12,
/* 0x0f40 */ 229,157, 48,  4,229,141, 48,  8,229,157, 16,  0,229,141, 64,  0,
/* 0x0f50 */ 229,141, 16,  4,227, 86,  0,  7,227,160, 96, 11, 51,160, 96,  8,
/* 0x0f60 */ 226,139,160,104,226,138,172, 10,226,138, 16,  0,235,  0,  1, 10,
/* 0x0f70 */  26,  0,  0,144,229,157, 48, 44,226,138, 80,  4,227,160, 32,  0,
/* 0x0f80 */ 224,133, 82,  3,227,160, 64,  8,234,  0,  0,156,226,138, 16,  2,
/* 0x0f90 */ 235,  0,  1, 10, 26,  0,  0,153,229,157, 48, 44,226,138, 95, 65,
/* 0x0fa0 */ 227,160, 32,  8,224,133, 82,  3,227,160, 64,  8,234,  0,  0,156,
/* 0x0fb0 */ 226,138, 95,129,227,160, 32, 16,227,160, 76,  1,229,141, 32, 52,
/* 0x0fc0 */ 227,160,  0,  1,225,160, 16,  5,235,  0,  1, 11,224, 80, 48,  4,
/* 0x0fd0 */  58,  0,  0,158,229,157, 80, 52,224,133, 80,  3,229,141, 80, 52,
/* 0x0fe0 */ 229,157, 16,  0,227, 86,  0,  4, 42,  0,  0,225,226,134, 96,  7,
/* 0x0ff0 */ 227, 85,  0,  4, 35,160, 80,  3,224,139, 83,133,226,133, 94, 54,
/* 0x1000 */ 227,160,  0,  1,227,160, 64, 64,225,160, 16,  5,235,  0,  1, 11,
/* 0x1010 */ 224, 80, 48,  4, 58,  0,  0,175,229,141, 48, 44,227, 83,  0,  4,
/* 0x1020 */  58,  0,  0,221,225,160, 64,163,226, 68, 64,  1,226,  3, 16,  1,
/* 0x1030 */ 227,129, 16,  2,227, 83,  0, 14, 42,  0,  0,194,225,160, 20, 17,
/* 0x1040 */ 226,139,160, 94,224, 65, 48,  3,226,138,172,  5,224,138,160,131,
/* 0x1050 */ 234,  0,  0,206,226, 68, 64,  4,235,  0,  0,255,225,160,112,167,
/* 0x1060 */ 225, 92,  0,  7, 32, 76,192,  7,224,161, 16,  1,226, 84, 64,  1,
/* 0x1070 */  26,  0,  0,195,226,139,160, 68,226,138,172,  6,225,160, 18,  1,
/* 0x1080 */ 227,160, 64,  4,229,141, 16,  0,227,160, 80,  1,227,160,  0,  1,
/* 0x1090 */ 225,160, 16, 10,235,  0,  1, 11,227, 16,  0,  1, 10,  0,  0,216,
/* 0x10a0 */ 229,157, 16,  0,225,129, 16,  5,229,141, 16,  0,225,160, 80,133,
/* 0x10b0 */ 226, 84, 64,  1, 26,  0,  0,209,229,157, 16,  0,234,  0,  0,222,
/* 0x10c0 */ 229,157, 16, 44,226,145, 16,  1,229,141, 16,  0,229,157, 80, 52,
/* 0x10d0 */ 229,157, 48, 36,226,133, 80,  2,224, 73, 48,  3,225, 81,  0,  3,
/* 0x10e0 */ 138,  0,  0,253,229,157, 32, 40,231, 89,  0,  1,228,201,  0,  1,
/* 0x10f0 */ 225, 89,  0,  2, 42,  0,  0,241,226, 85, 80,  1, 26,  0,  0,231,
/* 0x1100 */ 229,205,  0, 28,229,157, 32, 40,225, 89,  0,  2, 58,  0,  0, 33,
/* 0x1110 */ 235,  0,  0,255,227,160,  0,  0,229,157, 32, 32,224, 72, 48,  2,
/* 0x1120 */ 229,157, 32, 56,229,130, 48,  0,229,157, 32, 36,224, 73, 48,  2,
/* 0x1130 */ 229,157, 32,104,229,130, 48,  0,226,141,208, 60,232,189,143,240,
/* 0x1140 */ 227,160,  0,  1,234,  0,  0,243,227, 87,  4,  1, 33,160,240, 14,
/* 0x1150 */ 229,157, 48, 48,225,160,116,  7,225, 83,  0,  8, 10,  0,  0,253,
/* 0x1160 */ 228,216, 48,  1,225,131,196, 12,225,160,240, 14,225,160,  0,  6,
/* 0x1170 */ 224,129, 16,128,227,160,  0,  0,224,129, 16,128,227, 87,  4,  1,
/* 0x1180 */ 225,160, 32, 14, 59,  0,  1,  1,225,209, 48,176,225,160,229,167,
/* 0x1190 */ 224, 14, 14,147,225, 92,  0, 14, 49,160,112, 14, 32, 71,112, 14,
/* 0x11a0 */  50, 99,235,  2, 32, 76,192, 14, 48,131, 50,174, 32, 67, 50,163,
/* 0x11b0 */ 224,176,  0,  0,225,193, 48,176,225,160,240,  2,229,141, 48, 20,
/* 0x11c0 */ 226,142, 96,  4,227,160, 80,  0,227,224, 64,  0,227,160, 32,  3,
/* 0x11d0 */ 229,150, 16,  0,227,160,  0,  0,229,141, 16, 12,239,144,  0,192,
/* 0x11e0 */ 229,141,  0,  8,229,150, 48,  0,229, 45, 48,  4,225,160, 48, 13,
/* 0x11f0 */ 225,160, 32,  0,229,214,  0,  8,229, 45,  0,  4,229,150, 16,  4,
/* 0x1200 */ 226,134,  0, 12,225,160,160,  2,225,160,224, 15,229,157,240, 24,
/* 0x1210 */ 226,141,208,  4,228,157, 48,  4,229,157, 16, 20,228,138, 16,  4,
/* 0x1220 */ 227,160, 32,  5,229,157, 16, 12,229,157,  0,  8,239,144,  0,125,
/* 0x1230 */ 229,157,  0,  0,229, 22, 16,  4,224,128, 80,  1,224, 73, 64,  1,
/* 0x1240 */ 226,143,224,  0,225,160,240, 10, 47,112,114,111, 99, 47,115,101,
/* 0x1250 */ 108,102, 47,101,120,101,  0,  0,227,160, 32, 14,226, 79, 16, 28,
/* 0x1260 */ 227,160,  0,  2,239,144,  0,  4,227,160,  0,127,239,144,  0,  1,
/* 0x1270 */ 229, 30,  0, 16,226, 78, 96, 16,229,141,224, 16,224, 70, 96,  0,
/* 0x1280 */ 229,141, 96,  0,225,160,144,  0,226, 79,  0, 72,227,160, 16,  0,
/* 0x1290 */ 239,144,  0,  5,227, 80,  0,  0,186,  0,  0, 37,229,141,  0,  4,
/* 0x12a0 */ 229, 30, 48, 12,235,255,255,254,  0,  0,  0,  0,102,105,108,101,
/* 0x12b0 */  32,102,111,114,109, 97,116, 32,101,108,102, 51, 50, 45, 98,105,
/* 0x12c0 */ 103, 97,114,109, 10, 10, 83,101, 99,116,105,111,110,115, 58, 10,
/* 0x12d0 */  73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x12e0 */  32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32,
/* 0x12f0 */  32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32,
/* 0x1300 */  70,105,108,101, 32,111,102,102, 32, 32, 65,108,103,110, 32, 32,
/* 0x1310 */  70,108, 97,103,115, 10, 32, 32, 48, 32, 69, 76, 70, 77, 65, 73,
/* 0x1320 */  78, 88, 32, 32, 32, 32, 32, 32, 48, 99, 32, 32, 48, 32, 32, 48,
/* 0x1330 */  32, 32, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1340 */  84, 69, 78, 84, 83, 10, 32, 32, 49, 32, 78, 82, 86, 95, 72, 69,
/* 0x1350 */  65, 68, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32,
/* 0x1360 */  32, 48, 52, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1370 */  69, 78, 84, 83, 10, 32, 32, 50, 32, 78, 82, 86, 95, 84, 65, 73,
/* 0x1380 */  76, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x1390 */  48, 52, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x13a0 */  78, 84, 83, 10, 32, 32, 51, 32, 78, 82, 86, 50, 69, 32, 32, 32,
/* 0x13b0 */  32, 32, 32, 32, 32, 32, 48, 49, 50, 99, 32, 32, 48, 32, 32, 48,
/* 0x13c0 */  32, 32, 48, 52, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x13d0 */  84, 69, 78, 84, 83, 10, 32, 32, 52, 32, 78, 82, 86, 50, 68, 32,
/* 0x13e0 */  32, 32, 32, 32, 32, 32, 32, 32, 48, 49, 49, 56, 32, 32, 48, 32,
/* 0x13f0 */  32, 48, 32, 32, 48, 49, 54, 99, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1400 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 53, 32, 78, 82, 86,
/* 0x1410 */  50, 66, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48,100, 99, 32, 32,
/* 0x1420 */  48, 32, 32, 48, 32, 32, 48, 50, 56, 52, 32, 32, 50, 42, 42, 48,
/* 0x1430 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 54, 32, 76,
/* 0x1440 */  90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32, 48, 97, 99,
/* 0x1450 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 54, 48, 32, 32, 50, 42,
/* 0x1460 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 55,
/* 0x1470 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32, 32, 48,
/* 0x1480 */  57, 51, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 52, 48, 99, 32,
/* 0x1490 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x14a0 */  32, 32, 56, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 32,
/* 0x14b0 */  32, 32, 48, 52, 55, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48,100,
/* 0x14c0 */  52, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x14d0 */  84, 83, 10, 32, 32, 57, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51,
/* 0x14e0 */  48, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x14f0 */  49, 98, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1500 */  78, 84, 83, 10, 32, 49, 48, 32, 69, 76, 70, 77, 65, 73, 78, 89,
/* 0x1510 */  32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x1520 */  49, 49, 98, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1530 */  69, 78, 84, 83, 10, 32, 49, 49, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x1540 */  90, 32, 32, 32, 32, 32, 32, 48,102, 48, 32, 32, 48, 32, 32, 48,
/* 0x1550 */  32, 32, 48, 49, 49, 98, 99, 32, 32, 50, 42, 42, 50, 32, 32, 67,
/* 0x1560 */  79, 78, 84, 69, 78, 84, 83, 10, 83, 89, 77, 66, 79, 76, 32, 84,
/* 0x1570 */  65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x1580 */  32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69, 32, 48, 32, 78,
/* 0x1590 */  82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x15a0 */  32, 32, 32,100, 32, 32, 78, 82, 86, 50, 68, 32, 48, 32, 78, 82,
/* 0x15b0 */  86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x15c0 */  32, 32,100, 32, 32, 78, 82, 86, 50, 66, 32, 48, 32, 78, 82, 86,
/* 0x15d0 */  50, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x15e0 */  32,100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 48,
/* 0x15f0 */  32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48,
/* 0x1600 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77,
/* 0x1610 */  65, 95, 68, 69, 67, 50, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68,
/* 0x1620 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x1630 */  32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x1640 */  32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x1650 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69,
/* 0x1660 */  76, 70, 77, 65, 73, 78, 90, 32, 48, 32, 69, 76, 70, 77, 65, 73,
/* 0x1670 */  78, 90, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x1680 */  32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 48, 32, 69,
/* 0x1690 */  76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x16a0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 95, 72, 69, 65,
/* 0x16b0 */  68, 32, 48, 32, 78, 82, 86, 95, 72, 69, 65, 68, 10, 48, 48, 48,
/* 0x16c0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82,
/* 0x16d0 */  86, 95, 84, 65, 73, 76, 32, 48, 32, 78, 82, 86, 95, 84, 65, 73,
/* 0x16e0 */  76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x16f0 */ 100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 48, 32,
/* 0x1700 */  76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48,
/* 0x1710 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77,
/* 0x1720 */  65, 73, 78, 89, 32, 48, 32, 69, 76, 70, 77, 65, 73, 78, 89, 10,
/* 0x1730 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1740 */  32, 42, 85, 78, 68, 42, 32, 48, 32, 77, 70, 76, 71, 10, 48, 48,
/* 0x1750 */  48, 48, 48, 48, 48, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x1760 */  76, 70, 77, 65, 73, 78, 88, 32, 48, 32, 95,115,116, 97,114,116,
/* 0x1770 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32,
/* 0x1780 */  70, 32, 78, 82, 86, 50, 69, 32, 48, 49, 50, 99, 32,117, 99,108,
/* 0x1790 */  95,110,114,118, 50,101, 95,100,101, 99,111,109,112,114,101,115,
/* 0x17a0 */ 115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32,
/* 0x17b0 */  32, 32, 32, 70, 32, 78, 82, 86, 50, 68, 32, 48, 49, 49, 56, 32,
/* 0x17c0 */ 117, 99,108, 95,110,114,118, 50,100, 95,100,101, 99,111,109,112,
/* 0x17d0 */ 114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x17e0 */ 103, 32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50, 66, 32, 48,100,
/* 0x17f0 */  99, 32,117, 99,108, 95,110,114,118, 50, 98, 95,100,101, 99,111,
/* 0x1800 */ 109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1810 */  48, 32,103, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x1820 */  69, 67, 49, 48, 32, 48, 32, 76,122,109, 97, 68,101, 99,111,100,
/* 0x1830 */ 101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32,
/* 0x1840 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 89, 32, 48, 32,101,110,
/* 0x1850 */ 100, 95,100,101, 99,111,109,112,114,101,115,115, 10, 48, 48, 48,
/* 0x1860 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x1870 */  78, 68, 42, 32, 48, 32, 79, 95, 66, 73, 78, 70, 79, 10, 48, 48,
/* 0x1880 */  48, 48, 48, 48,102, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x1890 */  76, 70, 77, 65, 73, 78, 90, 32, 48, 32, 99,112,114, 48, 10, 10,
/* 0x18a0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x18b0 */  68, 83, 32, 70, 79, 82, 32, 91, 69, 76, 70, 77, 65, 73, 78, 88,
/* 0x18c0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x18d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x18e0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 65,
/* 0x18f0 */  82, 77, 95, 65, 66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32, 77,
/* 0x1900 */  70, 76, 71, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 65,
/* 0x1910 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x1920 */  76, 70, 77, 65, 73, 78, 90, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x1930 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x1940 */  91, 78, 82, 86, 50, 69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x1950 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1960 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x1970 */  49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x1980 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48,
/* 0x1990 */  48, 53, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x19a0 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48,
/* 0x19b0 */  48, 48, 54, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x19c0 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48,
/* 0x19d0 */  48, 48, 48, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x19e0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48,
/* 0x19f0 */  48, 48, 48, 48, 55, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x1a00 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48,
/* 0x1a10 */  48, 48, 48, 48, 48, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x1a20 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10,
/* 0x1a30 */  48, 48, 48, 48, 48, 48, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x1a40 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69,
/* 0x1a50 */  10, 48, 48, 48, 48, 48, 48, 57, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x1a60 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x1a70 */  69, 10, 48, 48, 48, 48, 48, 48, 57, 99, 32, 82, 95, 65, 82, 77,
/* 0x1a80 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x1a90 */  50, 69, 10, 48, 48, 48, 48, 48, 48, 97, 99, 32, 82, 95, 65, 82,
/* 0x1aa0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x1ab0 */  86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 98, 52, 32, 82, 95, 65,
/* 0x1ac0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x1ad0 */  82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 98, 56, 32, 82, 95,
/* 0x1ae0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1af0 */  78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 99, 48, 32, 82,
/* 0x1b00 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x1b10 */  32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 99, 52, 32,
/* 0x1b20 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x1b30 */  32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,100, 48,
/* 0x1b40 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x1b50 */  32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,100,
/* 0x1b60 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x1b70 */  32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x1b80 */ 100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x1b90 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48,
/* 0x1ba0 */  48,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x1bb0 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48,
/* 0x1bc0 */  48, 48,101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x1bd0 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48,
/* 0x1be0 */  48, 48, 48,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x1bf0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48,
/* 0x1c00 */  48, 48, 48, 48,102, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x1c10 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48,
/* 0x1c20 */  48, 48, 48, 48, 49, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x1c30 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10,
/* 0x1c40 */  48, 48, 48, 48, 48, 49, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x1c50 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69,
/* 0x1c60 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x1c70 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 68, 93,
/* 0x1c80 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x1c90 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x1ca0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 65, 82,
/* 0x1cb0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x1cc0 */  86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 53, 99, 32, 82, 95, 65,
/* 0x1cd0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x1ce0 */  82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 54, 48, 32, 82, 95,
/* 0x1cf0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1d00 */  78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 54, 56, 32, 82,
/* 0x1d10 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x1d20 */  32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 55, 52, 32,
/* 0x1d30 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x1d40 */  32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 56, 48,
/* 0x1d50 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x1d60 */  32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 56,
/* 0x1d70 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x1d80 */  32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x1d90 */  57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x1da0 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48,
/* 0x1db0 */  48, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x1dc0 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48,
/* 0x1dd0 */  48, 48, 97, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x1de0 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48,
/* 0x1df0 */  48, 48, 48, 98, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x1e00 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48,
/* 0x1e10 */  48, 48, 48, 48, 98, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x1e20 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48,
/* 0x1e30 */  48, 48, 48, 48, 48, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x1e40 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10,
/* 0x1e50 */  48, 48, 48, 48, 48, 48,100, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x1e60 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68,
/* 0x1e70 */  10, 48, 48, 48, 48, 48, 48,100, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x1e80 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x1e90 */  68, 10, 48, 48, 48, 48, 48, 48,101, 56, 32, 82, 95, 65, 82, 77,
/* 0x1ea0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x1eb0 */  50, 68, 10, 48, 48, 48, 48, 48, 48,101, 99, 32, 82, 95, 65, 82,
/* 0x1ec0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x1ed0 */  86, 50, 68, 10, 48, 48, 48, 48, 48, 49, 49, 48, 32, 82, 95, 65,
/* 0x1ee0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x1ef0 */  82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 49, 49, 52, 32, 82, 95,
/* 0x1f00 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1f10 */  78, 82, 86, 50, 68, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x1f20 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x1f30 */  82, 86, 50, 66, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x1f40 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1f50 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 48,
/* 0x1f60 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x1f70 */  32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 54,
/* 0x1f80 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x1f90 */  32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48,
/* 0x1fa0 */  54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x1fb0 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48,
/* 0x1fc0 */  48, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x1fd0 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48,
/* 0x1fe0 */  48, 48, 55, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x1ff0 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48,
/* 0x2000 */  48, 48, 48, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2010 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48,
/* 0x2020 */  48, 48, 48, 48, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2030 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48,
/* 0x2040 */  48, 48, 48, 48, 48, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2050 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10,
/* 0x2060 */  48, 48, 48, 48, 48, 48, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2070 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66,
/* 0x2080 */  10, 48, 48, 48, 48, 48, 48, 97, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x2090 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x20a0 */  66, 10, 48, 48, 48, 48, 48, 48, 97, 99, 32, 82, 95, 65, 82, 77,
/* 0x20b0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x20c0 */  50, 66, 10, 48, 48, 48, 48, 48, 48, 98, 52, 32, 82, 95, 65, 82,
/* 0x20d0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x20e0 */  86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 98, 56, 32, 82, 95, 65,
/* 0x20f0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x2100 */  82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48,100, 52, 32, 82, 95,
/* 0x2110 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2120 */  78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48,100, 56, 32, 82,
/* 0x2130 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2140 */  32, 78, 82, 86, 50, 66, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x2150 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x2160 */  76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 93, 58, 10, 79, 70, 70,
/* 0x2170 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x2180 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x2190 */  48, 48, 48, 48, 48, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x21a0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 69, 76,
/* 0x21b0 */  70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 52, 99, 32, 82, 95, 65,
/* 0x21c0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x21d0 */  90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x21e0 */  56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x21f0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10,
/* 0x2200 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x2210 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69,
/* 0x2220 */  67, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x2230 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2240 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 55, 52, 32,
/* 0x2250 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2260 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x2270 */  48, 48, 48, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2280 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2290 */  50, 48, 10, 48, 48, 48, 48, 48, 48, 98, 56, 32, 82, 95, 65, 82,
/* 0x22a0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x22b0 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 99,
/* 0x22c0 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x22d0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x22e0 */  48, 48, 48, 48, 48,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x22f0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x2300 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49, 48, 48, 32, 82, 95,
/* 0x2310 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2320 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x2330 */  49, 48, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2340 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x2350 */  10, 48, 48, 48, 48, 48, 49, 52, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x2360 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2370 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49, 57, 48, 32,
/* 0x2380 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2390 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x23a0 */  48, 48, 49, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x23b0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x23c0 */  50, 48, 10, 48, 48, 48, 48, 48, 49,100, 56, 32, 82, 95, 65, 82,
/* 0x23d0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x23e0 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 48,
/* 0x23f0 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2400 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x2410 */  48, 48, 48, 48, 50, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2420 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x2430 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 50, 48, 32, 82, 95,
/* 0x2440 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2450 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x2460 */  50, 51, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2470 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x2480 */  10, 48, 48, 48, 48, 48, 50, 51, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x2490 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x24a0 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 52, 48, 32,
/* 0x24b0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x24c0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x24d0 */  48, 48, 50, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x24e0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x24f0 */  50, 48, 10, 48, 48, 48, 48, 48, 50, 53, 56, 32, 82, 95, 65, 82,
/* 0x2500 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x2510 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 97,
/* 0x2520 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2530 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x2540 */  48, 48, 48, 48, 50, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2550 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x2560 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50,101, 56, 32, 82, 95,
/* 0x2570 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2580 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x2590 */  51, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x25a0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x25b0 */  10, 48, 48, 48, 48, 48, 51, 48, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x25c0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x25d0 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 51, 99, 32,
/* 0x25e0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x25f0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x2600 */  48, 48, 51, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2610 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2620 */  50, 48, 10, 48, 48, 48, 48, 48, 51, 97, 48, 32, 82, 95, 65, 82,
/* 0x2630 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x2640 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 97,
/* 0x2650 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2660 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x2670 */  48, 48, 48, 48, 51, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2680 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x2690 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51,101, 48, 32, 82, 95,
/* 0x26a0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x26b0 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x26c0 */  51,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x26d0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x26e0 */  10, 48, 48, 48, 48, 48, 52, 50, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x26f0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2700 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 51, 56, 32,
/* 0x2710 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2720 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x2730 */  48, 48, 52, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2740 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2750 */  50, 48, 10, 48, 48, 48, 48, 48, 52, 56, 52, 32, 82, 95, 65, 82,
/* 0x2760 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x2770 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 56,
/* 0x2780 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2790 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x27a0 */  48, 48, 48, 48, 52, 98, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x27b0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x27c0 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52,100, 52, 32, 82, 95,
/* 0x27d0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x27e0 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x27f0 */  52,101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2800 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x2810 */  10, 48, 48, 48, 48, 48, 52,102, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x2820 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2830 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 49, 56, 32,
/* 0x2840 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2850 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x2860 */  48, 48, 53, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2870 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2880 */  50, 48, 10, 48, 48, 48, 48, 48, 53, 57, 56, 32, 82, 95, 65, 82,
/* 0x2890 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x28a0 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 97,
/* 0x28b0 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x28c0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x28d0 */  48, 48, 48, 48, 53, 99, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x28e0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x28f0 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53,101, 52, 32, 82, 95,
/* 0x2900 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2910 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x2920 */  53,102, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2930 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x2940 */  10, 48, 48, 48, 48, 48, 54, 48, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x2950 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2960 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54, 50, 52, 32,
/* 0x2970 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2980 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x2990 */  48, 48, 54, 52, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x29a0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x29b0 */  50, 48, 10, 48, 48, 48, 48, 48, 54, 56, 48, 32, 82, 95, 65, 82,
/* 0x29c0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x29d0 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54, 56,
/* 0x29e0 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x29f0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x2a00 */  48, 48, 48, 48, 54,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2a10 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x2a20 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54,101, 99, 32, 82, 95,
/* 0x2a30 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2a40 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x2a50 */  55, 49, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2a60 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x2a70 */  10, 48, 48, 48, 48, 48, 55, 50, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x2a80 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2a90 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 54, 99, 32,
/* 0x2aa0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2ab0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x2ac0 */  48, 48, 55, 55, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2ad0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2ae0 */  50, 48, 10, 48, 48, 48, 48, 48, 55, 57, 99, 32, 82, 95, 65, 82,
/* 0x2af0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x2b00 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 98,
/* 0x2b10 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2b20 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x2b30 */  48, 48, 48, 48, 55, 99, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2b40 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x2b50 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55,100, 48, 32, 82, 95,
/* 0x2b60 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2b70 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x2b80 */  55,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2b90 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x2ba0 */  10, 48, 48, 48, 48, 48, 56, 50, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x2bb0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2bc0 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56, 50, 99, 32,
/* 0x2bd0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2be0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x2bf0 */  48, 48, 56, 55, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2c00 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2c10 */  50, 48, 10, 48, 48, 48, 48, 48, 56, 56, 56, 32, 82, 95, 65, 82,
/* 0x2c20 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x2c30 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56, 97,
/* 0x2c40 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2c50 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x2c60 */  48, 48, 48, 48, 56,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2c70 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x2c80 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56,102, 52, 32, 82, 95,
/* 0x2c90 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2ca0 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x2cb0 */  56,102, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2cc0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x2cd0 */  10, 48, 48, 48, 48, 48, 57, 48, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x2ce0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2cf0 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 57, 50, 56, 32,
/* 0x2d00 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2d10 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 10, 82, 69,
/* 0x2d20 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x2d30 */  32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x2d40 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x2d50 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x2d60 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65,
/* 0x2d70 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2d80 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x2d90 */  56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2da0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x2db0 */  48, 48, 48, 48, 48, 48, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2dc0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2dd0 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 97, 56, 32, 82,
/* 0x2de0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2df0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x2e00 */  48, 48, 97, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2e10 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x2e20 */  48, 10, 48, 48, 48, 48, 48, 48,101, 52, 32, 82, 95, 65, 82, 77,
/* 0x2e30 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2e40 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 48, 48,
/* 0x2e50 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2e60 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x2e70 */  48, 48, 48, 49, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2e80 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2e90 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 49, 52, 32, 82, 95, 65,
/* 0x2ea0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2eb0 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49,
/* 0x2ec0 */  49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2ed0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x2ee0 */  48, 48, 48, 48, 48, 49, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2ef0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2f00 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 50, 56, 32, 82,
/* 0x2f10 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2f20 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x2f30 */  48, 49, 52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2f40 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x2f50 */  48, 10, 48, 48, 48, 48, 48, 49, 52, 99, 32, 82, 95, 65, 82, 77,
/* 0x2f60 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2f70 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 53, 48,
/* 0x2f80 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2f90 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x2fa0 */  48, 48, 48, 49, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2fb0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2fc0 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 56, 56, 32, 82, 95, 65,
/* 0x2fd0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2fe0 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49,
/* 0x2ff0 */  56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3000 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x3010 */  48, 48, 48, 48, 48, 49, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3020 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x3030 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 97, 48, 32, 82,
/* 0x3040 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3050 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x3060 */  48, 49, 99, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3070 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x3080 */  48, 10, 48, 48, 48, 48, 48, 49, 99, 99, 32, 82, 95, 65, 82, 77,
/* 0x3090 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x30a0 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49,100, 52,
/* 0x30b0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x30c0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x30d0 */  48, 48, 48, 49,100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x30e0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x30f0 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 49,101, 52, 32, 82, 95, 65,
/* 0x3100 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x3110 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49,
/* 0x3120 */ 101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3130 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x3140 */  48, 48, 48, 48, 48, 50, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3150 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x3160 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 50, 99, 32, 82,
/* 0x3170 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3180 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x3190 */  48, 50, 52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x31a0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x31b0 */  48, 10, 48, 48, 48, 48, 48, 50, 52, 99, 32, 82, 95, 65, 82, 77,
/* 0x31c0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x31d0 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 53, 48,
/* 0x31e0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x31f0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x3200 */  48, 48, 48, 50, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3210 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3220 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 56, 52, 32, 82, 95, 65,
/* 0x3230 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x3240 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50,
/* 0x3250 */  56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3260 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x3270 */  48, 48, 48, 48, 48, 50, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3280 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x3290 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 99, 56, 32, 82,
/* 0x32a0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x32b0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x32c0 */  48, 50,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x32d0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x32e0 */  48, 10, 48, 48, 48, 48, 48, 50,100, 99, 32, 82, 95, 65, 82, 77,
/* 0x32f0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x3300 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50,102, 52,
/* 0x3310 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3320 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x3330 */  48, 48, 48, 51, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3340 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3350 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 49, 52, 32, 82, 95, 65,
/* 0x3360 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x3370 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51,
/* 0x3380 */  50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3390 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x33a0 */  48, 48, 48, 48, 48, 51, 53, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x33b0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x33c0 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 53, 56, 32, 82,
/* 0x33d0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x33e0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x33f0 */  48, 51, 55, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3400 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x3410 */  48, 10, 48, 48, 48, 48, 48, 51, 55, 56, 32, 82, 95, 65, 82, 77,
/* 0x3420 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x3430 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 57, 99,
/* 0x3440 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3450 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x3460 */  48, 48, 48, 51, 98, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3470 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3480 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 98, 56, 32, 82, 95, 65,
/* 0x3490 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x34a0 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51,
/* 0x34b0 */  99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x34c0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x34d0 */  48, 48, 48, 48, 48, 51, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x34e0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x34f0 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52, 48, 48, 32, 82,
/* 0x3500 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3510 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x3520 */  48, 52, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3530 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x3540 */  48, 10, 48, 48, 48, 48, 48, 52, 52, 48, 32, 82, 95, 65, 82, 77,
/* 0x3550 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x3560 */  65, 95, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x3570 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x3580 */  91, 69, 76, 70, 77, 65, 73, 78, 90, 93, 58, 10, 79, 70, 70, 83,
/* 0x3590 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x35a0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x35b0 */  48, 48, 48,100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x35c0 */  32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x35d0 */  10, 48, 48, 48, 48, 48, 48,101, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x35e0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x35f0 */  65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48,101, 99, 32, 82, 95,
/* 0x3600 */  65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x3610 */  79, 95, 66, 73, 78, 70, 79, 10
};
