;**********************************;
; WASM Case Conversion, String     ;
; By Eric Tauck                    ;
;                                  ;
; Defines:                         ;
;                                  ;
;   StrLwr  string to lowercase    ;
;   StrUpr  string to uppercase    ;
;                                  ;
; Requires:                        ;
;                                  ;
;   CASE1.ASM                      ;
;**********************************;

        jmps    _case2_end

;========================================
; Convert a string to lowercase.
;
; In: AX= address of string.

StrLwr  PROC    NEAR
        mov     bx, ax          ;address into BX
        jmps    _srlwr2         ;enter loop
_srlwr1 call    ChrLwr          ;convert to lowercase
        mov     [bx], al        ;store character
        inc     bx              ;increment address
_srlwr2 mov     al, [bx]        ;load character
        or      al, al          ;check if end of string
        jnz     _srlwr1         ;loop back if not
        ret
        ENDP

;========================================
; Convert a string to uppercase.
;
; In: AX= address of string.

StrUpr  PROC    NEAR
        mov     bx, ax          ;address into BX
        jmps    _srupr2         ;enter loop
_srupr1 call    ChrUpr          ;convert to uppercase
        mov     [bx], al        ;store character
        inc     bx              ;increment address
_srupr2 mov     al, [bx]        ;load character
        or      al, al          ;check if end of string
        jnz     _srupr1         ;loop back if not
        ret
        ENDP

_case2_end
