;*************************************;
; WASM Checksum Calculation, CRC Byte ;
; By Eric Tauck                       ;
;                                     ;
; Defines:                            ;
;                                     ;
;   CrcRes  reset CRC                 ;
;   CrcCur  return current CRC        ;
;   CrcUpd  update current CRC        ;
;*************************************;

        jmps    _check4_end

;--- data

_crc_cur        DW      0       ;current checksum value

;========================================
; Reset CRC.

CrcRes  PROC    NEAR
        mov     _crc_cur, 0     ;zero checksum
        ret
        ENDP

;========================================
; Return the current CRC.
;
; Out: AX= CRC value.

CrcCur  PROC    NEAR
        mov     ax, _crc_cur    ;return checksum
        ret
        ENDP

;========================================
; Update the current CRC by a byte.
;
; In: AL= byte.

CrcUpd  PROC    NEAR
        mov     dl, al
        mov     ax, _crc_cur    ;current CRC
        mov     cx, 8           ;bits to update

_ccupd1 shl     dl              ;shift bit
        rcl     ax              ;roll into checksum
        jnc     _ccupd2         ;skip xor if bit not shifted out
        xor     ax, 1021H       ;xor CRC value
_ccupd2 loop    _ccupd1         ;loop for each bit

        mov     _crc_cur, ax    ;save
        ret
        ENDP

_check4_end
