;*************************************;
; WASM Number Conversion              ;
; By Eric Tauck                       ;
;                                     ;
; Defines:                            ;
;                                     ;
;   Num2Str  convert number to string ;
;   Str2Num  convert string to number ;
;                                     ;
; Requires:                           ;
;                                     ;
;   CASE1.ASM                         ;
;*************************************;

        jmp     _convert_end

_conv_digs      DB      '0123456789ABCDEF'

;========================================
; Convert a string to a 32-bit number.
;
; In: AX= string address; CX= base.
;
; Out: DX:AX= number; CY= set if error
;      (number too big or illegal digit).

Str2Num PROC    NEAR
        push    di
        push    si

        mov     bx, ax          ;load address
        cmp     BYTE [bx], 0    ;check if null string
        je      _srnum2         ;error if so

        sub     di, di          ;zero low word
        mov     si, di          ;zero high word

;--- loop for each byte in string

_srnum1 mov     al, BYTE [bx]   ;load next byte
        call    ChrUpr          ;convert to upper case
        inc     bx              ;increment address
        push    cx
        push    di
        mov     di, OFFSET _conv_digs   ;address of digits
        cld
        repne
        scasb                   ;scan for matching digit
        mov     ax, cx
        pop     di
        pop     cx
        jne     _srnum2         ;jump if error
        sub     ax, cx
        inc     ax
        neg     ax              ;convert to number

        add     di, ax          ;add to low number
        adc     si, 0           ;add carry
        jc      _srnum2         ;jump if error

        cmp     BYTE [bx], 0    ;check if end of string
        je      _srnum3         ;exit if so

        mov     ax, si          ;load high word
        mul     cx              ;times base
        jc      _srnum2         ;jump if error
        mov     si, ax          ;save high word
        mov     ax, di          ;load low word
        mul     cx              ;times base
        mov     di, ax          ;save low word
        add     si, dx          ;add high word
        jnc     _srnum1         ;loop back if okay

;--- error

_srnum2 pop     si
        pop     di
        stc
        ret

;--- success

_srnum3 mov     dx, si
        mov     ax, di
        pop     si
        pop     di
        clc
        ret
        ENDP

;========================================
; Convert a 32 bit number to a string.
;
; In: DX:AX= number; BX= place to put
;     string; CX= base (1 to 16).
;
; Out: AX= number of digits.

Num2Str PROC    NEAR
        push    di
        push    si

;--- store digits (are stored in reverse order)

        push    bx
        mov     si, dx          ;
        mov     di, ax          ;put value in SI:DI

_nmstr1 mov     ax, si          ;load high word
        sub     dx, dx          ;zero for divide
        div     cx              ;divide
        mov     si, ax          ;save high word
        mov     ax, di          ;load low word
        div     cx              ;divide
        mov     di, ax          ;save low word
        push    bx
        mov     bx, OFFSET _conv_digs   ;address of digits
        add     bx, dx                  ;offset for digit
        mov     al, [bx]                ;load digit
        pop     bx
        mov     [bx], al        ;store digit
        inc     bx              ;increment storage
        or      di, di          ;check if low word zero
        jnz     _nmstr1
        or      si, si          ;check if high word zero
        jnz     _nmstr1

;--- reverse digits

        mov     BYTE [bx], 0    ;store terminator

        pop     si
        mov     cx, bx
        sub     cx, si          ;get bytes written
        push    cx              ;save for exit
        dec     bx              ;point to last character
        shr     cx              ;divide character count by two
        jz      _nmstr3         ;jump if none left

_nmstr2 mov     al, [si]        ;load front character
        xchg    al, [bx]        ;swap with end character
        mov     [si], al        ;store front character
        inc     si              ;advance front pointer
        dec     bx              ;decrement end pointer
        loop    _nmstr2

;--- finished

_nmstr3 pop     ax
        pop     si
        pop     di
        ret
        ENDP

_convert_end
