;************************************;
; WASM Serial I/O, Timed Input       ;
; By Eric Tauck                      ;
;                                    ;
; Defines:                           ;
;                                    ;
;   ComWai   wait for a byte of data ;
;   ComWaiW  wait for a word of data ;
;   ComAny   wait for any data       ;
;                                    ;
; Requires:                          ;
;                                    ;
;   SERIAL1.ASM                      ;
;   SERIAL2.ASM                      ;
;   TICKS.ASM                        ;
;************************************;

        jmps    _serial5_end

;========================================
; Wait for and read a byte.
;
; In: BX= record address; AX= timeout
;     ticks.
;
; Out: AL= byte; CY= set if timeout.

ComWai  PROC    NEAR
        push    di
        push    si
        mov     di, bx          ;save record address
        mov     si, ax          ;save timeout value

        sub     al, al          ;timer zero
        call    TicRes          ;reset timer

_cmwai1 mov     bx, di
        call    ComGet          ;get byte
        jnc     _cmwai2         ;jump if byte returned

        sub     al, al          ;timer zero
        call    TicPas          ;get time passed
        cmp     ax, si          ;check if timeout
        jb      _cmwai1         ;loop back if not

;--- finished, timeout

        pop     si
        pop     di
        stc
        ret

;--- finished, no timeout

_cmwai2 pop     si
        pop     di
        clc
        ret
        ENDP

;========================================
; Wait for and read a word.
;
; In: BX= record address; AX= timeout
;     ticks.
;
; Out: AX= word; CY= set if timeout.

ComWaiW PROC    NEAR
        push    di
        push    si
        mov     di, bx          ;save record address
        mov     si, ax          ;save timeout value

        sub     al, al          ;timer zero
        call    TicRes          ;reset timer

_cmwaw1 mov     bx, di
        call    ComGetW         ;get byte
        jnc     _cmwaw2         ;jump if byte returned

        sub     al, al          ;timer zero
        call    TicPas          ;get time passed
        cmp     ax, si          ;check if timeout
        jb      _cmwaw1         ;loop back if not

;--- finished, timeout

        pop     si
        pop     di
        stc
        ret

;--- finished, no timeout

_cmwaw2 pop     si
        pop     di
        clc
        ret
        ENDP

;========================================
; Wait for any data.  The data is not
; read.
;
; In: BX= record address; AX= timeout
;     ticks.
;
; Out: CY= set if timeout.

ComAny  PROC    NEAR
        push    di
        push    si
        mov     di, bx          ;save record address
        mov     si, ax          ;save timeout value

        sub     al, al          ;timer zero
        call    TicRes          ;reset timer

_cmwaa1 mov     bx, di
        call    ComByt          ;get bytes in buffer
        or      ax, ax          ;check if any bytes
        jnz     _cmwaa2         ;jump if so

        sub     al, al          ;timer zero
        call    TicPas          ;get time passed
        cmp     ax, si          ;check if timeout
        jb      _cmwaa1         ;loop back if not

;--- finished, timeout

        pop     si
        pop     di
        stc
        ret

;--- finished, no timeout

_cmwaa2 pop     si
        pop     di
        clc
        ret
        ENDP

_serial5_end
