;*************************;
; SESSION Macro Debugging ;
;     By Eric Tauck       ;
;*************************;

DEBUG_ITEMS     EQU     3       ;max number of items displayed
DEBUG_DEC       EQU     5       ;decimal number width (not including sign)
DEBUG_HEX       EQU     4       ;hexadecimal number width

bline   DB      13,10,0
bspace  DB      '  ',0
bplus   DB      ' + ',0
bterm   DB      '** Macro Terminated **',13,10,0
brning  DB      '** Macro Running **',13,10,0
bmes1   DB      '> Code = ',0
bmes2   DB      '> Stack = ',0
bmes3   DB      '  Return = ',0
bmes4   DB      '> Stack:',13,10,0
bmes5   DB      '> Return:',13,10,0
bwait   DB      '> Press any key ...',0

;========================================
; Format a hexadecimal number.
;
; In: AX= number; DI= buffer.

DebugHex PROC   NEAR
        mov     bx, di
        mov     cx, 16          ;base 16
        sub     dx, dx          ;no high word
        call    Num2Str         ;convert to string

        mov     ax, di
        mov     cx, DEBUG_HEX   ;width
        mov     dl, '0'         ;pad with zeros
        call    StrJusR         ;right justify
        ret
        ENDP

;========================================
; Format a decimal number.
;
; In: AX= number; DI= buffer.

DebugDec PROC   NEAR
        push    di
        mov     BYTE [di], '+'  ;store plus
        test    ah, 80H         ;check if negative
        jz      debdec1
        mov     BYTE [di], '-'  ;store negative
        neg     ax              ;negate

debdec1 inc     di              ;skip sign
        mov     bx, di
        mov     cx, 10          ;base 10
        sub     dx, dx          ;no high word
        call    Num2Str         ;convert to string

        mov     ax, di
        mov     cx, DEBUG_DEC   ;width
        mov     dl, '0'         ;pad with zeros
        call    StrJusR         ;right justify
        pop     di
        ret
        ENDP

;========================================
; Look up and format the symbol of an
; address (might be an empty string).
;
; In: AX= address; DI= buffer.

DebugSym PROC   NEAR
        push    di
        mov     BYTE [di], 0    ;store NUL if no symbol returned

;--- get symbol

        mov     bx, di
        call    MacSym          ;look up symbol
        jc      debsym1         ;exit if none
        or      ax, ax          ;check if any offset
        jz      debsym1         ;exit if not

;--- append offset

        push    ax
        mov     ax, di
        call    StrLen          ;get length of symbol
        add     di, ax          ;point to end
        mov     ax, OFFSET bplus
        mov     bx, di
        call    StrCpy          ;copy plus
        add     di, ax          ;point to end
        pop     ax

        sub     dx, dx
        mov     cx, 10
        mov     bx, di
        call    Num2Str         ;append offset
debsym1 pop     di
        ret
        ENDP

;========================================
; Look up and format a stack item.
;
; In: AX= value; DI= buffer.

DebugItem PROC  NEAR
        push    di

;--- decimal format

        push    ax
        call    DebugDec
        add     di, DEBUG_DEC + 1
        mov     ax, OFFSET bspace
        mov     bx, di
        call    StrCpy
        add     di, ax
        pop     ax

;--- hexadecimal format

        push    ax
        call    DebugHex
        add     di, DEBUG_HEX
        mov     ax, OFFSET bspace
        mov     bx, di
        call    StrCpy
        add     di, ax
        pop     ax

;--- symbol

        call    DebugSym
        pop     di
        ret
        ENDP

;========================================
; Display current macro state.
;
; Out: CY= set if abort macro.

DebugInfo PROC  NEAR
        push    di
        push    si
        StkAll  di, 80                  ;enough space for numbers and tokens
        StkAll  si, DEBUG_ITEMS * 2     ;stack value storage

;--- display running/terminated status

        mov     ax, OFFSET brning
        test    trmflg, T_MACRO
        jnz     debinf1
        mov     ax, OFFSET bterm
debinf1 call    Debug_String

;--- display current code location

        mov     ax, OFFSET bmes1
        call    Debug_String            ;display Code =
        call    MacCur                  ;get code pointer
        push    ax
        call    DebugHex                ;hex format
        mov     ax, di
        call    Debug_String            ;display
        mov     ax, OFFSET bspace
        call    Debug_String            ;display spacing
        pop     ax
        call    DebugSym                ;convert to symbol
        mov     ax, di
        call    Debug_String            ;display symbol
        mov     ax, OFFSET bline
        call    Debug_String            ;new line

;--- display stack and return items

        mov     ax, OFFSET bmes2
        call    Debug_String            ;display Stack =
        call    MacCur                  ;get stack and return items
        push    cx
        mov     ax, bx
        sub     dx, dx
        mov     cx, 10
        mov     bx, di
        call    Num2Str
        mov     ax, di
        call    Debug_String            ;display stack items
        mov     ax, OFFSET bmes3
        call    Debug_String            ;display spacing
        pop     ax
        sub     dx, dx
        mov     cx, 10
        mov     bx, di
        call    Num2Str
        mov     ax, di
        call    Debug_String            ;display return items
        mov     ax, OFFSET bline
        call    Debug_String            ;new line

;--- display top stack items

        call    MacCur                  ;get stack items
        mov     cx, bx
        cmp     cx, DEBUG_ITEMS
        jbe     debinf2
        mov     cx, DEBUG_ITEMS

debinf2 jcxz    debinf4

        push    cx
        mov     ax, OFFSET bmes4
        call    Debug_String
        pop     cx

        push    cx
        mov     ax, si
        call    MacStk
        pop     cx

        push    si
debinf3 push    cx
        mov     ax, OFFSET bspace
        call    Debug_String            ;display spacing
        cld
        lodsw
        call    DebugItem
        mov     ax, di
        call    Debug_String            ;display item
        mov     ax, OFFSET bline
        call    Debug_String            ;new line
        pop     cx
        loop    debinf3
        pop     si

;--- display top return items

debinf4 call    MacCur                  ;get stack items
        cmp     cx, DEBUG_ITEMS
        jbe     debinf5
        mov     cx, DEBUG_ITEMS

debinf5 jcxz    debinf7

        push    cx
        mov     ax, OFFSET bmes5
        call    Debug_String
        pop     cx

        push    cx
        mov     ax, si
        call    MacRet
        pop     cx

debinf6 push    cx
        mov     ax, OFFSET bspace
        call    Debug_String            ;display spacing
        cld
        lodsw
        call    DebugItem
        mov     ax, di
        call    Debug_String            ;display item
        mov     ax, OFFSET bline
        call    Debug_String            ;new line
        pop     cx
        loop    debinf6

;--- final prompt

debinf7 mov     ax, OFFSET bwait
        call    Debug_String

;--- wait for key

        call    KeyClr                  ;clear keyboard
        call    KeyWai                  ;wait for key
        cmp     ax, KEY_ALT_B           ;check if disable debugging
        jne     debinf8
        and     trmflg, NOT T_DEBUG     ;clear debugging flag

debinf8 push    ax
        mov     ax, OFFSET bline
        call    Debug_String
        pop     ax

        cmp     ax, KEY_ALT_A           ;check if abort
        je      debinf9                 ;jump if so

        StkRel  80, DEBUG_ITEMS * 2
        pop     si
        pop     di
        clc
        ret

;--- abort macro

debinf9 StkRel  80, DEBUG_ITEMS * 2
        pop     si
        pop     di
        stc
        ret
        ENDP
