/*
 *  d4iface.h   DOT4 interface
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _DOT4_IFACE_H
#define _DOT4_IFACE_H

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Primitive data types */
typedef unsigned long   CHANNEL_HANDLE;
typedef CHANNEL_HANDLE  *PCHANNEL_HANDLE;

/* DOT4 maximum channels */
#define DOT4_MAX_CHANNELS   128

/* Timeout special value */
#define NO_TIMEOUT  0

/* Channel types */
#define STREAM_TYPE_CHANNEL 1
#define PACKET_TYPE_CHANNEL 2

/* DOT4 broadcast activity messages */
#define DOT4_STREAM_RECEIVED    0x0100
#define DOT4_STREAM_CREDITS     0x0101
#define DOT4_MESSAGE_RECEIVED   0x0102
#define DOT4_DISCONNECT         0x0103
#define DOT4_CHANNEL_CLOSED     0x0105

/* DOT4 channels */
#define DOT4_CHANNEL            0
#define HP_MESSAGE_PROCESSOR    1
#define PRINTER_CHANNEL         2
#define SCANNER_CHANNEL         4
#define MIO_COMMAND_PROCESSOR   5
#define ECHO_CHANNEL            6
#define FAX_SEND_CHANNEL        7
#define FAX_RECV_CHANNEL        8
#define DIAGNOSTIC_CHANNEL      9
#define HP_RESERVED             10
#define IMAGE_DOWNLOAD          11
#define HOST_DATASTORE_UPLOAD   12
#define HOST_DATASTORE_DOWNLOAD 13
#define CONFIG_UPLOAD           14
#define CONFIG_DOWNLOAD         15

/* DOT4 activity */
typedef struct _DOT4_ACTIVITY {
    ULONG           ulMessage;
    ULONG           ulByteCount;
    CHANNEL_HANDLE  hChannel;
} DOT4_ACTIVITY;
typedef DOT4_ACTIVITY   *PDOT4_ACTIVITY;

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _DOT4_IFACE_H */
