/*
 *  usbuser.h   USB user mode device I/O control codes
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef __USBUSER_H__
#define __USBUSER_H__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#if (_WIN32_WINNT >= 0x0501)
    #include <usbiodef.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* USB user mode version number */
#if (_WIN32_WINNT >= 0x0501)
    #define USBUSER_VERSION 0x00000004L
#endif

/* USB device I/O control codes */
#if (_WIN32_WINNT >= 0x0501)
    #define IOCTL_USB_USER_REQUEST                  USB_CTL( HCD_USER_REQUEST )
    #define IOCTL_USB_HCD_GET_STATS_1               USB_CTL( HCD_GET_STATS_1 )
    #define IOCTL_USB_HCD_GET_STATS_2               USB_CTL( HCD_GET_STATS_2 )
    #define IOCTL_USB_HCD_DISABLE_PORT              USB_CTL( HCD_DISABLE_PORT )
    #define IOCTL_USB_HCD_ENABLE_PORT               USB_CTL( HCD_ENABLE_PORT )
    #ifndef IOCTL_USB_DIAGNOSTIC_MODE_ON
        #define IOCTL_USB_DIAGNOSTIC_MODE_ON        USB_CTL( HCD_DIAGNOSTIC_MODE_ON )
    #endif
    #ifndef IOCTL_USB_DIAGNOSTIC_MODE_OFF
        #define IOCTL_USB_DIAGNOSTIC_MODE_OFF       USB_CTL( HCD_DIAGNOSTIC_MODE_OFF )
    #endif
    #ifndef IOCTL_USB_GET_ROOT_HUB_NAME
        #define IOCTL_USB_GET_ROOT_HUB_NAME         USB_CTL( HCD_GET_ROOT_HUB_NAME )
    #endif
    #ifndef IOCTL_USB_GET_HCD_DRIVERKEY_NAME
        #define IOCTL_USB_GET_HCD_DRIVERKEY_NAME    USB_CTL( HCD_GET_DRIVERKEY_NAME )
    #endif
#endif

/* USB user mode request codes */
#if (_WIN32_WINNT >= 0x0501)
    #define USBUSER_GET_CONTROLLER_INFO_0       0x00000001L
    #define USBUSER_GET_CONTROLLER_DRIVER_KEY   0x00000002L
    #define USBUSER_PASS_THRU                   0x00000003L
    #define USBUSER_GET_POWER_STATE_MAP         0x00000004L
    #define USBUSER_GET_BANDWIDTH_INFORMATION   0x00000005L
    #define USBUSER_GET_BUS_STATISTICS_0        0x00000006L
    #define USBUSER_GET_ROOTHUB_SYMBOLIC_NAME   0x00000007L
    #define USBUSER_GET_USB_DRIVER_VERSION      0x00000008L
    #define USBUSER_GET_USB2_HW_VERSION         0x00000009L
    #define USBUSER_USB_REFRESH_HCT_REG         0x0000000AL
    #define USBUSER_OP_SEND_ONE_PACKET          0x10000001L
    #define USBUSER_OP_RAW_RESET_PORT           0x20000001L
    #define USBUSER_OP_OPEN_RAW_DEVICE          0x20000002L
    #define USBUSER_OP_CLOSE_RAW_DEVICE         0x20000003L
    #define USBUSER_OP_SEND_RAW_COMMAND         0x20000004L
    #define USBUSER_SET_ROOTPORT_FEATURE        0x20000005L
    #define USBUSER_CLEAR_ROOTPORT_FEATURE      0x20000006L
    #define USBUSER_GET_ROOTPORT_STATUS         0x20000007L
    #define USBUSER_INVALID_REQUEST             0xFFFFFFF0L
    #define USBUSER_OP_MASK_DEVONLY_API         0x10000000L
    #define USBUSER_OP_MASK_HCTEST_API          0x20000000L
#endif

/* USB packet flags */
#if (_WIN32_WINNT >= 0x0501)
    #define USB_PACKETFLAG_LOW_SPEED    0x00000001L
    #define USB_PACKETFLAG_FULL_SPEED   0x00000002L
    #define USB_PACKETFLAG_HIGH_SPEED   0x00000004L
    #define USB_PACKETFLAG_ASYNC_IN     0x00000008L
    #define USB_PACKETFLAG_ASYNC_OUT    0x00000010L
    #define USB_PACKETFLAG_ISO_IN       0x00000020L
    #define USB_PACKETFLAG_ISO_OUT      0x00000040L
    #define USB_PACKETFLAG_SETUP        0x00000080L
    #define USB_PACKETFLAG_TOGGLE0      0x00000100L
    #define USB_PACKETFLAG_TOGGLE1      0x00000200L
#endif

/* USB hardware compatibility feature flags */
#if (_WIN32_WINNT >= 0x0501)
    #define USB_HC_FEATURE_FLAG_PORT_POWER_SWITCHING    0x00000001L
    #define USB_HC_FEATURE_FLAG_SEL_SUSPEND             0x00000002L
    #define USB_HC_FEATURE_LEGACY_BIOS                  0x00000004L
#endif

/* All structures in this file get one-byte packing. */
#include <pshpack1.h>

/* USB user mode error codes */
#if (_WIN32_WINNT >= 0x0501)
typedef enum _USB_USER_ERROR_CODE {
    UsbUserSuccess                  = 0,
    UsbUserNotSupported             = 1,
    UsbUserInvalidRequestCode       = 2,
    UsbUserFeatureDisabled          = 3,
    UsbUserInvalidHeaderParameter   = 4,
    UsbUserInvalidParameter         = 5,
    UsbUserMiniportError            = 6,
    UsbUserBufferTooSmall           = 7,
    UsbUserErrorNotMapped           = 8,
    UsbUserDeviceNotStarted         = 9,
    UsbUserNoDeviceConnected        = 10
} USB_USER_ERROR_CODE;
#endif

/* USB user mode request header */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USBUSER_REQUEST_HEADER {
    ULONG               UsbUserRequest;
    USB_USER_ERROR_CODE UsbUserStatusCode;
    ULONG               RequestBufferLength;
    ULONG               ActualBufferLength;
} USBUSER_REQUEST_HEADER;
typedef USBUSER_REQUEST_HEADER  *PUSBUSER_REQUEST_HEADER;
#endif

/* Packet parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _PACKET_PARAMETERS {
    UCHAR       DeviceAddress;
    UCHAR       EndpointAddress;
    USHORT      MaximumPacketSize;
    ULONG       Timeout;
    ULONG       Flags;
    ULONG       DataLength;
    USHORT      HubDeviceAddress;
    USHORT      PortTTNumber;
    UCHAR       ErrorCount;
    UCHAR       Pad[3];
    USBD_STATUS UsbdStatusCode;
    UCHAR       Data[4];
} PACKET_PARAMETERS;
typedef PACKET_PARAMETERS   *PPACKET_PARAMETERS;
#endif

/* USBUSER_OP_SEND_ONE_PACKET parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USBUSER_SEND_ONE_PACKET {
    USBUSER_REQUEST_HEADER  Header;
    PACKET_PARAMETERS       PacketParameters;
} USBUSER_SEND_ONE_PACKET;
typedef USBUSER_SEND_ONE_PACKET *PUSBUSER_SEND_ONE_PACKET;
#endif

/* Raw reset port parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _RAW_RESET_PORT_PARAMETERS {
    USHORT  PortNumber;
    USHORT  PortStatus;
} RAW_RESET_PORT_PARAMETERS;
typedef RAW_RESET_PORT_PARAMETERS   *PRAW_RESET_PORT_PARAMETERS;
#endif

/* USBUSER_OP_RAW_RESET_PORT parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USBUSER_RAW_RESET_ROOT_PORT {
    USBUSER_REQUEST_HEADER      Header;
    RAW_RESET_PORT_PARAMETERS   Parameters;
} USBUSER_RAW_RESET_ROOT_PORT;
typedef USBUSER_RAW_RESET_ROOT_PORT *PUSBUSER_RAW_RESET_ROOT_PORT;
#endif

/* Raw root port feature */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _RAW_ROOTPORT_FEATURE {
    USHORT  PortNumber;
    USHORT  PortFeature;
    USHORT  PortStatus;
} RAW_ROOTPORT_FEATURE;
typedef RAW_ROOTPORT_FEATURE    *PRAW_ROOTPORT_FEATURE;
#endif

/* USB user mode root port feature request parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USBUSER_ROOTPORT_FEATURE_REQUEST {
    USBUSER_REQUEST_HEADER  Header;
    RAW_ROOTPORT_FEATURE    Parameters;
} USBUSER_ROOTPORT_FEATURE_REQUEST;
typedef USBUSER_ROOTPORT_FEATURE_REQUEST    *PUSBUSER_ROOTPORT_FEATURE_REQUEST;
#endif

/* Raw root port parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _RAW_ROOTPORT_PARAMETERS {
    USHORT  PortNumber;
    USHORT  PortStatus;
} RAW_ROOTPORT_PARAMETERS;
typedef RAW_ROOTPORT_PARAMETERS *PRAW_ROOTPORT_PARAMETERS;
#endif

/* USBUSER_GET_ROOTPORT_STATUS parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USBUSER_ROOTPORT_PARAMETERS {
    USBUSER_REQUEST_HEADER  Header;
    RAW_ROOTPORT_PARAMETERS Parameters;
} USBUSER_ROOTPORT_PARAMETERS;
typedef USBUSER_ROOTPORT_PARAMETERS *PUSBUSER_ROOTPORT_PARAMETERS;
#endif

/* USB controller information */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USB_CONTROLLER_INFO_0 {
    ULONG                   PciVendorId;
    ULONG                   PciDeviceId;
    ULONG                   PciRevision;
    ULONG                   NumberOfRootPorts;
    USB_CONTROLLER_FLAVOR   ControllerFlavor;
    ULONG                   HcFeatureFlags;
} USB_CONTROLLER_INFO_0;
typedef USB_CONTROLLER_INFO_0   *PUSB_CONTROLLER_INFO_0;
#endif

/* USBUSER_GET_CONTROLLER_INFO_0 parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USBUSER_CONTROLLER_INFO_0 {
    USBUSER_REQUEST_HEADER  Header;
    USB_CONTROLLER_INFO_0   Info0;
} USBUSER_CONTROLLER_INFO_0;
typedef USBUSER_CONTROLLER_INFO_0   *PUSBUSER_CONTROLLER_INFO_0;
#endif

/* USB Unicode name */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USB_UNICODE_NAME {
    ULONG   Length;
    WCHAR   String[1];
} USB_UNICODE_NAME;
typedef USB_UNICODE_NAME    *PUSB_UNICODE_NAME;
#endif

/* USB user mode controller Unicode name parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USBUSER_CONTROLLER_UNICODE_NAME {
    USBUSER_REQUEST_HEADER  Header;
    USB_UNICODE_NAME        UnicodeName;
} USBUSER_CONTROLLER_UNICODE_NAME;
typedef USBUSER_CONTROLLER_UNICODE_NAME *PUSBUSER_CONTROLLER_UNICODE_NAME;
#endif

/* USB pass through parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USB_PASS_THRU_PARAMETERS {
    GUID    FunctionGUID;
    ULONG   ParameterLength;
    UCHAR   Parameters[4];
} USB_PASS_THRU_PARAMETERS;
typedef USB_PASS_THRU_PARAMETERS    *PUSB_PASS_THRU_PARAMETERS;
#endif

/* USBUSER_PASS_THRU parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USBUSER_PASS_THRU_REQUEST {
    USBUSER_REQUEST_HEADER      Header;
    USB_PASS_THRU_PARAMETERS    PassThru;
} USBUSER_PASS_THRU_REQUEST;
typedef USBUSER_PASS_THRU_REQUEST   *PUSBUSER_PASS_THRU_REQUEST;
#endif

/* WDM USB power states */
#if (_WIN32_WINNT >= 0x0501)
typedef enum _WDMUSB_POWER_STATE {
    WdmUsbPowerNotMapped            = 0,
    WdmUsbPowerSystemUnspecified    = 100,
    WdmUsbPowerSystemWorking        = 101,
    WdmUsbPowerSystemSleeping1      = 102,
    WdmUsbPowerSystemSleeping2      = 103,
    WdmUsbPowerSystemSleeping3      = 104,
    WdmUsbPowerSystemHibernate      = 105,
    WdmUsbPowerSystemShutdown       = 106,
    WdmUsbPowerDeviceUnspecified    = 200,
    WdmUsbPowerDeviceD0             = 201,
    WdmUsbPowerDeviceD1             = 202,
    WdmUsbPowerDeviceD2             = 203,
    WdmUsbPowerDeviceD3             = 204
} WDMUSB_POWER_STATE;
#endif

/* USB power information */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USB_POWER_INFO {
    WDMUSB_POWER_STATE  SystemState;
    WDMUSB_POWER_STATE  HcDevicePowerState;
    WDMUSB_POWER_STATE  HcDeviceWake;
    WDMUSB_POWER_STATE  HcSystemWake;
    WDMUSB_POWER_STATE  RhDevicePowerState;
    WDMUSB_POWER_STATE  RhDeviceWake;
    WDMUSB_POWER_STATE  RhSystemWake;
    WDMUSB_POWER_STATE  LastSystemSleepState;
    BOOLEAN             CanWakeup;
    BOOLEAN             IsPowered;
} USB_POWER_INFO;
typedef USB_POWER_INFO  *PUSB_POWER_INFO;
#endif

/* USBUSER_GET_POWER_STATE_MAP parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USBUSER_POWER_INFO_REQUEST {
    USBUSER_REQUEST_HEADER  Header;
    USB_POWER_INFO          PowerInformation;
} USBUSER_POWER_INFO_REQUEST;
typedef USBUSER_POWER_INFO_REQUEST  *PUSBUSER_POWER_INFO_REQUEST;
#endif

/* USB open raw device parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USB_OPEN_RAW_DEVICE_PARAMETERS {
    USHORT  PortStatus;
    USHORT  MaxPacketEp0;
} USB_OPEN_RAW_DEVICE_PARAMETERS;
typedef USB_OPEN_RAW_DEVICE_PARAMETERS  *PUSB_OPEN_RAW_DEVICE_PARAMETERS;
#endif

/* USBUSER_OP_OPEN_RAW_DEVICE parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USBUSER_OPEN_RAW_DEVICE {
    USBUSER_REQUEST_HEADER          Header;
    USB_OPEN_RAW_DEVICE_PARAMETERS  Parameters;
} USBUSER_OPEN_RAW_DEVICE;
typedef USBUSER_OPEN_RAW_DEVICE *PUSBUSER_OPEN_RAW_DEVICE;
#endif

/* USB close raw device parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USB_CLOSE_RAW_DEVICE_PARAMETERS {
    ULONG   xxx;
} USB_CLOSE_RAW_DEVICE_PARAMETERS;
typedef USB_CLOSE_RAW_DEVICE_PARAMETERS *PUSB_CLOSE_RAW_DEVICE_PARAMETERS;
#endif

/* USBUSER_OP_CLOSE_RAW_DEVICE parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USBUSER_CLOSE_RAW_DEVICE {
    USBUSER_REQUEST_HEADER          Header;
    USB_CLOSE_RAW_DEVICE_PARAMETERS Parameters;
} USBUSER_CLOSE_RAW_DEVICE;
typedef USBUSER_CLOSE_RAW_DEVICE    *PUSBUSER_CLOSE_RAW_DEVICE;
#endif

/* USB send raw command parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USB_SEND_RAW_COMMAND_PARAMETERS {
    UCHAR       Usb_bmRequest;
    UCHAR       Usb_bRequest;
    USHORT      Usb_wVlaue;
    USHORT      Usb_wIndex;
    USHORT      Usb_wLength;
    USHORT      DeviceAddress;
    USHORT      MaximumPacketSize;
    ULONG       Timeout;
    ULONG       DataLength;
    USBD_STATUS UsbdStatusCode;
    UCHAR       Data[4];
} USB_SEND_RAW_COMMAND_PARAMETERS;
typedef USB_SEND_RAW_COMMAND_PARAMETERS *PUSB_SEND_RAW_COMMAND_PARAMETERS;
#endif

/* USBUSER_SEND_RAW_COMMAND parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USBUSER_SEND_RAW_COMMAND {
    USBUSER_REQUEST_HEADER          Header;
    USB_SEND_RAW_COMMAND_PARAMETERS Parameters;
} USBUSER_SEND_RAW_COMMAND;
typedef USBUSER_SEND_RAW_COMMAND    *PUSBUSER_SEND_RAW_COMMAND;
#endif

/* USB bandwidth information */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USB_BANDWIDTH_INFO {
    ULONG   DeviceCount;
    ULONG   TotalBusBandwidth;
    ULONG   Total32secBandwidth;
    ULONG   AllocedBulkAndControl;
    ULONG   AllocedIso;
    ULONG   AllocedInterrupt_1ms;
    ULONG   AllocedInterrupt_2ms;
    ULONG   AllocedInterrupt_4ms;
    ULONG   AllocedInterrupt_8ms;
    ULONG   AllocedInterrupt_16ms;
    ULONG   AllocedInterrupt_32ms;
} USB_BANDWIDTH_INFO;
typedef USB_BANDWIDTH_INFO  *PUSB_BANDWIDTH_INFO;
#endif

/* USBUSER_GET_BANDWIDTH_INFORMATION parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USBUSER_BANDWIDTH_INFO_REQUEST {
    USBUSER_REQUEST_HEADER  Header;
    USB_BANDWIDTH_INFO      BandwidthInformation;
} USBUSER_BANDWIDTH_INFO_REQUEST;
typedef USBUSER_BANDWIDTH_INFO_REQUEST  *PUSBUSER_BANDWIDTH_INFO_REQUEST;
#endif

/* USB bus statistics */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USB_BUS_STATISTICS_0 {
    ULONG           DeviceCount;
    LARGE_INTEGER   CurrentSystemTime;
    ULONG           CurrentUsbFrame;
    ULONG           BulkBytes;
    ULONG           IsoBytes;
    ULONG           InterruptBytes;
    ULONG           ControlDataBytes;
    ULONG           PciInterruptCount;
    ULONG           HardResetCount;
    ULONG           WorkerSignalCount;
    ULONG           CommonBufferBytes;
    ULONG           WorkerIdleTimeMs;
    BOOLEAN         RootHubEnabled;
    UCHAR           RootHubDevicePowerState;
    UCHAR           Unused;
    UCHAR           NameIndex;
} USB_BUS_STATISTICS_0;
typedef USB_BUS_STATISTICS_0    *PUSB_BUS_STATISTICS_0;
#endif

/* USBUSER_BUS_STATISTICS_0 parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USBUSER_BUS_STATISTICS_0_REQUEST {
    USBUSER_REQUEST_HEADER  Header;
    USB_BUS_STATISTICS_0    BusStatistics0;
} USBUSER_BUS_STATISTICS_0_REQUEST;
typedef USBUSER_BUS_STATISTICS_0_REQUEST    *PUSBUSER_BUS_STATISTICS_0_REQUEST;
#endif

/* USB driver version parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USB_DRIVER_VERSION_PARAMETERS {
    ULONG   DriverTrackingCode;
    ULONG   USBDI_Version;
    ULONG   USBUSER_Version;
    BOOLEAN CheckedPortDriver;
    BOOLEAN CheckedMiniportDriver;
    USHORT  USB_Version;
} USB_DRIVER_VERSION_PARAMETERS;
typedef USB_DRIVER_VERSION_PARAMETERS   *PUSB_DRIVER_VERSION_PARAMETERS;
#endif

/* USBUSER_GET_USB_DRIVER_VERSION parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USBUSER_GET_DRIVER_VERSION {
    USBUSER_REQUEST_HEADER          Header;
    USB_DRIVER_VERSION_PARAMETERS   Parameters;
} USBUSER_GET_DRIVER_VERSION;
typedef USBUSER_GET_DRIVER_VERSION  *PUSBUSER_GET_DRIVER_VERSION;
#endif

/* USB 2 hardware version parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USB_USB2HW_VERSION_PARAMETERS {
    UCHAR   Usb2HwRevision;
} USB_USB2HW_VERSION_PARAMETERS;
typedef USB_USB2HW_VERSION_PARAMETERS   *PUSB_USB2HW_VERSION_PARAMETERS;
#endif

/* USBUSER_GET_USB2HW_VERSION parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USBUSER_GET_USB2HW_VERSION {
    USBUSER_REQUEST_HEADER          Header;
    USB_USB2HW_VERSION_PARAMETERS   Parameters;
} USBUSER_GET_USB2HW_VERSION;
typedef USBUSER_GET_USB2HW_VERSION  *PUSBUSER_GET_USB2HW_VERSION;
#endif

/* USBUSER_REFRESH_G_REG parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _USBUSER_REFRESH_HCT_REG {
    USBUSER_REQUEST_HEADER  Header;
    ULONG                   Flags;
} USBUSER_REFRESH_HCT_REG;
typedef USBUSER_REFRESH_HCT_REG *PUSBUSER_REFRESH_HCT_REG;
#endif

/* Revert to default packing. */
#include <poppack.h>

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __USBUSER_H__ */
