/*
 *  iprtrmib.h  IP router Management Information Base (MIB) definitions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef __ROUTING_IPRTRMIB_H__
#define __ROUTING_IPRTRMIB_H__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <mprapi.h>
#include <ipifcons.h>
#include <ipmib.h>
#include <tcpmib.h>
#include <udpmib.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Maximum scope name length */
#define MAX_SCOPE_NAME_LEN  255

/* Scope name data types */
#define SN_UNICODE
typedef WCHAR   SN_CHAR;
typedef SN_CHAR SCOPE_NAME_BUFFER[MAX_SCOPE_NAME_LEN + 1];
typedef SN_CHAR *SCOPE_NAME;

/* IP router manager protocol identifier */
#define IPRTRMGR_PID    1000

/* Value used to declare an array of an unknown size */
#ifndef ANY_SIZE
    #define ANY_SIZE    1
#endif

/* MIB variables */
#define IF_NUMBER                           0
#define IF_TABLE                            1
#define IF_ROW                              2
#define IF_STATS                            3
#define IF_ADDRTABLE                        4
#define IF_ADDRROW                          5
#define IF_FORWARDNUMBER                    6
#define IF_FORWARDTABLE                     7
#define IF_FORWARDROW                       8
#define IF_NETTABLE                         9
#define IF_NETROW                           10
#define ICMP_STATS                          11
#define TCP_STATS                           12
#define TCP_TABLE                           13
#define TCP_ROW                             14
#define UDP_STATS                           15
#define UDP_TABLE                           16
#define UDP_ROW                             17
#define MCAST_MFE                           18
#define MCAST_MFE_STATS                     19
#define BEST_IF                             20
#define BEST_ROUTE                          21
#define PROXY_ARP                           22
#define MCAST_IF_ENTRY                      23
#define MCAST_GLOBAL                        24
#define IF_STATUS                           25
#define MCAST_BOUNDARY                      26
#define MCAST_SCOPE                         27
#define DEST_MATCHING                       28
#define DEST_LONGER                         29
#define DEST_SHORTER                        30
#define ROUTE_MATCHING                      31
#define ROUTE_LONGER                        32
#define ROUTE_SHORTER                       33
#define ROUTE_STATE                         34
#define MCAST_MFE_STATS_EX                  35
#define IP6_STATS                           36
#define UDP6_STATS                          37
#define TCP6_STATS                          38
#if (NTDDI_VERSION >= 0x06000000)
    #define NUMBER_OF_EXPORTED_VARIABLES    (TCP6_STATS + 1)
#else
    #define NUMBER_OF_EXPORTED_VARIABLES    (ROUTE_STATE + 1)
#endif

/* Maximum MIB offset */
#define MAX_MIB_OFFSET  8

/* MIB opaque query */
typedef struct _MIB_OPAQUE_QUERY {
    DWORD   dwVarId;
    DWORD   rgdwVarIndex[ANY_SIZE];
} MIB_OPAQUE_QUERY;
typedef MIB_OPAQUE_QUERY    *PMIB_OPAQUE_QUERY;

/* TCP table classes */
typedef enum _TCP_TABLE_CLASS {
    TCP_TABLE_BASIC_LISTENER            = 0,
    TCP_TABLE_BASIC_CONNECTIONS         = 1,
    TCP_TABLE_BASIC_ALL                 = 2,
    TCP_TABLE_BASIC_PID_LISTENER        = 3,
    TCP_TABLE_BASIC_PID_CONNECTIONS     = 4,
    TCP_TABLE_BASIC_PID_ALL             = 5,
    TCP_TABLE_BASIC_MODULE_LISTENER     = 6,
    TCP_TABLE_BASIC_MODULE_CONNECTIONS  = 7,
    TCP_TABLE_BASIC_MODULE_ALL          = 8
} TCP_TABLE_CLASS;
typedef TCP_TABLE_CLASS *PTCP_TABLE_CLASS;

/* UDP table classes */
typedef enum _UDP_TABLE_CLASS {
    UDP_TABLE_BASIC         = 0,
    UDP_TABLE_OWNER_PID     = 1,
    UDP_TABLE_OWNER_MODULE  = 2
} UDP_TABLE_CLASS;
typedef UDP_TABLE_CLASS *PUDP_TABLE_CLASS;

/* TCP/IP owner module information classes */
typedef enum _TCPIP_OWNER_MODULE_INFO_CLASS {
    TCPIP_OWNER_MODULE_INFO_BASIC   = 0
} TCPIP_OWNER_MODULE_INFO_CLASS;
typedef TCPIP_OWNER_MODULE_INFO_CLASS   *PTCPIP_OWNER_MODULE_INFO_CLASS;

/* TCP/IP owner module basic information */
typedef struct _TCPIP_OWNER_MODULE_BASIC_INFO {
    PWCHAR  pModuleName;
    PWCHAR  pModulePath;
} TCPIP_OWNER_MODULE_BASIC_INFO;
typedef TCPIP_OWNER_MODULE_BASIC_INFO   *PTCPIP_OWNER_MODULE_BASIC_INFO;

/* MIB IP multicast boundary */
typedef struct _MIB_IPMCAST_BOUNDARY {
    DWORD   dwIfIndex;
    DWORD   dwGroupAddress;
    DWORD   dwGroupMask;
    DWORD   dwStatus;
} MIB_IPMCAST_BOUNDARY;
typedef MIB_IPMCAST_BOUNDARY    *PMIB_IPMCAST_BOUNDARY;

/* MIB IP multicast boundary table */
typedef struct _MIB_IPMCAST_BOUNDARY_TABLE {
    DWORD                   dwNumEntries;
    MIB_IPMCAST_BOUNDARY    table[ANY_SIZE];
} MIB_IPMCAST_BOUNDARY_TABLE;
typedef MIB_IPMCAST_BOUNDARY_TABLE  *PMIB_IPMCAST_BOUNDARY_TABLE;

/* MIB boundary row */
typedef struct {
    DWORD   dwGroupAddress;
    DWORD   dwGroupMask;
} MIB_BOUNDARYROW;
typedef MIB_BOUNDARYROW *PMIB_BOUNDARYROW;

/* MIB multicast limit row */
typedef struct {
    DWORD   dwTtl;
    DWORD   dwRateLimit;
} MIB_MCAST_LIMIT_ROW;
typedef MIB_MCAST_LIMIT_ROW *PMIB_MCAST_LIMIT_ROW;

/* MIB IP multicast scope */
typedef struct _MIB_IPMCAST_SCOPE {
    DWORD               dwGroupAddress;
    DWORD               dwGroupMask;
    SCOPE_NAME_BUFFER   snNameBuffer;
    DWORD               dwStatus;
} MIB_IPMCAST_SCOPE;
typedef MIB_IPMCAST_SCOPE   *PMIB_IPMCAST_SCOPE;

/* MIB IP destination row */
typedef struct _MIB_IPDESTROW {
#ifdef __cplusplus
    MIB_IPFORWARDROW    ForwardRow;
#else
    MIB_IPFORWARDROW;
#endif
    DWORD               dwForwardPreference;
    DWORD               dwForwardViewSet;
} MIB_IPDESTROW;
typedef MIB_IPDESTROW   *PMIB_IPDESTROW;

/* MIB IP destination table */
typedef struct _MIB_IPDESTTABLE {
    DWORD           dwNumEntries;
    MIB_IPDESTROW   table[ANY_SIZE];
} MIB_IPDESTTABLE;
typedef MIB_IPDESTTABLE *PMIB_IPDESTTABLE;

/* MIB best interface */
typedef struct _MIB_BEST_IF {
    DWORD   dwDestAddr;
    DWORD   dwIfIndex;
} MIB_BEST_IF;
typedef MIB_BEST_IF *PMIB_BEST_IF;

/* MIB proxy Address Resolution Protocol (ARP) */
typedef struct _MIB_PROXYARP {
    DWORD   dwAddress;
    DWORD   dwMask;
    DWORD   dwIfIndex;
} MIB_PROXYARP;
typedef MIB_PROXYARP    *PMIB_PROXYARP;

/* MIB interface status */
typedef struct _MIB_IFSTATUS {
    DWORD   dwIfIndex;
    DWORD   dwAdminStatus;
    DWORD   dwOperationalStatus;
    BOOL    bMHbeatActive;
    BOOL    bMHbeatAlive;
} MIB_IFSTATUS;
typedef MIB_IFSTATUS    *PMIB_IFSTATUS;

/* MIB route status */
typedef struct _MIB_ROUTESTATE {
    BOOL    bRoutesSetToStack;
} MIB_ROUTESTATE;
typedef MIB_ROUTESTATE  *PMIB_ROUTESTATE;

/* MIB opaque information */
typedef struct _MIB_OPAQUE_INFO {
    DWORD   dwId;
    union {
        ULONGLONG   ullAlign;
        BYTE        rgbyData[1];
    };
} MIB_OPAQUE_INFO;
typedef MIB_OPAQUE_INFO *PMIB_OPAQUE_INFO;

/* Macros to manipulate MIB buffers */
#define MIB_INFO_SIZE( x ) \
    (MAX_MIB_OFFSET + sizeof( x ))
#define MIB_INFO_SIZE_IN_DWORDS( x ) \
    (MIB_INFO_SIZE( x ) / sizeof( DWORD ) + 1)
#define DEFINE_MIB_BUFFER( p1, p2, p3 ) \
    DWORD               __rgdwBuff[MIB_INFO_SIZE_IN_DWORDS( p2 )]; \
    PMIB_OPAQUE_INFO    p1 = (PMIB_OPAQUE_INFO)__rgdwBuff; \
    p2                  *p3 = (p2 *)(p1->rgbyData)
#define CAST_MIB_INFO( x, p1, p2 ) \
    p3 = (p2)(p1->rgbyData)

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __ROUTING_IPRTRMIB_H__ */
