/*
 *  mgmtapi.h   SNMP management API functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _INC_MGMTAPI
#define _INC_MGMTAPI

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <snmp.h>
#include <winsock.h>

#ifdef __cplusplus
extern "C" {
#endif

/* SNMP manager session data type */
typedef PVOID   LPSNMP_MGR_SESSION;

/* SNMP management API error codes */
#define SNMP_MGMTAPI_TIMEOUT            40
#define SNMP_MGMTAPI_SELECT_FDERRORS    41
#define SNMP_MGMTAPI_TRAP_ERRORS        42
#define SNMP_MGMTAPI_TRAP_DUPINIT       43
#define SNMP_MGMTAPI_NOTRAPS            44
#define SNMP_MGMTAPI_AGAIN              45
#define SNMP_MGMTAPI_INVALID_CTL        46
#define SNMP_MGMTAPI_INVALID_SESSION    47
#define SNMP_MGMTAPI_INVALID_BUFFER     48

/* SNMP management control codes */
#define MGMCTL_SETAGENTPORT 0x00000001L

/* Functions in MGMTAPI.DLL */
BOOL SNMP_FUNC_TYPE                 SnmpMgrClose( LPSNMP_MGR_SESSION );
BOOL SNMP_FUNC_TYPE                 SnmpMgrCtl( LPSNMP_MGR_SESSION, DWORD, LPVOID, DWORD, LPVOID, DWORD, LPDWORD );
BOOL SNMP_FUNC_TYPE                 SnmpMgrGetTrap( AsnObjectIdentifier *, AsnNetworkAddress *, AsnInteger *, AsnInteger *, AsnTimeticks *, RFC1157VarBindList * );
BOOL SNMP_FUNC_TYPE                 SnmpMgrGetTrapEx( AsnObjectIdentifier *, AsnNetworkAddress *, AsnNetworkAddress *, AsnInteger *, AsnInteger *, AsnOctetString *, AsnTimeticks *, RFC1157VarBindList * );
BOOL SNMP_FUNC_TYPE                 SnmpMgrOidToStr( AsnObjectIdentifier *, LPSTR * );
LPSNMP_MGR_SESSION SNMP_FUNC_TYPE   SnmpMgrOpen( LPSTR, LPSTR, INT, INT );
SNMPAPI SNMP_FUNC_TYPE              SnmpMgrRequest( LPSNMP_MGR_SESSION, BYTE, RFC1157VarBindList *, AsnInteger *, AsnInteger * );
BOOL SNMP_FUNC_TYPE                 SnmpMgrStrToOid( LPSTR, AsnObjectIdentifier * );
BOOL SNMP_FUNC_TYPE                 SnmpMgrTrapListen( HANDLE * );

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _INC_MGMTAPI */
