/*
 *  windot11.h  802.11 definitions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef __WINDOT11_H__
#define __WINDOT11_H__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <ntddndis.h>
#include <wlantypes.h>

#ifdef __cplusplus
extern "C" {
#endif

/* ExtAP and Virtual WiFi are supported on Windows 7 and later. */
#if (NTDDI_VERSION >= 0x06010000) || NDIS_SUPPORT_NDIS620
    #define NWF_EXTAP_SUPPORTED
    #define NWF_VWIFI_SUPPORTED
#endif

/* Primitive data types */
#if (NTDDI_VERSION >= 0x06000000)
typedef ULONG   DOT11_ASSOC_STATUS;
#endif

/* 802.11 BSSID list revision number */
#define DOT11_BSSID_LIST_REVISION_1 1

/* 802.11 rate set maximum length */
#define DOT11_RATE_SET_MAX_LENGTH   126

/* NDIS packet types */
#if (NTDDI_VERSION >= 0x06000000)
    #define NDIS_PACKET_TYPE_MEDIA_SPECIFIC_MASK        0x0FFF0000L
    #define NDIS_PACKET_TYPE_802_11_DIRECTED_DATA       NDIS_PACKET_TYPE_DIRECTED
    #define NDIS_PACKET_TYPE_802_11_BROADCAST_DATA      NDIS_PACKET_TYPE_BROADCAST
    #define NDIS_PACKET_TYPE_802_11_MULTICAST_DATA      NDIS_PACKET_TYPE_MULTICAST
    #define NDIS_PACKET_TYPE_802_11_ALL_MULTICAST_DATA  NDIS_PACKET_TYPE_ALL_MULTICAST
    #define NDIS_PACKET_TYPE_802_11_PROMISCUOUS_DATA    NDIS_PACKET_TYPE_PROMISCUOUS
    #define NDIS_PACKET_TYPE_802_11_RAW_DATA            0x00010000L
    #define NDIS_PACKET_TYPE_802_11_DIRECTED_MGMT       0x00020000L
    #define NDIS_PACKET_TYPE_802_11_BROADCAST_MGMT      0x00040000L
    #define NDIS_PACKET_TYPE_802_11_MULTICAST_MGMT      0x00080000L
    #define NDIS_PACKET_TYPE_802_11_ALL_MULTICAST_MGMT  0x00100000L
    #define NDIS_PACKET_TYPE_802_11_PROMISCUOUS_MGMT    0x00200000L
    #define NDIS_PACKET_TYPE_802_11_RAW_MGMT            0x00400000L
    #define NDIS_PACKET_TYPE_802_11_DIRECTED_CTRL       0x00800000L
    #define NDIS_PACKET_TYPE_802_11_BROADCAST_CTRL      0x01000000L
    #define NDIS_PACKET_TYPE_802_11_PROMISCUOUS_CTRL    0x02000000L
    #define NDIS_PACKET_TYPE_ALL_802_11_FILTERS \
        (NDIS_PACKET_TYPE_DIRECTED | NDIS_PACKET_TYPE_MULTICAST | \
        NDIS_PACKET_TYPE_ALL_MULTICAST | NDIS_PACKET_TYPE_BROADCAST | \
        NDIS_PACKET_TYPE_PROMISCUOUS | NDIS_PACKET_TYPE_802_11_RAW_DATA | \
        NDIS_PACKET_TYPE_802_11_DIRECTED_MGMT | \
        NDIS_PACKET_TYPE_802_11_BROADCAST_MGMT | \
        NDIS_PACKET_TYPE_802_11_MULTICAST_MGMT | \
        NDIS_PACKET_TYPE_802_11_ALL_MULTICAST_MGMT | \
        NDIS_PACKET_TYPE_802_11_PROMISCUOUS_MGMT | NDIS_PACKET_TYPE_802_11_RAW_MGMT | \
        NDIS_PACKET_TYPE_802_11_DIRECTED_CTRL | \
        NDIS_PACKET_TYPE_802_11_BROADCAST_CTRL | \
        NDIS_PACKET_TYPE_802_11_PROMISCUOUS_CTRL)
#endif

/* 802.11 maximum and minimum PDU sizes */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_MAX_PDU_SIZE  2346
    #define DOT11_MIN_PDU_SIZE  256
#endif

/* 802.11 maximum default key number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_MAX_NUM_DEFAULT_KEY   4
#endif

/* NWF constants */
#if (NTDDI_VERSION >= 0x06000000)
    #define NWF_MANDATORY_OID   0x01
    #define NWF_OPTIONAL_OID    0x02
    #define NWF_OPERATIONAL_OID 0x01
    #define NWF_STATISTICS_OID  0x02
#endif

/* Macro to define NWF object identifiers */
#if (NTDDI_VERSION >= 0x06000000)
    #define NWF_DEFINE_OID( p1, p2, p3 ) \
        (0x0E000000L | ((p2) << 16) | ((p3) << 8) | (p1))
#endif

/* NDIS 802.11 object identifiers */
#if (NTDDI_VERSION >= 0x06000000)
    #define OID_DOT11_NDIS_START                            0x0D010300L
    #define OID_DOT11_OFFLOAD_CAPABILITY                    (OID_DOT11_NDIS_START + 0)
    #define OID_DOT11_CURRENT_OFFLOAD_CAPABILITY            (OID_DOT11_NDIS_START + 1)
    #define OID_DOT11_WEP_OFFLOAD                           (OID_DOT11_NDIS_START + 2)
    #define OID_DOT11_WEP_UPLOAD                            (OID_DOT11_NDIS_START + 3)
    #define OID_DOT11_DEFAULT_WEP_OFFLOAD                   (OID_DOT11_NDIS_START + 4)
    #define OID_DOT11_DEFAULT_WEP_UPLOAD                    (OID_DOT11_NDIS_START + 5)
    #define OID_DOT11_MPDU_MAX_LENGTH                       (OID_DOT11_NDIS_START + 6)
    #define OID_DOT11_OPERATION_MODE_CAPABILITY             (OID_DOT11_NDIS_START + 7)
    #define OID_DOT11_CURRENT_OPERATION_MODE                (OID_DOT11_NDIS_START + 8)
    #define OID_DOT11_CURRENT_PACKET_FILTER                 (OID_DOT11_NDIS_START + 9)
    #define OID_DOT11_ATIM_WINDOW                           (OID_DOT11_NDIS_START + 10)
    #define OID_DOT11_SCAN_REQUEST                          (OID_DOT11_NDIS_START + 11)
    #define OID_DOT11_CURRENT_PHY_TYPE                      (OID_DOT11_NDIS_START + 12)
    #define OID_DOT11_JOIN_REQUEST                          (OID_DOT11_NDIS_START + 13)
    #define OID_DOT11_START_REQUEST                         (OID_DOT11_NDIS_START + 14)
    #define OID_DOT11_UPDATE_IE                             (OID_DOT11_NDIS_START + 15)
    #define OID_DOT11_RESET_REQUEST                         (OID_DOT11_NDIS_START + 16)
    #define OID_DOT11_NIC_POWER_STATE                       (OID_DOT11_NDIS_START + 17)
    #define OID_DOT11_OPTIONAL_CAPABILITY                   (OID_DOT11_NDIS_START + 18)
    #define OID_DOT11_CURRENT_OPTIONAL_CAPABILITY           (OID_DOT11_NDIS_START + 19)
    #define OID_DOT11_STATION_ID                            (OID_DOT11_NDIS_START + 20)
    #define OID_DOT11_MEDIUM_OCCUPANCY_LIMIT                (OID_DOT11_NDIS_START + 21)
    #define OID_DOT11_CF_POLLABLE                           (OID_DOT11_NDIS_START + 22)
    #define OID_DOT11_CFP_PERIOD                            (OID_DOT11_NDIS_START + 23)
    #define OID_DOT11_CFP_MAX_DURATION                      (OID_DOT11_NDIS_START + 24)
    #define OID_DOT11_POWER_MGMT_MODE                       (OID_DOT11_NDIS_START + 25)
    #define OID_DOT11_OPERATIONAL_RATE_SET                  (OID_DOT11_NDIS_START + 26)
    #define OID_DOT11_BEACON_PERIOD                         (OID_DOT11_NDIS_START + 27)
    #define OID_DOT11_DTIM_PERIOD                           (OID_DOT11_NDIS_START + 28)
    #define OID_DOT11_WEP_ICV_ERROR_COUNT                   (OID_DOT11_NDIS_START + 29)
    #define OID_DOT11_MAC_ADDRESS                           (OID_DOT11_NDIS_START + 30)
    #define OID_DOT11_RTS_THRESHOLD                         (OID_DOT11_NDIS_START + 31)
    #define OID_DOT11_SHORT_RETRY_LIMIT                     (OID_DOT11_NDIS_START + 32)
    #define OID_DOT11_LONG_RETRY_LIMIT                      (OID_DOT11_NDIS_START + 33)
    #define OID_DOT11_FRAGMENTATION_THRESHOLD               (OID_DOT11_NDIS_START + 34)
    #define OID_DOT11_MAX_TRANSMIT_MSDU_LIFETIME            (OID_DOT11_NDIS_START + 35)
    #define OID_DOT11_MAX_RECEIVE_LIFETIME                  (OID_DOT11_NDIS_START + 36)
    #define OID_DOT11_COUNTERS_ENTRY                        (OID_DOT11_NDIS_START + 37)
    #define OID_DOT11_SUPPORTED_PHY_TYPES                   (OID_DOT11_NDIS_START + 38)
    #define OID_DOT11_CURRENT_REG_DOMAIN                    (OID_DOT11_NDIS_START + 39)
    #define OID_DOT11_TEMP_TYPE                             (OID_DOT11_NDIS_START + 40)
    #define OID_DOT11_CURRENT_TX_ANTENNA                    (OID_DOT11_NDIS_START + 41)
    #define OID_DOT11_DIVERSITY_SUPPORT                     (OID_DOT11_NDIS_START + 42)
    #define OID_DOT11_CURRENT_RX_ANTENNA                    (OID_DOT11_NDIS_START + 43)
    #define OID_DOT11_SUPPORTED_POWER_LEVELS                (OID_DOT11_NDIS_START + 44)
    #define OID_DOT11_CURRENT_TX_POWER_LEVEL                (OID_DOT11_NDIS_START + 45)
    #define OID_DOT11_HOP_TIME                              (OID_DOT11_NDIS_START + 46)
    #define OID_DOT11_CURRENT_CHANNEL_NUMBER                (OID_DOT11_NDIS_START + 47)
    #define OID_DOT11_MAX_DWELL_TIME                        (OID_DOT11_NDIS_START + 48)
    #define OID_DOT11_CURRENT_DWELL_TIME                    (OID_DOT11_NDIS_START + 49)
    #define OID_DOT11_CURRENT_SET                           (OID_DOT11_NDIS_START + 50)
    #define OID_DOT11_CURRENT_PATTERN                       (OID_DOT11_NDIS_START + 51)
    #define OID_DOT11_CURRENT_INDEX                         (OID_DOT11_NDIS_START + 52)
    #define OID_DOT11_CURRENT_CHANNEL                       (OID_DOT11_NDIS_START + 53)
    #define OID_DOT11_CCA_MODE_SUPPORTED                    (OID_DOT11_NDIS_START + 54)
    #define OID_DOT11_CURRENT_CCA_MODE                      (OID_DOT11_NDIS_START + 55)
    #define OID_DOT11_ED_THRESHOLD                          (OID_DOT11_NDIS_START + 56)
    #define OID_DOT11_CCA_WATCHDOG_TIMER_MAX                (OID_DOT11_NDIS_START + 57)
    #define OID_DOT11_CCA_WATCHDOG_COUNT_MAX                (OID_DOT11_NDIS_START + 58)
    #define OID_DOT11_CCA_WATCHDOG_TIMER_MIN                (OID_DOT11_NDIS_START + 59)
    #define OID_DOT11_CCA_WATCHDOG_COUNT_MIN                (OID_DOT11_NDIS_START + 60)
    #define OID_DOT11_REG_DOMAINS_SUPPORT_VALUE             (OID_DOT11_NDIS_START + 61)
    #define OID_DOT11_SUPPORTED_TX_ANTENNA                  (OID_DOT11_NDIS_START + 62)
    #define OID_DOT11_SUPPORTED_RX_ANTENNA                  (OID_DOT11_NDIS_START + 63)
    #define OID_DOT11_DIVERSITY_SELECTION_RX                (OID_DOT11_NDIS_START + 64)
    #define OID_DOT11_SUPPORTED_DATA_RATES_VALUE            (OID_DOT11_NDIS_START + 65)
    #define OID_DOT11_CURRENT_FREQUENCY                     (OID_DOT11_NDIS_START + 66)
    #define OID_DOT11_TI_THRESHOLD                          (OID_DOT11_NDIS_START + 67)
    #define OID_DOT11_FREQUENCY_BAND_SUPPORTED              (OID_DOT11_NDIS_START + 68)
    #define OID_DOT11_SHORT_PREAMBLE_OPTION_IMPLEMENTED     (OID_DOT11_NDIS_START + 69)
    #define OID_DOT11_PBCC_OPTION_IMPLEMENTED               (OID_DOT11_NDIS_START + 70)
    #define OID_DOT11_CHANNEL_AGILITY_PRESENT               (OID_DOT11_NDIS_START + 71)
    #define OID_DOT11_CHANNEL_AGILITY_ENABLED               (OID_DOT11_NDIS_START + 72)
    #define OID_DOT11_HR_CCA_MODE_SUPPORTED                 (OID_DOT11_NDIS_START + 73)
    #define OID_DOT11_MULTI_DOMAIN_CAPABILITY_IMPLEMENTED   (OID_DOT11_NDIS_START + 74)
    #define OID_DOT11_MULTI_DOMAIN_CAPABILITY_ENABLED       (OID_DOT11_NDIS_START + 75)
    #define OID_DOT11_COUNTRY_STRING                        (OID_DOT11_NDIS_START + 76)
    #define OID_DOT11_MULTI_DOMAIN_CAPABILITY               (OID_DOT11_NDIS_START + 77)
    #define OID_DOT11_EHCC_PRIME_RADIX                      (OID_DOT11_NDIS_START + 78)
    #define OID_DOT11_EHCC_NUMBER_OF_CHANNELS_FAMILY_INDEX  (OID_DOT11_NDIS_START + 79)
    #define OID_DOT11_EHCC_CAPABILITY_IMPLEMENTED           (OID_DOT11_NDIS_START + 80)
    #define OID_DOT11_EHCC_CAPABILITY_ENABLED               (OID_DOT11_NDIS_START + 81)
    #define OID_DOT11_HOP_ALGORITHM_ADOPTED                 (OID_DOT11_NDIS_START + 82)
    #define OID_DOT11_RANDOM_TABLE_FLAG                     (OID_DOT11_NDIS_START + 83)
    #define OID_DOT11_NUMBER_OF_HOPPING_SETS                (OID_DOT11_NDIS_START + 84)
    #define OID_DOT11_HOP_MODULUS                           (OID_DOT11_NDIS_START + 85)
    #define OID_DOT11_HOP_OFFSET                            (OID_DOT11_NDIS_START + 86)
    #define OID_DOT11_HOPPING_PATTERN                       (OID_DOT11_NDIS_START + 87)
    #define OID_DOT11_RANDOM_TABLE_FIELD_NUMBER             (OID_DOT11_NDIS_START + 88)
    #define OID_DOT11_WPA_TSC                               (OID_DOT11_NDIS_START + 89)
    #define OID_DOT11_RSSI_RANGE                            (OID_DOT11_NDIS_START + 90)
    #define OID_DOT11_RF_USAGE                              (OID_DOT11_NDIS_START + 91)
    #define OID_DOT11_NIC_SPECIFIC_EXTENSION                (OID_DOT11_NDIS_START + 92)
    #define OID_DOT11_AP_JOIN_REQUEST                       (OID_DOT11_NDIS_START + 93)
    #define OID_DOT11_ERP_PBCC_OPTION_IMPLEMENTED           (OID_DOT11_NDIS_START + 94)
    #define OID_DOT11_ERP_PBCC_OPTION_ENABLED               (OID_DOT11_NDIS_START + 95)
    #define OID_DOT11_DSSS_OFDM_OPTION_IMPLEMENTED          (OID_DOT11_NDIS_START + 96)
    #define OID_DOT11_DSSS_OFDM_OPTION_ENABLED              (OID_DOT11_NDIS_START + 97)
    #define OID_DOT11_SHORT_SLOT_TIME_OPTION_IMPLEMENTED    (OID_DOT11_NDIS_START + 98)
    #define OID_DOT11_SHORT_SLOT_TIME_OPTION_ENABLED        (OID_DOT11_NDIS_START + 99)
    #define OID_DOT11_MAX_MAC_ADDRESS_STATES                (OID_DOT11_NDIS_START + 100)
    #define OID_DOT11_RECV_SENSITIVITY_LIST                 (OID_DOT11_NDIS_START + 101)
    #define OID_DOT11_WME_IMPLEMENTED                       (OID_DOT11_NDIS_START + 102)
    #define OID_DOT11_WME_ENABLED                           (OID_DOT11_NDIS_START + 103)
    #define OID_DOT11_WME_AC_PARAMETERS                     (OID_DOT11_NDIS_START + 104)
    #define OID_DOT11_WME_UPDATE_IE                         (OID_DOT11_NDIS_START + 105)
    #define OID_DOT11_QOS_TX_QUEUES_SUPPORTED               (OID_DOT11_NDIS_START + 106)
    #define OID_DOT11_QOS_TX_DURATION                       (OID_DOT11_NDIS_START + 107)
    #define OID_DOT11_QOS_TX_MEDIUM_TIME                    (OID_DOT11_NDIS_START + 108)
    #define OID_DOT11_SUPPORTED_OFDM_FREQUENCY_LIST         (OID_DOT11_NDIS_START + 109)
    #define OID_DOT11_SUPPORTED_DSSS_CHANNEL_LIST           (OID_DOT11_NDIS_START + 110)
#endif

/* 802.11 offload capability flags */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_HW_WEP_SUPPORTED_TX           0x00000001L
    #define DOT11_HW_WEP_SUPPORTED_RX           0x00000002L
    #define DOT11_HW_FRAGMENTATION_SUPPORTED    0x00000004L
    #define DOT11_HW_DEFRAGMENTATION_SUPPORTED  0x00000008L
    #define DOT11_HW_MSDU_AUTH_SUPPORTED_TX     0x00000010L
    #define DOT11_HW_MSDU_AUTH_SUPPORTED_RX     0x00000020L
#endif

/* 802.11 WEP algorithm flags */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_CONF_ALGO_WEP_RC4 0x00000001L
    #define DOT11_CONF_ALGO_TKIP    0x00000002L
#endif

/* 802.11 intergrity algorithm flags */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_AUTH_ALGO_MICHAEL 0x00000001L
#endif

/* 802.11 operation modes */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_OPERATION_MODE_UNKNOWN            0x00000000L
    #define DOT11_OPERATION_MODE_STATION            0x00000001L
    #define DOT11_OPERATION_MODE_AP                 0x00000002L
    #define DOT11_OPERATION_MODE_EXTENSIBLE_STATION 0x00000004L
    #define DOT11_OPERATION_MODE_EXTENSIBLE_AP      0x00000008L
    #define DOT11_OPERATION_MODE_NETWORK_MONITOR    0x80000000L
#endif

/* 802.11 packet types */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_PACKET_TYPE_DIRECTED_CTRL         0x00000001L
    #define DOT11_PACKET_TYPE_DIRECTED_MGMT         0x00000002L
    #define DOT11_PACKET_TYPE_DIRECTED_DATA         0x00000004L
    #define DOT11_PACKET_TYPE_MULTICAST_CTRL        0x00000008L
    #define DOT11_PACKET_TYPE_MULTICAST_MGMT        0x00000010L
    #define DOT11_PACKET_TYPE_MULTICAST_DATA        0x00000020L
    #define DOT11_PACKET_TYPE_BROADCAST_CTRL        0x00000040L
    #define DOT11_PACKET_TYPE_BROADCAST_MGMT        0x00000080L
    #define DOT11_PACKET_TYPE_BROADCAST_DATA        0x00000100L
    #define DOT11_PACKET_TYPE_PROMISCUOUS_CTRL      0x00000200L
    #define DOT11_PACKET_TYPE_PROMISCUOUS_MGMT      0x00000400L
    #define DOT11_PACKET_TYPE_PROMISCUOUS_DATA      0x00000800L
    #define DOT11_PACKET_TYPE_ALL_MULTICAST_CTRL    0x00001000L
    #define DOT11_PACKET_TYPE_ALL_MULTICAST_MGMT    0x00002000L
    #define DOT11_PACKET_TYPE_ALL_MULTICAST_DATA    0x00004000L
#endif

/* 802.11 physical type list revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_PHY_TYPE_LIST_REVISION_1  1
#endif

/* 802.11 capability information flags */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_CAPABILITY_INFO_ESS           0x0001
    #define DOT11_CAPABILITY_INFO_IBSS          0x0002
    #define DOT11_CAPABILITY_INFO_CF_POLLABLE   0x0004
    #define DOT11_CAPABILITY_INFO_CF_POLL_REQ   0x0008
    #define DOT11_CAPABILITY_INFO_PRIVACY       0x0010
    #define DOT11_CAPABILITY_SHORT_PREAMBLE     0x0020
    #define DOT11_CAPABILITY_PBCC               0x0040
    #define DOT11_CAPABILITY_CHANNEL_AGILITY    0x0080
    #define DOT11_CAPABILITY_SHORT_SLOT_TIME    0x0400
    #define DOT11_CAPABILITY_DSSSOFDM           0x2000
#endif

/* 802.11 power save levels */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_POWER_SAVE_LEVEL_MAX_PSP  1L
    #define DOT11_POWER_SAVE_LEVEL_FAST_PSP 2L
#endif

/* 802.11 registration domains */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_REG_DOMAIN_OTHER  0x00000000L
    #define DOT11_REG_DOMAIN_FCC    0x00000010L
    #define DOT11_REG_DOMAIN_DOC    0x00000020L
    #define DOT11_REG_DOMAIN_ETSI   0x00000030L
    #define DOT11_REG_DOMAIN_SPAIN  0x00000031L
    #define DOT11_REG_DOMAIN_FRANCE 0x00000032L
    #define DOT11_REG_DOMAIN_MKK    0x00000040L
#endif

/* 802.11 CCA modes */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_CCA_MODE_ED_ONLY          0x00000001L
    #define DOT11_CCA_MODE_CS_ONLY          0x00000002L
    #define DOT11_CCA_MODE_ED_and_CS        0x00000004L
    #define DOT11_CCA_MODE_CS_WITH_TIMER    0x00000008L
    #define DOT11_CCA_MODE_HRCS_AND_ED      0x00000010L
#endif

/* Maximum number of supported rates */
#if (NTDDI_VERSION >= 0x06000000)
    #define MAX_NUM_SUPPORTED_RATES     8
    #define MAX_NUM_SUPPORTED_RATES_V2  255
#endif

/* 802.11 frequency bands */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_FREQUENCY_BANDS_LOWER     0x00000001L
    #define DOT11_FREQUENCY_BANDS_MIDDLE    0x00000002L
    #define DOT11_FREQUENCY_BANDS_UPPER     0x00000004L
#endif

/* 802.11 HR-CCA modes */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_HR_CCA_MODE_ED_ONLY       0x00000001L
    #define DOT11_HR_CCA_MODE_CS_ONLY       0x00000002L
    #define DOT11_HR_CCA_MODE_CS_AND_ED     0x00000004L
    #define DOT11_HR_CCA_MODE_CS_WITH_TIMER 0x00000008L
    #define DOT11_HR_CCA_MODE_HRCS_AND_ED   0x00000010L
#endif

/* NWF object identifiers */
#if (NTDDI_VERSION >= 0x06000000)
    #define OID_DOT11_AUTO_CONFIG_ENABLED \
        NWF_DEFINE_OID( 120, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_ENUM_BSS_LIST \
        NWF_DEFINE_OID( 121, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_FLUSH_BSS_LIST \
        NWF_DEFINE_OID( 122, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_POWER_MGMT_REQUEST \
        NWF_DEFINE_OID( 123, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_DESIRED_SSID_LIST \
        NWF_DEFINE_OID( 124, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_EXCLUDED_MAC_ADDRESS_LIST \
        NWF_DEFINE_OID( 125, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_DESIRED_BSSID_LIST \
        NWF_DEFINE_OID( 126, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_DESIRED_BSS_TYPE \
        NWF_DEFINE_OID( 127, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_PMKID_LIST \
        NWF_DEFINE_OID( 128, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_CONNECT_REQUEST \
        NWF_DEFINE_OID( 129, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_EXCLUDE_UNENCRYPTED \
        NWF_DEFINE_OID( 130, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_STATISTICS \
        NWF_DEFINE_OID( 131, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_PRIVACY_EXEMPTION_LIST \
        NWF_DEFINE_OID( 132, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_ENABLED_AUTHENTICATION_ALGORITHM \
        NWF_DEFINE_OID( 133, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_SUPPORTED_UNICAST_ALGORITHM_PAIR \
        NWF_DEFINE_OID( 134, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_ENABLED_UNICAST_CIPHER_ALGORITHM \
        NWF_DEFINE_OID( 135, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_SUPPORTED_MULTICAST_ALGORITHM_PAIR \
        NWF_DEFINE_OID( 136, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_ENABLED_MULTICAST_CIPHER_ALGORITHM \
        NWF_DEFINE_OID( 137, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_CIPHER_DEFAULT_KEY_ID \
        NWF_DEFINE_OID( 138, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_CIPHER_DEFAULT_KEY \
        NWF_DEFINE_OID( 139, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_CIPHER_KEY_MAPPING_KEY \
        NWF_DEFINE_OID( 140, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_ENUM_ASSOCIATION_INFO \
        NWF_DEFINE_OID( 141, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_DISCONNECT_REQUEST \
        NWF_DEFINE_OID( 142, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_UNICAST_USE_GROUP_ENABLED \
        NWF_DEFINE_OID( 143, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_HARDWARE_PHY_STATE \
        NWF_DEFINE_OID( 144, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_DESIRED_PHY_LIST \
        NWF_DEFINE_OID( 145, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_CURRENT_PHY_ID \
        NWF_DEFINE_OID( 146, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_MEDIA_STREAMING_ENABLED \
        NWF_DEFINE_OID( 147, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_UNREACHABLE_DETECTION_THRESHOLD \
        NWF_DEFINE_OID( 148, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_ACTIVE_PHY_LIST \
        NWF_DEFINE_OID( 149, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_EXTSTA_CAPABILITY \
        NWF_DEFINE_OID( 150, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_DATA_RATE_MAPPING_TABLE \
        NWF_DEFINE_OID( 151, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_SUPPORTED_COUNTRY_OR_REGION_STRING \
        NWF_DEFINE_OID( 152, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_DESIRED_COUNTRY_OR_REGION_STRING \
        NWF_DEFINE_OID( 153, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_PORT_STATE_NOTIFICATION \
        NWF_DEFINE_OID( 154, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_IBSS_PARAMS \
        NWF_DEFINE_OID( 155, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_QOS_PARAMS \
        NWF_DEFINE_OID( 156, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_SAFE_MODE_ENABLED \
        NWF_DEFINE_OID( 157, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_HIDDEN_NETWORK_ENABLED \
        NWF_DEFINE_OID( 158, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_ASSOCIATION_PARAMS \
        NWF_DEFINE_OID( 159, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID )
#endif

/* 802.11 autoconfiguration enabled flags */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_PHY_AUTO_CONFIG_ENABLED_FLAG  0x00000001L
    #define DOT11_MAC_AUTO_CONFIG_ENABLED_FLAG  0x00000002L
#endif

/* 802.11 BSS entry byte array revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_BSS_ENTRY_BYTE_ARRAY_REVISION_1   1
#endif

/* 802.11 power saving values */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_POWER_SAVING_NO_POWER_SAVING  0
    #define DOT11_POWER_SAVING_FAST_PSP         8
    #define DOT11_POWER_SAVING_MAX_PSP          16
    #define DOT11_POWER_SAVING_MAXIMUM_LEVEL    24
#endif

/* 802.11 SSID list revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_SSID_LIST_REVISION_1  1
#endif

/* 802.11 MAC address list revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_MAC_ADDRESS_LIST_REVISION_1   1
#endif

/* 802.11 PMKID list revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_PMKID_LIST_REVISION_1 1
#endif

/* 802.11 statistics special value */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_STATISTICS_UNKNOWN    0xFFFFFFFFFFFFFFFFLL
#endif

/* 802.11 statistics revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_STATISTICS_REVISION_1 1
#endif

/* 802.11 exemption action types */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_EXEMPT_NO_EXEMPTION                   0
    #define DOT11_EXEMPT_ALWAYS                         1
    #define DOT11_EXEMPT_ON_KEY_MAPPING_KEY_UNAVAILABLE 2
#endif

/* 802.11 exemption packet types */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_EXEMPT_UNICAST    1
    #define DOT11_EXEMPT_MULTICAST  2
    #define DOT11_EXEMPT_BOTH       3
#endif

/* 802.11 privacy exemption list revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_PRIVACY_EXEMPTION_LIST_REVISION_1 1
#endif

/* 802.11 authentication algorithm list revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_AUTH_ALGORITHM_LIST_REVISION_1    1
#endif

/* 802.11 authentication cipher pair list revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_AUTH_CIPHER_PAIR_LIST_REVISION_1  1
#endif

/* 802.11 cipher algorithm list revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_CIPHER_ALGORITHM_LIST_REVISION_1  1
#endif

/* 802.11 cipher default key value revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_CIPHER_DEFAULT_KEY_VALUE_REVISION_1   1
#endif

/* 802.11 cipher key mapping key value byte array revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_CIPHER_KEY_MAPPING_KEY_VALUE_BYTE_ARRAY_REVISION_1    1
#endif

/* 802.11 association information list revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_ASSOCIATION_INFO_LIST_REVISION_1  1
#endif

/* 802.11 physical identifier list revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_PHY_ID_LIST_REVISION_1    1
#endif

/* 802.11 physical identifier special value */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_PHY_ID_ANY    0xFFFFFFFFL
#endif

/* 802.11 ExtSTA capability revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_EXTSTA_CAPABILITY_REVISION_1  1
#endif

/* 802.11 data rate mapping table revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_DATA_RATE_MAPPING_TABLE_REVISION_1    1
#endif

/* 802.11 data rates */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_DATA_RATE_NON_STANDARD    0x01
    #define DOT11_DATA_RATE_INDEX_MASK      0x7F
#endif

/* 802.11 country or region string list revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_COUNTRY_OR_REGION_STRING_LIST_REVISION_1  1
#endif

/* 802.11 port state notification revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_PORT_STATE_NOTIFICATION_REVISION_1    1
#endif

/* 802.11 IBSS parameters revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_IBSS_PARAMS_REVISION_1    1
#endif

/* 802.11 QOS parameters revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_QOS_PARAMS_REVISION_1 1
#endif

/* 802.11 association parameters revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_ASSOCIATION_PARAMS_REVISION_1 1
#endif

/* 802.11 QOS protocol flags */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_QOS_PROTOCOL_FLAG_WMM 0x01
    #define DOT11_QOS_PROTOCOL_FLAG_11E 0x02
#endif

/* 802.11 maximum number of fragments */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_MAX_NUM_OF_FRAGMENTS  16
#endif

/* 802.11 priority classes */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_PRIORITY_CONTENTION       0
    #define DOT11_PRIORITY_CONTENTION_FREE  1
#endif

/* 802.11 service classes */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_SERVICE_CLASS_REORDERABLE_MULTICAST   0
    #define DOT11_SERVICE_CLASS_STRICTLY_ORDERED        1
#endif

/* 802.11 flags */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_FLAGS_80211B_SHORT_PREAMBLE       0x00000001L
    #define DOT11_FLAGS_80211B_PBCC                 0x00000002L
    #define DOT11_FLAGS_80211B_CHANNEL_AGILITY      0x00000004L
    #define DOT11_FLAGS_PS_ON                       0x00000008L
    #define DOT11_FLAGS_80211G_DSSS_OFDM            0x00000010L
    #define DOT11_FLAGS_80211G_USE_PROTECTION       0x00000020L
    #define DOT11_FLAGS_80211G_NON_ERP_PRESENT      0x00000040L
    #define DOT11_FLAGS_80211G_BARKER_PREAMBLE_MODE 0x00000080L
    #define DOT11_WME_PACKET                        0x00000100L
#endif

/* 802.11 physical attributes */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_PHY_ATTRIBUTES_REVISION_1 1
#endif

/* 802.11 ExtSTA attributes */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_EXTSTA_ATTRIBUTES_SAFEMODE_OID_SUPPORTED  0x00000001L
    #define DOT11_EXTSTA_ATTRIBUTES_SAFEMODE_CERTIFIED      0x00000002L
#endif

/* 802.11 ExtSTA attributes revision numbers */
#if (NTDDI_VERSION >= 0x06000000) && defined( NDIS_SUPPORT_NDIS6 )
    #define DOT11_EXTSTA_ATTRIBUTES_REVISION_1  1
    #define DOT11_EXTSTA_ATTRIBUTES_REVISION_2  2
#endif

/* 802.11 send context revision number */
#if (NTDDI_VERSION >= 0x06000000) && (defined( _NDIS_ ) || defined( NDIS_WRAPPER )) && \
    defined( NDIS_SUPPORT_NDIS6 )
    #define DOT11_SEND_CONTEXT_REVISION_1   1
#endif

/* 802.11 status codes */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_STATUS_SUCCESS                    0x00000001L
    #define DOT11_STATUS_RETRY_LIMIT_EXCEEDED       0x00000002L
    #define DOT11_STATUS_UNSUPPORTED_PRIORITY       0x00000004L
    #define DOT11_STATUS_UNSUPPORTED_SERVICE_CLASS  0x00000008L
    #define DOT11_STATUS_UNAVAILABLE_PRIORITY       0x00000010L
    #define DOT11_STATUS_UNAVAILABLE_SERVICE_CLASS  0x00000020L
    #define DOT11_STATUS_XMIT_MSDU_TIMER_EXPIRED    0x00000040L
    #define DOT11_STATUS_UNAVAILABLE_BSS            0x00000080L
    #define DOT11_STATUS_EXCESSIVE_DATA_LENGTH      0x00000100L
    #define DOT11_STATUS_ENCRYPTION_FAILED          0x00000200L
    #define DOT11_STATUS_WEP_KEY_UNAVAILABLE        0x00000400L
    #define DOT11_STATUS_ICV_VERIFIED               0x00000800L
    #define DOT11_STATUS_PACKET_REASSEMBLED         0x00001000L
    #define DOT11_STATUS_PACKET_NOT_REASSEMBLED     0x00002000L
    #define DOT11_STATUS_GENERATE_AUTH_FAILED       0x00004000L
    #define DOT11_STATUS_AUTH_NOT_VERIFIED          0x00008000L
    #define DOT11_STATUS_AUTH_VERIFIED              0x00010000L
    #define DOT11_STATUS_AUTH_FAILED                0x00020000L
    #define DOT11_STATUS_PS_LIFETIME_EXPIRED        0x00040000L
#endif

/* 802.11 status confirm values */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_STATUS_SCAN_CONFIRM               1
    #define DOT11_STATUS_JOIN_CONFIRM               2
    #define DOT11_STATUS_START_CONFIRM              3
    #define DOT11_STATUS_RESET_CONFIRM              4
    #define DOT11_STATUS_AP_JOIN_CONFIRM            5
    #define DOT11_STATUS_MPDU_MAX_LENGTH_CHANGED    6
#endif

/* 802.11 MPDU maximum length indication revision number */
#if (NTDDI_VERSION >= 0x06000000) && defined( NDIS_SUPPORT_NDIS6 )
    #define DOT11_MPDU_MAX_LENGTH_INDICATION_REVISION_1 1
#endif

/* 802.11 association start parameters revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_ASSOCIATION_START_PARAMETERS_REVISION_1   1
#endif

/* 802.11 encapsulation types */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_ENCAP_RFC_1042    1L
    #define DOT11_ENCAP_802_1H      2L
#endif

/* 802.11 association status values */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_ASSOC_STATUS_SUCCESS                  0x00000000L
    #define DOT11_ASSOC_STATUS_FAILURE                  0x00000001L
    #define DOT11_ASSOC_STATUS_UNREACHABLE              0x00000002L
    #define DOT11_ASSOC_STATUS_RADIO_OFF                0x00000003L
    #define DOT11_ASSOC_STATUS_PHY_DISABLED             0x00000004L
    #define DOT11_ASSOC_STATUS_CANCELLED                0x00000005L
    #define DOT11_ASSOC_STATUS_CANDIDATE_LIST_EXHAUSTED 0x00000006L
    #define DOT11_ASSOC_STATUS_DISASSOCIATED_BY_OS      0x00000007L
    #define DOT11_ASSOC_STATUS_DISASSOCIATED_BY_ROAMING 0x00000008L
    #define DOT11_ASSOC_STATUS_DISASSOCIATED_BY_RESET   0x00000009L
    #define DOT11_ASSOC_STATUS_SYSTEM_ERROR             0x0000000AL
    #define DOT11_ASSOC_STATUS_ROAMING_BETTER_AP_FOUND  0x0000000BL
    #define DOT11_ASSOC_STATUS_ROAMING_ASSOCIATION_LOST 0x0000000CL
    #define DOT11_ASSOC_STATUS_ROAMING_ADHOC            0x0000000DL
    #define DOT11_ASSOC_STATUS_PEER_DEAUTHENTICATED     0x00010000L
    #define DOT11_ASSOC_STATUS_PEER_DEAUTHENTICATED_START \
        DOT11_ASSOC_STATUS_PEER_DEAUTHENTICATED
    #define DOT11_ASSOC_STATUS_PEER_DEAUTHENTICATED_END 0x0001FFFFL
    #define DOT11_ASSOC_STATUS_PEER_DISASSOCIATED       0x00020000L
    #define DOT11_ASSOC_STATUS_PEER_DISASSOCIATED_START \
        DOT11_ASSOC_STATUS_PEER_DISASSOCIATED
    #define DOT11_ASSOC_STATUS_PEER_DISASSOCIATED_END   0x0002FFFFL
    #define DOT11_ASSOC_STATUS_ASSOCIATION_RESPONSE     0x00030000L
    #define DOT11_ASSOC_STATUS_ASSOCIATION_RESPONSE_START \
        DOT11_ASSOC_STATUS_ASSOCIATION_RESPONSE
    #define DOT11_ASSOC_STATUS_ASSOCIATION_RESPONSE_END 0x0003FFFFL
    #define DOT11_ASSOC_STATUS_REASON_CODE_MASK         0x0000FFFFL
    #define DOT11_ASSOC_STATUS_IHV_START                0x80000000L
    #define DOT11_ASSOC_STATUS_IHV_END                  0xFFFFFFFFL
#endif

/* 802.11 association completion parameters revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_ASSOCIATION_COMPLETION_PARAMETERS_REVISION_1  1
#endif

/* 802.11 connection status values */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_CONNECTION_STATUS_SUCCESS         DOT11_ASSOC_STATUS_SUCCESS
    #define DOT11_CONNECTION_STATUS_FAILURE         DOT11_ASSOC_STATUS_FAILURE
    #define DOT11_CONNECTION_STATUS_CANDIDATE_LIST_EXHAUSTED \
        DOT11_ASSOC_STATUS_CANDIDATE_LIST_EXHAUSTED
    #define DOT11_CONNECTION_STATUS_PHY_POWER_DOWN  DOT11_ASSOC_STATUS_RADIO_OFF
    #define DOT11_CONNECTION_STATUS_CANCELLED       DOT11_ASSOC_STATUS_CANCELLED
    #define DOT11_CONNECTION_STATUS_IHV_START       DOT11_ASSOC_STATUS_IHV_START
    #define DOT11_CONNECTION_STATUS_IHV_END         DOT11_ASSOC_STATUS_IHV_END
#endif

/* 802.11 connection completion parameters revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_CONNECTION_COMPLETION_PARAMETERS_REVISION_1   1
#endif

/* 802.11 roaming reasons */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_ROAMING_REASON_BETTER_AP_FOUND \
        DOT11_ASSOC_STATUS_ROAMING_BETTER_AP_FOUND
    #define DOT11_ROAMING_REASON_ASSOCIATION_LOST \
        DOT11_ASSOC_STATUS_ROAMING_ASSOCIATION_LOST
    #define DOT11_ROAMING_REASON_ADHOC      DOT11_ASSOC_STATUS_ROAMING_ADHOC
    #define DOT11_ROAMING_REASON_IHV_START  DOT11_ASSOC_STATUS_IHV_START
    #define DOT11_ROAMING_REASON_IHV_END    DOT11_ASSOC_STATUS_IHV_END
#endif

/* 802.11 roaming start parameters revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_ROAMING_START_PARAMETERS_REVISION_1   1
#endif

/* 802.11 roaming completion parameters revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_ROAMING_COMPLETION_PARAMETERS_REVISION_1  1
#endif

/* 802.11 disassociation reasons */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_DISASSOC_REASON_OS                    DOT11_ASSOC_STATUS_DISASSOCIATED_BY_OS
    #define DOT11_DISASSOC_REASON_PEER_UNREACHABLE      DOT11_ASSOC_STATUS_UNREACHABLE
    #define DOT11_DISASSOC_REASON_RADIO_OFF             DOT11_ASSOC_STATUS_RADIO_OFF
    #define DOT11_DISASSOC_REASON_PHY_DISABLED          DOT11_ASSOC_STATUS_PHY_DISABLED
    #define DOT11_DISASSOC_REASON_IHV_START             DOT11_ASSOC_STATUS_IHV_START
    #define DOT11_DISASSOC_REASON_IHV_END               DOT11_ASSOC_STATUS_IHV_END
    #define DOT11_DISASSOC_REASON_PEER_DEAUTHENTICATED  DOT11_ASSOC_STATUS_PEER_DEAUTHENTICATED
    #define DOT11_DISASSOC_REASON_PEER_DISASSOCIATED    DOT11_ASSOC_STATUS_PEER_DISASSOCIATED
#endif

/* 802.11 disassociation parameters revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_DISASSOCIATION_PARAMETERS_REVISION_1  1
#endif

/* 802.11 TKIPMIC failure parameters revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_TKIPMIC_FAILURE_PARAMETERS_REVISION_1 1
#endif

/* 802.11 PMKID candidate list parameters revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_PMKID_CANDIDATE_LIST_PARAMETERS_REVISION_1    1
#endif

/* 802.11 BSSID candidate flags */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_PMKID_CANDIDATE_PREAUTH_ENABLED   0x00000001L
#endif

/* 802.11 physical state parameters revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_PHY_STATE_PARAMETERS_REVISION_1   1
#endif

/* 802.11 link quality parameters revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_LINK_QUALITY_PARAMETERS_REVISION_1    1
#endif

/* 802.11 ExtSTA send context revision number */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_EXTSTA_SEND_CONTEXT_REVISION_1    1
#endif

/* 802.11 receive flags */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_RECV_FLAG_RAW_PACKET              0x00000001L
    #define DOT11_RECV_FLAG_RAW_PACKET_FCS_FAILURE  0x00000002L
    #define DOT11_RECV_FLAG_RAW_PACKET_TIMESTAMP    0x00000004L
#endif

/* 802.11 ExtSTA receive context */
#if (NTDDI_VERSION >= 0x06000000)
    #define DOT11_EXTSTA_RECV_CONTEXT_REVISION_1    1
#endif

/* 802.11 private object identifiers */
#if (NTDDI_VERSION >= 0x06000000)
    #define OID_DOT11_PRIVATE_OIDS_START    (OID_DOT11_NDIS_START + 1024)
    #define OID_DOT11_CURRENT_ADDRESS       (OID_DOT11_PRIVATE_OIDS_START + 2)
    #define OID_DOT11_PERMANENT_ADDRESS     (OID_DOT11_PRIVATE_OIDS_START + 3)
    #define OID_DOT11_MULTICAST_LIST        (OID_DOT11_PRIVATE_OIDS_START + 4)
    #define OID_DOT11_MAXIMUM_LIST_SIZE     (OID_DOT11_PRIVATE_OIDS_START + 5)
#endif

/* 802.11 ExtAP attributes revision number */
#ifdef NWF_EXTAP_SUPPORTED
    #define DOT11_EXTAP_ATTRIBUTES_REVISION_1   1
#endif

/* 802.11 incoming association started parameters revision number */
#ifdef NWF_EXTAP_SUPPORTED
    #define DOT11_INCOMING_ASSOC_STARTED_PARAMETERS_REVISION_1  1
#endif

/* 802.11 incoming association request received parameters revision number */
#ifdef NWF_EXTAP_SUPPORTED
    #define DOT11_INCOMING_ASSOC_REQUEST_RECEIVED_PARAMETERS_REVISION_1 1
#endif

/* 802.11 association error sources */
#ifdef NWF_EXTAP_SUPPORTED
    #define DOT11_ASSOC_ERROR_SOURCE_OS     0x00
    #define DOT11_ASSOC_ERROR_SOURCE_REMOTE 0x01
    #define DOT11_ASSOC_ERROR_SOURCE_OTHER  0xFF
#endif

/* 802.11 incoming association completion parameters revision number */
#ifdef NWF_EXTAP_SUPPORTED
    #define DOT11_INCOMING_ASSOC_COMPLETION_PARAMETERS_REVISION_1   1
#endif

/* 802.11 stop AP parameters revision number */
#ifdef NWF_EXTAP_SUPPORTED
    #define DOT11_STOP_AP_PARAMETERS_REVISION_1 1
#endif

/* 802.11 stop AP reason codes */
#ifdef NWF_EXTAP_SUPPORTED
    #define DOT11_STOP_AP_REASON_FREQUENCY_NOT_AVAILABLE    0x00000001L
    #define DOT11_STOP_AP_REASON_CHANNEL_NOT_AVAILABLE      0x00000002L
    #define DOT11_STOP_AP_REASON_AP_ACTIVE                  0x00000003L
    #define DOT11_STOP_AP_REASON_IHV_START                  0xFF000000L
    #define DOT11_STOP_AP_REASON_IHV_END                    0xFFFFFFFFL
#endif

/* 802.11 physical frequency adopted parameters revision number */
#ifdef NWF_EXTAP_SUPPORTED
    #define DOT11_PHY_FREQUENCY_ADOPTED_PARAMETERS_REVISION_1   1
#endif

/* 802.11 can sustain AP parameters revision number */
#ifdef NWF_EXTAP_SUPPORTED
    #define DOT11_CAN_SUSTAIN_AP_PARAMETERS_REVISION_1  1
#endif

/* 802.11 can sustain AP reason codes */
#ifdef NWF_EXTAP_SUPPORTED
    #define DOT11_CAN_SUSTAIN_AP_REASON_IHV_START   0xFF000000L
    #define DOT11_CAN_SUSTAIN_AP_REASON_IHV_END     0xFFFFFFFFL
#endif

/* NWF ExtAP constants */
#ifdef NWF_EXTAP_SUPPORTED
    #define NWF_EXTAP_OID   0x03
#endif

/* ExtAP object identifiers */
#ifdef NWF_EXTAP_SUPPORTED
    #define OID_DOT11_WPS_ENABLED \
        NWF_DEFINE_OID( 0x01, NWF_EXTAP_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_START_AP_REQUEST \
        NWF_DEFINE_OID( 0x02, NWF_EXTAP_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_AVAILABLE_CHANNEL_LIST \
        NWF_DEFINE_OID( 0x03, NWF_EXTAP_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_AVAILABLE_FREQUENCY_LIST \
        NWF_DEFINE_OID( 0x04, NWF_EXTAP_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_DISASSOCIATE_PEER_REQUEST \
        NWF_DEFINE_OID( 0x05, NWF_EXTAP_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_INCOMING_ASSOCIATION_DECISION \
        NWF_DEFINE_OID( 0x06, NWF_EXTAP_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_ADDITIONAL_IE \
        NWF_DEFINE_OID( 0x07, NWF_EXTAP_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_ENUM_PEER_INFO \
        NWF_DEFINE_OID( 0x08, NWF_EXTAP_OID, NWF_MANDATORY_OID )
#endif

/* 802.11 available channel list revision number */
#ifdef NWF_EXTAP_SUPPORTED
    #define DOT11_AVAILABLE_CHANNEL_LIST_REVISION_1 1
#endif

/* 802.11 available frequency list revision number */
#ifdef NWF_EXTAP_SUPPORTED
    #define DOT11_AVAILABLE_FREQUENCY_LIST_REVISION_1   1
#endif

/* 802.11 disassociate peer request revision number */
#ifdef NWF_EXTAP_SUPPORTED
    #define DOT11_DISASSOCIATE_PEER_REQUEST_REVISION_1  1
#endif

/* 802.11 incoming association decision revision number */
#ifdef NWF_EXTAP_SUPPORTED
    #define DOT11_INCOMING_ASSOC_DECISION_REVISION_1    1
#endif

/* 802.11 additional information element revision number */
#ifdef NWF_EXTAP_SUPPORTED
    #define DOT11_ADDITIONAL_IE_REVISION_1  1
#endif

/* 802.11 ExtAP send context revision number */
#ifdef NWF_EXTAP_SUPPORTED
    #define DOT11_EXTAP_SEND_CONTEXT_REVISION_1 1
#endif

/* 802.11 ExtAP receive context revision number */
#ifdef NWF_EXTAP_SUPPORTED
    #define DOT11_EXTAP_RECEIVE_CONTEXT_REVISION_1  1
#endif

/* 802.11 peer information list revision number */
#ifdef NWF_EXTAP_SUPPORTED
    #define DOT11_PEER_INFO_LIST_REVISION_1 1
#endif

/* 802.11 Virtual WiFi combination revision numbers */
#ifdef NWF_VWIFI_SUPPORTED
    #define DOT11_VWIFI_COMBINATION_REVISION_1  1
    #define DOT11_VWIFI_COMBINATION_REVISION_2  2
#endif

/* 802.11 Virtual WiFi attributes revision number */
#ifdef NWF_VWIFI_SUPPORTED
    #define DOT11_VWIFI_ATTRIBUTES_REVISION_1   1
#endif

/* NWF Virtual WiFi constants */
#ifdef NWF_VWIFI_SUPPORTED
    #define NWF_VWIFI_OID   0x04
#endif

/* Virtual WiFi object identifiers */
#ifdef NWF_VWIFI_SUPPORTED
    #define OID_DOT11_CREATE_MAC \
        NWF_DEFINE_OID( 0x01, NWF_VWIFI_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_DELETE_MAC \
        NWF_DEFINE_OID( 0x02, NWF_VWIFI_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_PREFERRED_MAC \
        NWF_DEFINE_OID( 0x03, NWF_VWIFI_OID, NWF_MANDATORY_OID )
    #define OID_DOT11_VIRTUAL_STATION_CAPABILITY \
        NWF_DEFINE_OID( 0x04, NWF_VWIFI_OID, NWF_MANDATORY_OID )
#endif

/* 802.11 MAC address */
typedef UCHAR               DOT11_MAC_ADDRESS[6];
typedef DOT11_MAC_ADDRESS   *PDOT11_MAC_ADDRESS;

/* 802.11 BSSID list */
typedef struct DOT11_BSSID_LIST {
    NDIS_OBJECT_HEADER  Header;
    ULONG               uNumOfEntries;
    ULONG               uTotalNumOfEntries;
    DOT11_MAC_ADDRESS   BSSIDs[1];
} DOT11_BSSID_LIST;
typedef DOT11_BSSID_LIST    *PDOT11_BSSID_LIST;

/* 802.11 physical types */
typedef enum _DOT11_PHY_TYPE {
    dot11_phy_type_unknown      = 0,
    dot11_phy_type_any          = dot11_phy_type_unknown,
    dot11_phy_type_fhss         = 1,
    dot11_phy_type_dsss         = 2,
    dot11_phy_type_irbaseband   = 3,
    dot11_phy_type_ofdm         = 4,
    dot11_phy_type_hrdsss       = 5,
    dot11_phy_type_erp          = 6,
    dot11_phy_type_ht           = 7,
    dot11_phy_type_IHV_start    = 0x80000000,
    dot11_phy_type_IHV_end      = 0xFFFFFFFF
} DOT11_PHY_TYPE;
typedef DOT11_PHY_TYPE  *PDOT11_PHY_TYPE;

/* 802.11 rate set */
typedef struct _DOT11_RATE_SET {
    ULONG   uRateSetLength;
    UCHAR   ucRateSet[DOT11_RATE_SET_MAX_LENGTH];
} DOT11_RATE_SET;
typedef DOT11_RATE_SET  *PDOT11_RATE_SET;

/* 802.11 country or region string */
typedef UCHAR                           DOT11_COUNTRY_OR_REGION_STRING[3];
typedef DOT11_COUNTRY_OR_REGION_STRING  *PDOT11_COUNTRY_OR_REGION_STRING;

/* 802.11 offload capability */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_OFFLOAD_CAPABILITY {
    ULONG   uReserved;
    ULONG   uFlags;
    ULONG   uSupportedWEPAlgorithms;
    ULONG   uNumOfReplayWindows;
    ULONG   uMaxWEPKeyMappingLength;
    ULONG   uSupportedAuthAlgorithms;
    ULONG   uMaxAuthKeyMappingLength;
} DOT11_OFFLOAD_CAPABILITY;
typedef DOT11_OFFLOAD_CAPABILITY    *PDOT11_OFFLOAD_CAPABILITY;
#endif

/* 802.11 current offload capability */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_CURRENT_OFFLOAD_CAPABILITY {
    ULONG   uReserved;
    ULONG   uFlags;
} DOT11_CURRENT_OFFLOAD_CAPABILITY;
typedef DOT11_CURRENT_OFFLOAD_CAPABILITY    *PDOT11_CURRENT_OFFLOAD_CAPABILITY;
#endif

/* 802.11 WEP offload types */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum _DOT11_OFFLOAD_TYPE {
    dot11_offload_type_wep  = 1,
    dot11_offload_type_auth = 2
} DOT11_OFFLOAD_TYPE;
typedef DOT11_OFFLOAD_TYPE  *PDOT11_OFFLOAD_TYPE;
#endif

/* 802.11 IV48 counter */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_IV48_COUNTER {
    ULONG   uIV32Counter;
    USHORT  usIV16Counter;
} DOT11_IV48_COUNTER;
typedef DOT11_IV48_COUNTER  *PDOT11_IV48_COUNTER;
#endif

/* 802.11 WEP offload */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_WEP_OFFLOAD {
    ULONG               uReserved;
    HANDLE              hOffloadContext;
    HANDLE              hOffload;
    DOT11_OFFLOAD_TYPE  dot11OffloadType;
    ULONG               dwAlgorithm;
    BOOLEAN             bRowIsOutbound;
    BOOLEAN             bUseDefault;
    ULONG               uFlags;
    UCHAR               ucMacAddress[6];
    ULONG               uNumOfRWsOnPeer;
    ULONG               uNumOfRWsOnMe;
    DOT11_IV48_COUNTER  dot11IV48Counters[16];
    USHORT              usDot11RWBitMaps[16];
    USHORT              usKeyLength;
    UCHAR               ucKey[1];
} DOT11_WEP_OFFLOAD;
typedef DOT11_WEP_OFFLOAD   *PDOT11_WEP_OFFLOAD;
#endif

/* 802.11 WEP upload */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_WEP_UPLOAD {
    ULONG               uReserved;
    DOT11_OFFLOAD_TYPE  dot11OffloadType;
    HANDLE              hOffload;
    ULONG               uNumOfRWsUsed;
    DOT11_IV48_COUNTER  dot11IV48Counters[16];
    USHORT              usDot11RWBitMaps[16];
} DOT11_WEP_UPLOAD;
typedef DOT11_WEP_UPLOAD    *PDOT11_WEP_UPLOAD;
#endif

/* 802.11 key directions */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum _DOT11_KEY_DIRECTION {
    dot11_key_direction_both        = 1,
    dot11_key_direction_inbound     = 2,
    dot11_key_direction_outbound    = 3
} DOT11_KEY_DIRECTION;
typedef DOT11_KEY_DIRECTION *PDOT11_KEY_DIRECTION;
#endif

/* 802.11 default WEP offload */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_DEFAULT_WEP_OFFLOAD {
    ULONG               uReserved;
    HANDLE              hOffloadContext;
    HANDLE              hOffload;
    ULONG               dwIndex;
    DOT11_OFFLOAD_TYPE  dot11OffloadType;
    ULONG               dwAlgorithm;
    ULONG               uFlags;
    DOT11_KEY_DIRECTION dot11KeyDirection;
    UCHAR               ucMacAddress[6];
    ULONG               uNumOfRWsOnMe;
    DOT11_IV48_COUNTER  dot11IV48Counters[16];
    USHORT              usDot11RWBitMaps[16];
    USHORT              usKeyLength;
    UCHAR               ucKey[1];
} DOT11_DEFAULT_WEP_OFFLOAD;
typedef DOT11_DEFAULT_WEP_OFFLOAD   *PDOT11_DEFAULT_WEP_OFFLOAD;
#endif

/* 802.11 default WEP upload */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_DEFAULT_WEP_UPLOAD {
    ULONG               uReserved;
    DOT11_OFFLOAD_TYPE  dot11OffloadType;
    HANDLE              hOffload;
    ULONG               uNumOfRWsUsed;
    DOT11_IV48_COUNTER  dot11IV48Counters[16];
    USHORT              usDot11RWBitMaps[16];
} DOT11_DEFAULT_WEP_UPLOAD;
typedef DOT11_DEFAULT_WEP_UPLOAD    *PDOT11_DEFAULT_WEP_UPLOAD;
#endif

/* 802.11 operation mode capability */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_OPERATION_MODE_CAPABILITY {
    ULONG   uReserved;
    ULONG   uMajorVersion;
    ULONG   uMinorVersion;
    ULONG   uNumOfTXBuffers;
    ULONG   uNumOfRXBuffers;
    ULONG   uOpModeCapability;
} DOT11_OPERATION_MODE_CAPABILITY;
typedef DOT11_OPERATION_MODE_CAPABILITY *PDOT11_OPERATION_MODE_CAPABILITY;
#endif

/* 802.11 current operation mode */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_CURRENT_OPERATION_MODE {
    ULONG   uReserved;
    ULONG   uCurrentOpMode;
} DOT11_CURRENT_OPERATION_MODE;
typedef DOT11_CURRENT_OPERATION_MODE    *PDOT11_CURRENT_OPERATION_MODE;
#endif

/* 802.11 scan types */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum _DOT11_SCAN_TYPE {
    dot11_scan_type_active  = 1,
    dot11_scan_type_passive = 2,
    dot11_scan_type_auto    = 3,
    dot11_scan_type_forced  = 0x80000000
} DOT11_SCAN_TYPE;
typedef DOT11_SCAN_TYPE *PDOT11_SCAN_TYPE;
#endif

/* 802.11 scan request */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_SCAN_REQUEST {
    DOT11_BSS_TYPE      dot11BSSType;
    DOT11_MAC_ADDRESS   dot11BSSID;
    DOT11_SSID          dot11SSID;
    DOT11_SCAN_TYPE     dot11ScanType;
    BOOLEAN             bRestrictedScan;
    BOOLEAN             bUseRequestIE;
    ULONG               uRequestIDsOffset;
    ULONG               uNumOfRequestIDs;
    ULONG               uPhyTypesOffset;
    ULONG               uNumOfPhyTypes;
    ULONG               uIEsOffset;
    ULONG               uIEsLength;
    UCHAR               ucBuffer[1];
} DOT11_SCAN_REQUEST;
typedef DOT11_SCAN_REQUEST  *PDOT11_SCAN_REQUEST;
#endif

/* Channel description types */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum _CH_DESCRIPTION_TYPE {
    ch_description_type_logical             = 1,
    ch_description_type_center_frequency    = 2,
    ch_description_type_phy_specific        = 3
} CH_DESCRIPTION_TYPE;
typedef CH_DESCRIPTION_TYPE *PCH_DESCRIPTION_TYPE;
#endif

/* 802.11 physical type information */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_PHY_TYPE_INFO {
    DOT11_PHY_TYPE      dot11PhyType;
    BOOLEAN             bUseParameters;
    ULONG               uProbeDelay;
    ULONG               uMinChannelTime;
    ULONG               uMaxChannelTime;
    CH_DESCRIPTION_TYPE ChDescriptionType;
    ULONG               uChannelListSize;
    UCHAR               ucChannelListBuffer[1];
} DOT11_PHY_TYPE_INFO;
typedef DOT11_PHY_TYPE_INFO *PDOT11_PHY_TYPE_INFO;
#endif

/* 802.11 scan request (version 2) */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_SCAN_REQUEST_V2 {
    DOT11_BSS_TYPE      dot11BSSType;
    DOT11_MAC_ADDRESS   dot11BSSID;
    DOT11_SCAN_TYPE     dot11ScanType;
    BOOLEAN             bRestrictedScan;
    ULONG               udot11SSIDsOffset;
    ULONG               uNumOfdot11SSIDs;
    BOOLEAN             bUseRequestIE;
    ULONG               uRequestIDsOffset;
    ULONG               uNumOfRequestIDs;
    ULONG               uPhyTypeInfosOffset;
    ULONG               uNumOfPhyTypeInfos;
    ULONG               uIEsOffset;
    ULONG               uIEsLength;
    UCHAR               ucBuffer[1];
} DOT11_SCAN_REQUEST_V2;
typedef DOT11_SCAN_REQUEST_V2   *PDOT11_SCAN_REQUEST_V2;
#endif

/* 802.11 physical type list */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_PHY_TYPE_LIST {
    NDIS_OBJECT_HEADER  Header;
    ULONG               uNumOfEntries;
    ULONG               uTotalNumOfEntries;
    DOT11_PHY_TYPE      dot11PhyType[1];
} DOT11_PHY_TYPE_LIST;
typedef DOT11_PHY_TYPE_LIST *PDOT11_PHY_TYPE_LIST;
#endif

/* 802.11 BSS description */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_BSS_DESCRIPTION {
    ULONG               uReserved;
    DOT11_MAC_ADDRESS   dot11BSSID;
    DOT11_BSS_TYPE      dot11BSSType;
    USHORT              usBeaconPeriod;
    ULONGLONG           ullTimestamp;
    USHORT              usCapabilityInformation;
    ULONG               uBufferLength;
    UCHAR               ucBuffer[1];
} DOT11_BSS_DESCRIPTION;
typedef DOT11_BSS_DESCRIPTION   *PDOT11_BSS_DESCRIPTION;
#endif

/* 802.11 join request */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_JOIN_REQUEST {
    ULONG                   uJoinFailureTimeout;
    DOT11_RATE_SET          OperationalRateSet;
    ULONG                   uChCenterFrequency;
    DOT11_BSS_DESCRIPTION   dot11BSSDescription;
} DOT11_JOIN_REQUEST;
typedef DOT11_JOIN_REQUEST  *PDOT11_JOIN_REQUEST;
#endif

/* 802.11 start request */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_START_REQUEST {
    ULONG                   uStartFailureTimeout;
    DOT11_RATE_SET          OperationalRateSet;
    ULONG                   uChCenterFrequency;
    DOT11_BSS_DESCRIPTION   dot11BSSDescription;
} DOT11_START_REQUEST;
typedef DOT11_START_REQUEST *PDOT11_START_REQUEST;
#endif

/* 802.11 update IE operations */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum _DOT11_UPDATE_IE_OP {
    dot11_update_ie_op_create_replace   = 1,
    dot11_update_ie_op_delete           = 2
} DOT11_UPDATE_IE_OP;
typedef DOT11_UPDATE_IE_OP  *PDOT11_UPDATE_IE_OP;
#endif

/* 802.11 update IE */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_UPDATE_IE {
    DOT11_UPDATE_IE_OP  dot11UpdateIEOp;
    ULONG               uBufferLength;
    UCHAR               ucBuffer[1];
} DOT11_UPDATE_IE;
typedef DOT11_UPDATE_IE *PDOT11_UPDATE_IE;
#endif

/* 802.11 reset types */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum _DOT11_RESET_TYPE {
    dot11_reset_type_phy            = 1,
    dot11_reset_type_mac            = 2,
    dot11_reset_type_phy_and_mac    = 3
} DOT11_RESET_TYPE;
typedef DOT11_RESET_TYPE    *PDOT11_RESET_TYPE;
#endif

/* 802.11 reset request */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_RESET_REQUEST {
    DOT11_RESET_TYPE    dot11ResetType;
    DOT11_MAC_ADDRESS   dot11MacAddress;
    BOOLEAN             bSetDefaultMIB;
} DOT11_RESET_REQUEST;
typedef DOT11_RESET_REQUEST *PDOT11_RESET_REQUEST;
#endif

/* 802.11 optional capability */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_OPTIONAL_CAPABILITY {
    ULONG   uReserved;
    BOOLEAN bDot11PCF;
    BOOLEAN bDot11PCFMPDUTransferToPC;
    BOOLEAN bStrictlyOrderedServiceClass;
} DOT11_OPTIONAL_CAPABILITY;
typedef DOT11_OPTIONAL_CAPABILITY   *PDOT11_OPTIONAL_CAPABILITY;
#endif

/* 802.11 current optional capability */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_CURRENT_OPTIONAL_CAPABILITY {
    ULONG   uReserved;
    BOOLEAN bDot11CFPollable;
    BOOLEAN bDot11PCF;
    BOOLEAN bDot11PCFMPDUTransferToPC;
    BOOLEAN bStrictlyOrderedServiceClass;
} DOT11_CURRENT_OPTIONAL_CAPABILITY;
typedef DOT11_CURRENT_OPTIONAL_CAPABILITY   *PDOT11_CURRENT_OPTIONAL_CAPABILITY;
#endif

/* 802.11 power modes */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum _DOT11_POWER_MODE {
    dot11_power_mode_unknown    = 0,
    dot11_power_mode_active     = 1,
    dot11_power_mode_powersave  = 2
} DOT11_POWER_MODE;
typedef DOT11_POWER_MODE    *PDOT11_POWER_MODE;
#endif

/* 802.11 power management mode */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_POWER_MGMT_MODE {
    DOT11_POWER_MODE    dot11PowerMode;
    ULONG               uPowerSaveLevel;
    USHORT              usListenInterval;
    USHORT              usAID;
    BOOLEAN             bReceiveDTIMs;
} DOT11_POWER_MGMT_MODE;
typedef DOT11_POWER_MGMT_MODE   *PDOT11_POWER_MGMT_MODE;
#endif

/* 802.11 counters entry */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_COUNTERS_ENTRY {
    ULONG   uTransmittedFragmentCount;
    ULONG   uMulticastTransmittedFrameCount;
    ULONG   uFailedCount;
    ULONG   uRetryCount;
    ULONG   uMultipleRetryCount;
    ULONG   uFrameDuplicateCount;
    ULONG   uRTSSuccessCount;
    ULONG   uRTSFailureCount;
    ULONG   uACKFailureCount;
    ULONG   uReceivedFragmentCount;
    ULONG   uMulticastReceivedFrameCount;
    ULONG   uFCSErrorCount;
    ULONG   uTransmittedFrameCount;
} DOT11_COUNTERS_ENTRY;
typedef DOT11_COUNTERS_ENTRY    *PDOT11_COUNTERS_ENTRY;
#endif

/* 802.11 supported physical types */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_SUPPORTED_PHY_TYPES {
    ULONG           uNumOfEntries;
    ULONG           uTotalNumOfEntries;
    DOT11_PHY_TYPE  dot11PHYType[1];
} DOT11_SUPPORTED_PHY_TYPES;
typedef DOT11_SUPPORTED_PHY_TYPES   *PDOT11_SUPPORTED_PHY_TYPES;
#endif

/* 802.11 temporary types */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum _DOT11_TEMP_TYPE {
    dot11_temp_type_unknown = 0,
    dot11_temp_type_1       = 1,
    dot11_temp_type_2       = 2
} DOT11_TEMP_TYPE;
typedef DOT11_TEMP_TYPE *PDOT11_TEMP_TYPE;
#endif

/* 802.11 diversity support values */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum _DOT11_DIVERSITY_SUPPORT {
    dot11_diversity_support_unknown         = 0,
    dot11_diversity_support_fixedlist       = 1,
    dot11_diversity_support_notsupported    = 2,
    dot11_diversity_support_dynamic         = 3
} DOT11_DIVERSITY_SUPPORT;
typedef DOT11_DIVERSITY_SUPPORT *PDOT11_DIVERSITY_SUPPORT;
#endif

/* 802.11 supported power levels */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_SUPPORTED_POWER_LEVELS {
    ULONG   uNumOfSupportedPowerLevels;
    ULONG   uTxPowerLevelValues[8];
} DOT11_SUPPORTED_POWER_LEVELS;
typedef DOT11_SUPPORTED_POWER_LEVELS    *PDOT11_SUPPORTED_POWER_LEVELS;
#endif

/* 802.11 registration domain value */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_REG_DOMAIN_VALUE {
    ULONG   uRegDomainsSupportIndex;
    ULONG   uRegDomainsSupportValue;
} DOT11_REG_DOMAIN_VALUE;
typedef DOT11_REG_DOMAIN_VALUE  *PDOT11_REG_DOMAIN_VALUE;
#endif

/* 802.11 registration domains support value */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_REG_DOMAINS_SUPPORT_VALUE {
    ULONG                   uNumOfEntries;
    ULONG                   uTotalNumOfEntries;
    DOT11_REG_DOMAIN_VALUE  dot11RegDomainValue[1];
} DOT11_REG_DOMAINS_SUPPORT_VALUE;
typedef DOT11_REG_DOMAINS_SUPPORT_VALUE *PDOT11_REG_DOMAINS_SUPPORT_VALUE;
#endif

/* 802.11 supported antenna */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_SUPPORTED_ANTENNA {
    ULONG   uAntennaListIndex;
    BOOLEAN bSupportedAntenna;
} DOT11_SUPPORTED_ANTENNA;
typedef DOT11_SUPPORTED_ANTENNA *PDOT11_SUPPORTED_ANTENNA;
#endif

/* 802.11 supported antenna list */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_SUPPORTED_ANTENNA_LIST {
    ULONG                   uNumOfEntries;
    ULONG                   uTotalNumOfEntries;
    DOT11_SUPPORTED_ANTENNA dot11SupportedAntenna[1];
} DOT11_SUPPORTED_ANTENNA_LIST;
#endif

/* 802.11 receiver diversity selection */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_DIVERSITY_SELECTION_RX {
    ULONG   uAntennaListIndex;
    BOOLEAN bDiversitySelectionRX;
} DOT11_DIVERSITY_SELECTION_RX;
typedef DOT11_DIVERSITY_SELECTION_RX    *PDOT11_DIVERSITY_SELECTION_RX;
#endif

/* 802.11 receiver diversity selection list */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_DIVERSITY_SELECTION_RX_LIST {
    ULONG                           uNumOfEntries;
    ULONG                           uTotalNumOfEntries;
    DOT11_DIVERSITY_SELECTION_RX    dot11DiversitySelectionRx[1];
} DOT11_DIVERSITY_SELECTION_RX_LIST;
typedef DOT11_DIVERSITY_SELECTION_RX_LIST   *PDOT11_DIVERSITY_SELECTION_RX_LIST;
#endif

/* 802.11 supported data rates value */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_SUPPORTED_DATA_RATES_VALUE {
    UCHAR   ucSupportedTxDataRatesValue[MAX_NUM_SUPPORTED_RATES];
    UCHAR   ucSupportedRxDataRatesValue[MAX_NUM_SUPPORTED_RATES];
} DOT11_SUPPORTED_DATA_RATES_VALUE;
typedef DOT11_SUPPORTED_DATA_RATES_VALUE    *PDOT11_SUPPORTED_DATA_RATES_VALUE;
#endif

/* 802.11 supported data rates value (version 2) */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_SUPPORTED_DATA_RATES_VALUE_V2 {
    UCHAR   ucSupportedTxDataRatesValue[MAX_NUM_SUPPORTED_RATES_V2];
    UCHAR   ucSupportedRxDataRatesValue[MAX_NUM_SUPPORTED_RATES_V2];
} DOT11_SUPPORTED_DATA_RATES_VALUE_V2;
typedef DOT11_SUPPORTED_DATA_RATES_VALUE_V2 *PDOT11_SUPPORTED_DATA_RATES_VALUE_V2;
typedef DOT11_SUPPORTED_DATA_RATES_VALUE_V2 DOT11_SUPPORTED_DATA_RATES_VALUE_V1;
typedef DOT11_SUPPORTED_DATA_RATES_VALUE_V2 *PDOT11_SUPPORTED_DATA_RATES_VALUE_V1;
#endif

/* 802.11 multi-domain capability entry */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_MULTI_DOMAIN_CAPABILITY_ENTRY {
    ULONG   uMultiDomainCapabilityIndex;
    ULONG   uFirstChannelNumber;
    ULONG   uNumberOfChannels;
    LONG    lMaximumTransmitPowerLevel;
} DOT11_MULTI_DOMAIN_CAPABILITY_ENTRY;
typedef DOT11_MULTI_DOMAIN_CAPABILITY_ENTRY *PDOT11_MULTI_DOMAIN_CAPABILITY_ENTRY;
#endif

/* 802.11 multi-domain capability entry list */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_MD_CAPABILTIY_ENTRY_LIST {
    ULONG                               uNumOfEntries;
    ULONG                               uTotalNumOfEntries;
    DOT11_MULTI_DOMAIN_CAPABILITY_ENTRY dot11MDCapabilityEntry[1];
} DOT11_MD_CAPABILITY_ENTRY_LIST;
typedef DOT11_MD_CAPABILITY_ENTRY_LIST  *PDOT11_MD_CAPABILITY_ENTRY_LIST;
#endif

/* 802.11 hop algorithm adopted values */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum _DOT11_HOP_ALGO_ADOPTED {
    dot11_hop_algo_current      = 0,
    dot11_hop_algo_hop_index    = 1,
    dot11_hop_algo_hcc          = 2
} DOT11_HOP_ALGO_ADOPTED;
typedef DOT11_HOP_ALGO_ADOPTED  *PDOT11_HOP_ALGO_ADOPTED;
#endif

/* 802.11 hopping pattern entry */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_HOPPING_PATTERN_ENTRY {
    ULONG   uHoppingPatternIndex;
    ULONG   uRandomTableFieldNumber;
} DOT11_HOPPING_PATTERN_ENTRY;
typedef DOT11_HOPPING_PATTERN_ENTRY *PDOT11_HOPPING_PATTERN_ENTRY;
#endif

/* 802.11 hopping pattern entry list */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_HOPPING_PATTERN_ENTRY_LIST {
    ULONG                       uNumOfEntries;
    ULONG                       uTotalNumOfEntries;
    DOT11_HOPPING_PATTERN_ENTRY dot11HoppingPatternEntry[1];
} DOT11_HOPPING_PATTERN_ENTRY_LIST;
typedef DOT11_HOPPING_PATTERN_ENTRY_LIST    *PDOT11_HOPPING_PATTERN_ENTRY_LIST;
#endif

/* 802.11 WPA TSC */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_WPA_TSC {
    ULONG               uReserved;
    DOT11_OFFLOAD_TYPE  dot11OffloadType;
    HANDLE              hOffload;
    DOT11_IV48_COUNTER  dot11IV48Counter;
} DOT11_WPA_TSC;
typedef DOT11_WPA_TSC   *PDOT11_WPA_TSC;
#endif

/* 802.11 RSSI range */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_RSSI_RANGE {
    DOT11_PHY_TYPE  dot11PhyType;
    ULONG           uRSSIMin;
    ULONG           uRSSIMax;
} DOT11_RSSI_RANGE;
typedef DOT11_RSSI_RANGE    *PDOT11_RSSI_RANGE;
#endif

/* 802.11 NIC-specific extension */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_NIC_SPECIFIC_EXTENSION {
    ULONG   uBufferLength;
    ULONG   uTotalBufferLength;
    UCHAR   ucBuffer[1];
} DOT11_NIC_SPECIFIC_EXTENSION;
typedef DOT11_NIC_SPECIFIC_EXTENSION    *PDOT11_NIC_SPECIFIC_EXTENSION;
#endif

/* 802.11 AP join request */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_AP_JOIN_REQUEST {
    ULONG                   uJoinFailureTimeout;
    DOT11_RATE_SET          OperationalRateSet;
    ULONG                   uChCenterFrequency;
    DOT11_BSS_DESCRIPTION   dot11BSSDescription;
} DOT11_AP_JOIN_REQUEST;
typedef DOT11_AP_JOIN_REQUEST   *PDOT11_AP_JOIN_REQUEST;
#endif

/* 802.11 receive sensitivity */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_RECV_SENSITIVITY {
    UCHAR   ucDataRate;
    LONG    lRSSIMin;
    LONG    lRSSIMax;
} DOT11_RECV_SENSITIVITY;
typedef DOT11_RECV_SENSITIVITY  *PDOT11_RECV_SENSITIVITY;
#endif

/* 802.11 receive sensitivity list */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_RECV_SENSITIVITY_LIST {
    union {
        DOT11_PHY_TYPE  dot11PhyType;
        ULONG           uPhyId;
    };
    ULONG                   uNumOfEntries;
    ULONG                   uTotalNumOfEntries;
    DOT11_RECV_SENSITIVITY  dot11RecvSensitivity[1];
} DOT11_RECV_SENSITIVITY_LIST;
typedef DOT11_RECV_SENSITIVITY_LIST *PDOT11_RECV_SENSITIVITY_LIST;
#endif

/* 802.11 AC parameters */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum _DOT11_AC_PARAM {
    dot11_AC_param_BE   = 0,
    dot11_AC_param_BK   = 1,
    dot11_AC_param_VI   = 2,
    dot11_AC_param_VO   = 3,
    dot11_AC_param_max  = 4
} DOT11_AC_PARAM;
typedef DOT11_AC_PARAM  *PDOT11_AC_PARAM;
#endif

/* 802.11 WME AC parameters */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_WME_AC_PARAMETERS {
    UCHAR   ucAccessCategoryIndex;
    UCHAR   ucAFIFSN;
    UCHAR   ucECWmin;
    UCHAR   ucECWmax;
    USHORT  usTXOPLimit;
} DOT11_WME_AC_PARAMETERS;
typedef DOT11_WME_AC_PARAMETERS *PDOT11_WME_AC_PARAMETERS;
#endif

/* 802.11 WME AC parameters list */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_WME_AC_PARAMETERS_LIST {
    ULONG                   uNumOfEntries;
    ULONG                   uTotalNumOfEntries;
    DOT11_WME_AC_PARAMETERS dot11WMEACParameters[1];
} DOT11_WME_AC_PARAMETERS_LIST;
typedef DOT11_WME_AC_PARAMETERS_LIST    *PDOT11_WME_AC_PARAMETERS_LIST;
#endif

/* 802.11 WME update IE */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_WME_UPDATE_IE {
    ULONG   uParamElemMinBeaconIntervals;
    ULONG   uWMEInfoElemOffset;
    ULONG   uWMEInfoElemLength;
    ULONG   uWMEParamElemOffset;
    ULONG   uWMEParamElemLength;
    UCHAR   ucBuffer[1];
} DOT11_WME_UPDATE_IE;
typedef DOT11_WME_UPDATE_IE *PDOT11_WME_UPDATE_IE;
#endif

/* 802.11 QOS transmit duration */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_QOS_TX_DURATION {
    ULONG   uNormalMSDUSize;
    ULONG   uMinPHYRate;
    ULONG   uDuration;
} DOT11_QOS_TX_DURATION;
typedef DOT11_QOS_TX_DURATION   *PDOT11_QOS_TX_DURATION;
#endif

/* 802.11 QOS transmit medium time */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_QOS_TX_MEDIUM_TIME {
    DOT11_MAC_ADDRESS   dot11PeerAddress;
    UCHAR               ucQoSPriority;
    ULONG               uMediumTimeAdmited;
} DOT11_QOS_TX_MEDIUM_TIME;
typedef DOT11_QOS_TX_MEDIUM_TIME    *PDOT11_QOS_TX_MEDIUM_TIME;
#endif

/* 802.11 supported OFDM frequency */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_SUPPORTED_OFDM_FREQUENCY {
    ULONG   uCenterFrequency;
} DOT11_SUPPORTED_OFDM_FREQUENCY;
typedef DOT11_SUPPORTED_OFDM_FREQUENCY  *PDOT11_SUPPORTED_OFDM_FREQUENCY;
#endif

/* 802.11 supported OFDM frequency list */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_SUPPORTED_OFDM_FREQUENCY_LIST {
    ULONG                           uNumOfEntries;
    ULONG                           uTotalNumOfEntries;
    DOT11_SUPPORTED_OFDM_FREQUENCY  dot11SupportedOFDMFrequency[1];
} DOT11_SUPPORTED_OFDM_FREQUENCY_LIST;
#endif

/* 802.11 supported DSSS channel */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_SUPPORTED_DSSS_CHANNEL {
    ULONG   uChannel;
} DOT11_SUPPORTED_DSSS_CHANNEL;
typedef DOT11_SUPPORTED_DSSS_CHANNEL    *PDOT11_SUPPORTED_DSSS_CHANNEL;
#endif

/* 802.11 supported DSSS channel list */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_SUPPORTED_DSSS_CHANNEL_LIST {
    ULONG                           uNumOfEntries;
    ULONG                           uTotalNumOfEntries;
    DOT11_SUPPORTED_DSSS_CHANNEL    dot11SupportedDSSSChannel[1];
} DOT11_SUPPORTED_DSSS_CHANNEL_LIST;
typedef DOT11_SUPPORTED_DSSS_CHANNEL_LIST   *PDOT11_SUPPORTED_DSSS_CHANNEL_LIST;
#endif

/* 802.11 byte array */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_BYTE_ARRAY {
    NDIS_OBJECT_HEADER  Header;
    ULONG               uNumOfBytes;
    ULONG               uTotalNumOfBytes;
    UCHAR               ucBuffer[1];
} DOT11_BYTE_ARRAY;
typedef DOT11_BYTE_ARRAY    *PDOT11_BYTE_ARRAY;
#endif

/* 802.11 BSS entry physical specific information */
#if (NTDDI_VERSION >= 0x06000000)
typedef union DOT11_BSS_ENTRY_PHY_SPECIFIC_INFO {
    ULONG   uChCenterFrequency;
    struct {
        ULONG   uHopPattern;
        ULONG   uHopSet;
        ULONG   uDwellTime;
    } FHSS;
} DOT11_BSS_ENTRY_PHY_SPECIFIC_INFO;
typedef DOT11_BSS_ENTRY_PHY_SPECIFIC_INFO   *PDOT11_BSS_ENTRY_PHY_SPECIFIC_INFO;
#endif

/* 802.11 BSS entry */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_BSS_ENTRY {
    ULONG                               uPhyId;
    DOT11_BSS_ENTRY_PHY_SPECIFIC_INFO   PhySpecificInfo;
    DOT11_MAC_ADDRESS                   dot11BSSID;
    DOT11_BSS_TYPE                      dot11BSSType;
    LONG                                lRSSI;
    ULONG                               uLinkQuality;
    BOOLEAN                             bInRegDomain;
    USHORT                              usBeaconPeriod;
    ULONGLONG                           ullTimestamp;
    ULONGLONG                           ullHostTimestamp;
    USHORT                              usCapabilityInformation;
    ULONG                               uBufferLength;
    UCHAR                               ucBuffer[1];
} DOT11_BSS_ENTRY;
typedef DOT11_BSS_ENTRY *PDOT11_BSS_ENTRY;
#endif

/* 802.11 SSID list */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_SSID_LIST {
    NDIS_OBJECT_HEADER  Header;
    ULONG               uNumOfEntries;
    ULONG               uTotalNumOfEntries;
    DOT11_SSID          SSIDs[1];
} DOT11_SSID_LIST;
typedef DOT11_SSID_LIST *PDOT11_SSID_LIST;
#endif

/* 802.11 MAC address list */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_MAC_ADDRESS_LIST {
    NDIS_OBJECT_HEADER  Header;
    ULONG               uNumOfEntries;
    ULONG               uTotalNumOfEntries;
    DOT11_MAC_ADDRESS   MacAddrs[1];
} DOT11_MAC_ADDRESS_LIST;
typedef DOT11_MAC_ADDRESS_LIST  *PDOT11_MAC_ADDRESS_LIST;
#endif

/* 802.11 PMKID value */
#if (NTDDI_VERSION >= 0x06000000)
typedef UCHAR   DOT11_PMKID_VALUE[16];
#endif

/* 802.11 PMKID entry */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_PMKID_ENTRY {
    DOT11_MAC_ADDRESS   BSSID;
    DOT11_PMKID_VALUE   PMKID;
    ULONG               uFlags;
} DOT11_PMKID_ENTRY;
typedef DOT11_PMKID_ENTRY   *PDOT11_PMKID_ENTRY;
#endif

/* 802.11 PMKID list */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_PMKID_LIST {
    NDIS_OBJECT_HEADER  Header;
    ULONG               uNumOfEntries;
    ULONG               uTotalNumOfEntries;
    DOT11_PMKID_ENTRY   PMKIDs[1];
} DOT11_PMKID_LIST;
typedef DOT11_PMKID_LIST    *PDOT11_PMKID_LIST;
#endif

/* 802.11 physical frame statistics */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_PHY_FRAME_STATISTICS {
    ULONGLONG   ullTransmittedFrameCount;
    ULONGLONG   ullMulticastTransmittedFrameCount;
    ULONGLONG   ullFailedCount;
    ULONGLONG   ullRetryCount;
    ULONGLONG   ullMultipleRetryCount;
    ULONGLONG   ullMaxTXLifetimeExceededCount;
    ULONGLONG   ullTransmittedFragmentCount;
    ULONGLONG   ullRTSSuccessCount;
    ULONGLONG   ullRTSFailureCount;
    ULONGLONG   ullACKFailureCount;
    ULONGLONG   ullReceivedFrameCount;
    ULONGLONG   ullMulticastReceivedFrameCount;
    ULONGLONG   ullPromiscuousReceivedFrameCount;
    ULONGLONG   ullMaxRXLifetimeExceededCount;
    ULONGLONG   ullFrameDuplicateCount;
    ULONGLONG   ullReceivedFragmentCount;
    ULONGLONG   ullPromiscuousReceivedFragmentCount;
    ULONGLONG   ullFCSErrorCount;
} DOT11_PHY_FRAME_STATISTICS;
typedef DOT11_PHY_FRAME_STATISTICS  *PDOT11_PHY_FRAME_STATISTICS;
#endif

/* 802.11 MAC frame statistics */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_MAC_FRAME_STATISTICS {
    ULONGLONG   ullTransmittedFrameCount;
    ULONGLONG   ullReceivedFrameCount;
    ULONGLONG   ullTransmittedFailureFrameCount;
    ULONGLONG   ullReceivedFailureFrameCount;
    ULONGLONG   ullWEPExcludedCount;
    ULONGLONG   ullTKIPLocalMICFailures;
    ULONGLONG   ullTKIPReplays;
    ULONGLONG   ullTKIPICVErrorCount;
    ULONGLONG   ullCCMPReplays;
    ULONGLONG   ullCCMPDecryptErrors;
    ULONGLONG   ullWEPUndecryptableCount;
    ULONGLONG   ullWEPICVErrorCount;
    ULONGLONG   ullDecryptSuccessCount;
    ULONGLONG   ullDecryptFailureCount;
} DOT11_MAC_FRAME_STATISTICS;
typedef DOT11_MAC_FRAME_STATISTICS  *PDOT11_MAC_FRAME_STATISTICS;
#endif

/* 802.11 statistics */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_STATISTICS {
    NDIS_OBJECT_HEADER          Header;
    ULONGLONG                   ullFourWayHandshakeFailures;
    ULONGLONG                   ullTKIPCounterMeasuresInvoked;
    ULONGLONG                   ullReserved;
    DOT11_MAC_FRAME_STATISTICS  MacUcastCounters;
    DOT11_MAC_FRAME_STATISTICS  MacMcastCounters;
    DOT11_PHY_FRAME_STATISTICS  PhyCounters[1];
} DOT11_STATISTICS;
typedef DOT11_STATISTICS    *PDOT11_STATISTICS;
#endif

/* 802.11 privacy exemption */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_PRIVACY_EXEMPTION {
    USHORT  usEtherType;
    USHORT  usExemptionActionType;
    USHORT  usExemptionPacketType;
} DOT11_PRIVACY_EXEMPTION;
typedef DOT11_PRIVACY_EXEMPTION *PDOT11_PRIVACY_EXEMPTION;
#endif

/* 802.11 privacy exemption list */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_PRIVACY_EXEMPTION_LIST {
    NDIS_OBJECT_HEADER      Header;
    ULONG                   uNumOfEntries;
    ULONG                   uTotalNumOfEntries;
    DOT11_PRIVACY_EXEMPTION PrivacyExemptionEntries[1];
} DOT11_PRIVACY_EXEMPTION_LIST;
typedef DOT11_PRIVACY_EXEMPTION_LIST    *PDOT11_PRIVACY_EXEMPTION_LIST;
#endif

/* 802.11 authentication algorithm list */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_AUTH_ALGORITHM_LIST {
    NDIS_OBJECT_HEADER      Header;
    ULONG                   uNumOfEntries;
    ULONG                   uTotalNumOfEntries;
    DOT11_AUTH_ALGORITHM    AlgorithmIds[1];
} DOT11_AUTH_ALGORITHM_LIST;
typedef DOT11_AUTH_ALGORITHM_LIST   *PDOT11_AUTH_ALGORITHM_LIST;
#endif

/* 802.11 authentication cipher pair list */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_AUTH_CIPHER_PAIR_LIST {
    NDIS_OBJECT_HEADER      Header;
    ULONG                   uNumOfEntries;
    ULONG                   uTotalNumOfEntries;
    DOT11_AUTH_CIPHER_PAIR  AuthCipherPairs[1];
} DOT11_AUTH_CIPHER_PAIR_LIST;
typedef DOT11_AUTH_CIPHER_PAIR_LIST *PDOT11_AUTH_CIPHER_PAIR_LIST;
#endif

/* 802.11 cipher algorithm list */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_CIPHER_ALGORITHM_LIST {
    NDIS_OBJECT_HEADER      Header;
    ULONG                   uNumOfEntries;
    ULONG                   uTotalNumOfEntries;
    DOT11_CIPHER_ALGORITHM  AlgorithmIds[1];
} DOT11_CIPHER_ALGORITHM_LIST;
typedef DOT11_CIPHER_ALGORITHM_LIST *PDOT11_CIPHER_ALGORITHM_LIST;
#endif

/* 802.11 cipher default key value */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_CIPHER_DEFAULT_KEY_VALUE {
    NDIS_OBJECT_HEADER      Header;
    ULONG                   uKeyIndex;
    DOT11_CIPHER_ALGORITHM  AlgorithmId;
    DOT11_MAC_ADDRESS       MacAddr;
    BOOLEAN                 bDelete;
    BOOLEAN                 bStatic;
    USHORT                  usKeyLength;
    UCHAR                   ucKey[1];
} DOT11_CIPHER_DEFAULT_KEY_VALUE;
typedef DOT11_CIPHER_DEFAULT_KEY_VALUE  *PDOT11_CIPHER_DEFAULT_KEY_VALUE;
#endif

/* 802.11 key algorithm TKIP MIC */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_KEY_ALGO_TKIP_MIC {
    UCHAR   ucIV48Counter[6];
    ULONG   ulTKIPKeyLength;
    ULONG   ulMICKeyLength;
    UCHAR   ucTKIPMICKeys[1];
} DOT11_KEY_ALGO_TKIP_MIC;
typedef DOT11_KEY_ALGO_TKIP_MIC *PDOT11_KEY_ALGO_TKIP_MIC;
#endif

/* 802.11 key algorithm CCMP */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_KEY_ALGO_CCMP {
    UCHAR   ucIV48Counter[6];
    ULONG   ulCCMPKeyLength;
    UCHAR   ucCCMPKey[1];
} DOT11_KEY_ALGO_CCMP;
typedef DOT11_KEY_ALGO_CCMP *PDOT11_KEY_ALGO_CCMP;
#endif

/* 802.11 directions */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum DOT11_DIRECTION {
    DOT11_DIR_INBOUND   = 1,
    DOT11_DIR_OUTBOUND  = 2,
    DOT11_DIR_BOTH      = 3
} DOT11_DIRECTION;
typedef DOT11_DIRECTION *PDOT11_DIRECTION;
#endif

/* 802.11 cipher key mapping key value */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_CIPHER_KEY_MAPPING_KEY_VALUE {
    DOT11_MAC_ADDRESS       PeerMacAddr;
    DOT11_CIPHER_ALGORITHM  AlgorithmId;
    DOT11_DIRECTION         Direction;
    BOOLEAN                 bDelete;
    BOOLEAN                 bStatic;
    USHORT                  usKeyLength;
    UCHAR                   ucKey[1];
} DOT11_CIPHER_KEY_MAPPING_KEY_VALUE;
typedef DOT11_CIPHER_KEY_MAPPING_KEY_VALUE  *PDOT11_CIPHER_KEY_MAPPING_KEY_VALUE;
#endif

/* 802.11 association states */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum _DOT11_ASSOCIATION_STATE {
    dot11_assoc_state_zero              = 0,
    dot11_assoc_state_unauth_unassoc    = 1,
    dot11_assoc_state_auth_unassoc      = 2,
    dot11_assoc_state_auth_assoc        = 3
} DOT11_ASSOCIATION_STATE;
typedef DOT11_ASSOCIATION_STATE *PDOT11_ASSOCIATION_STATE;
#endif

/* 802.11 association information (extended version) */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_ASSOCIATION_INFO_EX {
    DOT11_MAC_ADDRESS       PeerMacAddress;
    DOT11_MAC_ADDRESS       BSSID;
    USHORT                  usCapabilityInformation;
    USHORT                  usListenInterval;
    UCHAR                   ucPeerSupportedRates[MAX_NUM_SUPPORTED_RATES_V2];
    USHORT                  usAssociationID;
    DOT11_ASSOCIATION_STATE dot11AssociationState;
    DOT11_POWER_MODE        dot11PowerMode;
    LARGE_INTEGER           liAssociationUpTime;
    ULONGLONG               ullNumOfTxPacketSuccesses;
    ULONGLONG               ullNumOfTxPacketFailures;
    ULONGLONG               ullNumOfRxPacketSuccesses;
    ULONGLONG               ullNumOfRxPacketFailures;
} DOT11_ASSOCIATION_INFO_EX;
typedef DOT11_ASSOCIATION_INFO_EX   *PDOT11_ASSOCIATION_INFO_EX;
#endif

/* 802.11 association information list */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_ASSOCIATION_INFO_LIST {
    NDIS_OBJECT_HEADER          Header;
    ULONG                       uNumOfEntries;
    ULONG                       uTotalNumOfEntries;
    DOT11_ASSOCIATION_INFO_EX   dot11AssocInfo[1];
} DOT11_ASSOCIATION_INFO_LIST;
typedef DOT11_ASSOCIATION_INFO_LIST *PDOT11_ASSOCIATION_INFO_LIST;
#endif

/* 802.11 physical identifier list */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_PHY_ID_LIST {
    NDIS_OBJECT_HEADER  Header;
    ULONG               uNumOfEntries;
    ULONG               uTotalNumOfEntries;
    ULONG               dot11PhyId[1];
} DOT11_PHY_ID_LIST;
typedef DOT11_PHY_ID_LIST   *PDOT11_PHY_ID_LIST;
#endif

/* 802.11 ExtSTA capability */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_EXTSTA_CAPABILITY {
    NDIS_OBJECT_HEADER  Header;
    ULONG               uScanSSIDListSize;
    ULONG               uDesiredBSSIDListSize;
    ULONG               uDesiredSSIDListSize;
    ULONG               uExcludedMacAddressListSize;
    ULONG               uPrivacyExemptionListSize;
    ULONG               uKeyMappingTableSize;
    ULONG               uDefaultKeyTableSize;
    ULONG               uWEPKeyValueMaxLength;
    ULONG               uPMKIDCacheSize;
    ULONG               uMaxNumPerSTADefaultKeyTables;
} DOT11_EXTSTA_CAPABILITY;
typedef DOT11_EXTSTA_CAPABILITY *PDOT11_EXTSTA_CAPABILITY;
#endif

/* 802.11 data rate mapping entry */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_DATA_RATE_MAPPING_ENTRY {
    UCHAR   ucDataRateIndex;
    UCHAR   ucDataRateFlag;
    USHORT  usDataRateValue;
} DOT11_DATA_RATE_MAPPING_ENTRY;
typedef DOT11_DATA_RATE_MAPPING_ENTRY   *PDOT11_DATA_RATE_MAPPING_ENTRY;
#endif

/* 802.11 data rate mapping table */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_DATA_RATE_MAPPING_TABLE {
    NDIS_OBJECT_HEADER              Header;
    ULONG                           uDataRateMappingLength;
    DOT11_DATA_RATE_MAPPING_ENTRY   DataRateMappingEntries[DOT11_RATE_SET_MAX_LENGTH];
} DOT11_DATA_RATE_MAPPING_TABLE;
typedef DOT11_DATA_RATE_MAPPING_TABLE   *PDOT11_DATA_RATE_MAPPING_TABLE;
#endif

/* 802.11 country or region string list */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_COUNTRY_OR_REGION_STRING_LIST {
    NDIS_OBJECT_HEADER              Header;
    ULONG                           uNumOfEntries;
    ULONG                           uTotalNumOfEntries;
    DOT11_COUNTRY_OR_REGION_STRING  CountryOrRegionStrings[1];
} DOT11_COUNTRY_OR_REGION_STRING_LIST;
typedef DOT11_COUNTRY_OR_REGION_STRING_LIST *PDOT11_COUNTRY_OR_REGION_STRING_LIST;
#endif

/* 802.11 port state notification */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_PORT_STATE_NOTIFICATION {
    NDIS_OBJECT_HEADER  Header;
    DOT11_MAC_ADDRESS   PeerMac;
    BOOLEAN             bOpen;
} DOT11_PORT_STATE_NOTIFICATION;
typedef DOT11_PORT_STATE_NOTIFICATION   *PDOT11_PORT_STATE_NOTIFICATION;
#endif

/* 802.11 IBSS parameters */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_IBSS_PARAMS {
    NDIS_OBJECT_HEADER  Header;
    BOOLEAN             bJoinOnly;
    ULONG               uIEsOffset;
    ULONG               uIEsLength;
} DOT11_IBSS_PARAMS;
typedef DOT11_IBSS_PARAMS   *PDOT11_IBSS_PARAMS;
#endif

/* 802.11 QOS parameters */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_QOS_PARAMS {
    NDIS_OBJECT_HEADER  Header;
    UCHAR               ucEnabledQoSProtocolFlags;
} DOT11_QOS_PARAMS;
typedef DOT11_QOS_PARAMS    *PDOT11_QOS_PARAMS;
#endif

/* 802.11 association parameters */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_ASSOCIATON_PARAMS {
    NDIS_OBJECT_HEADER  Header;
    DOT11_MAC_ADDRESS   BSSID;
    ULONG               uAssocRequestIEsOffset;
    ULONG               uAssocRequestIEsLength;
} DOT11_ASSOCIATION_PARAMS;
typedef DOT11_ASSOCIATION_PARAMS    *PDOT11_ASSOCIATION_PARAMS;
#endif

/* 802.11 fragment descriptor */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_FRAGMENT_DESCRIPTOR {
    ULONG   uOffset;
    ULONG   uLength;
} DOT11_FRAGMENT_DESCRIPTOR;
typedef DOT11_FRAGMENT_DESCRIPTOR   *PDOT11_FRAGMENT_DESCRIPTOR;
#endif

/* 802.11 per MSDU counters */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_PER_MSDU_COUNTERS {
    ULONG   uTransmittedFragmentCount;
    ULONG   uRetryCount;
    ULONG   uRTSSuccessCount;
    ULONG   uRTSFailureCount;
    ULONG   uACKFailureCount;
} DOT11_PER_MSDU_COUNTERS;
typedef DOT11_PER_MSDU_COUNTERS *PDOT11_PER_MSDU_COUNTERS;
#endif

/* 802.11 HRDSSS physical attributes */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_HRDSSS_PHY_ATTRIBUTES {
    BOOLEAN bShortPreambleOptionImplemented;
    BOOLEAN bPBCCOptionImplemented;
    BOOLEAN bChannelAgilityPresent;
    ULONG   uHRCCAModeSupported;
} DOT11_HRDSSS_PHY_ATTRIBUTES;
typedef DOT11_HRDSSS_PHY_ATTRIBUTES *PDOT11_HRDSSS_PHY_ATTRIBUTES;
#endif

/* 802.11 OFDM physical attributes */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_OFDM_PHY_ATTRIBUTES {
    ULONG   uFrequencyBandsSupported;
} DOT11_OFDM_PHY_ATTRIBUTES;
typedef DOT11_OFDM_PHY_ATTRIBUTES   *PDOT11_OFDM_PHY_ATTRIBUTES;
#endif

/* 802.11 ERP physical attributes */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_ERP_PHY_ATTRIBUTES {
#ifdef __cplusplus
    DOT11_HRDSSS_PHY_ATTRIBUTES HRDSSSAttributes;
#else
    DOT11_HRDSSS_PHY_ATTRIBUTES;
#endif
    BOOLEAN                     bERPPBCOptionImplemented;
    BOOLEAN                     bDSSSOFDMOptionImplemented;
    BOOLEAN                     bShortSlotTimeOptionImplemented;
} DOT11_ERP_PHY_ATTRIBUTES;
typedef DOT11_ERP_PHY_ATTRIBUTES    *PDOT11_ERP_PHY_ATTRIBUTES;
#endif

/* 802.11 physical attributes */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_PHY_ATTRIBUTES {
    NDIS_OBJECT_HEADER      Header;
    DOT11_PHY_TYPE          PhyType;
    BOOLEAN                 bHardwarePhyState;
    BOOLEAN                 bSoftwarePhyState;
    BOOLEAN                 bCFPollable;
    ULONG                   uMPDUMaxLength;
    DOT11_TEMP_TYPE         TempType;
    DOT11_DIVERSITY_SUPPORT DiversitySupport;
    union {
        DOT11_HRDSSS_PHY_ATTRIBUTES HRDSSSAttributes;
        DOT11_OFDM_PHY_ATTRIBUTES   OFDMAttributes;
        DOT11_ERP_PHY_ATTRIBUTES    ERPAttributes;
#ifdef __cplusplus
    } PhySpecificAttributes;
#else
    };
#endif
    ULONG                   uNumberSupportedPowerLevels;
    ULONG                   TxPowerLevels[8];
    ULONG                   uNumDataRateMappingEntries;
    DOT11_DATA_RATE_MAPPING_ENTRY   DataRateMappingEntries[DOT11_RATE_SET_MAX_LENGTH];
    DOT11_SUPPORTED_DATA_RATES_VALUE_V2 SupportedDataRatesValue;
} DOT11_PHY_ATTRIBUTES;
typedef DOT11_PHY_ATTRIBUTES    *PDOT11_PHY_ATTRIBUTES;
#endif

/* 802.11 ExtSTA attributes */
#if (NTDDI_VERSION >= 0x06000000) && defined( NDIS_SUPPORT_NDIS6 )
typedef struct DOT11_EXTSTA_ATTRIBUTES {
    NDIS_OBJECT_HEADER      Header;
    ULONG                   uScanSSIDListSize;
    ULONG                   uDesiredBSSIDListSize;
    ULONG                   uDesiredSSIDListSize;
    ULONG                   uExcludedMacAddressListSize;
    ULONG                   uPrivacyExemptionListSize;
    ULONG                   uKeyMappingTableSize;
    ULONG                   uDefaultKeyTableSize;
    ULONG                   uWEPKeyValueMaxLength;
    ULONG                   uPMKIDCacheSize;
    ULONG                   uMaxNumPerSTADefaultKeyTables;
    BOOLEAN                 bStrictlyOrderedServiceClassImplemented;
    UCHAR                   ucSupportedQoSProtocolFlags;
    BOOLEAN                 bSafeModeImplemented;
    ULONG                   uNumSupportedCountryOrRegionStrings;
    PDOT11_COUNTRY_OR_REGION_STRING pSupportedCountryOrRegionStrings;
    ULONG                   uInfraNumSupportedUcastAlgoPairs;
    PDOT11_AUTH_CIPHER_PAIR pInfraSupportedUcastAlgoPairs;
    ULONG                   uInfraNumSupportedMcastAlgoPairs;
    PDOT11_AUTH_CIPHER_PAIR pInfraSupportedMcastAlgoPairs;
    ULONG                   uAdhocNumSupportedUcastAlgoPairs;
    PDOT11_AUTH_CIPHER_PAIR pAdhocSupportedUcastAlgoPairs;
    ULONG                   uAdhocNumSupportedMcastAlgoPairs;
    PDOT11_AUTH_CIPHER_PAIR pAdhocSupportedMcastAlgoPairs;
} DOT11_EXTSTA_ATTRIBUTES;
typedef DOT11_EXTSTA_ATTRIBUTES *PDOT11_EXTSTA_ATTRIBUTES;
#endif

/* 802.11 send context */
#if (NTDDI_VERSION >= 0x06000000) && (defined( _NDIS_ ) || defined( NDIS_WRAPPER )) && \
    defined( NDIS_SUPPORT_NDIS6 )
typedef struct _DOT11_SEND_CONTEXT {
    NDIS_OBJECT_HEADER          Header;
    PVOID                       pvReserved;
    ULONG                       uFlags;
    ULONG                       uPSLifetime;
    ULONG                       uDelayedSleepValue;
    UCHAR                       ucTXDataRates[8];
    BOOLEAN                     bIndicateAssociatedACKs;
    BOOLEAN                     bIndicateTXStatus;
    UCHAR                       ucPriority;
    BOOLEAN                     bDontFragment;
    ULONG                       dwExtendedStatus;
    HANDLE                      hIntegrityOffload;
    HANDLE                      hWEPOffload;
    UCHAR                       ucWPAMSDUPriority;
    UCHAR                       ucNumOfRWsOnPeer;
    USHORT                      usAID;
    PDOT11_PER_MSDU_COUNTERS    pDot11PerMSDUCounters;
} DOT11_SEND_CONTEXT;
typedef DOT11_SEND_CONTEXT  *PDOT11_SEND_CONTEXT;
#endif

/* 802.11 send extension information */
#if (NTDDI_VERSION >= 0x06000000) && (defined( _NDIS_ ) || defined( NDIS_WRAPPER )) && \
    defined( NDIS_SUPPORT_NDIS6 )
typedef struct _DOT11_SEND_EXTENSION_INFO {
    ULONG                       uVersion;
    NDIS_OBJECT_HEADER          Header;
    PVOID                       pvReserved;
    ULONG                       uFlags;
    ULONG                       uPSLifetime;
    ULONG                       uDelayedSleepValue;
    UCHAR                       ucTXDataRates[8];
    BOOLEAN                     bIndicateAssociatedACKs;
    BOOLEAN                     bIndicateTXStatus;
    UCHAR                       ucPriority;
    BOOLEAN                     bDontFragment;
    ULONG                       dwExtendedStatus;
    HANDLE                      hIntegrityOffload;
    HANDLE                      hWEPOffload;
    UCHAR                       ucWPAMSDUPriority;
    UCHAR                       ucNumOfRWsOnPeer;
    USHORT                      usAID;
    PDOT11_PER_MSDU_COUNTERS    pDot11PerMSDUCounters;
    USHORT                      usNumberOfFragments;
    DOT11_FRAGMENT_DESCRIPTOR   Dot11FragmentDescriptors[1];
} DOT11_SEND_EXTENSION_INFO;
typedef DOT11_SEND_EXTENSION_INFO   *PDOT11_SEND_EXTENSION_INFO;
#endif

/* 802.11 ACK policies */
#if (NTDDI_VERSION >= 0x06000000) && (defined( _NDIS_ ) || defined( NDIS_WRAPPER )) && \
    defined( NDIS_SUPPORT_NDIS6 )
typedef enum _DOT11_ACK_POLICY {
    dot11_ack_policy_none               = 0,
    dot11_ack_policy_acknowledge        = 1,
    dot11_ack_policy_do_not_acknowledge = 2
} DOT11_ACK_POLICY;
typedef DOT11_ACK_POLICY    *PDOT11_ACK_POLICY;
#endif

/* 802.11 send extension information (version 2) */
#if (NTDDI_VERSION >= 0x06000000) && (defined( _NDIS_ ) || defined( NDIS_WRAPPER )) && \
    defined( NDIS_SUPPORT_NDIS6 )
typedef struct _DOT11_SEND_EXTENSION_INFO_V2 {
    UCHAR   ucQosPriority   : 4;
    UCHAR   ucAckPolicy     : 4;
    USHORT  usExtendedTXDataRatesOffset;
    UCHAR   ucNumOfExtendedTXDataRates;
    UCHAR   ucBuffer[1];
} DOT11_SEND_EXTENSION_INFO_V2;
typedef DOT11_SEND_EXTENSION_INFO_V2    *PDOT11_SEND_EXTENSION_INFO_V2;
#endif

/* 802.11 receive context */
#if (NTDDI_VERSION >= 0x06000000) && (defined( _NDIS_ ) || defined( NDIS_WRAPPER )) && \
    defined( NDIS_SUPPORT_NDIS6 )
typedef struct _DOT11_RECV_CONTEXT {
    NDIS_OBJECT_HEADER  Header;
    PVOID               pvReserved;
    DOT11_PHY_TYPE      dot11PhyType;
    ULONG               uChCenterFrequency;
    LONG                lRSSI;
    ULONG               uRSSI;
    UCHAR               ucPriority;
    UCHAR               ucDataRate;
    UCHAR               ucPeerMacAddress[6];
    ULONG               dwExtendedStatus;
    HANDLE              hWEPOffloadContext;
    HANDLE              hAuthOffloadContext;
    USHORT              usWEPAppliedMask;
    USHORT              usWPAMSDUPriority;
    DOT11_IV48_COUNTER  dot11LowestIV48Counter;
    USHORT              usDot11LeftRWBitMap;
    DOT11_IV48_COUNTER  dot11HighestIV48Counter;
    USHORT              usDot11RightRWBitMap;
    USHORT              usNumberOfMPDUsReceived;
} DOT11_RECV_CONTEXT;
typedef DOT11_RECV_CONTEXT  *PDOT11_RECV_CONTEXT;
#endif

/* 802.11 receive extension information */
#if (NTDDI_VERSION >= 0x06000000) && (defined( _NDIS_ ) || defined( NDIS_WRAPPER )) && \
    !defined( NDIS_SUPPORT_NDIS6 )
typedef struct _DOT11_RECV_EXTENSION_INFO {
    ULONG               uVersion;
    PVOID               pvReserved;
    DOT11_PHY_TYPE      dot11PhyType;
    ULONG               uChCenterFrequency;
    LONG                lRSSI;
    LONG                lRSSIMin;
    LONG                lRSSIMax;
    ULONG               uRSSI;
    UCHAR               ucPriority;
    UCHAR               ucDataRate;
    UCHAR               ucPeerMacAddress[6];
    ULONG               dwExtendedStatus;
    HANDLE              hWEPOffloadContext;
    HANDLE              hAuthOffloadContext;
    USHORT              usWEPAppliedMask;
    USHORT              usWPAMSDUPriority;
    DOT11_IV48_COUNTER  dot11LowestIV48Counter;
    USHORT              usDot11LeftRWBitMap;
    DOT11_IV48_COUNTER  dot11HighestIV48Counter;
    USHORT              usDot11RightRWBitMap;
    USHORT              usNumberOfMPDUsReceived;
    USHORT              usNumberOfFragments;
    PVOID               pNdisPackets[1];
} DOT11_RECV_EXTENSION_INFO;
typedef DOT11_RECV_EXTENSION_INFO   *PDOT11_RECV_EXTENSION_INFO;
#endif

/* 802.11 receive extension information (version 2) */
#if (NTDDI_VERSION >= 0x06000000) && (defined( _NDIS_ ) || defined( NDIS_WRAPPER )) && \
    !defined( NDIS_SUPPORT_NDIS6 )
typedef struct _DOT11_RECV_EXTENSION_INFO_V2 {
    ULONG               uVersion;
    PVOID               pvReserved;
    DOT11_PHY_TYPE      dot11PhyType;
    ULONG               uChCenterFrequency;
    LONG                lRSSI;
    ULONG               uRSSI;
    UCHAR               ucPriority;
    UCHAR               ucDataRate;
    UCHAR               ucPeerMacAddress[6];
    ULONG               dwExtendedStatus;
    HANDLE              hWEPOffloadContext;
    HANDLE              hAuthOffloadContext;
    USHORT              usWEPAppliedMask;
    USHORT              usWPAMSDUPriority;
    DOT11_IV48_COUNTER  dot11LowestIV48Counter;
    USHORT              usDot11LeftRWBitMap;
    DOT11_IV48_COUNTER  dot11HighestIV48Counter;
    USHORT              usDot11RightRWBitMap;
    USHORT              usNumberOfMPDUsReceived;
    USHORT              usNumberOfFragments;
    PVOID               pNdisPackets[1];
} DOT11_RECV_EXTENSION_INFO_V2;
typedef DOT11_RECV_EXTENSION_INFO_V2    *PDOT11_RECV_EXTENSION_INFO_V2;
#endif

/* 802.11 status indication */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _DOT11_STATUS_INDICATION {
    ULONG       uStatusType;
    NDIS_STATUS ndisStatus;
} DOT11_STATUS_INDICATION;
typedef DOT11_STATUS_INDICATION *PDOT11_STATUS_INDICATION;
#endif

/* 802.11 MPDU maximum length indication */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_MDPU_MAX_LENGTH_INDICATION {
#ifdef NDIS_SUPPORT_NDIS6
    NDIS_OBJECT_HEADER  Header;
#else
    ULONG               uStatusType;
    ULONG               uVersion;
#endif
    ULONG               uPhyId;
    ULONG               uMPDUMaxLength;
} DOT11_MPDU_MAX_LENGTH_INDICATION;
typedef DOT11_MPDU_MAX_LENGTH_INDICATION    *PDOT11_MPDU_MAX_LENGTH_INDICATION;
#endif

/* 802.11 association start parameters */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_ASSOCIATION_START_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    DOT11_MAC_ADDRESS   MacAddr;
    DOT11_SSID          SSID;
    ULONG               uIHVDataOffset;
    ULONG               uIHVDataSize;
} DOT11_ASSOCIATION_START_PARAMETERS;
typedef DOT11_ASSOCIATION_START_PARAMETERS  *PDOT11_ASSOCIATION_START_PARAMETERS;
#endif

/* 802.11 encapsulation entry */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_ENCAP_ENTRY {
    USHORT  usEtherType;
    USHORT  usEncapType;
} DOT11_ENCAP_ENTRY;
typedef DOT11_ENCAP_ENTRY   *PDOT11_ENCAP_ENTRY;
#endif

/* 802.11 DS information values */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum DOT11_DS_INFO {
    DOT11_DS_CHANGED    = 0,
    DOT11_DS_UNCHANGED  = 1,
    DOT11_DS_UNKNOWN    = 2
} DOT11_DS_INFO;
typedef DOT11_DS_INFO   *PDOT11_DS_INFO;
#endif

/* 802.11 association completion parameters */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_ASSOCIATION_COMPLETION_PARAMETERS {
    NDIS_OBJECT_HEADER      Header;
    DOT11_MAC_ADDRESS       MacAddr;
    DOT11_ASSOC_STATUS      Status;
    BOOLEAN                 bReAssocReq;
    BOOLEAN                 bReAssocResp;
    ULONG                   uAssocReqOffset;
    ULONG                   uAssocReqSize;
    ULONG                   uAssocRespOffset;
    ULONG                   uAssocRespSize;
    ULONG                   uBeaconOffset;
    ULONG                   uBeaconSize;
    ULONG                   uIHVDataOffset;
    ULONG                   uIHVDataSize;
    DOT11_AUTH_ALGORITHM    AuthAlgo;
    DOT11_CIPHER_ALGORITHM  UnicastCipher;
    DOT11_CIPHER_ALGORITHM  MulticastCipher;
    ULONG                   uActivePhyListOffset;
    ULONG                   uActivePhyListSize;
    BOOLEAN                 bFourAddressSupported;
    BOOLEAN                 bPortAuthorized;
    UCHAR                   ucActiveQoSProtocol;
    DOT11_DS_INFO           DSInfo;
    ULONG                   uEncapTableOffset;
    ULONG                   uEncapTableSize;
} DOT11_ASSOCIATION_COMPLETION_PARAMETERS;
typedef DOT11_ASSOCIATION_COMPLETION_PARAMETERS *PDOT11_ASSOCIATION_COMPLETION_PARAMETERS;
#endif

/* 802.11 connection start parameters */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_CONNECTION_START_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    DOT11_BSS_TYPE      BSSType;
    DOT11_MAC_ADDRESS   AdhocBSSID;
    DOT11_SSID          AdhocSSID;
} DOT11_CONNECTION_START_PARAMETERS;
typedef DOT11_CONNECTION_START_PARAMETERS   *PDOT11_CONNECTION_START_PARAMETERS;
#endif

/* 802.11 connection completion parameters */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_CONNECTION_COMPLETION_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    DOT11_ASSOC_STATUS  uStatus;
} DOT11_CONNECTION_COMPLETION_PARAMETERS;
typedef DOT11_CONNECTION_COMPLETION_PARAMETERS  *PDOT11_CONNECTION_COMPLETION_PARAMETERS;
#endif

/* 802.11 roaming start parameters */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_ROAMING_START_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    DOT11_MAC_ADDRESS   AdhocBSSID;
    DOT11_SSID          AdhocSSID;
    DOT11_ASSOC_STATUS  uRoamingReason;
} DOT11_ROAMING_START_PARAMETERS;
typedef DOT11_ROAMING_START_PARAMETERS  *PDOT11_ROAMING_START_PARAMETERS;
#endif

/* 802.11 roaming completion parameters */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_ROAMING_COMPLETION_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    DOT11_ASSOC_STATUS  uStatus;
} DOT11_ROAMING_COMPLETION_PARAMETERS;
typedef DOT11_ROAMING_COMPLETION_PARAMETERS *PDOT11_ROAMING_COMPLETION_PARAMETERS;
#endif

/* 802.11 disassociation parameters */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_DISASSOCIATION_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    DOT11_MAC_ADDRESS   MacAddr;
    DOT11_ASSOC_STATUS  uReason;
    ULONG               uIHVDataOffset;
    ULONG               uIHVDataSize;
} DOT11_DISASSOCIATION_PARAMETERS;
typedef DOT11_DISASSOCIATION_PARAMETERS *PDOT11_DISASSOCIATION_PARAMETERS;
#endif

/* 802.11 TKIPMIC failure parameters */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_TKIPMIC_FAILURE_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    BOOLEAN             bDefaultKeyFailure;
    ULONG               uKeyIndex;
    DOT11_MAC_ADDRESS   PeerMac;
} DOT11_TKIPMIC_FAILURE_PARAMETERS;
typedef DOT11_TKIPMIC_FAILURE_PARAMETERS    *PDOT11_TKIPMIC_FAILURE_PARAMETERS;
#endif

/* 802.11 PMKID candidate list parameters */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_PMKID_CANDIDATE_LIST_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    ULONG               uCandidateListSize;
    ULONG               uCandidateListOffset;
} DOT11_PMKID_CANDIDATE_LIST_PARAMETERS;
typedef DOT11_PMKID_CANDIDATE_LIST_PARAMETERS   *PDOT11_PMKID_CANDIDATE_LIST_PARAMETERS;
#endif

/* 802.11 BSSID candidate */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_BSSID_CANDIDATE {
    DOT11_MAC_ADDRESS   BSSID;
    ULONG               uFlags;
} DOT11_BSSID_CANDIDATE;
typedef DOT11_BSSID_CANDIDATE   *PDOT11_BSSID_CANDIDATE;
#endif

/* 802.11 physical state parameters */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_PHY_STATE_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    ULONG               uPhyId;
    BOOLEAN             bHardwarePhyState;
    BOOLEAN             bSoftwarePhyState;
} DOT11_PHY_STATE_PARAMETERS;
typedef DOT11_PHY_STATE_PARAMETERS  *PDOT11_PHY_STATE_PARAMETERS;
#endif

/* 802.11 link quality entry */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_LINK_QUALITY_ENTRY {
    DOT11_MAC_ADDRESS   PeerMacAddr;
    UCHAR               ucLinkQuality;
} DOT11_LINK_QUALITY_ENTRY;
typedef DOT11_LINK_QUALITY_ENTRY    *PDOT11_LINK_QUALITY_ENTRY;
#endif

/* 802.11 link quality parameters */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_LINK_QUALITY_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    ULONG               uLinkQualityListSize;
    ULONG               uLinkQualityListOffset;
} DOT11_LINK_QUALITY_PARAMETERS;
typedef DOT11_LINK_QUALITY_PARAMETERS   *PDOT11_LINK_QUALITY_PARAMETERS;
#endif

/* 802.11 ExtSTA send context */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_EXTSTA_SEND_CONTEXT {
    NDIS_OBJECT_HEADER  Header;
    USHORT              usExemptionActionType;
    ULONG               uPhyId;
    ULONG               uDelayedSleepValue;
    PVOID               pvMediaSpecificInfo;
    ULONG               uSendFlags;
} DOT11_EXTSTA_SEND_CONTEXT;
typedef DOT11_EXTSTA_SEND_CONTEXT   *PDOT11_EXTSTA_SEND_CONTEXT;
#ifdef NWF_SUPPORT_EXTAP
typedef DOT11_EXTSTA_SEND_CONTEXT   DOT11_EXTAP_SEND_CONTEXT;
typedef DOT11_EXTSTA_SEND_CONTEXT   *PDOT11_EXTAP_SEND_CONTEXT;
#endif
#endif

/* 802.11 ExtSTA receive context */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct DOT11_EXTSTA_RECV_CONTEXT {
    NDIS_OBJECT_HEADER  Header;
    ULONG               uReceiveFlags;
    ULONG               uPhyId;
    ULONG               uChCenterFrequency;
    USHORT              usNumberOfMPDUsReceived;
    LONG                lRSSI;
    UCHAR               ucDataRate;
    ULONG               uSizeMediaSpecificInfo;
    PVOID               pvMediaSpecificInfo;
    ULONGLONG           ullTimestamp;
} DOT11_EXTSTA_RECV_CONTEXT;
typedef DOT11_EXTSTA_RECV_CONTEXT   *PDOT11_EXTSTA_RECV_CONTEXT;
#ifdef NWF_SUPPORT_EXTAP
typedef DOT11_EXTSTA_RECV_CONTEXT   DOT11_EXTAP_RECV_CONTEXT;
typedef DOT11_EXTSTA_RECV_CONTEXT   *PDOT11_EXTAP_RECV_CONTEXT;
#endif
#endif

/* 802.11 ExtAP attributes */
#ifdef NWF_EXTAP_SUPPORTED
typedef struct _DOT11_EXTAP_ATTRIBUTES {
    NDIS_OBJECT_HEADER      Header;
    ULONG                   uScanSSIDListSize;
    ULONG                   uDesiredSSIDListSize;
    ULONG                   uPrivacyExemptionListSize;
    ULONG                   uAssociationTableSize;
    ULONG                   uDefaultKeyTableSize;
    ULONG                   uWEPKeyValueMaxLength;
    BOOLEAN                 bStrictlyOrderedServiceClassImplemented;
    ULONG                   uNumSupportedCountryOrRegionStrings;
    PDOT11_COUNTRY_OR_REGION_STRING pSupportedCountryOrRegionStrings;
    ULONG                   uInfraNumSupportedUcastAlgoPairs;
    PDOT11_AUTH_CIPHER_PAIR pInfraSupportedUcastAlgoPairs;
    ULONG                   uInfraNumSupportedMcastAlgoPairs;
    PDOT11_AUTH_CIPHER_PAIR pInfraSupportedMcastAlgoPairs;
} DOT11_EXTAP_ATTRIBUTES;
typedef DOT11_EXTAP_ATTRIBUTES  *PDOT11_EXTAP_ATTRIBUTES;
#endif

/* 802.11 incoming association started parameters */
#ifdef NWF_EXTAP_SUPPORTED
typedef struct _DOT11_INCOMING_ASSOC_STARTED_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    DOT11_MAC_ADDRESS   PeerMacAddr;
} DOT11_INCOMING_ASSOC_STARTED_PARAMETERS;
typedef DOT11_INCOMING_ASSOC_STARTED_PARAMETERS *PDOT11_INCOMING_ASSOC_STARTED_PARAMETERS;
#endif

/* 802.11 incoming association request received parameters */
#ifdef NWF_EXTAP_SUPPORTED
typedef struct _DOT11_INCOMING_ASSOC_REQUEST_RECEIVED_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    DOT11_MAC_ADDRESS   PeerMacAddr;
    BOOLEAN             bReAssocReq;
    ULONG               uAssocReqOffset;
    ULONG               uAssocReqSize;
} DOT11_INCOMING_ASSOC_REQUEST_RECEIVED_PARAMETERS;
typedef DOT11_INCOMING_ASSOC_REQUEST_RECEIVED_PARAMETERS    *PDOT11_INCOMING_ASSOC_REQUEST_RECEIVED_PARAMETERS;
#endif

/* 802.11 incoming association completion parameters */
#ifdef NWF_EXTAP_SUPPORTED
typedef struct _DOT11_INCOMING_ASSOC_COMPLETION_PARAMETERS {
    NDIS_OBJECT_HEADER      Header;
    DOT11_MAC_ADDRESS       PeerMacAddr;
    ULONG                   uStatus;
    UCHAR                   ucErrorSource;
    BOOLEAN                 bReAssocReq;
    BOOLEAN                 bReAssocResp;
    ULONG                   uAssocReqOffset;
    ULONG                   uAssocReqSize;
    ULONG                   uAssocRespOffset;
    ULONG                   uAssocRespSize;
    DOT11_AUTH_ALGORITHM    AuthAlgo;
    DOT11_CIPHER_ALGORITHM  UnicastCipher;
    DOT11_CIPHER_ALGORITHM  MulticastCipher;
    ULONG                   uActivePhyListOffset;
    ULONG                   uActivePhyListSize;
    ULONG                   uBeaconOffset;
    ULONG                   uBeaconSize;
} DOT11_INCOMING_ASSOC_COMPLETION_PARAMETERS;
typedef DOT11_INCOMING_ASSOC_COMPLETION_PARAMETERS  *PDOT11_INCOMING_ASSOC_COMPLETION_PARAMETERS;
#endif

/* 802.11 stop AP parameters */
#ifdef NWF_EXTAP_SUPPORTED
typedef struct _DOT11_STOP_AP_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    ULONG               ulReason;
} DOT11_STOP_AP_PARAMETERS;
typedef DOT11_STOP_AP_PARAMETERS    *PDOT11_STOP_AP_PARAMETERS;
#endif

/* 802.11 physical frequency adopted parameters */
#ifdef NWF_EXTAP_SUPPORTED
typedef struct _DOT11_PHY_FREQUENCY_ADOPTED_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    ULONG               ulPhyID;
    union {
        ULONG   ulChannel;
        ULONG   ulFrequency;
    };
} DOT11_PHY_FREQUENCY_ADOPTED_PARAMETERS;
typedef DOT11_PHY_FREQUENCY_ADOPTED_PARAMETERS  *PDOT11_PHY_FREQUENCY_ADOPTED_PARAMETERS;
#endif

/* 802.11 can sustain AP parameters */
#ifdef NWF_EXTAP_SUPPORTED
typedef struct _DOT11_CAN_SUSTAIN_AP_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    ULONG               ulReason;
} DOT11_CAN_SUSTAIN_AP_PARAMETERS;
typedef DOT11_CAN_SUSTAIN_AP_PARAMETERS *PDOT11_CAN_SUSTAIN_AP_PARAMETERS;
#endif

/* 802.11 available channel list */
#ifdef NWF_EXTAP_SUPPORTED
typedef struct _DOT11_AVAILABLE_CHANNEL_LIST {
    NDIS_OBJECT_HEADER  Header;
    ULONG               uNumOfEntries;
    ULONG               uTotalNumOfEntries;
    ULONG               uChannelNumber[1];
} DOT11_AVAILABLE_CHANNEL_LIST;
typedef DOT11_AVAILABLE_CHANNEL_LIST    *PDOT11_AVAILABLE_CHANNEL_LIST;
#endif

/* 802.11 available frequency list */
#ifdef NWF_EXTAP_SUPPORTED
typedef struct _DOT11_AVAILABLE_FREQUENCY_LIST {
    NDIS_OBJECT_HEADER  Header;
    ULONG               uNumOfEntries;
    ULONG               uTotalNumOfEntries;
    ULONG               uFrequencyValue[1];
} DOT11_AVAILABLE_FREQUENCY_LIST;
typedef DOT11_AVAILABLE_FREQUENCY_LIST  *PDOT11_AVAILABLE_FREQUENCY_LIST;
#endif

/* 802.11 disassociate peer request */
#ifdef NWF_EXTAP_SUPPORTED
typedef struct _DOT11_DISASSOCIATE_PEER_REQUEST {
    NDIS_OBJECT_HEADER  Header;
    DOT11_MAC_ADDRESS   PeerMacAddr;
    USHORT              usReason;
} DOT11_DISASSOCIATE_PEER_REQUEST;
typedef DOT11_DISASSOCIATE_PEER_REQUEST *PDOT11_DISASSOCIATE_PEER_REQUEST;
#endif

/* 802.11 incoming association decision */
#ifdef NWF_EXTAP_SUPPORTED
typedef struct _DOT11_INCOMING_ASSOC_DECISION {
    NDIS_OBJECT_HEADER  Header;
    DOT11_MAC_ADDRESS   PeerMacAddr;
    BOOLEAN             bAccept;
    USHORT              usReasonCode;
    ULONG               uAssocResponseIEsOffset;
    ULONG               uAssocResponseIEsLength;
} DOT11_INCOMING_ASSOC_DECISION;
typedef DOT11_INCOMING_ASSOC_DECISION   *PDOT11_INCOMING_ASSOC_DECISION;
#endif

/* 802.11 additional information element */
#ifdef NWF_EXTAP_SUPPORTED
typedef struct _DOT11_ADDITIONAL_IE {
    NDIS_OBJECT_HEADER  Header;
    ULONG               uBeaconIEsOffset;
    ULONG               uBeaconIEsLength;
    ULONG               uResponseIEsOffset;
    ULONG               uResponseIEsLength;
} DOT11_ADDITIONAL_IE;
typedef DOT11_ADDITIONAL_IE *PDOT11_ADDITIONAL_IE;
#endif

/* 802.11 peer statistics */
#ifdef NWF_EXTAP_SUPPORTED
typedef struct _DOT11_PEER_STATISTICS {
    ULONGLONG   ullDecryptSuccessCount;
    ULONGLONG   ullDecryptFailureCount;
    ULONGLONG   ullTxPacketSuccessCount;
    ULONGLONG   ullTxPacketFailureCount;
    ULONGLONG   ullRxPacketSuccessCount;
    ULONGLONG   ullRxPacketFailureCount;
} DOT11_PEER_STATISTICS;
typedef DOT11_PEER_STATISTICS   *PDOT11_PEER_STATISTICS;
#endif

/* 802.11 peer information */
#ifdef NWF_EXTAP_SUPPORTED
typedef struct _DOT11_PEER_INFO {
    DOT11_MAC_ADDRESS       MacAddress;
    USHORT                  usCapabilityInformation;
    DOT11_AUTH_ALGORITHM    AuthAlgo;
    DOT11_CIPHER_ALGORITHM  UnicastCipherAlgo;
    DOT11_CIPHER_ALGORITHM  MulticastCipherAlgo;
    BOOLEAN                 bWpsEnabled;
    USHORT                  usListenInterval;
    UCHAR                   ucSupportedRates[MAX_NUM_SUPPORTED_RATES_V2];
    USHORT                  usAssociationID;
    DOT11_ASSOCIATION_STATE AssociationState;
    DOT11_POWER_MODE        PowerMode;
    LARGE_INTEGER           liAssociationUpTime;
    DOT11_PEER_STATISTICS   Statistics;
} DOT11_PEER_INFO;
typedef DOT11_PEER_INFO *PDOT11_PEER_INFO;
#endif

/* 802.11 peer information list */
#ifdef NWF_EXTAP_SUPPORTED
typedef struct _DOT11_PEER_INFO_LIST {
    NDIS_OBJECT_HEADER  Header;
    ULONG               uNumOfEntries;
    ULONG               uTotalNumOfEntries;
    DOT11_PEER_INFO     PeerInfo[1];
} DOT11_PEER_INFO_LIST;
typedef DOT11_PEER_INFO_LIST    *PDOT11_PEER_INFO_LIST;
#endif

/* 802.11 Virtual WiFi combination */
#ifdef NWF_VWIFI_SUPPORTED
typedef struct _DOT11_VWIFI_COMBINATION {
    NDIS_OBJECT_HEADER  Header;
    ULONG               uNumInfrastructure;
    ULONG               uNumAdhoc;
    ULONG               uNumSoftAP;
} DOT11_VWIFI_COMBINATION;
typedef DOT11_VWIFI_COMBINATION *PDOT11_VWIFI_COMBINATION;
#endif

/* 802.11 Virtual WiFi combination (version 2) */
#ifdef NWF_VWIFI_SUPPORTED
typedef struct _DOT11_VWIFI_COMBINATION_V2 {
    NDIS_OBJECT_HEADER  Header;
    ULONG               uNumInfrastructure;
    ULONG               uNumAdhoc;
    ULONG               uNumSoftAP;
    ULONG               uNumVirtualStation;
} DOT11_VWIFI_COMBINATION_V2;
typedef DOT11_VWIFI_COMBINATION_V2  *PDOT11_VWIFI_COMBINATION_V2;
#endif

/* 802.11 Virtual WiFi attributes */
#ifdef NWF_VWIFI_SUPPORTED
typedef struct _DOT11_VWIFI_ATTRIBUTES {
    NDIS_OBJECT_HEADER      Header;
    ULONG                   uTotalNumOfEntries;
    DOT11_VWIFI_COMBINATION Combinations[1];
} DOT11_VWIFI_ATTRIBUTES;
typedef DOT11_VWIFI_ATTRIBUTES  *PDOT11_VWIFI_ATTRIBUTES;
#endif

/* 802.11 MAC information */
#ifdef NWF_VWIFI_SUPPORTED
typedef struct _DOT11_MAC_INFO {
    ULONG               uReserved;
    ULONG               uNdisPortNumber;
    DOT11_MAC_ADDRESS   MacAddr;
} DOT11_MAC_INFO;
typedef DOT11_MAC_INFO  *PDOT11_MAC_INFO;
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __WINDOT11_H__ */
