; Copyright (C) 2017 Jerome Shidel
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation; either version 2 of the License, or
;   (at your option) any later version.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License along
;   with this program; if not, write to the Free Software Foundation, Inc.,
;   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

; NASM 2.14rc0 for DOS

%imacro IOBUFFER 1
    %idefine %1_BUFFER
    %idefine BUFFERED_IO
    %idefine USEZEROPDA
    %ifidni %1, STDIN
        %idefine STDIO_BUFFERS
        %idefine Need_FileBufferRead
    %endif
    %ifidni %1, STDOUT
        %idefine STDIO_BUFFERS
        %idefine Need_FileBufferWrite
        %idefine Need_FileBufferFlush
    %endif
    %ifidni %1, STDERR
        %idefine STDIO_BUFFERS
        %idefine Need_FileBufferWrite
        %idefine Need_FileBufferFlush
    %endif
    %ifidni %1, STDAUX
        %idefine STDIO_BUFFERS
        %idefine Need_FileBufferWrite
        %idefine Need_FileBufferFlush
    %endif
    %ifidni %1, STDPRT
        %idefine STDIO_BUFFERS
        %idefine Need_FileBufferWrite
        %idefine Need_FileBufferFlush
    %endif
    %ifdef STDIO_BUFFERS
        %ifndef STDIO_CHARACTER
            %idefine STDIO_CHARACTER
            .STDIOCHAR      resb 1
        %endif
    %endif
    .%1      resb 0
    .%1_HDL  resw 1
    .%1_PTR  resw 1
    .%1_CNT  resw 1
    .%1_BUF  resb SIZEOF_IOBUF
%endmacro

struc tIOBUFFER
    .HDL  resw 1
    .PTR  resw 1
    .CNT  resw 1
    .BUF  resb SIZEOF_IOBUF
endstruc

%imacro HEAP_DATA 0
    %idefine USEZEROPDA
    %ifdef SIZEOF_MEMORY
        .HEAPBEGIN  resw 1
        .HEAPPTR    resw 1
        .HEAPEND    resw 1
    %endif
%endmacro

%imacro STACK_DATA 0
    %ifdef SIZEOF_STACK
        .STACK          resb SIZEOF_STACK
    %endif
%endmacro
