; Copyright (C) 2017 Jerome Shidel
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation; either version 2 of the License, or
;   (at your option) any later version.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License along
;   with this program; if not, write to the Free Software Foundation, Inc.,
;   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

; NASM 2.14rc0 for DOS

; -----------------------------------------------------------------------------
; FORWARD
; -----------------------------------------------------------------------------

%ifidni CODE_STAGE, BLOCK_FORWARD

%imacro idle 0
        hlt
%endmacro

%imacro retz 0
        jnz     %%Skip
        ret
    %%Skip:
%endmacro

%imacro retnz 0
        jz      %%Skip
        ret
    %%Skip:
%endmacro

%imacro retc 0
        jnc     %%Skip
        ret
    %%Skip:
%endmacro

%imacro retnc 0
        jc      %%Skip
        ret
    %%Skip:
%endmacro

%imacro rete 0
        jne     %%Skip
        ret
    %%Skip:
%endmacro

%imacro retne 0
        je      %%Skip
        ret
    %%Skip:
%endmacro

%imacro pusha   0
    push        ax
    push        cx
    push        dx
    push        bx
    ; push        sp
    push        bp
    push        si
    push        di
%endmacro

%imacro popa    0
    pop         di
    pop         si
    pop         bp
    ; pop         sp
    pop         bx
    pop         dx
    pop         cx
    pop         ax
%endmacro

%imacro pushas 0
    push        ds
    push        es
    ; fs, gs
%endmacro

%imacro popas 0
    pop         es
    pop         ds
%endmacro

%imacro mpush 0-*
    %ifidni %0, 0
        pusha
    %elifidni %1, all
        pusha
    %else
        %rep  %0
            push    %1
        %rotate 1
        %endrep
    %endif
%endmacro

%imacro mpop 0-*
    %ifidni %0, 0
        popa
    %elifidni %1, all
        popa
    %else
        %rep %0
        %rotate -1
            pop     %1
        %endrep
    %endif
%endmacro

%imacro DefineRegisterType 1
    %undef RegisterType8Bit
    %undef RegisterType16Bit
    %undef RegisterType32Bit
    %undef RegisterType64Bit
    %undef RegisterTypeGeneral
    %undef RegisterTypeOffset
    %undef RegisterTypeSegment

    %idefine RegisterTypeUnknown

    %ifidni %1, al
        %define RegisterType8Bit
        %idefine RegisterTypeGeneral
    %elifidni %1, bl
        %define RegisterType8Bit
        %idefine RegisterTypeGeneral
    %elifidni %1, cl
        %define RegisterType8Bit
        %idefine RegisterTypeGeneral
    %elifidni %1, dl
        %define RegisterType8Bit
        %idefine RegisterTypeGeneral
    %elifidni %1, ah
        %define RegisterType8Bit
        %idefine RegisterTypeGeneral
    %elifidni %1, bh
        %define RegisterType8Bit
        %idefine RegisterTypeGeneral
    %elifidni %1, ch
        %define RegisterType8Bit
        %idefine RegisterTypeGeneral
    %elifidni %1, dh
        %define RegisterType8Bit
        %idefine RegisterTypeGeneral

    %elifidni %1, ax
        %define RegisterType16Bit
        %define RegisterTypeGeneral
    %elifidni %1, bx
        %define RegisterType16Bit
        %define RegisterTypeGeneral
    %elifidni %1, cx
        %define RegisterType16Bit
        %define RegisterTypeGeneral
    %elifidni %1, dx
        %define RegisterType16Bit
        %define RegisterTypeGeneral

    %elifidni %1, si
        %define RegisterType16Bit
        %define RegisterTypeOffset
    %elifidni %1, di
        %define RegisterType16Bit
        %define RegisterTypeOffset
    %elifidni %1, bp
        %define RegisterType16Bit
        %define RegisterTypeOffset
    %elifidni %1, sp
        %define RegisterType16Bit
        %define RegisterTypeOffset
    %elifidni %1, ip
        %define RegisterType16Bit
        %define RegisterTypeOffset

    %elifidni %1, es
        %define RegisterType16Bit
        %define RegisterTypeSegment
    %elifidni %1, ds
        %define RegisterType16Bit
        %define RegisterTypeSegment
    %elifidni %1, ss
        %define RegisterType16Bit
        %define RegisterTypeSegment
    %elifidni %1, cs
        %define RegisterType16Bit
        %define RegisterTypeSegment
    %elifidni %1, fs
        %define RegisterType16Bit
        %define RegisterTypeSegment
    %elifidni %1, gs
        %define RegisterType16Bit
        %define RegisterTypeSegment
    %elifidni %1, gs
        %define RegisterType16Bit
        %define RegisterTypeSegment

    %elifidni %1, eax
        %define RegisterType32Bit
        %define RegisterTypeGeneral
    %elifidni %1, ebx
        %define RegisterType32Bit
        %define RegisterTypeGeneral
    %elifidni %1, ecx
        %define RegisterType32Bit
        %define RegisterTypeGeneral
    %elifidni %1, edx
        %define RegisterType32Bit
        %define RegisterTypeGeneral

    %elifidni %1, esi
        %define RegisterType32Bit
        %define RegisterTypeOffset
    %elifidni %1, edi
        %define RegisterType32Bit
        %define RegisterTypeOffset
    %elifidni %1, ebp
        %define RegisterType32Bit
        %define RegisterTypeOffset
    %elifidni %1, esp
        %define RegisterType32Bit
        %define RegisterTypeOffset
    %elifidni %1, eip
        %define RegisterType32Bit
        %define RegisterTypeOffset

    %elifidni %1, rax
        %define RegisterType64Bit
        %define RegisterTypeGeneral
    %elifidni %1, rbx
        %define RegisterType64Bit
        %define RegisterTypeGeneral
    %elifidni %1, rcx
        %define RegisterType64Bit
        %define RegisterTypeGeneral
    %elifidni %1, rdx
        %define RegisterType64Bit
        %define RegisterTypeGeneral

    %elifidni %1, rsi
        %define RegisterType64Bit
        %define RegisterTypeOffset
    %elifidni %1, rdi
        %define RegisterType64Bit
        %define RegisterTypeOffset
    %elifidni %1, rbp
        %define RegisterType64Bit
        %define RegisterTypeOffset
    %elifidni %1, rsp
        %define RegisterType64Bit
        %define RegisterTypeOffset

    ; I'm stopping there. I'm not doing R8-15 or FPU registers.
    %endif

    ; Clear the unknown
    %ifdef RegisterType8Bit
        %undef RegisterTypeUnknown
    %endif
    %ifdef RegisterType16Bit
        %undef RegisterTypeUnknown
    %endif
    %ifdef RegisterType32Bit
        %undef RegisterTypeUnknown
    %endif
    %ifdef RegisterType64Bit
        %undef RegisterTypeUnknown
    %endif
    %ifdef RegisterTypeGeneral
        %undef RegisterTypeUnknown
    %endif
    %ifdef RegisterTypeOffset
        %undef RegisterTypeUnknown
    %endif
    %ifdef RegisterTypeSegment
        %undef RegisterTypeUnknown
    %endif

%endmacro

%imacro forward 1-*

    %assign params %0 - 1
    %ixdefine NeedProc_%1
    %ixdefine ProcUses_%1 params

    ; %warning Forward %1, Has params
    %rotate 1
    %rep %0 - 1
        DefineRegisterType %1
        %ifdef RegisterTypeUnknown
            %idefine Need_ForwardHolding
            mov     [Data_ForwardHolding], ax
            mov     ax, %1
            push    ax
            ; %warning MOV AX, %1 & PUSH ax
            mov     ax, [Data_ForwardHolding]
        %else
            %warning PUSH %1
            push    %1
        %endif
    %rotate 1
    %endrep

    %ifidni CALL_MODEL, NEAR
        ; %warning Near Call %1
        call near Near_Procedure_%1
    %elifidni CALL_MODEL, FAR
        %idefine NeedFarProc_%1
        ; %warning Far Call %1
        call far  Far_Procedure_%1
    %else
        %fatal Unsupported procedure call model
    %endif

%endmacro


%imacro procedure 1
    Near_Procedure_%1:
        push    bp
        mov     bp, sp

    %idefine Procedure_Name %1
%endmacro

%imacro Registers 1-*
    %idefine ProcCount ProcUses_ %+ Procedure_Name
    %if ProcCount <> %0
        %fatal %1 forward parameter count (ProcUses_%1,params) mismatch
    %endif
    %assign ofs 4
    %rep ProcCount
        %rotate -1
        ; %warning load %1, [bp + ofs]
        mov     %1, [bp + ofs]
        %assign ofs ofs + 2
    %endrep
    %undef ProcCount
%endmacro

%imacro endproc 1
    %idefine ProcName %1
    %assign index 0
    %rep ProcUses_%1
            ; ProcGetRegister ProcName index
            ; %warning ProcRegData
            %assign index index + 1
    %endrep

    pop bp
    ret ProcUses_%1

    %ifdef NeedFarProc_%1
        %fatal Procedure Far Calls not yet supported.
    global _%1:
;    Far_Procedure_%1:
;        %warning Add far call for %1
;        call    Near_Procedure_%1
;        retf
    %endif

    %undef ProcUses_%1

;    %warning End %1

%endmacro

%endif

; -----------------------------------------------------------------------------
; Begin uninitialized data section
; -----------------------------------------------------------------------------

%ifidni CODE_STAGE, BLOCK_BSS

%ifdef Need_ForwardHolding
    ; %warning Appended Forward Procedure Call Data
    Data_ForwardHolding:
        dw 0
%endif

%endif