; Copyright (C) 2018 Jerome Shidel
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation; either version 2 of the License, or
;   (at your option) any later version.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License along
;   with this program; if not, write to the Free Software Foundation, Inc.,
;   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

; NASM 2.14rc0 for DOS

; Since DOS has the most limited RAM and executable size, all macro functions
; assume the DOS registers are destroyed and others are preserved. For non-DOS
; operating systems, insure this is the case using push/pop.

; -----------------------------------------------------------------------------
; FORWARD
; -----------------------------------------------------------------------------

%ifidni CODE_STAGE, BLOCK_FORWARD

%idefine PathDelim '\'

; DOS Program Prefix Segment Offset Definitions

; byte, CP/M exit INT 20h
%idefine PSP_INT20      0x00

; word, Segment of the first byte beyond the program
%idefine PSP_MEMTOP     0x02

; 5 bytes, Far call to DOS Function Dispatcher
%idefine PSP_DOSCALL    0x05

; dword, Terminate address for parent program
%idefine PSP_TERMINATE  0x0A

; dword, Control-Break address for parent program
%idefine PSP_BREAK      0x0E

; dword, Critical error address for parent program
%idefine PSP_ERROR      0x12

; word, Parent program PSP Segment
%idefine PSP_PARENT     0x16

; word, Environment Segment
%idefine PSP_ENV        0x2c

; byte, Number of bytes in command line
%idefine PSP_CMDLEN     0x80

; command line, ends in 0x0d
%idefine PSP_CMDLN      0x81

; Generic DOS Function Calls

%imacro OS_CommandLine 0-1 si
    mov         %1, PSP_CMDLN
%endmacro

%imacro OS_SwitchChar 0-1 al
    mov         %1, '/'
%endmacro

%imacro OS_PathDelim 0-1 al
    mov         %1, PathDelim
%endmacro

; Destroys AX
%imacro OS_StdInEcho 0
    mov         ah, 0x01
    int         0x21
    ; al = keystroke, if Ctrl+C is detected, int 0x23 is called.
%endmacro

; Destroys AX, DX
%imacro OS_StdOut 1
    mov         ah, 0x02
    %ifnidni 1, dl
        mov     dl, %1      ; Output Character
    %endif
    int         0x21
    ; if Ctrl+C is detected, int 0x23 is called.
%endmacro

; Destroys AX
%imacro OS_StdIn 0
    TEST_BUG_DOSBOX_21_0B
    %ifdef BUG_DOSBOX_21_0B
        call        PATCH_BUG_DOSBOX_21_0B
    %else
        mov         ah, 0x08
        int         0x21
        clc
    ; CLC, al = keystroke, if Ctrl+C is detected, int 0x23 is called.
    ; STC if error occurred, DOSBOX bug workaround
    %endif
%endmacro

%imacro OS_StdInStatus 0
    mov         ah, 0x0b
    int         0x21    ; al = 0x00, no chars avail. al = 0xff, chars avail
%endmacro

; Destroys AX, BX, CX, DX
%imacro OS_FileRead 3
    %ifnidni 1, bx
        mov         bx, %1              ; File Handle
    %endif
    %ifnidni 2, dx
        mov         dx, %2              ; DS:DX Read Buffer Pointer
    %endif
    %ifnidni 3, cx
        mov         cx, %3              ; Bytes to Read
    %endif
    mov         ah, 0x3f
    int         0x21
    ; CLC, AX=Bytes read. STC, AX=Error code.
%endmacro

; Destroys AX, BX, CX, DX
%imacro OS_FileWrite 3
    %ifnidni 1, bx
        mov         bx, %1              ; File Handle
    %endif
    %ifnidni 2, dx
        mov         dx, %2              ; DS:DX Read Buffer Pointer
    %endif
    %ifnidni 3, cx
        mov         cx, %3              ; Bytes to Read
    %endif
    mov         ah, 0x40
    int         0x21
    ; CLC, AX=Bytes written. STC, AX=Error code.
%endmacro

; Destroys AX, BX, CX
%imacro OS_ResizeMCB 2
    push        es
    mov         ax, %1              ; Segment of Memory for MCB, probably CS
    push        ax
    pop         es
    mov         ax, %2              ; New Size in Bytes
    mov         cl, 4
    shr         ax, cl              ; Convert to full 16-byte Paragraphs
    inc         ax                  ; Add 1 just in case, probably not even
    mov         bx, ax
    mov         ah, 0x4a
    int         0x21
    pop         es
    mov         ah, 0x4a
    int         0x21
    ; CLC, Successful
    ; STC and AX=8, BX is paragraphs available
%endmacro

; Destroys Program
%imacro OS_Terminate 0-1 0x00

    %idefine REQUIRE_OS_Terminate_AL

    %ifidni %1, al
        jmp             FUNCTION_OS_Terminate_AL
    %elifnum %1, 0
        %idefine REQUIRE_OS_Terminate_NoError
        jmp             FUNCTION_OS_Terminate_NoError
    %else
        mov             al, %1          ; DOS exit code
        jmp             FUNCTION_OS_Terminate_AL
    %endif

%endmacro

; Parameter 1 In Address or String
; Found CLC and ES:SI -> AsciiZ String
; Not found STC and ES:SI undefined
%imacro OS_FindEnvVar 1
    %idefine REQUIRE_OS_FindEnvVar

    %ifnidni %1, di
        push        di
    %endif

    %ifstr %1
            jmp     %%Search
        %%Data:
            db      %1,0
        %%Search:
            mov     di, %%Data
    %elifnidni %1, di
            mov     di, %1
    %endif

    call FUNCTION_OS_FindEnvVar

    %ifnidni %1, di
        pop        di
    %endif

%endmacro

%endif

; -----------------------------------------------------------------------------
; CODE - Forward macro support code
; -----------------------------------------------------------------------------

%ifidni CODE_STAGE, BLOCK_CODE

%ifdef REQUIRE_OS_FindEnvVar

FUNCTION_OS_FindEnvVar:
    mpush       ax, bx, di
    mov         es, [PSP_ENV]
    mov         si, 0x0000
    mov         bx, di
.Compare:
    mov         di, bx
.CompareLoop:
    mov         ah, [di]
    inc         di
    cmp         ah, 0x00
    je          .Maybe
    es          lodsb
    cmp         al, 0x00
    je          .NotFound
    cmp         al, ah
    je          .CompareLoop
.Mismatch:
    cmp         al, 0x00
    je          .Compare
    es          lodsb
    jmp         .Mismatch
.Maybe:
    es          lodsb
    cmp         al, 0x00
    je          .NotFound
    cmp         al, '='
    jne         .Mismatch
.Found:
    clc
    jmp         .Done
.NotFound:
    stc
.Done:
    mpop        ax, bx, di
    ret

%endif

%ifdef REQUIRE_OS_Terminate_NoError

FUNCTION_OS_Terminate_NoError:
    xor         al, al
%endif

%ifdef REQUIRE_OS_Terminate_AL

FUNCTION_OS_Terminate_AL:
    mov         ah, 0x4c
    int         0x21
%endif

%endif

; -----------------------------------------------------------------------------
; String and general resource area for built in macros
; -----------------------------------------------------------------------------

%ifidni CODE_STAGE, BLOCK_RESOURCES

%endif

; -----------------------------------------------------------------------------
; Miscellaneous data area for built in macros
; -----------------------------------------------------------------------------

%ifidni CODE_STAGE, BLOCK_DATA

%endif

; -----------------------------------------------------------------------------
; Begin uninitialized data section
; -----------------------------------------------------------------------------

%ifidni CODE_STAGE, BLOCK_BSS

%endif


