; Copyright (C) 2018 Jerome Shidel
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation; either version 2 of the License, or
;   (at your option) any later version.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License along
;   with this program; if not, write to the Free Software Foundation, Inc.,
;   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

; NASM 2.14rc0 for DOS

; -----------------------------------------------------------------------------
; FORWARD
; -----------------------------------------------------------------------------

%ifidni CODE_STAGE, BLOCK_FORWARD

; Terminate Program
%imacro Terminate 0-1 0x00
    StdOutFlush
    OS_Terminate %1
%endmacro

%imacro FindEnvVar 1
    OS_FindEnvVar %1
%endmacro

%imacro ByteToHex 0-1 al
    %idefine REQUIRE_ByteToHex
    %ifnidni %1, al
        mov     al, %1
    %endif
    call FUNCTION_ByteToHex
%endmacro

%imacro GetLangFilename 2
    jmp     %%Start
%%ProgramName:
    db      PathDelim,%1,'.',0
%%Start:
    mpush   es, si, di
    mov     di, %2
    FindEnvVar 'NLSPATH'
    jc      %%Done
    CopyAsciiZ
    mov     si, %%ProgramName
    push    ds
    pop     es
    CopyAsciiZ
    FindEnvVar 'LANG'
    jc      %%Done
    CopyAsciiZ
    clc
%%Done:
    mpop    es, si, di

%endmacro

%endif

; -----------------------------------------------------------------------------
; CODE - Forward macro support code
; -----------------------------------------------------------------------------

%ifidni CODE_STAGE, BLOCK_CODE

%ifdef REQUIRE_ByteToHex
FUNCTION_ByteToHex:
    push        cx
    mov         ch, al
    and         al, 0x0f
    add         al, 0x30
    cmp         al, 0x39
    jna         .NumberA
    add         al, 0x27
.NumberA:
    xchg        al, ch
    mov         cl, 0x04
    shr         al, cl
    and         al, 0x0f
    add         al, 0x30
    cmp         al, 0x39
    jna         .NumberB
    add         al, 0x27
.NumberB:
    mov         ah, al
    mov         al, ch
    pop         cx
    ret
%endif


%endif

; -----------------------------------------------------------------------------
; String and general resource area for built in macros
; -----------------------------------------------------------------------------

%ifidni CODE_STAGE, BLOCK_RESOURCES

%endif

; -----------------------------------------------------------------------------
; Miscellaneous data area for built in macros
; -----------------------------------------------------------------------------

%ifidni CODE_STAGE, BLOCK_DATA

%endif

; -----------------------------------------------------------------------------
; Begin uninitialized data section
; -----------------------------------------------------------------------------

%ifidni CODE_STAGE, BLOCK_BSS

%endif
