; EXTKBD - DOS executable and device driver to set the
;          extended keyboard flag in BDA byte 0040:0096

; This is free and unencumbered software released into the public domain.
; 
; Anyone is free to copy, modify, publish, use, compile, sell, or
; distribute this software, either in source code form or as a compiled
; binary, for any purpose, commercial or non-commercial, and by any
; means.
; 
; In jurisdictions that recognize copyright laws, the author or authors
; of this software dedicate any and all copyright interest in the
; software to the public domain. We make this dedication for the benefit
; of the public at large and to the detriment of our heirs and
; successors. We intend this dedication to be an overt act of
; relinquishment in perpetuity of all present and future rights to this
; software under copyright law.
; 
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
; EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
; MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
; IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
; OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
; ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
; OTHER DEALINGS IN THE SOFTWARE.
; 
; For more information, please refer to <https://unlicense.org/>

; device driver status flags
S_DONE		equ 0100h
S_BUSY		equ 0200h
S_ERROR		equ 8000h

ERR_UNKNOWN_CMD	equ 3

DEVHDR struct
  next		dd ?		; far ptr to next device
  attr		dw ?		; device attributes
  strat		dw ?		; near ptr to strategy routine
  intr		dw ?		; near ptr to interrupt routine
  nam		db 8 dup (?)	; device name
DEVHDR ends

RP struct
  len		db ?		; length of request packet
  unit		db ?		; unit this request is for
  cmd		db ?		; operation to be executed by device
  status	dw ?		; status of driver operation
  		db 8 dup (?)	; reserved
  nunits	db ?		; number of units found by device
  brkoff	dw ?		; offset and segment of
  brkseg	dw ?		;  last byte to allocate for device
  cfgoff	dw ?		; segment and offset of 
  cfgseg	dw ?		;  config.sys line (after =)
RP ends

CODE segment

header	DEVHDR <-1, 80h, offset dev_strat, offset dev_intr, 'EXTKBD2 '>


main proc near
	assume ds:CODE,es:nothing,ss:STACK
	xor ax,ax
	mov es,ax			; es=0
	mov al,es:[496h]		; get extended keyboard flag from BDA
	mov dx,offset ext_kbd_msg
	test al,10h
	 jnz @@ext
	mov byte ptr es:[496h],10h
	mov dx,offset std_kbd_msg
@@ext:
	mov ah,9			; print whether standard or extended
	int 21h				; keyboard is present
	ret
main endp


rp_off	dw 0
rp_seg	dw 0

dos_ss	dw 0				; store DOS stack SS
dos_sp	dw offset stktop		; exchange with DOS stack SP

dev_strat proc far
	assume ds:nothing,es:nothing,ss:nothing
	mov cs:rp_off,bx		; store request packet given by ES:BX
	mov cs:rp_seg,es
	ret
dev_strat endp


dev_intr proc far
; Via the device interrupt routine we only support the INIT function.
; INIT gets called upon driver loading. In INIT we call our main
; routine like we do when executed as ordinary .EXE file, and then
; instruct DOS to unload the driver.
	assume ds:nothing,es:nothing,ss:nothing
	pushf				; store flags and registers on
	push ax				; DOS provided stack
	push bx				; ~40 bytes are available
	push cx
	push dx
	push ds
	push es
	push si
	push di
	push bp

	push cs				; setup data segment
	pop ds
	assume ds:CODE

	mov dos_ss,ss			; save DOS stack SS
	mov ax,seg STACK		; swith to local stack SS		
	mov ss,ax
	xchg dos_sp,sp			; save DOS SP and swith to local stack
	assume ss:STACK

	mov es,rp_seg			; es:bx => request packet
	mov bx,rp_off

	mov al,es:RP.cmd[bx]		; get command code
	test al,al			; only INIT is supported
	 jz @@exec_command
	mov es:RP.status[bx],S_ERROR or ERR_UNKNOWN_CMD
	jmp @@r

@@exec_command:
	push bx				; save far ptr to request packet
	push es

	call main			; execute main routine as when .EXE
					; is run
	pop es				; restore far ptr to request packet
	pop bx

	mov es:RP.status[bx],S_DONE

@@r:
	; Modify request packet and driver header to tell DOS to unload
	; the driver. Do not reserve any memory by pointing to brk address
	; to device header, set supported units to zero, and clear character
	; flag in device header.
	mov es:RP.brkoff[bx],offset header
	mov es:RP.brkseg[bx],cs
	mov es:RP.nunits[bx],0
	mov header.attr,0

	; restore DOS stack
	mov ax,dos_ss
	mov ss,ax
	mov sp,dos_sp

	; restore all registers from DOS stack
	pop bp
	pop di
	pop si
	pop es				; restore registers from
	pop ds				; DOS provided stack
	pop dx
	pop cx
	pop bx
	pop ax
	popf
	ret
dev_intr endp


exe_entry:
	assume ds:nothing,es:nothing
	push cs
	pop ds
	assume ds:CODE

	call main
	
	mov ax,4c00h			; exit to DOS
	int 21h

ext_kbd_msg	db 'Extended keyboard flag already set.',13,10,'$'
std_kbd_msg	db 'Setting extended keyboard flag.',13,10,'$'

CODE ends

STACK segment stack 'STACK'
	db 512 dup (?)
stktop:
STACK ends

end exe_entry
