uses Dos,VenomGFX,FNfont2,wokna32,Lacrt,vaznik,disk,Konfig,Clanky,RezKlav;
{$INCLUDE defines.inc}

type
     pedob = ^edob;
     edob = object
     ed:PEditacniPole;
     ob:PVWOkno;
     ik:PTlacitko;
     Constructor Init(obrazek:boolean);
     Destructor Done;
     end;

const
    MAX_KLAVES = 200;
    ALT_SHIFT = 1;   {pro kombinaci Alt-Shift si z prstu vycucam ASCII kod 1}
    CTRL_ALT_NAHORU  = 2;
    CTRL_ALT_DOLEVA  = 3;
    CTRL_ALT_DOPRAVA = 4;
    CTRL_ALT_DOLU    = 5;

    VYSKA_HL_MENU = 21;
    B_OKRAJ       = 3;    {bocni okraj}
    H_OKRAJ       = 5;  {Kolik pixelu pod posledni radkou menu bude umisteno
                         editacni pole}

    unicode_font:string[30]='unismall.ufn';
    non_unicode_font:string[30]=FN_FONT_VGA16;
    unicode_startup:boolean = false;
    zadost_o_zavreni:boolean = false;
    zadost_o_otevreni:ansistring = '';
    mozno_sejmout_obrazovku:boolean = true;
    prefix:longint = 0;

type
     pklavesy = ^klavesy;
     klavesy = array[1..MAX_KLAVES] of record p,a,u:longint;c:boolean;end;

     Punifiltr = ^Tunifiltr;
     Tunifiltr = record
     t_velke_na_male:pointer; {tabulka pro prevod znaku na mala pismena}
     soubor,nazev:string;
     mapa:pklavesy;
     end;

var ed:PEditacniPole;
    ob:PVWOkno;
    edvaz:PVaznik;      {bude drzet objekt PEdob}
    moje_klavesnice:PVaznik;
    mimoradny_kod:byte;
    Aktualni_klavesnice:Punifiltr;
    Vyska_Soub_L:longint;
    Vyska_DL:longint;
    vb:PVybernicek;
    za_un,za_za:Zatrzitko;
    ob_zoom,ob_rp,ob_rm:Tlacitko;
    klin:TSeznam;
    ss:PStrom;
    lng:string;
    popredi,pozadi,zaklad:word;
    listovy_font:string[30];
    doplnky_desktopu:string;   { :-) }
    l_f:fn;
    hlasky:Pclanek;
    moje_utf8_tbl:utf8conv;
    malsyst:string;
    screen_width,screen_height:longint;
    seznam_filtru:Pvaznik;
    _ex,_ey,_xr,_yr:longint;


{-------------------------------------------------------------------------}
Function NastartujEditacniPole(obrazek:boolean):PEditacniPole;forward;
Procedure ZavriOkno_z_menu;forward;
Function ZavriOkno(p:PVaznik):byte;forward;
Procedure SejmiObrazovku;forward;
Function UniFiltr2string(p:pointer):string;forward;
Procedure MyEdZobrProc;forward;
Function MyEdProc(o:word):word;forward;
{-------------------------------------------------------------------------}

Procedure ZapniGrafiku;
begin
SetRequestedVideoAccess(LFB_ACCESS);
SetRequestedFrequency(BEST_FQ or 70);
Init_Graph(Find_Mode(screen_width,screen_height));
FN_adresar:=EXEdir+'fonty\';              {Adresar s fonty}
FN_PCX_adresar:=EXEdir;
SetLastLine(vga.hoeheminus1);
Init_Mouse('',vga);
MouseShow;
end;

Procedure VykresliPozadiProgramu;
begin
MouseHide;
ClrPacked(vga,zaklad);
FN_ignore:=true;
print_fn(0,0,doplnky_desktopu,fn_vga16);
MouseShow;
end;

Function UrcenyFont(s:string):string;
begin
s:=Convert_Up(s);
if s='<VGA16>' then s:=FN_FONT_VGA16 else
if s='<VGA16U>' then s:=FN_FONT_VGA16_U else
if s='<VGA14>' then s:=FN_FONT_VGA14 else
if s='<VGA8>' then s:=FN_FONT_VGA8;
UrcenyFont:=s;
end;

Function PrekladFontu(s:string):string;
begin
if s=FN_FONT_VGA16 then s:='<vga16>' else
if s=FN_FONT_VGA16_U then s:='<vga16u>' else
if s=FN_FONT_VGA14 then s:='<vga14>' else
if s=FN_FONT_VGA8 then s:='<vga8>';
PrekladFontu:=s;
end;

Procedure ZavedSystemovyFont;
var a:byte;
begin
a:=Nacti_FNSLR(listovy_font);
l_f:=fn_selector^[a].font;
print_fn(0,0,hlla('sys_font'),fn_vga16);
malsyst:=hlla('sys_font_maly');
FN_syst_font:=FN_default;
NastavFont(FN_default);
end;

Function xReadKey_obsluha(b:byte):word;
{Presmerovava na sebe cele xReadKey}
var w:word;
    s:string;
begin
if mimoradny_kod<>0 then Exit(mimoradny_kod);
Asm
   mov AX,$0700 {cislo sluzby pro cteni klaves}
   int $21      {precteni klavesy - normalni Readkey}
   or AL,AL      {neco udelame s AL, ve kterem se vratil ten znak (tak, abychom ho nezmenili), tim se nastavi ZF}
   jnz @vratznak {takze kdyz to AL neni 0, skocime dal >> }
   int $21        {jestli jsme jeste tady, tak v AL byla 0, takze precteme dalsi znak (v AX porad jeste je $07)}
   mov AH,1       {do AH ulozime 1, aby bylo poznat, ze to byla specialni klavesa}
   jmp @konec     {a mame hotovo.}
   @vratznak:
   xor AH,AH     { >> vynulujeme AH, precteny znak zustane v AL a je vymalovano.}
   @konec:
   mov w,ax
end;
if (w=xAltF2) and mozno_sejmout_obrazovku then
   begin
   s:=FN_default;
   FN_default:=FN_syst_font;
   SejmiObrazovku;
   FN_default:=s;
   end;
xReadKey_obsluha:=w;
end;

function xKeyPressed_obsluha_AltShift(b:byte):boolean;
begin
mimoradny_kod:=0;
xKeyPressed_obsluha_AltShift:=true;
if (vsechny_klavesy[KEY_ALT] and vsechny_klavesy[KEY_SHIFT]) then
   mimoradny_kod:=ALT_SHIFT else

if (vsechny_klavesy[KEY_CTRL] and vsechny_klavesy[KEY_ALT] and vsechny_klavesy[KEY_G_CURSOR_UP]) then
   mimoradny_kod:=CTRL_ALT_NAHORU else

if (vsechny_klavesy[KEY_CTRL] and vsechny_klavesy[KEY_ALT] and vsechny_klavesy[KEY_G_CURSOR_LEFT]) then
   mimoradny_kod:=CTRL_ALT_DOLEVA else

if (vsechny_klavesy[KEY_CTRL] and vsechny_klavesy[KEY_ALT] and vsechny_klavesy[KEY_G_CURSOR_RIGHT]) then
   mimoradny_kod:=CTRL_ALT_DOPRAVA else

if (vsechny_klavesy[KEY_CTRL] and vsechny_klavesy[KEY_ALT] and vsechny_klavesy[KEY_G_CURSOR_DOWN]) then
   mimoradny_kod:=CTRL_ALT_DOLU else

xKeyPressed_obsluha_AltShift:=LKeyPressed;
end;

Procedure NahrajPrevodniTabulku(q:pUniFiltr;s:string);
{Definice prevodni tabulky vypada takto:}
{[   ]}
{proste vzdy dvojice pismen: velka forma a za nim mala}
var a,b:byte;
    c,d:char;
begin
if q^.t_velke_na_male=@DOS_velke_na_male then
   begin
   GetMem(q^.t_velke_na_male,256);
   Move(DOS_male_na_velke,q^.t_velke_na_male,256);
   end;
s:=SkipAllSpaces(s);
b:=Length(s);
a:=2;
repeat
c:=s[a];
d:=s[a+1];
if (c=']') or (d=']') then Break;
q^.t_velke_na_male^[byte(c)]:=d;
inc(a,2);
until a>b;
end;

Procedure ZpracujMapyKlavesnic(var p:pointer);
var q:PUniFiltr;
    v:PKlavesy;
    uni,s:string;
    utf:utf8conv;
    t:text;
    kf:TKonfig;
    pp:PVaznik;
    vv:PKFpolozka;
    a,i,b:longint;
    caps:boolean;
begin
q:=p;
New(v);
q^.mapa:=v;
caps:=false;
kf.init;
kf.NactiKonfiguraci(EXEdir+'key_tbl\'+q^.soubor);
pp:=kf.cfg^.dalsi^.dalsi;
vv:=pp^.vazba;
uni:=vv^.k^;         {defaultni mapovani unicode znaku}
NahrajUTF8tabulku(EXEdir+'key_tbl\'+uni,utf);
q^.t_velke_na_male:=@DOS_velke_na_male;
i:=0;
pp:=pp^.dalsi;
while pp<>nil do
   begin
   vv:=pp^.vazba;

   if vv^.z=nil then  {toto neni radek s ROVNA SE}
      begin
      s:=vv^.k^;
      if s[1]='-' then caps:=false else
      if s[1]='+' then caps:=true else
      if s[1]='[' then NahrajPrevodniTabulku(q,s);
      end
   else begin
   inc(i);
   v^[i].p:=MyVal(vv^.z^);
   v^[i].c:=caps;        {je tato klavesa ovlivnitelna CapsLockem?}
   a:=Pos('(',vv^.c^);   {je explicitne definovan unicode znak?}
   if a=0 then
      begin         {ne}
      v^[i].a:=MyVal(vv^.c^);               {priradim ASCII hodnotu}
      v^[i].u:=PrelozZnak(v^[i].a,utf);    {a z TBL souboru vytahnu UTF ekvivalent}
      end
      else begin    {ano}
      s:=s;
      v^[i].a:=MyVal(Copy(vv^.c^,1,a-1));   {to pred zavorkou je ASCII hodnota}
      b:=Pos(')',vv^.c^);
      v^[i].u:=MyVal(Mid(vv^.c^,a+1,b-1));    {a to v zavorce je UTF}
      end;
   end;
   pp:=pp^.dalsi;
   end;
kf.Done;
end;

Procedure NactiDuleziteSoubory(co:string;var kam:Pvaznik);
var p:Pvaznik;
    u:UkNaTSoubor;
    v:Punifiltr;
    t:text;
    s,m:string;
begin
m:=StripPath(co);
SeznamSouboru(kam,co);
p:=kam^.dalsi;
while p<>nil do
   begin
   u:=p^.vazba;
   New(v);
   v^.soubor:=u^.jmeno^+'.'+u^.koncovka^;
   Assign(t,m+v^.soubor);
   Reset(t);
   readln(t,s);
   Close(t);
   v^.nazev:=s;
   Smaz_S(u);
   p^.vazba:=v;
   p:=p^.dalsi;
   end;
end;


Procedure NactiFiltry;
begin
NactiDuleziteSoubory(EXEdir+'key_tbl\*.tbl',seznam_filtru);
end;

Procedure NactiMapyKlavesnic;
var p:PVaznik;
    v:Punifiltr;
begin
NactiDuleziteSoubory(EXEdir+'key_tbl\*.ktb',moje_klavesnice);
new(v);
v^.soubor:='';
v^.nazev:='<FONT=latin216.ch>DOS<SF>';
v^.t_velke_na_male:=@DOS_velke_na_male;
p:=New(Pvaznik,Init(nil,nil));
p^.vazba:=v;
moje_klavesnice^.Insert(p);
moje_klavesnice^.dalsi^.For_Each(@ZpracujMapyKlavesnic);
end;

Procedure NactiKonfiguraci;
var kf:TKonfig;
    s:string;
{}  Function Zjisti_soubor_s_hlaskami(promenna:string;sufix:char):string;
{}  var nlspath,lang:string;
{}  begin
{}  nlspath:=GetEnv('NLSPATH');
{}  if nlspath<>'' then
{}     if nlspath[Length(nlspath)]<>'\' then nlspath:=nlspath+'\';
{}  lang:=GetEnv('LANG');
{}  if (nlspath<>'') and (lang<>'') then
{}     begin
{}        lng:=nlspath+EXEname+sufix+'.'+lang;
{}           if not ExistFile(lng) then lng:=EXEdir+kf.NactiPolozku(promenna,'');
{}           end else lng:=EXEdir+kf.NactiPolozku(promenna,'');
{}
{}  if not ExistFile(lng) then
{}     begin writeln('Chyb soubor ',lng,' !');Halt(2);end;
{}  Zjisti_soubor_s_hlaskami:=lng;
{}  end;
begin
if not ExistFile(EXEdir+'blocek.cfg') then
   begin writeln('Chyb soubor '+EXEdir+'BLOCEK.CFG !');Halt(2);end;
kf.init;
kf.NactiKonfiguraci(EXEdir+'blocek.cfg');
screen_width:=MyVal(kf.NactiPolozku('screen_width',''));
screen_height:=MyVal(kf.NactiPolozku('screen_height',''));
popredi:=MyVal(kf.NactiPolozku('popredi',''));
pozadi:=MyVal(kf.NactiPolozku('pozadi',''));
zaklad:=MyVal(kf.NactiPolozku('zaklad',''));
doplnky_desktopu:=kf.NactiPolozku('doplnky_desktopu',' ');
listovy_font:=UrcenyFont(kf.NactiPolozku('listovy_font',''));
s:=kf.NactiPolozku('non_unicode_font',' ');
if s<>' ' then non_unicode_font:=UrcenyFont(s);
s:=kf.NactiPolozku('unicode_font',' ');
if s<>' ' then unicode_font:=UrcenyFont(s);
s:=kf.NactiPolozku('keyboard_mapping','');
s:=EXEdir+'key_tbl\'+s;
NahrajUtf8Tabulku(s,moje_utf8_tbl);
{nacte vsechny texty pouzite v programu}
NactiHlasky_ze_souboru(Zjisti_soubor_s_hlaskami('texty1','1')); {wokna32}
Nacti_Data(hlasky,Zjisti_soubor_s_hlaskami('texty2','2'));      {blocek}
vaznik_s_hlaskami:=hlasky;
NactiFiltry;
NactiMapyKlavesnic;
Aktualni_klavesnice:=moje_klavesnice^.dalsi^.vazba;
kf.Done;
end;

Procedure DefiniceMenu;
begin
ss:=StromDef(
       {v1}Vetev(VytvorPolozku(hlla('m1'),'',1,true),
                 (
                   UzelS(VytvorPolozku(hlla('m11'),'',11,true),
                   UzelS(VytvorPolozku(hlla('m12'),'',12,true),
                   UzelS(VytvorPolozku(hlla('m13'),'',13,true),
                   UzelS(VytvorPolozku(hlla('m16'),'',16,true),
                   UzelS(VytvorPolozku(hlla('m14'),'',14,true),
                   UzelS(VytvorPolozku(hlla('m15'),'',15,true),nil))))))
                 ),
       {s1}  SvazejS(
       {v2}Vetev(VytvorPolozku(hlla('m4'),'',4,true),
                 (
                   UzelS(VytvorPolozku(hlla('m41'),'',41,true),
                   UzelS(VytvorPolozku(hlla('m42'),'',42,true),nil))
                 ),
       {s2}  SvazejS(
       {v3}Vetev(VytvorPolozku(hlla('m2'),'',2,true),
                 (
                   UzelS(VytvorPolozku(hlla('m21'),'',21,true),
                   UzelS(VytvorPolozku(hlla('m22'),'',22,true),
                   UzelS(VytvorPolozku(hlla('m23'),'',23,true),
                   UzelS(VytvorPolozku(hlla('m24'),'',24,true),
                   UzelS(VytvorPolozku(hlla('m25'),'',25,true),nil)))))
                 ),
       {s3}  SvazejS(
           Vetev(VytvorPolozku(hlla('m3'),'',3,true),
                 (
                   UzelS(VytvorPolozku(hlla('m31'),'',31,true),
                   UzelS(VytvorPolozku(hlla('m32'),'',32,true),nil))
                 ),nil
           )
      {/s3})
      {/v3})
      {/s2})
      {/v2})
      {/s1})
      {/v1})
 {stromdef});
vb:=New(PVybernicek,Init(0,0,vbVEDLESEBE+vbZOBRAZ+vbROZTAHNI,ss));

{jeste sem umistim indikator klavesnice}
klin.init(vga.breite-130,1,128,450,moje_klavesnice,moje_klavesnice^.dalsi,@UniFiltr2string);
end;

Procedure IndikatorKlavesnice;
begin
klin.zobraz;
end;

Procedure SpocitejZachytneBody;
begin
_ex:=B_OKRAJ;
_ey:=VYSKA_HL_MENU+Vyska_DL+Vyska_Soub_L+H_OKRAJ;
_xr:=vga.breite-_ex-_ex;
_yr:=vga.hoehe-_ey-3;
end;

Procedure VykresliMenu;
begin
NastavFont(FN_syst_font);
Bar(vga,0,0,vga.breiteminus1,VYSKA_HL_MENU-1,vga2word(7));
vb^.Zobraz;
vb^.dosah_kontroly:=vga.breite-400;
IndikatorKlavesnice;
end;

Procedure NakresliZatrzitko;
var os:string;
begin
if ed=nil then za_un.hodnota:=false else za_un.hodnota:=ed^.unicode;
if ed<>nil then za_za.hodnota:=ed^.zalamuj;
os:=fn_default;
nastavfont(malsyst);
za_un.zobraz;
za_za.zobraz;
nastavfont(os);
end;

Procedure InfoOobrazku(y:longint);
begin
Print_FN(5,y,'<BARVA=65535>'+mystr(ob^.zdroj.breite)+'x'+mystr(ob^.zdroj.hoehe)+'<SB>',fn_vga14);
ob_zoom.zobraz;
ob_rp.zobraz;
ob_rm.zobraz;
end;

Procedure VykresliDolniListu;
var y,v:longint;
begin
v:=Vyska_FN(FN_VGA14);
Vyska_DL:=v+5;
y:=VYSKA_HL_MENU;
_Box(0,y,vga.breiteminus1,y+Vyska_DL-1,mlhbarva,mpdbarva,mvbarva);

if ob=nil then
   begin
   NakresliZatrzitko;
   if ed<>nil then MyEdZobrProc;
   end
   else begin
   InfoOobrazku(y+Vyska_DL-1);
   end;
end;

Procedure VytvorListu;
var p:Pvaznik;
    x,y,v,w:longint;
    s,ofn:string;
    ofb,otx,otv:word;
    e:PEdob;
begin
x:=1;
y:=VYSKA_HL_MENU+VYSKA_DL;
v:=l_f^.so+l_f^.su;
MouseHide;
_Box(0,y,vga.breiteminus1,y+v+2,mlhbarva,mpdbarva,mvbarva);
{LineHorz(vga,y-1,0,vga.breiteminus1,tpdbarva);}
p:=edvaz^.dalsi;
ofb:=FN_color;
ofn:=FN_default;
otx:=ttxtbarva;
ttxtbarva:={1030}65535;
FN_default:=listovy_font;
FN_color:=64000;
otv:=tvbarva;
while p<>nil do
   begin
   e:=p^.vazba;
   if e^.ob<>nil then
      begin
      s:=StripName(e^.ob^.info1)+StripExt(e^.ob^.info1);
      if e^.ob=ob then tvbarva:=796 else tvbarva:=53;
      e^.ik^.Init(x,y+1,s,'',90,0);
      end
      else begin
      s:=StripName(e^.ed^.info1)+StripExt(e^.ed^.info1);
      if e^.ed=ed then tvbarva:=50000 else tvbarva:=otv;
      if s<>'' then e^.ik^.Init(x,y+1,s,'',90,0) else
                    e^.ik^.Init(x,y+1,' ','',50,0);

      end;
   inc(x,e^.ik^.sirka+5);
   p:=p^.dalsi;
   end;
MouseShow;
tvbarva:=otv;
FN_color:=ofb;
FN_default:=ofn;
ttxtbarva:=otx;
Vyska_Soub_L:=v+2;
end;

Procedure VykresliPracoviste;
begin
VykresliPozadiProgramu;
VykresliMenu;
VykresliDolniListu;
VytvorListu;
end;

Procedure UkonciProgram;
begin
if (ed=nil) or anoneokno(hlla('opravdu_konec')) then
   begin
   Kill_Mouse;
   Kill_Graph;
   VypniObsluhuKlavesnice;
   Halt(0);
   end;
end;

Procedure DOS_skok;
var v:VirtualWindow;
begin
MouseHide;
Init_VW(v,vga.breite,vga.hoehe,false);
Flip_VW(vga,v);
Kill_Mouse;
VypniObsluhuKlavesnice;
Kill_Graph;
Exec(GetEnv('COMSPEC'),'');
videoprava:=false;
ZapniGrafiku;
ZapniObsluhuKlavesnice(KL_S_BIOSEM);
Mousehide;
Flip_VW(v,vga);
Kill_VW(v);
MouseShow;
end;

Procedure Napoveda;
const SIRKA = 550;
      VYSKA = 280;
var ok:okno;
     t:tlacitko;
     s:ansistring;
begin
ok.Init(vga.breitediv2-SIRKA div 2,vga.hoehediv2-VYSKA div 2,SIRKA,VYSKA,hlla('napoveda'));
t.Init(vga.breitediv2-20,ok.y+vyska-23,hlla('ok'),'',0,2);
SetBasicLine(ok.y+23);
MouseHide;
hlasky^.NajdiClanek('text_napovedy')^.Vypis(ok.x+6,ok.y+23);

MouseShow;
repeat t.kontrola;
if KeyPressed then if xReadKey=xEnter then Break;
until (t.klik<>0);
while KeyPressed do xReadKey;
ok.Zrus;
end;

Procedure NovySoubor;
begin
ed:=NastartujEditacniPole(false);
ob:=nil;
ed^.NovySoubor;
ed^.info1:='';
ed^.zobraz;
VytvorListu;
end;

Function Uz_ho_tu_mame(s:string):boolean;
var p:Pvaznik;
    v:Pedob;
begin
s:=Convert_UP(s);
p:=Edvaz^.dalsi;
while p<>nil do
   begin
   v:=p^.vazba;
   if Convert_UP(v^.ed^.info1)=s then Exit(true);
   p:=p^.dalsi;
   end;
Uz_ho_tu_mame:=false;
end;

Procedure ZalozZatrzitko;
var hv:boolean;
    os:string;
begin
hv:=hned_vykresluj;
hned_vykresluj:=false;
os:=fn_default;
nastavfont(fn_font_vga14);
za_un.init(4,VYSKA_HL_MENU,hlla('unicode'),hlla('unicode_varovani'),false);
za_za.init(140,VYSKA_HL_MENU,hlla('zalamovani'),'',false);
ob_zoom.init(100,VYSKA_HL_MENU+2,hlla('zoom'),hlla('zoom_info'),100,0);
ob_rp.init(220,VYSKA_HL_MENU+2,hlla('plus90'),hlla('plus90_info'),40,0);
ob_rm.init(280,VYSKA_HL_MENU+2,hlla('minus90'),hlla('minus90_info'),40,0);
nastavfont(os);
hned_vykresluj:=hv;
end;

Procedure VarovneOkno;
begin
OKokno(hlla('info'),hlla('tento_soubor_uz_jednou_mame'));
end;

Function ObrazovyValidator(s:string):boolean;
var f:file;
    t:string;
begin
t:=Convert_UP(StripExt(s));
if (t='.BMP') or (t='.JPG') or (t='.GIF') or (t='.PNG') or (t='.PCX') then
   begin
   ObrazovyValidator:=true;
   end else ObrazovyValidator:=false;
end;

Procedure NastartujObrazek(s:string);
var e:Pedob;
    h:PVWOkno;
    t:string;
    ex,ey,xr,yr:longint;
    data:VirtualWindow;
begin
e:=New(PEdob,Init(true));
edvaz^.InitNext(e);
t:=Convert_UP(StripExt(s));
if t='.BMP' then Nacti_BMP(s,data) else
if t='.PCX' then Nacti_PCX(s,data) else
if t='.GIF' then Nacti_GIF(s,data) else
if t='.PNG' then Nacti_PNG(s,data) else
if t='.JPG' then Nacti_JPG(s,data);

h:=New(PVWOkno,Init(_ex,_ey,_xr,_yr,data,true));
h^.info1:=s;
h^.ob_my_key_proc:=@MyEdProc;
e^.ob:=h;
ob:=h;
end;

Procedure OtevriSoubor(s:string);
var r:real;

begin
if s='' then
   s:=VyberSouborOkno(hlla('vyber_soubor'),'*.*',
      'txt|doc|1st|bmp||jpg||gif||png||pcx|',350,VSNORMAL);
if s<>'' then
   begin
   if ObrazovyValidator(s) then
      begin
      NastartujObrazek(s);
      VykreslidolniListu;
      VytvorListu;
      ob^.Zobraz;
      ed:=nil;
      Exit;
      end;
   if Uz_ho_tu_mame(s) then VarovneOkno;
   ed:=NastartujEditacniPole(false);
   ob:=nil;
   ed^.hlavni_font:=non_unicode_font;
   if not ed^.NactiSoubor(s) then Exit;
   if ed^.prac1=0 then r:=0 else r:=ed^.prac2/ed^.prac1;
   if r>0.9 then
      begin
      ed^.unicode:=true;
      ed^.hlavni_font:=unicode_font;
      ed^.NactiSoubor(s);            {znovunacteni - tentokrat v unicode}
      end;
   ed^.info1:=s;
   ed^.Zobraz;
   VykreslidolniListu;
   VytvorListu;
   end;
end;

Procedure UlozSoubor;
var t:Souborovy_Dialog;
    s:string;
begin
if ed=nil then Exit;
t.Init(hlla('jak_to_ulozit'),455,ed^.info1);
t.Zobraz;
if t.Bylo_cancel then begin t.Done;Exit;end;
s:=t.hodnota;
t.Done;
if (Convert_up(ed^.info1)<>Convert_Up(s)) and ExistFile(s) then
   if not anoneokno(hlla('soubor_existuje_prepsat')) then Exit;
ed^.UlozSoubor(s);
ed^.info1:=s;
VytvorListu;
end;

Procedure ZmenBarvuZakladu;
begin
zaklad:=VyberHiColorBarvuOkno(hlla('vyber_barvu_zakladu'),123);
VykresliPracoviste;
if ed<>nil then
   begin
   VytvorListu;
   ed^.Zobraz;
   end;
end;

Procedure VyberFont;
var s:string;
begin
s:=VyberSouborOkno(hlla('vyber_soubor'),'.\fonty\*.*','FN|CH|VGA',350,0);
if s='' then Exit;
s:=convert_up(StripName(s)+StripExt(s));
if s='VGA8X16.VGA' then non_unicode_font:=FN_FONT_VGA16 else
if s='VGA8X16U.VGA' then non_unicode_font:=FN_FONT_VGA16_U else
if s='VGA8X14.VGA' then non_unicode_font:=FN_FONT_VGA14 else
if s='VGA8X08.VGA' then non_unicode_font:=FN_FONT_VGA8 else
   non_unicode_font:=s;
if ed<>nil then ed^.ZmenFont(non_unicode_font);
end;

Procedure UlozitNastaveni;
var kf:TKonfig;
     p:PVaznik;
     v:PKFpolozka;
begin
kf.Init;
kf.NactiKonfiguraci(EXEdir+'blocek.cfg');

p:=kf.Vrat_ID_polozky('pozadi');v:=p^.vazba;
ZrusPString(v^.c);v^.c:=NaPstring(MyStr(pozadi));

p:=kf.Vrat_ID_polozky('popredi');v:=p^.vazba;
ZrusPString(v^.c);v^.c:=NaPstring(MyStr(popredi));

p:=kf.Vrat_ID_polozky('zaklad');v:=p^.vazba;
ZrusPString(v^.c);v^.c:=NaPstring(MyStr(zaklad));

p:=kf.Vrat_ID_polozky('non_unicode_font');v:=p^.vazba;
ZrusPString(v^.c);v^.c:=NaPstring(PrekladFontu(non_unicode_font));

kf.Zapis(EXEdir+'blocek.cfg');
kf.Done;
OKokno(hlla('info'),hlla('nastaveni_ulozeno'));
end;

Procedure SejmiObrazovku;
var t:Souborovy_Dialog;
    s:string;
begin
mozno_sejmout_obrazovku:=false;  {ochrana pred rekurzi}
t.Init(hlla('jak_to_ulozit'),40,'snimek.bmp');
t.Zobraz;
if t.Bylo_cancel then begin t.Done;Exit;end;
s:=t.hodnota;
t.Done;
if ExistFile(s) then
   if not anoneokno(hlla('soubor_existuje_prepsat')) then Exit;
Uloz_BMP(vga,s);
mozno_sejmout_obrazovku:=true;
end;

Procedure OtevriInfoTXT;
begin
OtevriSoubor(EXEdir+'info.txt');
end;

Function UniFiltr2string(p:pointer):string;
var v:PuniFiltr;
begin
v:=p;
UniFiltr2string:=v^.nazev;
end;

Procedure Do_UTF8;
var s,ofn:string;
    p:PVaznik;
    v,v2:PEdRadek;
    i,j,vspp:longint;
    n:Pchar;
    c,d:byte;
    utftabulka:utf8conv;
    pw:pchar;
    _pw:string[5];

begin
if ed=nil then Exit;
if ed^.unicode then
   begin
   okokno(hlla('info'),hlla('to_uz_utf8_je'));
   Exit;
   end;
p:=ListboxOkno(NA_STRED-150,NA_STRED-50,250,300,hlla('vyber_filtr'),
               seznam_filtru,@UniFiltr2string);
if p=nil then Exit;
s:=PUniFiltr(p^.vazba)^.soubor;
NahrajUTF8tabulku(EXEdir+'key_tbl\'+s,utftabulka);
ofn:=fn_default;
fn_default:=unicode_font;

if ed^.zalamuj then ed^.PospojujRadky(false);
ed^.hlavni_font:=unicode_font;
ed^.unicode:=true;

p:=ed^.radky^.dalsi;
while p<>nil do
   begin
   v:=p^.vazba;
   v2:=New(PEdRadek,Init);
   j:=0;
   i:=0;
   vspp:=v^.spp-2;
   repeat
       c:=byte(v^.p[i]);
       if c<128 then inc(j)
          else begin
          if j>0 then
             begin      {znaky pod 128 ulozim nezmeneny}
             n:=v^.p;
             inc(n,i);d:=byte(n^);n^:=#0; {musim docasne vsadit konec retezce}
             dec(n,j);                    {tady jsem mel ZAKYS JAKO SVINA}
             v2^.Vloz(n,v2^.spp);
             inc(n,j);n^:=char(d);        {a vratim do puvodniho stavu}
             end;
          {a ted zpracuju tajemny znak 128 a vyssi}
          _pw:=Word2Utf8(PrelozZnak(c,utftabulka))+#0;
          pw:=@_pw;inc(pw);
          v2^.Vloz(pw,v2^.spp);
          j:=0;
          end;
   inc(i);
   until i>vspp;
   if j>0 then
      begin
      n:=v^.p;
      inc(n,i-j);             {tady uz neni treba vsazovat konec retezce}
      v2^.Vloz(n,v2^.spp);
      end;
   p^.vazba:=v2;
   dispose(v,Done);
   p:=p^.dalsi;
   end;
fn_default:=ofn;
ed^.PridelRadky;
VykresliDolniListu;
ed^.zobraz;
end;

Procedure Z_UTF8;
var p:Pvaznik;
    v,v2:PEdRadek;
    s,ofn:string;
    c,d:byte;
    n:Pchar;
    utftabulka:utf8conv;
    w:word;
    i,j,vspp:longint;
    na_otaznik:boolean;

  Function Index_v_UTFtabulce(w:word):string;
  var kk:longint;
  begin
  if w<128 then Index_v_UTFtabulce:=char(w)+#0 else
     for kk:=128 to 255 do
         if utftabulka[kk]=w then Exit(char(kk)+#0);
  {nikdy by nemelo nastat}
  if not na_otaznik then
     Index_v_UTFtabulce:=Word2UTF8(PrelozZnak(w,utftabulka))+#0
     else Index_v_UTFtabulce:='?'+#0;
  end;

begin
if ed=nil then Exit;
if ed^.unicode=false then
   begin
   okokno(hlla('info'),hlla('neni_v_utf8'));
   Exit;
   end;
p:=ListboxOkno(NA_STRED-150,NA_STRED-50,250,300,hlla('vyber_filtr'),
               seznam_filtru,@UniFiltr2string);
if p=nil then Exit;
s:=PUniFiltr(p^.vazba)^.soubor;
NahrajUTF8tabulku(EXEdir+'key_tbl\'+s,utftabulka);
na_otaznik:=anoneokno(hlla('nezname_na_otaznik'));
ofn:=fn_default;
fn_default:=unicode_font;
if ed^.zalamuj then ed^.PospojujRadky(false);
ed^.hlavni_font:=non_unicode_font;
ed^.unicode:=false;
p:=ed^.radky^.dalsi;
while p<>nil do
   begin
   v:=p^.vazba;
   v2:=New(PEdRadek,Init);
   j:=0;
   i:=0;
   vspp:=v^.spp-2;
   repeat
   c:=byte(v^.p[i]);
   if c<128 then inc(j)
      else begin
      if j>0 then
         begin
         n:=v^.p;
         inc(n,i);d:=byte(n^);n^:=#0; {musim docasne vsadit konec retezce}
         dec(n,j);                    {tady jsem mel ZAKYS JAKO SVINA}
         v2^.Vloz(n,v2^.spp);
         inc(n,j);n^:=char(d);        {a vratim do puvodniho stavu}
         end;
      {mam pred sebou unicode znak}
      if c<224 then
         begin                                  {dvojbajtovy znak}
         if i+1>vspp then begin
            w:=63;
            end else
            begin
            w:=(c and 63) shl 6+byte(v^.p[i+1]) and 63;
            inc(i);
            end;
         end
         else begin                             {trojbajtovy znak}
         if i+2>vspp then w:=63 else
            begin
            w:=(c and 15) shl 12+byte(v^.p[i+1]) and 63 shl 6+byte(v^.p[i+2]) and 63;
            inc(i,2);
            end;
         end;

      s:=Index_v_UTFtabulce(w);
      n:=@s;inc(n);
      v2^.Vloz(n,v2^.spp);
      j:=0;
      end;
   inc(i);
   until i>vspp;
   if j>0 then
         begin
         n:=v^.p;
         inc(n,i-j);
         v2^.Vloz(n,v2^.spp);
         end;
   p^.vazba:=v2;
   Dispose(v,Done);
   p:=p^.dalsi;
   end;
fn_default:=ofn;
ed^.PridelRadky;
VykresliDolniListu;
ed^.zobraz;
end;

Procedure AktivaceMenu(i:longint);
var p,q:PStrom;
    j:longint;
begin
MouseRel;
q:=vb^.pozice^.potomek;
if i=0 then p:=vb^.Vyber else
   begin
   for j:=1 to i do q:=q^.dejdalsi;
   if q^.potomek<>nil then
      begin
      q:=q^.vem;
      vb^.UrovenZobrazeni(q);
      p:=vb^.Vyber;
      end
      else p:=q;
   end;
if p<>nil then
   begin
   j:=VybraneID(p);
   case j of
      11:NovySoubor;
      12:OtevriSoubor('');
      13:UlozSoubor;
      14:DOS_skok;
      15:UkonciProgram;
      16:ZavriOkno_z_menu;
      21:begin popredi:=VyberHicolorBarvuOkno(hlla('vyber_barvu_popredi'),0);if ed<>nil then ed^.popredi:=popredi;end;
      22:begin pozadi:=VyberHicolorBarvuOkno(hlla('vyber_barvu_pozadi'),15);if ed<>nil then ed^.ZmenBarvuPozadi(pozadi);end;
      23:ZmenBarvuZakladu;
      24:VyberFont;
      25:UlozitNastaveni;
      31:Napoveda;
      32:OtevriInfoTXT;
      41:Do_UTF8;
      42:Z_UTF8;
      end;
   end;
vb^.UrovenZobrazeni(nil);
if ed<>nil then
   begin
   ed^.stav:=_aktivni;
   ed^.xm:=-mouse.last_px;
   ed^.ym:=-mouse.last_py;
   ed^.zobraz;
   end;
end;

Procedure ZmenRozlozeniKlavesnice;
begin
Klin.RozbalSeznam;
aktualni_klavesnice:=klin.hodnota^.vazba;
if ed<>nil then
   begin
   ed^.stav:=_aktivni;
   ed^.xm:=-mouse.last_px;
   ed^.ym:=-mouse.last_py;
   end;
end;

Procedure ObrazekNaCelouObrazovku;
var v,fs:virtualwindow;
    _nx,_ny:real;
    nx,ny:longint;
    r:real;
begin
r:=vga.breite/ob^.zdroj.breite;
_ny:=ob^.zdroj.hoehe*r;
ny:=round(_ny);
if ny>vga.hoehe then
   begin
   r:=vga.hoehe/ob^.zdroj.hoehe;
   _ny:=ob^.zdroj.hoehe*r;
   ny:=round(_ny);
   end;
_nx:=ob^.zdroj.breite*r;
nx:=round(_nx);

fs:=ScaleSprite(ob^.zdroj,nx,ny);
Init_VW(v,vga.breite,vga.hoehe,false);
Mousehide;
Flip_VW(vga,v);
ClrPacked(vga,0);
PutSprite(vga,fs,vga.breitediv2-fs.breitediv2,vga.hoehediv2-fs.hoehediv2);
MouseShow;
while xKeypressed do xReadkey;
Cekej;
while xKeypressed do xReadkey;
MouseRel;
MouseHide;
Flip_VW(v,vga);
MouseShow;
Kill_VW(fs);
Kill_VW(v);
end;

Procedure RotujDoprava;
var vw:virtualwindow;
    v:PEdob;
    p:PVaznik;
begin
vw:=Rotate90p(ob^.zdroj);
p:=edvaz^.dalsi;
while p<>nil do
   begin
   v:=p^.vazba;
   if v^.ob=ob then
      begin
      Kill_VW(ob^.zdroj);
      Dispose(ob,Done);
      v^.ob:=New(PVWOkno,Init(_ex,_ey,_xr,_yr,vw,true));
      p^.vazba:=v;
      ob:=v^.ob;
      Exit;
      end;
   p:=p^.dalsi;
   end;
writeln(#7);
{Chyba, sem by se program nemel nikdy dostat.}
end;

Procedure RotujDoleva;
var vw:virtualwindow;
    v:PEdob;
    p:PVaznik;
begin
vw:=Rotate90m(ob^.zdroj);
p:=edvaz^.dalsi;
while p<>nil do
   begin
   v:=p^.vazba;
   if v^.ob=ob then
      begin
      Kill_VW(ob^.zdroj);
      Dispose(ob,Done);
      v^.ob:=New(PVWOkno,Init(_ex,_ey,_xr,_yr,vw,true));
      p^.vazba:=v;
      ob:=v^.ob;
      Exit;
      end;
   p:=p^.dalsi;
   end;
writeln(#7);
{Chyba, sem by se program nemel nikdy dostat.}
end;

Function SmazRadku:boolean;
begin
if ed=nil then Exit;
ed^.SmazRadku;
ed^.Zobraz;
end;

Function SmazZacatekRadky:boolean;
begin
if ed=nil then Exit;
ed^.SmazZacatekRadky;
ed^.Zobraz;
end;

Function SmazKonecRadky:boolean;
begin
if ed=nil then Exit;
ed^.SmazKonecRadky;
ed^.Zobraz;
end;

Function SmazSlovo:boolean;
begin
if ed=nil then Exit;
ed^.SmazSlovo;
ed^.Zobraz;
end;

Procedure Pust_a(b:boolean); {parametrem bude funkce, ktera se timto zavola}
var a:byte;
    znovu:boolean;
begin
{a:=mimoradny_kod;
repeat xKeyPressed until mimoradny_kod<>a;}
repeat
znovu:=false;
for a:=0 to 160 do
    if vsechny_klavesy[a]=true then znovu:=true;
until znovu=false;
end;

Function MyEdProc(o:word):word;
var a,a2,a3:byte;
    u,caps,zmc:boolean;
    oo:longint;
    kl,km:word;
begin
Nastavfont(fn_syst_font);
oo:=o;
o:=0;
if oo=xF10 then AktivaceMenu(0) else
if oo=xESC then UkonciProgram else
if oo=xF1 then NovySoubor else
if oo=xF2 then UlozSoubor else
if oo=xF3 then OtevriSoubor('') else
if oo=xAltF3 then zadost_o_zavreni:=true else
if oo=xAltF2 then SejmiObrazovku else
if oo=xAltF1 then zadost_o_otevreni:=EXEdir+'info.txt' else
if oo=CTRL_ALT_NAHORU then Pust_a(SmazRadku) else
if oo=CTRL_ALT_DOLEVA then Pust_a(SmazZacatekRadky) else
if oo=CTRL_ALT_DOPRAVA then Pust_a(SmazKonecRadky) else
if oo=CTRL_ALT_DOLU then Pust_a(SmazSlovo) else
if oo=ALT_SHIFT then ZmenRozlozeniKlavesnice else
if (oo=xEnter) and (ob<>nil) then ObrazekNaCelouObrazovku else
   begin
   {JE STISKNUTO COKOLIV JINEHO}
   o:=oo;
   if ed=nil then u:=false else u:=ed^.unicode;
   if aktualni_klavesnice^.soubor<>'' then
      begin
      kl:=kl_kod;
      km:=kl;

      if je_capslock then
         begin
         zmc:=true;
         if km<1000 then      {jak by tato klavesa vypadala s CapsLockem?}
            inc(km,1000) else
            dec(km,1000);
         end else zmc:=false;

      kl:=prefix+kl;
      km:=prefix+km;
      caps:=false;
      if prefix<>0 then
         prefix:=prefix;
      prefix:=0;
      a2:=0;
      a:=0;
      repeat
      inc(a);
          if aktualni_klavesnice^.mapa^[a].p=km then
             if caps then Break else a2:=a;

          if aktualni_klavesnice^.mapa^[a].p=kl then
             if zmc=false then Break  {neni zmacky CapsLock - fajn}
                else     {CapsLock je zmackly}
                if aktualni_klavesnice^.mapa^[a].c=false
                   then Break         {tato klavesa se na CapsLock neohlizi}
                   else
                   if a2=0 then    {Byla tu uz CapsLockova varianta?}
                      caps:=true      {ne? Tak od ted ji cilene hledame}
                      else begin
                      a:=a2;          {jo? A kde byla?}
                      Break;
                      end;
      until a=MAX_KLAVES;

      if a<MAX_KLAVES then
         begin
         if u then oo:=aktualni_klavesnice^.mapa^[a].u
              else oo:=aktualni_klavesnice^.mapa^[a].a;
         if oo<0 then begin o:=0;prefix:=-oo;end
                  else begin o:=oo;prefix:=0;end;
         end;
      end;
   end;
MyEdProc:=o;
end;

Function MyOsetreniKlavesnice(o:word):string;
begin
if o=0 then Exit('');
if aktualni_klavesnice^.soubor='' then
   begin      {pouzivame schema DOS}
   if o>255 then Exit('') else
   if ed^.unicode then
      Exit(Word2UTF8(PrelozZnak(o,moje_utf8_tbl))+#0) else Exit(char(o)+#0);
   end
   else begin {pouzivame svoje schema}
   if ed^.unicode then Exit(Word2UTF8(o)+#0)
                  else Exit(char(o)+#0);
   end;
end;

Procedure HlidejKlavesnici;
begin
if xKeyPressed then MyEdProc(xReadKey);
end;

Procedure MyEdZobrProc;
var x,l:longint;
    s,t:string;
    w:word;
begin
x:=vga.breite-100;
Bar(vga,x,VYSKA_HL_MENU+1,vga.breite-2,VYSKA_HL_MENU+12,mvbarva);
w:=FN_color;
FN_color:=65535;
s:=mystr(ed^.pozice.y)+':'+mystr(ed^.pozice.vx);
t:=fn_default;
NastavFont(fn_font_vga16);
l:=Sirka_FN(s,fn_vga16);

{l:=l+150;
s:=s+' -> '+mystr(kl_kod);}

Print_FN(vga.breiteminus1-l-2,VYSKA_HL_MENU+16,s,fn_vga16);
Nastavfont(t);
FN_color:=w;
end;

Procedure NapisKodZnaku(x1,y1,x2,y2:longint;s:string;z:word;f:fn;si,vy:longint);
var ofn:string;
    nx,ny:longint;
    v:virtualwindow;
begin
Init_VW(v,x2-x1+1,y2-y1+1,false);
MouseHide;
GetSprite(vga,v,x1,y1);
Rectangle(vga,x1,y1,x2,y2,14,33,7);
Bar(vga,x1+1,y1+1,x2-1,y2-1,61184);
nx:=(x2+x1) div 2 - si div 2;
ny:=y1+f^.so+2;
fn_ignore:=false;
if s='<<' then s:='<';
Print_FN(nx,ny,s,f);
Print_FN(x1+2,y2-16-2,mystr(z),fn_vga16);
Print_FN(x1+2,y2-2,dec2hex(z)+'h',fn_vga16);
fn_ignore:=true;
MouseShow;
mouserel;bufferoff;
repeat
if xKeyPressed then begin xReadkey;Break;end;
until mouse.b<>0;
repeat until mouse.b<2;
MouseHide;
PutSprite(vga,v,x1,y1);
MouseShow;
end;

Procedure MyEdPmysProc(e:PEditacniPole);
const SIRKA:byte = 65;
      VYSKA:byte = 50;

var w,c:word;
    p:pchar;
    v:PEdRadek;
    x,i,si,vy,mx,my:longint;
    s:string;
    f:fn;
begin
v:=pedradek(e^.pozice.r^.vazba);
p:=v^.p;
x:=e^.pozice.x;
if e^.unicode=false then
   begin
   w:=byte(p[x-1]);
   s:=p[x-1];
   end
   else begin
   c:=byte(p[x-1]);
   s:=p[x-1];
   if c<128 then w:=c else
   if c<224 then
         begin                                  {dvojbajtovy znak}
         if x>v^.spp then begin
            w:=63;
            end else
            begin
            w:=(c and 63) shl 6+byte(p[x]) and 63;
            s:=p[x-1]+p[x];
            end;
         end
         else begin                             {trojbajtovy znak}
         if x+1>v^.spp then w:=63 else
            begin
            w:=(c and 15) shl 12+byte(p[x]) and 63 shl 6+byte(p[x+1]) and 63;
            s:=p[x-1]+p[x]+p[x+1];
            end;
         end;
   end;
if s='<' then s:='<<';
mx:=mouse.x;
my:=mouse.y;
si:=Sirka_FN(s,fn_vga16);
vy:=RychlaVyskaRadky(s);
if si>SIRKA-10 then SIRKA:=si+10;
if vy>VYSKA-38 then VYSKA:=vy+38;

if mx+SIRKA>vga.breite then mx:=vga.breite-SIRKA;
if my+VYSKA>vga.hoehe then my:=vga.hoehe-VYSKA;
f:=String2FN(e^.hlavni_font);
NapisKodZnaku(mx,my,mx+SIRKA-1,my+VYSKA-1,s,w,f,si,vy);
end;

Function NastartujEditacniPole(obrazek:boolean):PEditacniPole;
var e:PEdob;
begin
e:=New(PEdob,Init(obrazek));
edvaz^.InitNext(e);
NastartujEditacniPole:=e^.ed;
VykresliDolniListu;
end;

Constructor Edob.Init(obrazek:boolean);
var e:PEditacniPole;
    i:PTlacitko;
    hv:boolean;
begin
if obrazek then self.ed:=nil
   else begin
   e:=New(PEditacniPole,Init(_ex,_ey,_xr,_yr,true));
   e^.ED_key_proc:=@MyEdProc;
   e^.ED_Zobr_proc:=@MyEdZobrProc;
   e^.ED_PMys_proc:=@MyEdPmysProc;
   e^.mimoradne_osetreni_klavesnice:=@MyOsetreniKlavesnice;
   e^.popredi:=popredi;
   e^.ZmenBarvuPozadi(pozadi);
   e^.hlavni_font:=non_unicode_font;
   self.ed:=e;
   end;
hv:=hned_vykresluj;
hned_vykresluj:=false;
i:=New(PTlacitko,Init(0,0,'','',0,0));
hned_vykresluj:=hv;
self.ik:=i;
self.ob:=nil;
end;

Destructor Edob.Done;
begin
if self.ed=nil then
               begin
               Kill_VW(ob^.zdroj);
               Dispose(ob,Done);
               end
               else Dispose(ed,Done);
Dispose(ik,Done);
end;

Function PrepniOkno(p:PVaznik):byte;
var v:PEdob;
begin
v:=p^.vazba;
ed:=v^.ed;
if ed=nil then    {je to obrazek nebo text?}
   begin
   ob:=v^.ob;     {obrazek}
   ob^.zobraz;
   end
   else begin
   ob:=nil;
   ed^.Zobraz;
   end;
VykresliDolniListu;
VytvorListu;
end;

Function ZavriOkno(p:PVaznik):byte;
var v:Pedob;
    q:Pvaznik;
begin
v:=p^.vazba;
if p^.predchozi^.predchozi=nil then q:=p^.dalsi else q:=p^.predchozi;
Dispose(v,Done);
Dispose(p,Done);
if q<>nil then
   begin
   v:=q^.vazba;
   ed:=v^.ed;
   if ed=nil then {je to obrazek nebo text?}
      begin
      ob:=v^.ob;
      ob^.Zobraz;
      end
      else begin
      ob:=nil;
      ed^.Zobraz;
      end;
   VykresliDolniListu;
   VytvorListu;
   end
   else begin
   ed:=nil;
   VykresliPracoviste;
   end;
end;

Procedure ZavriOkno_z_menu;
var p:PVaznik;
    v:PEdob;
begin
if ed=nil then Exit;
zadost_o_zavreni:=false;
p:=edvaz^.dalsi;
while p<>nil do
   begin
   v:=p^.vazba;
   if v^.ed=ed then begin ZavriOkno(p);Exit;end;
   p:=p^.dalsi;
   end;
end;

Function PohlidejListu:byte;
var p:PVaznik;
    v:PEdob;
begin
p:=edvaz^.dalsi;
while p<>nil do
   begin
   v:=p^.vazba;
   v^.ik^.kontrola;
   case v^.ik^.hodnota of
      1:Exit(PrepniOkno(p));
      2:Exit(ZavriOkno(p));
      end;
   p:=p^.dalsi;
   end;
end;

Procedure PohlidejZatrzitka;
var b:boolean;
    p1,p2:pointer;
begin
p1:=klin.hodnota;klin.kontrola;p2:=klin.hodnota;
if p1<>p2 then aktualni_klavesnice:=klin.hodnota^.vazba;

if ob<>nil then        {mame otevreny obrazek?}
   begin
   ob_zoom.kontrola;
   ob_rp.kontrola;
   ob_rm.kontrola;
   if ob_zoom.klik=1 then ObrazekNaCelouObrazovku;
   if ob_rp.klik=1 then RotujDoprava;
   if ob_rm.klik=1 then RotujDoleva;
   Exit;
   end;

if ed=nil then Exit;   {otevreno neni vubec nic?}
b:=false;
za_un.kontrola;
za_za.kontrola;
if za_un.bylo_klepnuto then
   begin
   ed^.unicode:=za_un.hodnota;
   if za_un.hodnota then
      ed^.ZmenFont(unicode_font) else ed^.ZmenFont(non_unicode_font);
   b:=true;
   end;
if za_za.bylo_klepnuto then
   begin
   if ed^.zalamuj then ed^.PosouvaciRezim else ed^.ZalamovaciRezim;
   b:=true;
   end;
if B then ed^.Zobraz;
end;

Procedure PootvirejSoubory;
var i:longint;
begin
repeat
   i:=Pos('|',zadost_o_otevreni);
   if i=0 then OtevriSoubor(zadost_o_otevreni) else
      begin
      OtevriSoubor(Copy(zadost_o_otevreni,1,i-1));
      delete(zadost_o_otevreni,1,i);
      end;
until i=0;
end;

Procedure OtaznikNaPrikRadce;
begin
Kill_mouse;
Kill_graph;
writeln(hlla('parametr_otaznik'));
Halt(0);
end;

Procedure Pomlcka(s:string);
begin
delete(s,1,1);
if s='?' then OtaznikNaPrikRadce;
{if s='U' then unicode_startup:=true;}
end;

Procedure Parser;
var a,b:byte;
    s,soubor:string;
begin
soubor:='';
b:=LFNParamCount(CommandLine);
for a:=1 to b do
  begin
  s:=Convert_Up(LFNParamStr(CommandLine,a));
  case s[1] of
    '/','-':Pomlcka(s);
  else if ExistFile(s) then
          if zadost_o_otevreni='' then
             zadost_o_otevreni:=s else
             zadost_o_otevreni:=zadost_o_otevreni+'|'+s;
  end;
  end;
if soubor<>'' then
   begin
   {OtevriSoubor(soubor);}

   {if unicode_startup then
      begin
      ed^.unicode:=true;
      ed^.hlavni_font:=unicode_font;
      ed^.Zobraz;
      VytvorListu;
      end;        }
   end;
end;


{****************************************************************************}
{****************************************************************************}

var i:longint;
begin
dbg:=false;
NactiKonfiguraci;
Parser;               {zpracovani parametru prikazoveho radku}

ZapniGrafiku;
ZavedSystemovyFont;
utf8_tbl:=@moje_utf8_tbl;
edvaz:=New(PVaznik,Init(nil,nil));
ed:=nil;
ob:=nil;
ZalozZatrzitko;
DefiniceMenu;
VykresliPracoviste;
xReadKey_Doplnek:=@xReadKey_obsluha;
xKeyPressed_Doplnek:=@xKeyPressed_obsluha_AltShift;
ZapniObsluhuKlavesnice(KL_S_BIOSEM);
SpocitejZachytneBody;
repeat
if ob<>nil then
   begin
   ob^.kontrola;                  {Co kdyz nezobrazujeme text, ale obrazek?}
   end;
if ed<>nil then
   begin
   if ed^.stav<>_aktivni then
      begin
      ed^.stav:=_aktivni;
      ed^.xm:=-mouse.last_px;
      ed^.ym:=-mouse.last_py;
      end;
   ed^.kontrola;                  {o klavesnici se normalne stara otevrene okno}
   end else
   HlidejKlavesnici;              {kdyz ale zadne neexistuje...}
i:=vb^.kontrola;
if i<>0 then AktivaceMenu(i);
if zadost_o_zavreni then ZavriOkno_z_menu;
if zadost_o_otevreni<>'' then
   begin
   PootvirejSoubory;
   zadost_o_otevreni:='';
   end;
PohlidejListu;
PohlidejZatrzitka;
until 1=2;

Dispose(ed,Done);
Kill_Mouse;
Kill_Graph;
end.
