unit kas_fu;
{$IFDEF VER2}{$DEFINE NEWFPC}{$ENDIF}
{$IFDEF VER3}{$DEFINE NEWFPC}{$ENDIF}
{$IFDEF NEWFPC}{$CALLING OLDFPCCALL}{$ENDIF}

interface
uses {Fnfont3,}VnmFnHlp,Vnm_FU;


type
PExtFontFU = ^TExtFontFU;

TExtFontFU = object(TFontFU)
popisek1:string[255];
popisek2:string[255];
defzns:byte;    {defaultni sirka novotvorenych znaku}

Constructor Init;
Function ZalozNovyZnak(z:longint):PZnak;
Function DeleteChar(z:longint;vcetnebitmapy:boolean):byte;
Function DeleteChar(z:longint):byte;
Procedure VynulujBitmapuZnaku(z:longint);
Procedure Nakopiruj_data_fontu_odjinud(f:PBitmapovyFont);
Procedure Proved_Import_z_PFontFU(fu:PFontFU;odstran_z_fu:boolean);
Function SaveFont_FU(s:string):byte;
Function SaveFont_FN(s:string):byte;
Function SaveFont_V8F(var s,pop:string;optim1,optim2:boolean;var po:longint):byte;
Procedure SaveHeader_V8F(var f:file;var pop:string;cp:word);
Destructor Done;virtual;
end;

const kas_fu_dbg:byte = 0;
var prazdny_vga_znak:array[0..32] of byte;

Function Zkontroluj_Format_FU(s:string):boolean;

implementation
uses GrpFile,Vnm_V8FI;

type

TUnifont_header = packed record
   magic:array[1..4] of char;
   first:word;
   version:byte;
   {prapuvodni byly 0, ted zde ma byt 1}
   flags:byte;
   {0.bit: 0 = soubor neobsahuje popisek}
   {       1 = soubor obsahuje popisek}

   last:word;
   reserved1:byte;
   public_vel:byte;
   nahore:word;
   dole:word;
   end;


Tv8fblok16 = packed record
   typ:byte;
   vel:word;
   podtyp:byte;
   codepage:word;
   end;

Pv8fblok1 = ^Tv8fblok1;
Tv8fblok1 = packed record
   typ:byte;
   vel:word;
   first:word;
   count:word;
   width:word;
   height:word;
   end;

const unimagic:pchar='a';
      fnmagic:pchar = 'mon ';
      vf8magic:pchar = 'V8FONT'#13#10;

var gl_v8f_b1:Tv8fblok1;


function MyStr (Cislo: longint): string;
var
  Vysledek : string;
begin { MyStr }
  Str (Cislo, Vysledek);
  MyStr := Vysledek;
end;  { MyStr }


{$IFDEF NEWFPC}
Function PLength(p:pchar):longint;
begin
PLength:=Length(p);
end;
{$ELSE}
Function PLength(p:pchar):longint;assembler;
asm
xor eax,eax
mov esi,p
@znova:
cmp byte [esi],0
je @konec
inc esi
inc eax
jmp @znova
@konec:
end;
{$ENDIF}


Function Zkontroluj_Format_FU(s:string):boolean;
var grp:TGrpStream;
    p:array[1..4] of byte;
    q:pchar;
begin
grp.Init(DoplnJmenoFontu(s),grpOpenRead);
if grp.GetSize<5 then
   begin
   grp.Done;
   Exit(false);
   end;
q:=@p;
grp.Read(p,4);
grp.Done;
Zkontroluj_Format_FU:=comparebyte(q^,unimagic^,4)=0;
end;



Constructor TExtFontFU.Init;
begin
inherited Init;
format:=FNFMT_FU+128;
popisek1:='';
popisek2:='';
defzns:=8;
end;



Function TExtFontFU.ZalozNovyZnak(z:longint):PZnak;
var b:byte;
    aamod,aadiv:longint;
    zs,zn:PZnak;

begin
{debug}{if kas_fu_dbg>0 then
   b:=b;}
aadiv:=z div 256;
aamod:=z mod 256;

b:=OdemkniBlok(aadiv);

zs:=ZBlok[aadiv]^[aamod];

if zs<>nil then
   begin
   dispose(zs,Done);           {Nejaky znak tu uz je? Tak ho zrusime...}
   ZBlok[aadiv]^[aamod]:=nil;
   end;

zn:=New(PZnak,Init);        {inicializace dat. struktury znaku}
ZBlok[aadiv]^[aamod]:=zn;   {a prirazeni fontu}
ZalozNovyZnak:=zn;
inc(pocetzn);
end;


Function TExtFontFU.DeleteChar(z:longint;vcetnebitmapy:boolean):byte;
var zd,zm:longint;
    zz:PZnak;
begin
if (z>$FFFF) or (z<0) then Exit(1);
zd:=z div 256;
if ZBlok[zd]=nil then Exit(2)
   else begin
   zm:=z mod 256;
   zz:=ZBlok[zd]^[zm];
   if zz=nil then Exit(3);
   if vcetnebitmapy=false then zz^.data:=nil;
   {Ochrana bitmapy pred smazanim. Hodi se v rutinach, kde se odkaz na bitmapu
    preda jinemu znaku.}
   Dispose(zz,Done);
   ZBlok[zd]^[zm]:=nil;
   dec(pocetzn);
   DeleteChar:=0;
   end;
end;


Function TExtFontFU.DeleteChar(z:longint):byte;
begin
DeleteChar(z,true);
end;



Function TExtFontFU.SaveFont_FU(s:string):byte;
var t:file;
    u:Tunifont_header;
    a,b,k:longint;
    r:packed record b:byte;w:word;end;
    w:packed record dp:byte;sirka:byte;end;
    w2:packed record relx:shortint;rely:shortint;shift:byte;end;
    zzf:PZnak;
    pop:string;

begin
Assign(t,DoplnJmenoFontu(s));
Rewrite(t,1);
move(unimagic^,u.magic,4);
u.version:=1;

{popisek1:='VGA like Unicode font, height 16px';}

if popisek1<>'' then u.flags:=1 else u.flags:=0;
u.first:=first;
u.last:=last;
u.nahore:=so;
u.dole:=su;
u.public_vel:=vel;
BlockWrite(t,u,sizeof(Tunifont_header));


if popisek1<>'' then
   begin
   pop:=popisek1+#0;
   BlockWrite(t,pop[1],Length(pop));
   end;

b:=0;
for a:=first to last do
    begin
    zzf:=PrepChar(a);
    if IsChReadyZ(a,zzf)=false then inc(b)
       else begin
       if b<>0 then
          begin
          r.b:=0;  {tento znak je prazdny}
          r.w:=b;  {prazdnych znaku je tolik a tolik}
          BlockWrite(t,r,sizeof(r));
          b:=0;
          end;
       w.dp:=zzf^.dp;
       w.sirka:=zzf^.sirka;

       if (zzf^.rely<>-so) or (zzf^.relx<>0) or (zzf^.shift<>zzf^.sirka+2)
          then w.sirka:=w.sirka or 128;
          {rozmery znaku budou jine nez defaultni? V tom pripade nasstavime
           nejvyssi bit}

       BlockWrite(t,w,sizeof(w));
       {ulozime sirku a pocet bajtu bitmapy}
       if w.sirka>127 then
          begin
          w2.relx:=zzf^.relx;
          w2.rely:=zzf^.rely;
          w2.shift:=zzf^.shift;
          BlockWrite(t,w2,sizeof(w2));
          end;
       BlockWrite(t,zzf^.data^,w.dp);
       end;
   end;

if b<>0 then
   begin
   r.b:=0;  {tento znak je prazdny}
   if b=65536 then r.w:=0 else r.w:=b; {prazdnych znaku je tolik a tolik}
      {pokud neni definovany ani jeden znak, tak je zde nula}
   BlockWrite(t,r,sizeof(r));
   end;
Close(t);
SaveFont_FU:=0;
end;


Procedure TextFontFU.Nakopiruj_data_fontu_odjinud(f:PBitmapovyFont);
begin
so:=f^.so;
su:=f^.su;
sosu:=so+su;
vel:=f^.vel;
add:=f^.add;
unicode:=f^.unicode;
kodova_stranka:=f^.kodova_stranka;
first:=f^.first;
last:=f^.last;
pocetzn:=f^.pocetzn;
vzdy_komplet_nahrany:=f^.vzdy_komplet_nahrany;
end;


Procedure TextFontFU.Proved_Import_z_PFontFU(fu:PFontFU;odstran_z_fu:boolean);
var a:longint;
begin
Nakopiruj_data_fontu_odjinud(fu);
for a:=0 to 255 do Zblok[a]:=fu^.Zblok[a];
if odstran_z_fu=true then
   begin
   for a:=0 to 255 do fu^.Zblok[a]:=nil;
   fu^.pocetzn:=0;
   end;
end;


Procedure TExtFontFU.VynulujBitmapuZnaku(z:longint);
var zzf:PZnak;
begin
if IsChReady(z) then
   begin
   zzf:=PrepChar(z);
   FillChar(zzf^.data,zzf^.dp,0);
   end;
end;


Function TExtFontFU.SaveFont_FN(s:string):byte;
var t:file;
    mgl:longint;
    aa,a3,a,b,k,x,y,mbfn:longint;
    a4:word;
    j:byte;
    ddiv,dmod:byte;
    zzo,zzf,zzmez:PZnak;

    mbf:pbyte;

    pb:packed array[0..4097] of byte;
    pc:array[0..255] of longint;
    g:pbyte;
    ff:PExtFontFU;
    f:PExtFontFU;
    defpop:string;

begin
GetMem(mbf,$20000);


mgl:=PLength(fnmagic);
move(fnmagic[0],pb[0],mgl);    {"magic" signatura}

defpop:='<CP='+MyStr(kodova_stranka)+'>'+popisek1;

a:=Length(defpop);
move(defpop[1],pb[mgl],a);    {popisek}
inc(a,mgl);
pb[a+0]:=0;
pb[a+1]:=first;
pb[a+2]:=last;
pb[a+3]:=byte(so);
pb[a+4]:=byte(su);
pb[a+5]:=byte(add);
pb[a+6]:=0;   {"Future" musi byt bohuzel 0}



aa:=a+7;
a3:=aa+(last-first+1)*7;
mbfn:=0;
f:=@self;

ff:=New(PExtFontFU,Init);

kas_fu_dbg:=1;

ff^.Nakopiruj_data_fontu_odjinud(f);

zzmez:=New(PZnak,Init);  {zastupny znak pro nedefinovane}

if IsChReadyZ(32,zzo) and (zzo^.hasbitmap=false)
{je definovana mezera a ta mezera je skutecne "prazdna"?}
   then zzo^.PrekopirujPolozky(zzmez,false)
           {v tom pripade ji povazuj za placeholder}

   else begin  {mezeru za placeholder pouzit nemuzeme...}
   zzmez^.ready:=2;
   zzmez^.shift:=so; {dejme nejakou alespon vzdalene primerenou hodnotu pro posun}
   zzmez^.rely:=-so; {a neco smysluplneho pro RelY}
   {ostatni muzeme nechat na nulach}
   end;

for b:=first to last do
    if IsChReady(b) then
       begin
       zzo:=PrepChar(b);
       ff^.ZalozNovyZnak(b);
       zzf:=ff^.PrepChar(b);
       zzo^.PrekopirujPolozky(zzf,false);

       if zzo^.HasBitmap then  {pokud ma znak definovanou bitmapu}
          begin
          GetMem(zzf^.data,zzf^.dp);    {pripravime prostor pro bitmapu}
          Move(zzo^.data^,zzf^.data^,zzo^.dp);

          zzf^.Dekomprimuj(false,false);
          ddiv:=zzf^.sirka div 8;
          dmod:=zzf^.sirka mod 8;

          pc[b]:=mbfn;
          g:=zzf^.data;
          for y:=1 to zzf^.vyska do
              begin
              for x:=0 to ddiv-1 do
                  begin
                  ZnakBuf_Shrink(g,8,j);
                  inc(g,8);
                  mbf[mbfn]:=j;
                  inc(mbfn);
                  end;
              if dmod<>0 then
                 begin
                 ZnakBuf_Shrink(g,dmod,j);
                 inc(g,dmod);
                 mbf[mbfn]:=j;
                 inc(mbfn);
                 end;
             end;
          end
          else                 {pokud nema definovanou bitmapu}
          begin
          pc[b]:=0;            {hodnota zda je irelevantni, ale lepe je}
          end;                 {vlozit nejake definovane cislo}
       end
       else begin              {nedefinovany znak v bloku of FIRST do LAST}
       ff^.ZalozNovyZnak(b);       {presto zalozime "prazdny" znak}
       zzf:=ff^.PrepChar(b);
       zzf^.ready:=2;               {zvalidnime pristup ke znaku (nadale je ale bitmapa=NIL)}
       zzmez^.PrekopirujPolozky(zzf,false);    {pouzijeme placeholder}
       pc[b]:=0;
       end;

{TODO: pokud nebyla definovana mezera, tak ji doplnime?...}

for b:=first to last do
    begin
    zzf:=ff^.PrepChar(b);
    pb[aa+0]:=byte(zzf^.relx);
    pb[aa+1]:=byte(zzf^.rely);
    pb[aa+2]:=byte(zzf^.sirka);
    pb[aa+3]:=byte(zzf^.vyska);
    pb[aa+4]:=byte(zzf^.shift);
    a4:=a3+pc[b];
    pb[aa+5]:=Lo(a4);
    pb[aa+6]:=Hi(a4);
    inc(aa,7);
    end;


Assign(t,DoplnJmenoFontu(s));
Rewrite(t,1);

BlockWrite(t,pb[0],a3);
BlockWrite(t,mbf[0],mbfn);


Close(t);

Dispose(zzmez,Done);

Dispose(ff,Done);
FreeMem(mbf);
SaveFont_FN:=0;
end;


Procedure TExtFontFU.SaveHeader_V8F(var f:file;var pop:string;cp:word);
var s:string;
    mgl:longint;
    popk:string;
    blok10h:Tv8fblok16;

begin
mgl:=PLength(vf8magic);
popk:=#0#13#10#26;

blok10h.typ:=$10;
blok10h.vel:=5;
blok10h.podtyp:=0;
blok10h.codepage:=cp;

BlockWrite(f,vf8magic^,mgl);
BlockWrite(f,pop[1],Length(pop));
BlockWrite(f,popk[1],4);
BlockWrite(f,blok10h,blok10h.vel+1);
end;


Procedure Inicializuj_Blok1_V8F(bl1:Pv8fblok1;vel:longint);
begin
bl1^.typ:=1;
bl1^.vel:=0;
bl1^.first:=0;
bl1^.count:=1;
bl1^.width:=8;
bl1^.height:=vel;
end;


Function TExtFontFU.SaveFont_V8F(var s,pop:string;optim1,optim2:boolean;var po:longint):byte;
var f:file;
    a,b,i:longint;
    pp:pchar;
    zz:PZnak;
    blok1:Tv8fblok1;
    prac:array[0..12000] of byte;
    mn:set of byte;
    uvnitr:boolean;

begin
Assign(f,DoplnJmenoFontu(s));
Rewrite(f,1);

SaveHeader_V8F(f,pop,kodova_stranka);

if sosu=16 then pp:=@BIOS_FONT_16_DATA else
if sosu=14 then pp:=@BIOS_FONT_14_DATA else
if sosu=8 then pp:=@BIOS_FONT_8_DATA else pp:=nil;

mn:=[];
po:=0;
for a:=0 to 255 do
    begin
    zz:=PrepChar(a);
    if zz=nil then
       if optim2=true
          then Move(pp[a*sosu],prac[a*sosu],sosu)
          else begin Move(prazdny_vga_znak,prac[a*sosu],sosu);mn:=mn+[a];end
              else begin
              Move(zz^.data^,prac[a*sosu],sosu);
              if optim1=true then
                 begin
                 i:=CompareByte(prac[a*sosu],pp[a*sosu],sosu);
                 if i<>0 then mn:=mn+[a];
                 end
                 else begin
                 mn:=mn+[a];
                 end;
              end;
    end;

uvnitr:=false;
Inicializuj_Blok1_V8F(@blok1,sosu);

for a:=0 to 255 do
    begin
    if a in mn then
       if uvnitr
          then inc(blok1.count)  {pokracuje blok znaku, ktere budeme kopirovat}
          else begin             {vstupujeme do noveho bloku znaku}
               uvnitr:=true;
               blok1.first:=a;
               end
       else begin  {not (a in mn)}
       if uvnitr=true then       {ukoncujeme blok znaku, ktere se budou kopirovat}
          begin
          b:=SizeOf(Tv8fblok1)+blok1.count*sosu-1;
          blok1.vel:=b;
          BlockWrite(f,blok1,SizeOf(Tv8fblok1));
          BlockWrite(f,prac[blok1.first*sosu],blok1.count*sosu);
          uvnitr:=false;
          Inicializuj_Blok1_V8F(@blok1,sosu);
          end;
       inc(po);
       end;
    end;

if uvnitr=true then
   BlockWrite(f,prac[blok1.first*sosu],blok1.count*sosu);

Close(f);

SaveFont_V8F:=0;
end;


Destructor TExtFontFU.Done;
begin
inherited Done;
end;

Procedure Inicializace_jednotky;
begin
FillChar(prazdny_vga_znak,32,0);
{pripravi prazdny blok pro pripadne nedefinovane VGA znaky}
end;

begin
Inicializace_jednotky;

end.
