' подсвечиваем слово при удачном поиске
' рисует поверх рисования всего буфера , поэтому плохо применимо для подсветки (например кода)
' годится только для операций , не требующих производительности
' Параметры:
' iRow - номер строки
' iPos - позиция в этой строке
' Параметры:
' iColor - цвет подсвечивания слова
' pwsWord - указатель на строку со словом
sub SetColorWord(iRow as Long  , iPos as Long , iColor as Long , pwsWord as wstring ptr)
	
	dim as Long iPosInConsole ' позиция по X в экране
	
	dim as Long iLocalRow ' относительная строка на экране
	
	' если строка со словом больше кол-ва строк на экране
	if iRow > pObj.iHeightRows - 1 then 
		
		' получим число , равное половине строк на экране
		iLocalRow = pObj.iHeightRows\2
		
		' подсчитаем стартовую позицию на экране
		pObj.iStartRowInWindow = iRow - iLocalRow + 1
		
	else
		
		iLocalRow = iRow ' строка равна параметру функции
		
		pObj.iStartRowInWindow = 1 ' стратовую строку на самое начало
		
	EndIf
	
	SetLenghtNumbers() ' подсчитаем кол-во символов в номерах строк
	
	' получим позицию перед словом
	dim as long iRealPos = GetTabStopPositionFromRealPosition(pObj.pList.GetValueIndex(iRow-1) , iPos)
	
	' получим позицию после слова
	dim as long iRealPosWithWord = GetTabStopPositionFromRealPosition(pObj.pList.GetValueIndex(iRow-1) , iPos+len(*pwsWord))
	
	' если позиция слова выходит за рамки экрана
	if iRealPosWithWord + pObj.iLenghtNumbers + 1 >= pObj.iWidthSimbols  Then 
		
		dim as Long iTempPos = 1 ' первая позиция в строке буфера
		
		pObj.iScrollWidth = 1 ' прокрутку на начало
		
		' пока слово не окажется в области видимости экрана
		while iRealPosWithWord + pObj.iLenghtNumbers + 1 >= pObj.iWidthSimbols 
			
			' получить текущую позицию с учетом табуляций
			dim as Long iCurentPos = GetTabStopPositionFromRealPosition(pObj.pList.GetValueIndex(iRow-1) , iTempPos)
			
			' получить предыдущую позицию с учетом табуляций
			dim as Long iNextPos = GetTabStopPositionFromRealPosition(pObj.pList.GetValueIndex(iRow-1) , iTempPos+1)
			
			iCurentPos = (iNextPos - iCurentPos) ' получим шаг между позициями
			
			pObj.iScrollWidth += iCurentPos ' увеличим прокрутку
			
			iRealPos -= iCurentPos ' уменьшим позицию курсора
			
			iRealPosWithWord -= iCurentPos ' уменьшим позицию окончания слова
			
			iTempPos+=1 ' увеличим позицию в строке буфера
			
		Wend
		
		' подсчитываем позицию по X в экране
		iPosInConsole = iRealPos + pObj.iLenghtNumbers + 1
		
	else
		
		' подсчитываем позицию по X в экране
		iPosInConsole = iRealPos + pObj.iLenghtNumbers + 1
		
	EndIf
	
	' переходим на позицию
	SetPositionWithPosAndRow(iPos , iLocalRow , pObj.iStartRowInWindow , iPosInConsole , 1)	
	
	bRepaintAnyway = 1 ' обновим весь экран
	
	' рисуем все строки на экране
	DrawRowsEditor(1)
	
	' печатаем найденное слово
	DrawInPos(pwsWord , "" , iLocalRow , iPosInConsole , (iColor shl 4) or pObj.iColorText )
	
End Sub

' Поиск , начиная со строки и позиции , указанной в параметрах функции
' Параметры:
' iRow - номер строки
' iPos - позиция в этой строке
' pWstrBuf - искомая строка
' iDirection - направление поиска
' iCase - учитывается ли регистр символов (0 - не учитывается , 1 - учитывается)
' pRetWstrBuf - найденная строка , с учетом регистра 
function Find(Byref iRow as Long  , Byref iPos as Long , pWstrBuf as wstring ptr , _
iDirection as Long = 1  , iCase as Long = 0 , pRetWstrBuf as wstring ptr = 0) as LONG
	
	dim as Long iIndex = iRow - 1 ' получаем индекс для списка из текущей строки
	
	dim as Long iStart = iPos ' ставим начальную позицию для поиска , как задано параметром
	
	if iDirection then ' если поиск идет вниз
		
		for i as Long  = iIndex to pObj.pList.GetSize()-1 ' от текущей строки до конца
			
			dim as Wstring ptr pWstr = pObj.pList.GetValueIndex(i) ' получим указатель на строку
			
			dim as Long iFindPos ' вспомогательная переменная для поиска
			
			if iCase then
				
				iFindPos = instr(iStart , *pWstr , *pWstrBuf) ' ищем
				
			else
				
				iFindPos = instr(iStart , lcase(*pWstr) , lcase(*pWstrBuf)) ' ищем
				
			EndIf
			
			if iFindPos then ' если найдено
				
				iRow = i + 1 ' сохраняем строку (линию) для возврата
				
				iPos = iFindPos ' сохраняем позицию в этой линии
				
				*pRetWstrBuf = mid( *pWstr , iFindPos , len(*pWstrBuf)) ' записываем реальную найденную строку
				
				return 1 ' выходим из функции
				
			else
				
				iStart = 1 ' поиск ставим с первой позиции
				
			EndIf
			
		Next
		
	else ' если поиск идет вверх
		
		' если начальная позиция больше длины строки
		if iStart > pObj.pList.GetValueLenIndex(iIndex) then
			' ставим начальную позицию , равную длине строки
			iStart = pObj.pList.GetValueLenIndex(iIndex)
			
		EndIf
		
		for i as Long = iIndex to 0 step -1 ' от текущей строки до начала
			
			dim as Wstring ptr pWstr = pObj.pList.GetValueIndex(i) ' получим указатель на строку
			
			if i < iIndex then ' если поиск в предыдущей строке
				
				iStart = len(*pWstr) ' ставим поиск с конца
				
			EndIf
			
			dim as Long iFindPos ' вспомогательная переменная для поиска
			
			if iCase then
				
				iFindPos = instrRev(*pWstr , *pWstrBuf , iStart) ' ищем назад
				
			else
				
				iFindPos = instrRev(lcase(*pWstr) , lcase(*pWstrBuf) , iStart) ' ищем назад
				
			EndIf
			
			if iFindPos then ' если найдено
				
				iRow = i + 1 ' сохраняем строку (линию) для возврата
				
				iPos = iFindPos ' сохраняем позицию в этой линии
				
				*pRetWstrBuf = mid( *pWstr , iFindPos , len(*pWstrBuf)) ' записываем реальную найденную строку
				
				return 1 ' выходим из функции
				
			EndIf
			
		Next
		
	EndIf
	
End Function

' процедура вывода о неудачном поиске
sub NothingFound()
	
	ClearLine(pObj.iHeightRows) ' очистка последней строки
	
	' выводим подсказку
	DrawInPos( 0 , "Find: Nothing found" , pObj.iHeightRows , 1 , (pObj.iColorBackGround shl 4) or pObj.iColorStatusBar)
	
End Sub

' объединение клавиш в общий буфер и вывод буфера на экран с предваряющей строкой
' параметры:
' pwsKeys - указатель на строку с клавишей
' pwsFindInit - предваряющая строка поиска для вывода в статусбар
' pwsBufFind - буфер строки поиска куда заносятся клавиши
' pwsReplaceInit - предваряющая строка замены для вывода в статусбар
' pwsBufReplace - буфер строки замены куда заносятся клавиши
' iColumnWrite - флаг , позволяющий определять в какой строке находится курсор (поиск или замена)
' iCursor - позиция курсора на экране
' iCursorInStr - позиция в строке
sub ConcatKeys(pwsKeys as wstring ptr , pwsFindInit as Wstring ptr , pwsBufFind as wstring ptr ,_
pwsReplaceInit as Wstring ptr , pwsBufReplace as wstring ptr, iColumnWrite as long , Byref iCursor as Long , Byref iCursorInStr as Long)
	
	if iColumnWrite = 0 then ' если в строке поиска
		
		' ограничим длину вводимой строки
		if GetLenStringWithTab(*pwsBufFind , iTabSpace) < pObj.iWidthSimbols - GetLenStringWithTab(*pwsFindInit , iTabSpace) -2 then
			
			' если курсор в конце
			if iCursorInStr > len(*pwsFindInit & *pwsBufFind) then
				
				' добавим символ в общий буфер
				*pwsBufFind &= *pwsKeys
				
			else ' если курсор не в конце
				
				' посчитаем относительную позицию курсора в искомой строке
				dim as Long iCursorR = iCursorInStr-1-len(*pwsFindInit)
				
				' вставим символ в буфер
				*pwsBufFind = left(*pwsBufFind , iCursorR) & *pwsKeys & mid(*pwsBufFind , iCursorR+1)
				
			endif
			
			' увеличим позицию в строке
			iCursorInStr+=1
			
			' установим позицию курсора
			iCursor = GetTabStopPositionFromRealPosition(*pwsFindInit & *pwsBufFind , iCursorInStr)
			
			' выведем строку в статусбар с учетом нового символа
			DrawInitFind(*pwsFindInit & *pwsBufFind , pObj.iHeightRows-1 , 1 , iCursor)
			
		endif
		
	else ' если в строке замена
		
		' ограничим длину вводимой строки
		if GetLenStringWithTab(*pwsBufReplace , iTabSpace) < pObj.iWidthSimbols - GetLenStringWithTab(*pwsReplaceInit ,iTabSpace) -2 then
			
			' если курсор в конце
			if iCursorInStr > len(*pwsReplaceInit & *pwsBufReplace) then
				
				' добавим символ в общий буфер
				*pwsBufReplace &= *pwsKeys
				
			else ' если курсор не в конце
				
				' посчитаем относительную позицию курсора в искомой строке
				dim as Long iCursorR = iCursorInStr-1-len(*pwsReplaceInit)
				
				' вставим символ в буфер
				*pwsBufReplace = left(*pwsBufReplace , iCursorR) & *pwsKeys & mid(*pwsBufReplace , iCursorR+1)
				
			EndIf
			
			' увеличим позицию в строке
			iCursorInStr+=1
			
			iCursor = GetTabStopPositionFromRealPosition(*pwsReplaceInit & *pwsBufReplace , iCursorInStr)
			
			' выведем строку в статусбар с учетом нового символа
			DrawInitFind(*pwsReplaceInit & *pwsBufReplace , pObj.iHeightRows , 1 , iCursor)
			
		endif	
		
	endif
	
End sub

' вывод подсказки для клавиш при операциях поиска или замены и подсвечивание найденного слова
' параметры:
' iReplaceParameter - флаг , отличающий диалог (поиск или замена)
' iFindRow - номер строки
' iFindPos - позиция в строке
' pWstrRet - указатель на строку подсвечиваемого слова
' iFlagReplaceTrue - флаг для возможности замены
sub SetResultFind(iReplaceParameter as Long , iFindRow as long , iFindPos as long ,_
pWstrRet as wstring ptr , byref iFlagReplaceTrue as long)
	
	dim as wstring*60 wsText ' переменная для текста подсказки
	
	if iReplaceParameter then ' если запущен диалог замены
		
		' заносим подсказку при замене
		wsText = "Next [->] ; Prev [<-] ; Replace [Up] ; End [esc]"
		
		' устанавливаем флаг , что замена возможна
		iFlagReplaceTrue = 1
		
	else ' если запущен диалог поиска
		
		' заносим подсказку при поиске
		wsText = "Next [->] ; Prev [<-] ; End [esc]"
		
		' устанавливаем флаг , что замена не возможна
		iFlagReplaceTrue = 0
		
	EndIf
	
	SetColorWord(iFindRow , iFindPos , pObj.iColorFindWord , pWstrRet) ' подсвечиваем слово
	
	ClearLine(pObj.iHeightRows) ' очистка последней строки
	
	' выводим подсказку
	DrawInPos(wsText , "" , pObj.iHeightRows , 1 , (pObj.iColorBackGround shl 4) or pObj.iColorStatusBar)
	
End Sub

' стирает символ с помощью BACKSPACE в диалоге поиска\замены
' параметры
' pwsInitStr - указатель на предваряющую строку
' pwsBuf - указатель на буфер строки поиска или замены 
' iRow - номер экранной строки
' iCursor - позиция курсора
' iCursorInStr - позиция в строке
sub FindBoxBackSpaceSymbol(pwsInitStr as WSTRING ptr , pwsBuf as wstring ptr , iRow as Long , byref iCursor as Long , Byref iCursorInStr as Long )
	
	' если курсор не в конце строки
	if iCursorInStr < len(*pwsInitStr & *pwsBuf)+1 then
		
		' если курсор находится на искомой строке и возможно удаление 
		if iCursorInStr > len(*pwsInitStr)+1 then
			
			' посчитаем относительную позицию курсора в искомой строке
			dim as Long iCursorR = iCursorInStr-1-len(*pwsInitStr)
			
			' уменьшаем позицию в строке на единицу
			iCursorInStr-=1
			
			' установим курсор
			iCursor = GetTabStopPositionFromRealPosition(*pwsInitStr & *pwsBuf , iCursorInStr)
			
			' перепишем строку поиска без удаляемого символа
			*pwsBuf = left(*pwsBuf , iCursorR-1) & mid(*pwsBuf , iCursorR+1)
			
			' выводим инициализирующую строку поиска вместе с имеющимся введенным словом в статусбар
			DrawInitFind(*pwsInitStr & *pwsBuf , iRow , 1 , iCursor)					
			
		endif
		
	else ' курсор в конце строки
		
		' Если курсор не выходит за грань искомой строки , то уменьшаем позицию на единицу
		if iCursorInStr > len(*pwsInitStr)+1 then
			
			' перепишем строку поиска без удаляемого символа
			*pwsBuf = left(*pwsBuf , len(*pwsBuf)-1)
			
			' выводим инициализирующую строку поиска вместе с имеющимся введенным словом в статусбар
			DrawInitFind(*pwsInitStr & *pwsBuf , iRow , 1)
			
			' уменьшаем позицию в строке на единицу
			iCursorInStr-=1
			
			' установим курсор
			iCursor = GetTabStopPositionFromRealPosition(*pwsInitStr & *pwsBuf , iCursorInStr)
			
		EndIf
		
	endif
	
End Sub

' стирает символ с помощью DELETE в диалоге поиска\замены
' параметры
' pwsInitStr - указатель на предваряющую строку
' pwsBuf - указатель на буфер строки поиска или замены 
' iRow - номер экранной строки
' iCursor - позиция курсора
' iCursorInStr - позиция в строке
sub FindBoxDeleteSymbol(pwsInitStr as WSTRING ptr , pwsBuf as wstring ptr , iRow as Long , iCursor as Long  , iCursorInStr as Long)
	
	' посчитаем относительную позицию курсора в искомой строке
	dim as Long iCursorR = iCursorInStr-len(*pwsInitStr)
	
	' перепишем строку поиска без удаляемого символа
	*pwsBuf = left(*pwsBuf , iCursorR-1) & mid(*pwsBuf , iCursorR+1)	
	
	' выводим инициализирующую строку поиска вместе с имеющимся введенным словом в статусбар
	DrawInitFind(*pwsInitStr & *pwsBuf , iRow , 1 , iCursor)
	
End Sub

' "диалог" поиска , замены
' если iReplaceParameter = 0 , то диалог поиска
' если iReplaceParameter = 1 , то диалог замены
sub FindReplaceBox(iReplaceParameter as Long = 0)
	
	dim as Long iPos = GetPosition() ' получим текущую позицию
	
	dim as Long iKey ' буфер для клавиши
	
	dim as Long iRetRow ' переменная для получения текущей строки
	
	dim as Long iRetPos ' переменная для получения позиции в текущей строке
	
	dim as Long iCase = 1 ' первоначально регистр символов учитывается
	
	dim as Long iColumnWrite ' для определения в какой строке пишем (поиска или замены)
	
	dim as Long iDirectionFlag ' направление поиска для замены
	
	dim as Long iCursor ' позиция курсора в строке
	
	dim as Long iCursorInStr ' позиция в реальной строке 
	
	dim as wstring ptr pws = GetWordFromPosition(iPos , iRetRow , iRetPos) ' получим слово в текущей позиции
	
	dim as Wstring*25 wsInitialFind = "CASE [F3] Find: " ' предваряющая строка для статусбара (поиск)
	
	dim as Wstring*20 wsInitialReplace ' предваряющая строка для статусбара (замена)
	
	' выделяем память для буферов , куда будет заносится введенный текст для поиска и замены
	dim as wstring ptr pwsBufFind = callocate(300*sizeof(wstring))
	dim as wstring ptr pwsBufReplace = callocate(300*sizeof(wstring))
	
	' выделяем память для буферов , куда будет заносится найденное слово с учетом регистра символов
	dim as wstring ptr pWstrRet = callocate(300*sizeof(wstring))
	
	' если проблема с выделением памяти
	if pwsBufFind = 0 orelse pwsBufReplace = 0 orelse pWstrRet = 0 then
		
		DrawErrorMemory() ' выводим ошибку памяти
		
		exit sub ' выходим из процедуры
		
	EndIf
	
	if iReplaceParameter then ' если запущен диалог замены
		
		wsInitialReplace = "Replace: " ' инициализируем предваряющую строку для замены
		
	else
		
		wsInitialReplace = "           " ' инициализируем пустую предваряющую строку для замены
		
	EndIf
	
	' выводим инициализирующую строку замены в статусбар
	DrawInitFind(wsInitialReplace , pObj.iHeightRows , 1)
	
	' очищаем строку на экране для поиска
	ClearLine(pObj.iHeightRows-1)
	
	' если слово под курсором получили
	if pws andalso len(*pws) then
		
		iCursor = GetLenStringWithTab(wsInitialFind & *pws , iTabSpace)+1 ' курсор сразу за строкой
		
		iCursorInStr = len(wsInitialFind & *pws) + 1 ' позиция в строке в конце
		
		' выводим предваряющую строку для поиска вместе со словом , остальное забиваем пробелами
		DrawInPos(wsInitialFind & *pws & wspace(pObj.iWidthSimbols-GetLenStringWithTab(wsInitialFind & *pws , iTabSpace)) , "" _
		, pObj.iHeightRows-1 , 1 , (pObj.iColorBackGround shl 4) or pObj.iColorStatusBar ,pObj.iHeightRows-1 , iCursor)
		
		' сохраняем слово в буфере поиска
		*pwsBufFind = *pws
		
	else ' если слово под курсором не получено
		
		iCursor = GetLenStringWithTab(wsInitialFind , iTabSpace)+1 ' курсор сразу за строкой
		
		iCursorInStr = len(wsInitialFind) + 1 ' позиция в строке в конце
		
		' выводим предваряющую строку для поиска , остальное забиваем пробелами
		DrawInPos(wsInitialFind & wspace(pObj.iWidthSimbols-GetLenStringWithTab(wsInitialFind , iTabSpace)) , "" _
		, pObj.iHeightRows-1 , 1 , (pObj.iColorBackGround shl 4) or pObj.iColorStatusBar ,pObj.iHeightRows-1 , iCursor)
		
	EndIf
	
	' освободим память при необходимости для буфера , где было слово , полученное под курсором
	if pws then deallocate(pws)
	
	' заходим в цикл диалога
	do
		
		dim as wstring ptr pwsKeys ' буфер для юникод символа
		
		iKey = GetKeyUni(pwsKeys , 1) ' получим символ или клавишу
		
		if iKey then ' если это однобайтовый символ или клавиша
			
			select case iKey
					
				Case CVK_ESC
					
					exit do ' выходим из диалога
					
				Case CVK_BACKSPACE
					
					if iColumnWrite = 0 then ' если стираем символ в строке поиска
						
						' стираем символ в строке поиска
						FindBoxBackSpaceSymbol(@wsInitialFind , pwsBufFind , pObj.iHeightRows-1 , iCursor , iCursorInStr)
						
					else ' если стираем символ в строке замены
						
						' стираем символ в строке замены
						FindBoxBackSpaceSymbol(@wsInitialReplace , pwsBufReplace , pObj.iHeightRows , iCursor , iCursorInStr)
						
					EndIf
					
				case CVK_DELETE
					
					if iColumnWrite = 0 then ' если стираем символ в строке поиска
						
						' стираем символ в строке поиска
						FindBoxDeleteSymbol(@wsInitialFind , pwsBufFind , pObj.iHeightRows-1 , iCursor , iCursorInStr)
						
					else ' если стираем символ в строке замены
						
						' стираем символ в строке замены
						FindBoxDeleteSymbol(@wsInitialReplace , pwsBufReplace , pObj.iHeightRows , iCursor , iCursorInStr)
						
					EndIf
					
				case CVK_ENTER
					
					' если введена строка поиска и она не пустая , а так же запущен диалог замены 
					if len(*pwsBufFind) andalso iColumnWrite = 0 andalso iReplaceParameter = 1 then
						
						if len(*pwsBufReplace) then ' если в строке замены что-то уже есть
							
							' позиция курсора сразу строкой
							iCursor = GetLenStringWithTab(wsInitialReplace & *pwsBufReplace , iTabSpace)+1
							
							iCursorInStr = len(wsInitialReplace & *pwsBufReplace) + 1
							
							' выводим строку замены на экран
							DrawInitFind(wsInitialReplace & *pwsBufReplace , pObj.iHeightRows , 1 , iCursor)
							
							' установим флаг , что надо перейти на строку замены 
							iColumnWrite = 1
							
						else ' если в строке замены ничего нет
							
							' выводим инициализирующую строку замены в статусбар
							DrawInitFind(wsInitialReplace , pObj.iHeightRows , 1)
							
							' позиция курсора сразу строкой
							iCursor = GetLenStringWithTab(wsInitialReplace , iTabSpace)+1
							
							iCursorInStr = len(wsInitialReplace)+1
							
							' установим флаг , что надо перейти на строку замены 
							iColumnWrite = 1
							
						EndIf
						
						' если находимся в строке замены или если диалог замены не запущен и находимся в строке поиска
					elseif iColumnWrite = 1 orelse iReplaceParameter = 0 then
						
						' сохраняем текущую строку и позицию в этой строке
						dim as Long iFindRow = iRetRow , iFindPos = iRetPos
						
						' флаг , необходимый для пропуска ожидания клавиши , когда происходит замена
						dim as Long iFlagReplaceKey
						
						' флаг , позволяющий замену , если есть что заменять
						dim as Long iFlagReplaceTrue
						
						' результат удачного\неудачного поиска
						dim as Long iFindTrue 
						
						' ищем сначала вниз по тексту
						iFindTrue = Find(iFindRow , iFindPos , pwsBufFind , 1 , iCase , pWstrRet)
						
						if iFindTrue then ' если поиск удачен
							
							' активируем флаг , символизирующий дальнейшую замену вниз по тексту
							iDirectionFlag = 1
							
						else ' если поиск вниз неудачен
							
							' ищем вверх по тексту
							iFindTrue = Find(iFindRow , iFindPos , pwsBufFind , 0 , iCase , pWstrRet)
							
							' активируем флаг , символизирующий дальнейшую замену вверх по тексту
							iDirectionFlag = 0
							
						EndIf
						
						if iFindTrue then ' если поиск удачен
							
							' выводим подсказку для клавиш и подсветим слово
							SetResultFind(iReplaceParameter , iFindRow , iFindPos , pWstrRet , iFlagReplaceTrue)
							
							' входим во внутренний цикл для следующего\предыдущего поиска\замены
							' и перемещения по найденным словам
							do
								
								if iFlagReplaceKey = 0 then ' если замена не ожидается
									
									iKey = GetOnlyAscKey() ' получим любой не юникод символ
									
								endif
								
								select case iKey ' какая клавиша нажата
										
									Case CVK_RIGHT ' right
										
										iFindPos+=1 ' увеличим позицию поиска на единицу после прошлого поиска
										
										' если что-то найдено вниз по тексту
										if Find(iFindRow ,iFindPos , pwsBufFind , 1 ,  iCase , pWstrRet) then
											
											bRepaintAnyway = 1 ' обновим весь экран
											
											DrawRowsEditor(1) ' выводим все строки текста
											
											iDirectionFlag = 1 ' направление поиска для замены ставим вниз по тексту
											
											' выводим подсказку для клавиш и подсветим слово
											SetResultFind(iReplaceParameter , iFindRow , iFindPos ,_
											pWstrRet , iFlagReplaceTrue)
											
										else ' ничего не найдено
											
											iFindPos = 0 ' возвращаем позицию назад , как перед поиском
											
											iFindRow = 1 ' позицию номера строки на самое начало
											
											' устанавливаем флаг , что замена не возможна
											iFlagReplaceTrue = 0
											
											' выводим строку о неудачном поиске
											NothingFound()
											
										EndIf
										
										' сбрасываем флаг. Нужно будет ожидать клавишу с помощью GetKey 
										iFlagReplaceKey = 0
										
									case CVK_LEFT ' left
										
										' если позиция для поиска в пределах строки
										if iFindPos-1 > -1 then
											
											iFindPos-=1 ' сдвигаем указатель поиска влево в строке
											
										EndIf
										
										' если что-то найдено вверх по тексту
										if Find(iFindRow ,iFindPos , pwsBufFind , 0 , iCase , pWstrRet) then
											
											bRepaintAnyway = 1 ' обновим весь экран
											
											DrawRowsEditor(1) ' выводим все строки текста
											
											iDirectionFlag = 0 ' направление поиска для замены ставим вверх по тексту
											
											' выводим подсказку для клавиш и подсветим слово
											SetResultFind(iReplaceParameter , iFindRow ,_
											iFindPos , pWstrRet , iFlagReplaceTrue)
											
										else ' если ничего не найдено
											
											' возвращаем позицию вперед , как перед поиском
											iFindPos = pObj.pList.GetValueLenIndex(pObj.pList.GetSize()-1)+1
											
											iFindRow = pObj.pList.GetSize() ' позицию номера строки на самый конец
											
											' устанавливаем флаг , что замена не возможна
											iFlagReplaceTrue = 0
											
											' выводим строку о неудачном поиске
											NothingFound()
											
										EndIf							
										
										' сбрасываем флаг. Нужно будет ожидать клавишу с помощью GetKey
										iFlagReplaceKey = 0
										
									case CVK_UP ' (replace)
										
										' если запущен диалог замены и замена возможна
										if iReplaceParameter andalso iFlagReplaceTrue then
											
											' получаем строку из списка
											dim as wstring ptr pWstrTemp = pObj.pList.GetValueIndex(iFindRow-1)
											
											' если указатель на строку не пустой и длина строки не нулевая
											if pWstrTemp andalso len(*pWstrTemp) then
												
												' перезапишем строку в списке с учетом заменяемого текста
												pObj.pList.SetValueIndex(iFindRow-1 , _
												mid(*pWstrTemp , 1 , iFindPos-1) & *pwsBufReplace & _
												mid(*pWstrTemp , iFindPos+len(*pwsBufFind)))
												
												bRepaintAnyway = 1 ' обновим весь экран
												
												' флаг сохранения сбрасываем (теперь файл не сохранен)
												pObjFB.iFlagSave = 0
												
												' выводим все строки текста
												DrawRowsEditor(1)
												
												' устанавливаем флаг. Нужно будет пропустить ожидание клавишы с помощью GetKey
												iFlagReplaceKey = 1
												
												' если вниз по тексту
												if iDirectionFlag then
													
													' эмулируем нажатие клавиши right
													iKey = CVK_RIGHT
													
												else ' если вверх по тексту
													
													' эмулируем нажатие клавиши left
													iKey = CVK_LEFT
													
												EndIf
												
											EndIf
											
										EndIf
										
									case CVK_ESC
										
										exit do , do ' выходим из диалога
										
								End Select
								
							Loop
							
						else ' если поиск не удался
							
							' выводим строку о неудачном поиске
							NothingFound()
							
							' выводим инициализирующую строку поиска вместе с введенным буфером в статусбар
							DrawInitFind(wsInitialFind & *pwsBufFind , pObj.iHeightRows-1 , 1)
							
							' ожидаем любую клавишу , чтобы оценить результат
							GetAnyKey()
							
							' выходим из цикла
							exit do
							
						endif
						
					EndIf
					
					' ненужные сочетания клавиш игнорируем
				case CVK_INSERT,CVK_HOME,CVK_END,CVK_PAGEUP,CVK_PAGEDOWN, _
					CVK_F1,CVK_F2,CVK_F4,CVK_F5,CVK_F6,CVK_F7,CVK_F8,CVK_F9,CVK_F12,_
					CVK_SHIFT_LEFT,CVK_SHIFT_RIGHT,CVK_SHIFT_UP,CVK_SHIFT_DOWN,CVK_SHIFT_HOME,CVK_SHIFT_END
					
				case CVK_UP
					
					if iReplaceParameter = 1 andalso iColumnWrite = 1 then ' если находимся в строке замены
						
						' установим флаг , что надо перейти на строку поиска 
						iColumnWrite = 0
						
						' выводим строку поиска на экран
						DrawInitFind(wsInitialFind & *pwsBufFind , pObj.iHeightRows-1 , 1)
						
						' позиция курсора сразу за строкой
						iCursor = GetLenStringWithTab(wsInitialFind & *pwsBufFind , iTabSpace)+1
						
						' позиция в строке в самом конце
						iCursorInStr = len(wsInitialFind & *pwsBufFind) +1
						
					EndIf
					
				case CVK_DOWN
					
					' если находимся в строке поиска
					if iReplaceParameter = 1 andalso iColumnWrite = 0 andalso len(*pwsBufFind) then
						
						' позиция курсора сразу строкой
						iCursor = GetLenStringWithTab(wsInitialReplace & *pwsBufReplace , iTabSpace)+1
						
						' позиция в строке в самом конце
						iCursorInStr = len(wsInitialReplace & *pwsBufReplace)+1
						
						' выводим строку замены на экран
						DrawInitFind(wsInitialReplace & *pwsBufReplace , pObj.iHeightRows , 1 , iCursor)
						
						' установим флаг , что надо перейти на строку замены 
						iColumnWrite = 1
						
					EndIf
					
				case CVK_LEFT
					
					' если курсор при перемещении не выйдет за пределы строки поиска
					if (iColumnWrite = 0 andalso iCursorInStr > len(wsInitialFind)+1) then
						
						' получим предыдущую позицию
						dim as Long iPrevPos = GetLenStringWithTab(left(wsInitialFind & *pwsBufFind , iCursorInStr-1) , iTabSpace)
						
						if iPrevPos >= len(wsInitialFind)+1 then ' если есть возможность сдвинуть курсор
							
							iCursor = iPrevPos' уменьшим позицию курсора
							
							iCursorInStr -= 1 ' уменьшим позицию в строке
							
							' выводим строку поиска на экран
							DrawInitFind(wsInitialFind & *pwsBufFind , pObj.iHeightRows-1 , 1 , iCursor)
							
						endif
						
						' если курсор при перемещении не выйдет за пределы строки замены
					elseif (iColumnWrite = 1 andalso iCursorInStr > len(wsInitialReplace)+1) then
						
						dim as Long iPrevPos = GetLenStringWithTab(left(wsInitialReplace & *pwsBufReplace , iCursorInStr-1) , iTabSpace)
						
						if iPrevPos >= len(wsInitialReplace)+1 then ' если есть возможность сдвинуть курсор
							
							iCursor = iPrevPos ' уменьшим позицию курсора						
							
							iCursorInStr -= 1 ' уменьшим позицию в строке
							
							' выводим строку замены на экран
							DrawInitFind(wsInitialReplace & *pwsBufReplace , pObj.iHeightRows , 1 , iCursor)
							
						endif
						
					EndIf
					
				case CVK_RIGHT
					
					' если курсор при перемещении не выйдет за пределы строки поиска
					if (iColumnWrite = 0 andalso iCursorInStr < len(wsInitialFind & *pwsBufFind)+1) then
						
						iCursorInStr += 1 ' увеличим позицию в строке
						
						' установим позицию курсора
						iCursor = GetTabStopPositionFromRealPosition(left(wsInitialFind & *pwsBufFind , iCursorInStr) , iCursorInStr)
						
						' выводим строку поиска на экран
						DrawInitFind(wsInitialFind & *pwsBufFind , pObj.iHeightRows-1 , 1 , iCursor)
						
						' если курсор при перемещении не выйдет за пределы строки замены
					elseif (iColumnWrite = 1 andalso iCursorInStr < len(wsInitialReplace & *pwsBufReplace)+1) then
						
						iCursorInStr += 1 ' увеличим позицию в строке
						
						iCursor = GetTabStopPositionFromRealPosition(left(wsInitialReplace & *pwsBufReplace , iCursorInStr) , iCursorInStr)
						
						' выводим строку замены на экран
						DrawInitFind(wsInitialReplace & *pwsBufReplace , pObj.iHeightRows , 1 , iCursor)
						
					EndIf
					
				case CVK_F3 ' регистр символов
					
					iCase xor=1 ' меняем регистр символов
					
					if iCase then ' если флаг регистра символов активен
						
						' поясняющая строка будет такой 
						wsInitialFind = "CASE [F3] Find: "
						
					else ' если флаг регистра символов не активен
						
						' поясняющая строка будет такой
						wsInitialFind = "NOT CASE [F3] Find: "
						
					EndIf
					
					' выводим строку поиска на экран
					DrawInitFind(wsInitialFind & *pwsBufFind , pObj.iHeightRows-1 , 1)
					
					' если находимся в строке поиска
					if (iReplaceParameter = 1 andalso iColumnWrite = 0) orelse iReplaceParameter = 0 then	
						
						' позиция курсора сразу за строкой
						iCursor = GetLenStringWithTab(wsInitialFind & *pwsBufFind , iTabSpace)+1
						
						' позиция в строке на самый конец
						iCursorInStr = len(wsInitialFind & *pwsBufFind)+1
						
					elseif iReplaceParameter = 1 andalso iColumnWrite = 1 then ' если находимся в строке замены
						
						' выводим строку замены на экран
						DrawInitFind(wsInitialReplace & *pwsBufReplace , pObj.iHeightRows , 1 , iCursor)						
						
					endif
					
				case else ' другие символы
					
					if iKey = CVK_TAB orelse iKey > 31 then ' если это текстовый символ
						#ifdef Win9x
							' преобразуем символ из OEM в UNICODE
							dim as wstring ptr pwsTemp = ASCIITOUTF(chr(iKey), w32CP_OEM)
							if pwsTemp then
								' добавим клавишу в общий буфер и выведем буфер на экран с предваряющей строкой
								ConcatKeys(pwsTemp , @wsInitialFind , pwsBufFind , @wsInitialReplace ,_
								pwsBufReplace , iColumnWrite , iCursor , iCursorInStr)
								deallocate(pwsTemp) ' освободим память
							endif
						#else
							' добавим клавишу в общий буфер и выведем буфер на экран с предваряющей строкой
							ConcatKeys(wchr(iKey) , @wsInitialFind , pwsBufFind , @wsInitialReplace ,_
							pwsBufReplace , iColumnWrite , iCursor , iCursorInStr)
						#endif
					EndIf
					
			End Select
			
		elseif pwsKeys then ' если расширенный символ
			
			' добавим клавишу в общий буфер и выведем буфер на экран с предваряющей строкой
			ConcatKeys(pwsKeys , @wsInitialFind , pwsBufFind , @wsInitialReplace ,_
			pwsBufReplace , iColumnWrite , iCursor, iCursorInStr)
			
			' освободим память для буфера клавиши
			deallocate(pwsKeys)
			
			' обнулим буфер клавиши
			pwsKeys = 0
			
		endif
		
	Loop
	
	' освободим память для ранее выделенных буферов
	deallocate(pwsBufFind)	
	deallocate(pWstrRet)	
	deallocate(pwsBufReplace)
	
	' очистим последние линии
	ClearLine(pObj.iHeightRows-1)
	ClearLine(pObj.iHeightRows)
	
End Sub