#ifdef __FB_WIN32__
	' получение клавиши в том числе юникода
	' параметры:
	' pwsSymbol - буфер для возврата символа юникода
	' iWait - задание параметра ожидания после нажатия
	function GetKeyUni(byref pwsSymbol as wstring ptr , iWait as Long = 0) as short
		
		dim as long iNumRead ' буфер , необходимый функции w32ReadConsoleInput для получения кол-ва записей
		
		dim as w32INPUT_RECORD irBuf(128) ' структура для получения данных
		
		dim as Byte bOem ' флаг , распознающий систему win9x
		
		#ifdef Win9x
			bOem = 1 ' активируем флаг OEM (для Win9x системы)
		#endif
		
		do
			
			w32ReadConsoleInput(pTConsole.hStdin, @irBuf(0), 128, @iNumRead) ' получим клавишу из буфера консоли
			
			if irBuf(0).EventType = w32KEY_EVENT then ' если в буфере клавиша
				
				if bOem = 0 andalso irBuf(0).event.KeyEvent.uChar.UnicodeChar then ' если доступен юникод символ
					
					if irBuf(0).event.KeyEvent.bKeyDown then ' если клавиша отжата
						
						' если находится в диапазоне первой половины таблицы ASCII
						if irBuf(0).event.KeyEvent.uChar.UnicodeChar < 128 then
							
							' возвратим клавишу
							return irBuf(0).event.KeyEvent.uChar.UnicodeChar
							
						EndIf
						
						' выделим память под юникод символ
						pwsSymbol = callocate(3*sizeof(wstring))
						
						if pwsSymbol then
							
							' присвоим юникод символ
							*pwsSymbol = wchr(irBuf(0).event.KeyEvent.uChar.UnicodeChar)
							
						else
							
							DrawErrorMemory() ' выводим ошибку памяти
							
						endif
						
						' вернем ноль чтобы отличать , что возможно доступен юникод символ
						return 0
						
					endif
					
				else
					
					if irBuf(0).event.KeyEvent.bKeyDown then ' если клавиша отжата
						
						select case irBuf(0).event.KeyEvent.wVirtualScanCode ' проверяем скан-код
								
							Case 29 , 56 , 42 , 54 , 58 , 68 , 87 , 70 , 91 , 530 ' все ненужные скан-коды
								
								continue do ' на начало цикла
								
							case 7
								#ifdef Win9x
									return irBuf(0).event.KeyEvent.uChar.AsciiChar ' вернем обычный символ
								#else
									return CVK_CTRL_6 ' вернем сочетание клавиши (в данный момент не используется)
								#endif
							case 82
								
								return CVK_INSERT
								
							case 71
								
								if irBuf(0).event.KeyEvent.dwControlKeyState and &h10 then
									return CVK_SHIFT_HOME
								elseif (irBuf(0).event.KeyEvent.dwControlKeyState and &h4) orelse _
									(irBuf(0).event.KeyEvent.dwControlKeyState and &h8) then
									return CVK_CTRL_HOME
								else
									return CVK_HOME
								EndIf
								
							case 73
								
								return CVK_PAGEUP
								
							case 83
								
								return CVK_DELETE
								
							case 79
								
								if irBuf(0).event.KeyEvent.dwControlKeyState and &h10 then
									return CVK_SHIFT_END
								elseif (irBuf(0).event.KeyEvent.dwControlKeyState and &h4) orelse _
									(irBuf(0).event.KeyEvent.dwControlKeyState and &h8) then
									return CVK_CTRL_END
								else
									return CVK_END
								EndIf
								
							case 81
								
								return CVK_PAGEDOWN
								
							case 72
								
								if irBuf(0).event.KeyEvent.dwControlKeyState and &h10 then
									return CVK_SHIFT_UP
								else
									return CVK_UP
								EndIf
								
							case 75
								
								if irBuf(0).event.KeyEvent.dwControlKeyState and &h10 then
									return CVK_SHIFT_LEFT
								else
									return CVK_LEFT
								EndIf
								
							case 80
								
								if irBuf(0).event.KeyEvent.dwControlKeyState and &h10 then
									return CVK_SHIFT_DOWN
								else
									return CVK_DOWN
								EndIf
								
							case 77
								
								if irBuf(0).event.KeyEvent.dwControlKeyState and &h10 then
									return CVK_SHIFT_RIGHT
								else
									return CVK_RIGHT
								EndIf
								
							case 59
								
								return CVK_F1
								
							case 60
								
								return CVK_F2
								
							case 61
								
								return CVK_F3
								
							case 62
								
								return CVK_F4
								
							case 63
								
								return CVK_F5
								
							case 64
								
								return CVK_F6
								
							case 65
								
								return CVK_F7
								
							case 66
								
								return CVK_F8
								
							case 67
								
								return CVK_F9
								
							case 88
								
								return CVK_F12                           
								
							case else ' все другие скан-коды
								
								#ifdef Win9x
									' если ASCII символ , а не нуль
									if irBuf(0).event.KeyEvent.uChar.AsciiChar then
										return irBuf(0).event.KeyEvent.uChar.AsciiChar
									else
										if iWait then ' если задан параметр ожидания клавиши (аналог GETKEY)
											
											sleep(1 , 1) ' ждем
											
										else ' если не задан параметр ожидания клавиши (аналог INKEY)
											
											exit do ' выходим из цикла
											
										EndIf									
									endif
								#else
									' если не нулевой скан-код
									if irBuf(0).event.KeyEvent.wVirtualScanCode then
										
										' вернем его
										return irBuf(0).event.KeyEvent.wVirtualScanCode
										
									else ' если скан-код нулевой
										
										if iWait then ' если задан параметр ожидания клавиши (аналог GETKEY)
											
											sleep(1 , 1) ' ждем
											
										else ' если не задан параметр ожидания клавиши (аналог INKEY)
											
											exit do ' выходим из цикла
											
										EndIf
										
									EndIf 
								#endif                       
								
						End Select
						
					endif
					
				endif
				
			else
				
				if iWait = 0 then ' если не задан параметр ожидания 
					
					exit do
					
				EndIf
				
			endif
			
		Loop
		
	End Function
	
#endif

#ifdef __UNIX_SYSTEM__
	
	' Процедура для замены некоторых данных клавиш
	' используется при работе в TTY консоли
	' к сожалению нет стандартизации по клавишам для разных видов терминалов
	sub ReDefineKeysForTtyLinux()
		
		Customkeys(0).b(0) = 91 : Customkeys(0).b(1) = 49 : Customkeys(0).b(2) = 126 : Customkeys(0).b(3) = 0' home
		Customkeys(1).b(0) = 91 : Customkeys(1).b(1) = 52 : Customkeys(1).b(2) = 126 : Customkeys(1).b(3) = 0' end
		Customkeys(5).b(0) = 91 : Customkeys(5).b(1) = 68 ' left
		Customkeys(6).b(0) = 91 : Customkeys(6).b(1) = 67 ' right
		Customkeys(7).b(0) = 91 : Customkeys(7).b(1) = 65 ' up
		Customkeys(8).b(0) = 91 : Customkeys(8).b(1) = 66 ' down
		Customkeys(10).b(0) = 91 : Customkeys(10).b(1) = 91 : Customkeys(10).b(2) = 65 : Customkeys(10).b(3) = 0 ' F1
		Customkeys(11).b(0) = 91 : Customkeys(11).b(1) = 91 : Customkeys(11).b(2) = 66 : Customkeys(11).b(3) = 0 ' F2
		Customkeys(12).b(0) = 91 : Customkeys(12).b(1) = 91 : Customkeys(12).b(2) = 67 : Customkeys(12).b(3) = 0 ' F3
		Customkeys(13).b(0) = 91 : Customkeys(13).b(1) = 91 : Customkeys(13).b(2) = 68 : Customkeys(13).b(3) = 0 ' F4			
		Customkeys(14).b(0) = 91 : Customkeys(14).b(1) = 91 : Customkeys(14).b(2) = 69 : Customkeys(14).b(3) = 0 ' F5				
		
	End Sub
	
	' Инициализация терминала , чтобы без труда ловить
	' некоторые клавиши , которые не ловят стандартные Inkey\GetKey
	sub Init_Custom_Keys()
		
		dim as termios nt ' переменная для настроек терминала
		
		tty_fd = open_("/dev/tty", O_RDONLY) ' откроем устройство для чтения
		
		tcgetattr(0 , @save_stdin) ' получим текущие настройки
		
		nt = save_stdin ' скопируем данные
		
		#ifdef __FB_LINUX__
			nt.c_iflag and= not(ICRNL or IGNCR or IXON or IXOFF) ' поменяем некоторые флаги
			nt.c_lflag and= not(ISIG or ECHO or ICANON) ' поменяем некоторые флаги
		#EndIf
		#ifdef __FB_freebsd__
			nt.c_iflag = &b100000000000010 ' поменяем некоторые флаги
			nt.c_lflag = &b1000101000110000 ' поменяем некоторые флаги			
		#EndIf
		
		tcsetattr(0 , TCSANOW , @nt) ' заменим настройки терминала
		
		' не блокирующий режим
		if fcntl(tty_fd , F_SETFL , O_NDELAY) = -1 then end
		
		' если это TTY консоль (не графический терминал)
		if *getenv("TERM") = "linux" then
			
			ReDefineKeysForTTYLinux() ' переназначим некоторые клавиши
			
		EndIf
		
	End Sub
	
	' Возврат настроек терминала , которые были до запуска редактора
	sub DeInit_Custom_Keys()
		
		' вернем настройки
		tcsetattr(tty_fd , TCSANOW , @save_stdin)
		' отключим неблокирующий режим
		fcntl(tty_fd , F_SETFL , 0)
		
	End Sub
	
	' Процедура для отлова сырых данных клавиш
	function CustomInkey() as short
		
		dim as Ubyte bBuf ' буфер для одного сканкода
		
		dim as zstring*20 szBuf ' буфер для цепочки байт клавиши
		
		dim as Long iCount ' размер полученных кодов
		
		dim as Long iIndex ' смещение в строке szBuf
		
		iCount = read_(tty_fd , @bBuf , 1) ' получим первый сканкод
		
		if iCount > 0 then ' если что-то получили
			
			select case bBuf ' смотрим что получили
					
				Case 10 ' если символ перевода строки
					
					return 13 ' вернем как будто нажата ENTER
					
				case 127 ' если символ удаления
					
					return 8 ' вернем как будто это клавиша BackSpace
					
				case 27 ' если символ начала управляющих последовательностей
					
					while read_(tty_fd , @bBuf , 1) > 0 ' читаем пока можно
						
						szBuf[iIndex] = bBuf ' сохраняем в буфере строки
						
						iIndex+=1 ' увеличиваем индекс для строки
						
					Wend
					
					if len(szBuf) then ' если действительно это управляющие последовательности
						
						' проходим по всему массиву Customkeys
						for i as Long = 0 to ubound(Customkeys)
							
							' если клавиша найдена , то есть совпала
							if *cast(zstring ptr , @(Customkeys(i).B(0))) = szBuf then
								
								' вернем ее сканкод
								return Customkeys(i).shKey
								
							EndIf
							
						Next
						
					else ' если только один символ 27
						
						return bBuf ' вернем как будто клавиша ESC
						
					EndIf
					
				case else ' остальные случаи (одиночные сканкоды)
					
					return bBuf ' вернем как есть
					
			End Select
			
		EndIf
		
	End function
	
	function GetKeyUni(byref pwsSymbol as wstring ptr , iWait as Long = 0) as short
		
		dim as UTF8STRUCT tUtf8 ' структура для хранения отдельных байтов UTF8 последовательности
		
		dim as Short iInkey 'буфер для хранения клавиши
		
		dim as long iCounterKeys ' кол-во символов в UTF8 последовательности
		
		for i as Long = 1 to 4 ' цикл на максимальное кол-во байт в UTF8 последовательности
			
			if iWait then ' если задан параметр ожидания после нажатия
				
				iInkey = GetKey ' используем GETKEY для получения клавиши
				
			else ' если параметр ожидания после нажатия не задан
				
				iInkey = CustomInkey()
				
			EndIf
			
			' если получаем расширенную клавишу (не латиница) , имеющую последовательность из 2 байтов 
			if iCounterKeys = 0 andalso iInkey > &hc1 andalso iInkey < &he0 then
				
				iCounterKeys = 2 ' ставим счетчик равный 2
				
				tUtf8.b1 = iInkey ' заносим байт в первое поле структуры
				
				' если получаем расширенную клавишу (не латиница) , имеющую последовательность из 3 байтов
			elseif iCounterKeys = 0 andalso iInkey > &hdf andalso iInkey < &hf0 then
				
				iCounterKeys = 3 ' ставим счетчик равный 3
				
				tUtf8.b1 = iInkey ' заносим байт в первое поле структуры
				
				' если получаем расширенную клавишу (не латиница) , имеющую последовательность из 4 байтов	
			elseif iCounterKeys = 0 andalso iInkey > &hef andalso iInkey < &hf5 then
				
				iCounterKeys = 4 ' ставим счетчик равный 4
				
				tUtf8.b1 = iInkey ' заносим байт в первое поле структуры		
				
				' если последовательность из 2 байтов
			elseif iCounterKeys = 2 then
				
				tUtf8.b2 = iInkey ' заносим байт во второе поле структуры
				
				exit for ' выходим из цикла
				
				' если последовательность из 3 байтов	
			elseif iCounterKeys = 3 then
				
				if i = 2 then
					
					tUtf8.b2 = iInkey ' заносим байт во второе поле структуры
					
				elseif i = 3 then
					
					tUtf8.b3 = iInkey ' заносим байт в третье поле структуры
					
					exit for ' выходим из цикла
					
				EndIf
				
				' если последовательность из 4 байтов	
			elseif iCounterKeys = 4 then
				
				if i = 2 then
					
					tUtf8.b2 = iInkey ' заносим байт во второе поле структуры
					
				elseif i = 3 then
					
					tUtf8.b3 = iInkey ' заносим байт в третье поле структуры
					
				elseif i = 4 then
					
					tUtf8.b4 = iInkey ' заносим байт в четвертое поле структуры
					
				EndIf		
				
			else ' если это латиница или не текстовая клавиша
				
				return iInkey ' возвращаем как есть
				
			EndIf
			
		next
		
		if iCounterKeys then ' если была получена расширенная клавиша
			
			dim as zstring*5 s ' определяем буфер для 4 байт
			
			fb_memcopy(s , tUtf8 , iCounterKeys) ' копируем в буфер байты из структуры
			
			pwsSymbol = Utf8tounicode(s) ' преобразуем буфер в юникод
			
		EndIf
		
	End Function
#EndIf

#ifdef __FB_DOS__
	
	' получение клавиши
	' параметры:
	' pwsSymbol - буфер для возврата символа юникода (не используется в дос)
	' iWait - задание параметра ожидания после нажатия (всегда ждет клавиши в дос)
	function GetKeyUni(byref pwsSymbol as wstring ptr , iWait as Long = 0) as short
		
		dim as Long iBK
		
		dim as Long iC = getch() ' получим саму клавишу
		
		if iC = 0 then ' если расширенная клавиша  (в FB вариант if iC = 0 orelse iC = &he0 then . Пока не знаю зачем это надо.)
			
			iBK = bioskey(&h12) ' пробуем получить сигнал о клавишах SHIFT
			
			' получим вторую половинку и
			' объединим так , как это делают стандартные функции FB
			iC = (getch() shl 8) or &hff
			
		EndIf
		
		if iBK and 3 then ' если клавиша SHIFT нажата
			
			' какую клавишу получили в буфер
			' если одну из нужным нам сочетаний с клавишей SHIFT
			' то вернем нужный нам результат
			select case iC 
					
				Case CVK_LEFT ' left
					return CVK_SHIFT_LEFT ' SHIFT+LEFT
				case CVK_RIGHT ' right
					return CVK_SHIFT_RIGHT ' SHIFT+RIGHT
				case CVK_UP ' up
					return CVK_SHIFT_UP ' SHIFT+UP
				case CVK_DOWN ' down
					return CVK_SHIFT_DOWN ' SHIFT+DOWN
				case CVK_HOME ' home
					return CVK_SHIFT_HOME ' SHIFT+HOME
				case CVK_END ' end
					return CVK_SHIFT_END ' SHIFT+END
				case else
					return iC ' вернем оригинал
			End Select
			
		elseif iBK and &b10100000000 then ' если CTRL
			
			select case iC
					
				case 30719 'CVK_HOME
					
					return CVK_CTRL_HOME
					
				case 30207 'CVK_END
					
					return CVK_CTRL_END
					
				case 29695 'ctrl+left
					
					return CVK_LEFT
					
				case 29951 'ctrl+right
					
					return CVK_RIGHT
					
				case 30463,34047 'ctrl+PGDOWN,PGUP
					
					return 0
					
				case else
					
					return iC
					
			end select
			
		else
			
			return iC ' вернем клавишу
			
		EndIf
		
	End Function
	
#EndIf

' процедура ожидания любой нажатой клавиши
' sleep в данном случае работает плохо , поэтому так 
sub GetAnyKey()
	
	dim as wstring ptr pwsSymbol ' буфер для символа юникода
	
	' просто поулчаем любую клавишу
	dim as Long iKey = GetKeyUni(pwsSymbol , 1) ' получим обычный или юникод символ
	
	if pwsSymbol then ' если получили символ юникода
		
		' освободим память для буфера клавиши
		deallocate(pwsSymbol)
		
	EndIf
	
End Sub

' получение любого символа кроме юникода
function GetOnlyAscKey() as LONG
	
	do
		
		dim as wstring ptr pwsSymbol ' буфер для символа юникода
		
		' просто получаем любую клавишу
		dim as Long iKey = GetKeyUni(pwsSymbol , 1) ' получим обычный или юникод символ
		
		if pwsSymbol then ' если получили символ юникода
			
			' освободим память для буфера клавиши
			deallocate(pwsSymbol)
			
		elseif iKey then ' если получили любой другой символ
			
			return iKey ' возвратим его
			
		EndIf
		
	loop
	
End Function
