sub LoadSetting()

	pObj.iFlagHighlight = 0 ' подсветка выключена
	
	iTabSpace = 4 ' размер табуляции
	
	pObj.iColorBackGround = 0 ' цвет фона
	
	pObj.iColorNumbersFore = 2 ' цвет текста для номеров строк
	
	pObj.iColorSelection = 1 ' цвет для выделение
	
	pObj.iColorStatusBar = 3 ' цвет статусбара
	
	pObj.iColorFindWord = 1 ' цвет выделения слова при поиске
	
	pObj.iColorText = 15 ' цвет основного текста
	
	pObj.iColorWarning = 2 ' цвет предупреждений
	
	pObj.iColorFolders = 3 ' цвет папок при перечислении
	
	pObj.iColorFiles = 15 ' цвет файлов при перечислении
	
	pObj.iColorKeyWords = 10 ' подсветка ключевых слов
	
	pObj.iColorComments = 6 ' подсветка комментариев
	
	pObj.iColorStrings = 14 ' подсветка строковых литералов
	
	dim as string sFile
	
	#ifdef __UNIX_SYSTEM__
		
		dim as zstring ptr pszUserName = getenv("HOME")
		
		if pszUserName andalso len(*pszUserName) then
			
			sFile = *pszUserName & "/" & "cedit.ini"
			
		else
		
			sFile = exepath & "/cedit.ini"
			
		EndIf
		
	#else
	
		sFile = exepath & "\cedit.ini"
		
	#EndIf
	
	dim as File ptr fp

	fp = File_Open(sFile , 0) ' открываем файл для чтения
	
	If fp = 0 Then ' если файл открыт неудачно
		
		' пробуем сохранить файл настроек
		
		fp = File_Open(sFile) ' открываем файл
		
		If fp = 0 Then ' если файл открыт неудачно
			
			exit sub ' выходим
			
		else ' файл создали , теперь запишем в него настройки

			dim as string sBuf = "# highlight may be 0 (off) or 1 (on)" & sCHR10 & _
			"highlight = 0" & sCHR10 & _
			" "  & sCHR10 & _
			"tabsize = 4" & sCHR10 & _
			" "  & sCHR10 & _			
			"# ***********colors*************"  & sCHR10 & _
			"# 0 black"  & sCHR10 & _
			"# 1 blue"  & sCHR10 & _
			"# 2 green"  & sCHR10 & _
			"# 3 cyan"  & sCHR10 & _
			"# 4 red"  & sCHR10 & _
			"# 5 pink"  & sCHR10 & _
			"# 6 yellow"  & sCHR10 & _
			"# 7 grey"  & sCHR10 & _
			"# 8 dark grey"  & sCHR10 & _
			"# 9 bright blue"  & sCHR10 & _
			"# 10 bright green"  & sCHR10 & _
			"# 11 bright cyan"  & sCHR10 & _
			"# 12 bright red"  & sCHR10 & _
			"# 13 bright pink"  & sCHR10 & _
			"# 14 bright yellow"  & sCHR10 & _
			"# 15 white"  & sCHR10 & _
			" "  & sCHR10 & _
			"colorbackground = 0"  & sCHR10 & _
			"colornumbersfore = 2"  & sCHR10 & _
			"colorselection = 1"  & sCHR10 & _
			"colorstatusbar = 3"  & sCHR10 & _
			"colorfindword = 1"  & sCHR10 & _
			"colortext = 15"  & sCHR10 & _
			"colorwarning = 2"  & sCHR10 & _
			"colorfolders = 3"  & sCHR10 & _
			"colorfiles = 15"  & sCHR10 & _
			"colorkeywords = 10"  & sCHR10 & _
			"colorcomments = 6"  & sCHR10 & _
			"colorstrings = 14"
		
			' положим настройки в файл
			File_Write_Data(fp , strptr(sBuf) , len(sBuf))
			
			File_Close(fp) ' закроем файл
			
		EndIf
		
	else ' файл настроек был найден
	
		dim as string sBuf ' общий буфер для полученной строки
		dim as string sPart1 ' левая часть перед знаком =
		dim as string sPart2 ' правая часть после знака =
	
		Do Until FILE_EOF(fp) ' читаем файл до конца
			
			' получим строку
			sBuf = File_Read_String(fp)
			
			if len(sBuf) then ' если строка
				
				if left(trim(sBuf , any chr(32) & chr(9)) , 1) = "#" then ' комментарий
					
					continue do ' пропускаем
					
				EndIf
				
				dim as Long iFind = instr(sBuf , "=") ' ищем маркер присваивания
				
				if iFind then ' если найден
					
					sPart1 = lcase(trim(left(sBuf , iFind-1))) ' сохраняем левую часть
					
					sPart2 = trim(mid(sBuf , iFind+1)) ' сохраняем правую часть
					
				else
				
					continue do ' пропускаем
					
				EndIf
				
				dim as Long iParam = val(sPart2) ' строку правой части переводим в число
					
				select case sPart1 ' смотрим что в левой части
					
					' различные параметры
					
					Case "highlight"
						
						pObj.iFlagHighlight = iParam
						
					case "tabsize"
					
						iTabSpace = iParam
						
					case "colorbackground"
					
						pObj.iColorBackGround = iParam
					
					case "colornumbersfore"
					
						pObj.iColorNumbersFore = iParam
					
					case "colorselection"
					
						pObj.iColorSelection = iParam
					
					case "colorstatusbar"
					
						pObj.iColorStatusBar = iParam
					
					case "colorfindword"
					
						pObj.iColorFindWord = iParam
					
					case "colortext"
						
						pObj.iColorText = iParam
						
					case "colorwarning"
					
						pObj.iColorWarning = iParam
					
					case "colorfolders"
					
						pObj.iColorFolders = iParam
					
					case "colorfiles"
					
						pObj.iColorFiles = iParam
					
					case "colorkeywords"
					
						pObj.iColorKeyWords = iParam
					
					case "colorcomments"
					
						pObj.iColorComments = iParam
					
					case "colorstrings"
					
						pObj.iColorStrings = iParam
					
				End Select
				
			EndIf
			
		loop
		
		File_Close(fp) ' закрываем файл
		
	EndIf
	
End Sub