#ifdef __UNIX_SYSTEM__
	extern "C"	
		declare function wcwidth(as long) as Long
	End Extern
#EndIf

dim shared as Long iLocaleWideSupport

type TSymbolSpaces
	
	j1 as LONG
	
	j2 as Long
	
End Type

dim shared as TSymbolSpaces tSymbolSpacesWide(...) => {_
(&h1100 , &h115F) , (&h231A , &h231B) , (&h2329 , &h232A) , (&h23E9 , &h23EC) , (&h23F0 , &h23F0) ,_
(&h23F3 , &h23F3) , (&h25FD , &h25FE) , (&h2614 , &h2615) , (&h2648 , &h2653) , (&h267F , &h267F) ,_
(&h2693 , &h2693) , (&h26A1 , &h26A1) , (&h26AA , &h26AB) , (&h26BD , &h26BE) , (&h26C4 , &h26C5) ,_
(&h26CE , &h26CE) , (&h26D4 , &h26D4) , (&h26EA , &h26EA) , (&h26F2 , &h26F3) , (&h26F5 , &h26F5) ,_
(&h26FA , &h26FA) , (&h26FD , &h26FD) , (&h2705 , &h2705) , (&h270A , &h270B) , (&h2728 , &h2728) ,_
(&h274C , &h274C) , (&h274E , &h274E) , (&h2753 , &h2755) , (&h2757 , &h2757) , (&h2795 , &h2797) ,_
(&h27B0 , &h27B0) , (&h27BF , &h27BF) , (&h2B1B , &h2B1C) , (&h2B50 , &h2B50) , (&h2B55 , &h2B55) ,_
(&h2E80 , &h2E99) , (&h2E9B , &h2EF3) , (&h2F00 , &h2FD5) , (&h2FF0 , &h2FFB) , (&h3000 , &h3029) ,_
(&h302E , &h303E) , (&h3041 , &h3096) , (&h309B , &h30FF) , (&h3105 , &h312E) , (&h3131 , &h318E) ,_
(&h3190 , &h31BA) , (&h31C0 , &h31E3) , (&h31F0 , &h321E) , (&h3220 , &h32FE) , (&h3300 , &h4DB5) ,_
(&h4DC0 , &h9FEA) , (&hA000 , &hA48C) , (&hA490 , &hA4C6) , (&hA960 , &hA97C) , (&hAC00 , &hD7A3) ,_
(&hF900 , &hFA6D) , (&hFA70 , &hFAD9) , (&hFE10 , &hFE19) , (&hFE30 , &hFE52) , (&hFE54 , &hFE66) ,_
(&hFE68 , &hFE6B) , (&hFF01 , &hFF60) , (&hFFE0 , &hFFE6)}

' получение ширины знакоместа в консоли
function GetWidthSymbol(iwChar as Long) as long
	
	#ifdef __FB_WIN32__
		
		#ifdef Win9x
			return 1
		#EndIf
		
		if iLocaleWideSupport then
		
			if iwChar < &h300 then return 1
			
			' ищем в цикле совпадение по диапазонам с двумя знакоместами
			for i as Long  = 0 to Ubound(tSymbolSpacesWide)
				
				if iwChar >= tSymbolSpacesWide(i).j1 andalso iwChar <= tSymbolSpacesWide(i).j2 then
					
					return 2
					
				EndIf
				
			Next
		
		endif
		
		return 1
	
	#endif
	
	#ifdef __UNIX_SYSTEM__
		
		dim as Long iRet = wcwidth(iwChar) ' получим ширину символа
		
		' для того , чтобы не сбивала подсчеты , даже неудачное определение ширины классифицируем как один символ
		if iRet = -1 then return 1
		
		return iRet		
		
	#EndIf
	
	#ifdef __FB_DOS__
	
		return 1 ' в досе ширина всегда равна единице
		
	#endif
	
End function

' Функция взята из моей библиотеки window9 для замены подстрок в строке: https://sourceforge.net/projects/guiwindow9/
Function replacestring (Byval sString As String, Byval sSearchStr As String, Byval sReplaceStr As String, Byval iPosition As Integer = 1 , Byval iSearchParam As Integer = 0 ) As String
	
	Dim As String szTempString , sReturnString = sString
	
	Dim As Long iPosSearch, iPosSearchNext = iPosition, iPos0 = 1
	
	Do
		
		iPosSearch = Instr(iPosSearchNext , sReturnString , sSearchStr)
		
		If iPosSearch<>0 Then
			
			szTempString = Mid(sReturnString , iPos0 , iPosSearch - 1 ) & sReplaceStr & Mid(sReturnString , iPosSearch + Len(sSearchStr))
			
			If iSearchParam = 1 Then
				
				sReturnString = szTempString
				
				iPosSearchNext = iPosSearch + Len(sReplaceStr)
				
			Else
				
				Return szTempString
				
			End If
			
		Else
			
			Return sReturnString
			
		End If
		
	Loop
	
End Function

' получение длины строки с учетом табуляции , преобразованной в пробелы
function GetLenStringWithTab(w as wstring ptr , iTabSpace as Long , iStart as Long = 1  , iLen as Long = -1) as LONG
	
	dim as Long j  , iTLen = len(*w)
	
	' проверим и при необходимости ограничим длину
	if iLen = -1 then
		
		iLen = iTLen
		
	elseif iLen > iTLen then
	
		iLen = iTLen
		
	EndIf
	
	for i as Long = iStart-1 to iLen-1 ' проходим по всей строке
		
		if (*w)[i] = 9 then ' если TAB
			
			j+=1 ' увеличим счетчик для табуляции
			
			' пока не будет равно сегменту , равному длине табуляции
			while (j mod iTabSpace <> 0)
				
				j+=1 ' увеличим счетчик для табуляции
				
			Wend
			
		else ' любой другой символ
			
			dim as Long iTs = GetWidthSymbol((*w)[i])
			
			if iTs = 2 then
				
				j+=2 ' увеличим счетчик для табуляции
				
			elseif iTs = 1 then
			
				j+=1 ' увеличим счетчик для табуляции
				
			EndIf
			
		endif
		
	Next
	
	return j ' вернем длину
	
End Function

' преобразование строки с табуляцией в строку с пробелами
function ReplaceTabToSpace(pws as wstring ptr, iTabSpace as Long) as wstring ptr
	
	dim as Long j , j2 , iLen = len(*pws) , iLen2
	
	if iLen then ' если строка не пустая
		
		' подсчитаем кол-во табуляций и сохраним в iLen2
		for i as Long = 0 to iLen-1
			
			if (*pws)[i] = 9 then ' если TAB
				
				iLen2 += 1 ' увеличим счетчик
				
			EndIf
			
		Next
		
	endif
	
	if iLen2 = 0 then ' если табуляций нет
		
		dim as wstring ptr p = callocate((iLen+1)*sizeof(wstring))
		
		if p then
			
			*p = *pws ' копируем оригинальную строку
			
		else
		
			DrawErrorMemory() ' выводим ошибку памяти
			
		EndIf
		
		return p ' вернем копию строки или нуль если ошибка выделения памяти
		
	EndIf
	
	' выделим память для буфера с запасом
	dim as wstring ptr pwsRet = callocate((1+iLen+(iLen2*iTabSpace))*sizeof(wstring))
	
	if pwsRet then
	
		for i as Long = 0 to len(*pws)-1 ' проходим по всей строке
			
			if (*pws)[i] = 9 then ' если TAB
				
				(*pwsRet)[j] = 32 ' заменим первый байт
				
				j+=1 ' увеличим счетчик для смещения
				
				j2+=1 ' увеличим счетчик для табуляции
				
				' пока не будет равно сегменту , равному длине табуляции
				while (j2 mod iTabSpace <> 0) 
					
					(*pwsRet)[j] = 32 ' заменим следующий байт
					
					j+=1 ' увеличим счетчик для смещения
					
					j2+=1 ' увеличим счетчик для табуляции
					
				Wend
				
			else ' любой другой символ
				
				(*pwsRet)[j] = (*pws)[i] ' просто присваиваем символ
				
				j+=1 ' увеличим счетчик
				
				dim as Long iTs = GetWidthSymbol((*pws)[i])
				
				if iTs = 2 then
					
					j2+=2 ' увеличим счетчик для табуляции
					
				elseif iTs = 1 then
				
					j2+=1 ' увеличим счетчик для табуляции
					
				EndIf
				
			endif
			
		Next
		
		(*pwsRet)[j+1] = 0 ' добавим символ нуля в конце
		
		return pwsRet ' вернем указатель
		
	else
	
		DrawErrorMemory() ' выводим ошибку памяти
	
	endif
	
End Function

' возвращает реальную позицию на экране из позиции буфера строки
function GetTabStopPositionFromRealPosition(pwsTempString as wstring ptr , iReal as Long) as LONG
	
	if pwsTempString then ' если указатель валидный
		
		dim as long j ' счетчик
		
		' проходим строку до нужной позиции
		for i as Long = 0 to iReal-2
			
			if (*pwsTempString)[i] = 9 then ' если TAB
				
				j+=1 ' увеличим счетчик
				
				' пока не будет равно сегменту , равному длине табуляции
				while (j mod iTabSpace <> 0)
					
					j+=1 ' увеличим счетчик
					
				Wend
				
			else
				
				dim as long iTs = GetWidthSymbol((*pwsTempString)[i])
				
				if iTs = 2 then
					
					j+=2 ' увеличим счетчик
					
				elseif iTs = 1 then
				
					j+=1 ' увеличим счетчик
					
				EndIf
				
			endif
			
		Next
		
		return j+1 ' вернем позицию
		
	endif
	
End Function

' подсчет символов в буфере c размерностью каждой ячейки SHORT
'нужен для сохранения строк комментариев в DOS , поскольку в этой системе
'тип WSTRING = 1 байт. А для хранения номеров строк нужен размер в 2 байта 
'То есть эта функция как будто симулирует функцию LEN и тип WSTRING под Windows
'параметр:
'pBuf - буфер с номерами строк
function LenShortBuf(pBuf as Short ptr) as LONG
	
	if pBuf then ' если указатель валидный
		
		for i as Long = 0 to &hFFFF ' буфер не может быть больше чем &hFFFF
			
			if pBuf[i] = 0 then ' если нашли символ окончания строки
				
				return i ' вернем длину строки
				
			EndIf
			
		Next
		
	EndIf
	
End Function