#ifdef __FB_LINUX__
	#define __UNIX_SYSTEM__
#EndIf
#ifdef __FB_FREEBSD__
	#define __UNIX_SYSTEM__
#EndIf

' связный список взят из моей библиотеки FreeBasic containers: https://sourceforge.net/projects/freebasic-containers/

dim shared as Long iTabSpace
declare function GetLenStringWithTab(w as wstring ptr , iTabSpace as Long , iStart as Long = 1  , iLen as Long = -1) as LONG
declare sub DrawErrorMemory()

Type WSTRPTR AS wstring ptr

Type TLISTNODEWSTRPTR
	
	xValue As WSTRPTR
	
	iLen as Long
	
	pPrev As TLISTNODEWSTRPTR Ptr =0
	
	pNext As TLISTNODEWSTRPTR Ptr =0
	
End Type

Type TLISTWSTRPTR
	
	pFirst As TLISTNODEWSTRPTR Ptr =0
	
	pLast As TLISTNODEWSTRPTR Ptr =0
	
	pCurent As TLISTNODEWSTRPTR Ptr =0
	
	iSize As Long =0
	
	iCurentIndex As Long
	
	Declare Destructor()
	
	Declare Sub Add(xValue As WSTRPTR)
	
	Declare Sub InsertItemIndex(iIndex As Long , xValue As WSTRPTR)
	
	Declare Sub InsertItem(pItem As TLISTNODEWSTRPTR Ptr, xValue As WSTRPTR, iIndex As Long =-1)
	
	Declare Sub DeleteItemIndex(iIndex As Long)
	
	Declare Sub DeleteItem(pItem As TLISTNODEWSTRPTR Ptr)
	
	Declare Sub DeleteAll()
	
	Declare Sub SetValueIndex(iIndex As Long , xValue As WSTRPTR)
	
	Declare Function GetSize() As Long
	
	Declare Function GetValueIndex(iIndex As Long) As WSTRPTR
	
	Declare Sub SetCurent(iIndex As Long)
	
	declare Function GetValueLenIndex(iIndex As Long) As Long
	
End Type

Destructor TLISTWSTRPTR()
	
	DeleteAll()
	
End Destructor

Sub TLISTWSTRPTR.Add(xValue As WSTRPTR)
	
	Dim As TLISTNODEWSTRPTR Ptr pTemp =New TLISTNODEWSTRPTR
	
	if pTemp then
		
		if xValue then
			
			pTemp->iLen = len(*xValue)
			
			dim as Wstring ptr p = callocate((pTemp->iLen+1)*sizeof(wstring))
			
			if p then
				
				*p = *xValue
				
				pTemp->xValue = p
				
			else
			
				DrawErrorMemory() ' выводим ошибку памяти
				
			endif
			
		else
			
			dim as Wstring ptr p = callocate(1*sizeof(wstring))
			
			pTemp->xValue = p
			
			pTemp->iLen = 0
			
		EndIf
		
		If pFirst =0 Then
			
			pFirst =pTemp
			
			pLast =pTemp
			
		Else
			
			pLast->pNext =pTemp
			
			pTemp->pPrev =pLast
			
			pLast =pTemp
			
		Endif
		
		pCurent =pLast
		
		iCurentIndex =iSize
		
		iSize+=1
		
	else
	
		DrawErrorMemory() ' выводим ошибку памяти
		
	endif
	
End Sub

Sub TLISTWSTRPTR.InsertItemIndex(iIndex As Long , xValue As WSTRPTR)
	
	If pFirst =0 Orelse iIndex >= iSize Then
		
		This.Add(xValue)
		
		Exit Sub
		
	Endif
	
	If iIndex <0 Then
		
		Exit Sub
		
	Endif
	
	SetCurent(iIndex)
	
	InsertItem(pCurent , xValue , iIndex)
	
End Sub

Sub TLISTWSTRPTR.InsertItem(pItem As TLISTNODEWSTRPTR Ptr, xValue As WSTRPTR , iIndex As Long =-1)
	
	If pFirst =0 Orelse pItem =0 Then
		
		This.Add(xValue)
		
		Exit Sub
		
	Endif
	
	Dim As TLISTNODEWSTRPTR Ptr pTemp =New TLISTNODEWSTRPTR
	
	if pTemp then
		
		if xValue then
			
			pTemp->iLen = len(*xValue)
			
			dim as Wstring ptr p = callocate((pTemp->iLen+1)*sizeof(wstring))
			
			if p then
				
				*p = *xValue
				
				pTemp->xValue = p
				
			else
			
				DrawErrorMemory() ' выводим ошибку памяти
				
			endif
			
		else
			
			dim as Wstring ptr p = callocate(1*sizeof(wstring))
			
			pTemp->xValue = p
			
			pTemp->iLen = 0
			
		EndIf
		
		If pItem =pFirst Then
			
			pTemp->pNext =pFirst
			
			pFirst->pPrev =pTemp
			
			pFirst =pTemp
			
		Else
			
			pTemp->pNext =pItem
			
			pTemp->pPrev =pItem->pPrev
			
			pItem->pPrev->pNext =pTemp
			
			pItem->pPrev =pTemp
			
		Endif
		
		If iIndex =-1 Then
			
			pCurent =pFirst
			
			iCurentIndex =0
			
		Else
			
			pCurent =pTemp
			
			iCurentIndex =iIndex
			
		Endif
		
		iSize+=1
		
	else
	
		DrawErrorMemory() ' выводим ошибку памяти
		
	endif
	
End Sub

Sub TLISTWSTRPTR.DeleteItemIndex(iIndex As Long)
	
	If pFirst =0 Orelse iIndex >= iSize Orelse iIndex <0 Orelse iSize =0 Then
		
		Exit Sub
		
	Endif
	
	SetCurent(iIndex)
	
	DeleteItem(pCurent)
	
End Sub

Sub TLISTWSTRPTR.DeleteItem(pItem As TLISTNODEWSTRPTR Ptr)
	
	If pItem =0 Orelse iSize =0 Then
		
		Exit Sub
		
	Endif
	
	If pItem = pFirst Then
		
		pFirst = pFirst->pNext
		
		If pFirst Then
			
			pFirst->pPrev =0
			
		Endif
		
		If pItem =pLast Then
			
			pLast =pFirst
			
		Endif
		
	Elseif pItem =pLast Then
		
		pLast =pLast->pPrev
		
		pLast->pNext =0
		
	Else
		
		pItem->pPrev->pNext =pItem->pNext
		
		pItem->pNext->pPrev =pItem->pPrev
		
	Endif
	
	if pItem->xValue then 
		
		deallocate (pItem->xValue)
		
		pItem->xValue = 0
		
	EndIf
	
	Delete pItem
	
	iSize -=1
	
	If iSize =0 Then
		
		pFirst =0
		
		pLast =0
		
		pCurent =0
		
		iCurentIndex =0
		
	Else
		
		pCurent =pFirst
		
		iCurentIndex =0
		
	Endif
	
End Sub

Sub TLISTWSTRPTR.DeleteAll()
	
	Dim As TLISTNODEWSTRPTR Ptr pDel , pTemp =pFirst
	
	While pTemp
		
		pDel =pTemp
		
		pTemp =pTemp->pNext
		
		if pDel->xValue then deallocate (pDel->xValue)
		
		Delete pDel
		
	Wend
	
	iSize =0
	
	pFirst =0
	
	pLast =0
	
	pCurent =0
	
	iCurentIndex =0
	
End Sub

Sub TLISTWSTRPTR.SetValueIndex(iIndex As Long , xValue As WSTRPTR)
	
	If pFirst =0 Orelse iIndex >= iSize Orelse iIndex <0 Orelse iSize =0 Then
		
		Exit Sub
		
	Endif
	
	SetCurent(iIndex)
	
	if pCurent->xValue then 
		
		deallocate (pCurent->xValue)
		
		pCurent->xValue = 0
		
	EndIf
	
	if xValue then
		
		pCurent->iLen = len(*xValue)
		
		dim as Wstring ptr p = callocate((pCurent->iLen+1)*sizeof(wstring))
		
		if p then
			
			*p = *xValue
			
			pCurent->xValue = p
			
		else
		
			DrawErrorMemory() ' выводим ошибку памяти
			
		endif
		
	else
		
		dim as Wstring ptr p = callocate(1*sizeof(wstring))
		
		pCurent->xValue = p
		
		pCurent->iLen = 0
		
	EndIf
	
End Sub

Function TLISTWSTRPTR.GetSize() As Long
	
	Return iSize
	
End Function

Function TLISTWSTRPTR.GetValueIndex(iIndex As Long) As WSTRPTR
	
	If iIndex <0 Orelse iIndex >= iSize Orelse pFirst =0 Then
		
		Exit Function
		
	Endif
	
	SetCurent(iIndex)
	
	Return pCurent->xValue
	
End Function

Function TLISTWSTRPTR.GetValueLenIndex(iIndex As Long) As Long
	
	If iIndex <0 Orelse iIndex >= iSize Orelse pFirst =0 Then
		
		Exit Function
		
	Endif
	
	SetCurent(iIndex)
	
	Return pCurent->iLen
	
End Function

Sub TLISTWSTRPTR.SetCurent(iIndex As Long)
	
	If iCurentIndex =iIndex Then Exit Sub
	
	Dim As Long iE =iSize-iIndex-1
	
	Dim As Long iC =Abs(iCurentIndex -iIndex)
	
	Dim As Long iStep =1
	
	If iE <iIndex Then
		
		iStep =-1
		
	Else
		
		iE =iIndex
		
	Endif
	
	If iE <iC Then
		
		If iStep =1 Then
			
			pCurent =pFirst
			
			For i As Long =0 To iIndex-1
				
				pCurent =pCurent->pNext
				
			Next
			
		Else
			
			pCurent =pLast
			
			For i As Long =iSize To iIndex+2 Step -1
				
				pCurent =pCurent->pPrev
				
			Next
			
		Endif
		
	Else
		
		If iIndex >iCurentIndex Then
			
			For i As Long =iCurentIndex To iIndex-1
				
				pCurent =pCurent->pNext
				
			Next
			
		Else
			
			For i As Long =iCurentIndex-1 To iIndex Step -1
				
				pCurent =pCurent->pPrev
				
			Next
			
		Endif
		
	Endif
	
	iCurentIndex =iIndex
	
End Sub