' Возвращает слово в данной позиции (iPos)
' дополнительные параметры просто чтобы лишний раз не вызывать GetRowsAndPosFromPosition после работы этой функции
' параметры:
' iPos - общая позиция в тексте
' iRetRow - переменная для получения номера строки
' iRetPos - переменная для получения позиции в строке iRetRow
function GetWordFromPosition(iPos as Long , byref iRetRow as long , byref iRetPos as Long) as wstring ptr
	
	' для получения строки и позиции в строке из общей позиции
	dim as Long iRow , iPosInLine , iPosInLineTab
	
	' получаем строку и позицию в строке из общей позиции
	GetRowsAndPosFromPosition(iPos , iRow , iPosInLine , iPosInLineTab)
	
	' сохраняем строку и позицию в строке для возврата из функции
	iRetRow = iRow
	iRetPos = iPosInLine
	
	' Получаем текст из списка
	dim as wstring ptr pWstr = pObj.pList.GetValueIndex(iRow-1) 
	
	' в этом буфере будет слово для возврата из функции
	dim as wstring ptr pwsTemp
	
	' если указатель существует
	if pWstr then
		
		' если длина строки больше нуля
		if len(*pWstr) then
			
			' проверяем символ в текущей позиции
			select case (*pWstr)[iPosInLine-1]
					' если различные вспомогательные символы
				Case 0 , 9 , 32 to 47 , 58 to 64 , 91 to 96 , 123 to 126
					
					' ничего не делаем
					
				case else
					
					' получаем длину текста из списка для отдельной строки
					dim as Long iLen = pObj.pList.GetValueLenIndex(iRow-1)
					
					' выделяем память для буфера с вышеуказанной длиной
					pwsTemp = callocate((iLen+1)*sizeof(wstring))
					
					if pwsTemp then
						
						' сначала в цикле идем назад по строке
						for i as Long  = iPosInLine-1 to 0 step -1
							
							if GetLenStringWithTab(*pwsTemp , iTabSpace) > pObj.iWidthSimbols - 20 then exit for ' ограничим длину слова
							
							' проверяем символ
							select case (*pWstr)[i]
									
									' если различные вспомогательные символы
								Case 0 , 9 , 32 to 47 , 58 to 64 , 91 to 96 , 123 to 126
									' выходим из цикла
									exit for
									
								case else ' любые другие символы
									
									' символ должен быть текстовым
									if (*pWstr)[i] > 31 then
										
										' сохраняем символ в буфере
										(*pwsTemp) = wchr((*pWstr)[i]) & *pwsTemp
										
									endif
									
							End Select
							
						Next
						
						' далее в цикле идем вперед по строке
						for i as Long  = iPosInLine to iLen-1
							
							if GetLenStringWithTab(*pwsTemp , iTabSpace) > pObj.iWidthSimbols - 20 then exit for ' ограничим длину слова
							
							' проверяем символ
							select case (*pWstr)[i]
									
									' если различные вспомогательные символы
								Case 0 , 9 , 32 to 47 , 58 to 64 , 91 to 96 , 123 to 126
									
									' выходим из цикла
									exit for
									
								case else
									
									' символ должен быть текстовым
									if (*pWstr)[i] > 31 then
										
										' сохраняем символ в буфере
										(*pwsTemp) &= wchr((*pWstr)[i])
										
									endif
									
							End Select
							
						Next
						
					else
						
						DrawErrorMemory() ' выводим ошибку памяти
						
					endif
					
			End Select
			
			' возвращаем буфер
			return pwsTemp
			
		EndIf
		
	EndIf
	
End Function

' Получение позиции в общем буфере (во всем списке)
function GetPosition() as long
	
	dim as long iAllLen ' общая длина строк из списка , включая переносы (CHR10)
	
	' координата Y для предыдущей строки
	dim as long iCur = pObj.iStartRowInWindow + pObj.iCurentCursorRowInWindow - 3
	
	for i as Long = 0 to iCur
		
		iAllLen += (pObj.pList.GetValueLenIndex(i)+1) ' складываем длину всех строк , кроме текущей 
		
	Next
	
	iAllLen += pObj.iCurentPosInRow ' прибавляем длину в текущей строке до позиции
	
	return iAllLen
	
End function

' Получение последней позиции в общем буфере (во всем списке)
function GetLastPosition() as long
	
	dim as long iAllLen ' общая длина строк из списка , включая переносы (CHR10)
	
	dim as long iEndRow = pObj.pList.GetSize()-1 ' последний пункт в связном списке
	
	' гоняем цикл по всем строкам в списке , складывая длину строк , 
	' пока позиция не окажется на нужной строке в списке	
	for i as Long = 0 to iEndRow
		
		iAllLen += (pObj.pList.GetValueLenIndex(i)+1) ' складываем длину строки с символом переноса
		
	next
	
	return iAllLen
	
End function

' Установка позиции в общем буфере (во всем списке)
' параметр:
' iPos - общая позиция в тексте
sub SetPosition(iPos as Long)
	
	dim as long iAllLen ' общая длина всех строк
	
	dim as long iPrevLen ' общая длина всех строк за минусом одной строки
	
	dim as long iEndRow = pObj.pList.GetSize()-1 ' последний пункт в связном списке
	
	#ifdef __UNIX_SYSTEM__
		GetWHConsole() ' получить размеры консоли в символах
	#endif
	
	if iPos < 1 then iPos = 1 ' на всякий случай делаем проверку на некоррекность позиции
	
	pObj.iScrollWidth = 1 ' сбрасываем прокрутку по ширине
	
	' гоняем цикл по всем строкам в списке , складывая длину строк , 
	' пока позиция не окажется на нужной строке в списке	
	for i as Long = 0 to iEndRow
		
		iPrevLen = iAllLen ' сохраняем предыдущую длину
		
		if i = iEndRow then ' если дошли до конца списка
			
			iAllLen += pObj.pList.GetValueLenIndex(i) ' складываем длину последней строки без символа переноса
			
			if iAllLen+1 < iPos then ' если устанавливаемая позиция больше , чем реальный объем текста
				
				iPos = iAllLen+1 ' считаем , что позиция в самом конце
				
			EndIf
			
		else
			
			iAllLen += (pObj.pList.GetValueLenIndex(i)+1) ' складываем длину строки с символом переноса
			
		EndIf
		
		' если позиция в текущей строке списка или позиция в самом конце
		if iPos <= iAllLen orelse (i = iEndRow andalso iPos = iAllLen+1) then
			
			'if i+1 > pObj.iHeightRows-1 then ' если позиция требует прокрутки по высоте
				'
				'pObj.iStartRowInWindow = i+1 - (pObj.iHeightRows - 2) ' подсчитываем первую видимую строку на экране
				'
			'else
				'
				'pObj.iStartRowInWindow = 1 ' первую видимую строку на экране ставим в единицу
				'
			'EndIf
			'
			'SetLenghtNumbers() ' устанавливаем размер номеров строк
			'
			'if i+1 <= pObj.iHeightRows-1 then ' если все умещается на одном экране без прокрутки по высоте
				'
				'' ставим позицию курсора в окне по высоте равной кол-ву прохождений цикла
				'pObj.iCurentCursorRowInWindow = i+1 
				'
			'else
				'
				'' ставим позицию курсора в окне по высоте в самый низ экрана
				'pObj.iCurentCursorRowInWindow = pObj.iHeightRows-1 
				'
			'EndIf
			
			' если позиция требует прокрутки по высоте
			if i+1 < pObj.iStartRowInWindow orelse (i+2 - pObj.iStartRowInWindow) > pObj.iHeightRows-1 then
				
				if i+1 > pObj.iHeightRows-1 then ' если позиция выходит за размеры экрана по высоте
					
					pObj.iStartRowInWindow = i+1 - (pObj.iHeightRows - 2) ' подсчитываем первую видимую строку на экране
					
				else ' 
					
					pObj.iStartRowInWindow = 1 ' первую видимую строку на экране ставим в единицу
					
				EndIf
				
				SetLenghtNumbers() ' устанавливаем размер номеров строк
				
				if i+1 <= pObj.iHeightRows-1 then ' если все умещается на одном экране без прокрутки по высоте
					
					' ставим позицию курсора в окне по высоте равной кол-ву прохождений цикла
					pObj.iCurentCursorRowInWindow = i+1
					
				else
				
					' ставим позицию курсора в окне по высоте в самый низ экрана
					pObj.iCurentCursorRowInWindow = pObj.iHeightRows-1
					
				EndIf
				
			else ' если прокрутка не требуется
				
				' ставим позицию курсора в окне по высоте
				pObj.iCurentCursorRowInWindow = (i+2) - pObj.iStartRowInWindow
				
			EndIf
			
			' позиция без учета табуляций
			dim as long iCurPosTemp = iPos - iPrevLen
			
			' ставим позицию курсора в окне по ширине
			pObj.iCurentCursorPosInWindow = GetTabStopPositionFromRealPosition(pObj.pList.GetValueIndex(i) , iPos - iPrevLen) + pObj.iLenghtNumbers + 1
			
			' ставим позицию в строке
			pObj.iCurentPosInRow = iPos - iPrevLen
			
			' если позиция курсора выходит за пределы экрана
			if pObj.iCurentCursorPosInWindow >= pObj.iWidthSimbols then
				
				dim as Long iPos = 1 ' первая позиция в строке буфера
				
				pObj.iScrollWidth = 1 ' прокрутку на начало

				while pObj.iCurentCursorPosInWindow >= pObj.iWidthSimbols ' пока курсор не окажется в области видимости экрана
					
					' получить текущую позицию с учетом табуляций
					dim as Long iCurentPos = GetTabStopPositionFromRealPosition(pObj.pList.GetValueIndex(i) , iPos)
					
					' получить предыдущую позицию с учетом табуляций
					dim as Long iNextPos = GetTabStopPositionFromRealPosition(pObj.pList.GetValueIndex(i) , iPos+1)
					
					iCurentPos = (iNextPos - iCurentPos) ' получим шаг между позициями
					
					pObj.iScrollWidth += iCurentPos ' увеличим прокрутку
					
					pObj.iCurentCursorPosInWindow -= iCurentPos ' уменьшим позицию курсора
					
					iPos+=1 ' увеличим позицию в строке буфера
					
				Wend
				
			EndIf
			
			exit for
			
		EndIf
		
	Next
	
End Sub

' скроллинг для функции SetPositionWithPosAndRow
' когда позиция выходит за пределы экрана
' по возможности рядом с позицией iPosInConsole
' параметры:
' pWstr - указатель на строку
' iRealPosWithTab - позиция , высчитанная на основе pObj.iCurentPosInRow , но учитывающая табуляции , символы разных знакомест
' iPosInConsole - предпочтительная позиция , на которую желательно установить курсор на экране 
sub ScrollFor_SetPositionWithPosAndRow(pWstr as wstring ptr  , iRealPosWithTab as Long , iPosInConsole as long)
	
	dim as Long iPosTemp = 1	
		
	pObj.iCurentCursorPosInWindow = iRealPosWithTab + pObj.iLenghtNumbers + 1' 
	
	' пока курсор не окажется в области видимости экрана и на потенциальной позиции
	while pObj.iCurentCursorPosInWindow >= pObj.iWidthSimbols orelse pObj.iCurentCursorPosInWindow > iPosInConsole  
		
		' получить текущую позицию с учетом табуляций
		dim as Long iCurentPos = GetTabStopPositionFromRealPosition(pWStr , iPosTemp)
		
		' получить предыдущую позицию с учетом табуляций
		dim as Long iNextPos = GetTabStopPositionFromRealPosition(pWStr , iPosTemp+1)
		
		iCurentPos = (iNextPos - iCurentPos) ' получим шаг между позициями
		
		pObj.iScrollWidth += iCurentPos ' увеличим прокрутку
		
		pObj.iCurentCursorPosInWindow -= iCurentPos ' уменьшим позицию курсора
		
		iPosTemp+=1 ' увеличим позицию в строке буфера
		
	Wend
	
End Sub

' Установка позиции , используя позицию в строке  , номер строки и при возможности позиции на экране
' параметры:
' iPos - позиция в строке iRow
' iRow - экранный номер строки
' iStartRow - номер строки , отображаемый на первой строке экрана
' iPosInConsole - позиция на экране в отдельной строке
' iAnywayScroll - флаг , который включает принудительную прокрутку до iPosInConsole (нужна для прокрутки при поиске)
sub SetPositionWithPosAndRow(iPos as Long , iRow as Long , iStartRow as Long , iPosInConsole as Long , iAnywayScroll as Long = 0)
	
	' подсчитаем длину строки , куда будет перемещен курсор
	dim as long iLen = pObj.pList.GetValueLenIndex((iStartRow+iRow)-2)
	
	' получим строку
	dim as Wstring ptr pWstr = pObj.pList.GetValueIndex((iStartRow+iRow)-2)
	
	pObj.iScrollWidth = 1 ' сбрасываем прокрутку по ширине
	
	pObj.iCurentPosInRow = iPos ' ставим позицию в строке по умолчанию , как задано параметром
	
	pObj.iStartRowInWindow = iStartRow ' ставим начальную позицию строк в экране
	
	SetLenghtNumbers() ' подсчитаем размер номеров строк
	
	pObj.iCurentCursorRowInWindow = iRow ' ставим позицию курсора на экране по высоте
	
	if iPosInConsole < pObj.iLenghtNumbers+2 then
		
		iPosInConsole = pObj.iLenghtNumbers+2
		
	EndIf
	
	if iPos > iLen+1 then ' если позиция больше длины строки
		
		pObj.iCurentPosInRow = iLen+1 ' ставим позицию в строке на самый конец 
		
		' подсчитаем реальную позицию с учетом табуляции
		dim as long iRealPosWithTab = GetTabStopPositionFromRealPosition(pWstr , pObj.iCurentPosInRow)
		
		' если позиция выходит за пределы экрана по ширине
		if iRealPosWithTab + pObj.iLenghtNumbers + 1 >= pObj.iWidthSimbols then
			
			' считаем и устанавливаем скроллинг и позицию в окне
			ScrollFor_SetPositionWithPosAndRow(pWstr , iRealPosWithTab , iPosInConsole)
			
		else
			
			' подсчитаем позицию курсора по ширине
			pObj.iCurentCursorPosInWindow = iRealPosWithTab + pObj.iLenghtNumbers + 1
			
		EndIf
		
	else
		
		' подсчитаем реальную позицию с учетом табуляции
		dim as long iRealPosWithTab = GetTabStopPositionFromRealPosition(pWstr , pObj.iCurentPosInRow)
		
		' если позиция в окне оказывается больше задаваемой параметром
		if (iRealPosWithTab + pObj.iLenghtNumbers + 1 > iPosInConsole andalso _
			iRealPosWithTab + pObj.iLenghtNumbers + 1 >= pObj.iWidthSimbols) orelse _
			(iAnywayScroll andalso iRealPosWithTab + pObj.iLenghtNumbers + 1 > iPosInConsole) then			
			
			' считаем и устанавливаем скроллинг и позицию в окне
			ScrollFor_SetPositionWithPosAndRow(pWstr , iRealPosWithTab , iPosInConsole)
			
			exit sub
			
		EndIf
		
		' подсчитаем позицию курсора по ширине
		pObj.iCurentCursorPosInWindow = iRealPosWithTab + pObj.iLenghtNumbers + 1
		
	EndIf
	
End Sub

' Получает позиции: номера строки от начала , позиции в строке из общей позиции в тексте
' параметры:
' iPosition - общая позиция в тексте
' iRow - номер строки в тексте
' iPosInLine - позиция в строке iRow
' iPosInLineTab - позиция в строке iRow с учетом табуляции
sub GetRowsAndPosFromPosition(iPosition as Long , Byref iRow as Long , Byref iPosInLine as Long , Byref iPosInLineTab as Long)
	
	dim as Long iLen ' общая длина всех строк
	
	' проходим в цикле по всем строкам
	for i as Long = 0 to pObj.pList.GetSize()-1
		
		iLen+= pObj.pList.GetValueLenIndex(i)+1 'складываем их длину
		
		if iPosition <= iLen then ' если позиция оказалась в последней складываемой строке
			
			iRow = i+1 ' сохраняем номер строки
			
			iPosInLine = pObj.pList.GetValueLenIndex(i)+1 - (iLen - iPosition) ' сохраняем позицию от начала строки
			
			' получим на основе iPosInLine позицию с учетом табуляций и пр. символов с разными знакоместами
			iPosInLineTab = GetTabStopPositionFromRealPosition(pObj.pList.GetValueIndex(i) , iPosInLine)
			
			exit for ' выходим из цикла
			
		EndIf
		
	Next
	
End sub

' получает номер строки из текущей позиции или
' получает начальную и конечную строку из множества выделенных строк
' если выделения нет , то в оба параметра будет записано одно и тоже значение (по сути одна и та же строка)
' параметры:
' iStartRow - начальная строка
' iEndRow - конечная строка
' iSwap - флаг , указывающий будут ли поменяны местами координаты iStartRow и iEndRow (0 - нет ; 1 - да)
sub GetRowsFromPosition(byref iStartRow as Long , byref iEndRow as Long , Byref iSwap as Long)
	
	dim as Long iStartPos ' начальная позиция в строке выделения
	
	dim as Long iEndPos ' конечная позиция в строке выделения
	
	dim as Long iStartMarker ' начальная позиция маркера
	
	dim as Long iEndMarker ' конечная позиция маркера
	
	if pObj.iMarkerSelectionStart then ' если установлен начальный маркер выделения
		
		iStartMarker = pObj.iMarkerSelectionStart ' сохраняем позицию начального маркера во временный буфер
		
		iEndMarker = GetPosition() ' ' сохраняем позицию конечного маркера во временный буфер из текущей позиции
		
		iF iStartMarker > iEndMarker THEN ' если позиция начального маркера больше позиции конечного маркера
			
			swap iStartMarker , iEndMarker ' меняем местами значения
			
			iSwap = 1 ' активируем и сохраняем флаг , что строки поменяли местами
			
		EndIf
		' получаем начальную строку и начальную позицию в этой строке
		GetRowsAndPosFromPosition(iStartMarker , iStartRow , iStartPos , iStartPos)
		' получаем конечную строку и конечную позицию в этой строке
		GetRowsAndPosFromPosition(iEndMarker , iEndRow , iEndPos , iEndPos)
		
	else
		
		iEndMarker = GetPosition() ' получаем текущую позицию
		
		' получаем строку и позицию в этой строке
		GetRowsAndPosFromPosition(iEndMarker , iEndRow , iEndPos , iEndPos)
		
		' все на одной строке
		iStartRow = iEndRow
		
	endif	
	
End Sub

' устанавливает курсор в текущей строке на начало
sub SetPositionInStartLine()
	
	' установим позицию на начало строки
	SetPositionWithPosAndRow( 1 , pObj.iCurentCursorRowInWindow , pObj.iStartRowInWindow , 1)
	
End Sub

' устанавливает курсор в текущей строке на конец
sub SetPositionInEndLine()
	
	' получаем индекс для списка (для текущей экранной строки)
	dim as Long iIndex = pObj.iStartRowInWindow+pObj.iCurentCursorRowInWindow-2
	
	' получим длину текущей строки
	dim as long iLen = pObj.pList.GetValueLenIndex(iIndex)
	
	' установим позицию на конец строки
	SetPositionWithPosAndRow( iLen+2 , pObj.iCurentCursorRowInWindow , pObj.iStartRowInWindow , pObj.iWidthSimbols)	
	
End Sub

'функция получает позицию при UNDO|REDO после операция комментирования/раскомментирования
'Позиция при операциях смещается из-за добавления/удаления символов '
'Параметры:
'iPrevPos - сохраненная позиция до операций комментирования/раскомментирования
'iComOrUnCom - какая операция комментирование или раскомментирование
'iCountOperationWithRows - сколько строк подверглись операции комментирования/раскомментирования
'iTrue - куда было выделение вперед или назад при операциях комментирования/раскомментирования (до откатов)
function GetPositionWithUndoRedo(iPrevPos as Long , iComOrUnCom as Long , iCountOperationWithRows as Long , iTrue as Long) as LONG
	
	dim as Long iNewPos = iPrevPos
	
	if iTrue then ' если выделение было сверху вниз
	
		if iComOrUnCom = E_COMMENT then ' если операция комментирования
			
			iNewPos += iCountOperationWithRows ' прибавляем к сохраненной позиции кол-во закомментированных строк
			
		else ' если операция раскомментирования
			
			iNewPos -= iCountOperationWithRows ' вычитаем из сохраненной позиции кол-во закомментированных строк
			
			if iNewPos < 1 then iNewPos = 1 ' если позиция оказалась за пределами допустимой , ставим на начало
			
		EndIf
		
	else
	
		if iComOrUnCom = E_COMMENT then ' если операция комментирования
			
			iNewPos += 1 ' прибавляем к сохраненной позиции 1 позицию
			
		else ' если операция раскомментирования
			
			iNewPos -= 1 ' вычитаем из сохраненной позиции 1 позицию
			
			if iNewPos < 1 then iNewPos = 1 ' если позиция оказалась за пределами допустимой , ставим на начало
			
		EndIf
	
	endif
	
	return iNewPos
	
End Function

' устанавливает или снимает маркер выделения
' если iClear не равен нулю , то маркер снимается
sub SetMarkerSelection(iClear as Long = 0)
	
	if iClear then ' если флаг очистки выделения установлен
		
		iMode_F2_Selection = 0
		
		if pObj.iMarkerSelectionStart then
			
			pObj.iMarkerSelectionStart = 0 ' сбрасываем начальный маркер
			
			bRepaintAnyway = 1 ' установим флаг перерисовки
			
		EndIf
		
		exit sub ' выходим из процедуры
		
	EndIf
	
	if pObj.iMarkerSelectionStart = 0 then ' если маркер не установлен
		
		pObj.iMarkerSelectionStart = GetPosition() ' сохраняем начальный маркер
		
	EndIf
	
End Sub

' установка режима выделения по клавише F2
' требуется в основном в линуксе на чистой консоли
' там где не работают клавиши SHIFT+стрелки
sub SetMarkerSelectionMode()
	
	if pObj.iMarkerSelectionStart then ' если маркер установлен
		
		pObj.iMarkerSelectionStart = 0 ' сбрасываем начальный маркер
		
		iMode_F2_Selection = 0 ' флаг обнуляем
		
	else
		
		pObj.iMarkerSelectionStart = GetPosition() ' сохраняем начальный маркер
		
		iMode_F2_Selection = 1 ' флаг активируем
		
	EndIf
	
	bRepaintAnyway = 1 ' активируем флаг перерисовки
	
End Sub