//-----------------------------------------------------------------------------
// MEKA - drivers.h
// Machine Drivers - Headers
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Definitions
//-----------------------------------------------------------------------------

// Machines
#define DRV_SMS     (0)
#define DRV_GG      (1)
#define DRV_SG1000  (2)
#define DRV_SC3000  (3)
#define DRV_COLECO  (4)
#define DRV_MSX     (5)
#define DRV_NES     (6)
#define DRV_SF7000  (7)
#define DRV_MAX     (8)

// CPU Type
#define CPU_Z80     (0)
#define CPU_6502    (1)

// VDP Type
#define VDP_SMSGG   (0)
#define VDP_TMS     (1)
#define VDP_NES     (2)

// Sound Type
#define SND_SN76489 (0)
#define SND_NES     (1)

//-----------------------------------------------------------------------------
// Data
//-----------------------------------------------------------------------------

typedef struct s_driver
{
  byte  id;
  char *short_name;
  char *full_name;
  int   cpu;
  int   vdp;
  int   snd;
  int   x_res;
  int   y_res;
  int   x_start;
  int   y_start;
  int   y_show_start; // Working variable
  int   y_show_end;   // Working variable
  int   y_int;        // Working variable
  int   colors;
  int   ram;
} ts_driver;

ts_driver *     cur_drv;

typedef struct
{
 char *ext;
 int   driver;
} ts_driver_ext;

//-----------------------------------------------------------------------------
// Functions
//-----------------------------------------------------------------------------

void                    drv_init (void);
void                    drv_set (int);
int                     drv_get_from_ext (char *ext);
int                     drv_id_to_mode (int);

//-----------------------------------------------------------------------------

