unsigned char fire_b[320 * 10], fire_c[320 * 10];
struct {
  short c1;
} fire;
struct {
  short live;
  float x, y;
  float x_add, y_add;
  float frame;
  float tail_x[3], tail_y[3];
  char tail_p;
} spark[40];
struct {
  short live;
  float x, y;
  float x_add, y_add;
  float frame;
  float tail_x[3], tail_y[3];
  char tail_p;
} blood[40];
struct {
  short live;
  float x, y;
  float x_add, y_add;
  float frame;
  float tail_x[3], tail_y[3];
  char tail_p;
} crystal[40];
char crystal_spawn;
struct {
  short live;
  float x, y;
  float x_add, y_add;
} bdrop[200];
struct {
  short live;
  char mood;
  float x, y;
  float x_add, y_add;
} mslogo[4];
struct {
  short live;
  float x, y;
  float x_add, y_add;
  float frame;
} msdebr[40];
struct {
  short live;
  char mood;
  float x, y;
  float x_add, y_add;
} programmer[4];
struct {
  short live;
  char mood;
  float x, y;
  float x_add, y_add;
  float frame;
} chicken[40];
struct {
  short live;
  short age;
  short x;
} fire_fuel[20];



void move_fire(void);
void draw_fire(void);
void add_spark(float x_pos, float y_pos, float x_add, float y_add);
void move_spark(void);
void draw_spark(void);
void add_blood(float x_pos, float y_pos, float x_add, float y_add);
void move_blood(void);
void draw_blood(void);
void add_crystal(float x_pos, float y_pos, float x_add, float y_add);
void move_crystal(void);
void draw_crystal(void);
void add_bdrop(float x_pos, float y_pos, float x_add, float y_add);
void move_bdrop(void);
void draw_bdrop(void);
void add_mslogo(void);
void move_mslogo(void);
void draw_mslogo(void);
void add_msdebr(float x_pos, float y_pos, float x_add, float y_add);
void move_msdebr(void);
void draw_msdebr(void);
void add_programmer(void);
void move_programmer(void);
void draw_programmer(void);
void add_chicken(void);
void move_chicken(void);
void draw_chicken(void);
void add_fire_fuel(short x_pos);
void move_fire_fuel(void);



void draw_fire(void) {
  short x, y, c;
  unsigned short offs;
  for (x = 1; x < 319; x++) {
    offs = 0;
    for (y = 0; y < 8; y++) {
      c = fire_b[offs + x];
      if (c != 0) put_pixel(x, y + ground[x] - 7, c, vrscr);
      offs += 320;
    }
  }
}

void move_fire(void) {
  short x, y, c;
  unsigned short offs;

  fire.c1++;
  if (fire.c1 >= 3) {
    fire.c1 = 0;

    offs = 0;
    for (y = 0; y < 8; y++) {
      for (x = 1; x < 319; x++) {
        c = fire_b[offs + x];
        c += fire_b[offs + x + 1];
        c += fire_b[offs + 320 + x + 1];
        c += fire_b[offs + 640 + x + 1];
        c += fire_b[offs + 640 + x];
        c += fire_b[offs + 640 + x - 1];
        c += fire_b[offs + 320 + x - 1];
        c += fire_b[offs + x - 1];
        fire_c[offs + x] = (c >> 3);
      }
      offs += 320;
    }
    for (offs = 0; offs < 10 * 320; offs++) {
      fire_b[offs] = fire_c[offs];
    }
  }
}

void add_programmer(void) {
  short c = 0, n;
  while(programmer[c].live != 0) c++;
  if (c < 3) {
    programmer[c].y_add = -((rnd(20) + 10) / 10);
    programmer[c].mood = rnd(2);
    if (programmer[c].mood == 0) {
      programmer[c].x = -40;
      programmer[c].x_add = 1;
      programmer[c].y = ground[0];
    }
    else {
      programmer[c].x = 360;
      programmer[c].x_add = -1;
      programmer[c].y = ground[319];
    }
    programmer[c].live = 1;
  }
}

void move_programmer(void) {
  short c, c2;

  if (rnd(10000) == 0) add_programmer();

  for (c = 0; c < 4; c++) {
    if (programmer[c].live != 0) {

      programmer[c].x += programmer[c].x_add;
      programmer[c].y += programmer[c].y_add;
      programmer[c].y_add += 0.1;
      if (programmer[c].mood == 0) {
        if (programmer[c].x > 340) programmer[c].live = 0;
      }
      else {
        if (programmer[c].x < -20) programmer[c].live = 0;
      }
      if (programmer[c].y > ground[(int)programmer[c].x] + 3) {
        programmer[c].y_add = -programmer[c].y_add;
        programmer[c].y += programmer[c].y_add;
      }
    }
  }
}

void draw_programmer(void) {
  short c;
  for (c = 0; c < 4; c++) {
    if (programmer[c].live != 0) {
      put_pob(programmer[c].x, programmer[c].y, 26, pobs, vrscr);
    }
  }
}

void add_msdebr(float x_pos, float y_pos, float x_add, float y_add) {
  short c = 0;
  while(msdebr[c].live != 0) c++;
  if (c < 39) {
    msdebr[c].x = x_pos;
    msdebr[c].y = y_pos;
    msdebr[c].x_add = x_add;
    msdebr[c].y_add = y_add;
    msdebr[c].frame = rnd(4) + 22;
    msdebr[c].live = 1;
  }
}

void move_msdebr(void) {
  short c, c2;
  for (c = 0; c < 40; c++) {
    if (msdebr[c].live != 0) {

      msdebr[c].x += msdebr[c].x_add;
      msdebr[c].y += msdebr[c].y_add;
      msdebr[c].y_add += 0.1;
      if (msdebr[c].x < 5) msdebr[c].x_add = -msdebr[c].x_add;
      if (msdebr[c].x > 314) msdebr[c].x_add = -msdebr[c].x_add;
      if (msdebr[c].y > ground[(int)msdebr[c].x] + 5) {
        msdebr[c].y_add = -msdebr[c].y_add;
        msdebr[c].y += msdebr[c].y_add;
        msdebr[c].y_add -= msdebr[c].y_add / 3;
        if (msdebr[c].y_add > -2) {
          msdebr[c].live = 0;
          put_pob(msdebr[c].x, msdebr[c].y, msdebr[c].frame, pobs, backg);
        }
      }
    }
  }
}

void draw_msdebr(void) {
  short c;
  for (c = 0; c < 40; c++) {
    if (msdebr[c].live != 0) {
      put_pob(msdebr[c].x, msdebr[c].y, msdebr[c].frame, pobs, vrscr);
    }
  }
}

void add_mslogo(void) {
  short c = 0, n;
  while(mslogo[c].live != 0) c++;
  if (c < 3) {
    mslogo[c].y_add = -((rnd(20) + 10) / 10);
    mslogo[c].mood = rnd(2);
    if (mslogo[c].mood == 0) {
      mslogo[c].x = -40;
      mslogo[c].x_add = 1;
      mslogo[c].y = ground[0];
    }
    else {
      mslogo[c].x = 360;
      mslogo[c].x_add = -1;
      mslogo[c].y = ground[319];
    }
    mslogo[c].live = 1;
  }
}

void move_mslogo(void) {
  short c, c2;

  if (rnd(5000) == 0) add_mslogo();

  for (c = 0; c < 4; c++) {
    if (mslogo[c].live != 0) {

      mslogo[c].x += mslogo[c].x_add;
      mslogo[c].y += mslogo[c].y_add;
      mslogo[c].y_add += 0.1;
      if (mslogo[c].mood == 0) {
        if (mslogo[c].x > 340) mslogo[c].live = 0;
      }
      else {
        if (mslogo[c].x < -20) mslogo[c].live = 0;
      }
      if (mslogo[c].y > ground[(int)mslogo[c].x] + 3) {
        mslogo[c].y_add = -mslogo[c].y_add;
        mslogo[c].y += mslogo[c].y_add;
      }
    }
  }
}

void draw_mslogo(void) {
  short c;
  for (c = 0; c < 4; c++) {
    if (mslogo[c].live != 0) {
      put_pob(mslogo[c].x, mslogo[c].y, 21, pobs, vrscr);
    }
  }
}

void add_crystal(float x_pos, float y_pos, float x_add, float y_add) {
  short c = 0, c2;
  while(crystal[c].live != 0) c++;
  if (c < 39) {
    crystal[c].x = x_pos;
    crystal[c].y = y_pos;
    crystal[c].x_add = x_add;
    crystal[c].y_add = y_add;
    crystal[c].frame = 5;
    crystal[c].tail_p = 0;
    for (c2 = 0; c2 < 3; c2++) {
      crystal[c].tail_x[c2] = x_pos;
      crystal[c].tail_y[c2] = y_pos;
    }
    crystal[c].live = rnd(256) + 128;
  }
}

void move_crystal(void) {
  short c, c2, p;
  for (c = 0; c < 40; c++) {
    if (crystal[c].live != 0) {
      crystal[c].tail_p++;
      if (crystal[c].tail_p > 2) crystal[c].tail_p = 0;
      crystal[c].tail_x[crystal[c].tail_p] = crystal[c].x;
      crystal[c].tail_y[crystal[c].tail_p] = crystal[c].y;

      crystal[c].x += crystal[c].x_add;
      crystal[c].y += crystal[c].y_add;
      crystal[c].x_add -= crystal[c].x_add / 40;
      crystal[c].y_add -= crystal[c].y_add / 40;
      //crystal[c].y_add -= 0.1;
      if (crystal[c].x < 5) crystal[c].x_add = -crystal[c].x_add;
      if (crystal[c].x > 314) crystal[c].x_add = -crystal[c].x_add;
      if (crystal[c].y > ground[(int)crystal[c].x] + 3) {
        crystal[c].y_add = -crystal[c].y_add;
        crystal[c].y += crystal[c].y_add;
      }
      if (crystal[c].y < 5) {
        crystal[c].y_add = -crystal[c].y_add;
        crystal[c].y += crystal[c].y_add;
      }
      if ((crystal[c].x_add > -0.1) && (crystal[c].x_add < 0.1) && (crystal[c].y_add > -0.1) && (crystal[c].y_add < 0.1)) crystal[c].live = 0;
      //crystal[c].live--;
      //if (crystal[c].live < 2) crystal[c].live = 0;
    }
  }
}

void draw_crystal(void) {
  short c, c2, p;
  for (c = 0; c < 40; c++) {
    if (crystal[c].live != 0) {
      p = crystal[c].tail_p + 1;
      if (p > 2) p = 0;
      for (c2 = 2; c2 >= 0; c2--) {
        put_pob(crystal[c].tail_x[p], crystal[c].tail_y[p], 6 + c2, pobs, vrscr);
        p++;
        if (p > 2) p = 0;
      }
      put_pob(crystal[c].x, crystal[c].y, crystal[c].frame, pobs, vrscr);
    }
  }
}

void add_bdrop(float x_pos, float y_pos, float x_add, float y_add) {
  short c = 0;
  while(bdrop[c].live != 0) c++;
  if (c < 199) {
    bdrop[c].x = x_pos;
    bdrop[c].y = y_pos;
    bdrop[c].x_add = x_add;
    bdrop[c].y_add = y_add;
    bdrop[c].live = 1;
  }
}

void move_bdrop(void) {
  short c, c2;
  for (c = 0; c < 200; c++) {
    if (bdrop[c].live != 0) {

      bdrop[c].x += bdrop[c].x_add;
      bdrop[c].y += bdrop[c].y_add;
      bdrop[c].y_add += 0.1;
      if (bdrop[c].x < 5) bdrop[c].x_add = -bdrop[c].x_add;
      if (bdrop[c].x > 314) bdrop[c].x_add = -bdrop[c].x_add;
      if (bdrop[c].y > ground[(int)bdrop[c].x] + 3) {
        bdrop[c].y_add = -bdrop[c].y_add;
        bdrop[c].y += bdrop[c].y_add;
        bdrop[c].y_add -= bdrop[c].y_add / 3;
        if (bdrop[c].y_add > -2) {
          bdrop[c].live = 0;
          put_pixel(bdrop[c].x, bdrop[c].y, 140, backg);
        }
      }
    }
  }
}

void draw_bdrop(void) {
  short c, c2;
  for (c = 0; c < 200; c++) {
    if (bdrop[c].live != 0) {
      put_pixel(bdrop[c].x, bdrop[c].y, 140, vrscr);
    }
  }
}

void add_chicken(void) {
  short c = 0;
  while(chicken[c].live != 0) c++;
  if (c < 39) {
    chicken[c].live = 1;
    chicken[c].mood = rnd(2) + 1;
    if (chicken[c].mood == 1) { // running right
      chicken[c].x = rnd(320) - 320;
      chicken[c].frame = 11;
      chicken[c].x_add = 1;
    }
    if (chicken[c].mood == 2) { // running left
      chicken[c].x = rnd(320) + 320;
      chicken[c].frame = 9;
      chicken[c].x_add = -1;
    }
    chicken[c].y_add = 0;
  }
}

void move_chicken(void) {
  short c;
  for (c = 0; c < 40; c++) {
    if (chicken[c].live != 0) {
      chicken[c].x += chicken[c].x_add;
      chicken[c].y = ground[(int)chicken[c].x];

      if (chicken[c].mood == 1) { // running right
        chicken[c].frame += 0.4;
        if (chicken[c].frame >= 13) chicken[c].frame = 11;
        if (chicken[c].x > 324) {
          /*chicken[c].mood = 2;
          chicken[c].x_add = -1;
          chicken[c].frame = 9;*/
          //exit(1);
          quit = 1;
        }
      }
      if (chicken[c].mood == 2) { // running left
        chicken[c].frame += 0.4;
        if (chicken[c].frame >= 11) chicken[c].frame = 9;
        if (chicken[c].x < -3) {
          /*chicken[c].mood = 1;
          chicken[c].x_add = 1;
          chicken[c].frame = 11;*/
          quit = 1;
        }
      }
    }
  }
}

void draw_chicken(void) {
  short c;
  for (c = 0; c < 40; c++) {
    if (chicken[c].live != 0) {
      put_pob(chicken[c].x, chicken[c].y, chicken[c].frame, pobs, vrscr);
    }
  }
}

void add_blood(float x_pos, float y_pos, float x_add, float y_add) {
  short c = 0, c2;
  while(blood[c].live != 0) c++;
  if (c < 39) {
    blood[c].x = x_pos;
    blood[c].y = y_pos;
    blood[c].x_add = x_add;
    blood[c].y_add = y_add;
    blood[c].frame = 13 + rnd(5);
    blood[c].tail_p = 0;
    for (c2 = 0; c2 < 3; c2++) {
      blood[c].tail_x[c2] = x_pos;
      blood[c].tail_y[c2] = y_pos;
    }
    blood[c].live = 1;
  }
}

void move_blood(void) {
  short c, c2, p;
  for (c = 0; c < 40; c++) {
    if (blood[c].live != 0) {
      blood[c].tail_p++;
      if (blood[c].tail_p > 2) blood[c].tail_p = 0;
      blood[c].tail_x[blood[c].tail_p] = blood[c].x;
      blood[c].tail_y[blood[c].tail_p] = blood[c].y;

      blood[c].x += blood[c].x_add;
      blood[c].y += blood[c].y_add;
      blood[c].y_add += 0.1;
      if (blood[c].x < 5) blood[c].x_add = -blood[c].x_add;
      if (blood[c].x > 314) blood[c].x_add = -blood[c].x_add;
      if (blood[c].y > ground[(int)blood[c].x] + 3) {
        blood[c].y_add = -blood[c].y_add;
        blood[c].y += blood[c].y_add;
        blood[c].y_add -= blood[c].y_add / 3;
        if (blood[c].y_add > -2) {
          blood[c].live = 0;
          put_pob(blood[c].x, blood[c].y + 2, blood[c].frame, pobs, backg);
          //ground[(int)blood[c].x]--;
        }
      }
    }
  }
}

void draw_blood(void) {
  short c, c2, p;
  for (c = 0; c < 40; c++) {
    if (blood[c].live != 0) {
      p = blood[c].tail_p + 1;
      if (p > 2) p = 0;
      for (c2 = 2; c2 >= 0; c2--) {
        put_pob(blood[c].tail_x[p], blood[c].tail_y[p], 18 + c2, pobs, vrscr);
        p++;
        if (p > 2) p = 0;
      }
      put_pob(blood[c].x, blood[c].y, blood[c].frame, pobs, vrscr);
    }
  }
}

void add_spark(float x_pos, float y_pos, float x_add, float y_add) {
  short c = 0, c2;
  while(spark[c].live != 0) c++;
  if (c < 39) {
    spark[c].x = x_pos;
    spark[c].y = y_pos;
    spark[c].x_add = x_add;
    spark[c].y_add = y_add;
    spark[c].frame = 1;
    spark[c].tail_p = 0;
    for (c2 = 0; c2 < 3; c2++) {
      spark[c].tail_x[c2] = x_pos;
      spark[c].tail_y[c2] = y_pos;
    }
    spark[c].live = 1;
  }
}

void move_spark(void) {
  short c, c2, p;
  for (c = 0; c < 40; c++) {
    if (spark[c].live != 0) {
      spark[c].tail_p++;
      if (spark[c].tail_p > 2) spark[c].tail_p = 0;
      spark[c].tail_x[spark[c].tail_p] = spark[c].x;
      spark[c].tail_y[spark[c].tail_p] = spark[c].y;

      spark[c].x += spark[c].x_add;
      spark[c].y += spark[c].y_add;
      spark[c].y_add += 0.2;
      if (spark[c].x < 5) spark[c].x_add = -spark[c].x_add;
      if (spark[c].x > 314) spark[c].x_add = -spark[c].x_add;
      if (spark[c].y > ground[(int)spark[c].x]) {
        spark[c].y_add = -spark[c].y_add;
        spark[c].y += spark[c].y_add;
        spark[c].y_add -= spark[c].y_add / 2;
        if (spark[c].y_add > -2) {
          spark[c].live = 0;
          add_fire_fuel(spark[c].x);
        }
      }
    }
  }
}

void draw_spark(void) {
  short c, c2, p;
  for (c = 0; c < 40; c++) {
    if (spark[c].live != 0) {
      p = spark[c].tail_p + 1;
      if (p > 2) p = 0;
      for (c2 = 2; c2 >= 0; c2--) {
        put_pob(spark[c].tail_x[p], spark[c].tail_y[p], 2 + c2, pobs, vrscr);
        p++;
        if (p > 2) p = 0;
      }
      put_pob(spark[c].x, spark[c].y, spark[c].frame, pobs, vrscr);
    }
  }
}

void add_fire_fuel(short x_pos) {
  short c = 0;
  while(fire_fuel[c].live != 0) c++;
  if (c < 19) {
    fire_fuel[c].x = x_pos;
    fire_fuel[c].live = 1;
    fire_fuel[c].age = 1;
  }
}

void move_fire_fuel(void) {
  short c, c2, c3, x;
  for (c = 0; c < 20; c++) {
    if (fire_fuel[c].live != 0) {
      fire_fuel[c].live++;

      if (fire_fuel[c].live > 5) {
        fire_fuel[c].live = 1;
        fire_fuel[c].age++;
      }
      if (fire_fuel[c].age > 15) fire_fuel[c].live = 0;
      else {
        for (c3 = 0; c3 < 1; c3++) {
          x = fire_fuel[c].x + rnd(10) - 5;
          c2 = rnd(8) * (float)(16 - fire_fuel[c].age) / 8 + 8;
          fire_b[8 * 320 + x] = c2;
          fire_b[8 * 320 + x + 1] = c2;
          fire_b[9 * 320 + x] = c2;
          fire_b[9 * 320 + x + 1] = c2;
        }
      }
    }
  }
}