//
//    MARAUDER
//
//    alien.cpp: cool stuff here, lots of nifty collision checks.
//
//    By Shawn Hargreaves, 1995.
//
//    C++ source code for djgpp, using the 
//    Allegro game programming library.


#include <stdlib.h>
#include <limits.h>
#include <allegro.h>
#include "marauder.h"
#include "sprite.h"
#include "genes.h"
#include "mgr.h"
#include "alien.h"
#include "bullet.h"


extern spritemgr *explosions, *treasures, *planets, *bullets;
extern alienmgr *aliens;
extern exploder *explode;
extern playership *ship;

extern DATAFILE *dat;



multidir *draw_alien(int *rcol, void (*callback)(void))
{
    int x, y;
    BITMAP *bmp = create_bitmap(32, 32);
    clear(bmp);
    int x1, y1, x2, y2, x3, y3, color;
    int ax = 16;
    int ay = 16;
    int flag = FALSE;

    for (int c=(rand()&7)+6; c>0; c--) {
	x1 = (rand()&7) + 8;
	x2 = (rand()&15) + 8;
	x3 = (rand()&15) + (flag ? 16 : 0);
	y1 = rand()&31;
	y2 = rand()&31;
	y3 = rand()&31;
	color = rand()&255;
	x = (x1+x2+x3)/3;
	y = (y1+y2+y3)/3;
	line(bmp, ax, ay, x, y, color);
	ax = x;
	ay = y;
	triangle(bmp, x1, y1, x2, y2, x3, y3, color);
	flag = !flag;
    }

    if (rcol)
	*rcol = rand()&255;

    for (x=16; x<32; x++)
	for (y=0; y<32; y++)
	    bmp->line[y][x] = bmp->line[y][31-x];

    multidir *spr = new multidir(bmp, 32, callback);
    destroy_bitmap(bmp);
    return spr;
}



alien::alien(genepool *g)
{
    genes = g;
    mygene = genes->get_genes(&spr, &rcol);
    current_sprite = spr->sprite(0);
    set_dim();
    bound = calculate_bound(current_sprite);
    speed_shift = 4+(mygene->get_speed());
    turn_speed = 1+mygene->get_turn_speed();
    shields = mygene->get_shields();
    dir = rand();
    itemtype = ITEM_ALIEN;
    money = 100;
    cargo = 0;
    shootdelay = 0;
    inf.v1 = inf.v2 = 0;
}



void alien::play_my_sample(SAMPLE *spl, int freq)
{
    int x = ((getx() - ship->getx()) >> FIX_TO_PIX_SHIFT);
    int y = ((gety() - ship->gety()) >> FIX_TO_PIX_SHIFT);

    int absx = (x >= 0) ? x : -x;
    int absy = (y >= 0) ? y : -y;

    int vol = 255 - ((absx+absy) / 2);
    if (vol <= 0)
	return;

    int pan = 128 + x;
    if (pan < 0)
	pan = 0;
    else if (pan > 255)
	pan = 255;

    play_sample(spl, vol, pan, freq, FALSE);
}



void alien::collide(item *other)
{
    if (other->get_type()==ITEM_PLANET) {
	damage = 100;
	explosions->add(new explosion(explode, FALSE), getx(), gety());
	play_my_sample((SAMPLE *)dat[EXPLODE_WAV].dat, 1000);
    }
    else if (other->get_type()==ITEM_BULLET) {
	if (((bullet *)other)->get_parent() == this)
	    return;
	damage += ((bullet *)other)->get_harm() / ((2+shields) / 2);
	if (damage >= 100) {
	    item *parent = ((bullet *)other)->get_parent();
	    if ((parent == ship) || (parent == NULL))
		ship->kill_count++;
	}
	((bullet *)other)->kill(); 
	if ((!burn_delay) || (damage >= 100)) {
	    explosions->add(new explosion(explode, FALSE), other->getx(), other->gety());
	    burn_delay = 12;
	    if (damage >= 100)
		play_my_sample((SAMPLE *)dat[EXPLODE_WAV].dat, 1000);
	    else
		play_my_sample((SAMPLE *)dat[CRASH_WAV].dat, 350);
	}
    }
    else if (other->get_type()==ITEM_TREASURE) {
	money += ((treasure *)other)->get_money();
	cargo += ((treasure *)other)->get_cargo();
	if (cargo > 100)
	    cargo = 100;
	((treasure *)other)->kill();
    }
}



int alien::move()
{
    action act;

    if (damage >= 100) {
	if ((cargo != 0) || (money != 0)) {
	    treasures->add(new treasure(cargo, money), getx(), gety());
	    cargo = money = 0;
	}
	return -1;
    }

    if (burn_delay)
	burn_delay--;

    inf.money = money;
    inf.cargo = cargo;
    inf.damage = damage;

    mygene->evaluate(&inf, &act);

    if ((act.left > act.right) && (act.left > act.forwards))
	dir-=turn_speed;
    else
	if (act.right > act.forwards)
	    dir+=turn_speed;

    dir &= 0xff;

    if (shootdelay)
	shootdelay--;
    else {
	if ((act.fire > 0) && (inf.ship.dir == 0) && 
	    (inf.ship.dist < (100 << FIX_TO_PIX_SHIFT))) {
	    switch(mygene->get_weapon()) {
		case WEAPON_LASER:
		    bullets->add(new laser(dir, 
					   fsin(itofix(dir)) << speed_shift, 
					   -fcos(itofix(dir)) << speed_shift, 
					   this),
				 getx()+fsin(itofix(dir))*128,
				 gety()-fcos(itofix(dir))*128);
		    shootdelay = 10;
		    play_my_sample((SAMPLE *)dat[L1_WAV].dat, 600);
		    break;

		case WEAPON_PROTON_GUN:
		    bullets->add(new proton_gun(dir, 
					    fsin(itofix(dir)) << speed_shift, 
					    -fcos(itofix(dir)) << speed_shift, 
					    this),
				 getx()+fsin(itofix(dir))*128,
				 gety()-fcos(itofix(dir))*128);
		    shootdelay = 5;
		    play_my_sample((SAMPLE *)dat[L2_WAV].dat, 800);
		    break;

		case WEAPON_MATTER_CANNON:
		    bullets->add(new matter_cannon(dir, 
					    fsin(itofix(dir)) << speed_shift, 
					    -fcos(itofix(dir)) << speed_shift, 
					    this),
				 getx()+fsin(itofix(dir))*128,
				 gety()-fcos(itofix(dir))*128);
		    shootdelay = 8;
		    play_my_sample((SAMPLE *)dat[L3_WAV].dat, 800);
		    break;
	    }
	}
    }

    if (inf.planet.dist < (40 << FIX_TO_PIX_SHIFT)) {
	while ((damage >= 10) && (money > REPAIR_PRICE + 10)) {
	    damage -= 10;
	    money -= REPAIR_PRICE;
	}
	if (inf.buy_planet) {
	    int flag = FALSE;
	    while ((cargo <= 90) && (money > 0)) {
		cargo += 10;
		money--;
		flag = TRUE;
	    }
	    if (flag)
		explosions->add(new yippee("BUY"), getx(), gety());
	}
	else if (inf.sell_planet) {
	    if (cargo > 0) {
		money += cargo * 10;
		explosions->add(new yippee("SELL"), getx(), gety());
		cargo = 0;
	    }
	}
    }

    x += (fsin(itofix(dir)) << speed_shift);
    y -= (fcos(itofix(dir)) << speed_shift);
    current_sprite = spr->sprite(dir);

    return 0;
}



int alienmgr::get_dist(item *i1, item *i2)
{ 
    int xdiff = myabs(i1->getx() - i2->getx());
    int ydiff = myabs(i1->gety() - i2->gety());
    if (xdiff > ydiff)
	return xdiff - (i1->getwidth() + i2->getwidth());
    else
	return ydiff - (i1->getheight() + i2->getheight());
}



int alienmgr::get_dir(item *i1, alien *i2)
{
    int xdiff = i1->getx() - i2->getx();
    int ydiff = i1->gety() - i2->gety();
    int ret = -1;

    if (myabs(xdiff) > myabs(ydiff)) {
	if (myabs(xdiff)/2 > myabs(ydiff)) {
	    if (xdiff>0)
		ret = 2;
	    else
		ret = 6;
	}
    }
    else {
	if (myabs(ydiff)/2 > myabs(xdiff)) {
	    if (ydiff>0)
		ret = 4;
	    else
		ret = 0;
	}
    }
    if (ret==-1) {
	if (xdiff>0) {
	    if (ydiff>0)
		ret = 3;
	    else
		ret = 1;
	}
	else {
	    if (ydiff>0)
		ret = 5;
	    else
		ret = 7;
	}
    }

    return (ret - ((i2->dir+16)/32)) & 7;
}



void alienmgr::check_items(item *i1, item *i2)
{
    // circle bounding box, rectangle has already been done
    int xd = myabs(i1->getx()-i2->getx()) >> FIX_TO_PIX_SHIFT;
    int yd = myabs(i1->gety()-i2->gety()) >> FIX_TO_PIX_SHIFT;
    if ((fsqrt(xd*xd+yd*yd)>>8) < (i1->getbound()+i2->getbound()))
	i1->collide(i2);
}



void alienmgr::check_ship_collision(playership *ship)
{
    extern int hide;
    alien **a = (alien **)i;

    for (int c=0; c<count; c++) {
	if ((a[c]->inf.player.dist = get_dist(ship, a[c])) < 0)
	    check_items(ship, a[c]);
	if (!hide)
	    a[c]->inf.player.dir = get_dir(ship, a[c]);
	else {
	    a[c]->inf.player.dist = INT_MAX;
	}
    }
}



// I have yet to figure out how templates work, but who cares.
// Macros can do the same stuff.....
// Hehe. Understand this if you can :-)


#define DO_THE_CHECK(spritemanager)                                     \
{                                                                       \
    alien *al;                                                          \
    int dist;                                                           \
    int best_distance = INT_MAX;                                        \
    int a, o, d;                                                        \
									\
    o = 0;                                                              \
									\
    for (a=0; a<count; a++) {                                           \
	al = (alien *)i[a];                                             \
	MAX_DISTANCES(al);                                              \
									\
	if (spritemanager->count > 0) {                                 \
	    CLEAR_CLOSEST();                                            \
									\
	    d = o;                                                      \
	    do {                                                        \
		o = d;                                                  \
		d++;                                                    \
	    } while ((d<spritemanager->count) &&                        \
		     (spritemanager->i[d]->getx() < al->getx()));       \
									\
	    d = o;                                                      \
	    do {                                                        \
		CHECK(d);                                               \
		d--;                                                    \
		if (d<0)                                                \
		    d = spritemanager->count-1;                         \
	    } while ((myabs(al->getx()-spritemanager->i[d]->getx()) <   \
		      best_distance) && (d != o));                      \
									\
	    d = o+1;                                                    \
	    if (d>=spritemanager->count)                                \
		d = 0;                                                  \
	    while ((myabs(al->getx()-spritemanager->i[d]->getx()) <     \
		    best_distance) && (d != o)) {                       \
		CHECK(d);                                               \
		d++;                                                    \
		if (d>=spritemanager->count)                            \
		    d = 0;                                              \
	    }                                                           \
									\
	    STORE_RESULTS();                                            \
	}                                                               \
    }                                                                   \
}



void alienmgr::bullet_collision_check()
{
    bullet *closest_missile, *closest_laser;
    bullet *bul;

    #define MAX_DISTANCES(al)                                           \
	al->inf.laser.dist = al->inf.missile.dist = INT_MAX;

    #define CLEAR_CLOSEST()                                             \
	closest_missile = closest_laser = NULL;

    #define STORE_RESULTS()                                             \
    {                                                                   \
	if (closest_missile)                                            \
	    al->inf.missile.dir = get_dir(closest_missile, al);         \
	else                                                            \
	    al->inf.missile.dir = 1;                                    \
	if (closest_laser)                                              \
	    al->inf.laser.dir = get_dir(closest_laser, al);             \
	else                                                            \
	    al->inf.laser.dir = 3;                                      \
    }

    #define CHECK(b)                                                    \
    {                                                                   \
	bul = (bullet *)bullets->i[b];                                  \
	if (bul->get_parent() != al) {                                  \
	    if ((dist = get_dist(al, bul)) < 0)                         \
		check_items(al, bul);                                   \
	    if (bul->is_missile) {                                      \
		if (dist<al->inf.missile.dist) {                        \
		    al->inf.missile.dist = dist;                        \
		    closest_missile = bul;                              \
		    if (dist<al->inf.laser.dist)                        \
			best_distance = al->inf.laser.dist;             \
		}                                                       \
	    }                                                           \
	    else {                                                      \
		if (dist<al->inf.laser.dist) {                          \
		    al->inf.laser.dist = dist;                          \
		    closest_laser = bul;                                \
		    if (dist<al->inf.missile.dist)                      \
			best_distance = al->inf.missile.dist;           \
		}                                                       \
	    }                                                           \
	}                                                               \
    }

    DO_THE_CHECK(bullets);

    #undef MAX_DISTANCES
    #undef CLEAR_CLOSEST
    #undef STORE_RESULTS
    #undef CHECK
}



void alienmgr::planet_collision_check()
{
    planet *closest;
    planet *plan;

    #define MAX_DISTANCES(al)                                           \
	al->inf.planet.dist = INT_MAX;

    #define CLEAR_CLOSEST()                                             \
	closest = NULL;

    #define STORE_RESULTS()                                             \
    {                                                                   \
	al->inf.buy_planet = al->inf.sell_planet = FALSE;               \
	if (closest) {                                                  \
	    al->inf.planet.dir = get_dir(closest, al);                  \
	    if (closest->price()==1)                                    \
		al->inf.buy_planet = TRUE;                              \
	    else                                                        \
		if (closest->price()>1)                                 \
		    al->inf.sell_planet = TRUE;                         \
	}                                                               \
	else                                                            \
	    al->inf.planet.dir = 5;                                     \
    }

    #define CHECK(b)                                                    \
    {                                                                   \
	plan = (planet *)planets->i[b];                                 \
	if ((dist = get_dist(al, plan)) < 0)                            \
	    check_items(al, plan);                                      \
	if (dist<al->inf.planet.dist) {                                 \
	    best_distance = al->inf.planet.dist = dist;                 \
	    closest = plan;                                             \
	}                                                               \
    }

    DO_THE_CHECK(planets);

    #undef MAX_DISTANCES
    #undef CLEAR_CLOSEST
    #undef STORE_RESULTS
    #undef CHECK
}



void alienmgr::treasure_collision_check()
{
    treasure *closest;
    treasure *tres;

    #define MAX_DISTANCES(al)                                           \
	al->inf.treasure.dist = INT_MAX;

    #define CLEAR_CLOSEST()                                             \
	closest = NULL;

    #define STORE_RESULTS()                                             \
    {                                                                   \
	if (closest)                                                    \
	    al->inf.treasure.dir = get_dir(closest, al);                \
	else                                                            \
	    al->inf.treasure.dir = 7;                                   \
    }

    #define CHECK(b)                                                    \
    {                                                                   \
	tres = (treasure*)treasures->i[b];                              \
	if ((dist = get_dist(al, tres)) < 0)                            \
	    check_items(al, tres);                                      \
	if (dist<al->inf.treasure.dist) {                               \
	    best_distance = al->inf.treasure.dist = dist;               \
	    closest = tres;                                             \
	}                                                               \
    }

    DO_THE_CHECK(treasures);

    #undef MAX_DISTANCES
    #undef CLEAR_CLOSEST
    #undef STORE_RESULTS
    #undef CHECK
}



void alienmgr::alien_collision_check()
{
    alien *closest;
    alien *aln;

    #define MAX_DISTANCES(al)                                           \
	al->inf.ship.dist = INT_MAX;

    #define CLEAR_CLOSEST()                                             \
	closest = NULL;

    #define STORE_RESULTS()                                             \
    {                                                                   \
	if (closest) {                                                  \
	    if (al->inf.ship.dist < al->inf.player.dist)                \
		al->inf.ship.dir = get_dir(closest, al);                \
	    else                                                        \
		al->inf.ship = al->inf.player;                          \
	}                                                               \
	else                                                            \
	    al->inf.ship = al->inf.player;                              \
    }

    #define CHECK(b)                                                    \
    {                                                                   \
	aln = (alien *)i[b];                                            \
	if (al != aln) {                                                \
	    dist = get_dist(al, aln);                                   \
	    if (dist<al->inf.ship.dist) {                               \
		best_distance = al->inf.ship.dist = dist;               \
		closest = aln;                                          \
	    }                                                           \
	}                                                               \
    }

    DO_THE_CHECK(this);

    #undef MAX_DISTANCES
    #undef CLEAR_CLOSEST
    #undef STORE_RESULTS
    #undef CHECK
}



void alienmgr::move(int x)
{
    static int count = 0;

    bullet_collision_check();

    if (count & 1)
	treasure_collision_check();
    else {
	if (count & 2)
	    alien_collision_check();
	else
	    planet_collision_check();
    }

    count++;

    spritemgr::move(x);
}


