#include <math.h>
#include <stdlib.h>

#ifdef AMIGA
#include "AmigaInt.h"
#else

#ifdef WIN32
#include "Win32Int.h"
#else
#include <stdint.h>
#include <unistd.h>
#endif

#endif

#include "FixP.h"

const uint8_t kIntegerPart = 16;

int32_t fixToInt( FixP_t fp) {
	return fp >> kIntegerPart;
}

FixP_t intToFix(int32_t	v ) {
	return v << kIntegerPart;
}

FixP_t Mul( FixP_t v1,  FixP_t v2) {
	return ((v1 >> 6) * (v2 >> 6)) >> 4;
}

FixP_t Div( FixP_t v1,  FixP_t v2) {
	return (((int64_t) v1) * (1 << kIntegerPart)) / v2;
}
