/*

 Nibbles - Copyright (C) 2000 Andrea Fazzi

 This file is part of Nibbles.

 Nibbles is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Nibbles is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Nibbles; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
//---------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "Body.h"
#include "DblBuf.h"
#include "AWorm.h"
#include "MathFun.h"
//---------------------------------------------------------------------------
Body::Body() {}
//---------------------------------------------------------------------------
Body::~Body() {}
//---------------------------------------------------------------------------
void Body::Make(int bodynum,int bodytot) {

 int i;

  bodyID=bodynum;
  mass=rand()%50;

  direction=DIR_RIGHT;
  memset(&pivotCheck[0],0,100);

  if(bodynum>0) {

   PrevPart=new Body;
   Exists=true;

   if(bodynum==bodytot)
    type=IS_A_HEAD;

   else type=IS_A_BODY;

   PrevPart->Make(bodynum-1,bodytot);

  }

  else {

   type=IS_A_TAIL;
   Exists=false;

 }

}
//---------------------------------------------------------------------------
void Body::AddPart(Body *prev) {

   Exists=true;
   prev->Exists=false;
   prev->bodyID=-1;
   prev->direction=direction;
   prev->mass=rand()%50;
   memcpy(&prev->pivotCheck[0],&pivotCheck[0],100);

   prev->GraphData=new Sprite;
//   prev->GraphData->LoadFrom_SPR_File("art/Body.spr");
   prev->GraphData->W=GraphData->W;prev->GraphData->H=GraphData->H;
   prev->GraphData->Size=GraphData->Size;
   prev->GraphData->PtrSprite=(unsigned char *) malloc(GraphData->Size);
   memcpy(prev->GraphData->PtrSprite,GraphData->PtrSprite,GraphData->Size);

   prev->W=prev->GraphData->W;prev->H=prev->GraphData->H;

    switch(direction) {

     case DIR_LEFT:  prev->x=x+8;prev->y=y;
                     break;
     case DIR_RIGHT: prev->x=x-8;prev->y=y;
                     break;
     case DIR_UP:    prev->x=x;prev->y=y+8;
                     break;
     case DIR_DOWN:  prev->x=x;prev->y=y-8;
                     break;

   }

   prev->GraphBuf=GraphBuf;

}
//---------------------------------------------------------------------------
void Body::Grow(int bodynum) {

 int i,tmpID;

  tmpID=bodyID;

  if(bodyID==0) {

   PrevPart=new Body;
   AddPart(PrevPart);

  }

   bodyID=bodynum;

    if(Exists) PrevPart->Grow(bodynum-1);


}
//---------------------------------------------------------------------------
void Body::Move(char dir) {

 switch(dir) {

  case DIR_LEFT:  x--;
                  break;

  case DIR_RIGHT: x++;
                  break;

  case DIR_DOWN : y++;
                  break;

  case DIR_UP:    y--;
                  break;

 }

}
//---------------------------------------------------------------------------
bool Delta(int x,int y,int delta) {

 if((x<(y+delta))&&(x>(y-delta))) return true;
  else return false;

}
//---------------------------------------------------------------------------
bool Body::Crawl(pointXY *pivots,char num,bool StopFlag,bool pivotTest) {

 char i;

  for(i=0;i<num;i++) {

   if((direction==DIR_LEFT)||(direction==DIR_RIGHT)) {

     if((x==pivots[i].x)&&(Delta(y,pivots[i].y,3))&&(pivotCheck[i]==0)&&
        ((direction+pivots[i].dir)!=0)) {

      direction=pivots[i].dir;
      pivotCheck[i]++;

       if(bodyID==0)
        pivotTest=true;

       else pivotTest=false;


     }
   }

   else if((direction==DIR_UP)||(direction==DIR_DOWN)) {

     if((y==pivots[i].y)&&(Delta(x,pivots[i].x,3))&&(pivotCheck[i]==0)&&
        ((direction+pivots[i].dir)!=0)) {

      direction=pivots[i].dir;
      pivotCheck[i]++;

       if(bodyID==0)
        pivotTest=true;

       else pivotTest=false;

     }
   }

  }

   Move(direction);

   if(Exists) PrevPart->Crawl(pivots,num,StopFlag,pivotTest);

}
//---------------------------------------------------------------------------
void Body::Display() {

 if(type==IS_A_HEAD) {

  switch(direction) {

   case DIR_RIGHT: GraphData[0].DrawSprite(x,y,GraphBuf->FrameBuf);
                   break;
   case DIR_UP:    GraphData[1].DrawSprite(x-1,y,GraphBuf->FrameBuf);
                   break;
   case DIR_LEFT:  GraphData[2].DrawSprite(x-2,y,GraphBuf->FrameBuf);
                   break;
   case DIR_DOWN:  GraphData[3].DrawSprite(x-1,y,GraphBuf->FrameBuf);
                   break;

  }

 }

 else GraphData->DrawSprite(x,y,GraphBuf->FrameBuf);

   if(Exists) PrevPart->Display();

}
//---------------------------------------------------------------------------
void Body::Init(LevelHeader *lev,char *sprname,DblBuf *buf) {

 int delta;
 int startx,starty,startsize;

 startx=lev->StartX;starty=lev->StartY;
 startsize=lev->CurrSize;

 if((type==IS_A_BODY)||(type==IS_A_TAIL)) {

  GraphData=new Sprite;
  GraphData->LoadFrom_SPR_File(sprname);
  W=GraphData->W;H=GraphData->H;

 }

 else {

  GraphData=new Sprite[4];

  GraphData[0].LoadFrom_SPR_File(sprname);
  W=GraphData[0].W;H=GraphData[0].H;


  GraphData[0].Transform(ROTATE_90DEG_LEFT,&GraphData[1]);
   GraphData[0].Transform(ROTATE_180DEG_LEFT,&GraphData[2]);
    GraphData[2].Transform(ROTATE_90DEG_LEFT,&GraphData[3]);

 }

 if(type==IS_A_HEAD) {

   x=startx;
   y=starty;

 }

 else {

   delta=(startsize-(bodyID))*8;

   x=startx+10-delta;
   y=starty;

 }

 GraphBuf=buf;

  if(Exists) {

    if(PrevPart->bodyID==0) PrevPart->Init(lev,"art/Body.spr",buf);
     else PrevPart->Init(lev,"art/Body.spr",buf);

  }

}
//---------------------------------------------------------------------------
bool Body::ImEatingMySelf(int X,int Y,int w,int h,char dir) {

int prevX,prevY,prevW,prevH;

 if(Exists) {

  prevX=PrevPart->x;prevY=PrevPart->y;
  prevW=PrevPart->W;prevH=PrevPart->H;

  if(dir==0) {

   if((Range(Y,prevY,(prevY+prevH))||
       Range(Y+h,prevY,(prevY+prevH)))&&
       Range(X,prevX,(prevX+prevW)))

    return true;

  }

  else {

   if((Range(X,prevX,(prevX+prevW))||
       Range(X+w,prevX,(prevX+prevW)))&&
       Range(Y,prevY,(prevY+prevH)))

    return true;

  }

 PrevPart->ImEatingMySelf(X,Y,w,h,dir);

 }

 else return false;

}
//---------------------------------------------------------------------------
void Body::Die(int t) {

int accFact;

 if(t==0) {  y0=y;   x0=x;  }

 /*sequenza di morte 1*/

  y=(int)(y0+0.4/mass*(t*t));

  if(Exists) PrevPart->Die(t);

}
//---------------------------------------------------------------------------
bool Body::Eat(int t) {

 bool notify;

  switch(direction) {

   case DIR_LEFT:  x--;
                   break;
   case DIR_RIGHT: x++;
                   break;
   case DIR_UP:    y--;
                   break;
   case DIR_DOWN:  y++;
                   break;

  }

  if(t<10) return false;
   else return true;

}
//---------------------------------------------------------------------------







