/**
 * This file contains MIDI instrument defenitions for use with the OPL2 Audio Board library.
 *
 * Currently only melodic instruments are included.
 */

const unsigned char PIANO1[12]   PROGMEM = { 0x00, 0x33, 0x5A, 0xB2, 0x50, 0x01, 0x00, 0x31, 0x00, 0xB1, 0xF5, 0x01 };
const unsigned char PIANO2[12]   PROGMEM = { 0x00, 0x31, 0x49, 0xF2, 0x53, 0x07, 0x01, 0x11, 0x03, 0xF1, 0xF5, 0x00 };
const unsigned char PIANO3[12]   PROGMEM = { 0x00, 0x31, 0x95, 0xD1, 0x83, 0x0D, 0x01, 0x32, 0x03, 0xC1, 0xF5, 0x00 };
const unsigned char HONKTONK[12] PROGMEM = { 0x00, 0x34, 0x9B, 0xF3, 0x63, 0x01, 0x01, 0x11, 0x00, 0x92, 0xF5, 0x01 };
const unsigned char EP1[12]      PROGMEM = { 0x00, 0x27, 0x28, 0xF8, 0xB7, 0x01, 0x02, 0x91, 0x00, 0xF1, 0xF9, 0x00 };
const unsigned char EP2[12]      PROGMEM = { 0x00, 0x1A, 0x2D, 0xF3, 0xEE, 0x01, 0x01, 0x11, 0x00, 0xF1, 0xF5, 0x00 };
const unsigned char HARPSIC[12]  PROGMEM = { 0x00, 0x35, 0x95, 0xF2, 0x58, 0x0F, 0x01, 0x32, 0x02, 0x81, 0xF6, 0x01 };
const unsigned char CLAVIC[12]   PROGMEM = { 0x00, 0x31, 0x85, 0xC9, 0x40, 0x01, 0x00, 0x35, 0x00, 0xC2, 0xB9, 0x01 };
const unsigned char CELESTA[12]  PROGMEM = { 0x00, 0x09, 0x15, 0xC7, 0x64, 0x08, 0x00, 0x01, 0x05, 0xB2, 0x35, 0x00 };
const unsigned char GLOCK[12]    PROGMEM = { 0x00, 0x06, 0x03, 0xF4, 0x44, 0x00, 0x01, 0x01, 0x1B, 0xF2, 0x34, 0x00 };
const unsigned char MUSICBOX[12] PROGMEM = { 0x00, 0x04, 0x06, 0xA9, 0x24, 0x0A, 0x01, 0x01, 0x01, 0xF5, 0x74, 0x00 };
const unsigned char VIBES[12]    PROGMEM = { 0x00, 0xD4, 0x00, 0xF6, 0x33, 0x00, 0x00, 0xF1, 0x00, 0x61, 0xE3, 0x00 };
const unsigned char MARIMBA[12]  PROGMEM = { 0x00, 0xD4, 0x00, 0xF7, 0xE8, 0x04, 0x00, 0xD1, 0x00, 0xA4, 0x64, 0x00 };
const unsigned char XYLO[12]     PROGMEM = { 0x00, 0x36, 0x16, 0xF7, 0xF7, 0x01, 0x00, 0x31, 0x07, 0xB5, 0xF5, 0x00 };
const unsigned char TUBEBELL[12] PROGMEM = { 0x00, 0x03, 0x1B, 0xA2, 0x43, 0x0B, 0x00, 0x00, 0x00, 0xF3, 0x74, 0x00 };
const unsigned char SANTUR[12]   PROGMEM = { 0x00, 0xC3, 0x8E, 0xF8, 0x35, 0x01, 0x01, 0x11, 0x00, 0xC3, 0x94, 0x01 };
const unsigned char ORGAN1[12]   PROGMEM = { 0x00, 0xE2, 0x07, 0xF4, 0x1B, 0x06, 0x01, 0xE0, 0x00, 0xF4, 0x0D, 0x01 };
const unsigned char ORGAN2[12]   PROGMEM = { 0x00, 0xF2, 0x00, 0xF6, 0x2C, 0x04, 0x00, 0xF0, 0x00, 0xF5, 0x0B, 0x01 };
const unsigned char ORGAN3[12]   PROGMEM = { 0x00, 0xF1, 0x06, 0xB6, 0x15, 0x0A, 0x00, 0xF0, 0x00, 0xBF, 0x07, 0x00 };
const unsigned char PIPEORG[12]  PROGMEM = { 0x00, 0x22, 0x03, 0x79, 0x16, 0x08, 0x01, 0xE0, 0x00, 0x6D, 0x08, 0x01 };
const unsigned char REEDORG[12]  PROGMEM = { 0x00, 0x31, 0x27, 0x63, 0x06, 0x01, 0x00, 0x72, 0x00, 0x51, 0x17, 0x01 };
const unsigned char ACORDIAN[12] PROGMEM = { 0x00, 0xB4, 0x1D, 0x53, 0x16, 0x0F, 0x01, 0x71, 0x00, 0x51, 0x17, 0x01 };
const unsigned char HARMONIC[12] PROGMEM = { 0x00, 0x25, 0x29, 0x97, 0x15, 0x01, 0x00, 0x32, 0x00, 0x53, 0x08, 0x01 };
const unsigned char BANDNEON[12] PROGMEM = { 0x00, 0x24, 0x9E, 0x67, 0x15, 0x0F, 0x00, 0x31, 0x00, 0x53, 0x06, 0x01 };
const unsigned char NYLONGT[12]  PROGMEM = { 0x00, 0x13, 0x27, 0xA3, 0xB4, 0x05, 0x01, 0x31, 0x00, 0xD2, 0xF8, 0x00 };
const unsigned char STEELGT[12]  PROGMEM = { 0x00, 0x17, 0xA3, 0xF3, 0x32, 0x01, 0x00, 0x11, 0x00, 0xE2, 0xC7, 0x01 };
const unsigned char JAZZGT[12]   PROGMEM = { 0x00, 0x33, 0x24, 0xD2, 0xC1, 0x0F, 0x01, 0x31, 0x00, 0xF1, 0x9C, 0x00 };
const unsigned char CLEANGT[12]  PROGMEM = { 0x00, 0x31, 0x05, 0xF8, 0x44, 0x01, 0x00, 0x32, 0x02, 0xF2, 0xC9, 0x01 };
const unsigned char MUTEGT[12]   PROGMEM = { 0x00, 0x21, 0x09, 0x9C, 0x7B, 0x07, 0x00, 0x02, 0x03, 0x95, 0xFB, 0x00 };
const unsigned char OVERDGT[12]  PROGMEM = { 0x00, 0x21, 0x84, 0x81, 0x98, 0x07, 0x01, 0x21, 0x04, 0xA1, 0x59, 0x00 };
const unsigned char DISTGT[12]   PROGMEM = { 0x00, 0xB1, 0x0C, 0x78, 0x43, 0x01, 0x00, 0x22, 0x03, 0x91, 0xFC, 0x03 };
const unsigned char GTHARMS[12]  PROGMEM = { 0x00, 0x00, 0x0A, 0x82, 0x8C, 0x09, 0x00, 0x08, 0x02, 0xB4, 0xEC, 0x00 };
const unsigned char ACOUBASS[12] PROGMEM = { 0x00, 0x21, 0x13, 0xAB, 0x46, 0x01, 0x00, 0x21, 0x00, 0x93, 0xF7, 0x00 };
const unsigned char FINGBASS[12] PROGMEM = { 0x00, 0x01, 0x0A, 0xF9, 0x32, 0x01, 0x00, 0x22, 0x04, 0xC1, 0x58, 0x00 };
const unsigned char PICKBASS[12] PROGMEM = { 0x00, 0x21, 0x07, 0xFA, 0x77, 0x0B, 0x00, 0x22, 0x02, 0xC3, 0x6A, 0x00 };
const unsigned char FRETLESS[12] PROGMEM = { 0x00, 0x21, 0x17, 0x71, 0x57, 0x0B, 0x00, 0x21, 0x00, 0x62, 0x87, 0x00 };
const unsigned char SLAPBAS1[12] PROGMEM = { 0x00, 0x25, 0x01, 0xFA, 0x78, 0x07, 0x01, 0x12, 0x00, 0xF3, 0x97, 0x00 };
const unsigned char SLAPBAS2[12] PROGMEM = { 0x00, 0x21, 0x03, 0xFA, 0x88, 0x0D, 0x00, 0x13, 0x00, 0xB3, 0x97, 0x00 };
const unsigned char SYNBASS1[12] PROGMEM = { 0x00, 0x21, 0x09, 0xF5, 0x7F, 0x09, 0x01, 0x23, 0x04, 0xF3, 0xCC, 0x00 };
const unsigned char SYNBASS2[12] PROGMEM = { 0x00, 0x01, 0x10, 0xA3, 0x9B, 0x09, 0x00, 0x01, 0x00, 0x93, 0xAA, 0x00 };
const unsigned char VIOLIN[12]   PROGMEM = { 0x00, 0xE2, 0x19, 0xF6, 0x29, 0x0D, 0x01, 0xE1, 0x00, 0x78, 0x08, 0x01 };
const unsigned char VIOLA[12]    PROGMEM = { 0x00, 0xE2, 0x1C, 0xF6, 0x29, 0x0D, 0x01, 0xE1, 0x00, 0x78, 0x08, 0x01 };
const unsigned char CELLO[12]    PROGMEM = { 0x00, 0x61, 0x19, 0x69, 0x16, 0x0B, 0x01, 0x61, 0x00, 0x54, 0x27, 0x01 };
const unsigned char CONTRAB[12]  PROGMEM = { 0x00, 0x71, 0x18, 0x82, 0x31, 0x0D, 0x01, 0x32, 0x00, 0x61, 0x56, 0x00 };
const unsigned char TREMSTR[12]  PROGMEM = { 0x00, 0xE2, 0x23, 0x70, 0x06, 0x0D, 0x01, 0xE1, 0x00, 0x75, 0x16, 0x01 };
const unsigned char PIZZ[12]     PROGMEM = { 0x00, 0x02, 0x00, 0x88, 0xE6, 0x08, 0x00, 0x61, 0x00, 0xF5, 0xF6, 0x01 };
const unsigned char HARP[12]     PROGMEM = { 0x00, 0x12, 0x20, 0xF6, 0xD5, 0x0F, 0x01, 0x11, 0x80, 0xF3, 0xE3, 0x00 };
const unsigned char TIMPANI[12]  PROGMEM = { 0x00, 0x61, 0x0E, 0xF4, 0xF4, 0x01, 0x01, 0x00, 0x00, 0xB5, 0xF5, 0x00 };
const unsigned char STRINGS[12]  PROGMEM = { 0x00, 0x61, 0x1E, 0x9C, 0x04, 0x0F, 0x01, 0x21, 0x80, 0x71, 0x16, 0x00 };
const unsigned char SLOWSTR[12]  PROGMEM = { 0x00, 0xA2, 0x2A, 0xC0, 0xD6, 0x0F, 0x02, 0x21, 0x00, 0x30, 0x55, 0x01 };
const unsigned char SYNSTR1[12]  PROGMEM = { 0x00, 0x61, 0x21, 0x72, 0x35, 0x0F, 0x01, 0x61, 0x00, 0x62, 0x36, 0x01 };
const unsigned char SYNSTR2[12]  PROGMEM = { 0x00, 0x21, 0x1A, 0x72, 0x23, 0x0F, 0x01, 0x21, 0x02, 0x51, 0x07, 0x00 };
const unsigned char CHOIR[12]    PROGMEM = { 0x00, 0xE1, 0x16, 0x97, 0x31, 0x09, 0x00, 0x61, 0x00, 0x62, 0x39, 0x00 };
const unsigned char OOHS[12]     PROGMEM = { 0x00, 0x22, 0xC3, 0x79, 0x45, 0x01, 0x00, 0x21, 0x00, 0x66, 0x27, 0x00 };
const unsigned char SYNVOX[12]   PROGMEM = { 0x00, 0x21, 0xDE, 0x63, 0x55, 0x01, 0x01, 0x21, 0x00, 0x73, 0x46, 0x00 };
const unsigned char ORCHIT[12]   PROGMEM = { 0x00, 0x42, 0x05, 0x86, 0xF7, 0x0A, 0x00, 0x50, 0x00, 0x74, 0x76, 0x01 };
const unsigned char TRUMPET[12]  PROGMEM = { 0x00, 0x31, 0x1C, 0x61, 0x02, 0x0F, 0x00, 0x61, 0x81, 0x92, 0x38, 0x00 };
const unsigned char TROMBONE[12] PROGMEM = { 0x00, 0x71, 0x1E, 0x52, 0x23, 0x0F, 0x00, 0x61, 0x02, 0x71, 0x19, 0x00 };
const unsigned char TUBA[12]     PROGMEM = { 0x00, 0x21, 0x1A, 0x76, 0x16, 0x0F, 0x00, 0x21, 0x01, 0x81, 0x09, 0x00 };
const unsigned char MUTETRP[12]  PROGMEM = { 0x00, 0x25, 0x28, 0x89, 0x2C, 0x07, 0x02, 0x20, 0x00, 0x83, 0x4B, 0x02 };
const unsigned char FRHORN[12]   PROGMEM = { 0x00, 0x21, 0x1F, 0x79, 0x16, 0x09, 0x00, 0xA2, 0x05, 0x71, 0x59, 0x00 };
const unsigned char BRASS1[12]   PROGMEM = { 0x00, 0x21, 0x19, 0x87, 0x16, 0x0F, 0x00, 0x21, 0x03, 0x82, 0x39, 0x00 };
const unsigned char SYNBRAS1[12] PROGMEM = { 0x00, 0x21, 0x17, 0x75, 0x35, 0x0F, 0x00, 0x22, 0x82, 0x84, 0x17, 0x00 };
const unsigned char SYNBRAS2[12] PROGMEM = { 0x00, 0x21, 0x22, 0x62, 0x58, 0x0F, 0x00, 0x21, 0x02, 0x72, 0x16, 0x00 };
const unsigned char SOPSAX[12]   PROGMEM = { 0x00, 0xB1, 0x1B, 0x59, 0x07, 0x01, 0x01, 0xA1, 0x00, 0x7B, 0x0A, 0x00 };
const unsigned char ALTOSAX[12]  PROGMEM = { 0x00, 0x21, 0x16, 0x9F, 0x04, 0x0B, 0x00, 0x21, 0x00, 0x85, 0x0C, 0x01 };
const unsigned char TENSAX[12]   PROGMEM = { 0x00, 0x21, 0x0F, 0xA8, 0x20, 0x0D, 0x00, 0x23, 0x00, 0x7B, 0x0A, 0x01 };
const unsigned char BARISAX[12]  PROGMEM = { 0x00, 0x21, 0x0F, 0x88, 0x04, 0x09, 0x00, 0x26, 0x00, 0x79, 0x18, 0x01 };
const unsigned char OBOE[12]     PROGMEM = { 0x00, 0x31, 0x18, 0x8F, 0x05, 0x01, 0x00, 0x32, 0x01, 0x73, 0x08, 0x00 };
const unsigned char ENGLHORN[12] PROGMEM = { 0x00, 0xA1, 0x0A, 0x8C, 0x37, 0x01, 0x01, 0x24, 0x04, 0x77, 0x0A, 0x00 };
const unsigned char BASSOON[12]  PROGMEM = { 0x00, 0x31, 0x04, 0xA8, 0x67, 0x0B, 0x00, 0x75, 0x00, 0x51, 0x19, 0x00 };
const unsigned char CLARINET[12] PROGMEM = { 0x00, 0xA2, 0x1F, 0x77, 0x26, 0x01, 0x01, 0x21, 0x01, 0x74, 0x09, 0x00 };
const unsigned char PICCOLO[12]  PROGMEM = { 0x00, 0xE1, 0x07, 0xB8, 0x94, 0x01, 0x01, 0x21, 0x01, 0x63, 0x28, 0x00 };
const unsigned char FLUTE1[12]   PROGMEM = { 0x00, 0xA1, 0x93, 0x87, 0x59, 0x01, 0x00, 0xE1, 0x00, 0x65, 0x0A, 0x00 };
const unsigned char RECORDER[12] PROGMEM = { 0x00, 0x22, 0x10, 0x9F, 0x38, 0x01, 0x00, 0x61, 0x00, 0x67, 0x29, 0x00 };
const unsigned char PANFLUTE[12] PROGMEM = { 0x00, 0xE2, 0x0D, 0x88, 0x9A, 0x01, 0x01, 0x21, 0x00, 0x67, 0x09, 0x00 };
const unsigned char BOTTLEB[12]  PROGMEM = { 0x00, 0xA2, 0x10, 0x98, 0x94, 0x0F, 0x00, 0x21, 0x01, 0x6A, 0x28, 0x00 };
const unsigned char SHAKU[12]    PROGMEM = { 0x00, 0xF1, 0x1C, 0x86, 0x26, 0x0F, 0x00, 0xF1, 0x00, 0x55, 0x27, 0x00 };
const unsigned char WHISTLE[12]  PROGMEM = { 0x00, 0xE1, 0x3F, 0x9F, 0x09, 0x00, 0x00, 0xE1, 0x00, 0x6F, 0x08, 0x00 };
const unsigned char OCARINA[12]  PROGMEM = { 0x00, 0xE2, 0x3B, 0xF7, 0x19, 0x01, 0x00, 0x21, 0x00, 0x7A, 0x07, 0x00 };
const unsigned char SQUARWAV[12] PROGMEM = { 0x00, 0x22, 0x1E, 0x92, 0x0C, 0x0F, 0x00, 0x61, 0x06, 0xA2, 0x0D, 0x00 };
const unsigned char SAWWAV[12]   PROGMEM = { 0x00, 0x21, 0x15, 0xF4, 0x22, 0x0F, 0x01, 0x21, 0x00, 0xA3, 0x5F, 0x00 };
const unsigned char SYNCALLI[12] PROGMEM = { 0x00, 0xF2, 0x20, 0x47, 0x66, 0x03, 0x01, 0xF1, 0x00, 0x42, 0x27, 0x00 };
const unsigned char CHIFLEAD[12] PROGMEM = { 0x00, 0x61, 0x19, 0x88, 0x28, 0x0F, 0x00, 0x61, 0x05, 0xB2, 0x49, 0x00 };
const unsigned char CHARANG[12]  PROGMEM = { 0x00, 0x21, 0x16, 0x82, 0x1B, 0x01, 0x00, 0x23, 0x00, 0xB2, 0x79, 0x01 };
const unsigned char SOLOVOX[12]  PROGMEM = { 0x00, 0x21, 0x00, 0xCA, 0x93, 0x01, 0x00, 0x22, 0x00, 0x7A, 0x1A, 0x00 };
const unsigned char FIFTHSAW[12] PROGMEM = { 0x00, 0x23, 0x00, 0x92, 0xC9, 0x08, 0x01, 0x22, 0x00, 0x82, 0x28, 0x01 };
const unsigned char BASSLEAD[12] PROGMEM = { 0x00, 0x21, 0x1D, 0xF3, 0x7B, 0x0F, 0x00, 0x22, 0x02, 0xC3, 0x5F, 0x00 };
const unsigned char FANTASIA[12] PROGMEM = { 0x00, 0xE1, 0x00, 0x81, 0x25, 0x00, 0x01, 0xA6, 0x86, 0xC4, 0x95, 0x01 };
const unsigned char WARMPAD[12]  PROGMEM = { 0x00, 0x21, 0x27, 0x31, 0x01, 0x0F, 0x00, 0x21, 0x00, 0x44, 0x15, 0x00 };
const unsigned char POLYSYN[12]  PROGMEM = { 0x00, 0x60, 0x14, 0x83, 0x35, 0x0D, 0x02, 0x61, 0x00, 0xD1, 0x06, 0x00 };
const unsigned char SPACEVOX[12] PROGMEM = { 0x00, 0xE1, 0x5C, 0xD3, 0x01, 0x01, 0x01, 0x62, 0x00, 0x82, 0x37, 0x00 };
const unsigned char BOWEDGLS[12] PROGMEM = { 0x00, 0x28, 0x38, 0x34, 0x86, 0x01, 0x02, 0x21, 0x00, 0x41, 0x35, 0x00 };
const unsigned char METALPAD[12] PROGMEM = { 0x00, 0x24, 0x12, 0x52, 0xF3, 0x05, 0x01, 0x23, 0x02, 0x32, 0xF5, 0x01 };
const unsigned char HALOPAD[12]  PROGMEM = { 0x00, 0x61, 0x1D, 0x62, 0xA6, 0x0B, 0x00, 0xA1, 0x00, 0x61, 0x26, 0x00 };
const unsigned char SWEEPPAD[12] PROGMEM = { 0x00, 0x22, 0x0F, 0x22, 0xD5, 0x0B, 0x01, 0x21, 0x84, 0x3F, 0x05, 0x01 };
const unsigned char ICERAIN[12]  PROGMEM = { 0x00, 0xE3, 0x1F, 0xF9, 0x24, 0x01, 0x00, 0x31, 0x01, 0xD1, 0xF6, 0x00 };
const unsigned char SOUNDTRK[12] PROGMEM = { 0x00, 0x63, 0x00, 0x41, 0x55, 0x06, 0x01, 0xA2, 0x00, 0x41, 0x05, 0x01 };
const unsigned char CRYSTAL[12]  PROGMEM = { 0x00, 0xC7, 0x25, 0xA7, 0x65, 0x01, 0x01, 0xC1, 0x05, 0xF3, 0xE4, 0x00 };
const unsigned char ATMOSPH[12]  PROGMEM = { 0x00, 0xE3, 0x19, 0xF7, 0xB7, 0x01, 0x01, 0x61, 0x00, 0x92, 0xF5, 0x01 };
const unsigned char BRIGHT[12]   PROGMEM = { 0x00, 0x66, 0x9B, 0xA8, 0x44, 0x0F, 0x00, 0x41, 0x04, 0xF2, 0xE4, 0x01 };
const unsigned char GOBLIN[12]   PROGMEM = { 0x00, 0x61, 0x20, 0x22, 0x75, 0x0D, 0x00, 0x61, 0x00, 0x45, 0x25, 0x00 };
const unsigned char ECHODROP[12] PROGMEM = { 0x00, 0xE1, 0x21, 0xF6, 0x84, 0x0F, 0x00, 0xE1, 0x01, 0xA3, 0x36, 0x00 };
const unsigned char STARTHEM[12] PROGMEM = { 0x00, 0xE2, 0x14, 0x73, 0x64, 0x0B, 0x01, 0xE1, 0x01, 0x98, 0x05, 0x01 };
const unsigned char SITAR[12]    PROGMEM = { 0x00, 0x21, 0x0B, 0x72, 0x34, 0x09, 0x00, 0x24, 0x02, 0xA3, 0xF6, 0x01 };
const unsigned char BANJO[12]    PROGMEM = { 0x00, 0x21, 0x16, 0xF4, 0x53, 0x0D, 0x00, 0x04, 0x00, 0xF6, 0xF8, 0x00 };
const unsigned char SHAMISEN[12] PROGMEM = { 0x00, 0x21, 0x18, 0xDA, 0x02, 0x0D, 0x00, 0x35, 0x00, 0xF3, 0xF5, 0x00 };
const unsigned char KOTO[12]     PROGMEM = { 0x00, 0x25, 0x0F, 0xFA, 0x63, 0x09, 0x00, 0x02, 0x00, 0x94, 0xE5, 0x01 };
const unsigned char KALIMBA[12]  PROGMEM = { 0x00, 0x32, 0x07, 0xF9, 0x96, 0x01, 0x00, 0x11, 0x00, 0x84, 0x44, 0x00 };
const unsigned char BAGPIPE[12]  PROGMEM = { 0x00, 0x20, 0x0E, 0x97, 0x18, 0x09, 0x02, 0x25, 0x03, 0x83, 0x18, 0x01 };
const unsigned char FIDDLE[12]   PROGMEM = { 0x00, 0x61, 0x18, 0xF6, 0x29, 0x01, 0x00, 0x62, 0x01, 0x78, 0x08, 0x01 };
const unsigned char SHANNAI[12]  PROGMEM = { 0x00, 0xE6, 0x21, 0x76, 0x19, 0x0B, 0x00, 0x61, 0x03, 0x8E, 0x08, 0x01 };
const unsigned char TINKLBEL[12] PROGMEM = { 0x00, 0x27, 0x23, 0xF0, 0xD4, 0x01, 0x00, 0x05, 0x09, 0xF2, 0x46, 0x00 };
const unsigned char AGOGO[12]    PROGMEM = { 0x00, 0x1C, 0x0C, 0xF9, 0x31, 0x0F, 0x01, 0x15, 0x00, 0x96, 0xE8, 0x01 };
const unsigned char STEELDRM[12] PROGMEM = { 0x00, 0x02, 0x00, 0x75, 0x16, 0x06, 0x02, 0x01, 0x00, 0xF6, 0xF6, 0x01 };
const unsigned char WOODBLOK[12] PROGMEM = { 0x00, 0x25, 0x1B, 0xFA, 0xF2, 0x01, 0x00, 0x12, 0x00, 0xF6, 0x9A, 0x00 };
const unsigned char TAIKO[12]    PROGMEM = { 0x00, 0x02, 0x1D, 0xF5, 0x93, 0x01, 0x00, 0x00, 0x00, 0xC6, 0x45, 0x00 };
const unsigned char MELOTOM[12]  PROGMEM = { 0x00, 0x11, 0x15, 0xF5, 0x32, 0x05, 0x00, 0x10, 0x00, 0xF4, 0xB4, 0x00 };
const unsigned char SYNDRUM[12]  PROGMEM = { 0x00, 0x22, 0x06, 0xFA, 0x99, 0x09, 0x00, 0x01, 0x00, 0xD5, 0x25, 0x00 };
const unsigned char REVRSCYM[12] PROGMEM = { 0x00, 0x2E, 0x00, 0xFF, 0x00, 0x0F, 0x02, 0x0E, 0x0E, 0x21, 0x2D, 0x00 };
const unsigned char FRETNOIS[12] PROGMEM = { 0x00, 0x30, 0x0B, 0x56, 0xE4, 0x01, 0x01, 0x17, 0x00, 0x55, 0x87, 0x02 };
const unsigned char BRTHNOIS[12] PROGMEM = { 0x00, 0x24, 0x00, 0xFF, 0x03, 0x0D, 0x00, 0x05, 0x08, 0x98, 0x87, 0x01 };
const unsigned char SEASHORE[12] PROGMEM = { 0x00, 0x0E, 0x00, 0xF0, 0x00, 0x0F, 0x02, 0x0A, 0x04, 0x17, 0x04, 0x03 };
const unsigned char BIRDS[12]    PROGMEM = { 0x00, 0x20, 0x08, 0xF6, 0xF7, 0x01, 0x00, 0x0E, 0x05, 0x77, 0xF9, 0x02 };
const unsigned char TELEPHON[12] PROGMEM = { 0x00, 0x20, 0x14, 0xF1, 0x08, 0x01, 0x00, 0x2E, 0x02, 0xF4, 0x08, 0x00 };
const unsigned char HELICOPT[12] PROGMEM = { 0x00, 0x20, 0x04, 0xF2, 0x00, 0x03, 0x01, 0x23, 0x00, 0x36, 0x05, 0x01 };
const unsigned char APPLAUSE[12] PROGMEM = { 0x00, 0x2E, 0x00, 0xFF, 0x02, 0x0F, 0x00, 0x2A, 0x05, 0x32, 0x55, 0x03 };
