# GNUmakefile
.NOTPARALLEL:
.RECIPEPREFIX := _

#=== fix1.sed begins ===
# 1i\
# %define W word\
# %define B byte
# /CODE_SEG/d
# /ENDP/d
# /END /d
# s/\[0\]//
# s/ \+PROC .*/:/
# s/ES:\[/[ES:/
# s/40://
# /^\([^; ]\+\) \+D\([BW]\)\(.*\)/{
# h
# s//_\1:\
# D\2 \3/
# x
# s//%define \1 \2[_\1]/w inv0.inc
# g
# }
# s/ \+DD \+0/:\
# DW 0,0/
#=== fix1.sed ends ===

#=== fix2.sed begins ===
# /%line/d
# s/\]\[/+/
# s/\[2\]/+2/
# /\[[bw][a-z]\+\[/s/\[//
# s/\]+BX/+BX/
# s/Word Ptr \([^,]\+\)/word[\1]/
# s/,Offset/,/
# /LEA /{
# s//MOV /
# s/,/,OFFSET/
# }
# /,OFFSET/{
# s/,.*\[/,/
# s/\]$//
# }
#=== fix2.sed ends ===

#=== fix3.sed begins ===
# /RemoveNewInt9:/,/ RET/s/OldInt9Addr/cs:&/
# /NewInt9Handler:/,/NotIntercept:/s/\[/[cs:/
# /NotIntercept:/,/CLC/s/_StoreAX/cs:&/
#=== fix3.sed ends ===

.PHONY: all check clean cleanall

#http://exactcode.com/opensource/minised/
#http://dl.exactcode.de/oss/minised/minised-1.15.tar.gz
SED=minised

PROG=inv-nasm
GAMEZIP=invadr11.zip
OLDASM=INVADERS.ASM
NASM=nasm
NASMFLAGS=-fbin -O9
MD5SUM=md5sum
WGET=wget
WGETOPT=-q
UNZIPPER=unzip
UNZIPFLAGS=-qjan

#GAMEURL=ftp.lanet.lv/ftp/mirror/x2ftp/msdos/programming/gamesrc/
GAMEURL=www.ibiblio.org/pub/micro/pc-stuff/freedos/files/games/invaders/

all: $(PROG).com check

$(PROG).com: inv2.asm
_$(NASM) $(NASMFLAGS) $< -o $@

fix1.sed fix2.sed fix3.sed: $(lastword $(MAKEFILE_LIST))
_@$(SED) -n -e '/$@ begins ===/,/$@ ends ===/s/^# \+//w $@' $<

inv1.asm inv0.inc: fix1.sed $(OLDASM)
_$(SED) -f $^ >$@

inv2.asm: inv1.asm inv0.inc fix2.sed fix3.sed
_$(NASM) -P$(word 2,$^) -e $< | $(SED) -f $(word 3,$^) -f $(word 4,$^) >$@

$(GAMEZIP):
_@$(WGET) $(WGETOPT) $(GAMEURL)$(GAMEZIP)

$(OLDASM): $(GAMEZIP)
_@$(UNZIPPER) $(UNZIPFLAGS) $< INVADERS/$@ >/dev/null

check: $(PROG).com
_@$(MD5SUM) $<
_@echo 5d6fa26af01606feb90f17e014390139 \ $<

clean:
_@$(RM) inv0.inc inv?.asm fix?.sed

cleanall: clean
_@$(RM) $(PROG).com

# EOF
