/* REXX */

call time 'r'

srcfile='INVADERS.ASM' ; jumpnum=0 ; cseg=0
outfile='inv.a86' ; incfile=delstr(outfile,pos('.',outfile))'.inc'

if arg(1)='/v' then lineno=1 ; else lineno=0

if lines(srcfile)=1 then do while lines(srcfile) \= 0
  call grab
end
else do lines(srcfile)
  call grab
end

say 'Elapsed:' format(time('e'),,2) 'secs.' ; say

say 'assemble  : a86 inv.a86    (or "a86 +ESP0 *.a86 inv-a86")'
say '.COM size : 9,194 bytes'
say 'CRC32     : CDFE86FA'

exit

grab:
  line=linein(srcfile)
  call datainc ; call misc ; call jmpshort ; call insertseg
  call writeout line
  if lineno > 0 then do
    if right(lineno,2)='00' then say 'lineno='lineno ; lineno=lineno+1
  end
return

misc: procedure expose line incfile
  if found('BEGIN:') then line=line 'include' incfile ; call omit '[0]'
return

datainc: procedure expose line incfile
  if left(line,1) \= ';' & words(line) > 1 & ,
    wordlength(line,2)=2 & left(word(line,2),1)='D' then
      size=substr(word(line,2),2,1)
      if verify(size,'BW','m') then do
        call lineout incfile,'EXTRN' word(line,1)':'size
      end
return

jmpshort: procedure expose line jumpnum
  noshort='#$%&,./123456789=>DGJMOPQRSTUVWXYZ[\]^_`abcdefy'
  j='JMP ' ; p=pos(j,line)
  if left(line,1) \= ';' & p \= 0 then do
    jumpnum=jumpnum+1
    if pos(d2c(jumpnum+c2d(' ')),noshort)=0 then
      line=insert('SHORT',line,p+length(j))
  end
return

insertseg: procedure expose line outfile cseg
  if (found('RemoveNewInt9') & found('PROC ')) | found('CLC') then
    cseg = \cseg
  if cseg then do
    call omit '40:'
    if found(',W') | found('StoreAX') | foundend(',0') | foundend(',1') then
      call writeout 'cs:'
  end
return

found: procedure expose line
return min(1,pos(arg(1),line))

foundend: procedure expose line
return right(line,length(arg(1)))=arg(1)

omit: procedure expose line
  p=pos(arg(1),line) ; if p \= 0 then line=delstr(line,p,length(arg(1)))
return

writeout: procedure expose outfile
  call lineout outfile,arg(1)
return

/* EOF */
