#!/bin/awk -f
BEGIN {
  ASM="inv-wat.asm";INC="inv-wat.inc"
  print "B equ byte ptr\nW equ word ptr\ninclude",INC >ASM
}

/^;/ || /^ *$/ { next }
/ PROC / { print >ASM ; next }
/LEA / { sub("LEA ","MOV "); sub(",",",OFFSET "); print >ASM; next }
/[+]BX/ {
  c=index($0,"["); s=substr($0,c+1,index($0,"]")-c-length("+BX]"))
  sub("\\[.*\\]","s_" s "[" s "+BX]")
}

!/O[fF]/ && /\[[0-9]\]/ {
  b=index($0,"[")
  for(i=b;i;i--) {
    c=substr($0,i,1)
    if ((c==",") || (c==" ")) {
      s=substr($0,i+1,b-i-1); sub(s,"s_" s "[" s "]"); break
    }
  }
}

$2 ~ /^D[BWD]$/ {
  sub(" DD "," DW 0,")
  print "s_" $1,"equ",substr($2,2,1) >INC
  print >ASM; next
}

{
  sub(";.*|Word Ptr",""); sub("40:","DS:"); sub(","," ")

  if ($1 ~ /:$/) {
    print $1 >ASM
    for(i=2;i <= NF;i++)$(i-1)=$i; $NF=""; NF--
  }

  if (((NF > 2) && ($2 ~ /^[A-Z][a-zA-Z][a-zA-Z][^ ]*/)) ||
     (($1 ~ /DEC|INC/) && ($2 ~ /^[A-Z][a-zA-Z][a-zA-Z][^ ]*/)))
    $2="s_"$2"["$2"]"
  else if (($3 ~ /^[A-Z][a-zA-Z][a-zA-Z][^ ]*/) && ($3 !~ /^O[fF]/))
    $3="s_"$3"["$3"]"

  for(i=1;i <= NF;i++)
    printf "%s%c%s",$i,(i==2 && NF > 2)?",":" ",(i==NF)?"\n":"" >ASM
}
# EOF
