@echo off

rem Sets up the Qtetris package for building with the specified compiler,
rem and if possible converting text files from LF to CR/LF format.
rem Based in `fix.bat' of the Allegro library.

if [%2] == [--quick] set NOCONV=1

if [%1] == [bcc32]   goto bcc32
if [%1] == [djgpp]   goto djgpp
if [%1] == [mingw32] goto mingw32
if [%1] == [msvc]    goto msvc
if [%1] == [rsxnt]   goto rsxnt
if [%1] == [watcom]  goto watcom

if [%1] == [help]    goto help
if [%1] == []        goto help

goto done

:bcc32

set MAKEFILE=makefile.bcc
set NOCONV=1
goto fix

:djgpp

set MAKEFILE=makefile.dj
goto fix

:mingw32

set MAKEFILE=makefile.mgw
set NOCONV=1
goto fix

:msvc

set MAKEFILE=makefile.vc
goto fix

:rsxnt

set MAKEFILE=makefile.rsx
goto fix

:watcom

set MAKEFILE=makefile.wat
goto fix

:help

echo.
echo Usage: fix platform [--quick]
echo.
echo Where platform is one of: bcc32, djgpp, dll, mingw32, msvc, rsxnt or watcom.
echo The --quick parameter is used to turn off LF to CR/LF conversion.
echo.
goto done

:fix

echo Configuring Qtetris...

echo # generated by fix.bat > makefile
echo MAKEFILE_INC = %MAKEFILE% >> makefile
echo include makefile.all >> makefile

if [%NOCONV%] == [1] goto done

echo Converting Qtetris files...

cd ..
utod .../*.c .../*.h .../makefile.* .../*.cfg
utod .../*.txt .../*.arg
cd src

:done

set MAKEFILE=
set NOCONV=

echo Done!
