/*
 * four-in-a-row game
 * Copyright (c) 2017 Andreas K. Foerster <info@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
For Unix and DOS
This is an exercise in retroprogramming.
It can be compiled for 16-bit systems with bcc - Bruce's C compiler.

The board is internally x: 0-6, y: 0-5, with 0,0 is bottom left
*/

#ifndef __ROW4_H
#define __ROW4_H

#ifdef DEUTSCH
#define TITLE "VIER IN EINER REIHE"
#define AUTHOR "Andreas K. Foerster"
#define PLAYERS "Ende mit \"E\", Lizenz mit \"L\"\r\n1 oder 2 Spieler? "
#define ENTER "Bitte Enter druecken..."
#define COMMENT "Gib die Spalte an, \"N\": neu, \"E\": Ende"
#define WINMSG "? gewinnt!"
#define OPTIONERROR "Unbekannte Option"
#else /* ENGLISH */
#define TITLE "FOUR IN A ROW"
#define AUTHOR "Andreas K. Foerster"
#define PLAYERS "Exit with \"E\", license with \"L\"\r\n1 or 2 players? "
#define ENTER "Press Enter..."
#define COMMENT "enter column, \"n\": new, \"e\": exit"
#define WINMSG "? wins!"
#define OPTIONERROR "Unknown option"
#endif

#define FALSE 0
#define TRUE 1

#define NONE 0
#define PLAYER1 1
#define PLAYER2 2
#define BOTH 3

#define ERROR (-1)
#define NEW (-2)

#define MOD_ASCII 1

#ifdef __STDC__
#define P(x) x
#else
#define P(x) ()
#endif

typedef unsigned char byte;

extern const char *const copyright;
extern const char *const license;

/*
The board is defined as follows:
The lower 2 bit are the chips, 1 or 2.
The next 2 bit are threats, 1 or 2 or 3 for both.
A field with a chip is never a threat.

So, if you want to ignore the threats use (board[x][y] & 3).
To see if there are threats, check if (board[x][y] > 3).
*/
extern byte board[7][6], filled[7];
extern short chips;

/*
 * logics
 */

/* initialize or clear board */
void reset_board P((void));

/* is this slot full? */
#define full(x) (filled[x] >= 6)

/* make a move */
/* returns y or ERROR */
int drop P((int player, int x));

/* check if last move wins */
/* returns TRUE or FALSE */
int wincheck P((void));

/* returns x or ERROR */
int compute P((int player));


/*
 * user interface
 */

/* Use this to initialize the output */
void initialize P((int));

int ask_players P((void));

void draw_board P((void));
void clear_board P((void));

/* puts chip for player in specified position */
void chip P((int x, int y, int player));

/* return slot number, or ERROR, or NEW */
int ask_slot P((int player));

/* show that the player has won */
void win P((int player));

#endif
