/*
 * low-level stuff for bcc
 * Copyright (c) 2017 Andreas K. Foerster <info@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef BCC_SYST_H
#define BCC_SYST_H

#include <stddef.h>
#include "row4.h"

void bcc_clear_screen P_((void));
void bcc_clear_rest P_((void)); /* rest of line */
void bcc_position P_((int x, int y));
void bcc_character P_((int));
void bcc_print P_((const char *));
void bcc_set_attribute P_((int));
int bcc_get_attribute P_((void));
void bcc_beep P_((void));
void bcc_bcc_usleep P_((unsigned long)); /* microseconds, max. 4s */
void bcc_idle P_((void));

/* initialize mouse */
/* don't call the other functions when this returns 0 */
int bcc_check_mouse P_((void));

/* hide the mouse before you print something */
void bcc_show_mouse P_((int));

/* returns button state */
int bcc_mouse_status P_((int *x, int *y));

#endif
