/*
 * four-in-a-row game
 * Copyright (c) 2017 Andreas K. Foerster <info@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include "row4.h"

static byte mode, players, player;

int main P_ ((int, char **));
static void help P_ ((void));
static void version P_ ((void));
static void options P_ ((int, char **));
static void optionerror P_ ((const char *));
static int ask P_ ((void));
static void play_round P_ ((void));

#if defined(__MSDOS__) || defined(_WIN32)
#define charset()
#else
static void system_charset P_ ((void));
#define charset()  system_charset()
#endif

#define cputs(s)  write (STDOUT_FILENO, (s), strlen (s))


int
main (argc, argv)
     int argc;
     char **argv;
{
  mode = MOD_VT100;
  player = 1;

  charset ();
  messages (unknown_language);
  options (argc, argv);

  initialize (mode);
  players = ask_players ();

  draw_board ();
  reset_board ();

  while (1)
    play_round ();

  return EXIT_SUCCESS;
}


static void
help ()
{
  cputs (msg.title);
  cputs ("\r\n");
  cputs (msg.copyright);

#ifdef __MSDOS__
  cputs ("\r\n\nOptions:\r\n"
	 "  /?\t\thelp\r\n"
	 "  /L\t\tlicense\r\n"
	 "  /E\t\tenglish\r\n" "  /D\t\tdeutsch (German)\r\n");
#else
  cputs ("\r\n\nOptions:\r\n"
	 "  -h, --help\t\thelp\r\n"
	 "  -l, --version\t\tlicense\r\n"
	 "  -e\t\t\tenglish\r\n" "  -d\t\t\tdeutsch (German)\r\n");
#endif

#if !defined(__MSDOS__) && !defined(_WIN32) && !defined(_WIN64)
  cputs ("  -v, --vt100\t\tVT100 special graphics charset\r\n"
	 "  -u, --utf8\t\tUTF-8\n" "  -a, --ascii\t\tASCII\r\n\n");
#endif

  exit (EXIT_SUCCESS);
}


static void
version ()
{
  cputs (msg.title);
  cputs ("\r\n");
  cputs (msg.copyright);
  cputs ("\r\n\n");
  cputs (msg.license_text);
  cputs ("\r\n");

  exit (EXIT_SUCCESS);
}


static void
optionerror (option)
     const char *option;
{
  write (STDERR_FILENO, msg.optionerror, strlen (msg.optionerror));
  write (STDERR_FILENO, ": ", 2);
  write (STDERR_FILENO, option, strlen (option));
  write (STDERR_FILENO, "\n", 1);

  exit (EXIT_FAILURE);
}


static void
options (argc, argv)
     int argc;
     char **argv;
{
  int i;

  for (i = 1; i < argc; ++i)
    {
      if (!strcmp (argv[i], "--help") || !strcmp (argv[i], "-h")
	  || !strcmp (argv[i], "/?"))
	help ();
      else if (!strcmp (argv[i], "--version")
	       || !strcmp (argv[i], "-l") || !strcasecmp (argv[i], "/l"))
	version ();
      else if (!strcmp (argv[i], "-a") || !strcasecmp (argv[i], "/a")
	       || !strcmp (argv[i], "--ascii"))
	mode = MOD_ASCII;
      else if (!strcmp (argv[i], "-u") || !strcasecmp (argv[i], "/u")
	       || !strcmp (argv[i], "--utf8"))
	mode = MOD_UTF8;
      else if (!strcmp (argv[i], "-v") || !strcasecmp (argv[i], "/v")
	       || !strcmp (argv[i], "--vt100"))
	mode = MOD_VT100;
      else if (!strcmp (argv[i], "-e") || !strcasecmp (argv[i], "/e"))
	messages (english);
      else if (!strcmp (argv[i], "-d") || !strcasecmp (argv[i], "/d"))
	messages (deutsch);
      else
	optionerror (argv[i]);
    }
}


/* returns slot or -1 */
static int
ask ()
{
  int r;

  do
    r = ask_slot (player);
  while (r >= 0 && (chips <= 0 || full (r)));

  return r;
}


static void
play_round ()
{
  int starter = PLAYER1;

  while (chips)
    {
      int x;

      if (chips == 42)
	starter = player;

      if (players == 2 || player == 1)
	x = ask ();
      else
	x = compute (player);

      if (x < 0)
	{
	  chips = 0;
	  player = starter;
	}
      else
	{
	  chip (x, drop (player, x), player);

	  if (wincheck ())
	    {
	      win (player);
	      chips = 0;

	      x = ask ();
	      player = starter;
	    }
	}

      /* next player */
      player = (player == 1) ? 2 : 1;
    }

  reset_board ();
  draw_board ();
}


#if !defined(__MSDOS__) && !defined(_WIN32)
static void
system_charset ()
{
  const char *l;

  if (!(l = getenv ("LC_ALL")) && !(l = getenv ("LC_CTYPE"))
      && !(l = getenv ("LANG")))
    return;

  /* UTF-8 or not? */
  if (strstr (l, "UTF") || strstr (l, "utf"))
    mode = MOD_UTF8;

  /*
     Terminals using UTF-8 may be locked to that charset
     and no longer support switching.
   */
}
#endif


#ifdef __DJGPP__
#undef __STRICT_ANSI__
#include <crt0.h>

/* this switches off globbing and allows the option /? to work */
char **
__crt0_glob_function (arg)
     char *arg;
{
  (void) arg;
  return NULL;
}

/* no need for environment file */
void
__crt0_load_environment_file (name)
     char *name;
{
  (void) name;
}
#endif
