
 id=F14;
 object[id].max_draw_dist=5000;
 object[id].always_draw_dist=50;

 object[id].nvertices = 458;
 object[id].nfacets   = 300; /* Excluding control surface polys */
 object[id].nctrl_srf =  17;

 object[id].ctrl_surface[0].hinge.x      =   0.43;
 object[id].ctrl_surface[0].hinge.y      =   3.26;
 object[id].ctrl_surface[0].hinge.z      =   0.45;
 object[id].ctrl_surface[0].rudder_gain  =   0;
 object[id].ctrl_surface[0].aileron_gain =   0;
 object[id].ctrl_surface[0].elevator_gain=   0;
 object[id].ctrl_surface[0].flap_gain    =   0.71; /* 17 = 24 * 0.71 */
 object[id].ctrl_surface[0].brake_gain   =   0;
 object[id].ctrl_surface[0].gear_gain    =   0;
 object[id].ctrl_surface[0].gear_id      =   0;
 object[id].ctrl_surface[0].nctrlpoly    =   2;
 object[id].ctrl_surface[0].poly_id[0]   = 300;
 object[id].ctrl_surface[0].poly_id[1]   = 302;

 object[id].ctrl_surface[1].hinge.x      =   0.43;
 object[id].ctrl_surface[1].hinge.y      =  -3.26;
 object[id].ctrl_surface[1].hinge.z      =   0.45;
 object[id].ctrl_surface[1].rudder_gain  =   0;
 object[id].ctrl_surface[1].aileron_gain =   0;
 object[id].ctrl_surface[1].elevator_gain=   0;
 object[id].ctrl_surface[1].flap_gain    =   0.71;
 object[id].ctrl_surface[1].brake_gain   =   0;
 object[id].ctrl_surface[1].gear_gain    =   0;
 object[id].ctrl_surface[1].gear_id      =   0;
 object[id].ctrl_surface[1].nctrlpoly    =   2;
 object[id].ctrl_surface[1].poly_id[0]   = 301;
 object[id].ctrl_surface[1].poly_id[1]   = 303;

 object[id].ctrl_surface[2].hinge.x      =  -1.20;
 object[id].ctrl_surface[2].hinge.y      =   4.16;
 object[id].ctrl_surface[2].hinge.z      =   0.48;
 object[id].ctrl_surface[2].rudder_gain  =   0;
 object[id].ctrl_surface[2].aileron_gain =   0;
 object[id].ctrl_surface[2].elevator_gain=   0;
 object[id].ctrl_surface[2].flap_gain    =  -1.46; /* 35 = 24 * 1.46 */
 object[id].ctrl_surface[2].brake_gain   =   0;
 object[id].ctrl_surface[2].gear_gain    =   0;
 object[id].ctrl_surface[2].gear_id      =   0;
 object[id].ctrl_surface[2].nctrlpoly    =   2;
 object[id].ctrl_surface[2].poly_id[0]   = 304;
 object[id].ctrl_surface[2].poly_id[1]   = 306;

 object[id].ctrl_surface[3].hinge.x      =  -1.20;
 object[id].ctrl_surface[3].hinge.y      =  -4.16;
 object[id].ctrl_surface[3].hinge.z      =   0.48;
 object[id].ctrl_surface[3].rudder_gain  =   0;
 object[id].ctrl_surface[3].aileron_gain =   0;
 object[id].ctrl_surface[3].elevator_gain=   0;
 object[id].ctrl_surface[3].flap_gain    =  -1.46;
 object[id].ctrl_surface[3].brake_gain   =   0;
 object[id].ctrl_surface[3].gear_gain    =   0;
 object[id].ctrl_surface[3].gear_id      =   0;
 object[id].ctrl_surface[3].nctrlpoly    =   2;
 object[id].ctrl_surface[3].poly_id[0]   = 305;
 object[id].ctrl_surface[3].poly_id[1]   = 307;

 object[id].ctrl_surface[4].hinge.x      =  -1.20;
 object[id].ctrl_surface[4].hinge.y      =   4.16;
 object[id].ctrl_surface[4].hinge.z      =   0.48;
 object[id].ctrl_surface[4].rudder_gain  =   0;
 object[id].ctrl_surface[4].aileron_gain =   0;
 object[id].ctrl_surface[4].elevator_gain=   0;
 object[id].ctrl_surface[4].flap_gain    =  -1.46;
 object[id].ctrl_surface[4].brake_gain   =   0;
 object[id].ctrl_surface[4].gear_gain    =   0;
 object[id].ctrl_surface[4].gear_id      =   0;
 object[id].ctrl_surface[4].nctrlpoly    =   4;
 object[id].ctrl_surface[4].poly_id[0]   = 308;
 object[id].ctrl_surface[4].poly_id[1]   = 310;
 object[id].ctrl_surface[4].poly_id[2]   = 312;
 object[id].ctrl_surface[4].poly_id[3]   = 314;

 object[id].ctrl_surface[5].hinge.x      =  -1.20;
 object[id].ctrl_surface[5].hinge.y      =  -4.16;
 object[id].ctrl_surface[5].hinge.z      =   0.48;
 object[id].ctrl_surface[5].rudder_gain  =   0;
 object[id].ctrl_surface[5].aileron_gain =   0;
 object[id].ctrl_surface[5].elevator_gain=   0;
 object[id].ctrl_surface[5].flap_gain    =  -1.46;
 object[id].ctrl_surface[5].brake_gain   =   0;
 object[id].ctrl_surface[5].gear_gain    =   0;
 object[id].ctrl_surface[5].gear_id      =   0;
 object[id].ctrl_surface[5].nctrlpoly    =   4;
 object[id].ctrl_surface[5].poly_id[0]   = 309;
 object[id].ctrl_surface[5].poly_id[1]   = 311;
 object[id].ctrl_surface[5].poly_id[2]   = 313;
 object[id].ctrl_surface[5].poly_id[3]   = 315;

 object[id].ctrl_surface[6].hinge.x      =  -1.71;
 object[id].ctrl_surface[6].hinge.y      =   8.91;
 object[id].ctrl_surface[6].hinge.z      =   0.64;
 object[id].ctrl_surface[6].rudder_gain  =   0;
 object[id].ctrl_surface[6].aileron_gain =   0;
 object[id].ctrl_surface[6].elevator_gain=   0;
 object[id].ctrl_surface[6].flap_gain    =   0;
 object[id].ctrl_surface[6].brake_gain   =   0;
 object[id].ctrl_surface[6].gear_gain    =   0;
 object[id].ctrl_surface[6].gear_id      =   0;
 object[id].ctrl_surface[6].nctrlpoly    =   2;
 object[id].ctrl_surface[6].poly_id[0]   = 316;
 object[id].ctrl_surface[6].poly_id[1]   = 318;

 object[id].ctrl_surface[7].hinge.x      =  -1.71;
 object[id].ctrl_surface[7].hinge.y      =  -8.91;
 object[id].ctrl_surface[7].hinge.z      =   0.64;
 object[id].ctrl_surface[7].rudder_gain  =   0;
 object[id].ctrl_surface[7].aileron_gain =   0;
 object[id].ctrl_surface[7].elevator_gain=   0;
 object[id].ctrl_surface[7].flap_gain    =   0;
 object[id].ctrl_surface[7].brake_gain   =   0;
 object[id].ctrl_surface[7].gear_gain    =   0;
 object[id].ctrl_surface[7].gear_id      =   0;
 object[id].ctrl_surface[7].nctrlpoly    =   2;
 object[id].ctrl_surface[7].poly_id[0]   = 317;
 object[id].ctrl_surface[7].poly_id[1]   = 319;

 object[id].ctrl_surface[8].hinge.x      =  -5.15;
 object[id].ctrl_surface[8].hinge.y      =   2.31;
 object[id].ctrl_surface[8].hinge.z      =  -0.03;
 object[id].ctrl_surface[8].rudder_gain  =   0;
 object[id].ctrl_surface[8].aileron_gain =  -1;
 object[id].ctrl_surface[8].elevator_gain=   1;
 object[id].ctrl_surface[8].flap_gain    =   0;
 object[id].ctrl_surface[8].brake_gain   =   0;
 object[id].ctrl_surface[8].gear_gain    =   0;
 object[id].ctrl_surface[8].gear_id      =   0;
 object[id].ctrl_surface[8].nctrlpoly    =   6;
 object[id].ctrl_surface[8].poly_id[0]   = 320;
 object[id].ctrl_surface[8].poly_id[1]   = 322;
 object[id].ctrl_surface[8].poly_id[2]   = 324;
 object[id].ctrl_surface[8].poly_id[3]   = 326;
 object[id].ctrl_surface[8].poly_id[4]   = 328;
 object[id].ctrl_surface[8].poly_id[5]   = 330;

 object[id].ctrl_surface[9].hinge.x      =  -5.15;
 object[id].ctrl_surface[9].hinge.y      =  -2.31;
 object[id].ctrl_surface[9].hinge.z      =  -0.03;
 object[id].ctrl_surface[9].rudder_gain  =   0;
 object[id].ctrl_surface[9].aileron_gain =   1;
 object[id].ctrl_surface[9].elevator_gain=   1;
 object[id].ctrl_surface[9].flap_gain    =   0;
 object[id].ctrl_surface[9].brake_gain   =   0;
 object[id].ctrl_surface[9].gear_gain    =   0;
 object[id].ctrl_surface[9].gear_id      =   0;
 object[id].ctrl_surface[9].nctrlpoly    =   6;
 object[id].ctrl_surface[9].poly_id[0]   = 321;
 object[id].ctrl_surface[9].poly_id[1]   = 323;
 object[id].ctrl_surface[9].poly_id[2]   = 325;
 object[id].ctrl_surface[9].poly_id[3]   = 327;
 object[id].ctrl_surface[9].poly_id[4]   = 329;
 object[id].ctrl_surface[9].poly_id[5]   = 331;

 object[id].ctrl_surface[10].hinge.x      =  -5.50;
 object[id].ctrl_surface[10].hinge.y      =   1.45;
 object[id].ctrl_surface[10].hinge.z      =   0.58;
 object[id].ctrl_surface[10].rudder_gain  =  -1;
 object[id].ctrl_surface[10].aileron_gain =   0;
 object[id].ctrl_surface[10].elevator_gain=   0;
 object[id].ctrl_surface[10].flap_gain    =   0;
 object[id].ctrl_surface[10].brake_gain   =   0;
 object[id].ctrl_surface[10].gear_gain    =   0;
 object[id].ctrl_surface[10].gear_id      =   0;
 object[id].ctrl_surface[10].nctrlpoly    =   2;
 object[id].ctrl_surface[10].poly_id[0]   = 332;
 object[id].ctrl_surface[10].poly_id[1]   = 333;

 object[id].ctrl_surface[11].hinge.x      =  -5.50;
 object[id].ctrl_surface[11].hinge.y      =  -1.45;
 object[id].ctrl_surface[11].hinge.z      =   0.58;
 object[id].ctrl_surface[11].rudder_gain  =  -1;
 object[id].ctrl_surface[11].aileron_gain =   0;
 object[id].ctrl_surface[11].elevator_gain=   0;
 object[id].ctrl_surface[11].flap_gain    =   0;
 object[id].ctrl_surface[11].brake_gain   =   0;
 object[id].ctrl_surface[11].gear_gain    =   0;
 object[id].ctrl_surface[11].gear_id      =   0;
 object[id].ctrl_surface[11].nctrlpoly    =   2;
 object[id].ctrl_surface[11].poly_id[0]   = 334;
 object[id].ctrl_surface[11].poly_id[1]   = 335;

 object[id].ctrl_surface[12].hinge.x      =  -4.80;
 object[id].ctrl_surface[12].hinge.y      =   0;
 object[id].ctrl_surface[12].hinge.z      =  -0.05;
 object[id].ctrl_surface[12].rudder_gain  =   0;
 object[id].ctrl_surface[12].aileron_gain =   0;
 object[id].ctrl_surface[12].elevator_gain=   0;
 object[id].ctrl_surface[12].flap_gain    =   0;
 object[id].ctrl_surface[12].brake_gain   = -60;
 object[id].ctrl_surface[12].gear_gain    =   0;
 object[id].ctrl_surface[12].gear_id      =   0;
 object[id].ctrl_surface[12].nctrlpoly    =   4;
 object[id].ctrl_surface[12].poly_id[0]   = 336;
 object[id].ctrl_surface[12].poly_id[1]   = 337;
 object[id].ctrl_surface[12].poly_id[2]   = 338;
 object[id].ctrl_surface[12].poly_id[3]   = 339;

 object[id].ctrl_surface[13].hinge.x      =  -5.06;
 object[id].ctrl_surface[13].hinge.y      =   0;
 object[id].ctrl_surface[13].hinge.z      =   0.36;
 object[id].ctrl_surface[13].rudder_gain  =   0;
 object[id].ctrl_surface[13].aileron_gain =   0;
 object[id].ctrl_surface[13].elevator_gain=   0;
 object[id].ctrl_surface[13].flap_gain    =   0;
 object[id].ctrl_surface[13].brake_gain   =  60;
 object[id].ctrl_surface[13].gear_gain    =   0;
 object[id].ctrl_surface[13].gear_id      =   0;
 object[id].ctrl_surface[13].nctrlpoly    =   6;
 object[id].ctrl_surface[13].poly_id[0]   = 340;
 object[id].ctrl_surface[13].poly_id[1]   = 341;
 object[id].ctrl_surface[13].poly_id[2]   = 342;
 object[id].ctrl_surface[13].poly_id[3]   = 343;
 object[id].ctrl_surface[13].poly_id[4]   = 344;
 object[id].ctrl_surface[13].poly_id[5]   = 345;

 object[id].ctrl_surface[14].hinge.x      =  -0.52;
 object[id].ctrl_surface[14].hinge.y      =   2.17;
 object[id].ctrl_surface[14].hinge.z      =   0.29;
 object[id].ctrl_surface[14].rudder_gain  =   0;
 object[id].ctrl_surface[14].aileron_gain =   0;
 object[id].ctrl_surface[14].elevator_gain=   0;
 object[id].ctrl_surface[14].flap_gain    =   0;
 object[id].ctrl_surface[14].brake_gain   =   0;
 object[id].ctrl_surface[14].gear_gain    = -90;
 object[id].ctrl_surface[14].gear_id      =   1;
 object[id].ctrl_surface[14].nctrlpoly    =   6;
 object[id].ctrl_surface[14].poly_id[0]   = 346;
 object[id].ctrl_surface[14].poly_id[1]   = 347;
 object[id].ctrl_surface[14].poly_id[2]   = 348;
 object[id].ctrl_surface[14].poly_id[3]   = 349;
 object[id].ctrl_surface[14].poly_id[4]   = 350;
 object[id].ctrl_surface[14].poly_id[5]   = 351;

 object[id].ctrl_surface[15].hinge.x      =  -0.52;
 object[id].ctrl_surface[15].hinge.y      =  -2.17;
 object[id].ctrl_surface[15].hinge.z      =   0.29;
 object[id].ctrl_surface[15].rudder_gain  =   0;
 object[id].ctrl_surface[15].aileron_gain =   0;
 object[id].ctrl_surface[15].elevator_gain=   0;
 object[id].ctrl_surface[15].flap_gain    =   0;
 object[id].ctrl_surface[15].brake_gain   =   0;
 object[id].ctrl_surface[15].gear_gain    = -90;
 object[id].ctrl_surface[15].gear_id      =   2;
 object[id].ctrl_surface[15].nctrlpoly    =   6;
 object[id].ctrl_surface[15].poly_id[0]   = 352;
 object[id].ctrl_surface[15].poly_id[1]   = 353;
 object[id].ctrl_surface[15].poly_id[2]   = 354;
 object[id].ctrl_surface[15].poly_id[3]   = 355;
 object[id].ctrl_surface[15].poly_id[4]   = 356;
 object[id].ctrl_surface[15].poly_id[5]   = 357;

 object[id].ctrl_surface[16].hinge.x      =   6.35;
 object[id].ctrl_surface[16].hinge.y      =   0;
 object[id].ctrl_surface[16].hinge.z      =  -0.15;
 object[id].ctrl_surface[16].rudder_gain  =   0;
 object[id].ctrl_surface[16].aileron_gain =   0;
 object[id].ctrl_surface[16].elevator_gain=   0;
 object[id].ctrl_surface[16].flap_gain    =   0;
 object[id].ctrl_surface[16].brake_gain   =   0;
 object[id].ctrl_surface[16].gear_gain    = -90;
 object[id].ctrl_surface[16].gear_id      =   0;
 object[id].ctrl_surface[16].nctrlpoly    =   6;
 object[id].ctrl_surface[16].poly_id[0]   = 358;
 object[id].ctrl_surface[16].poly_id[1]   = 359;
 object[id].ctrl_surface[16].poly_id[2]   = 360;
 object[id].ctrl_surface[16].poly_id[3]   = 361;
 object[id].ctrl_surface[16].poly_id[4]   = 362;
 object[id].ctrl_surface[16].poly_id[5]   = 363;

 nfacets=object[id].nfacets;
 for (j=0; j<object[id].nctrl_srf; j++) nfacets+=object[id].ctrl_surface[j].nctrlpoly;

 if ((object[id].vertex = malloc(object[id].nvertices*sizeof(cartvektor))) == NULL)
 {
   printf("Not enough memory\n");
   exit(1);
 }

 if ((object[id].facet = malloc(nfacets*sizeof(polygon_struct))) == NULL)
 {
   printf("Not enough memory\n");
   exit(1);
 }
 facetid=object[id].facet;

 /* belly */
 (object[id].vertex+0)->x=-2.16;
 (object[id].vertex+0)->y= 0.72;
 (object[id].vertex+0)->z=-0.20;

 (object[id].vertex+1)->x=-2.16;
 (object[id].vertex+1)->y=-0.72;
 (object[id].vertex+1)->z=-0.20;

 (object[id].vertex+2)->x=-5.50;
 (object[id].vertex+2)->y=-0.76;
 (object[id].vertex+2)->z=-0.05;

 (object[id].vertex+3)->x=-5.50;
 (object[id].vertex+3)->y= 0.76;
 (object[id].vertex+3)->z=-0.05;

 /* engines */
 (object[id].vertex+4)->x=-2.16;
 (object[id].vertex+4)->y= 1.64;
 (object[id].vertex+4)->z=-0.90;

 (object[id].vertex+5)->x=-2.16;
 (object[id].vertex+5)->y= 1.17;
 (object[id].vertex+5)->z=-0.90;

 (object[id].vertex+6)->x=-5.50;
 (object[id].vertex+6)->y= 1.21;
 (object[id].vertex+6)->z=-0.70;

 (object[id].vertex+7)->x=-5.50;
 (object[id].vertex+7)->y= 1.61;
 (object[id].vertex+7)->z=-0.70;

 (object[id].vertex+8)->x=-2.16;
 (object[id].vertex+8)->y=-1.17;
 (object[id].vertex+8)->z=-0.90;

 (object[id].vertex+9)->x=-2.16;
 (object[id].vertex+9)->y=-1.64;
 (object[id].vertex+9)->z=-0.90;

 (object[id].vertex+10)->x=-5.50;
 (object[id].vertex+10)->y=-1.61;
 (object[id].vertex+10)->z=-0.70;

 (object[id].vertex+11)->x=-5.50;
 (object[id].vertex+11)->y=-1.21;
 (object[id].vertex+11)->z=-0.70;

 (object[id].vertex+12)->x=-2.16;
 (object[id].vertex+12)->y= 0.80;
 (object[id].vertex+12)->z=-0.67;

 (object[id].vertex+13)->x=-5.50;
 (object[id].vertex+13)->y= 0.84;
 (object[id].vertex+13)->z=-0.46;

 (object[id].vertex+14)->x=-2.16;
 (object[id].vertex+14)->y=-0.80;
 (object[id].vertex+14)->z=-0.67;

 (object[id].vertex+15)->x=-5.50;
 (object[id].vertex+15)->y=-0.84;
 (object[id].vertex+15)->z=-0.46;

 (object[id].vertex+16)->x=-2.16;
 (object[id].vertex+16)->y= 1.97;
 (object[id].vertex+16)->z=-0.17;

 (object[id].vertex+17)->x=-2.16;
 (object[id].vertex+17)->y= 1.91;
 (object[id].vertex+17)->z=-0.67;

 (object[id].vertex+18)->x=-5.50;
 (object[id].vertex+18)->y= 1.95;
 (object[id].vertex+18)->z=-0.48;

 (object[id].vertex+19)->x=-5.50;
 (object[id].vertex+19)->y= 2.02;
 (object[id].vertex+19)->z=-0.23;

 (object[id].vertex+20)->x=-2.16;
 (object[id].vertex+20)->y=-1.91;
 (object[id].vertex+20)->z=-0.67;

 (object[id].vertex+21)->x=-2.16;
 (object[id].vertex+21)->y=-1.97;
 (object[id].vertex+21)->z=-0.17;

 (object[id].vertex+22)->x=-5.50;
 (object[id].vertex+22)->y=-2.02;
 (object[id].vertex+22)->z=-0.23;

 (object[id].vertex+23)->x=-5.50;
 (object[id].vertex+23)->y=-1.95;
 (object[id].vertex+23)->z=-0.48;

 /* Belly fin */
 (object[id].vertex+24)->x=-2.16;
 (object[id].vertex+24)->y= 1.42;
 (object[id].vertex+24)->z=-0.90;

 (object[id].vertex+25)->x=-2.60;
 (object[id].vertex+25)->y= 1.42;
 (object[id].vertex+25)->z=-1.35;

 (object[id].vertex+26)->x=-5.20;
 (object[id].vertex+26)->y= 1.42;
 (object[id].vertex+26)->z=-0.85;

 (object[id].vertex+27)->x=-5.20;
 (object[id].vertex+27)->y= 1.42;
 (object[id].vertex+27)->z=-0.74;

 (object[id].vertex+28)->x=-2.16;
 (object[id].vertex+28)->y=-1.42;
 (object[id].vertex+28)->z=-0.90;

 (object[id].vertex+29)->x=-2.60;
 (object[id].vertex+29)->y=-1.42;
 (object[id].vertex+29)->z=-1.35;

 (object[id].vertex+30)->x=-5.20;
 (object[id].vertex+30)->y=-1.42;
 (object[id].vertex+30)->z=-0.85;

 (object[id].vertex+31)->x=-5.20;
 (object[id].vertex+31)->y=-1.42;
 (object[id].vertex+31)->z=-0.74;

 /* Forward of engines */
 (object[id].vertex+32)->x=-0.72;
 (object[id].vertex+32)->y= 1.91;
 (object[id].vertex+32)->z=-0.12;

 (object[id].vertex+33)->x=-0.72;
 (object[id].vertex+33)->y= 1.86;
 (object[id].vertex+33)->z=-0.62;

 (object[id].vertex+34)->x=-0.72;
 (object[id].vertex+34)->y= 1.64;
 (object[id].vertex+34)->z=-0.87;

 (object[id].vertex+35)->x=-0.72;
 (object[id].vertex+35)->y= 1.17;
 (object[id].vertex+35)->z=-0.87;

 (object[id].vertex+36)->x=-0.72;
 (object[id].vertex+36)->y= 0.85;
 (object[id].vertex+36)->z=-0.67;

 (object[id].vertex+37)->x=-0.72;
 (object[id].vertex+37)->y= 0.78;
 (object[id].vertex+37)->z=-0.26;

 (object[id].vertex+38)->x=-0.72;
 (object[id].vertex+38)->y=-0.78;
 (object[id].vertex+38)->z=-0.26;

 (object[id].vertex+39)->x=-0.72;
 (object[id].vertex+39)->y=-0.85;
 (object[id].vertex+39)->z=-0.67;

 (object[id].vertex+40)->x=-0.72;
 (object[id].vertex+40)->y=-1.17;
 (object[id].vertex+40)->z=-0.87;

 (object[id].vertex+41)->x=-0.72;
 (object[id].vertex+41)->y=-1.64;
 (object[id].vertex+41)->z=-0.87;

 (object[id].vertex+42)->x=-0.72;
 (object[id].vertex+42)->y=-1.86;
 (object[id].vertex+42)->z=-0.62;

 (object[id].vertex+43)->x=-0.72;
 (object[id].vertex+43)->y=-1.91;
 (object[id].vertex+43)->z=-0.12;

 /* Intakes */
 (object[id].vertex+44)->x= 2.74;
 (object[id].vertex+44)->y= 1.80;
 (object[id].vertex+44)->z=-0.40;

 (object[id].vertex+45)->x= 2.74;
 (object[id].vertex+45)->y= 1.15;
 (object[id].vertex+45)->z=-0.49;

 (object[id].vertex+46)->x= 2.74;
 (object[id].vertex+46)->y= 1.13;
 (object[id].vertex+46)->z=-0.34;

 (object[id].vertex+47)->x= 2.74;
 (object[id].vertex+47)->y= 1.03;
 (object[id].vertex+47)->z= 0.38;

 (object[id].vertex+48)->x= 2.74;
 (object[id].vertex+48)->y= 1.68;
 (object[id].vertex+48)->z= 0.47;

 (object[id].vertex+49)->x= 2.74;
 (object[id].vertex+49)->y= 1.78;
 (object[id].vertex+49)->z=-0.25;

 (object[id].vertex+50)->x= 2.74;
 (object[id].vertex+50)->y=-1.15;
 (object[id].vertex+50)->z=-0.49;

 (object[id].vertex+51)->x= 2.74;
 (object[id].vertex+51)->y=-1.80;
 (object[id].vertex+51)->z=-0.40;

 (object[id].vertex+52)->x= 2.74;
 (object[id].vertex+52)->y=-1.78;
 (object[id].vertex+52)->z=-0.25;

 (object[id].vertex+53)->x= 2.74;
 (object[id].vertex+53)->y=-1.68;
 (object[id].vertex+53)->z= 0.47;

 (object[id].vertex+54)->x= 2.74;
 (object[id].vertex+54)->y=-1.03;
 (object[id].vertex+54)->z= 0.38;

 (object[id].vertex+55)->x= 2.74;
 (object[id].vertex+55)->y=-1.13;
 (object[id].vertex+55)->z=-0.34;

 (object[id].vertex+56)->x= 5.41;
 (object[id].vertex+56)->y= 1.66;
 (object[id].vertex+56)->z= 0.55;

 (object[id].vertex+57)->x= 5.41;
 (object[id].vertex+57)->y= 1.01;
 (object[id].vertex+57)->z= 0.46;

 (object[id].vertex+58)->x= 5.03;
 (object[id].vertex+58)->y= 1.66;
 (object[id].vertex+58)->z= 0.55;

 (object[id].vertex+59)->x= 5.03;
 (object[id].vertex+59)->y= 1.01;
 (object[id].vertex+59)->z= 0.46;

 (object[id].vertex+60)->x= 5.41;
 (object[id].vertex+60)->y=-1.01;
 (object[id].vertex+60)->z= 0.46;

 (object[id].vertex+61)->x= 5.41;
 (object[id].vertex+61)->y=-1.66;
 (object[id].vertex+61)->z= 0.55;

 (object[id].vertex+62)->x= 5.03;
 (object[id].vertex+62)->y=-1.01;
 (object[id].vertex+62)->z= 0.46;

 (object[id].vertex+63)->x= 5.03;
 (object[id].vertex+63)->y=-1.66;
 (object[id].vertex+63)->z= 0.55;

 (object[id].vertex+64)->x= 1.86;
 (object[id].vertex+64)->y= 1.02;  /* 0.90 */
 (object[id].vertex+64)->z=-0.30;

 (object[id].vertex+65)->x= 1.86;
 (object[id].vertex+65)->y=-1.02;
 (object[id].vertex+65)->z=-0.30;

 /* Side boxes */
 (object[id].vertex+66)->x=-1.07;
 (object[id].vertex+66)->y= 1.92;
 (object[id].vertex+66)->z=-0.14;

 (object[id].vertex+67)->x=-1.07;
 (object[id].vertex+67)->y= 2.26;
 (object[id].vertex+67)->z=-0.04;

 (object[id].vertex+68)->x=-1.07;
 (object[id].vertex+68)->y= 2.26;
 (object[id].vertex+68)->z= 0.45;

 (object[id].vertex+69)->x=-1.07;
 (object[id].vertex+69)->y=-1.92;
 (object[id].vertex+69)->z=-0.14;

 (object[id].vertex+70)->x=-1.07;
 (object[id].vertex+70)->y=-2.26;
 (object[id].vertex+70)->z=-0.04;

 (object[id].vertex+71)->x=-1.07;
 (object[id].vertex+71)->y=-2.26;
 (object[id].vertex+71)->z= 0.45;

 (object[id].vertex+72)->x=-5.16;
 (object[id].vertex+72)->y= 2.04;
 (object[id].vertex+72)->z=-0.23;

 (object[id].vertex+73)->x=-5.16;
 (object[id].vertex+73)->y= 2.31;
 (object[id].vertex+73)->z=-0.13;

 (object[id].vertex+74)->x=-5.16;
 (object[id].vertex+74)->y= 2.31;
 (object[id].vertex+74)->z= 0.43;

 (object[id].vertex+75)->x=-5.16;
 (object[id].vertex+75)->y=-2.04;
 (object[id].vertex+75)->z=-0.23;

 (object[id].vertex+76)->x=-5.16;
 (object[id].vertex+76)->y=-2.31;
 (object[id].vertex+76)->z=-0.13;

 (object[id].vertex+77)->x=-5.16;
 (object[id].vertex+77)->y=-2.31;
 (object[id].vertex+77)->z= 0.43;

 (object[id].vertex+78)->x=-5.99;
 (object[id].vertex+78)->y= 2.00;
 (object[id].vertex+78)->z=-0.11;

 (object[id].vertex+79)->x=-5.99;
 (object[id].vertex+79)->y= 2.00;
 (object[id].vertex+79)->z= 0.22;

 (object[id].vertex+80)->x=-5.99;
 (object[id].vertex+80)->y=-2.00;
 (object[id].vertex+80)->z=-0.11;

 (object[id].vertex+81)->x=-5.99;
 (object[id].vertex+81)->y=-2.00;
 (object[id].vertex+81)->z= 0.22;

 /* Back */
 (object[id].vertex+82)->x=-5.50;
 (object[id].vertex+82)->y= 0.75;
 (object[id].vertex+82)->z= 0.31;

 (object[id].vertex+83)->x=-5.50;
 (object[id].vertex+83)->y=-0.75;
 (object[id].vertex+83)->z= 0.31;

 (object[id].vertex+84)->x=-1.88;
 (object[id].vertex+84)->y=-0.75;
 (object[id].vertex+84)->z= 0.53;

 (object[id].vertex+85)->x=-1.88;
 (object[id].vertex+85)->y= 0.75;
 (object[id].vertex+85)->z= 0.53;

 /* Fin root */
 (object[id].vertex+86)->x=-5.50;
 (object[id].vertex+86)->y= 1.45;
 (object[id].vertex+86)->z= 0.58;

 (object[id].vertex+87)->x=-5.50;
 (object[id].vertex+87)->y=-1.45;
 (object[id].vertex+87)->z= 0.58;

 (object[id].vertex+88)->x=-3.32;
 (object[id].vertex+88)->y=-1.45;
 (object[id].vertex+88)->z= 0.61;

 (object[id].vertex+89)->x=-3.32;
 (object[id].vertex+89)->y= 1.45;
 (object[id].vertex+89)->z= 0.61;

 /* Fin tip */
 (object[id].vertex+90)->x=-6.84;
 (object[id].vertex+90)->y= 1.60;
 (object[id].vertex+90)->z= 2.85;

 (object[id].vertex+91)->x=-6.84;
 (object[id].vertex+91)->y=-1.60;
 (object[id].vertex+91)->z= 2.85;

 (object[id].vertex+92)->x=-5.92;
 (object[id].vertex+92)->y=-1.60;
 (object[id].vertex+92)->z= 2.85;

 (object[id].vertex+93)->x=-5.92;
 (object[id].vertex+93)->y= 1.60;
 (object[id].vertex+93)->z= 2.85;

 (object[id].vertex+94)->x=-7.20;
 (object[id].vertex+94)->y= 1.60;
 (object[id].vertex+94)->z= 2.85;

 (object[id].vertex+95)->x=-7.29;
 (object[id].vertex+95)->y= 1.62;
 (object[id].vertex+95)->z= 3.14;

 (object[id].vertex+96)->x=-6.43;
 (object[id].vertex+96)->y= 1.62;
 (object[id].vertex+96)->z= 3.14;

 (object[id].vertex+97)->x=-6.12;
 (object[id].vertex+97)->y= 1.61;
 (object[id].vertex+97)->z= 3.01;

 (object[id].vertex+98)->x=-7.20;
 (object[id].vertex+98)->y=-1.60;
 (object[id].vertex+98)->z= 2.85;

 (object[id].vertex+99)->x=-7.29;
 (object[id].vertex+99)->y=-1.62;
 (object[id].vertex+99)->z= 3.14;

 (object[id].vertex+100)->x=-6.43;
 (object[id].vertex+100)->y=-1.62;
 (object[id].vertex+100)->z= 3.14;

 (object[id].vertex+101)->x=-6.12;
 (object[id].vertex+101)->y=-1.61;
 (object[id].vertex+101)->z= 3.01;

 /* Rear back */
 (object[id].vertex+102)->x=-5.50;
 (object[id].vertex+102)->y= 1.20;
 (object[id].vertex+102)->z= 0.53;

 (object[id].vertex+103)->x=-5.50;
 (object[id].vertex+103)->y=-1.20;
 (object[id].vertex+103)->z= 0.53;

 (object[id].vertex+104)->x=-5.50;
 (object[id].vertex+104)->y= 1.88;
 (object[id].vertex+104)->z= 0.53;

 (object[id].vertex+105)->x=-5.50;
 (object[id].vertex+105)->y=-1.88;
 (object[id].vertex+105)->z= 0.53;

 (object[id].vertex+106)->x=-3.32;
 (object[id].vertex+106)->y= 1.88;
 (object[id].vertex+106)->z= 0.53;

 (object[id].vertex+107)->x=-3.32;
 (object[id].vertex+107)->y=-1.88;
 (object[id].vertex+107)->z= 0.53;

 (object[id].vertex+108)->x=-3.32;
 (object[id].vertex+108)->y= 2.29;
 (object[id].vertex+108)->z= 0.44;

 (object[id].vertex+109)->x=-3.32;
 (object[id].vertex+109)->y=-2.29;
 (object[id].vertex+109)->z= 0.44;

 /* Beaver tail */
 (object[id].vertex+110)->x=-5.93;
 (object[id].vertex+110)->y= 0.87;
 (object[id].vertex+110)->z= 0.235;

 (object[id].vertex+111)->x=-5.93;
 (object[id].vertex+111)->y=-0.87;
 (object[id].vertex+111)->z= 0.235;

 (object[id].vertex+112)->x=-5.93;
 (object[id].vertex+112)->y= 0.87;
 (object[id].vertex+112)->z= 0.055;

 (object[id].vertex+113)->x=-5.93;
 (object[id].vertex+113)->y=-0.87;
 (object[id].vertex+113)->z= 0.055;

 (object[id].vertex+114)->x=-6.36;
 (object[id].vertex+114)->y= 0.75;
 (object[id].vertex+114)->z= 0.16;

 (object[id].vertex+115)->x=-6.36;
 (object[id].vertex+115)->y=-0.75;
 (object[id].vertex+115)->z= 0.16;

 (object[id].vertex+116)->x=-6.36;
 (object[id].vertex+116)->y= 0.33;
 (object[id].vertex+116)->z= 0.16;

 (object[id].vertex+117)->x=-6.36;
 (object[id].vertex+117)->y=-0.33;
 (object[id].vertex+117)->z= 0.16;

 (object[id].vertex+118)->x=-7.00;
 (object[id].vertex+118)->y= 0.33;
 (object[id].vertex+118)->z= 0.16;

 (object[id].vertex+119)->x=-7.00;
 (object[id].vertex+119)->y=-0.33;
 (object[id].vertex+119)->z= 0.16;

 /* Exhaust nozzles */
 for (i=0; i<8; i++){
  float xc=-5.50, yc=1.42, zc=-0.07, radius=0.63;

  (object[id].vertex+120+i)->x=xc;
  (object[id].vertex+120+i)->y=yc-radius*sin(i*PI/4+PI/8);
  (object[id].vertex+120+i)->z=zc+radius*cos(i*PI/4+PI/8);
 }

 for (i=0; i<8; i++){
  float xc=-6.46, yc=1.42, zc=-0.07, radius=0.51;

  (object[id].vertex+128+i)->x=xc;
  (object[id].vertex+128+i)->y=yc-radius*sin(i*PI/4+PI/8);
  (object[id].vertex+128+i)->z=zc+radius*cos(i*PI/4+PI/8);
 }

 for (i=0; i<8; i++){
  float xc=-5.50, yc=-1.42, zc=-0.07, radius=0.63;

  (object[id].vertex+136+i)->x=xc;
  (object[id].vertex+136+i)->y=yc-radius*sin(i*PI/4+PI/8);
  (object[id].vertex+136+i)->z=zc+radius*cos(i*PI/4+PI/8);
 }

 for (i=0; i<8; i++){
  float xc=-6.46, yc=-1.42, zc=-0.07, radius=0.51;

  (object[id].vertex+144+i)->x=xc;
  (object[id].vertex+144+i)->y=yc-radius*sin(i*PI/4+PI/8);
  (object[id].vertex+144+i)->z=zc+radius*cos(i*PI/4+PI/8);
 }

 /* Side box */
 (object[id].vertex+152)->x=-0.72;
 (object[id].vertex+152)->y= 1.92;
 (object[id].vertex+152)->z=-0.14;

 (object[id].vertex+153)->x=-0.72;
 (object[id].vertex+153)->y= 2.26;
 (object[id].vertex+153)->z=-0.04;

 (object[id].vertex+154)->x=-0.72;
 (object[id].vertex+154)->y=-1.92;
 (object[id].vertex+154)->z=-0.14;

 (object[id].vertex+155)->x=-0.72;
 (object[id].vertex+155)->y=-2.26;
 (object[id].vertex+155)->z=-0.04;

 /* Gloves */
 (object[id].vertex+156)->x= 5.19;
 (object[id].vertex+156)->y= 1.66;
 (object[id].vertex+156)->z= 0.55;

 (object[id].vertex+157)->x= 5.19;
 (object[id].vertex+157)->y=-1.66;
 (object[id].vertex+157)->z= 0.55;

 (object[id].vertex+158)->x= 1.10;
 (object[id].vertex+158)->y= 3.31;
 (object[id].vertex+158)->z= 0.58;

 (object[id].vertex+159)->x= 1.10;
 (object[id].vertex+159)->y=-3.31;
 (object[id].vertex+159)->z= 0.58;

 (object[id].vertex+160)->x= 0.61;
 (object[id].vertex+160)->y= 3.26;
 (object[id].vertex+160)->z= 0.44;

 (object[id].vertex+161)->x= 0.61;
 (object[id].vertex+161)->y=-3.26;
 (object[id].vertex+161)->z= 0.44;

 (object[id].vertex+162)->x= 0.61;
 (object[id].vertex+162)->y= 3.26;
 (object[id].vertex+162)->z= 0.72;

 (object[id].vertex+163)->x= 0.61;
 (object[id].vertex+163)->y=-3.26;
 (object[id].vertex+163)->z= 0.72;

 /* Nose */
 (object[id].vertex+164)->x=11.37;
 (object[id].vertex+164)->y= 0.00;
 (object[id].vertex+164)->z= 0.00;

 for (i=0; i<8; i++){
  float xc=9.85, yc=0.00, zc=0.11, radius=0.47;

  (object[id].vertex+165+i)->x=xc;
  (object[id].vertex+165+i)->y=yc-radius*sin(i*PI/4+PI/8);
  (object[id].vertex+165+i)->z=zc+radius*cos(i*PI/4+PI/8);
 }

 /* Cockpit section */
 (object[id].vertex+173)->x= 7.35;
 (object[id].vertex+173)->y= 0.55;
 (object[id].vertex+173)->z=-0.41;

 (object[id].vertex+174)->x= 7.35;
 (object[id].vertex+174)->y=-0.55;
 (object[id].vertex+174)->z=-0.41;

 (object[id].vertex+175)->x= 5.06;
 (object[id].vertex+175)->y= 0.63;
 (object[id].vertex+175)->z=-0.37;

 (object[id].vertex+176)->x= 5.06;
 (object[id].vertex+176)->y=-0.63;
 (object[id].vertex+176)->z=-0.37;

 (object[id].vertex+177)->x= 7.35;
 (object[id].vertex+177)->y= 0.75;
 (object[id].vertex+177)->z=-0.18;

 (object[id].vertex+178)->x= 7.35;
 (object[id].vertex+178)->y=-0.75;
 (object[id].vertex+178)->z=-0.18;

 (object[id].vertex+179)->x= 5.06;
 (object[id].vertex+179)->y= 0.79;
 (object[id].vertex+179)->z=-0.23;

 (object[id].vertex+180)->x= 5.06;
 (object[id].vertex+180)->y=-0.79;
 (object[id].vertex+180)->z=-0.23;

 (object[id].vertex+181)->x= 7.35;
 (object[id].vertex+181)->y= 0.75;
 (object[id].vertex+181)->z= 0.22;

 (object[id].vertex+182)->x= 7.35;
 (object[id].vertex+182)->y=-0.75;
 (object[id].vertex+182)->z= 0.22;

 (object[id].vertex+183)->x= 5.06;
 (object[id].vertex+183)->y= 0.79;
 (object[id].vertex+183)->z= 0.22;

 (object[id].vertex+184)->x= 5.06;
 (object[id].vertex+184)->y=-0.79;
 (object[id].vertex+184)->z= 0.22;

 (object[id].vertex+185)->x= 7.35;
 (object[id].vertex+185)->y= 0.57;
 (object[id].vertex+185)->z= 0.90;

 (object[id].vertex+186)->x= 7.35;
 (object[id].vertex+186)->y=-0.57;
 (object[id].vertex+186)->z= 0.90;

 (object[id].vertex+187)->x= 5.06;
 (object[id].vertex+187)->y= 0.54;
 (object[id].vertex+187)->z= 1.10;

 (object[id].vertex+188)->x= 5.06;
 (object[id].vertex+188)->y=-0.54;
 (object[id].vertex+188)->z= 1.10;

 (object[id].vertex+189)->x= 7.35;
 (object[id].vertex+189)->y= 0.43;
 (object[id].vertex+189)->z= 1.08;

 (object[id].vertex+190)->x= 7.35;
 (object[id].vertex+190)->y=-0.43;
 (object[id].vertex+190)->z= 1.08;

 (object[id].vertex+191)->x= 5.06;
 (object[id].vertex+191)->y= 0.40;
 (object[id].vertex+191)->z= 1.25;

 (object[id].vertex+192)->x= 5.06;
 (object[id].vertex+192)->y=-0.40;
 (object[id].vertex+192)->z= 1.25;

 (object[id].vertex+193)->x= 8.48;
 (object[id].vertex+193)->y= 0.36;
 (object[id].vertex+193)->z=-0.42;

 (object[id].vertex+194)->x= 8.48;
 (object[id].vertex+194)->y=-0.36;
 (object[id].vertex+194)->z=-0.42;

 (object[id].vertex+195)->x= 8.48;
 (object[id].vertex+195)->y= 0.65;
 (object[id].vertex+195)->z=-0.14;

 (object[id].vertex+196)->x= 8.48;
 (object[id].vertex+196)->y=-0.65;
 (object[id].vertex+196)->z=-0.14;

 (object[id].vertex+197)->x= 8.48;
 (object[id].vertex+197)->y= 0.65;
 (object[id].vertex+197)->z= 0.26;

 (object[id].vertex+198)->x= 8.48;
 (object[id].vertex+198)->y=-0.65;
 (object[id].vertex+198)->z= 0.26;

 (object[id].vertex+199)->x= 8.48;
 (object[id].vertex+199)->y= 0.42;
 (object[id].vertex+199)->z= 0.80;

 (object[id].vertex+200)->x= 8.48;
 (object[id].vertex+200)->y= 0.16;
 (object[id].vertex+200)->z= 0.96;

 (object[id].vertex+201)->x= 8.48;
 (object[id].vertex+201)->y=-0.16;
 (object[id].vertex+201)->z= 0.96;

 (object[id].vertex+202)->x= 8.48;
 (object[id].vertex+202)->y=-0.42;
 (object[id].vertex+202)->z= 0.80;

 /* belly */
 (object[id].vertex+203)->x= 1.86;
 (object[id].vertex+203)->y= 0.69;
 (object[id].vertex+203)->z=-0.30;

 (object[id].vertex+204)->x= 1.86;
 (object[id].vertex+204)->y=-0.69;
 (object[id].vertex+204)->z=-0.30;

 /* canopy */
 (object[id].vertex+205)->x= 7.52;
 (object[id].vertex+205)->y= 0.30;
 (object[id].vertex+205)->z= 1.35;

 (object[id].vertex+206)->x= 7.52;
 (object[id].vertex+206)->y=-0.30;
 (object[id].vertex+206)->z= 1.35;

 (object[id].vertex+207)->x= 7.61;
 (object[id].vertex+207)->y= 0.09;
 (object[id].vertex+207)->z= 1.49;

 (object[id].vertex+208)->x= 7.61;
 (object[id].vertex+208)->y=-0.09;
 (object[id].vertex+208)->z= 1.49;

 (object[id].vertex+209)->x= 6.68;
 (object[id].vertex+209)->y= 0.11;
 (object[id].vertex+209)->z= 1.75;

 (object[id].vertex+210)->x= 6.68;
 (object[id].vertex+210)->y=-0.11;
 (object[id].vertex+210)->z= 1.75;

 (object[id].vertex+211)->x= 5.49;
 (object[id].vertex+211)->y= 0.10;
 (object[id].vertex+211)->z= 1.78;

 (object[id].vertex+212)->x= 5.49;
 (object[id].vertex+212)->y=-0.10;
 (object[id].vertex+212)->z= 1.78;

 (object[id].vertex+213)->x= 4.06;
 (object[id].vertex+213)->y= 0.08;
 (object[id].vertex+213)->z= 1.55;

 (object[id].vertex+214)->x= 4.06;
 (object[id].vertex+214)->y=-0.08;
 (object[id].vertex+214)->z= 1.55;

 (object[id].vertex+215)->x= 6.68;
 (object[id].vertex+215)->y= 0.32;
 (object[id].vertex+215)->z= 1.57;

 (object[id].vertex+216)->x= 6.68;
 (object[id].vertex+216)->y=-0.32;
 (object[id].vertex+216)->z= 1.57;

 (object[id].vertex+217)->x= 5.49;
 (object[id].vertex+217)->y= 0.30;
 (object[id].vertex+217)->z= 1.62;

 (object[id].vertex+218)->x= 5.49;
 (object[id].vertex+218)->y=-0.30;
 (object[id].vertex+218)->z= 1.62;

 (object[id].vertex+219)->x= 4.09;
 (object[id].vertex+219)->y= 0.27;
 (object[id].vertex+219)->z= 1.46;

 (object[id].vertex+220)->x= 4.09;
 (object[id].vertex+220)->y=-0.27;
 (object[id].vertex+220)->z= 1.46;

 (object[id].vertex+221)->x= 6.68;
 (object[id].vertex+221)->y= 0.421;
 (object[id].vertex+221)->z= 1.13;

 (object[id].vertex+222)->x= 6.68;
 (object[id].vertex+222)->y=-0.421;
 (object[id].vertex+222)->z= 1.13;

 (object[id].vertex+223)->x= 5.49;
 (object[id].vertex+223)->y= 0.406;
 (object[id].vertex+223)->z= 1.22;

 (object[id].vertex+224)->x= 5.49;
 (object[id].vertex+224)->y=-0.406;
 (object[id].vertex+224)->z= 1.22;

 (object[id].vertex+225)->x= 4.14;
 (object[id].vertex+225)->y= 0.37;
 (object[id].vertex+225)->z= 1.28;

 (object[id].vertex+226)->x= 4.14;
 (object[id].vertex+226)->y=-0.37;
 (object[id].vertex+226)->z= 1.28;

 /* Canopy frame */
 (object[id].vertex+227)->x= 4.14;
 (object[id].vertex+227)->y= 0.51;
 (object[id].vertex+227)->z= 1.13;

 (object[id].vertex+228)->x= 4.14;
 (object[id].vertex+228)->y=-0.51;
 (object[id].vertex+228)->z= 1.13;

 /* Spine */
 (object[id].vertex+229)->x= 1.48;
 (object[id].vertex+229)->y= 0.00;
 (object[id].vertex+229)->z= 1.01;

 (object[id].vertex+230)->x= 5.06;
 (object[id].vertex+230)->y= 0.725;
 (object[id].vertex+230)->z= 0.45;

 (object[id].vertex+231)->x= 5.06;
 (object[id].vertex+231)->y=-0.725;
 (object[id].vertex+231)->z= 0.45;

 (object[id].vertex+232)->x=-1.88;
 (object[id].vertex+232)->y= 0.19;
 (object[id].vertex+232)->z= 0.53;

 (object[id].vertex+233)->x=-1.88;
 (object[id].vertex+233)->y=-0.19;
 (object[id].vertex+233)->z= 0.53;

 /* Gloves */
 (object[id].vertex+234)->x= 2.91;
 (object[id].vertex+234)->y= 1.66;
 (object[id].vertex+234)->z= 0.80;

 (object[id].vertex+235)->x= 2.91;
 (object[id].vertex+235)->y=-1.66;
 (object[id].vertex+235)->z= 0.80;

 (object[id].vertex+236)->x= 0.23;
 (object[id].vertex+236)->y= 1.66;
 (object[id].vertex+236)->z= 0.67;

 (object[id].vertex+237)->x= 0.23;
 (object[id].vertex+237)->y=-1.66;
 (object[id].vertex+237)->z= 0.67;

 /* Back */
 (object[id].vertex+238)->x=-1.15;
 (object[id].vertex+238)->y= 2.30;
 (object[id].vertex+238)->z= 0.62;

 (object[id].vertex+239)->x=-1.15;
 (object[id].vertex+239)->y=-2.30;
 (object[id].vertex+239)->z= 0.62;

 (object[id].vertex+240)->x=-1.88;
 (object[id].vertex+240)->y= 1.02;
 (object[id].vertex+240)->z= 0.53;

 (object[id].vertex+241)->x=-1.88;
 (object[id].vertex+241)->y=-1.02;
 (object[id].vertex+241)->z= 0.53;

 /* Above air intakes */
 (object[id].vertex+242)->x= 2.91;
 (object[id].vertex+242)->y= 1.66;
 (object[id].vertex+242)->z= 0.74;

 (object[id].vertex+243)->x= 2.91;
 (object[id].vertex+243)->y= 0.94;
 (object[id].vertex+243)->z= 0.64;

 (object[id].vertex+244)->x= 2.91;
 (object[id].vertex+244)->y=-0.94;
 (object[id].vertex+244)->z= 0.64;

 (object[id].vertex+245)->x= 2.91;
 (object[id].vertex+245)->y=-1.66;
 (object[id].vertex+245)->z= 0.74;

 (object[id].vertex+246)->x= 2.91;
 (object[id].vertex+246)->y= 1.39;
 (object[id].vertex+246)->z= 0.70;

 (object[id].vertex+247)->x= 5.41;
 (object[id].vertex+247)->y= 1.46;
 (object[id].vertex+247)->z= 0.52;

 (object[id].vertex+248)->x= 1.23;
 (object[id].vertex+248)->y= 0.86;
 (object[id].vertex+248)->z= 0.553;

 (object[id].vertex+249)->x= 1.23;
 (object[id].vertex+249)->y= 0.43;
 (object[id].vertex+249)->z= 0.494;

 (object[id].vertex+250)->x= 1.23;
 (object[id].vertex+250)->y=-0.43;
 (object[id].vertex+250)->z= 0.494;

 (object[id].vertex+251)->x= 1.23;
 (object[id].vertex+251)->y=-0.86;
 (object[id].vertex+251)->z= 0.553;

 (object[id].vertex+252)->x= 5.06;
 (object[id].vertex+252)->y= 1.01;
 (object[id].vertex+252)->z= 0.49;

 (object[id].vertex+253)->x= 5.06;
 (object[id].vertex+253)->y=-1.01;
 (object[id].vertex+253)->z= 0.49;

 (object[id].vertex+254)->x= 1.47;
 (object[id].vertex+254)->y= 1.41;
 (object[id].vertex+254)->z= 0.706;

 (object[id].vertex+255)->x= 1.47;
 (object[id].vertex+255)->y= 0.86;
 (object[id].vertex+255)->z= 0.63;

 (object[id].vertex+256)->x= 1.47;
 (object[id].vertex+256)->y=-0.86;
 (object[id].vertex+256)->z= 0.63;

 (object[id].vertex+257)->x= 1.47;
 (object[id].vertex+257)->y=-1.41;
 (object[id].vertex+257)->z= 0.706;

 (object[id].vertex+258)->x= 1.89;
 (object[id].vertex+258)->y= 1.41;
 (object[id].vertex+258)->z= 0.636;

 (object[id].vertex+259)->x= 1.89;
 (object[id].vertex+259)->y= 0.86;
 (object[id].vertex+259)->z= 0.56;

 (object[id].vertex+260)->x= 1.89;
 (object[id].vertex+260)->y=-0.86;
 (object[id].vertex+260)->z= 0.56;

 (object[id].vertex+261)->x= 1.89;
 (object[id].vertex+261)->y=-1.41;
 (object[id].vertex+261)->z= 0.636;

 (object[id].vertex+262)->x= 1.23;
 (object[id].vertex+262)->y= 1.41;
 (object[id].vertex+262)->z= 0.629;

 (object[id].vertex+263)->x= 1.23;
 (object[id].vertex+263)->y=-1.41;
 (object[id].vertex+263)->z= 0.629;

 (object[id].vertex+264)->x= 1.89;
 (object[id].vertex+264)->y= 1.66;
 (object[id].vertex+264)->z= 0.67;

 (object[id].vertex+265)->x= 1.23;
 (object[id].vertex+265)->y= 1.66;
 (object[id].vertex+265)->z= 0.663;

 (object[id].vertex+266)->x= 1.89;
 (object[id].vertex+266)->y=-1.66;
 (object[id].vertex+266)->z= 0.67;

 (object[id].vertex+267)->x= 1.23;
 (object[id].vertex+267)->y=-1.66;
 (object[id].vertex+267)->z= 0.663;

 (object[id].vertex+268)->x= 2.97;
 (object[id].vertex+268)->y= 1.05;
 (object[id].vertex+268)->z= 0.13;

 (object[id].vertex+269)->x= 2.97;
 (object[id].vertex+269)->y= 0.702;
 (object[id].vertex+269)->z= 0.10;

 (object[id].vertex+270)->x= 2.97;
 (object[id].vertex+270)->y=-0.702;
 (object[id].vertex+270)->z= 0.10;

 (object[id].vertex+271)->x= 2.97;
 (object[id].vertex+271)->y=-1.05;
 (object[id].vertex+271)->z= 0.13;

 /* Inner back strake */
 (object[id].vertex+272)->x= 0.32;
 (object[id].vertex+272)->y= 1.02;
 (object[id].vertex+272)->z= 0.58;

 (object[id].vertex+273)->x= 0.17;
 (object[id].vertex+273)->y= 1.02;
 (object[id].vertex+273)->z= 0.66;

 (object[id].vertex+274)->x=-1.88;
 (object[id].vertex+274)->y= 1.02;
 (object[id].vertex+274)->z= 0.61;

 (object[id].vertex+275)->x= 0.32;
 (object[id].vertex+275)->y=-1.02;
 (object[id].vertex+275)->z= 0.58;

 (object[id].vertex+276)->x= 0.17;
 (object[id].vertex+276)->y=-1.02;
 (object[id].vertex+276)->z= 0.66;

 (object[id].vertex+277)->x=-1.88;
 (object[id].vertex+277)->y=-1.02;
 (object[id].vertex+277)->z= 0.61;

 /* Outer back strake */
 (object[id].vertex+278)->x= 1.27;
 (object[id].vertex+278)->y= 2.11;
 (object[id].vertex+278)->z= 0.66;

 (object[id].vertex+279)->x= 0.19;
 (object[id].vertex+279)->y= 2.11;
 (object[id].vertex+279)->z= 0.78;

 (object[id].vertex+280)->x=-1.15;
 (object[id].vertex+280)->y= 2.11;
 (object[id].vertex+280)->z= 0.69;

 (object[id].vertex+281)->x=-1.15;
 (object[id].vertex+281)->y= 2.11;
 (object[id].vertex+281)->z= 0.61;

 (object[id].vertex+282)->x= 1.27;
 (object[id].vertex+282)->y=-2.11;
 (object[id].vertex+282)->z= 0.66;

 (object[id].vertex+283)->x= 0.19;
 (object[id].vertex+283)->y=-2.11;
 (object[id].vertex+283)->z= 0.78;

 (object[id].vertex+284)->x=-1.15;
 (object[id].vertex+284)->y=-2.11;
 (object[id].vertex+284)->z= 0.69;

 (object[id].vertex+285)->x=-1.15;
 (object[id].vertex+285)->y=-2.11;
 (object[id].vertex+285)->z= 0.61;

 /* Wings */
 (object[id].vertex+286)->x= 0.61;
 (object[id].vertex+286)->y= 3.26;
 (object[id].vertex+286)->z= 0.72;

 (object[id].vertex+287)->x= 0.61;
 (object[id].vertex+287)->y=-3.26;
 (object[id].vertex+287)->z= 0.72;

 (object[id].vertex+288)->x=-1.17;
 (object[id].vertex+288)->y= 8.95;
 (object[id].vertex+288)->z= 0.64;

 (object[id].vertex+289)->x=-1.17;
 (object[id].vertex+289)->y=-8.95;
 (object[id].vertex+289)->z= 0.64;

 (object[id].vertex+290)->x=-1.71;
 (object[id].vertex+290)->y= 8.91;
 (object[id].vertex+290)->z= 0.64;

 (object[id].vertex+291)->x=-1.71;
 (object[id].vertex+291)->y=-8.91;
 (object[id].vertex+291)->z= 0.64;

 (object[id].vertex+292)->x=-0.74;
 (object[id].vertex+292)->y= 3.70;
 (object[id].vertex+292)->z= 0.66;

 (object[id].vertex+293)->x=-0.74;
 (object[id].vertex+293)->y=-3.70;
 (object[id].vertex+293)->z= 0.66;

 (object[id].vertex+294)->x=-0.561;
 (object[id].vertex+294)->y= 2.65;
 (object[id].vertex+294)->z= 0.66;

 (object[id].vertex+295)->x=-0.561;
 (object[id].vertex+295)->y=-2.65;
 (object[id].vertex+295)->z= 0.66;

 (object[id].vertex+296)->x=-1.91;
 (object[id].vertex+296)->y= 8.895;
 (object[id].vertex+296)->z= 0.64;

 (object[id].vertex+297)->x=-1.91;
 (object[id].vertex+297)->y=-8.895;
 (object[id].vertex+297)->z= 0.64;

 (object[id].vertex+298)->x=-1.13;
 (object[id].vertex+298)->y= 3.67;
 (object[id].vertex+298)->z= 0.65;

 (object[id].vertex+299)->x=-1.13;
 (object[id].vertex+299)->y=-3.67;
 (object[id].vertex+299)->z= 0.65;

 (object[id].vertex+300)->x=-0.944;
 (object[id].vertex+300)->y= 2.43;
 (object[id].vertex+300)->z= 0.65;

 (object[id].vertex+301)->x=-0.944;
 (object[id].vertex+301)->y=-2.43;
 (object[id].vertex+301)->z= 0.65;

 (object[id].vertex+302)->x= 0.61;
 (object[id].vertex+302)->y= 3.26;
 (object[id].vertex+302)->z= 0.44;

 (object[id].vertex+303)->x= 0.61;
 (object[id].vertex+303)->y=-3.26;
 (object[id].vertex+303)->z= 0.44;

 (object[id].vertex+304)->x=-1.13;
 (object[id].vertex+304)->y= 3.67;
 (object[id].vertex+304)->z= 0.46;

 (object[id].vertex+305)->x=-1.13;
 (object[id].vertex+305)->y=-3.67;
 (object[id].vertex+305)->z= 0.46;

 (object[id].vertex+306)->x=-0.937;
 (object[id].vertex+306)->y= 2.38;
 (object[id].vertex+306)->z= 0.44;

 (object[id].vertex+307)->x=-0.937;
 (object[id].vertex+307)->y=-2.38;
 (object[id].vertex+307)->z= 0.44;

 /* Wing tips */
 (object[id].vertex+308)->x=-0.925;
 (object[id].vertex+308)->y= 8.968;
 (object[id].vertex+308)->z= 0.58;

 (object[id].vertex+309)->x=-0.925;
 (object[id].vertex+309)->y=-8.968;
 (object[id].vertex+309)->z= 0.58;

 (object[id].vertex+310)->x=-2.336;
 (object[id].vertex+310)->y= 8.863;
 (object[id].vertex+310)->z= 0.58;

 (object[id].vertex+311)->x=-2.336;
 (object[id].vertex+311)->y=-8.863;
 (object[id].vertex+311)->z= 0.58;

 (object[id].vertex+312)->x=-2.385;
 (object[id].vertex+312)->y= 9.64;
 (object[id].vertex+312)->z= 0.58;

 (object[id].vertex+313)->x=-2.385;
 (object[id].vertex+313)->y=-9.64;
 (object[id].vertex+313)->z= 0.58;

 (object[id].vertex+314)->x=-1.52;
 (object[id].vertex+314)->y= 9.44;
 (object[id].vertex+314)->z= 0.58;

 (object[id].vertex+315)->x=-1.52;
 (object[id].vertex+315)->y=-9.44;
 (object[id].vertex+315)->z= 0.58;

 (object[id].vertex+316)->x=-0.99;
 (object[id].vertex+316)->y= 9.11;
 (object[id].vertex+316)->z= 0.58;

 (object[id].vertex+317)->x=-0.99;
 (object[id].vertex+317)->y=-9.11;
 (object[id].vertex+317)->z= 0.58;

 /* slats */
 (object[id].vertex+318)->x= 1.14;
 (object[id].vertex+318)->y= 3.26;
 (object[id].vertex+318)->z= 0.52;

 (object[id].vertex+319)->x= 1.14;
 (object[id].vertex+319)->y=-3.26;
 (object[id].vertex+319)->z= 0.52;

 /* Wing tip, below */
 (object[id].vertex+320)->x=-1.17;
 (object[id].vertex+320)->y= 8.95;
 (object[id].vertex+320)->z= 0.52;

 (object[id].vertex+321)->x=-1.17;
 (object[id].vertex+321)->y=-8.95;
 (object[id].vertex+321)->z= 0.52;

 (object[id].vertex+322)->x=-1.91;
 (object[id].vertex+322)->y= 8.895;
 (object[id].vertex+322)->z= 0.52;

 (object[id].vertex+323)->x=-1.91;
 (object[id].vertex+323)->y=-8.895;
 (object[id].vertex+323)->z= 0.52;

 /* Flaps */
 (object[id].vertex+324)->x=-1.20;
 (object[id].vertex+324)->y= 4.16;
 (object[id].vertex+324)->z= 0.68;

 (object[id].vertex+325)->x=-1.20;
 (object[id].vertex+325)->y= 4.16;
 (object[id].vertex+325)->z= 0.48;

 (object[id].vertex+326)->x=-1.20;
 (object[id].vertex+326)->y=-4.16;
 (object[id].vertex+326)->z= 0.68;

 (object[id].vertex+327)->x=-1.20;
 (object[id].vertex+327)->y=-4.16;
 (object[id].vertex+327)->z= 0.48;

 (object[id].vertex+328)->x=-2.03;
 (object[id].vertex+328)->y= 4.03;
 (object[id].vertex+328)->z= 0.58;

 (object[id].vertex+329)->x=-2.03;
 (object[id].vertex+329)->y=-4.03;
 (object[id].vertex+329)->z= 0.58;

 (object[id].vertex+330)->x=-1.998;
 (object[id].vertex+330)->y= 3.52;
 (object[id].vertex+330)->z= 0.58;

 (object[id].vertex+331)->x=-1.998;
 (object[id].vertex+331)->y=-3.52;
 (object[id].vertex+331)->z= 0.58;

 (object[id].vertex+332)->x=-1.935;
 (object[id].vertex+332)->y= 2.53;
 (object[id].vertex+332)->z= 0.58;

 (object[id].vertex+333)->x=-1.935;
 (object[id].vertex+333)->y=-2.53;
 (object[id].vertex+333)->z= 0.58;

 (object[id].vertex+334)->x=-1.74;
 (object[id].vertex+334)->y= 2.33;
 (object[id].vertex+334)->z= 0.60;

 (object[id].vertex+335)->x=-1.74;
 (object[id].vertex+335)->y= 2.33;
 (object[id].vertex+335)->z= 0.56;

 (object[id].vertex+336)->x=-1.74;
 (object[id].vertex+336)->y=-2.33;
 (object[id].vertex+336)->z= 0.60;

 (object[id].vertex+337)->x=-1.74;
 (object[id].vertex+337)->y=-2.33;
 (object[id].vertex+337)->z= 0.56;

 (object[id].vertex+338)->x=-1.18;
 (object[id].vertex+338)->y= 2.33;
 (object[id].vertex+338)->z= 0.63;

 (object[id].vertex+339)->x=-1.18;
 (object[id].vertex+339)->y= 2.33;
 (object[id].vertex+339)->z= 0.48;

 (object[id].vertex+340)->x=-1.18;
 (object[id].vertex+340)->y=-2.33;
 (object[id].vertex+340)->z= 0.63;

 (object[id].vertex+341)->x=-1.18;
 (object[id].vertex+341)->y=-2.33;
 (object[id].vertex+341)->z= 0.48;

 /* Spoilers */
 (object[id].vertex+342)->x=-1.60;
 (object[id].vertex+342)->y= 8.32;
 (object[id].vertex+342)->z= 0.64;

 (object[id].vertex+343)->x=-0.79;
 (object[id].vertex+343)->y= 3.98;
 (object[id].vertex+343)->z= 0.66;

 (object[id].vertex+344)->x=-0.79;
 (object[id].vertex+344)->y=-3.98;
 (object[id].vertex+344)->z= 0.66;

 (object[id].vertex+345)->x=-1.60;
 (object[id].vertex+345)->y=-8.32;
 (object[id].vertex+345)->z= 0.64;

 (object[id].vertex+346)->x=-1.82;
 (object[id].vertex+346)->y= 8.30;
 (object[id].vertex+346)->z= 0.64;

 (object[id].vertex+347)->x=-1.17;
 (object[id].vertex+347)->y= 3.95;
 (object[id].vertex+347)->z= 0.66;

 (object[id].vertex+348)->x=-1.17;
 (object[id].vertex+348)->y=-3.95;
 (object[id].vertex+348)->z= 0.66;

 (object[id].vertex+349)->x=-1.82;
 (object[id].vertex+349)->y=-8.30;
 (object[id].vertex+349)->z= 0.64;

 /* Tailerons */
 (object[id].vertex+350)->x=-2.96;
 (object[id].vertex+350)->y= 2.29;
 (object[id].vertex+350)->z=-0.03;

 (object[id].vertex+351)->x=-2.96;
 (object[id].vertex+351)->y=-2.29;
 (object[id].vertex+351)->z=-0.03;

 (object[id].vertex+352)->x=-3.44;
 (object[id].vertex+352)->y= 2.29;
 (object[id].vertex+352)->z=-0.03;

 (object[id].vertex+353)->x=-3.44;
 (object[id].vertex+353)->y=-2.29;
 (object[id].vertex+353)->z=-0.03;

 (object[id].vertex+354)->x=-5.16;
 (object[id].vertex+354)->y= 2.31;
 (object[id].vertex+354)->z=-0.03;

 (object[id].vertex+355)->x=-5.16;
 (object[id].vertex+355)->y=-2.31;
 (object[id].vertex+355)->z=-0.03;

 (object[id].vertex+356)->x=-5.99;
 (object[id].vertex+356)->y= 2.00;
 (object[id].vertex+356)->z=-0.03;

 (object[id].vertex+357)->x=-5.99;
 (object[id].vertex+357)->y=-2.00;
 (object[id].vertex+357)->z=-0.03;

 (object[id].vertex+358)->x=-6.82;
 (object[id].vertex+358)->y= 2.35;
 (object[id].vertex+358)->z=-0.03;

 (object[id].vertex+359)->x=-6.82;
 (object[id].vertex+359)->y=-2.35;
 (object[id].vertex+359)->z=-0.03;

 (object[id].vertex+360)->x=-7.24;
 (object[id].vertex+360)->y= 4.48;
 (object[id].vertex+360)->z=-0.03;

 (object[id].vertex+361)->x=-7.24;
 (object[id].vertex+361)->y=-4.48;
 (object[id].vertex+361)->z=-0.03;

 (object[id].vertex+362)->x=-6.88;
 (object[id].vertex+362)->y= 4.83;
 (object[id].vertex+362)->z=-0.03;

 (object[id].vertex+363)->x=-6.88;
 (object[id].vertex+363)->y=-4.83;
 (object[id].vertex+363)->z=-0.03;

 (object[id].vertex+364)->x=-6.66;
 (object[id].vertex+364)->y= 4.93;
 (object[id].vertex+364)->z=-0.03;

 (object[id].vertex+365)->x=-6.66;
 (object[id].vertex+365)->y=-4.93;
 (object[id].vertex+365)->z=-0.03;

 (object[id].vertex+366)->x=-6.42;
 (object[id].vertex+366)->y= 4.915;
 (object[id].vertex+366)->z=-0.03;

 (object[id].vertex+367)->x=-6.42;
 (object[id].vertex+367)->y=-4.915;
 (object[id].vertex+367)->z=-0.03;

 (object[id].vertex+368)->x=-6.08;
 (object[id].vertex+368)->y= 4.73;
 (object[id].vertex+368)->z=-0.03;

 (object[id].vertex+369)->x=-6.08;
 (object[id].vertex+369)->y=-4.73;
 (object[id].vertex+369)->z=-0.03;

 (object[id].vertex+370)->x=-6.21;
 (object[id].vertex+370)->y= 4.61;
 (object[id].vertex+370)->z=-0.03;

 (object[id].vertex+371)->x=-6.21;
 (object[id].vertex+371)->y=-4.61;
 (object[id].vertex+371)->z=-0.03;

 /* Rudders */
 (object[id].vertex+372)->x=-6.45;
 (object[id].vertex+372)->y= 1.45;
 (object[id].vertex+372)->z= 0.58;

 (object[id].vertex+373)->x=-6.45;
 (object[id].vertex+373)->y=-1.45;
 (object[id].vertex+373)->z= 0.58;

 /* Lower airbrakes */
 (object[id].vertex+374)->x=-4.95;
 (object[id].vertex+374)->y= 0.70;
 (object[id].vertex+374)->z=-0.05;

 (object[id].vertex+375)->x=-4.95;
 (object[id].vertex+375)->y= 0.12;
 (object[id].vertex+375)->z=-0.05;

 (object[id].vertex+376)->x=-4.95;
 (object[id].vertex+376)->y=-0.12;
 (object[id].vertex+376)->z=-0.05;

 (object[id].vertex+377)->x=-4.95;
 (object[id].vertex+377)->y=-0.70;
 (object[id].vertex+377)->z=-0.05;

 (object[id].vertex+378)->x=-5.94;
 (object[id].vertex+378)->y= 0.70;
 (object[id].vertex+378)->z= 0.03;

 (object[id].vertex+379)->x=-5.94;
 (object[id].vertex+379)->y= 0.38;
 (object[id].vertex+379)->z= 0.03;

 (object[id].vertex+380)->x=-5.94;
 (object[id].vertex+380)->y=-0.38;
 (object[id].vertex+380)->z= 0.03;

 (object[id].vertex+381)->x=-5.94;
 (object[id].vertex+381)->y=-0.70;
 (object[id].vertex+381)->z= 0.03;

 /* Upper airbrake */
 (object[id].vertex+382)->x=-5.10;
 (object[id].vertex+382)->y= 0.60;
 (object[id].vertex+382)->z= 0.38;

 (object[id].vertex+383)->x=-5.10;
 (object[id].vertex+383)->y=-0.60;
 (object[id].vertex+383)->z= 0.38;

 (object[id].vertex+384)->x=-5.34;
 (object[id].vertex+384)->y= 0.73;
 (object[id].vertex+384)->z= 0.34;

 (object[id].vertex+385)->x=-5.34;
 (object[id].vertex+385)->y=-0.73;
 (object[id].vertex+385)->z= 0.34;

 (object[id].vertex+386)->x=-5.58;
 (object[id].vertex+386)->y= 0.19;
 (object[id].vertex+386)->z= 0.296;

 (object[id].vertex+387)->x=-5.58;
 (object[id].vertex+387)->y=-0.19;
 (object[id].vertex+387)->z= 0.296;

 (object[id].vertex+388)->x=-5.92;
 (object[id].vertex+388)->y= 0.83;
 (object[id].vertex+388)->z= 0.236;

 (object[id].vertex+389)->x=-5.93;
 (object[id].vertex+389)->y= 0.36;
 (object[id].vertex+389)->z= 0.236;

 (object[id].vertex+390)->x=-5.93;
 (object[id].vertex+390)->y=-0.36;
 (object[id].vertex+390)->z= 0.236;

 (object[id].vertex+391)->x=-5.92;
 (object[id].vertex+391)->y=-0.83;
 (object[id].vertex+391)->z= 0.236;

 (object[id].vertex+392)->x=-6.21;
 (object[id].vertex+392)->y= 0.71;
 (object[id].vertex+392)->z= 0.186;

 (object[id].vertex+393)->x=-6.21;
 (object[id].vertex+393)->y= 0.47;
 (object[id].vertex+393)->z= 0.186;

 (object[id].vertex+394)->x=-6.21;
 (object[id].vertex+394)->y=-0.47;
 (object[id].vertex+394)->z= 0.186;

 (object[id].vertex+395)->x=-6.21;
 (object[id].vertex+395)->y=-0.71;
 (object[id].vertex+395)->z= 0.186;

 /* Port undercarriage */
 for (i=0; i<8; i++){
  float xc=-0.62, yc= 2.45, zc=-1.35, radius=0.47;

  (object[id].vertex+396+i)->x=xc+radius*sin(i*PI/4+PI/8);
  (object[id].vertex+396+i)->y=yc;
  (object[id].vertex+396+i)->z=zc+radius*cos(i*PI/4+PI/8);
 }

 /* Stb. undercarriage */
 for (i=0; i<8; i++){
  float xc=-0.62, yc=-2.45, zc=-1.35, radius=0.47;

  (object[id].vertex+404+i)->x=xc+radius*sin(i*PI/4+PI/8);
  (object[id].vertex+404+i)->y=yc;
  (object[id].vertex+404+i)->z=zc+radius*cos(i*PI/4+PI/8);
 }

 (object[id].vertex+412)->x=-0.62;
 (object[id].vertex+412)->y= 2.08;
 (object[id].vertex+412)->z=-1.44;

 (object[id].vertex+413)->x=-0.53;
 (object[id].vertex+413)->y= 2.17;
 (object[id].vertex+413)->z=-1.44;

 (object[id].vertex+414)->x=-0.62;
 (object[id].vertex+414)->y= 2.26;
 (object[id].vertex+414)->z=-1.44;

 (object[id].vertex+415)->x=-0.71;
 (object[id].vertex+415)->y= 2.17;
 (object[id].vertex+415)->z=-1.44;

 (object[id].vertex+416)->x=-0.56;
 (object[id].vertex+416)->y= 2.08;
 (object[id].vertex+416)->z=-0.01;

 (object[id].vertex+417)->x=-0.47;
 (object[id].vertex+417)->y= 2.17;
 (object[id].vertex+417)->z=-0.01;

 (object[id].vertex+418)->x=-0.56;
 (object[id].vertex+418)->y= 2.26;
 (object[id].vertex+418)->z=-0.01;

 (object[id].vertex+419)->x=-0.65;
 (object[id].vertex+419)->y= 2.17;
 (object[id].vertex+419)->z=-0.01;

 (object[id].vertex+420)->x=-0.62;
 (object[id].vertex+420)->y=-2.26;
 (object[id].vertex+420)->z=-1.44;

 (object[id].vertex+421)->x=-0.53;
 (object[id].vertex+421)->y=-2.17;
 (object[id].vertex+421)->z=-1.44;

 (object[id].vertex+422)->x=-0.62;
 (object[id].vertex+422)->y=-2.08;
 (object[id].vertex+422)->z=-1.44;

 (object[id].vertex+423)->x=-0.71;
 (object[id].vertex+423)->y=-2.17;
 (object[id].vertex+423)->z=-1.44;

 (object[id].vertex+424)->x=-0.56;
 (object[id].vertex+424)->y=-2.26;
 (object[id].vertex+424)->z=-0.01;

 (object[id].vertex+425)->x=-0.47;
 (object[id].vertex+425)->y=-2.17;
 (object[id].vertex+425)->z=-0.01;

 (object[id].vertex+426)->x=-0.56;
 (object[id].vertex+426)->y=-2.08;
 (object[id].vertex+426)->z=-0.01;

 (object[id].vertex+427)->x=-0.65;
 (object[id].vertex+427)->y=-2.17;
 (object[id].vertex+427)->z=-0.01;

 /* Nose gear */
 for (i=0; i<8; i++){
  float xc= 6.25, yc= 0.20, zc=-1.53, radius=0.24;

  (object[id].vertex+428+i)->x=xc+radius*sin(i*PI/4+PI/8);
  (object[id].vertex+428+i)->y=yc;
  (object[id].vertex+428+i)->z=zc+radius*cos(i*PI/4+PI/8);
 }

 for (i=0; i<8; i++){
  float xc= 6.25, yc=-0.20, zc=-1.53, radius=0.24;

  (object[id].vertex+436+i)->x=xc+radius*sin(i*PI/4+PI/8);
  (object[id].vertex+436+i)->y=yc;
  (object[id].vertex+436+i)->z=zc+radius*cos(i*PI/4+PI/8);
 }

 (object[id].vertex+444)->x= 6.41;
 (object[id].vertex+444)->y= 0.00;
 (object[id].vertex+444)->z=-0.41;

 (object[id].vertex+445)->x= 6.41;
 (object[id].vertex+445)->y= 0.00;
 (object[id].vertex+445)->z=-1.58;

 (object[id].vertex+446)->x= 6.29;
 (object[id].vertex+446)->y= 0.00;
 (object[id].vertex+446)->z=-1.58;

 (object[id].vertex+447)->x= 6.29;
 (object[id].vertex+447)->y= 0.00;
 (object[id].vertex+447)->z=-0.41;

 /* Glove vanes */
 (object[id].vertex+448)->x= 4.76;
 (object[id].vertex+448)->y= 1.833;
 (object[id].vertex+448)->z= 0.55;

 (object[id].vertex+449)->x= 4.76;
 (object[id].vertex+449)->y=-1.833;
 (object[id].vertex+449)->z= 0.55;

 (object[id].vertex+450)->x= 2.51;
 (object[id].vertex+450)->y= 2.741;
 (object[id].vertex+450)->z= 0.57;

 (object[id].vertex+451)->x= 2.51;
 (object[id].vertex+451)->y=-2.741;
 (object[id].vertex+451)->z= 0.57;

 (object[id].vertex+452)->x= 2.91;
 (object[id].vertex+452)->y= 3.356;
 (object[id].vertex+452)->z= 0.57;

 (object[id].vertex+453)->x= 2.91;
 (object[id].vertex+453)->y=-3.356;
 (object[id].vertex+453)->z= 0.57;

 /* Fin base */
 (object[id].vertex+454)->x=-2.56;
 (object[id].vertex+454)->y= 1.45;
 (object[id].vertex+454)->z= 0.61;

 (object[id].vertex+455)->x=-2.56;
 (object[id].vertex+455)->y=-1.45;
 (object[id].vertex+455)->z= 0.61;

 (object[id].vertex+456)->x=-3.55;
 (object[id].vertex+456)->y= 1.46;
 (object[id].vertex+456)->z= 0.81;

 (object[id].vertex+457)->x=-3.55;
 (object[id].vertex+457)->y=-1.46;
 (object[id].vertex+457)->z= 0.81;

 /*
 (object[id].vertex+)->x=;
 (object[id].vertex+)->y=;
 (object[id].vertex+)->z=;
 */

 /**********/
 /* Facets */
 /**********/

 /* Belly */
 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=0;
 facetid->edge[1]=1;
 facetid->edge[2]=2;
 facetid->edge[3]=3;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=4;
 facetid->edge[1]=5;
 facetid->edge[2]=6;
 facetid->edge[3]=7;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=8;
 facetid->edge[1]=9;
 facetid->edge[2]=10;
 facetid->edge[3]=11;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=0;
 facetid->edge[1]=3;
 facetid->edge[2]=13;
 facetid->edge[3]=12;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=13;
 facetid->edge[1]=6;
 facetid->edge[2]=5;
 facetid->edge[3]=12;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=1;
 facetid->edge[1]=14;
 facetid->edge[2]=15;
 facetid->edge[3]=2;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=14;
 facetid->edge[1]=8;
 facetid->edge[2]=11;
 facetid->edge[3]=15;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=17;
 facetid->edge[1]=4;
 facetid->edge[2]=7;
 facetid->edge[3]=18;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=9;
 facetid->edge[1]=20;
 facetid->edge[2]=23;
 facetid->edge[3]=10;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=16;
 facetid->edge[1]=17;
 facetid->edge[2]=18;
 facetid->edge[3]=19;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=20;
 facetid->edge[1]=21;
 facetid->edge[2]=22;
 facetid->edge[3]=23;
 facetid++;

 /* Belly fins */
 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=24;
 facetid->edge[1]=25;
 facetid->edge[2]=26;
 facetid->edge[3]=27;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=27;
 facetid->edge[1]=26;
 facetid->edge[2]=25;
 facetid->edge[3]=24;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=28;
 facetid->edge[1]=29;
 facetid->edge[2]=30;
 facetid->edge[3]=31;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=31;
 facetid->edge[1]=30;
 facetid->edge[2]=29;
 facetid->edge[3]=28;
 facetid++;

 /* Forward of engines */

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=32;
 facetid->edge[1]=33;
 facetid->edge[2]=17;
 facetid->edge[3]=16;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=33;
 facetid->edge[1]=34;
 facetid->edge[2]=4;
 facetid->edge[3]=17;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=34;
 facetid->edge[1]=35;
 facetid->edge[2]=5;
 facetid->edge[3]=4;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=35;
 facetid->edge[1]=36;
 facetid->edge[2]=12;
 facetid->edge[3]=5;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=36;
 facetid->edge[1]=37;
 facetid->edge[2]=0;
 facetid->edge[3]=12;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=37;
 facetid->edge[1]=38;
 facetid->edge[2]=1;
 facetid->edge[3]=0;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=38;
 facetid->edge[1]=39;
 facetid->edge[2]=14;
 facetid->edge[3]=1;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=39;
 facetid->edge[1]=40;
 facetid->edge[2]=8;
 facetid->edge[3]=14;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=40;
 facetid->edge[1]=41;
 facetid->edge[2]=9;
 facetid->edge[3]=8;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=41;
 facetid->edge[1]=42;
 facetid->edge[2]=20;
 facetid->edge[3]=9;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=42;
 facetid->edge[1]=43;
 facetid->edge[2]=21;
 facetid->edge[3]=20;
 facetid++;

 /* Intakes */
 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=47;
 facetid->edge[1]=45;
 facetid->edge[2]=44;
 facetid->edge[3]=48;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=54;
 facetid->edge[1]=53;
 facetid->edge[2]=51;
 facetid->edge[3]=50;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=44;
 facetid->edge[1]=45;
 facetid->edge[2]=34;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=35;
 facetid->edge[1]=34;
 facetid->edge[2]=45;
 facetid++;


 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=50;
 facetid->edge[1]=51;
 facetid->edge[2]=41;
 facetid++;


 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=41;
 facetid->edge[1]=40;
 facetid->edge[2]=50;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=34;
 facetid->edge[1]=33;
 facetid->edge[2]=44;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=36;
 facetid->edge[1]=35;
 facetid->edge[2]=45;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=40;
 facetid->edge[1]=39;
 facetid->edge[2]=50;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=42;
 facetid->edge[1]=41;
 facetid->edge[2]=51;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=33;
 facetid->edge[1]=32;
 facetid->edge[2]=44;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=37;
 facetid->edge[1]=36;
 facetid->edge[2]=45;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=39;
 facetid->edge[1]=38;
 facetid->edge[2]=50;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=43;
 facetid->edge[1]=42;
 facetid->edge[2]=51;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=32;
 facetid->edge[1]=48;
 facetid->edge[2]=44;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=43;
 facetid->edge[1]=51;
 facetid->edge[2]=53;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=47;
 facetid->edge[1]=48;
 facetid->edge[2]=56;
 facetid->edge[3]=57;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=54;
 facetid->edge[1]=60;
 facetid->edge[2]=61;
 facetid->edge[3]=53;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=58;
 facetid->edge[1]=49;
 facetid->edge[2]=48;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=58;
 facetid->edge[1]=48;
 facetid->edge[2]=49;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=59;
 facetid->edge[1]=46;
 facetid->edge[2]=47;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=59;
 facetid->edge[1]=47;
 facetid->edge[2]=46;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=62;
 facetid->edge[1]=55;
 facetid->edge[2]=54;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=62;
 facetid->edge[1]=54;
 facetid->edge[2]=55;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=63;
 facetid->edge[1]=52;
 facetid->edge[2]=53;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=63;
 facetid->edge[1]=53;
 facetid->edge[2]=52;
 facetid++;

 /* Belly */
 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=37;
 facetid->edge[1]=64;
 facetid->edge[2]=65;
 facetid->edge[3]=38;
 facetid++;

 /* Side boxes */
 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=72;
 facetid->edge[1]=73;
 facetid->edge[2]=67;
 facetid->edge[3]=66;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=73;
 facetid->edge[1]=74;
 facetid->edge[2]=68;
 facetid->edge[3]=67;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=76;
 facetid->edge[1]=75;
 facetid->edge[2]=69;
 facetid->edge[3]=70;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=77;
 facetid->edge[1]=76;
 facetid->edge[2]=70;
 facetid->edge[3]=71;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=72;
 facetid->edge[1]=78;
 facetid->edge[2]=73;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=73;
 facetid->edge[1]=78;
 facetid->edge[2]=79;
 facetid->edge[3]=74;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=75;
 facetid->edge[1]=76;
 facetid->edge[2]=80;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=76;
 facetid->edge[1]=77;
 facetid->edge[2]=81;
 facetid->edge[3]=80;
 facetid++;

 /* Back */
 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=82;
 facetid->edge[1]=83;
 facetid->edge[2]=84;
 facetid->edge[3]=85;
 facetid++;

 /* Tail fins */
 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=86;
 facetid->edge[1]=90;
 facetid->edge[2]=93;
 facetid->edge[3]=89;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=86;
 facetid->edge[1]=89;
 facetid->edge[2]=93;
 facetid->edge[3]=90;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=87;
 facetid->edge[1]=91;
 facetid->edge[2]=92;
 facetid->edge[3]=88;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=87;
 facetid->edge[1]=88;
 facetid->edge[2]=92;
 facetid->edge[3]=91;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=5;
 facetid->edge[0]=93;
 facetid->edge[1]=94;
 facetid->edge[2]=95;
 facetid->edge[3]=96;
 facetid->edge[4]=97;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=5;
 facetid->edge[0]=95;
 facetid->edge[1]=94;
 facetid->edge[2]=93;
 facetid->edge[3]=97;
 facetid->edge[4]=96;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=5;
 facetid->edge[0]= 92;
 facetid->edge[1]= 98;
 facetid->edge[2]= 99;
 facetid->edge[3]=100;
 facetid->edge[4]=101;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=5;
 facetid->edge[0]= 99;
 facetid->edge[1]= 98;
 facetid->edge[2]= 92;
 facetid->edge[3]=101;
 facetid->edge[4]=100;
 facetid++;

 /* Back */
 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]= 82;
 facetid->edge[1]= 85;
 facetid->edge[2]=102;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=103;
 facetid->edge[1]= 84;
 facetid->edge[2]= 83;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]= 86;
 facetid->edge[1]=102;
 facetid->edge[2]= 85;
 facetid->edge[3]= 89;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]= 87;
 facetid->edge[1]= 88;
 facetid->edge[2]= 84;
 facetid->edge[3]=103;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]= 79;
 facetid->edge[1]=104;
 facetid->edge[2]= 74;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]= 81;
 facetid->edge[1]= 77;
 facetid->edge[2]=105;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]= 89;
 facetid->edge[1]=106;
 facetid->edge[2]=104;
 facetid->edge[3]= 86;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]= 87;
 facetid->edge[1]=105;
 facetid->edge[2]=107;
 facetid->edge[3]= 88;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]= 74;
 facetid->edge[1]=104;
 facetid->edge[2]=106;
 facetid->edge[3]=108;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=105;
 facetid->edge[1]= 77;
 facetid->edge[2]=109;
 facetid->edge[3]=107;
 facetid++;

 /* Beaver tail */
 facetid->color=LIGHTGRAY;
 facetid->nedges=6;
 facetid->edge[0]= 83;
 facetid->edge[1]= 82;
 facetid->edge[2]=110;
 facetid->edge[3]=114;
 facetid->edge[4]=115;
 facetid->edge[5]=111;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=6;
 facetid->edge[0]=  3;
 facetid->edge[1]=  2;
 facetid->edge[2]=113;
 facetid->edge[3]=115;
 facetid->edge[4]=114;
 facetid->edge[5]=112;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=116;
 facetid->edge[1]=118;
 facetid->edge[2]=119;
 facetid->edge[3]=117;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=116;
 facetid->edge[1]=117;
 facetid->edge[2]=119;
 facetid->edge[3]=118;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=110;
 facetid->edge[1]=112;
 facetid->edge[2]=114;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=113;
 facetid->edge[1]=111;
 facetid->edge[2]=115;
 facetid++;

 /* Port engine exhaust */

 facetid->color=LIGHTGRAY;
 facetid->nedges=8;
 facetid->edge[0]=19;
 facetid->edge[1]=18;
 facetid->edge[2]= 7;
 facetid->edge[3]= 6;
 facetid->edge[4]=13;
 facetid->edge[5]= 3;
 facetid->edge[6]=82;
 facetid->edge[7]=104;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]= 82;
 facetid->edge[1]=102;
 facetid->edge[2]= 86;
 facetid->edge[3]=104;
 facetid++;

 facetid->color=BLACK;
 facetid->nedges=8;
 facetid->edge[0]=135;
 facetid->edge[1]=134;
 facetid->edge[2]=133;
 facetid->edge[3]=132;
 facetid->edge[4]=131;
 facetid->edge[5]=130;
 facetid->edge[6]=129;
 facetid->edge[7]=128;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=128;
 facetid->edge[1]=129;
 facetid->edge[2]=121;
 facetid->edge[3]=120;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=129;
 facetid->edge[1]=130;
 facetid->edge[2]=122;
 facetid->edge[3]=121;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=130;
 facetid->edge[1]=131;
 facetid->edge[2]=123;
 facetid->edge[3]=122;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=131;
 facetid->edge[1]=132;
 facetid->edge[2]=124;
 facetid->edge[3]=123;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=132;
 facetid->edge[1]=133;
 facetid->edge[2]=125;
 facetid->edge[3]=124;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=133;
 facetid->edge[1]=134;
 facetid->edge[2]=126;
 facetid->edge[3]=125;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=134;
 facetid->edge[1]=135;
 facetid->edge[2]=127;
 facetid->edge[3]=126;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=135;
 facetid->edge[1]=128;
 facetid->edge[2]=120;
 facetid->edge[3]=127;
 facetid++;

 /* Stb. engine exhaust */

 facetid->color=LIGHTGRAY;
 facetid->nedges=8;
 facetid->edge[0]=2;
 facetid->edge[1]=15;
 facetid->edge[2]=11;
 facetid->edge[3]=10;
 facetid->edge[4]=23;
 facetid->edge[5]=22;
 facetid->edge[6]=105;
 facetid->edge[7]=83;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=105;
 facetid->edge[1]= 87;
 facetid->edge[2]=103;
 facetid->edge[3]= 83;
 facetid++;

 facetid->color=BLACK;
 facetid->nedges=8;
 facetid->edge[0]=151;
 facetid->edge[1]=150;
 facetid->edge[2]=149;
 facetid->edge[3]=148;
 facetid->edge[4]=147;
 facetid->edge[5]=146;
 facetid->edge[6]=145;
 facetid->edge[7]=144;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=144;
 facetid->edge[1]=145;
 facetid->edge[2]=137;
 facetid->edge[3]=136;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=145;
 facetid->edge[1]=146;
 facetid->edge[2]=138;
 facetid->edge[3]=137;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=146;
 facetid->edge[1]=147;
 facetid->edge[2]=139;
 facetid->edge[3]=138;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=147;
 facetid->edge[1]=148;
 facetid->edge[2]=140;
 facetid->edge[3]=139;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=148;
 facetid->edge[1]=149;
 facetid->edge[2]=141;
 facetid->edge[3]=140;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=149;
 facetid->edge[1]=150;
 facetid->edge[2]=142;
 facetid->edge[3]=141;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=150;
 facetid->edge[1]=151;
 facetid->edge[2]=143;
 facetid->edge[3]=142;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=151;
 facetid->edge[1]=144;
 facetid->edge[2]=136;
 facetid->edge[3]=143;
 facetid++;

 /* Side boxes */
 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]= 66;
 facetid->edge[1]= 67;
 facetid->edge[2]=153;
 facetid->edge[3]=152;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]= 70;
 facetid->edge[1]= 69;
 facetid->edge[2]=154;
 facetid->edge[3]=155;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=152;
 facetid->edge[1]=153;
 facetid->edge[2]= 48;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=155;
 facetid->edge[1]=154;
 facetid->edge[2]= 53;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]= 68;
 facetid->edge[1]= 48;
 facetid->edge[2]=153;
 facetid->edge[3]= 67;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]= 71;
 facetid->edge[1]= 70;
 facetid->edge[2]=155;
 facetid->edge[3]= 53;
 facetid++;

 /* Gloves */
 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]= 68;
 facetid->edge[1]=160;
 facetid->edge[2]=156;
 facetid->edge[3]= 48;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]= 71;
 facetid->edge[1]= 53;
 facetid->edge[2]=157;
 facetid->edge[3]=161;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=160;
 facetid->edge[1]=158;
 facetid->edge[2]=156;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=161;
 facetid->edge[1]=157;
 facetid->edge[2]=159;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=162;
 facetid->edge[1]=156;
 facetid->edge[2]=158;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=163;
 facetid->edge[1]=159;
 facetid->edge[2]=157;
 facetid++;

 /* Nose */
 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=165;
 facetid->edge[1]=166;
 facetid->edge[2]=164;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=166;
 facetid->edge[1]=167;
 facetid->edge[2]=164;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=167;
 facetid->edge[1]=168;
 facetid->edge[2]=164;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=168;
 facetid->edge[1]=169;
 facetid->edge[2]=164;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=169;
 facetid->edge[1]=170;
 facetid->edge[2]=164;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=170;
 facetid->edge[1]=171;
 facetid->edge[2]=164;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=171;
 facetid->edge[1]=172;
 facetid->edge[2]=164;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=172;
 facetid->edge[1]=165;
 facetid->edge[2]=164;
 facetid++;

 /* Cockpit section */
 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=173;
 facetid->edge[1]=174;
 facetid->edge[2]=176;
 facetid->edge[3]=175;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=175;
 facetid->edge[1]=179;
 facetid->edge[2]=177;
 facetid->edge[3]=173;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=174;
 facetid->edge[1]=178;
 facetid->edge[2]=180;
 facetid->edge[3]=176;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=179;
 facetid->edge[1]=183;
 facetid->edge[2]=181;
 facetid->edge[3]=177;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=178;
 facetid->edge[1]=182;
 facetid->edge[2]=184;
 facetid->edge[3]=180;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=183;
 facetid->edge[1]=187;
 facetid->edge[2]=185;
 facetid->edge[3]=181;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=182;
 facetid->edge[1]=186;
 facetid->edge[2]=188;
 facetid->edge[3]=184;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=187;
 facetid->edge[1]=191;
 facetid->edge[2]=189;
 facetid->edge[3]=185;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=186;
 facetid->edge[1]=190;
 facetid->edge[2]=192;
 facetid->edge[3]=188;
 facetid++;

 /* 137 */

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=193;
 facetid->edge[1]=194;
 facetid->edge[2]=174;
 facetid->edge[3]=173;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=169;
 facetid->edge[1]=168;
 facetid->edge[2]=194;
 facetid->edge[3]=193;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=173;
 facetid->edge[1]=177;
 facetid->edge[2]=195;
 facetid->edge[3]=193;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=194;
 facetid->edge[1]=196;
 facetid->edge[2]=178;
 facetid->edge[3]=174;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=193;
 facetid->edge[1]=195;
 facetid->edge[2]=170;
 facetid->edge[3]=169;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=168;
 facetid->edge[1]=167;
 facetid->edge[2]=196;
 facetid->edge[3]=194;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=177;
 facetid->edge[1]=181;
 facetid->edge[2]=197;
 facetid->edge[3]=195;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=196;
 facetid->edge[1]=198;
 facetid->edge[2]=182;
 facetid->edge[3]=178;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=195;
 facetid->edge[1]=197;
 facetid->edge[2]=171;
 facetid->edge[3]=170;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=167;
 facetid->edge[1]=166;
 facetid->edge[2]=198;
 facetid->edge[3]=196;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=200;
 facetid->edge[1]=201;
 facetid->edge[2]=165;
 facetid->edge[3]=172;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=201;
 facetid->edge[1]=202;
 facetid->edge[2]=165;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=199;
 facetid->edge[1]=200;
 facetid->edge[2]=172;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=185;
 facetid->edge[1]=189;
 facetid->edge[2]=199;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=199;
 facetid->edge[1]=189;
 facetid->edge[2]=200;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=190;
 facetid->edge[1]=186;
 facetid->edge[2]=202;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=202;
 facetid->edge[1]=201;
 facetid->edge[2]=190;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=171;
 facetid->edge[1]=199;
 facetid->edge[2]=172;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=166;
 facetid->edge[1]=165;
 facetid->edge[2]=202;
 facetid++;


 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=181;
 facetid->edge[1]=185;
 facetid->edge[2]=197;
 facetid++;


 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=186;
 facetid->edge[1]=182;
 facetid->edge[2]=198;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=197;
 facetid->edge[1]=199;
 facetid->edge[2]=171;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=166;
 facetid->edge[1]=202;
 facetid->edge[2]=198;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=185;
 facetid->edge[1]=199;
 facetid->edge[2]=197;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=186;
 facetid->edge[1]=198;
 facetid->edge[2]=202;
 facetid++;

 /* 163 belly */
 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=204;
 facetid->edge[1]=203;
 facetid->edge[2]=175;
 facetid->edge[3]=176;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=203;
 facetid->edge[1]=179;
 facetid->edge[2]=175;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=176;
 facetid->edge[1]=180;
 facetid->edge[2]=204;
 facetid++;

 /* Canopy */
 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=200;
 facetid->edge[1]=207;
 facetid->edge[2]=208;
 facetid->edge[3]=201;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=3;
 facetid->edge[0]=189;
 facetid->edge[1]=205;
 facetid->edge[2]=200;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=3;
 facetid->edge[0]=205;
 facetid->edge[1]=207;
 facetid->edge[2]=200;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=3;
 facetid->edge[0]=201;
 facetid->edge[1]=208;
 facetid->edge[2]=206;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=3;
 facetid->edge[0]=201;
 facetid->edge[1]=206;
 facetid->edge[2]=190;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=209;
 facetid->edge[1]=210;
 facetid->edge[2]=208;
 facetid->edge[3]=207;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=211;
 facetid->edge[1]=212;
 facetid->edge[2]=210;
 facetid->edge[3]=209;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=213;
 facetid->edge[1]=214;
 facetid->edge[2]=212;
 facetid->edge[3]=211;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=221;
 facetid->edge[1]=215;
 facetid->edge[2]=205;
 facetid->edge[3]=189;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=215;
 facetid->edge[1]=209;
 facetid->edge[2]=207;
 facetid->edge[3]=205;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=210;
 facetid->edge[1]=216;
 facetid->edge[2]=206;
 facetid->edge[3]=208;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=216;
 facetid->edge[1]=222;
 facetid->edge[2]=190;
 facetid->edge[3]=206;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=223;
 facetid->edge[1]=217;
 facetid->edge[2]=215;
 facetid->edge[3]=221;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=217;
 facetid->edge[1]=211;
 facetid->edge[2]=209;
 facetid->edge[3]=215;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=212;
 facetid->edge[1]=218;
 facetid->edge[2]=216;
 facetid->edge[3]=210;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=218;
 facetid->edge[1]=224;
 facetid->edge[2]=222;
 facetid->edge[3]=216;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=225;
 facetid->edge[1]=219;
 facetid->edge[2]=217;
 facetid->edge[3]=223;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=219;
 facetid->edge[1]=213;
 facetid->edge[2]=211;
 facetid->edge[3]=217;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=214;
 facetid->edge[1]=220;
 facetid->edge[2]=218;
 facetid->edge[3]=212;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=220;
 facetid->edge[1]=226;
 facetid->edge[2]=224;
 facetid->edge[3]=218;
 facetid++;

 /* Canopy frame */
 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=227;
 facetid->edge[1]=225;
 facetid->edge[2]=191;
 facetid->edge[3]=187;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=188;
 facetid->edge[1]=192;
 facetid->edge[2]=226;
 facetid->edge[3]=228;
 facetid++;

 /* Spine */
 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=229;
 facetid->edge[1]=225;
 facetid->edge[2]=227;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=229;
 facetid->edge[1]=219;
 facetid->edge[2]=225;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=229;
 facetid->edge[1]=213;
 facetid->edge[2]=219;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=229;
 facetid->edge[1]=214;
 facetid->edge[2]=213;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=229;
 facetid->edge[1]=220;
 facetid->edge[2]=214;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=229;
 facetid->edge[1]=226;
 facetid->edge[2]=220;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=229;
 facetid->edge[1]=228;
 facetid->edge[2]=226;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=187;
 facetid->edge[1]=230;
 facetid->edge[2]=227;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=231;
 facetid->edge[1]=188;
 facetid->edge[2]=228;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=230;
 facetid->edge[1]=232;
 facetid->edge[2]=227;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=231;
 facetid->edge[1]=228;
 facetid->edge[2]=233;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=227;
 facetid->edge[1]=232;
 facetid->edge[2]=229;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=228;
 facetid->edge[1]=229;
 facetid->edge[2]=233;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=232;
 facetid->edge[1]=233;
 facetid->edge[2]=229;
 facetid++;

 /* 201 Gloves */
 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=162;
 facetid->edge[1]=234;
 facetid->edge[2]=156;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=163;
 facetid->edge[1]=157;
 facetid->edge[2]=235;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=162;
 facetid->edge[1]=236;
 facetid->edge[2]=234;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=237;
 facetid->edge[1]=163;
 facetid->edge[2]=235;
 facetid++;

 /* Back */
 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=238;
 facetid->edge[1]=236;
 facetid->edge[2]=162;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=238;
 facetid->edge[1]=240;
 facetid->edge[2]=236;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=241;
 facetid->edge[1]=239;
 facetid->edge[2]=237;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=239;
 facetid->edge[1]=163;
 facetid->edge[2]=237;
 facetid++;

 /* Above air intakes */

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=242;
 facetid->edge[1]=246;
 facetid->edge[2]=247;
 facetid->edge[3]= 56;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=246;
 facetid->edge[1]=243;
 facetid->edge[2]= 57;
 facetid->edge[3]=247;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=244;
 facetid->edge[1]=245;
 facetid->edge[2]= 61;
 facetid->edge[3]= 60;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=157;
 facetid->edge[1]=245;
 facetid->edge[2]=235;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=156;
 facetid->edge[1]=234;
 facetid->edge[2]=242;
 facetid++;

 /* 214 */
 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=230;
 facetid->edge[1]=252;
 facetid->edge[2]=248;
 facetid->edge[3]=249;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=253;
 facetid->edge[1]=231;
 facetid->edge[2]=250;
 facetid->edge[3]=251;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=252;
 facetid->edge[1]=243;
 facetid->edge[2]=248;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=251;
 facetid->edge[1]=244;
 facetid->edge[2]=253;
 facetid++;

 /* 218 Bleed ducts */
 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=254;
 facetid->edge[1]=255;
 facetid->edge[2]=259;
 facetid->edge[3]=258;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=256;
 facetid->edge[1]=257;
 facetid->edge[2]=261;
 facetid->edge[3]=260;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=248;
 facetid->edge[1]=255;
 facetid->edge[2]=254;
 facetid->edge[3]=262;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=263;
 facetid->edge[1]=257;
 facetid->edge[2]=256;
 facetid->edge[3]=251;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=264;
 facetid->edge[1]=259;
 facetid->edge[2]=243;
 facetid->edge[3]=242;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=260;
 facetid->edge[1]=266;
 facetid->edge[2]=245;
 facetid->edge[3]=244;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=265;
 facetid->edge[1]=262;
 facetid->edge[2]=258;
 facetid->edge[3]=264;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=263;
 facetid->edge[1]=267;
 facetid->edge[2]=266;
 facetid->edge[3]=261;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=262;
 facetid->edge[1]=254;
 facetid->edge[2]=258;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=259;
 facetid->edge[1]=255;
 facetid->edge[2]=248;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=251;
 facetid->edge[1]=256;
 facetid->edge[2]=260;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=261;
 facetid->edge[1]=257;
 facetid->edge[2]=263;
 facetid++;

 /* 230 back */
 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=240;
 facetid->edge[1]=232;
 facetid->edge[2]=249;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=233;
 facetid->edge[1]=241;
 facetid->edge[2]=250;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=249;
 facetid->edge[1]=265;
 facetid->edge[2]=238;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=250;
 facetid->edge[1]=237;
 facetid->edge[2]=267;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=249;
 facetid->edge[1]=238;
 facetid->edge[2]=240;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=250;
 facetid->edge[1]=241;
 facetid->edge[2]=237;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=5;
 facetid->edge[0]=242;
 facetid->edge[1]=234;
 facetid->edge[2]=236;
 facetid->edge[3]=265;
 facetid->edge[4]=264;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=5;
 facetid->edge[0]=235;
 facetid->edge[1]=245;
 facetid->edge[2]=266;
 facetid->edge[3]=267;
 facetid->edge[4]=237;
 facetid++;

 /* Below sweeping part */
 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=108;
 facetid->edge[1]=240;
 facetid->edge[2]= 68;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=108;
 facetid->edge[1]=106;
 facetid->edge[2]=240;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=106;
 facetid->edge[1]= 89;
 facetid->edge[2]= 85;
 facetid->edge[3]=240;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=109;
 facetid->edge[1]= 71;
 facetid->edge[2]=241;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=107;
 facetid->edge[1]=109;
 facetid->edge[2]=241;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]= 88;
 facetid->edge[1]=107;
 facetid->edge[2]=241;
 facetid->edge[3]= 84;
 facetid++;

 /* Belly around intakes */
 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=252;
 facetid->edge[1]=230;
 facetid->edge[2]=269;
 facetid->edge[3]=268;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=268;
 facetid->edge[1]=269;
 facetid->edge[2]=203;
 facetid->edge[3]= 64;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=231;
 facetid->edge[1]=253;
 facetid->edge[2]=271;
 facetid->edge[3]=270;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=270;
 facetid->edge[1]=271;
 facetid->edge[2]= 65;
 facetid->edge[3]=204;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=183;
 facetid->edge[1]=179;
 facetid->edge[2]=203;
 facetid->edge[3]=269;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=230;
 facetid->edge[1]=183;
 facetid->edge[2]=269;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=180;
 facetid->edge[1]=184;
 facetid->edge[2]=270;
 facetid->edge[3]=204;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=184;
 facetid->edge[1]=231;
 facetid->edge[2]=270;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]= 37;
 facetid->edge[1]= 45;
 facetid->edge[2]= 64;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]= 38;
 facetid->edge[1]= 65;
 facetid->edge[2]= 50;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]= 64;
 facetid->edge[1]= 45;
 facetid->edge[2]=268;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]= 65;
 facetid->edge[1]=271;
 facetid->edge[2]= 50;
 facetid++;

 /* 256 inner back strakes */
 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=240;
 facetid->edge[1]=274;
 facetid->edge[2]=273;
 facetid->edge[3]=272;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=272;
 facetid->edge[1]=273;
 facetid->edge[2]=274;
 facetid->edge[3]=240;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=241;
 facetid->edge[1]=277;
 facetid->edge[2]=276;
 facetid->edge[3]=275;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=275;
 facetid->edge[1]=276;
 facetid->edge[2]=277;
 facetid->edge[3]=241;
 facetid++;

 /* Outer back strakes */
 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=278;
 facetid->edge[1]=279;
 facetid->edge[2]=280;
 facetid->edge[3]=281;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=281;
 facetid->edge[1]=280;
 facetid->edge[2]=279;
 facetid->edge[3]=278;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=282;
 facetid->edge[1]=283;
 facetid->edge[2]=284;
 facetid->edge[3]=285;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=285;
 facetid->edge[1]=284;
 facetid->edge[2]=283;
 facetid->edge[3]=282;
 facetid++;

 /* 264 wings */
 /* main surfaces */
 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=286;
 facetid->edge[1]=288;
 facetid->edge[2]=290;
 facetid->edge[3]=292;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=289;
 facetid->edge[1]=287;
 facetid->edge[2]=293;
 facetid->edge[3]=291;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=302;
 facetid->edge[1]=304;
 facetid->edge[2]=322;
 facetid->edge[3]=320;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=321;
 facetid->edge[1]=323;
 facetid->edge[2]=305;
 facetid->edge[3]=303;
 facetid++;

 /* Inner wing */
 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=294;
 facetid->edge[1]=286;
 facetid->edge[2]=292;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=293;
 facetid->edge[1]=287;
 facetid->edge[2]=295;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=302;
 facetid->edge[1]=306;
 facetid->edge[2]=304;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=303;
 facetid->edge[1]=305;
 facetid->edge[2]=307;
 facetid++;

 /* Below spoilers */
 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=298;
 facetid->edge[1]=292;
 facetid->edge[2]=290;
 facetid->edge[3]=296;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=300;
 facetid->edge[1]=294;
 facetid->edge[2]=292;
 facetid->edge[3]=298;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=299;
 facetid->edge[1]=293;
 facetid->edge[2]=295;
 facetid->edge[3]=301;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=299;
 facetid->edge[1]=297;
 facetid->edge[2]=291;
 facetid->edge[3]=293;
 facetid++;

 /* 276 Wing tips */
 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=288;
 facetid->edge[1]=308;
 facetid->edge[2]=316;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=290;
 facetid->edge[1]=288;
 facetid->edge[2]=316;
 facetid->edge[3]=314;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=290;
 facetid->edge[1]=314;
 facetid->edge[2]=312;
 facetid->edge[3]=296;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=296;
 facetid->edge[1]=312;
 facetid->edge[2]=310;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=289;
 facetid->edge[1]=317;
 facetid->edge[2]=309;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=291;
 facetid->edge[1]=315;
 facetid->edge[2]=317;
 facetid->edge[3]=289;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=315;
 facetid->edge[1]=291;
 facetid->edge[2]=297;
 facetid->edge[3]=313;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=297;
 facetid->edge[1]=311;
 facetid->edge[2]=313;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=316;
 facetid->edge[1]=308;
 facetid->edge[2]=320;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=316;
 facetid->edge[1]=320;
 facetid->edge[2]=314;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=320;
 facetid->edge[1]=322;
 facetid->edge[2]=312;
 facetid->edge[3]=314;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=322;
 facetid->edge[1]=310;
 facetid->edge[2]=312;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=309;
 facetid->edge[1]=317;
 facetid->edge[2]=321;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=321;
 facetid->edge[1]=317;
 facetid->edge[2]=315;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=321;
 facetid->edge[1]=315;
 facetid->edge[2]=313;
 facetid->edge[3]=323;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=323;
 facetid->edge[1]=313;
 facetid->edge[2]=311;
 facetid++;

 /* 292 glove vanes */
 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=448;
 facetid->edge[1]=452;
 facetid->edge[2]=450;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=449;
 facetid->edge[1]=451;
 facetid->edge[2]=453;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=448;
 facetid->edge[1]=450;
 facetid->edge[2]=452;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=3;
 facetid->edge[0]=449;
 facetid->edge[1]=453;
 facetid->edge[2]=451;
 facetid++;

 /* 296 fin base */
 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=456;
 facetid->edge[1]=454;
 facetid->edge[2]= 89;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]= 89;
 facetid->edge[1]=454;
 facetid->edge[2]=456;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=457;
 facetid->edge[1]=455;
 facetid->edge[2]= 88;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]= 88;
 facetid->edge[1]=455;
 facetid->edge[2]=457;
 facetid++;

 /* 300 Control surfaces below */
 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=286;
 facetid->edge[1]=318;
 facetid->edge[2]=308;
 facetid->edge[3]=288;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=289;
 facetid->edge[1]=309;
 facetid->edge[2]=319;
 facetid->edge[3]=287;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=320;
 facetid->edge[1]=308;
 facetid->edge[2]=318;
 facetid->edge[3]=302;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=303;
 facetid->edge[1]=319;
 facetid->edge[2]=309;
 facetid->edge[3]=321;
 facetid++;

 /* Flaps */
 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=328;
 facetid->edge[1]=324;
 facetid->edge[2]=296;
 facetid->edge[3]=310;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=311;
 facetid->edge[1]=297;
 facetid->edge[2]=326;
 facetid->edge[3]=329;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=322;
 facetid->edge[1]=325;
 facetid->edge[2]=328;
 facetid->edge[3]=310;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=327;
 facetid->edge[1]=323;
 facetid->edge[2]=311;
 facetid->edge[3]=329;
 facetid++;

 /* Inboard flaps */
 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=330;
 facetid->edge[1]=298;
 facetid->edge[2]=324;
 facetid->edge[3]=328;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=329;
 facetid->edge[1]=326;
 facetid->edge[2]=299;
 facetid->edge[3]=331;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=325;
 facetid->edge[1]=304;
 facetid->edge[2]=330;
 facetid->edge[3]=328;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=305;
 facetid->edge[1]=327;
 facetid->edge[2]=329;
 facetid->edge[3]=331;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=6;
 facetid->edge[0]=330;
 facetid->edge[1]=332;
 facetid->edge[2]=334;
 facetid->edge[3]=338;
 facetid->edge[4]=300;
 facetid->edge[5]=298;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=6;
 facetid->edge[0]=331;
 facetid->edge[1]=299;
 facetid->edge[2]=301;
 facetid->edge[3]=340;
 facetid->edge[4]=336;
 facetid->edge[5]=333;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=6;
 facetid->edge[0]=330;
 facetid->edge[1]=304;
 facetid->edge[2]=306;
 facetid->edge[3]=339;
 facetid->edge[4]=335;
 facetid->edge[5]=332;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=6;
 facetid->edge[0]=333;
 facetid->edge[1]=337;
 facetid->edge[2]=341;
 facetid->edge[3]=307;
 facetid->edge[4]=305;
 facetid->edge[5]=331;
 facetid++;

 /* Spoilers */
 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=347;
 facetid->edge[1]=343;
 facetid->edge[2]=342;
 facetid->edge[3]=346;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=349;
 facetid->edge[1]=345;
 facetid->edge[2]=344;
 facetid->edge[3]=348;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=343;
 facetid->edge[1]=347;
 facetid->edge[2]=346;
 facetid->edge[3]=342;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=344;
 facetid->edge[1]=345;
 facetid->edge[2]=349;
 facetid->edge[3]=348;
 facetid++;

 /* Taileron */
 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=350;
 facetid->edge[1]=368;
 facetid->edge[2]=370;
 facetid->edge[3]=352;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=351;
 facetid->edge[1]=353;
 facetid->edge[2]=371;
 facetid->edge[3]=369;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=350;
 facetid->edge[1]=352;
 facetid->edge[2]=370;
 facetid->edge[3]=368;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=351;
 facetid->edge[1]=369;
 facetid->edge[2]=371;
 facetid->edge[3]=353;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=6;
 facetid->edge[0]=352;
 facetid->edge[1]=370;
 facetid->edge[2]=360;
 facetid->edge[3]=358;
 facetid->edge[4]=356;
 facetid->edge[5]=354;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=6;
 facetid->edge[0]=371;
 facetid->edge[1]=353;
 facetid->edge[2]=355;
 facetid->edge[3]=357;
 facetid->edge[4]=359;
 facetid->edge[5]=361;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=6;
 facetid->edge[0]=370;
 facetid->edge[1]=352;
 facetid->edge[2]=354;
 facetid->edge[3]=356;
 facetid->edge[4]=358;
 facetid->edge[5]=360;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=6;
 facetid->edge[0]=353;
 facetid->edge[1]=371;
 facetid->edge[2]=361;
 facetid->edge[3]=359;
 facetid->edge[4]=357;
 facetid->edge[5]=355;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=6;
 facetid->edge[0]=368;
 facetid->edge[1]=366;
 facetid->edge[2]=364;
 facetid->edge[3]=362;
 facetid->edge[4]=360;
 facetid->edge[5]=370;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=6;
 facetid->edge[0]=369;
 facetid->edge[1]=371;
 facetid->edge[2]=361;
 facetid->edge[3]=363;
 facetid->edge[4]=365;
 facetid->edge[5]=367;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=6;
 facetid->edge[0]=368;
 facetid->edge[1]=370;
 facetid->edge[2]=360;
 facetid->edge[3]=362;
 facetid->edge[4]=364;
 facetid->edge[5]=366;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=6;
 facetid->edge[0]=369;
 facetid->edge[1]=367;
 facetid->edge[2]=365;
 facetid->edge[3]=363;
 facetid->edge[4]=361;
 facetid->edge[5]=371;
 facetid++;

 /* Rudders */
 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]= 86;
 facetid->edge[1]=372;
 facetid->edge[2]= 94;
 facetid->edge[3]= 90;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]= 86;
 facetid->edge[1]= 90;
 facetid->edge[2]= 94;
 facetid->edge[3]=372;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]= 87;
 facetid->edge[1]=373;
 facetid->edge[2]= 98;
 facetid->edge[3]= 91;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]= 87;
 facetid->edge[1]= 91;
 facetid->edge[2]= 98;
 facetid->edge[3]=373;
 facetid++;

 /* Lower airbrakes */
 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=379;
 facetid->edge[1]=378;
 facetid->edge[2]=374;
 facetid->edge[3]=375;
 facetid++;

 facetid->color=RED;
 facetid->nedges=4;
 facetid->edge[0]=379;
 facetid->edge[1]=375;
 facetid->edge[2]=374;
 facetid->edge[3]=378;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=381;
 facetid->edge[1]=380;
 facetid->edge[2]=376;
 facetid->edge[3]=377;
 facetid++;

 facetid->color=RED;
 facetid->nedges=4;
 facetid->edge[0]=381;
 facetid->edge[1]=377;
 facetid->edge[2]=376;
 facetid->edge[3]=380;
 facetid++;

 /* 332 Upper air brake */
 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=387;
 facetid->edge[1]=386;
 facetid->edge[2]=389;
 facetid->edge[3]=390;
 facetid++;

 facetid->color=RED;
 facetid->nedges=4;
 facetid->edge[0]=387;
 facetid->edge[1]=390;
 facetid->edge[2]=389;
 facetid->edge[3]=386;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=7;
 facetid->edge[0]=382;
 facetid->edge[1]=384;
 facetid->edge[2]=388;
 facetid->edge[3]=392;
 facetid->edge[4]=393;
 facetid->edge[5]=389;
 facetid->edge[6]=386;
 facetid++;

 facetid->color=RED;
 facetid->nedges=7;
 facetid->edge[0]=382;
 facetid->edge[1]=386;
 facetid->edge[2]=389;
 facetid->edge[3]=393;
 facetid->edge[4]=392;
 facetid->edge[5]=388;
 facetid->edge[6]=384;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=7;
 facetid->edge[0]=383;
 facetid->edge[1]=387;
 facetid->edge[2]=390;
 facetid->edge[3]=394;
 facetid->edge[4]=395;
 facetid->edge[5]=391;
 facetid->edge[6]=385;
 facetid++;

 facetid->color=RED;
 facetid->nedges=7;
 facetid->edge[0]=383;
 facetid->edge[1]=385;
 facetid->edge[2]=391;
 facetid->edge[3]=395;
 facetid->edge[4]=394;
 facetid->edge[5]=390;
 facetid->edge[6]=387;
 facetid++;

 /* Port gear */
 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=419;
 facetid->edge[1]=417;
 facetid->edge[2]=413;
 facetid->edge[3]=415;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=419;
 facetid->edge[1]=415;
 facetid->edge[2]=413;
 facetid->edge[3]=417;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=416;
 facetid->edge[1]=418;
 facetid->edge[2]=414;
 facetid->edge[3]=412;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=416;
 facetid->edge[1]=412;
 facetid->edge[2]=414;
 facetid->edge[3]=418;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=396;
 facetid->edge[1]=397;
 facetid->edge[2]=398;
 facetid->edge[3]=399;
 facetid->edge[4]=400;
 facetid->edge[5]=401;
 facetid->edge[6]=402;
 facetid->edge[7]=403;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=396;
 facetid->edge[1]=403;
 facetid->edge[2]=402;
 facetid->edge[3]=401;
 facetid->edge[4]=400;
 facetid->edge[5]=399;
 facetid->edge[6]=398;
 facetid->edge[7]=397;
 facetid++;

 /* Stb. gear */
 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=427;
 facetid->edge[1]=425;
 facetid->edge[2]=421;
 facetid->edge[3]=423;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=427;
 facetid->edge[1]=423;
 facetid->edge[2]=421;
 facetid->edge[3]=425;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=424;
 facetid->edge[1]=426;
 facetid->edge[2]=422;
 facetid->edge[3]=420;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=424;
 facetid->edge[1]=420;
 facetid->edge[2]=422;
 facetid->edge[3]=426;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=404;
 facetid->edge[1]=405;
 facetid->edge[2]=406;
 facetid->edge[3]=407;
 facetid->edge[4]=408;
 facetid->edge[5]=409;
 facetid->edge[6]=410;
 facetid->edge[7]=411;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=404;
 facetid->edge[1]=411;
 facetid->edge[2]=410;
 facetid->edge[3]=409;
 facetid->edge[4]=408;
 facetid->edge[5]=407;
 facetid->edge[6]=406;
 facetid->edge[7]=405;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=428;
 facetid->edge[1]=429;
 facetid->edge[2]=430;
 facetid->edge[3]=431;
 facetid->edge[4]=432;
 facetid->edge[5]=433;
 facetid->edge[6]=434;
 facetid->edge[7]=435;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=428;
 facetid->edge[1]=435;
 facetid->edge[2]=434;
 facetid->edge[3]=433;
 facetid->edge[4]=432;
 facetid->edge[5]=431;
 facetid->edge[6]=430;
 facetid->edge[7]=429;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=436;
 facetid->edge[1]=437;
 facetid->edge[2]=438;
 facetid->edge[3]=439;
 facetid->edge[4]=440;
 facetid->edge[5]=441;
 facetid->edge[6]=442;
 facetid->edge[7]=443;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=436;
 facetid->edge[1]=443;
 facetid->edge[2]=442;
 facetid->edge[3]=441;
 facetid->edge[4]=440;
 facetid->edge[5]=439;
 facetid->edge[6]=438;
 facetid->edge[7]=437;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=444;
 facetid->edge[1]=445;
 facetid->edge[2]=446;
 facetid->edge[3]=447;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=444;
 facetid->edge[1]=447;
 facetid->edge[2]=446;
 facetid->edge[3]=445;
 facetid++;

 if (object[id].facet+nfacets!=facetid)
 {
   printf("F14: Incorrect number of facets\n");
   exit(1);
 }

 /*
 facetid->color=;
 facetid->nedges=;
 facetid->edge[0]=;
 facetid->edge[1]=;
 facetid->edge[2]=;
 facetid->edge[3]=;
 facetid++;
 */

 /* Define control surface rotation axis */
 object[id].ctrl_surface[0].axis =
   vminus(*(object[id].vertex+308),*(object[id].vertex+318));
 object[id].ctrl_surface[1].axis =
   vminus(*(object[id].vertex+319),*(object[id].vertex+309));
 object[id].ctrl_surface[2].axis =
   vminus(*(object[id].vertex+322),*(object[id].vertex+325));
 object[id].ctrl_surface[3].axis =
   vminus(*(object[id].vertex+327),*(object[id].vertex+323));
 object[id].ctrl_surface[4].axis =
   vminus(*(object[id].vertex+322),*(object[id].vertex+325));
 object[id].ctrl_surface[5].axis =
   vminus(*(object[id].vertex+327),*(object[id].vertex+323));
 object[id].ctrl_surface[6].axis =
   vminus(*(object[id].vertex+342),*(object[id].vertex+343));
 object[id].ctrl_surface[7].axis =
   vminus(*(object[id].vertex+344),*(object[id].vertex+345));
 object[id].ctrl_surface[8].axis =
   vminus(*(object[id].vertex+354),*(object[id].vertex+355));
 object[id].ctrl_surface[9].axis =
   vminus(*(object[id].vertex+354),*(object[id].vertex+355));
 object[id].ctrl_surface[10].axis =
   vminus(*(object[id].vertex+86),*(object[id].vertex+90));
 object[id].ctrl_surface[11].axis =
   vminus(*(object[id].vertex+87),*(object[id].vertex+91));
 object[id].ctrl_surface[12].axis =
   vminus(*(object[id].vertex+374),*(object[id].vertex+377));
 object[id].ctrl_surface[13].axis =
   vminus(*(object[id].vertex+382),*(object[id].vertex+383));
 object[id].ctrl_surface[14].axis =
   vminus(*(object[id].vertex+418),*(object[id].vertex+424));
 object[id].ctrl_surface[15].axis =
   vminus(*(object[id].vertex+418),*(object[id].vertex+424));
 object[id].ctrl_surface[16].axis =
   vminus(*(object[id].vertex+418),*(object[id].vertex+424));

 for (j=0; j<object[id].nctrl_srf; j++){
  float norm;
  cartvektor tmp, tmp2;

  /* Generate orthonormal-system */
  norm=sqrt(VPRIK(object[id].ctrl_surface[j].axis,
                  object[id].ctrl_surface[j].axis));
  object[id].ctrl_surface[j].front=
                  svmult(1./norm,object[id].ctrl_surface[j].axis);
  /* Rotate 90 deg about z */
  tmp.x = -object[id].ctrl_surface[j].front.y;
  tmp.y =  object[id].ctrl_surface[j].front.x;
  tmp.z =  object[id].ctrl_surface[j].front.z;

  /* Rotate 90 deg about x - then the vector is not parallel with front vector */
  tmp2.x =  tmp.x;
  tmp2.y = -tmp.z;
  tmp2.z =  tmp.y;

  object[id].ctrl_surface[j].left =
   vkryds(object[id].ctrl_surface[j].front,tmp2);
  norm=sqrt(VPRIK(object[id].ctrl_surface[j].left,
                  object[id].ctrl_surface[j].left));
  object[id].ctrl_surface[j].left=
                  svmult(1./norm,object[id].ctrl_surface[j].left);

  object[id].ctrl_surface[j].top =
   vkryds(object[id].ctrl_surface[j].front,object[id].ctrl_surface[j].left);
 }

  object[id].colarr[WHITE].r = 255;
 object[id].colarr[WHITE].g = 255;
 object[id].colarr[WHITE].b = 255;

 object[id].colarr[LIGHTGRAY].r = 192;
 object[id].colarr[LIGHTGRAY].g = 192;
 object[id].colarr[LIGHTGRAY].b = 192;

 object[id].colarr[DARKGRAY].r =  80;
 object[id].colarr[DARKGRAY].g =  80;
 object[id].colarr[DARKGRAY].b =  80;

 object[id].colarr[RED].r = 255;
 object[id].colarr[RED].g =  32;
 object[id].colarr[RED].b =  32;

 object[id].colarr[GREEN].r =  32;
 object[id].colarr[GREEN].g = 255;
 object[id].colarr[GREEN].b =  32;

 object[id].colarr[BLUE].r =  32;
 object[id].colarr[BLUE].g =  32;
 object[id].colarr[BLUE].b = 255;

 object[id].colarr[LIGHTRED].r = 255;
 object[id].colarr[LIGHTRED].g =  96;
 object[id].colarr[LIGHTRED].b =  96;

 object[id].colarr[LIGHTBLUE].r = 96;
 object[id].colarr[LIGHTBLUE].g = 96;
 object[id].colarr[LIGHTBLUE].b = 255;

 object[id].colarr[CYAN].r =  96;
 object[id].colarr[CYAN].g = 192;
 object[id].colarr[CYAN].b = 192;

 object[id].colarr[LIGHTCYAN].r =  64;
 object[id].colarr[LIGHTCYAN].g = 255;
 object[id].colarr[LIGHTCYAN].b = 255;

 object[id].colarr[DARKGREEN].r =  50;
 object[id].colarr[DARKGREEN].g = 100;
 object[id].colarr[DARKGREEN].b =  40;

 nobjects++;
