

 id=HARRIER;
 object[id].max_draw_dist=5000;
 object[id].always_draw_dist=50;

 object[id].nvertices = 172;
 object[id].nfacets   =  88; /* Excluding control surface polys */
 object[id].nctrl_srf =  11;

 object[id].ctrl_surface[0].hinge.x      =  -5.18;
 object[id].ctrl_surface[0].hinge.y      =   0;
 object[id].ctrl_surface[0].hinge.z      =   0.47;
 object[id].ctrl_surface[0].rudder_gain  =   0;
 object[id].ctrl_surface[0].aileron_gain =   0;
 object[id].ctrl_surface[0].elevator_gain=   1;
 object[id].ctrl_surface[0].flap_gain    =   0;
 object[id].ctrl_surface[0].brake_gain   =   0;
 object[id].ctrl_surface[0].gear_gain    =   0;
 object[id].ctrl_surface[0].gear_id      =  -1;
 object[id].ctrl_surface[0].nctrlpoly    =   4;
 object[id].ctrl_surface[0].poly_id[0]   =  88;
 object[id].ctrl_surface[0].poly_id[1]   =  89;
 object[id].ctrl_surface[0].poly_id[2]   =  90;
 object[id].ctrl_surface[0].poly_id[3]   =  91;

 object[id].ctrl_surface[1].hinge.x      =  -5.68;
 object[id].ctrl_surface[1].hinge.y      =   0;
 object[id].ctrl_surface[1].hinge.z      =   0.57;
 object[id].ctrl_surface[1].rudder_gain  =   1;
 object[id].ctrl_surface[1].aileron_gain =   0;
 object[id].ctrl_surface[1].elevator_gain=   0;
 object[id].ctrl_surface[1].flap_gain    =   0;
 object[id].ctrl_surface[1].brake_gain   =   0;
 object[id].ctrl_surface[1].gear_gain    =   0;
 object[id].ctrl_surface[1].gear_id      =  -1;
 object[id].ctrl_surface[1].nctrlpoly    =   2;
 object[id].ctrl_surface[1].poly_id[0]   =  92;
 object[id].ctrl_surface[1].poly_id[1]   =  93;

 object[id].ctrl_surface[2].hinge.x      =  -1.767;
 object[id].ctrl_surface[2].hinge.y      =   1.90;
 object[id].ctrl_surface[2].hinge.z      =   0.067;
 object[id].ctrl_surface[2].rudder_gain  =   0;
 object[id].ctrl_surface[2].aileron_gain =   0;
 object[id].ctrl_surface[2].elevator_gain=   0;
 object[id].ctrl_surface[2].flap_gain    =   1.5;
 object[id].ctrl_surface[2].brake_gain   =   0;
 object[id].ctrl_surface[2].gear_gain    =   0;
 object[id].ctrl_surface[2].gear_id      =  -1;
 object[id].ctrl_surface[2].nctrlpoly    =   2;
 object[id].ctrl_surface[2].poly_id[0]   =  94;
 object[id].ctrl_surface[2].poly_id[1]   =  95;

 object[id].ctrl_surface[3].hinge.x      =  -1.767;
 object[id].ctrl_surface[3].hinge.y      =  -1.90;
 object[id].ctrl_surface[3].hinge.z      =   0.067;
 object[id].ctrl_surface[3].rudder_gain  =   0;
 object[id].ctrl_surface[3].aileron_gain =   0;
 object[id].ctrl_surface[3].elevator_gain=   0;
 object[id].ctrl_surface[3].flap_gain    =   1.5;
 object[id].ctrl_surface[3].brake_gain   =   0;
 object[id].ctrl_surface[3].gear_gain    =   0;
 object[id].ctrl_surface[3].gear_id      =  -1;
 object[id].ctrl_surface[3].nctrlpoly    =   2;
 object[id].ctrl_surface[3].poly_id[0]   =  96;
 object[id].ctrl_surface[3].poly_id[1]   =  97;

 object[id].ctrl_surface[4].hinge.x      =  -1.767;
 object[id].ctrl_surface[4].hinge.y      =   1.90;
 object[id].ctrl_surface[4].hinge.z      =   0.067;
 object[id].ctrl_surface[4].rudder_gain  =   0;
 object[id].ctrl_surface[4].aileron_gain =   1;
 object[id].ctrl_surface[4].elevator_gain=   0;
 object[id].ctrl_surface[4].flap_gain    =   0;
 object[id].ctrl_surface[4].brake_gain   =   0;
 object[id].ctrl_surface[4].gear_gain    =   0;
 object[id].ctrl_surface[4].gear_id      =  -1;
 object[id].ctrl_surface[4].nctrlpoly    =   2;
 object[id].ctrl_surface[4].poly_id[0]   =  98;
 object[id].ctrl_surface[4].poly_id[1]   =  99;

 object[id].ctrl_surface[5].hinge.x      =  -1.767;
 object[id].ctrl_surface[5].hinge.y      =  -1.90;
 object[id].ctrl_surface[5].hinge.z      =   0.067;
 object[id].ctrl_surface[5].rudder_gain  =   0;
 object[id].ctrl_surface[5].aileron_gain =  -1;
 object[id].ctrl_surface[5].elevator_gain=   0;
 object[id].ctrl_surface[5].flap_gain    =   0;
 object[id].ctrl_surface[5].brake_gain   =   0;
 object[id].ctrl_surface[5].gear_gain    =   0;
 object[id].ctrl_surface[5].gear_id      =  -1;
 object[id].ctrl_surface[5].nctrlpoly    =   2;
 object[id].ctrl_surface[5].poly_id[0]   = 100;
 object[id].ctrl_surface[5].poly_id[1]   = 101;

 object[id].ctrl_surface[6].hinge.x      =  -2.36;
 object[id].ctrl_surface[6].hinge.y      =   0.00;
 object[id].ctrl_surface[6].hinge.z      =  -0.57;
 object[id].ctrl_surface[6].rudder_gain  =   0;
 object[id].ctrl_surface[6].aileron_gain =   0;
 object[id].ctrl_surface[6].elevator_gain=   0;
 object[id].ctrl_surface[6].flap_gain    =   0;
 object[id].ctrl_surface[6].brake_gain   =  35;
 object[id].ctrl_surface[6].gear_gain    =   0;
 object[id].ctrl_surface[6].gear_id      =  -1;
 object[id].ctrl_surface[6].nctrlpoly    =   2;
 object[id].ctrl_surface[6].poly_id[0]   = 102;
 object[id].ctrl_surface[6].poly_id[1]   = 103;

 object[id].ctrl_surface[7].hinge.x      =   2.60;
 object[id].ctrl_surface[7].hinge.y      =   0.00;
 object[id].ctrl_surface[7].hinge.z      =  -0.50;
 object[id].ctrl_surface[7].rudder_gain  =   0;
 object[id].ctrl_surface[7].aileron_gain =   0;
 object[id].ctrl_surface[7].elevator_gain=   0;
 object[id].ctrl_surface[7].flap_gain    =   0;
 object[id].ctrl_surface[7].brake_gain   =   0;
 object[id].ctrl_surface[7].gear_gain    = 135;
 object[id].ctrl_surface[7].gear_id      =   0;
 object[id].ctrl_surface[7].nctrlpoly    =   4;
 object[id].ctrl_surface[7].poly_id[0]   = 104;
 object[id].ctrl_surface[7].poly_id[1]   = 105;
 object[id].ctrl_surface[7].poly_id[2]   = 106;
 object[id].ctrl_surface[7].poly_id[3]   = 107;

 object[id].ctrl_surface[8].hinge.x      =  -1.45;
 object[id].ctrl_surface[8].hinge.y      =   0.00;
 object[id].ctrl_surface[8].hinge.z      =  -0.50;
 object[id].ctrl_surface[8].rudder_gain  =   0;
 object[id].ctrl_surface[8].aileron_gain =   0;
 object[id].ctrl_surface[8].elevator_gain=   0;
 object[id].ctrl_surface[8].flap_gain    =   0;
 object[id].ctrl_surface[8].brake_gain   =   0;
 object[id].ctrl_surface[8].gear_gain    =  90;
 object[id].ctrl_surface[8].gear_id      =   1;
 object[id].ctrl_surface[8].nctrlpoly    =   4;
 object[id].ctrl_surface[8].poly_id[0]   = 108;
 object[id].ctrl_surface[8].poly_id[1]   = 109;
 object[id].ctrl_surface[8].poly_id[2]   = 110;
 object[id].ctrl_surface[8].poly_id[3]   = 111;

 object[id].ctrl_surface[9].hinge.x      =  -1.95;
 object[id].ctrl_surface[9].hinge.y      =   3.5;
 object[id].ctrl_surface[9].hinge.z      =  -0.30;
 object[id].ctrl_surface[9].rudder_gain  =   0;
 object[id].ctrl_surface[9].aileron_gain =   0;
 object[id].ctrl_surface[9].elevator_gain=   0;
 object[id].ctrl_surface[9].flap_gain    =   0;
 object[id].ctrl_surface[9].brake_gain   =   0;
 object[id].ctrl_surface[9].gear_gain    =  90;
 object[id].ctrl_surface[9].gear_id      =   2;
 object[id].ctrl_surface[9].nctrlpoly    =   4;
 object[id].ctrl_surface[9].poly_id[0]   = 112;
 object[id].ctrl_surface[9].poly_id[1]   = 113;
 object[id].ctrl_surface[9].poly_id[2]   = 114;
 object[id].ctrl_surface[9].poly_id[3]   = 115;

 object[id].ctrl_surface[10].hinge.x      =  -1.95;
 object[id].ctrl_surface[10].hinge.y      =  -3.5;
 object[id].ctrl_surface[10].hinge.z      =  -0.30;
 object[id].ctrl_surface[10].rudder_gain  =   0;
 object[id].ctrl_surface[10].aileron_gain =   0;
 object[id].ctrl_surface[10].elevator_gain=   0;
 object[id].ctrl_surface[10].flap_gain    =   0;
 object[id].ctrl_surface[10].brake_gain   =   0;
 object[id].ctrl_surface[10].gear_gain    =  90;
 object[id].ctrl_surface[10].gear_id      =   3;
 object[id].ctrl_surface[10].nctrlpoly    =   4;
 object[id].ctrl_surface[10].poly_id[0]   = 116;
 object[id].ctrl_surface[10].poly_id[1]   = 117;
 object[id].ctrl_surface[10].poly_id[2]   = 118;
 object[id].ctrl_surface[10].poly_id[3]   = 119;


 nfacets=object[id].nfacets;
 for (j=0; j<object[id].nctrl_srf; j++) nfacets+=object[id].ctrl_surface[j].nctrlpoly;

 if ((object[id].vertex = malloc(object[id].nvertices*sizeof(cartvektor))) == NULL)
 {
   printf("Not enough memory\n");
   exit(1);
 }

 if ((object[id].facet = malloc(nfacets*sizeof(polygon_struct))) == NULL)
 {
   printf("Not enough memory\n");
   exit(1);
 }
 facetid=object[id].facet;



 /* Port wing */
 (object[id].vertex+0)->x= 1.09;
 (object[id].vertex+0)->y= 0.72;
 (object[id].vertex+0)->z= 0.53;

 (object[id].vertex+1)->x=-1.15;
 (object[id].vertex+1)->y= 3.36;
 (object[id].vertex+1)->z=-0.23;

 (object[id].vertex+2)->x=-1.45;
 (object[id].vertex+2)->y= 3.60;
 (object[id].vertex+2)->z=-0.305;

 (object[id].vertex+3)->x=-1.73;
 (object[id].vertex+3)->y= 3.80;
 (object[id].vertex+3)->z=-0.38;

 (object[id].vertex+4)->x=-2.02;
 (object[id].vertex+4)->y= 3.87;
 (object[id].vertex+4)->z=-0.43;

 (object[id].vertex+5)->x=-2.64;
 (object[id].vertex+5)->y= 3.89;
 (object[id].vertex+5)->z=-0.43;

 (object[id].vertex+6)->x=-1.92;
 (object[id].vertex+6)->y= 0.50;
 (object[id].vertex+6)->z= 0.38;

 /* Starboard wing */
 (object[id].vertex+7)->x= 1.09;
 (object[id].vertex+7)->y=-0.72;
 (object[id].vertex+7)->z= 0.53;

 (object[id].vertex+8)->x=-1.15;
 (object[id].vertex+8)->y=-3.36;
 (object[id].vertex+8)->z=-0.23;

 (object[id].vertex+9)->x=-1.45;
 (object[id].vertex+9)->y=-3.60;
 (object[id].vertex+9)->z=-0.305;

 (object[id].vertex+10)->x=-1.73;
 (object[id].vertex+10)->y=-3.80;
 (object[id].vertex+10)->z=-0.38;

 (object[id].vertex+11)->x=-2.02;
 (object[id].vertex+11)->y=-3.87;
 (object[id].vertex+11)->z=-0.43;

 (object[id].vertex+12)->x=-2.64;
 (object[id].vertex+12)->y=-3.89;
 (object[id].vertex+12)->z=-0.43;

 (object[id].vertex+13)->x=-1.92;
 (object[id].vertex+13)->y=-0.50;
 (object[id].vertex+13)->z= 0.38;

 /* Nose */
 (object[id].vertex+14)->x= 6.82;
 (object[id].vertex+14)->y= 0;
 (object[id].vertex+14)->z=-0.10;

 (object[id].vertex+15)->x= 5.85;
 (object[id].vertex+15)->y=-0.13;
 (object[id].vertex+15)->z= 0.28;

 (object[id].vertex+16)->x= 5.85;
 (object[id].vertex+16)->y= 0.13;
 (object[id].vertex+16)->z= 0.28;

 (object[id].vertex+17)->x= 5.85;
 (object[id].vertex+17)->y= 0.31;
 (object[id].vertex+17)->z= 0.10;

 (object[id].vertex+18)->x= 5.85;
 (object[id].vertex+18)->y= 0.31;
 (object[id].vertex+18)->z=-0.16;

 (object[id].vertex+19)->x= 5.85;
 (object[id].vertex+19)->y= 0.13;
 (object[id].vertex+19)->z=-0.34;

 (object[id].vertex+20)->x= 5.85;
 (object[id].vertex+20)->y=-0.13;
 (object[id].vertex+20)->z=-0.34;

 (object[id].vertex+21)->x= 5.85;
 (object[id].vertex+21)->y=-0.31;
 (object[id].vertex+21)->z=-0.16;

 (object[id].vertex+22)->x= 5.85;
 (object[id].vertex+22)->y=-0.31;
 (object[id].vertex+22)->z= 0.10;

 (object[id].vertex+23)->x= 3.43;
 (object[id].vertex+23)->y=-0.36;
 (object[id].vertex+23)->z= 0.60;

 (object[id].vertex+24)->x= 3.43;
 (object[id].vertex+24)->y= 0.36;
 (object[id].vertex+24)->z= 0.60;

 (object[id].vertex+25)->x= 3.31;
 (object[id].vertex+25)->y= 0.36;
 (object[id].vertex+25)->z=-0.48;

 (object[id].vertex+26)->x= 3.31;
 (object[id].vertex+26)->y=-0.36;
 (object[id].vertex+26)->z=-0.48;

 (object[id].vertex+27)->x= 2.59;
 (object[id].vertex+27)->y= 0.28;
 (object[id].vertex+27)->z= 0.80;

 (object[id].vertex+28)->x= 2.59;
 (object[id].vertex+28)->y=-0.28;
 (object[id].vertex+28)->z= 0.80;

 (object[id].vertex+29)->x=-6.82;
 (object[id].vertex+29)->y= 0.14;
 (object[id].vertex+29)->z= 0.53;

 (object[id].vertex+30)->x=-6.82;
 (object[id].vertex+30)->y=-0.14;
 (object[id].vertex+30)->z= 0.53;

 /* Tail fin */
 (object[id].vertex+31)->x=-6.05;
 (object[id].vertex+31)->y= 0.00;
 (object[id].vertex+31)->z= 0.57;

 (object[id].vertex+32)->x=-6.34;
 (object[id].vertex+32)->y= 0.00;
 (object[id].vertex+32)->z= 2.45;

 (object[id].vertex+33)->x=-6.10;
 (object[id].vertex+33)->y= 0.00;
 (object[id].vertex+33)->z= 2.45;

 (object[id].vertex+34)->x=-5.67;
 (object[id].vertex+34)->y= 0.00;
 (object[id].vertex+34)->z= 2.26;

 (object[id].vertex+35)->x=-4.42;
 (object[id].vertex+35)->y= 0.00;
 (object[id].vertex+35)->z= 1.06;

 (object[id].vertex+36)->x=-3.84;
 (object[id].vertex+36)->y= 0.00;
 (object[id].vertex+36)->z= 0.86;

 (object[id].vertex+37)->x=-3.24;
 (object[id].vertex+37)->y= 0.00;
 (object[id].vertex+37)->z= 0.74;

 (object[id].vertex+38)->x=-3.24;
 (object[id].vertex+38)->y= 0.00;
 (object[id].vertex+38)->z= 0.60;

 /* Air intake */
 (object[id].vertex+39)->x= 3.42;
 (object[id].vertex+39)->y= 0.74;
 (object[id].vertex+39)->z= 0.48;

 (object[id].vertex+40)->x= 3.39;
 (object[id].vertex+40)->y= 0.89;
 (object[id].vertex+40)->z= 0.22;

 (object[id].vertex+41)->x= 3.35;
 (object[id].vertex+41)->y= 0.89;
 (object[id].vertex+41)->z=-0.10;

 (object[id].vertex+42)->x= 3.32;
 (object[id].vertex+42)->y= 0.72;
 (object[id].vertex+42)->z=-0.41;

 (object[id].vertex+43)->x= 3.42;
 (object[id].vertex+43)->y=-0.74;
 (object[id].vertex+43)->z= 0.48;

 (object[id].vertex+44)->x= 3.39;
 (object[id].vertex+44)->y=-0.89;
 (object[id].vertex+44)->z= 0.22;

 (object[id].vertex+45)->x= 3.35;
 (object[id].vertex+45)->y=-0.89;
 (object[id].vertex+45)->z=-0.10;

 (object[id].vertex+46)->x= 3.32;
 (object[id].vertex+46)->y=-0.72;
 (object[id].vertex+46)->z=-0.41;

 /* Rear body spar */
 (object[id].vertex+47)->x=-2.16;
 (object[id].vertex+47)->y= 0.26;
 (object[id].vertex+47)->z= 0.63;

 (object[id].vertex+48)->x=-2.16;
 (object[id].vertex+48)->y=-0.26;
 (object[id].vertex+48)->z= 0.63;

 (object[id].vertex+49)->x=-2.16;
 (object[id].vertex+49)->y=-0.65;
 (object[id].vertex+49)->z= 0.36;

 (object[id].vertex+50)->x=-2.16;
 (object[id].vertex+50)->y=-0.56;
 (object[id].vertex+50)->z=-0.41;

 (object[id].vertex+51)->x=-2.16;
 (object[id].vertex+51)->y=-0.34;
 (object[id].vertex+51)->z=-0.59;

 (object[id].vertex+52)->x=-2.16;
 (object[id].vertex+52)->y= 0.34;
 (object[id].vertex+52)->z=-0.59;

 (object[id].vertex+53)->x=-2.16;
 (object[id].vertex+53)->y= 0.56;
 (object[id].vertex+53)->z=-0.41;

 (object[id].vertex+54)->x=-2.16;
 (object[id].vertex+54)->y= 0.65;
 (object[id].vertex+54)->z= 0.36;

 (object[id].vertex+55)->x=-6.00;
 (object[id].vertex+55)->y= 0.00;
 (object[id].vertex+55)->z= 0.25;

 /* Belly fin */
 (object[id].vertex+56)->x=-5.93;
 (object[id].vertex+56)->y= 0.00;
 (object[id].vertex+56)->z=-0.19;

 (object[id].vertex+57)->x=-5.85;
 (object[id].vertex+57)->y= 0.00;
 (object[id].vertex+57)->z=-0.70;

 (object[id].vertex+58)->x=-3.84;
 (object[id].vertex+58)->y= 0.00;
 (object[id].vertex+58)->z=-0.45;

 (object[id].vertex+59)->x=-6.82;
 (object[id].vertex+59)->y= 0.14;
 (object[id].vertex+59)->z= 0.19;

 (object[id].vertex+60)->x=-6.82;
 (object[id].vertex+60)->y=-0.14;
 (object[id].vertex+60)->z= 0.19;

 (object[id].vertex+61)->x=-2.16;
 (object[id].vertex+61)->y= 0.26;
 (object[id].vertex+61)->z= 0.29;

 (object[id].vertex+62)->x=-2.16;
 (object[id].vertex+62)->y=-0.26;
 (object[id].vertex+62)->z= 0.29;

 /* port tail plane */
 (object[id].vertex+63)->x=-6.41;
 (object[id].vertex+63)->y= 2.15;
 (object[id].vertex+63)->z=-0.07;

 (object[id].vertex+64)->x=-6.02;
 (object[id].vertex+64)->y= 0.14;
 (object[id].vertex+64)->z= 0.47;

 (object[id].vertex+65)->x=-4.46;
 (object[id].vertex+65)->y= 0.14;
 (object[id].vertex+65)->z= 0.47;

 (object[id].vertex+66)->x=-5.64;
 (object[id].vertex+66)->y= 1.54;
 (object[id].vertex+66)->z= 0.09;

 (object[id].vertex+67)->x=-6.00;
 (object[id].vertex+67)->y= 2.10;
 (object[id].vertex+67)->z=-0.06;

 /* stb. tail plane */
 (object[id].vertex+68)->x=-6.41;
 (object[id].vertex+68)->y=-2.15;
 (object[id].vertex+68)->z=-0.07;

 (object[id].vertex+69)->x=-6.02;
 (object[id].vertex+69)->y=-0.14;
 (object[id].vertex+69)->z= 0.47;

 (object[id].vertex+70)->x=-4.46;
 (object[id].vertex+70)->y=-0.14;
 (object[id].vertex+70)->z= 0.47;

 (object[id].vertex+71)->x=-5.64;
 (object[id].vertex+71)->y=-1.54;
 (object[id].vertex+71)->z= 0.09;

 (object[id].vertex+72)->x=-6.00;
 (object[id].vertex+72)->y=-2.10;
 (object[id].vertex+72)->z=-0.06;

 /* port cold jet */
 (object[id].vertex+73)->x= 1.11;
 (object[id].vertex+73)->y= 1.18;
 (object[id].vertex+73)->z= 0.24;

 (object[id].vertex+74)->x= 1.11;
 (object[id].vertex+74)->y= 1.18;
 (object[id].vertex+74)->z=-0.24;

 (object[id].vertex+75)->x= 0.63;
 (object[id].vertex+75)->y= 0.90;
 (object[id].vertex+75)->z= 0.24;

 (object[id].vertex+76)->x= 0.63;
 (object[id].vertex+76)->y= 0.90;
 (object[id].vertex+76)->z=-0.24;

 /* stb. cold jet */
 (object[id].vertex+77)->x= 1.11;
 (object[id].vertex+77)->y=-1.18;
 (object[id].vertex+77)->z= 0.24;

 (object[id].vertex+78)->x= 1.11;
 (object[id].vertex+78)->y=-1.18;
 (object[id].vertex+78)->z=-0.24;

 (object[id].vertex+79)->x= 0.63;
 (object[id].vertex+79)->y=-0.90;
 (object[id].vertex+79)->z= 0.24;

 (object[id].vertex+80)->x= 0.63;
 (object[id].vertex+80)->y=-0.90;
 (object[id].vertex+80)->z=-0.24;

 /* port hot jet */
 (object[id].vertex+81)->x=-0.76;
 (object[id].vertex+81)->y= 0.98;
 (object[id].vertex+81)->z= 0.12;

 (object[id].vertex+82)->x=-0.76;
 (object[id].vertex+82)->y= 0.98;
 (object[id].vertex+82)->z=-0.47;

 (object[id].vertex+83)->x=-1.33;
 (object[id].vertex+83)->y= 0.66;
 (object[id].vertex+83)->z= 0.12;

 (object[id].vertex+84)->x=-1.33;
 (object[id].vertex+84)->y= 0.66;
 (object[id].vertex+84)->z=-0.47;

 /* stb. hot jet */
 (object[id].vertex+85)->x=-0.76;
 (object[id].vertex+85)->y=-0.98;
 (object[id].vertex+85)->z= 0.12;

 (object[id].vertex+86)->x=-0.76;
 (object[id].vertex+86)->y=-0.98;
 (object[id].vertex+86)->z=-0.47;

 (object[id].vertex+87)->x=-1.33;
 (object[id].vertex+87)->y=-0.66;
 (object[id].vertex+87)->z= 0.12;

 (object[id].vertex+88)->x=-1.33;
 (object[id].vertex+88)->y=-0.66;
 (object[id].vertex+88)->z=-0.47;

 /* canopy */
 (object[id].vertex+89)->x= 4.99;
 (object[id].vertex+89)->y= 0.14;
 (object[id].vertex+89)->z= 0.55;

 (object[id].vertex+90)->x= 4.99;
 (object[id].vertex+90)->y=-0.14;
 (object[id].vertex+90)->z= 0.55;

 (object[id].vertex+91)->x= 4.06;
 (object[id].vertex+91)->y= 0.37;
 (object[id].vertex+91)->z= 0.55;

 (object[id].vertex+92)->x= 4.06;
 (object[id].vertex+92)->y=-0.37;
 (object[id].vertex+92)->z= 0.55;

 (object[id].vertex+93)->x= 4.27;
 (object[id].vertex+93)->y= 0.14;
 (object[id].vertex+93)->z= 1.02;

 (object[id].vertex+94)->x= 4.27;
 (object[id].vertex+94)->y=-0.14;
 (object[id].vertex+94)->z= 1.02;

 /* gun pods */
 (object[id].vertex+95)->x= 1.82;
 (object[id].vertex+95)->y= 0.51;
 (object[id].vertex+95)->z=-0.47;

 (object[id].vertex+96)->x= 1.82;
 (object[id].vertex+96)->y= 0.51;
 (object[id].vertex+96)->z=-0.73;

 (object[id].vertex+97)->x= 0.24;
 (object[id].vertex+97)->y= 0.51;
 (object[id].vertex+97)->z=-1.05;

 (object[id].vertex+98)->x=-1.43;
 (object[id].vertex+98)->y= 0.51;
 (object[id].vertex+98)->z=-0.75;

 (object[id].vertex+99)->x=-1.43;
 (object[id].vertex+99)->y= 0.51;
 (object[id].vertex+99)->z=-0.62;

 (object[id].vertex+100)->x= 1.82;
 (object[id].vertex+100)->y=-0.51;
 (object[id].vertex+100)->z=-0.47;

 (object[id].vertex+101)->x= 1.82;
 (object[id].vertex+101)->y=-0.51;
 (object[id].vertex+101)->z=-0.73;

 (object[id].vertex+102)->x= 0.24;
 (object[id].vertex+102)->y=-0.51;
 (object[id].vertex+102)->z=-1.05;

 (object[id].vertex+103)->x=-1.43;
 (object[id].vertex+103)->y=-0.51;
 (object[id].vertex+103)->z=-0.75;

 (object[id].vertex+104)->x=-1.43;
 (object[id].vertex+104)->y=-0.51;
 (object[id].vertex+104)->z=-0.62;

 /* Rudder */
 (object[id].vertex+105)->x=-5.68;
 (object[id].vertex+105)->y= 0.00;
 (object[id].vertex+105)->z= 0.57;

 (object[id].vertex+106)->x=-6.05;
 (object[id].vertex+106)->y= 0.00;
 (object[id].vertex+106)->z= 2.14;

 (object[id].vertex+107)->x=-6.292;
 (object[id].vertex+107)->y= 0.00;
 (object[id].vertex+107)->z= 2.14;

 /* port aileron/flap */
 (object[id].vertex+108)->x=-2.516;
 (object[id].vertex+108)->y= 3.31;
 (object[id].vertex+108)->z=-0.292;

 (object[id].vertex+109)->x=-2.217;
 (object[id].vertex+109)->y= 1.90;
 (object[id].vertex+109)->z= 0.045;

 (object[id].vertex+110)->x=-1.982;
 (object[id].vertex+110)->y= 0.79;
 (object[id].vertex+110)->z= 0.311;

 (object[id].vertex+111)->x=-2.066;
 (object[id].vertex+111)->y= 3.31;
 (object[id].vertex+111)->z=-0.270;

 (object[id].vertex+112)->x=-1.767;
 (object[id].vertex+112)->y= 1.90;
 (object[id].vertex+112)->z= 0.067;

 (object[id].vertex+113)->x=-1.532;
 (object[id].vertex+113)->y= 0.79;
 (object[id].vertex+113)->z= 0.333;

 /* stb aileron/flap */
 (object[id].vertex+114)->x=-2.516;
 (object[id].vertex+114)->y=-3.31;
 (object[id].vertex+114)->z=-0.292;

 (object[id].vertex+115)->x=-2.217;
 (object[id].vertex+115)->y=-1.90;
 (object[id].vertex+115)->z= 0.045;

 (object[id].vertex+116)->x=-1.982;
 (object[id].vertex+116)->y=-0.79;
 (object[id].vertex+116)->z= 0.311;

 (object[id].vertex+117)->x=-2.066;
 (object[id].vertex+117)->y=-3.31;
 (object[id].vertex+117)->z=-0.270;

 (object[id].vertex+118)->x=-1.767;
 (object[id].vertex+118)->y=-1.90;
 (object[id].vertex+118)->z= 0.067;

 (object[id].vertex+119)->x=-1.532;
 (object[id].vertex+119)->y=-0.79;
 (object[id].vertex+119)->z= 0.333;

 /* Air brake */
 (object[id].vertex+120)->x=-2.59;
 (object[id].vertex+120)->y= 0.25;
 (object[id].vertex+120)->z=-0.544;

 (object[id].vertex+121)->x=-2.59;
 (object[id].vertex+121)->y=-0.25;
 (object[id].vertex+121)->z=-0.544;

 (object[id].vertex+122)->x=-3.12;
 (object[id].vertex+122)->y=-0.30;
 (object[id].vertex+122)->z=-0.488;

 (object[id].vertex+123)->x=-3.12;
 (object[id].vertex+123)->y= 0.30;
 (object[id].vertex+123)->z=-0.488;

 /* Nose wheel */
 for (i=0; i<8; i++){
  float xc=2.24 , yc= 0.00, zc=-1.33, radius=0.34;

  (object[id].vertex+124+i)->x=xc+radius*sin(i*PI/4+PI/8);
  (object[id].vertex+124+i)->y=yc;
  (object[id].vertex+124+i)->z=zc+radius*cos(i*PI/4+PI/8);
 }

 (object[id].vertex+132)->x= 2.65;
 (object[id].vertex+132)->y= 0.00;
 (object[id].vertex+132)->z=-0.50;

 (object[id].vertex+133)->x= 2.55;
 (object[id].vertex+133)->y= 0.00;
 (object[id].vertex+133)->z=-0.50;

 (object[id].vertex+134)->x= 2.55;
 (object[id].vertex+134)->y= 0.00;
 (object[id].vertex+134)->z=-1.25;

 (object[id].vertex+135)->x= 2.65;
 (object[id].vertex+135)->y= 0.00;
 (object[id].vertex+135)->z=-1.20;

 /* Main gear */
 for (i=0; i<8; i++){
  float xc=-1.45 , yc= 0.00, zc=-1.08, radius=0.35;

  (object[id].vertex+136+i)->x=xc+radius*sin(i*PI/4+PI/8);
  (object[id].vertex+136+i)->y=yc;
  (object[id].vertex+136+i)->z=zc+radius*cos(i*PI/4+PI/8);
 }

 (object[id].vertex+144)->x=-1.40;
 (object[id].vertex+144)->y= 0.00;
 (object[id].vertex+144)->z=-0.60;

 (object[id].vertex+145)->x=-1.50;
 (object[id].vertex+145)->y= 0.00;
 (object[id].vertex+145)->z=-0.60;

 (object[id].vertex+146)->x=-1.50;
 (object[id].vertex+146)->y= 0.00;
 (object[id].vertex+146)->z=-0.73;

 (object[id].vertex+147)->x=-1.40;
 (object[id].vertex+147)->y= 0.00;
 (object[id].vertex+147)->z=-0.73;

 /* Port strut */
 for (i=0; i<8; i++){
  float xc=-1.95 , yc= 3.50, zc=-1.40, radius=0.17;

  (object[id].vertex+148+i)->x=xc+radius*sin(i*PI/4+PI/8);
  (object[id].vertex+148+i)->y=yc;
  (object[id].vertex+148+i)->z=zc+radius*cos(i*PI/4+PI/8);
 }

 (object[id].vertex+156)->x=-2.00;
 (object[id].vertex+156)->y= 3.50;
 (object[id].vertex+156)->z=-0.30;

 (object[id].vertex+157)->x=-1.90;
 (object[id].vertex+157)->y= 3.50;
 (object[id].vertex+157)->z=-0.30;

 (object[id].vertex+158)->x=-1.85;
 (object[id].vertex+158)->y= 3.50;
 (object[id].vertex+158)->z=-1.20;

 (object[id].vertex+159)->x=-2.15;
 (object[id].vertex+159)->y= 3.50;
 (object[id].vertex+159)->z=-1.20;

 /* Stb. strut */
 for (i=0; i<8; i++){
  float xc=-1.95 , yc=-3.50, zc=-1.40, radius=0.17;

  (object[id].vertex+160+i)->x=xc+radius*sin(i*PI/4+PI/8);
  (object[id].vertex+160+i)->y=yc;
  (object[id].vertex+160+i)->z=zc+radius*cos(i*PI/4+PI/8);
 }

 (object[id].vertex+168)->x=-2.00;
 (object[id].vertex+168)->y=-3.50;
 (object[id].vertex+168)->z=-0.30;

 (object[id].vertex+169)->x=-1.90;
 (object[id].vertex+169)->y=-3.50;
 (object[id].vertex+169)->z=-0.30;

 (object[id].vertex+170)->x=-1.85;
 (object[id].vertex+170)->y=-3.50;
 (object[id].vertex+170)->z=-1.20;

 (object[id].vertex+171)->x=-2.15;
 (object[id].vertex+171)->y=-3.50;
 (object[id].vertex+171)->z=-1.20;


 /*
 (object[id].vertex+)->x=;
 (object[id].vertex+)->y=;
 (object[id].vertex+)->z=;
 */

 /**********/
 /* Facets */
 /**********/

 /* 0 Port wing tip */
 facetid->color=BLUE;
 facetid->nedges=7;
 facetid->edge[0]=  5;
 facetid->edge[1]=108;
 facetid->edge[2]=111;
 facetid->edge[3]=  1;
 facetid->edge[4]=  2;
 facetid->edge[5]=  3;
 facetid->edge[6]=  4;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=7;
 facetid->edge[0]=111;
 facetid->edge[1]=108;
 facetid->edge[2]=  5;
 facetid->edge[3]=  4;
 facetid->edge[4]=  3;
 facetid->edge[5]=  2;
 facetid->edge[6]=  1;
 facetid++;

 /* 2 Starboard wing */
 facetid->color=BLUE;
 facetid->nedges=7;
 facetid->edge[0]=117;
 facetid->edge[1]=114;
 facetid->edge[2]= 12;
 facetid->edge[3]= 11;
 facetid->edge[4]= 10;
 facetid->edge[5]=  9;
 facetid->edge[6]=  8;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=7;
 facetid->edge[0]= 12;
 facetid->edge[1]=114;
 facetid->edge[2]=117;
 facetid->edge[3]=  8;
 facetid->edge[4]=  9;
 facetid->edge[5]= 10;
 facetid->edge[6]= 11;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=16;
 facetid->edge[1]=15;
 facetid->edge[2]=14;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=17;
 facetid->edge[1]=16;
 facetid->edge[2]=14;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=18;
 facetid->edge[1]=17;
 facetid->edge[2]=14;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=19;
 facetid->edge[1]=18;
 facetid->edge[2]=14;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=20;
 facetid->edge[1]=19;
 facetid->edge[2]=14;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=21;
 facetid->edge[1]=20;
 facetid->edge[2]=14;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=22;
 facetid->edge[1]=21;
 facetid->edge[2]=14;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=15;
 facetid->edge[1]=22;
 facetid->edge[2]=14;
 facetid++;

 /* 12 Cockpit */

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=19;
 facetid->edge[1]=20;
 facetid->edge[2]=26;
 facetid->edge[3]=25;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=3;
 facetid->edge[0]=18;
 facetid->edge[1]=19;
 facetid->edge[2]=25;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=3;
 facetid->edge[0]=20;
 facetid->edge[1]=21;
 facetid->edge[2]=26;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=3;
 facetid->edge[0]=22;
 facetid->edge[1]=15;
 facetid->edge[2]=92;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=17;
 facetid->edge[1]=18;
 facetid->edge[2]=25;
 facetid->edge[3]=24;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=3;
 facetid->edge[0]=16;
 facetid->edge[1]=17;
 facetid->edge[2]=91;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=21;
 facetid->edge[1]=22;
 facetid->edge[2]=23;
 facetid->edge[3]=26;
 facetid++;

 /* 19 Canopy */
 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=94;
 facetid->edge[1]=90;
 facetid->edge[2]=89;
 facetid->edge[3]=93;
 facetid++;

 /* 20 Tail fin, lower part */
 facetid->color=BLUE;
 facetid->nedges=7;
 facetid->edge[0]= 38;
 facetid->edge[1]=105;
 facetid->edge[2]=106;
 facetid->edge[3]= 34;
 facetid->edge[4]= 35;
 facetid->edge[5]= 36;
 facetid->edge[6]= 37;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=7;
 facetid->edge[0]=106;
 facetid->edge[1]=105;
 facetid->edge[2]= 38;
 facetid->edge[3]= 37;
 facetid->edge[4]= 36;
 facetid->edge[5]= 35;
 facetid->edge[6]= 34;
 facetid++;

  /* 22 canopy */
 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=94;
 facetid->edge[1]=93;
 facetid->edge[2]=27;
 facetid->edge[3]=28;
 facetid++;

 /* 23 air intake */
 facetid->color=DARKGRAY;
 facetid->nedges=6;
 facetid->edge[0]=24;
 facetid->edge[1]=25;
 facetid->edge[2]=42;
 facetid->edge[3]=41;
 facetid->edge[4]=40;
 facetid->edge[5]=39;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=6;
 facetid->edge[0]=26;
 facetid->edge[1]=23;
 facetid->edge[2]=43;
 facetid->edge[3]=44;
 facetid->edge[4]=45;
 facetid->edge[5]=46;
 facetid++;

 /* 25 centre body */
 facetid->color=BLUE;
 facetid->nedges=3;
 facetid->edge[0]=24;
 facetid->edge[1]=39;
 facetid->edge[2]=27;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=3;
 facetid->edge[0]=43;
 facetid->edge[1]=23;
 facetid->edge[2]=28;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=3;
 facetid->edge[0]=27;
 facetid->edge[1]=39;
 facetid->edge[2]=54;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=3;
 facetid->edge[0]=43;
 facetid->edge[1]=28;
 facetid->edge[2]=49;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=3;
 facetid->edge[0]=54;
 facetid->edge[1]=47;
 facetid->edge[2]=27;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=3;
 facetid->edge[0]=28;
 facetid->edge[1]=48;
 facetid->edge[2]=49;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=3;
 facetid->edge[0]=39;
 facetid->edge[1]=40;
 facetid->edge[2]=54;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=3;
 facetid->edge[0]=44;
 facetid->edge[1]=43;
 facetid->edge[2]=49;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=25;
 facetid->edge[1]=26;
 facetid->edge[2]=51;
 facetid->edge[3]=52;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=42;
 facetid->edge[1]=25;
 facetid->edge[2]=52;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=26;
 facetid->edge[1]=46;
 facetid->edge[2]=51;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=41;
 facetid->edge[1]=42;
 facetid->edge[2]=52;
 facetid->edge[3]=53;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=46;
 facetid->edge[1]=45;
 facetid->edge[2]=50;
 facetid->edge[3]=51;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=40;
 facetid->edge[1]=41;
 facetid->edge[2]=53;
 facetid->edge[3]=54;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=45;
 facetid->edge[1]=44;
 facetid->edge[2]=49;
 facetid->edge[3]=50;
 facetid++;


 /* 40 Lower rear body */

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=53;
 facetid->edge[1]=52;
 facetid->edge[2]=56;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=52;
 facetid->edge[1]=51;
 facetid->edge[2]=56;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=51;
 facetid->edge[1]=50;
 facetid->edge[2]=56;
 facetid++;

 /*  43 Lower tail fin */
 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=56;
 facetid->edge[1]=58;
 facetid->edge[2]=57;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=58;
 facetid->edge[1]=56;
 facetid->edge[2]=57;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=54;
 facetid->edge[1]=53;
 facetid->edge[2]=56;
 facetid->edge[3]=55;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=50;
 facetid->edge[1]=49;
 facetid->edge[2]=55;
 facetid->edge[3]=56;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=48;
 facetid->edge[1]=47;
 facetid->edge[2]=29;
 facetid->edge[3]=30;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=3;
 facetid->edge[0]=47;
 facetid->edge[1]=54;
 facetid->edge[2]=55;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=3;
 facetid->edge[0]=49;
 facetid->edge[1]=48;
 facetid->edge[2]=55;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=59;
 facetid->edge[1]=29;
 facetid->edge[2]=47;
 facetid->edge[3]=61;
 facetid++;

 /* 51 Tail jet beam */
 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=62;
 facetid->edge[1]=48;
 facetid->edge[2]=30;
 facetid->edge[3]=60;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=60;
 facetid->edge[1]=59;
 facetid->edge[2]=61;
 facetid->edge[3]=62;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=30;
 facetid->edge[1]=29;
 facetid->edge[2]=59;
 facetid->edge[3]=60;
 facetid++;



 /* 54 port cold jet */
 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=73;
 facetid->edge[1]=40;
 facetid->edge[2]=41;
 facetid->edge[3]=74;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=75;
 facetid->edge[1]=73;
 facetid->edge[2]=74;
 facetid->edge[3]=76;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=3;
 facetid->edge[0]=75;
 facetid->edge[1]=40;
 facetid->edge[2]=73;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=3;
 facetid->edge[0]=74;
 facetid->edge[1]=41;
 facetid->edge[2]=76;
 facetid++;

 /* 58 stb. cold jet */
 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=44;
 facetid->edge[1]=77;
 facetid->edge[2]=78;
 facetid->edge[3]=45;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=77;
 facetid->edge[1]=79;
 facetid->edge[2]=80;
 facetid->edge[3]=78;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=3;
 facetid->edge[0]=77;
 facetid->edge[1]=44;
 facetid->edge[2]=79;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=3;
 facetid->edge[0]=45;
 facetid->edge[1]=78;
 facetid->edge[2]=80;
 facetid++;

 /* 62 port hot jet */
 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=81;
 facetid->edge[1]=75;
 facetid->edge[2]=76;
 facetid->edge[3]=82;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=83;
 facetid->edge[1]=81;
 facetid->edge[2]=82;
 facetid->edge[3]=84;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=3;
 facetid->edge[0]=83;
 facetid->edge[1]=75;
 facetid->edge[2]=81;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=3;
 facetid->edge[0]=82;
 facetid->edge[1]=76;
 facetid->edge[2]=84;
 facetid++;

 /* 66 stb. hot jet */
 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=80;
 facetid->edge[1]=79;
 facetid->edge[2]=85;
 facetid->edge[3]=86;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=85;
 facetid->edge[1]=87;
 facetid->edge[2]=88;
 facetid->edge[3]=86;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=3;
 facetid->edge[0]=85;
 facetid->edge[1]=79;
 facetid->edge[2]=87;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=3;
 facetid->edge[0]=88;
 facetid->edge[1]=80;
 facetid->edge[2]=86;
 facetid++;

 /* 70 in front of windscreen */
 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=15;
 facetid->edge[1]=16;
 facetid->edge[2]=89;
 facetid->edge[3]=90;
 facetid++;

  /* 71 back */
 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=28;
 facetid->edge[1]=27;
 facetid->edge[2]=47;
 facetid->edge[3]=48;
 facetid++;

 /* 72 Canopy*/
 facetid->color=CYAN;
 facetid->nedges=3;
 facetid->edge[0]=93;
 facetid->edge[1]=89;
 facetid->edge[2]=91;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=3;
 facetid->edge[0]=90;
 facetid->edge[1]=94;
 facetid->edge[2]=92;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=3;
 facetid->edge[0]=93;
 facetid->edge[1]=91;
 facetid->edge[2]=27;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=3;
 facetid->edge[0]=94;
 facetid->edge[1]=28;
 facetid->edge[2]=92;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=3;
 facetid->edge[0]=89;
 facetid->edge[1]=16;
 facetid->edge[2]=91;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=3;
 facetid->edge[0]=15;
 facetid->edge[1]=90;
 facetid->edge[2]=92;
 facetid++;

 /* 78 gun pods */
 facetid->color=LIGHTGRAY;
 facetid->nedges=5;
 facetid->edge[0]=95;
 facetid->edge[1]=96;
 facetid->edge[2]=97;
 facetid->edge[3]=98;
 facetid->edge[4]=99;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=5;
 facetid->edge[0]=99;
 facetid->edge[1]=98;
 facetid->edge[2]=97;
 facetid->edge[3]=96;
 facetid->edge[4]=95;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=5;
 facetid->edge[0]=100;
 facetid->edge[1]=101;
 facetid->edge[2]=102;
 facetid->edge[3]=103;
 facetid->edge[4]=104;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=5;
 facetid->edge[0]=104;
 facetid->edge[1]=103;
 facetid->edge[2]=102;
 facetid->edge[3]=101;
 facetid->edge[4]=100;
 facetid++;

 /* Tail fin, upper */
 facetid->color=BLUE;
 facetid->nedges=5;
 facetid->edge[0]=106;
 facetid->edge[1]=107;
 facetid->edge[2]= 32;
 facetid->edge[3]= 33;
 facetid->edge[4]= 34;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=5;
 facetid->edge[0]= 32;
 facetid->edge[1]=107;
 facetid->edge[2]=106;
 facetid->edge[3]= 34;
 facetid->edge[4]= 33;
 facetid++;

 /* 84 Inner wing */
 facetid->color=BLUE;
 facetid->nedges=6;
 facetid->edge[0]=110;
 facetid->edge[1]=  6;
 facetid->edge[2]=  0;
 facetid->edge[3]=  1;
 facetid->edge[4]=111;
 facetid->edge[5]=113;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=6;
 facetid->edge[0]=  0;
 facetid->edge[1]=  6;
 facetid->edge[2]=110;
 facetid->edge[3]=113;
 facetid->edge[4]=111;
 facetid->edge[5]=  1;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=6;
 facetid->edge[0]=  7;
 facetid->edge[1]= 13;
 facetid->edge[2]=116;
 facetid->edge[3]=119;
 facetid->edge[4]=117;
 facetid->edge[5]=  8;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=6;
 facetid->edge[0]=116;
 facetid->edge[1]= 13;
 facetid->edge[2]=  7;
 facetid->edge[3]=  8;
 facetid->edge[4]=117;
 facetid->edge[5]=119;
 facetid++;

 /* Control surfaces below */

 /* 88 Tail plane */
 facetid->color=BLUE;
 facetid->nedges=5;
 facetid->edge[0]=63;
 facetid->edge[1]=64;
 facetid->edge[2]=65;
 facetid->edge[3]=66;
 facetid->edge[4]=67;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=5;
 facetid->edge[0]=65;
 facetid->edge[1]=64;
 facetid->edge[2]=63;
 facetid->edge[3]=67;
 facetid->edge[4]=66;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=5;
 facetid->edge[0]=68;
 facetid->edge[1]=69;
 facetid->edge[2]=70;
 facetid->edge[3]=71;
 facetid->edge[4]=72;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=5;
 facetid->edge[0]=70;
 facetid->edge[1]=69;
 facetid->edge[2]=68;
 facetid->edge[3]=72;
 facetid->edge[4]=71;
 facetid++;

 /* 92 rudder */
 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=105;
 facetid->edge[1]=106;
 facetid->edge[2]=107;
 facetid->edge[3]= 31;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=107;
 facetid->edge[1]=106;
 facetid->edge[2]=105;
 facetid->edge[3]= 31;
 facetid++;

 /* 94 flaps */
 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=109;
 facetid->edge[1]=110;
 facetid->edge[2]=113;
 facetid->edge[3]=112;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=113;
 facetid->edge[1]=110;
 facetid->edge[2]=109;
 facetid->edge[3]=112;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=116;
 facetid->edge[1]=115;
 facetid->edge[2]=118;
 facetid->edge[3]=119;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=118;
 facetid->edge[1]=115;
 facetid->edge[2]=116;
 facetid->edge[3]=119;
 facetid++;

 /* 98 ailerons */
 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=108;
 facetid->edge[1]=109;
 facetid->edge[2]=112;
 facetid->edge[3]=111;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=112;
 facetid->edge[1]=109;
 facetid->edge[2]=108;
 facetid->edge[3]=111;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=115;
 facetid->edge[1]=114;
 facetid->edge[2]=117;
 facetid->edge[3]=118;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=117;
 facetid->edge[1]=114;
 facetid->edge[2]=115;
 facetid->edge[3]=118;
 facetid++;

 /* 102 Air brake */
 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=120;
 facetid->edge[1]=121;
 facetid->edge[2]=122;
 facetid->edge[3]=123;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=122;
 facetid->edge[1]=121;
 facetid->edge[2]=120;
 facetid->edge[3]=123;
 facetid++;

 /* 104 Nose wheel */
 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=124;
 facetid->edge[1]=125;
 facetid->edge[2]=126;
 facetid->edge[3]=127;
 facetid->edge[4]=128;
 facetid->edge[5]=129;
 facetid->edge[6]=130;
 facetid->edge[7]=131;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=131;
 facetid->edge[1]=130;
 facetid->edge[2]=129;
 facetid->edge[3]=128;
 facetid->edge[4]=127;
 facetid->edge[5]=126;
 facetid->edge[6]=125;
 facetid->edge[7]=124;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=132;
 facetid->edge[1]=133;
 facetid->edge[2]=134;
 facetid->edge[3]=135;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=134;
 facetid->edge[1]=133;
 facetid->edge[2]=132;
 facetid->edge[3]=135;
 facetid++;

 /* 108 Main gear */
 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=136;
 facetid->edge[1]=137;
 facetid->edge[2]=138;
 facetid->edge[3]=139;
 facetid->edge[4]=140;
 facetid->edge[5]=141;
 facetid->edge[6]=142;
 facetid->edge[7]=143;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=143;
 facetid->edge[1]=142;
 facetid->edge[2]=141;
 facetid->edge[3]=140;
 facetid->edge[4]=139;
 facetid->edge[5]=138;
 facetid->edge[6]=137;
 facetid->edge[7]=136;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=144;
 facetid->edge[1]=145;
 facetid->edge[2]=146;
 facetid->edge[3]=147;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=146;
 facetid->edge[1]=145;
 facetid->edge[2]=144;
 facetid->edge[3]=147;
 facetid++;

 /* 112 Port strut */
 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=148;
 facetid->edge[1]=149;
 facetid->edge[2]=150;
 facetid->edge[3]=151;
 facetid->edge[4]=152;
 facetid->edge[5]=153;
 facetid->edge[6]=154;
 facetid->edge[7]=155;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=155;
 facetid->edge[1]=154;
 facetid->edge[2]=153;
 facetid->edge[3]=152;
 facetid->edge[4]=151;
 facetid->edge[5]=150;
 facetid->edge[6]=149;
 facetid->edge[7]=148;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=156;
 facetid->edge[1]=157;
 facetid->edge[2]=158;
 facetid->edge[3]=159;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=158;
 facetid->edge[1]=157;
 facetid->edge[2]=156;
 facetid->edge[3]=159;
 facetid++;

 /* 116 Stb. strut */
 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=160;
 facetid->edge[1]=161;
 facetid->edge[2]=162;
 facetid->edge[3]=163;
 facetid->edge[4]=164;
 facetid->edge[5]=165;
 facetid->edge[6]=166;
 facetid->edge[7]=167;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=167;
 facetid->edge[1]=166;
 facetid->edge[2]=165;
 facetid->edge[3]=164;
 facetid->edge[4]=163;
 facetid->edge[5]=162;
 facetid->edge[6]=161;
 facetid->edge[7]=160;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=168;
 facetid->edge[1]=169;
 facetid->edge[2]=170;
 facetid->edge[3]=171;
 facetid++;

 facetid->color=BLUE;
 facetid->nedges=4;
 facetid->edge[0]=170;
 facetid->edge[1]=169;
 facetid->edge[2]=168;
 facetid->edge[3]=171;
 facetid++;


 /*
 facetid->color=;
 facetid->nedges=;
 facetid->edge[0]=;
 facetid->edge[1]=;
 facetid->edge[2]=;
 facetid->edge[3]=;
 facetid++;
 */

 if (object[id].facet+nfacets!=facetid)
 {
   printf("Harrier: Incorrect number of facets\n");
   exit(1);
 }

 /* Define control surface rotation axis */
 object[id].ctrl_surface[0].axis =
   vminus(*(object[id].vertex+67),*(object[id].vertex+72));
 object[id].ctrl_surface[1].axis =
   vminus(*(object[id].vertex+106),*(object[id].vertex+105));
 object[id].ctrl_surface[2].axis =
   vminus(*(object[id].vertex+113),*(object[id].vertex+112));
 object[id].ctrl_surface[3].axis =
   vminus(*(object[id].vertex+118),*(object[id].vertex+119));
 object[id].ctrl_surface[4].axis =
   vminus(*(object[id].vertex+112),*(object[id].vertex+111));
 object[id].ctrl_surface[5].axis =
   vminus(*(object[id].vertex+117),*(object[id].vertex+118));
 object[id].ctrl_surface[6].axis =
   vminus(*(object[id].vertex+121),*(object[id].vertex+120));
 object[id].ctrl_surface[7].axis =
   vminus(*(object[id].vertex+121),*(object[id].vertex+120));
 object[id].ctrl_surface[8].axis =
   vminus(*(object[id].vertex+120),*(object[id].vertex+121));
 object[id].ctrl_surface[9].axis =
   vminus(*(object[id].vertex+120),*(object[id].vertex+121));
 object[id].ctrl_surface[10].axis =
   vminus(*(object[id].vertex+120),*(object[id].vertex+121));


 for (j=0; j<object[id].nctrl_srf; j++){
  float norm;
  cartvektor tmp, tmp2;

  /* Generate orthonormal-system */
  norm=sqrt(VPRIK(object[id].ctrl_surface[j].axis,
                  object[id].ctrl_surface[j].axis));
  object[id].ctrl_surface[j].front=
                  svmult(1./norm,object[id].ctrl_surface[j].axis);
  /* Rotate 90 deg about z */
  tmp.x = -object[id].ctrl_surface[j].front.y;
  tmp.y =  object[id].ctrl_surface[j].front.x;
  tmp.z =  object[id].ctrl_surface[j].front.z;

  /* Rotate 90 deg about x - then the vector is not parallel with front vector */
  tmp2.x =  tmp.x;
  tmp2.y = -tmp.z;
  tmp2.z =  tmp.y;

  object[id].ctrl_surface[j].left =
   vkryds(object[id].ctrl_surface[j].front,tmp2);
  norm=sqrt(VPRIK(object[id].ctrl_surface[j].left,
                  object[id].ctrl_surface[j].left));
  object[id].ctrl_surface[j].left=
                  svmult(1./norm,object[id].ctrl_surface[j].left);

  object[id].ctrl_surface[j].top =
   vkryds(object[id].ctrl_surface[j].front,object[id].ctrl_surface[j].left);
 }


 object[id].colarr[WHITE].r = 255;
 object[id].colarr[WHITE].g = 255;
 object[id].colarr[WHITE].b = 255;

 object[id].colarr[LIGHTGRAY].r = 192;
 object[id].colarr[LIGHTGRAY].g = 192;
 object[id].colarr[LIGHTGRAY].b = 192;

 object[id].colarr[DARKGRAY].r =  80;
 object[id].colarr[DARKGRAY].g =  80;
 object[id].colarr[DARKGRAY].b =  80;

 object[id].colarr[RED].r = 255;
 object[id].colarr[RED].g =  32;
 object[id].colarr[RED].b =  32;

 object[id].colarr[GREEN].r =  32;
 object[id].colarr[GREEN].g = 255;
 object[id].colarr[GREEN].b =  32;

 object[id].colarr[BLUE].r =  32;
 object[id].colarr[BLUE].g =  32;
 object[id].colarr[BLUE].b = 255;

 object[id].colarr[LIGHTRED].r = 255;
 object[id].colarr[LIGHTRED].g =  96;
 object[id].colarr[LIGHTRED].b =  96;

 object[id].colarr[LIGHTBLUE].r = 96;
 object[id].colarr[LIGHTBLUE].g = 96;
 object[id].colarr[LIGHTBLUE].b = 255;

 object[id].colarr[CYAN].r =  96;
 object[id].colarr[CYAN].g = 192;
 object[id].colarr[CYAN].b = 192;

 object[id].colarr[LIGHTCYAN].r =  64;
 object[id].colarr[LIGHTCYAN].g = 255;
 object[id].colarr[LIGHTCYAN].b = 255;

 object[id].colarr[DARKGREEN].r =  50;
 object[id].colarr[DARKGREEN].g = 100;
 object[id].colarr[DARKGREEN].b =  40;


 nobjects++;
