{//-------------------------------------------------------------------------}
{/*                                                                         }
{Copyright (C) 1990, 2009 - Apogee Software, Ltd.                           }
{                                                                           }
{This file is part of Word Whiz.  Word Whiz is free software; you can       }
{redistribute it and/or modify it under the terms of the GNU General Public }
{License as published by the Free Software Foundation; either version 2     }
{of the License, or (at your option) any later version.                     }
{                                                                           }
{This program is distributed in the hope that it will be useful,            }
{but WITHOUT ANY WARRANTY; without even the implied warranty of             }
{MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                       }
{                                                                           }
{See the GNU General Public License for more details.                       }
{                                                                           }
{You should have received a copy of the GNU General Public License          }
{along with this program; if not, write to the Free Software                }
{Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.}
{                                                                           }
{Original Source: 1990 Scott Miller                                         }
{Prepared for public release: 03/19/09 - Joe Siegler, Apogee Software, Ltd. }
{*/                                                                         }
{//-------------------------------------------------------------------------}
{****************************************************************************}
{*                            W O R D   W H I Z                             *}
{*                                Version 1                                 *}
{*                     An Apogee Software Production                        *}
{*                            Turbo Pascal 5.0                              *}
{*                        Created by Scott Miller                           *}
{*                          began Jan. 26, 1990                             *}
{****************************************************************************}


                        {***************************}
                        {* Last Modified:  2/ 4/90 *}
                        {***************************}

program Word_Whiz;

uses crt, dos, turbo3;

const
  Null          = 0;
  QNum          = 101;

type
  Str75         = string[75];    { used to store questions and comments }
  Str68         = string[69];    { used to store answers }
  Str30         = string[30];

var
  Q{uestions}   : array[1..100,1..2] of Str75;
  A{nswers}     : array[1..100,1..4] of Str68;
  C{omment}     : array[1..100] of Str75;
  QPos          : array[1..4] of integer;
  Status        : Str30;
  Men,
  Question,
  Correct,
  Next,
  Choice,
  Col1,
  Col2,
  Col3,
  Col4,
  x,y,i         : integer;
  Asked         : set of 1..100;
  ch            : char;
  xx,yy,ii      : byte;
  Result        : Registers;
  SoundOn,
  Color,
  CheatUsed,
  Restart       : boolean;

procedure Col(Num1,Num2:byte);
 begin
  if Color then textcolor(Num1) else textcolor(Num2);
 end;

procedure Bak(Num1,Num2:byte);
 begin
  if Color then textbackground(Num1) else textbackground(Num2);
 end;

procedure Bor(Num:byte);
 begin
  if Color then
   begin
    with Result do begin AX:=$B00;BX:=Num;end;
    intr($10,Result);
   end
 end;

procedure Cur(Num:byte);
 begin
  Result.AX:=$100;
  with Result do
   if Color then
    case Num of
     1:CX:=$707;   { Underline   }
     2:CX:=$8;     { Solid Block }
     3:CX:=$2000;  { Invisible   }
    end
   else
    case Num of
     1:CX:=$C0D;   { Underline   }
     2:CX:=$E;     { Solid Block }
     3:CX:=$2000;  { Invisible   }
    end;
  intr($10,Result);
 end;

procedure ClearKeys;
 begin
  while keypressed do read(kbd,ch)
 end;

 procedure Beep;
  begin
   if SoundOn then
    begin
     sound(350);delay(40);nosound;delay(50);
    end;
  end;

procedure Screen_Type;
 begin
  randomize;
  Color:=true;
  bor(4);
  clrscr;
  col(15,15);
  gotoxy(30,2);
  write('WORD WHIZ - VOLUME I');
  bak(0,0);
  col(9,9);
  gotoxy(26,10);
  write('Color or Monochrome (C/M)? C');cur(2);gotoxy(wherex-1,wherey);
  ClearKeys;
  repeat x:=random(maxint) until keypressed;
  read(kbd,ch);
  if upcase(ch) = 'M' then Color:=false;
  ClearKeys;
  gotoxy(26,10);
  write('                              ');
  gotoxy(26,14);
  write('Do you want sound ON (Y/N)? Y');gotoxy(wherex-1,wherey);
  ClearKeys;
  repeat x:=random(maxint) until keypressed;
  read(kbd,ch);
  if upcase(ch) = 'N' then SoundOn := false else SoundOn := true;
  Beep;
  ClearKeys;
  clrscr;
  bor(0);
  cur(3);
 end;

procedure Sign_Off;
 begin
  col(7,7);
  bor(0);
  bak(0,0);
  clrscr;
  gotoxy(30,1);write('WORD WHIZ - VOLUME I');
  gotoxy(26,2);write('An Apogee Software Production');
  gotoxy(1,wherey+2);
  writeln('Other shareware games available from Scott Miller:');
  writeln;
  writeln('* RETURN TO KROZ - Rated five stars by many magazines!  Brilliant sequel');
  writeln('     to KINGDOM OF KROZ with 20 new screens.  If you''ve never experienced');
  writeln('     a Kroz game then you''re missing the best game in shareware!  ($7.50)');
  writeln;
  writeln('* THE LOST ADVENTURES OF KROZ - 75 new levels, creature animation, shops,');
  writeln('     "sideways levels", hundreds of puzzling situations, multiple saves,');
  writeln('     gravity pits, flowing lava, diaries, dozens of new additions!  ($20)');
  writeln;  
  writeln('* SUPERNOVA - An epic adventure spanning an entire galaxy. Full color and');
  writeln('     sound effects galore.  Infocom games can''t compare!  ($10)');
  writeln;
  writeln('* BEYOND THE TITANIC - A fantastic adventure of exploration and survival.');
  writeln('     Sound effects and 16 color screens.  ($8)');
  writeln;
  writeln('Have a nice day,');
  write  ('Scott Miller');
  cur(1);
  ClearKeys;
  HALT;
 end; { Sign_Off }

function Cycle : integer;
 begin
  repeat
   x := random(16)
  until (x in [1..6,9..15])and(x<>Col1)and(x<>Col2)and(x<>Col3)and(x<>Col4);
  Col4  := Col3;
  Col3  := Col2;
  Col2  := Col1;
  Col1  := x;
  Cycle := x;
 end; { Cycle }

procedure Shareware_Screen(Start: boolean);
 begin
  bak(0,0);
  clrscr;
  col(9,0);
  bak(4,7);
  for x:=2 to 79 do
   begin
    gotoxy(x,1);write(#205);
    gotoxy(x,24);write(#205);
   end;
  gotoxy(1,1);write(#213);
  gotoxy(80,1);write(#184);
  gotoxy(1,24);write(#212);
  gotoxy(80,24);write(#190);
  bak(0,0);
  gotoxy(1,8);
  insline;
  bak(4,7);
  for y:=2 to 24 do
   begin
    gotoxy(1,y);write(#179);
    gotoxy(80,y);write(#179);
   end;
  bak(4,7);
  gotoxy(28,1);
  gotoxy(29,1);
  col(9,0);write(#16);
  col(15,0);write(' WORD WHIZ - VOLUME I ');
  col(9,0);write(#17);
  window(2,2,79,24);
  bak(0,0);
  col(2,9);
  gotoxy(25,1);write('An Apogee Software Production');
  gotoxy(27,2);
  col(2,7);
  write('Copyright (C) Scott Miller');
  gotoxy(17,4);
  col(11,7);
  write('WORD WHIZ - VOLUME I is a ');
  col(15,9);write('shareware');
  col(11,7);writeln(' program.');
  col(3,7);
  write('If you ');
  if Start then write('enjoy') else write('liked');
  writeln(' this game the author kindly asks that you send a $4 appreciation');
  write('and registration fee. This fee also entitles you to phone and written support.');
  bak(1,7);
  col(15,0);
  writeln;
  gotoxy(8,wherey);i:=wherey;
  writeln(' THERE ARE THREE MORE VOLUMES OF WORD WHIZ THAT YOU CAN ORDER! ');
  writeln;
  bak(0,0);
  col(3,7);
  writeln('Altogether, there are four separate and unique editions of WORD WHIZ, simply');
  writeln('titled WORD WHIZ - VOLUME 1 through WORD WHIZ - VOLUME 4. Each volume has 100');
  writeln('new questions to challenge and rate your vocabulary level.');
  writeln;
  writeln('Each volume can be ordered directly from Apogee Software for $5 each, plus $2');
  write  ('per entire order to cover disks and postage.  (i.e. Ordering 2 will cost $12.)');
  writeln('When ordering, please indicate which volume numbers you would like.  Also,');
  writeln('registered users will get a secret code that answers all questions correctly.');
  writeln;
  col(15,15);write('Special Offer: ');col(3,7);
  writeln('Order all four volumes and pay only $17! (a $5 savings)');
  col(3,7);writeln;
  write('Please make checks payable to:      ');
  col(14,15);       writeln('Apogee Software');
  gotoxy(37,wherey);writeln('4206 Mayflower');
  gotoxy(37,wherey);write('Garland, Tx. 75043');y:=wherey;
  gotoxy(1,y);col(3,7);write('Phone #: ');
  col(14,15);write('(214) 240-0614');
  col(2,7);
  gotoxy(66,22);write('Thank you,');
  gotoxy(66,23);write('Scott Miller');
  window(1,1,80,25);
  bak(4,7);
  gotoxy(32,25);
  if Start then delay(500);
  ClearKeys;
  col(25,16);write(#16);
  col(0,0);write(' PRESS ANY KEY. ');
  col(25,16);write(#17);
  repeat
  bak(1,7);
  if not Start then
    begin
     col(cycle,0);
     gotoxy(9,i+1);
     write(' THERE ARE THREE MORE VOLUMES OF WORD WHIZ THAT YOU CAN ORDER! ');
    end;
  until keypressed;
  read(kbd,ch);
  if ch='q' then begin cur(1);HALT;end;
  Beep;
  ClearKeys;
 end; { Shareware_Screen }

procedure Title;
 var Count : integer;
 begin
  Count := 0;
  if Color then textmode(C80) else textmode(BW80);
  bak(0,0);
  clrscr;
  cur(3);
  repeat
   Count := Count + 1;
   bor(Cycle);
   col(14,9);
   gotoxy(26,2);writeln('Apogee Software Production''s');
   writeln;
   col(Cycle,7);
   writeln('                        ');
   writeln('                                     ');
   writeln('                                          ');
   writeln('                                       ');
   writeln('                                        ');
   writeln('                                       ');
   writeln('                                     ');
   writeln;
   col(Cycle,7);
   writeln('                                                                    (R)');
   writeln('                                             ');
   writeln('                                                      ');
   writeln('                                              ');
   writeln('                                           ');
   writeln('                                              ');
   writeln('                                           ');
   writeln;
   col(Cycle,7);
   writeln('                                        ');
   writeln('                                               ');
   writeln('                                     ');
   writeln;
   col(0,0);
   bak(1,7);
   gotoxy(22,wherey);write(' Created by Scott Miller - Version 1 ');
   bak(0,0);
   if Count mod 110 = 0 then
    begin
     if SoundOn then sound(400);
     col(31,31);
     gotoxy(32,25);write('< Press any key. >');
     delay(90);
     nosound;
    end;
    delay(500);
  until keypressed;
  Beep;
  ClearKeys;
  bak(1,0);
  clrscr;
  cur(3);
  bor(1);
  bak(1,0);
  col(15,7);
  gotoxy(26,2);write('Apogee Software Production''s');
  col(4,7); gotoxy(29,3);write('');bak(4,7);
  col(14,0);gotoxy(29,4);write(' WORD WHIZ - VOLUME I ');bak(1,0);
  col(4,7); gotoxy(29,5);write('');
  bak(1,0);
  gotoxy(25,6);
  col(13,9);
  write('Copyright (C) 1990 Scott Miller');
  gotoxy(1,8);
  col(11,7);
  writeln('Word Whiz is a word challenge game that can measure your knowledge of the');
  writeln('English language.  For example, are you positive you know what the word');
  writeln('"Peruse" means?  Most people beleive it means "to skim" or "to glance over",');
  writeln('but in fact it means "to read carefully".  By playing Word Whiz you''ll receive');
  writeln('a continuous rating while you answer each quiz question!');
  writeln;
  writeln('Most questions focus on a key word, which is shown in CAPITAL LETTERS.  Simply');
  writeln('find the word or phrase the most correctly matches the key word.  There are');
  writeln('always four multiple choice answers to choose from--guess if you have to!');
  writeln;
  writeln('There are 100 words presented in this volume.  You can continue playing until');
  writeln('you miss 10 questions.  (You will earn a Bonus Miss for every ten questions');
  writeln('you answer correctly.)  Also, when a question is correctly answered, you might');
  writeln('receive some addition related information--just to further expand your already');
  writeln('voluminous knowledge base!');
  writeln;
  writeln('Good luck and have fun...');
  col(0,7);
  gotoxy(32,25);
  write('< Press any key. >');
  repeat
   x:=random(maxint)
  until keypressed;
  Beep;
  ClearKeys;
 end;

procedure Setup_Screen;
 begin
  bak(0,0);
  clrscr;
  cur(3);
  bor(5);
  col(2,0);
  bak(1,7);
  for x:=2 to 79 do
   begin
    gotoxy(x,1);write(#205);
    gotoxy(x,3);write(#205);
    gotoxy(x,22);write(#205);
    gotoxy(x,24);write(#205);
   end;
  gotoxy(1,1);write(#213);
  gotoxy(80,1);write(#184);
  gotoxy(1,24);write(#212);
  gotoxy(80,24);write(#190);
  bak(0,0);
  gotoxy(1,8);
  insline;
  bak(1,7);
  for y:=2 to 24 do
   begin
    gotoxy(1,y);write(#179);
    gotoxy(80,y);write(#179);
   end;
  gotoxy(1,3);write(#198);
  gotoxy(80,3);write(#181);
  gotoxy(1,23);write(#198);
  gotoxy(80,23);write(#181);
  bak(1,0);
  gotoxy(2,24);
  for x:=2 to 79 do write(#32);
  bak(1,7);
  col(0,0);
  gotoxy(2,2);
  for x:=2 to 79 do write(#32);
  gotoxy(29,1);
  col(15,0);
  write(' WORD WHIZ - VOLUME I ');
  gotoxy(2,2);
  Col(11,0);
  write('Question:');
  gotoxy(16,2);
  write('Correct:');
  gotoxy(29,2);
  write('Misses Left:');
  gotoxy(46,2);
  write('Status:');
  gotoxy(13,24);
  bak(1,0);
  col(12,7);write('Press ');
  col(14,15);write('1');
  col(12,7);write(', ');
  col(14,15);write('2');
  col(12,7);write(', ');
  col(14,15);write('3 ');
  col(12,7);write('or ');
  col(14,15);write('4');
  col(12,7);write(' to pick your answer.   Hit ');
  col(14,15);write('Q ');
  col(12,7);write('to quit.');
  col(2,7);
  bak(0,0);
  gotoxy(2,10);
  write('Which answer do you choose:');
  bak(4,7);
  col(14,0);
  gotoxy(2,QPos[1]);write(' 1 ');
  gotoxy(2,QPos[2]);write(' 2 ');
  gotoxy(2,QPos[3]);write(' 3 ');
  gotoxy(2,QPos[4]);write(' 4 ');
 end; { Setup_Screen }

procedure Print_Variables(UpdateStatus:boolean);
  var PercentRight, TempQ, TempC : real;
 begin
  bak(1,7);
  col(15,0);
  gotoxy(12,2);write(Question);
  gotoxy(25,2);write(Correct);
  gotoxy(42,2);write('   ');
  gotoxy(42,2);write(Men);

  if UpdateStatus then
   begin
    TempQ := Question;
    TempC := Correct;
    if Correct > 0 then
     PercentRight := (1.0 / (TempQ / TempC) * 100.0)
    else
     if Question = 1 then PercentRight := 100.0 else PercentRight := 0.0;

    if not CheatUsed then
     case round(PercentRight) of
      0..9:   Status:='Word Wimp                 ';
      10..19: Status:='3rd Grade Reading Level!  ';
      20..29: Status:='6th Grade Reading Level!  ';
      30..39: Status:='9th Grade Reading Level   ';
      40..49: Status:='High School Graduate Level';
      50..59: Status:='AAA--Above Average America';
      60..69: Status:='College Graduate Level    ';
      70..79: Status:='The Dictionary Dude!      ';
      80..89: Status:='Professor of Wordology!   ';
      90..100:begin
               if Question > 85 then Status:='WORD WHIZ OF THE GALAXY!  '
               else                  Status:='WORD WHIZ!                ';
              end;
     end
    else     Status:='Cheat Key User!          ';
   end;
  gotoxy(54,2);
  write(Status);
 end;

{$I A:WW1.Q&A ********* load Init_Questions procedure ******************}

function Right(QuesNum:integer): integer;
 begin
  case QuesNum of
    1..25  :Right := 1;
   26..50  :Right := 2;
   51..75  :Right := 3;
   76..100 :Right := 4;
  end;
 end; { Right }

procedure Print_Score;
  var Reply1, Reply2,
      Temp  : Str68;
 begin
  str(Correct+Men,Temp);
  Reply1:='You scored '+Temp+' points,';
		Reply2:='which is a total of questions correct, plus unused Misses.';
  col(11,9);
  bak(0,0);
  gotoxy(40-length(Reply1) div 2,7);
  writeln(Reply1);
  gotoxy(40-length(Reply2) div 2,8);
  writeln(Reply2);
  if CheatUsed then
    begin
      gotoxy(8,9);
      col(10,7);
      writeln('*** YOU TOOK ADVANTAGE OF THE CHEAT KEY TO OBTAIN THIS SCORE! ***');
    end;
 end; { Print_Score }

procedure Quiz_Done(Finished:boolean);
 begin
  window(2,4,79,22);
  gotoxy(1,22);
  clrscr;
  col(15,0);
  window(1,1,80,25);
  if Finished then
   begin
    gotoxy(16,5);
    bak(2,7);
    bor(4);
    writeln(' Congratulations, you have completed WORD WHIZ! ');
   end
  else
   begin
    gotoxy(21,5);
    bak(4,7);
    bor(2);
    writeln(' You have not yet finished WORD WHIZ! ');
   end;
  Print_Score;
  col(9,9);
  gotoxy(35,11);
  writeln('References:');
  col(6,7);
  gotoxy(14,13);writeln('Webster''s NewWorld Dictionary by Simon and Schuster');
  gotoxy(19,15);writeln('Roget''s College Thesaurus by Signet Books');
  gotoxy(3,17);writeln('The built-in thesaurus in the wordprocessor Sprint by Borland International');
  col(14,15);bak(0,0);
  if CheatUsed then
    begin
      gotoxy(14,19);
      write('All four WORD WHIZ volumes are available for only $17!');
      gotoxy(14,20);
      write('------------------------------------------------------');
    end
  else
    begin
      gotoxy(11,19);
      write('Registered users will receive a secret code that will allow');
      gotoxy(15,20);
      write('you to answer all questions correct--automatically.');
    end;
  col(7,7);
  bak(0,0);
  gotoxy(26,22);
  write('< Press any key to end game. >');
  read(kbd,ch);
  Beep;
  ClearKeys;
  Shareware_Screen(false);
  Sign_Off;
 end; { Quiz_Done }

procedure Next_Question;
 var Underscore  : boolean;
     Temp1,
     Temp2       : string[1];
 begin
  Question:=Question+1;
  if Question>QNum-1 then Quiz_Done(true);
  col(11,7);
  bak(0,0);
  window(1,1,79,25);
  gotoxy(2,6); clreol;  { question lines }
  gotoxy(2,7); clreol;
  gotoxy(2,20);clreol;  { correct or wrong line }
  gotoxy(2,22);clreol;  { press any key prompt }
  gotoxy(2,10);clreol;  { comment line }
  for x:=1 to 4 do
   begin
    gotoxy(6,QPos[x]);  { answer lines }
    clreol;
   end;
  window(1,1,80,25);
  col(2,7);
  bak(0,0);
  gotoxy(2,10);
  write('Which answer do you choose:');
  repeat Next:=random(100)+1; until not(Next in Asked);
  Asked:=Asked+[Next];
  Print_Variables(false);

{######### TEMP >>>>>> gotoxy(5,23);col(15,15);bak(0,0);write('#',Next,' ');}

  col(14,9);
  bak(0,0);
  if Q[Next,2] = '' then
    begin
     gotoxy(41-(length(Q[Next,1])+1) div 2,7); write(Q[Next,1]);
    end
  else
    begin
      gotoxy(41-(length(Q[Next,1])+1) div 2,6); write(Q[Next,1]);
      gotoxy(41-(length(Q[Next,2])+1) div 2,7); write(Q[Next,2]);
    end;
  col(11,7);
  for x:=1 to 4 do
   begin
    gotoxy(6,QPos[x]);
    write(A[Next,x]);
   end;
  bak(0,0);
 end; { Next_Question }

procedure Get_Answer;
  var   Reply : Str75;
        Wrong : boolean;
        Temp  : string[1];
  label AGAIN;
 begin
  AGAIN:
  bak(0,0);
  ClearKeys;
  repeat
   col(random(16),15);
   gotoxy(30,10);
   delay(15);
   write(chr(random(4)+220));
  until keypressed;
  read(kbd,ch);
  ClearKeys;
  if not(upcase(ch) in ['1','2','3','4','Q',#27,'~']) then
   begin
    if SoundOn then for x:=500 downto 10 do sound(x*2);
    nosound;
    goto AGAIN;
   end;
  col(15,15);
  gotoxy(30,10);
  if ch=#27 then ch:='Q';
  write(upcase(ch));
  Beep;
  if upcase(ch)='Q' then
   begin
    gotoxy(23,21);
    col(15,15);
    write('Are you sure you want to quit (Y/N)? ');
    read(kbd,ch);
    Beep;
    if upcase(ch)='Y' then Quiz_Done(false);
    gotoxy(23,21);
    write('                                    ');
    goto AGAIN;
   end;
  if ch <> '~' then
    val(ch,Choice,x)
  else
   begin                  { cheat mode, press "~" }
     CheatUsed := true;
     Choice := Right(Next);
   end;
  gotoxy(6,QPos[Choice]);
  col(14,9);
  write(A[Next,Choice]);
  Wrong := true;
  if Choice=Right(Next) then
   begin

    if C[Next] <> '' then
     begin
      bak(0,0);col(0,0);
      gotoxy(2,10);
      write('                              ');
      col(15,0);bak(6,7);
      gotoxy(39-(length(C[Next])) div 2,10);
      write(' ',C[Next],' ');
     end;

    Wrong := false;
    Reply:=' You got it right';
    Correct:=Correct+1;
    bak(1,7);
    col(10,0);
    if (Correct mod 10)=0 then
     begin
      Men:=Men+1;
      Reply:=Reply+'...and also earned a BONUS MISS';
     end;
    Reply:=Reply+'! ';
   end
  else
   begin
    bak(7,7);
    col(4,0);
    Reply:=' Wrong, you lost a BONUS MISS';
    Men:=Men-1;
    if Men=0 then Reply:=Reply+' ... and you lost the game';
    Reply:=Reply+'! ';
   end;
  gotoxy(40-length(Reply) div 2,20);
  write(Reply);
  Print_Variables(true);
  if Wrong and SoundOn then
   begin
    for x :=25 downto 1 do
      for y := 20 downto 1 do
       begin sound(x*y);delay(y div 3); end;
    nosound;
   end
  else
   begin
    if SoundOn then
      for i := 5 to 15 do
       begin sound(i*i*i div 3);delay(i);end;
    nosound;
   end;
  col(7,7);
  bak(0,0);
  gotoxy(26,22);
  write('< Press any key to continue. >');
  read(kbd,ch);
  Beep;
  ClearKeys;
  if Men=0 then Quiz_Done(false);
 end; { Get_Answer }

procedure Initialize_Variables;
 begin
  Status      := 'WORD WHIZ!';
  Men         :=10;
  Question    :=0;
  Correct     :=0;
  CheatUsed   :=false;
  Col1        :=15;
  Col2        :=15;
  Col3        :=15;
  Col4        :=1;
  Restart     :=false;
  QPos[1]     :=12;
  QPos[2]     :=14;
  QPos[3]     :=16;
  QPos[4]     :=18;
  Asked       :=[]; {* [QNum..100] *}
  Init_Questions;
 end;


BEGIN
Screen_Type;
Initialize_Variables;
Title;
Shareware_Screen(true);
Setup_Screen;

repeat
 Next_Question;
 Get_Answer;
until Restart;

END. { WORD WHIZ }