/**
*	(c) Copyright 2003,2004 Point Mad, Lukas Lipka. All rights reserved.
*
*	FILE:			error.c
*
*	PROJECT:		Phoenix engine - Core
*
*	DESCRIPTION:	Error and exception handling functions
*
*	CONTRIBUTORS:
*					Lukas Lipka
*
*	TODO:			@ Add ASM interupt reprogramming code.
*
*	BUG:			@
*
*	MISTAKE:		@
*
*	IDEA:			@
*/

#include "kernel.h"

/**
*	NAME: ERROR_SystemHalt
*	DESCRIPTION: Halts the whole system, cannot be undone
*/
_PRIVATE void  ERROR_SystemHalt ( void )
{
	printf("[EXCEPTION] => SYSTEM HALTED!\n");
	DebugFatal("SYSTEM HALTED!");
}

/**
*	NAME: ERROR_SystemPause
*	DESCRIPTION: Pauses the whole system, while we handle the exception
*/
_PRIVATE void  ERROR_SystemPause ( void )
{

}

/**
*	NAME: ERROR_SystemResume
*	DESCRIPTION: Resumes the whole system from a previous pause
*/
_PRIVATE void  ERROR_SystemResume ( void )
{

}

/**
 *	Exception functions
*/
_PUBLIC void  EXCEPTION_isr0 ( void )
{
	DebugError("0 Division by zero");
}

_PUBLIC void  EXCEPTION_isr1 ( void )
{
	DebugError("1 Debug exception");
}

_PUBLIC void  EXCEPTION_isr2 ( void )
{
	DebugError("2 Intel reserved");
}

_PUBLIC void  EXCEPTION_isr3 ( void )
{
	DebugError("3 Breakpoint");
}

_PUBLIC void  EXCEPTION_isr4 ( void )
{
	DebugError("4 Overflow");
}

_PUBLIC void  EXCEPTION_isr5 ( void )
{
	DebugError("5 Bounds check");
}

_PUBLIC void  EXCEPTION_isr6 ( void )
{
	DebugError("6 Invalid OPCODE");
}

_PUBLIC void  EXCEPTION_isr7 ( void )
{
	DebugError("7 Coprocessor Not Available");
}

_PUBLIC void  EXCEPTION_isr8 ( void )
{
	DebugError("8 Double Fault");
}

_PUBLIC void  EXCEPTION_isr9 ( void )
{
	DebugError("9 Coprocessor Segment Overrun");
}

_PUBLIC void  EXCEPTION_isr10 ( void )
{
	DebugError("10 Invalid TSS");
}

_PUBLIC void  EXCEPTION_isr11 ( void )
{
	DebugError("11 Segment Not Present");
}

_PUBLIC void  EXCEPTION_isr12 ( void )
{
	DebugError("12 Stack Exception");
}

_PUBLIC void  EXCEPTION_isr13 ( void )
{
	DebugError("13 General Protection Exception (Triple Fault)");
}

_PUBLIC void  EXCEPTION_isr14 ( void )
{
	DebugError("14 Page Fault");
}

_PUBLIC void  EXCEPTION_isr15 ( void )
{
	DebugError("15 Intel reserved");
}

_PUBLIC void  EXCEPTION_isr16 ( void )
{
	DebugError("16 Coprocessor Error");
}


_PUBLIC void  ExceptionHandlerInstall ( void )
{
	DebugMessage("Starting exception handler for exceptions (0-16)");

	/**
	*	Reprogram int 8, for ISR 0-16
	*/
	DebugMessage("Reprogramming interrupt 8 => 0-16 ISR");

	DebugMessage("Reprogramming interrupt successful");
}

_PUBLIC void  ExceptionHandlerUninstall ( void )
{
	DebugMessage("Reprogramming interrupt 8 => NORMAL");

	DebugMessage("Reprogramming interrupt successful");
}


