#include "kernel.h"
#include "widget.h"
#include "checkbox.h"

l_ulong	AppVersion = ULONG_ID(0,0,0,1);
l_char	AppName[] = "Checkbox Widget";
l_uid	nUID = "checkbox";
l_uid NeededLibs[] = { "widget", "skin", "" };

PSkin CheckboxCleared = 0;
PSkin CheckboxChecked = 0;

void CheckboxDraw ( PWidget o, p_bitmap buffer, PRect w )
{
	if (!CHECKBOX(o)->Checked)
		DrawSkin(buffer, CheckboxCleared, o->Absolute.a.x, o->Absolute.a.y , o->Absolute.b.x, o->Absolute.b.y);
	else
		DrawSkin(buffer, CheckboxChecked, o->Absolute.a.x, o->Absolute.a.y , o->Absolute.b.x, o->Absolute.b.y);

	textout(buffer, default_font, CHECKBOX(o)->Caption, o->Absolute.a.x + CheckboxChecked->Left + 1, o->Absolute.a.y + (o->Absolute.b.y-o->Absolute.a.y)/2 - text_height(CheckboxCleared->Font)/2, CheckboxCleared->FontColor);
}

l_bool CheckboxEventHandler ( PWidget o, PEvent Ev )
{
	if (Ev->Type == EV_MOUSE)
	{
		if (Ev->Message == WEvMouseLDown)
		{
			CHECKBOX(o)->Checked = !CHECKBOX(o)->Checked;
			WidgetDraw(o, NULL);
			return true;
		}

		/*if (Ev->Message == WEvMouseLUp)
		{
			CHECKBOX(o)->Checked = !CHECKBOX(o)->Checked;
			WidgetDraw(o, NULL);
			return true;
		}*/

	}

	return false;
}

PCheckbox CreateCheckbox(PApplication App, TRect r, l_text Caption)
{
	PCheckbox b = malloc(sizeof(TCheckbox));

	if (!b) return NULL;

	memset(b, 0, sizeof(TCheckbox));

	b->Checked = false;
	b->Caption = TextDup(Caption);

	/**
	*	Set the width and height to checkbox skin item
	*		width and height.
	*/
	r.b.x = r.a.x + (/**/ CheckboxCleared->Left + CheckboxCleared->Right + 1 + text_length(CheckboxCleared->Font, b->Caption) > CheckboxCleared->Skin->w ? CheckboxCleared->Left + CheckboxCleared->Right + 1 + text_length(CheckboxCleared->Font, b->Caption) : CheckboxCleared->Skin->w/**/);
	r.b.y = r.a.y + (CheckboxCleared->Skin->h > text_height(CheckboxCleared->Font) ? CheckboxCleared->Skin->h : text_height(CheckboxCleared->Font));

	IntialiseWidget(App, WIDGET(b), r, "CHKBOX");

	WIDGET(b)->Draw = &CheckboxDraw;
	WIDGET(b)->EventHandler = &CheckboxEventHandler;

	return b;
}

l_bool LibMain ( l_text Args )
{
	CheckboxCleared = GetSkinItem("CheckboxCleared");
	CheckboxChecked = GetSkinItem("CheckboxChecked");

	APPEXPORT(CreateCheckbox);

	/*TRect r;
	RectAssign(&r, 50,50,150,70);
	PCheckbox p = CreateCheckbox(&Me, r, "Bujaka");
	InsertWidget(WIDGET(DeskTop), WIDGET(p));
	WidgetDraw(WIDGET(p), NULL);*/

	return true;
}

void Close (void)
{

}
