; E100PKT, packet driver for DOS
; Copyright (C) 2018, Seth Simon (sethsimon@sdf.org)
;
; This program is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program.  If not, see
; <https://www.gnu.org/licenses/>.

;=============================
;=======               =======
;       INIT_CPU_MEMORY
;=======               =======
;=============================
init_cpu_memory:
    mov     al, 0
    mov     cx, 16 * 8
    mov     di, handles     ; Warning: packet_spec_matches assumes
    rep     stosb           ; that handles are initialized to 0.

    push    es
    mov     ah, 0x49
    mov     es, word [0x2c]
    int     0x21            ; Free environment strings
    pop     es

    mov     cx, 8
    mov     si, .default_tcb
    mov     di, tcb
    rep     movsw
    ret

.default_tcb:
    dw 0        ; Status
    db 0x04     ; CMD=100, SF=0, NC=0
    db 0x80     ; EL=1
    dd -1       ; Link address = don't care
    dd -1       ; TCB Array address must be -1 in simplified mode
    dw 0x8000   ; 2 MSBs must be 10, the rest is the size
    db 0x0e     ; Transmit threshold = max possible
    db 0        ; TCB Number = don't care

;=============================
;=======               =======
;       INIT_PCI_MEMORY
;=======               =======
;=============================
init_pci_memory:
    mov     ax, cs
    xor     bx, bx
    call    addr_16_to_32
    mov     bx, 0x60      ; CUC=Load CU Base
    call    scb_command

    ; BH unchanged
    ; EAX unchanged (SCB General Pointer => RU Base)

    mov     bl, 0x06    ; RUC=Load RU Base
    jmp     scb_command

;===========================
;=======             =======
;       ADDR_16_TO_32
;=======             =======
;===========================
addr_16_to_32:
    ; AX:BX = 16-bit address
    ; Returns EAX = 32-bit address
    and     eax, 0xffff
    shl     eax, 4
    add     ax, bx
    adc     eax, 0
    ret

