; E100PKT, packet driver for DOS
; Copyright (C) 2018, Seth Simon (sethsimon@sdf.org)
;
; This program is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program.  If not, see
; <https://www.gnu.org/licenses/>.

ERROR_BAD_HANDLE        EQU 1
ERROR_NO_CLASS          EQU 2
ERROR_NO_TYPE           EQU 3
ERROR_NO_NUMBER         EQU 4
ERROR_BAD_TYPE          EQU 5
ERROR_NO_MULTICAST      EQU 6
ERROR_CANT_TERMINATE    EQU 7
ERROR_BAD_MODE          EQU 8
ERROR_NO_SPACE          EQU 9
ERROR_TYPE_INUSE        EQU 10
ERROR_BAD_COMMAND       EQU 11
ERROR_CANT_SEND         EQU 12
ERROR_CANT_SET          EQU 13
ERROR_BAD_ADDRESS       EQU 14
ERROR_CANT_RESET        EQU 15

;=========================
;=======           =======
;       SCB_COMMAND
;=======           =======
;=========================
scb_command:
    ; EAX = SCB General Pointer
    ; BX = command word
    push    dx
    push    cx

    mov     dx, word [cs:csr_io_bar]
    xchg    ax, cx
    inc     dx
    inc     dx  ; SCB Command Word
.wait:
    ; Wait until the previous command (if any) finished
    in      al, dx
    test    al, al
    jnz     .wait

    xchg    ax, cx
    inc     dx
    inc     dx      ; SCB General Pointer
    out     dx, eax

    dec     dx
    dec     dx      ; SCB Command Word
    xchg    ax, bx
    out     dx, ax
    xchg    ax, bx

    pop     cx
    pop     dx
    ret

;=============================
;=======               =======
;       TOGGLE_IRQ_MASK
;=======               =======
;=============================
toggle_irq_mask:
    push    ax
    push    dx

    mov     dx, word [cs:pic_port]
    in      al, dx
    xor     al, byte [cs:irq_mask]
    out     dx, al

    pop     dx
    pop     ax
    ret

